/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch6.views.searchtypes.pivot.series;

import io.searchbox.core.SearchResult;
import io.searchbox.core.search.aggregation.Aggregation;
import io.searchbox.core.search.aggregation.Bucket;
import io.searchbox.core.search.aggregation.MetricAggregation;
import io.searchbox.core.search.aggregation.RootAggregation;
import io.searchbox.core.search.aggregation.ValueCountAggregation;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.graylog.plugins.views.search.searchtypes.pivot.Pivot;
import org.graylog.plugins.views.search.searchtypes.pivot.PivotSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.series.Count;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.AggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.AggregationBuilders;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.valuecount.ValueCountAggregationBuilder;
import org.graylog.storage.elasticsearch6.views.ESGeneratedQueryContext;
import org.graylog.storage.elasticsearch6.views.searchtypes.pivot.ESPivot;
import org.graylog.storage.elasticsearch6.views.searchtypes.pivot.ESPivotSeriesSpecHandler;
import org.jooq.lambda.tuple.Tuple2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESCountHandler
extends ESPivotSeriesSpecHandler<Count, MetricAggregation> {
    private static final Logger LOG = LoggerFactory.getLogger(ESCountHandler.class);

    @Nonnull
    public Optional<AggregationBuilder> doCreateAggregation(String name, Pivot pivot, Count count, ESPivot searchTypeHandler, ESGeneratedQueryContext queryContext) {
        String field = count.field();
        if (field == null) {
            return Optional.empty();
        }
        ValueCountAggregationBuilder value = (ValueCountAggregationBuilder)AggregationBuilders.count(name).field(field);
        this.record(queryContext, pivot, (PivotSpec)count, name, ValueCountAggregation.class);
        return Optional.of(value);
    }

    @Override
    public Stream<ESPivotSeriesSpecHandler.Value> doHandleResult(Pivot pivot, Count count, SearchResult searchResult, MetricAggregation metricAggregation, ESPivot searchTypeHandler, ESGeneratedQueryContext esGeneratedQueryContext) {
        Number value = null;
        if (metricAggregation instanceof Bucket) {
            value = ((Bucket)metricAggregation).getCount();
        } else if (metricAggregation instanceof RootAggregation) {
            value = searchResult.getTotal();
        } else if (metricAggregation instanceof ValueCountAggregation) {
            value = ((ValueCountAggregation)metricAggregation).getValueCount();
        }
        if (value == null) {
            LOG.error("Unexpected aggregation type {}, returning 0 for the count. This is a bug.", (Object)metricAggregation);
            value = 0;
        }
        return Stream.of(ESPivotSeriesSpecHandler.Value.create(count.id(), "count", value));
    }

    @Override
    protected Aggregation extractAggregationFromResult(Pivot pivot, PivotSpec spec, MetricAggregation aggregations, ESGeneratedQueryContext queryContext) {
        Tuple2<String, Class<? extends Aggregation>> objects = this.aggTypes(queryContext, pivot).getTypes(spec);
        if (objects == null) {
            return aggregations;
        }
        Object subAggregation = aggregations.getAggregation((String)objects.v1, (Class)objects.v2);
        if (subAggregation == null) {
            return aggregations;
        }
        return subAggregation;
    }
}

