/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch6;

import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import io.searchbox.core.Search;
import io.searchbox.core.SearchResult;
import io.searchbox.core.search.sort.Sort;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.graylog.events.processor.EventProcessorException;
import org.graylog.events.search.MoreSearch;
import org.graylog.events.search.MoreSearchAdapter;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.BoolQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.QueryBuilders;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.builder.SearchSourceBuilder;
import org.graylog.storage.elasticsearch6.MultiSearch;
import org.graylog.storage.elasticsearch6.Scroll;
import org.graylog.storage.elasticsearch6.SortOrderMapper;
import org.graylog.storage.elasticsearch6.TimeRangeQueryFactory;
import org.graylog2.indexer.results.ResultMessage;
import org.graylog2.indexer.results.ScrollResult;
import org.graylog2.indexer.searches.Sorting;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoreSearchAdapterES6
implements MoreSearchAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(MoreSearchAdapterES6.class);
    private final MultiSearch multiSearch;
    private final Scroll scroll;
    private final Boolean allowLeadingWildcard;
    private final SortOrderMapper sortOrderMapper;

    @Inject
    public MoreSearchAdapterES6(@Named(value="allow_leading_wildcard_searches") Boolean allowLeadingWildcard, MultiSearch multiSearch, Scroll scroll, SortOrderMapper sortOrderMapper) {
        this.allowLeadingWildcard = allowLeadingWildcard;
        this.multiSearch = multiSearch;
        this.scroll = scroll;
        this.sortOrderMapper = sortOrderMapper;
    }

    public MoreSearch.Result eventSearch(String queryString, TimeRange timerange, Set<String> affectedIndices, Sorting sorting, int page, int perPage, Set<String> eventStreams, String filterString, Set<String> forbiddenSourceStreams) {
        MatchAllQueryBuilder query = queryString.isEmpty() || queryString.equals("*") ? QueryBuilders.matchAllQuery() : QueryBuilders.queryStringQuery(queryString).allowLeadingWildcard(this.allowLeadingWildcard);
        BoolQueryBuilder filter = QueryBuilders.boolQuery().filter(query).filter(QueryBuilders.termsQuery("streams", eventStreams)).filter(Objects.requireNonNull(TimeRangeQueryFactory.create(timerange)));
        if (!Strings.isNullOrEmpty((String)filterString)) {
            filter.filter(QueryBuilders.queryStringQuery(filterString));
        }
        if (!forbiddenSourceStreams.isEmpty()) {
            filter.filter(QueryBuilders.boolQuery().mustNot(QueryBuilders.termsQuery("source_streams", forbiddenSourceStreams)));
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query(filter).from((page - 1) * perPage).size(perPage).sort(sorting.getField(), this.sortOrderMapper.fromSorting(sorting));
        Search.Builder searchBuilder = (Search.Builder)((Search.Builder)((Search.Builder)((Search.Builder)new Search.Builder(searchSourceBuilder.toString()).addType("message")).addIndex(affectedIndices.isEmpty() ? Collections.singleton("") : affectedIndices)).allowNoIndices(false)).ignoreUnavailable(false);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Query:\n{}", (Object)searchSourceBuilder.toString(new ToXContent.MapParams(Collections.singletonMap("pretty", "true"))));
            LOG.debug("Execute search: {}", (Object)searchBuilder.build().toString());
        }
        SearchResult searchResult = this.multiSearch.wrap(searchBuilder.build(), () -> "Unable to perform search query");
        List hits = searchResult.getHits(Map.class, false).stream().map(hit -> ResultMessage.parseFromSource((String)hit.id, (String)hit.index, (Map)((Map)hit.source), hit.highlight)).collect(Collectors.toList());
        return MoreSearch.Result.builder().results(hits).resultsCount(searchResult.getTotal().longValue()).duration(this.multiSearch.tookMsFromSearchResult(searchResult)).usedIndexNames(affectedIndices).executedQuery(searchSourceBuilder.toString()).build();
    }

    public void scrollEvents(String queryString, TimeRange timeRange, Set<String> affectedIndices, Set<String> streams, String scrollTime, int batchSize, MoreSearchAdapter.ScrollEventsCallback resultCallback) throws EventProcessorException {
        MatchAllQueryBuilder query = queryString.trim().isEmpty() || queryString.trim().equals("*") ? QueryBuilders.matchAllQuery() : QueryBuilders.queryStringQuery(queryString).allowLeadingWildcard(this.allowLeadingWildcard);
        BoolQueryBuilder filter = QueryBuilders.boolQuery().filter(query).filter(Objects.requireNonNull(TimeRangeQueryFactory.create(timeRange)));
        if (!streams.isEmpty()) {
            filter.filter(QueryBuilders.termsQuery("streams", streams));
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query(filter).size(batchSize);
        Search.Builder searchBuilder = (Search.Builder)((Search.Builder)((Search.Builder)((Search.Builder)((Search.Builder)new Search.Builder(searchSourceBuilder.toString()).addType("message")).addIndex(affectedIndices.isEmpty() ? Collections.singleton("") : affectedIndices)).addSort(new Sort("timestamp", Sort.Sorting.ASC)).allowNoIndices(false)).ignoreUnavailable(false)).setParameter("scroll", scrollTime);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Query:\n{}", (Object)searchSourceBuilder.toString(new ToXContent.MapParams(Collections.singletonMap("pretty", "true"))));
            LOG.debug("Execute search: {}", (Object)searchBuilder.build().toString());
        }
        ScrollResult scrollResult = this.scroll.scroll(searchBuilder.build(), () -> "Unable to scroll indices.", searchSourceBuilder.toString(), scrollTime, Collections.emptyList());
        AtomicBoolean continueScrolling = new AtomicBoolean(true);
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            ScrollResult.ScrollChunk scrollChunk = scrollResult.nextChunk();
            while (continueScrolling.get() && scrollChunk != null) {
                List messages = scrollChunk.getMessages();
                LOG.debug("Passing <{}> messages to callback", (Object)messages.size());
                resultCallback.accept(Collections.unmodifiableList(messages), continueScrolling);
                if (!continueScrolling.get()) {
                    break;
                }
                scrollChunk = scrollResult.nextChunk();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            try {
                scrollResult.cancel();
            }
            catch (Exception exception) {}
            LOG.debug("Scrolling done - took {} ms", (Object)stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
        }
    }
}

