/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.snapshots;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexCommit;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.SetOnce;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ExceptionsHelper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.ClusterChangedEvent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.ClusterState;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.ClusterStateApplier;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.SnapshotsInProgress;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.service.ClusterService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.collect.ImmutableOpenMap;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.Inject;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.unit.ByteSizeValue;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.unit.TimeValue;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.engine.SnapshotFailedEngineException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.shard.IndexEventListener;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.shard.IndexShard;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.shard.IndexShardState;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.shard.ShardId;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.snapshots.IndexShardSnapshotFailedException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.snapshots.IndexShardSnapshotStatus;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.indices.IndicesService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.repositories.IndexId;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.repositories.Repository;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.snapshots.Snapshot;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.snapshots.SnapshotsService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.threadpool.ThreadPool;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportChannel;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportRequestHandler;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportService;

public class SnapshotShardsService
extends AbstractLifecycleComponent
implements ClusterStateApplier,
IndexEventListener {
    public static final String UPDATE_SNAPSHOT_ACTION_NAME = "internal:cluster/snapshot/update_snapshot";
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final SnapshotsService snapshotsService;
    private final TransportService transportService;
    private final ThreadPool threadPool;
    private final Lock shutdownLock = new ReentrantLock();
    private final Condition shutdownCondition = this.shutdownLock.newCondition();
    private volatile Map<Snapshot, SnapshotShards> shardSnapshots = Collections.emptyMap();
    private final BlockingQueue<UpdateIndexShardSnapshotStatusRequest> updatedSnapshotStateQueue = ConcurrentCollections.newBlockingQueue();

    @Inject
    public SnapshotShardsService(Settings settings, ClusterService clusterService, SnapshotsService snapshotsService, ThreadPool threadPool, TransportService transportService, IndicesService indicesService) {
        super(settings);
        this.indicesService = indicesService;
        this.snapshotsService = snapshotsService;
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        if (DiscoveryNode.isDataNode(settings)) {
            clusterService.addLowPriorityApplier(this);
        }
        if (DiscoveryNode.isMasterNode(settings)) {
            transportService.registerRequestHandler(UPDATE_SNAPSHOT_ACTION_NAME, UpdateIndexShardSnapshotStatusRequest::new, "same", new UpdateSnapshotStateRequestHandler());
        }
    }

    @Override
    protected void doStart() {
    }

    @Override
    protected void doStop() {
        this.shutdownLock.lock();
        try {
            while (!this.shardSnapshots.isEmpty() && this.shutdownCondition.await(5L, TimeUnit.SECONDS)) {
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.shutdownLock.unlock();
        }
    }

    @Override
    protected void doClose() {
        this.clusterService.removeApplier(this);
    }

    @Override
    public void applyClusterState(ClusterChangedEvent event) {
        try {
            String masterNodeId;
            SnapshotsInProgress prev = (SnapshotsInProgress)event.previousState().custom("snapshots");
            SnapshotsInProgress curr = (SnapshotsInProgress)event.state().custom("snapshots");
            if (prev == null && curr != null || prev != null && !prev.equals(curr)) {
                this.processIndexShardSnapshots(event);
            }
            if ((masterNodeId = event.state().nodes().getMasterNodeId()) != null && !masterNodeId.equals(event.previousState().nodes().getMasterNodeId())) {
                this.syncShardStatsOnNewMaster(event);
            }
        }
        catch (Exception e) {
            this.logger.warn("Failed to update snapshot state ", (Throwable)e);
        }
    }

    @Override
    public void beforeIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard, Settings indexSettings) {
        Map<Snapshot, SnapshotShards> snapshotShardsMap = this.shardSnapshots;
        for (Map.Entry<Snapshot, SnapshotShards> snapshotShards : snapshotShardsMap.entrySet()) {
            Map shards = snapshotShards.getValue().shards;
            if (!shards.containsKey(shardId)) continue;
            this.logger.debug("[{}] shard closing, abort snapshotting for snapshot [{}]", (Object)shardId, (Object)snapshotShards.getKey().getSnapshotId());
            ((IndexShardSnapshotStatus)shards.get(shardId)).abort();
        }
    }

    public Map<ShardId, IndexShardSnapshotStatus> currentSnapshotShards(Snapshot snapshot) {
        SnapshotShards snapshotShards = this.shardSnapshots.get(snapshot);
        if (snapshotShards == null) {
            return null;
        }
        return snapshotShards.shards;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processIndexShardSnapshots(ClusterChangedEvent event) {
        SnapshotsInProgress snapshotsInProgress = (SnapshotsInProgress)event.state().custom("snapshots");
        HashMap<Snapshot, SnapshotShards> survivors = new HashMap<Snapshot, SnapshotShards>();
        for (Map.Entry<Snapshot, SnapshotShards> entry : this.shardSnapshots.entrySet()) {
            Snapshot snapshot = entry.getKey();
            if (snapshotsInProgress != null && snapshotsInProgress.snapshot(snapshot) != null) {
                survivors.put(entry.getKey(), entry.getValue());
                continue;
            }
            for (Object snapshotStatus : entry.getValue().shards.values()) {
                if (((IndexShardSnapshotStatus)snapshotStatus).stage() != IndexShardSnapshotStatus.Stage.INIT && ((IndexShardSnapshotStatus)snapshotStatus).stage() != IndexShardSnapshotStatus.Stage.STARTED) continue;
                ((IndexShardSnapshotStatus)snapshotStatus).abort();
            }
        }
        HashMap newSnapshots = new HashMap();
        final String localNodeId = event.state().nodes().getLocalNodeId();
        final DiscoveryNode masterNode = event.state().nodes().getMasterNode();
        HashMap snapshotIndices = new HashMap();
        if (snapshotsInProgress != null) {
            for (SnapshotsInProgress.Entry entry : snapshotsInProgress.entries()) {
                SnapshotShards snapshotShards;
                snapshotIndices.put(entry.snapshot(), entry.indices().stream().collect(Collectors.toMap(IndexId::getName, Function.identity())));
                if (entry.state() == SnapshotsInProgress.State.STARTED) {
                    HashMap startedShards = new HashMap();
                    SnapshotShards snapshotShards2 = this.shardSnapshots.get(entry.snapshot());
                    for (ObjectObjectCursor<ShardId, SnapshotsInProgress.ShardSnapshotStatus> objectObjectCursor : entry.shards()) {
                        if (!localNodeId.equals(((SnapshotsInProgress.ShardSnapshotStatus)objectObjectCursor.value).nodeId()) || ((SnapshotsInProgress.ShardSnapshotStatus)objectObjectCursor.value).state() != SnapshotsInProgress.State.INIT || snapshotShards2 != null && snapshotShards2.shards.containsKey(objectObjectCursor.key)) continue;
                        this.logger.trace("[{}] - Adding shard to the queue", objectObjectCursor.key);
                        startedShards.put(objectObjectCursor.key, new IndexShardSnapshotStatus());
                    }
                    if (startedShards.isEmpty()) continue;
                    newSnapshots.put(entry.snapshot(), startedShards);
                    if (snapshotShards2 != null) {
                        HashMap hashMap = new HashMap();
                        hashMap.putAll(snapshotShards2.shards);
                        hashMap.putAll(startedShards);
                        survivors.put(entry.snapshot(), new SnapshotShards(Collections.unmodifiableMap(hashMap)));
                        continue;
                    }
                    survivors.put(entry.snapshot(), new SnapshotShards(Collections.unmodifiableMap(startedShards)));
                    continue;
                }
                if (entry.state() != SnapshotsInProgress.State.ABORTED || (snapshotShards = this.shardSnapshots.get(entry.snapshot())) == null) continue;
                block13: for (ObjectObjectCursor objectObjectCursor : entry.shards()) {
                    IndexShardSnapshotStatus indexShardSnapshotStatus = (IndexShardSnapshotStatus)snapshotShards.shards.get(objectObjectCursor.key);
                    if (indexShardSnapshotStatus == null) continue;
                    switch (indexShardSnapshotStatus.stage()) {
                        case INIT: 
                        case STARTED: {
                            indexShardSnapshotStatus.abort();
                            continue block13;
                        }
                        case FINALIZE: {
                            this.logger.debug("[{}] trying to cancel snapshot on shard [{}] that is finalizing, letting it finish", (Object)entry.snapshot(), objectObjectCursor.key);
                            continue block13;
                        }
                        case DONE: {
                            this.logger.debug("[{}] trying to cancel snapshot on the shard [{}] that is already done, updating status on the master", (Object)entry.snapshot(), objectObjectCursor.key);
                            this.notifySuccessfulSnapshotShard(entry.snapshot(), (ShardId)objectObjectCursor.key, localNodeId, masterNode);
                            continue block13;
                        }
                        case FAILURE: {
                            this.logger.debug("[{}] trying to cancel snapshot on the shard [{}] that has already failed, updating status on the master", (Object)entry.snapshot(), objectObjectCursor.key);
                            this.notifyFailedSnapshotShard(entry.snapshot(), (ShardId)objectObjectCursor.key, localNodeId, indexShardSnapshotStatus.failure(), masterNode);
                            continue block13;
                        }
                    }
                    throw new IllegalStateException("Unknown snapshot shard stage " + (Object)((Object)indexShardSnapshotStatus.stage()));
                }
            }
        }
        this.shutdownLock.lock();
        try {
            this.shardSnapshots = Collections.unmodifiableMap(survivors);
            if (this.shardSnapshots.isEmpty()) {
                this.shutdownCondition.signalAll();
            }
        }
        finally {
            this.shutdownLock.unlock();
        }
        if (!newSnapshots.isEmpty()) {
            ExecutorService executor = this.threadPool.executor("snapshot");
            for (Map.Entry entry : newSnapshots.entrySet()) {
                final Snapshot snapshot = (Snapshot)entry.getKey();
                Map map = (Map)snapshotIndices.get(snapshot);
                assert (map != null);
                for (final Map.Entry shardEntry : ((Map)entry.getValue()).entrySet()) {
                    final ShardId shardId = (ShardId)shardEntry.getKey();
                    final IndexShard indexShard = this.indicesService.indexServiceSafe(shardId.getIndex()).getShardOrNull(shardId.id());
                    final IndexId indexId = (IndexId)map.get(shardId.getIndexName());
                    assert (indexId != null);
                    executor.execute(new AbstractRunnable(){
                        final SetOnce<Exception> failure = new SetOnce();

                        @Override
                        public void doRun() {
                            SnapshotShardsService.this.snapshot(indexShard, snapshot, indexId, (IndexShardSnapshotStatus)shardEntry.getValue());
                        }

                        @Override
                        public void onFailure(Exception e) {
                            SnapshotShardsService.this.logger.warn(() -> new ParameterizedMessage("[{}][{}] failed to snapshot shard", (Object)shardId, (Object)snapshot), (Throwable)e);
                            this.failure.set(e);
                        }

                        @Override
                        public void onRejection(Exception e) {
                            this.failure.set(e);
                        }

                        @Override
                        public void onAfter() {
                            Exception exception = this.failure.get();
                            if (exception != null) {
                                String failure = ExceptionsHelper.detailedMessage(exception);
                                SnapshotShardsService.this.notifyFailedSnapshotShard(snapshot, shardId, localNodeId, failure, masterNode);
                            } else {
                                SnapshotShardsService.this.notifySuccessfulSnapshotShard(snapshot, shardId, localNodeId, masterNode);
                            }
                        }
                    });
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void snapshot(IndexShard indexShard, Snapshot snapshot, IndexId indexId, IndexShardSnapshotStatus snapshotStatus) {
        ShardId shardId = indexShard.shardId();
        if (!indexShard.routingEntry().primary()) {
            throw new IndexShardSnapshotFailedException(shardId, "snapshot should be performed only on primary");
        }
        if (indexShard.routingEntry().relocating()) {
            throw new IndexShardSnapshotFailedException(shardId, "cannot snapshot while relocating");
        }
        IndexShardState indexShardState = indexShard.state();
        if (indexShardState == IndexShardState.CREATED || indexShardState == IndexShardState.RECOVERING) {
            throw new IndexShardSnapshotFailedException(shardId, "shard didn't fully recover yet");
        }
        Repository repository = this.snapshotsService.getRepositoriesService().repository(snapshot.getRepository());
        try {
            IndexCommit snapshotIndexCommit = indexShard.acquireIndexCommit(true);
            try {
                repository.snapshotShard(indexShard, snapshot.getSnapshotId(), indexId, snapshotIndexCommit, snapshotStatus);
                if (this.logger.isDebugEnabled()) {
                    StringBuilder details = new StringBuilder();
                    details.append("    index    : version [").append(snapshotStatus.indexVersion());
                    details.append("], number_of_files [").append(snapshotStatus.numberOfFiles());
                    details.append("] with total_size [").append(new ByteSizeValue(snapshotStatus.totalSize())).append("]\n");
                    this.logger.debug("snapshot ({}) completed to {}, took [{}]\n{}", (Object)snapshot, (Object)repository, (Object)TimeValue.timeValueMillis(snapshotStatus.time()), (Object)details);
                }
            }
            finally {
                indexShard.releaseIndexCommit(snapshotIndexCommit);
            }
        }
        catch (SnapshotFailedEngineException | IndexShardSnapshotFailedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IndexShardSnapshotFailedException(shardId, "Failed to snapshot", e);
        }
    }

    private void syncShardStatsOnNewMaster(ClusterChangedEvent event) {
        SnapshotsInProgress snapshotsInProgress = (SnapshotsInProgress)event.state().custom("snapshots");
        if (snapshotsInProgress == null) {
            return;
        }
        String localNodeId = event.state().nodes().getLocalNodeId();
        DiscoveryNode masterNode = event.state().nodes().getMasterNode();
        for (SnapshotsInProgress.Entry snapshot : snapshotsInProgress.entries()) {
            Map<ShardId, IndexShardSnapshotStatus> localShards;
            if (snapshot.state() != SnapshotsInProgress.State.STARTED && snapshot.state() != SnapshotsInProgress.State.ABORTED || (localShards = this.currentSnapshotShards(snapshot.snapshot())) == null) continue;
            ImmutableOpenMap<ShardId, SnapshotsInProgress.ShardSnapshotStatus> masterShards = snapshot.shards();
            for (Map.Entry<ShardId, IndexShardSnapshotStatus> localShard : localShards.entrySet()) {
                ShardId shardId = localShard.getKey();
                IndexShardSnapshotStatus localShardStatus = localShard.getValue();
                SnapshotsInProgress.ShardSnapshotStatus masterShard = masterShards.get(shardId);
                if (masterShard == null || masterShard.state().completed()) continue;
                if (localShardStatus.stage() == IndexShardSnapshotStatus.Stage.DONE) {
                    this.logger.debug("[{}] new master thinks the shard [{}] is not completed but the shard is done locally, updating status on the master", (Object)snapshot.snapshot(), (Object)shardId);
                    this.notifySuccessfulSnapshotShard(snapshot.snapshot(), shardId, localNodeId, masterNode);
                    continue;
                }
                if (localShard.getValue().stage() != IndexShardSnapshotStatus.Stage.FAILURE) continue;
                this.logger.debug("[{}] new master thinks the shard [{}] is not completed but the shard failed locally, updating status on master", (Object)snapshot.snapshot(), (Object)shardId);
                String failure = localShardStatus.failure();
                this.notifyFailedSnapshotShard(snapshot.snapshot(), shardId, localNodeId, failure, masterNode);
            }
        }
    }

    void notifySuccessfulSnapshotShard(Snapshot snapshot, ShardId shardId, String localNodeId, DiscoveryNode masterNode) {
        this.sendSnapshotShardUpdate(snapshot, shardId, new SnapshotsInProgress.ShardSnapshotStatus(localNodeId, SnapshotsInProgress.State.SUCCESS), masterNode);
    }

    void notifyFailedSnapshotShard(Snapshot snapshot, ShardId shardId, String localNodeId, String failure, DiscoveryNode masterNode) {
        this.sendSnapshotShardUpdate(snapshot, shardId, new SnapshotsInProgress.ShardSnapshotStatus(localNodeId, SnapshotsInProgress.State.FAILED, failure), masterNode);
    }

    void sendSnapshotShardUpdate(Snapshot snapshot, ShardId shardId, SnapshotsInProgress.ShardSnapshotStatus status, DiscoveryNode masterNode) {
        try {
            UpdateIndexShardSnapshotStatusRequest request = new UpdateIndexShardSnapshotStatusRequest(snapshot, shardId, status);
            this.transportService.sendRequest(masterNode, UPDATE_SNAPSHOT_ACTION_NAME, request, EmptyTransportResponseHandler.INSTANCE_SAME);
        }
        catch (Exception e) {
            this.logger.warn(() -> new ParameterizedMessage("[{}] [{}] failed to update snapshot state", (Object)snapshot, (Object)status), (Throwable)e);
        }
    }

    private void innerUpdateSnapshotState(final UpdateIndexShardSnapshotStatusRequest request) {
        this.logger.trace("received updated snapshot restore state [{}]", (Object)request);
        this.updatedSnapshotStateQueue.add(request);
        this.clusterService.submitStateUpdateTask("update snapshot state", new ClusterStateUpdateTask(){
            private final List<UpdateIndexShardSnapshotStatusRequest> drainedRequests = new ArrayList<UpdateIndexShardSnapshotStatusRequest>();

            @Override
            public ClusterState execute(ClusterState currentState) {
                if (request.isProcessed()) {
                    return currentState;
                }
                SnapshotShardsService.this.updatedSnapshotStateQueue.drainTo(this.drainedRequests);
                int batchSize = this.drainedRequests.size();
                if (batchSize == 0) {
                    return currentState;
                }
                SnapshotsInProgress snapshots = (SnapshotsInProgress)currentState.custom("snapshots");
                if (snapshots != null) {
                    int changedCount = 0;
                    ArrayList<SnapshotsInProgress.Entry> entries = new ArrayList<SnapshotsInProgress.Entry>();
                    for (SnapshotsInProgress.Entry entry : snapshots.entries()) {
                        ImmutableOpenMap.Builder<ShardId, SnapshotsInProgress.ShardSnapshotStatus> shards = ImmutableOpenMap.builder();
                        boolean updated = false;
                        for (int i = 0; i < batchSize; ++i) {
                            UpdateIndexShardSnapshotStatusRequest updateSnapshotState = this.drainedRequests.get(i);
                            updateSnapshotState.markAsProcessed();
                            if (!entry.snapshot().equals(updateSnapshotState.snapshot())) continue;
                            SnapshotShardsService.this.logger.trace("[{}] Updating shard [{}] with status [{}]", (Object)updateSnapshotState.snapshot(), (Object)updateSnapshotState.shardId(), (Object)updateSnapshotState.status().state());
                            if (!updated) {
                                shards.putAll(entry.shards());
                                updated = true;
                            }
                            shards.put(updateSnapshotState.shardId(), updateSnapshotState.status());
                            ++changedCount;
                        }
                        if (updated) {
                            if (!SnapshotsInProgress.completed(shards.values())) {
                                entries.add(new SnapshotsInProgress.Entry(entry, shards.build()));
                                continue;
                            }
                            SnapshotsInProgress.Entry updatedEntry = new SnapshotsInProgress.Entry(entry, SnapshotsInProgress.State.SUCCESS, shards.build());
                            entries.add(updatedEntry);
                            SnapshotShardsService.this.snapshotsService.endSnapshot(updatedEntry);
                            SnapshotShardsService.this.logger.info("snapshot [{}] is done", (Object)updatedEntry.snapshot());
                            continue;
                        }
                        entries.add(entry);
                    }
                    if (changedCount > 0) {
                        SnapshotShardsService.this.logger.trace("changed cluster state triggered by {} snapshot state updates", (Object)changedCount);
                        SnapshotsInProgress updatedSnapshots = new SnapshotsInProgress(entries.toArray(new SnapshotsInProgress.Entry[entries.size()]));
                        return ClusterState.builder(currentState).putCustom("snapshots", updatedSnapshots).build();
                    }
                }
                return currentState;
            }

            @Override
            public void onFailure(String source, Exception e) {
                for (UpdateIndexShardSnapshotStatusRequest request2 : this.drainedRequests) {
                    SnapshotShardsService.this.logger.warn(() -> new ParameterizedMessage("[{}][{}] failed to update snapshot status to [{}]", new Object[]{request2.snapshot(), request2.shardId(), request2.status()}), (Throwable)e);
                }
            }
        });
    }

    class UpdateSnapshotStateRequestHandler
    implements TransportRequestHandler<UpdateIndexShardSnapshotStatusRequest> {
        UpdateSnapshotStateRequestHandler() {
        }

        @Override
        public void messageReceived(UpdateIndexShardSnapshotStatusRequest request, TransportChannel channel) throws Exception {
            SnapshotShardsService.this.innerUpdateSnapshotState(request);
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }
    }

    public static class UpdateIndexShardSnapshotStatusRequest
    extends TransportRequest {
        private Snapshot snapshot;
        private ShardId shardId;
        private SnapshotsInProgress.ShardSnapshotStatus status;
        private volatile boolean processed;

        public UpdateIndexShardSnapshotStatusRequest() {
        }

        public UpdateIndexShardSnapshotStatusRequest(Snapshot snapshot, ShardId shardId, SnapshotsInProgress.ShardSnapshotStatus status) {
            this.snapshot = snapshot;
            this.shardId = shardId;
            this.status = status;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.snapshot = new Snapshot(in);
            this.shardId = ShardId.readShardId(in);
            this.status = new SnapshotsInProgress.ShardSnapshotStatus(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.snapshot.writeTo(out);
            this.shardId.writeTo(out);
            this.status.writeTo(out);
        }

        public Snapshot snapshot() {
            return this.snapshot;
        }

        public ShardId shardId() {
            return this.shardId;
        }

        public SnapshotsInProgress.ShardSnapshotStatus status() {
            return this.status;
        }

        public String toString() {
            return this.snapshot + ", shardId [" + this.shardId + "], status [" + (Object)((Object)this.status.state()) + "]";
        }

        public void markAsProcessed() {
            this.processed = true;
        }

        public boolean isProcessed() {
            return this.processed;
        }
    }

    private static class SnapshotShards {
        private final Map<ShardId, IndexShardSnapshotStatus> shards;

        private SnapshotShards(Map<ShardId, IndexShardSnapshotStatus> shards) {
            this.shards = shards;
        }
    }
}

