/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.search.suggest.completion;

import java.io.IOException;
import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.ObjectLongHashMap;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.Fields;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexReader;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReader;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.Terms;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.suggest.document.CompletionTerms;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ElasticsearchException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.FieldMemoryStats;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.regex.Regex;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.suggest.completion.CompletionStats;

public class CompletionFieldStats {
    public static CompletionStats completionStats(IndexReader indexReader, String ... fieldNamePatterns) {
        long sizeInBytes = 0L;
        ObjectLongHashMap<String> completionFields = null;
        if (fieldNamePatterns != null && fieldNamePatterns.length > 0) {
            completionFields = new ObjectLongHashMap<String>(fieldNamePatterns.length);
        }
        for (LeafReaderContext atomicReaderContext : indexReader.leaves()) {
            LeafReader atomicReader = atomicReaderContext.reader();
            try {
                Fields fields = atomicReader.fields();
                for (String fieldName : fields) {
                    Terms terms = fields.terms(fieldName);
                    if (!(terms instanceof CompletionTerms)) continue;
                    long fstSize = ((CompletionTerms)terms).suggester().ramBytesUsed();
                    if (fieldNamePatterns != null && fieldNamePatterns.length > 0 && Regex.simpleMatch(fieldNamePatterns, fieldName)) {
                        completionFields.addTo(fieldName, fstSize);
                    }
                    sizeInBytes += fstSize;
                }
            }
            catch (IOException ioe) {
                throw new ElasticsearchException(ioe);
            }
        }
        return new CompletionStats(sizeInBytes, completionFields == null ? null : new FieldMemoryStats(completionFields));
    }
}

