/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.search.lookup;

import java.io.IOException;
import java.util.Iterator;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.BytesRefBuilder;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.IntsRefBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.lookup.IndexFieldTerm;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.lookup.PositionIterator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.lookup.TermPosition;

public class CachedPositionIterator
extends PositionIterator {
    final BytesRefBuilder payloads = new BytesRefBuilder();
    final IntsRefBuilder payloadsLengths = new IntsRefBuilder();
    final IntsRefBuilder payloadsStarts = new IntsRefBuilder();
    final IntsRefBuilder positions = new IntsRefBuilder();
    final IntsRefBuilder startOffsets = new IntsRefBuilder();
    final IntsRefBuilder endOffsets = new IntsRefBuilder();
    final BytesRef payload = new BytesRef();

    public CachedPositionIterator(IndexFieldTerm indexFieldTerm) {
        super(indexFieldTerm);
    }

    @Override
    public Iterator<TermPosition> reset() {
        return new Iterator<TermPosition>(){
            private int pos = 0;
            private final TermPosition termPosition = new TermPosition();

            @Override
            public boolean hasNext() {
                return this.pos < CachedPositionIterator.this.freq;
            }

            @Override
            public TermPosition next() {
                this.termPosition.position = CachedPositionIterator.this.positions.intAt(this.pos);
                this.termPosition.startOffset = CachedPositionIterator.this.startOffsets.intAt(this.pos);
                this.termPosition.endOffset = CachedPositionIterator.this.endOffsets.intAt(this.pos);
                this.termPosition.payload = CachedPositionIterator.this.payload;
                CachedPositionIterator.this.payload.bytes = CachedPositionIterator.this.payloads.bytes();
                CachedPositionIterator.this.payload.offset = CachedPositionIterator.this.payloadsStarts.intAt(this.pos);
                CachedPositionIterator.this.payload.length = CachedPositionIterator.this.payloadsLengths.intAt(this.pos);
                ++this.pos;
                return this.termPosition;
            }

            @Override
            public void remove() {
            }
        };
    }

    private void record() throws IOException {
        for (int i = 0; i < this.freq; ++i) {
            TermPosition termPosition = super.next();
            this.positions.setIntAt(i, termPosition.position);
            this.addPayload(i, termPosition.payload);
            this.startOffsets.setIntAt(i, termPosition.startOffset);
            this.endOffsets.setIntAt(i, termPosition.endOffset);
        }
    }

    private void ensureSize(int freq) {
        if (freq == 0) {
            return;
        }
        this.startOffsets.grow(freq);
        this.endOffsets.grow(freq);
        this.positions.grow(freq);
        this.payloadsLengths.grow(freq);
        this.payloadsStarts.grow(freq);
        this.payloads.grow(freq * 8);
    }

    private void addPayload(int i, BytesRef currPayload) {
        if (currPayload != null) {
            this.payloadsLengths.setIntAt(i, currPayload.length);
            this.payloadsStarts.setIntAt(i, i == 0 ? 0 : this.payloadsStarts.intAt(i - 1) + this.payloadsLengths.intAt(i - 1));
            this.payloads.grow(this.payloadsStarts.intAt(i) + currPayload.length);
            System.arraycopy(currPayload.bytes, currPayload.offset, this.payloads.bytes(), this.payloadsStarts.intAt(i), currPayload.length);
        } else {
            this.payloadsLengths.setIntAt(i, 0);
            this.payloadsStarts.setIntAt(i, i == 0 ? 0 : this.payloadsStarts.intAt(i - 1) + this.payloadsLengths.intAt(i - 1));
        }
    }

    @Override
    public void nextDoc() throws IOException {
        super.nextDoc();
        this.ensureSize(this.freq);
        this.record();
    }

    @Override
    public TermPosition next() {
        throw new UnsupportedOperationException();
    }
}

