/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.subphase;

import java.io.IOException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ElasticsearchException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.FetchSubPhase;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.internal.SearchContext;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.lookup.SourceLookup;

public final class FetchSourceSubPhase
implements FetchSubPhase {
    @Override
    public void hitExecute(SearchContext context, FetchSubPhase.HitContext hitContext) {
        if (!context.sourceRequested()) {
            return;
        }
        SourceLookup source = context.lookup().source();
        FetchSourceContext fetchSourceContext = context.fetchSourceContext();
        assert (fetchSourceContext.fetchSource());
        if (fetchSourceContext.includes().length == 0 && fetchSourceContext.excludes().length == 0) {
            hitContext.hit().sourceRef(source.internalSourceRef());
            return;
        }
        if (source.internalSourceRef() == null) {
            throw new IllegalArgumentException("unable to fetch fields from _source field: _source is disabled in the mappings for index [" + context.indexShard().shardId().getIndexName() + "]");
        }
        Object value = source.filter(fetchSourceContext);
        try {
            int initialCapacity = Math.min(1024, source.internalSourceRef().length());
            BytesStreamOutput streamOutput = new BytesStreamOutput(initialCapacity);
            XContentBuilder builder = new XContentBuilder(source.sourceContentType().xContent(), streamOutput);
            builder.value(value);
            hitContext.hit().sourceRef(builder.bytes());
        }
        catch (IOException e) {
            throw new ElasticsearchException("Error filtering source", (Throwable)e, new Object[0]);
        }
    }
}

