/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.search;

import java.io.IOException;
import java.util.Objects;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.Writeable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.unit.TimeValue;

public final class Scroll
implements Writeable {
    private final TimeValue keepAlive;

    public Scroll(StreamInput in) throws IOException {
        this.keepAlive = new TimeValue(in);
    }

    public Scroll(TimeValue keepAlive) {
        this.keepAlive = Objects.requireNonNull(keepAlive, "keepAlive must not be null");
    }

    public TimeValue keepAlive() {
        return this.keepAlive;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.keepAlive.writeTo(out);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Scroll scroll = (Scroll)o;
        return Objects.equals(this.keepAlive, scroll.keepAlive);
    }

    public int hashCode() {
        return Objects.hash(this.keepAlive);
    }

    public String toString() {
        return "Scroll{keepAlive=" + this.keepAlive + '}';
    }
}

