/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index.store;

import java.io.IOException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.Streamable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.unit.ByteSizeValue;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.unit.TimeValue;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentBuilder;

public class StoreStats
implements Streamable,
ToXContent {
    private long sizeInBytes;
    private long throttleTimeInNanos;

    public StoreStats() {
    }

    public StoreStats(long sizeInBytes, long throttleTimeInNanos) {
        this.sizeInBytes = sizeInBytes;
        this.throttleTimeInNanos = throttleTimeInNanos;
    }

    public void add(StoreStats stats) {
        if (stats == null) {
            return;
        }
        this.sizeInBytes += stats.sizeInBytes;
        this.throttleTimeInNanos += stats.throttleTimeInNanos;
    }

    public long sizeInBytes() {
        return this.sizeInBytes;
    }

    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public ByteSizeValue size() {
        return new ByteSizeValue(this.sizeInBytes);
    }

    public ByteSizeValue getSize() {
        return this.size();
    }

    public TimeValue throttleTime() {
        return TimeValue.timeValueNanos(this.throttleTimeInNanos);
    }

    public TimeValue getThrottleTime() {
        return this.throttleTime();
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.sizeInBytes = in.readVLong();
        this.throttleTimeInNanos = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.sizeInBytes);
        out.writeVLong(this.throttleTimeInNanos);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("store");
        builder.byteSizeField("size_in_bytes", "size", this.sizeInBytes);
        builder.timeValueField("throttle_time_in_millis", "throttle_time", this.throttleTime());
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final String STORE = "store";
        static final String SIZE = "size";
        static final String SIZE_IN_BYTES = "size_in_bytes";
        static final String THROTTLE_TIME = "throttle_time";
        static final String THROTTLE_TIME_IN_MILLIS = "throttle_time_in_millis";

        Fields() {
        }
    }
}

