/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index.reindex;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.util.concurrent.AtomicArray;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.reindex.BulkByScrollTask;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.tasks.TaskId;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.tasks.TaskInfo;

public class ParentBulkByScrollTask
extends BulkByScrollTask {
    private final AtomicArray<Result> results;
    private final AtomicInteger counter;

    public ParentBulkByScrollTask(long id, String type, String action, String description, TaskId parentTaskId, int slices) {
        super(id, type, action, description, parentTaskId);
        this.results = new AtomicArray(slices);
        this.counter = new AtomicInteger(slices);
    }

    @Override
    public void rethrottle(float newRequestsPerSecond) {
    }

    @Override
    public BulkByScrollTask.Status getStatus() {
        List<BulkByScrollTask.StatusOrException> statuses = Arrays.asList(new BulkByScrollTask.StatusOrException[this.results.length()]);
        this.addResultsToList(statuses);
        return new BulkByScrollTask.Status(Collections.unmodifiableList(statuses), this.getReasonCancelled());
    }

    @Override
    public int runningSliceSubTasks() {
        return this.counter.get();
    }

    @Override
    public TaskInfo getInfoGivenSliceInfo(String localNodeId, List<TaskInfo> sliceInfo) {
        List<BulkByScrollTask.StatusOrException> sliceStatuses = Arrays.asList(new BulkByScrollTask.StatusOrException[this.results.length()]);
        for (TaskInfo t : sliceInfo) {
            BulkByScrollTask.Status status = (BulkByScrollTask.Status)t.getStatus();
            sliceStatuses.set(status.getSliceId(), new BulkByScrollTask.StatusOrException(status));
        }
        this.addResultsToList(sliceStatuses);
        BulkByScrollTask.Status status = new BulkByScrollTask.Status(sliceStatuses, this.getReasonCancelled());
        return this.taskInfo(localNodeId, this.getDescription(), status);
    }

    private void addResultsToList(List<BulkByScrollTask.StatusOrException> sliceStatuses) {
        for (Result t : this.results.asList()) {
            if (t.response != null) {
                sliceStatuses.set(t.sliceId, new BulkByScrollTask.StatusOrException(t.response.getStatus()));
                continue;
            }
            sliceStatuses.set(t.sliceId, new BulkByScrollTask.StatusOrException(t.failure));
        }
    }

    public void onSliceResponse(ActionListener<BulkByScrollResponse> listener, int sliceId, BulkByScrollResponse response) {
        this.results.setOnce(sliceId, new Result(sliceId, response));
        this.recordSliceCompletionAndRespondIfAllDone(listener);
    }

    public void onSliceFailure(ActionListener<BulkByScrollResponse> listener, int sliceId, Exception e) {
        this.results.setOnce(sliceId, new Result(sliceId, e));
        this.recordSliceCompletionAndRespondIfAllDone(listener);
    }

    private void recordSliceCompletionAndRespondIfAllDone(ActionListener<BulkByScrollResponse> listener) {
        if (this.counter.decrementAndGet() != 0) {
            return;
        }
        ArrayList<BulkByScrollResponse> responses = new ArrayList<BulkByScrollResponse>(this.results.length());
        Exception exception = null;
        for (Result t : this.results.asList()) {
            if (t.response == null) {
                assert (t.failure != null) : "exception shouldn't be null if value is null";
                if (exception == null) {
                    exception = t.failure;
                    continue;
                }
                exception.addSuppressed(t.failure);
                continue;
            }
            assert (t.failure == null) : "exception should be null if response is not null";
            responses.add(t.response);
        }
        if (exception == null) {
            listener.onResponse(new BulkByScrollResponse(responses, this.getReasonCancelled()));
        } else {
            listener.onFailure(exception);
        }
    }

    private static final class Result {
        final BulkByScrollResponse response;
        final int sliceId;
        final Exception failure;

        private Result(int sliceId, BulkByScrollResponse response) {
            this.sliceId = sliceId;
            this.response = response;
            this.failure = null;
        }

        private Result(int sliceId, Exception failure) {
            this.sliceId = sliceId;
            this.failure = failure;
            this.response = null;
        }
    }
}

