/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index.refresh;

import java.io.IOException;
import java.util.Objects;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.Version;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.Streamable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.unit.TimeValue;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentBuilder;

public class RefreshStats
implements Streamable,
ToXContent {
    private long total;
    private long totalTimeInMillis;
    private int listeners;

    public RefreshStats() {
    }

    public RefreshStats(long total, long totalTimeInMillis, int listeners) {
        this.total = total;
        this.totalTimeInMillis = totalTimeInMillis;
        this.listeners = listeners;
    }

    public void add(RefreshStats refreshStats) {
        this.addTotals(refreshStats);
    }

    public void addTotals(RefreshStats refreshStats) {
        if (refreshStats == null) {
            return;
        }
        this.total += refreshStats.total;
        this.totalTimeInMillis += refreshStats.totalTimeInMillis;
        this.listeners += refreshStats.listeners;
    }

    public long getTotal() {
        return this.total;
    }

    public long getTotalTimeInMillis() {
        return this.totalTimeInMillis;
    }

    public TimeValue getTotalTime() {
        return new TimeValue(this.totalTimeInMillis);
    }

    public int getListeners() {
        return this.listeners;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("refresh");
        builder.field("total", this.total);
        builder.timeValueField("total_time_in_millis", "total_time", this.totalTimeInMillis);
        builder.field("listeners", this.listeners);
        builder.endObject();
        return builder;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.total = in.readVLong();
        this.totalTimeInMillis = in.readVLong();
        this.listeners = in.getVersion().onOrAfter(Version.V_5_2_0) ? in.readVInt() : 0;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.total);
        out.writeVLong(this.totalTimeInMillis);
        if (out.getVersion().onOrAfter(Version.V_5_2_0)) {
            out.writeVInt(this.listeners);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != RefreshStats.class) {
            return false;
        }
        RefreshStats rhs = (RefreshStats)obj;
        return this.total == rhs.total && this.totalTimeInMillis == rhs.totalTimeInMillis && this.listeners == rhs.listeners;
    }

    public int hashCode() {
        return Objects.hash(this.total, this.totalTimeInMillis, this.listeners);
    }
}

