/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.document.Field;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.document.FieldType;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.document.SortedSetDocValuesField;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexOptions;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexReader;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexableField;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.Term;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.TermContext;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.BooleanClause;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.BooleanQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.ConstantScoreQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.MatchAllDocsQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.MatchNoDocsQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Query;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.TermInSetQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.TermQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.Version;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.fieldstats.FieldStats;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.lucene.Lucene;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.lucene.search.Queries;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.IndexFieldData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.plain.ConstantIndexFieldData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.plain.DocValuesIndexFieldData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.plain.PagedBytesIndexFieldData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.MappedFieldType;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.Mapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.MapperParsingException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.MapperService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.ParseContext;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.StringFieldType;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.TextFieldMapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.QueryShardContext;

public class TypeFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_type";
    public static final String CONTENT_TYPE = "_type";

    private TypeFieldMapper(Settings indexSettings, MappedFieldType existing) {
        this(existing == null ? TypeFieldMapper.defaultFieldType(indexSettings) : existing.clone(), indexSettings);
    }

    private TypeFieldMapper(MappedFieldType fieldType, Settings indexSettings) {
        super("_type", fieldType, TypeFieldMapper.defaultFieldType(indexSettings), indexSettings);
    }

    private static MappedFieldType defaultFieldType(Settings indexSettings) {
        Version indexCreated = Version.indexCreated(indexSettings);
        MappedFieldType defaultFieldType = Defaults.FIELD_TYPE.clone();
        if (MapperService.INDEX_MAPPING_SINGLE_TYPE_SETTING.get(indexSettings).booleanValue()) {
            defaultFieldType.setIndexOptions(IndexOptions.NONE);
            defaultFieldType.setHasDocValues(false);
        } else if (indexCreated.before(Version.V_2_1_0)) {
            ((TypeFieldType)defaultFieldType).setFielddata(true);
            defaultFieldType.setIndexOptions(IndexOptions.DOCS);
            defaultFieldType.setHasDocValues(false);
        } else {
            defaultFieldType.setIndexOptions(IndexOptions.DOCS);
            defaultFieldType.setHasDocValues(true);
        }
        return defaultFieldType;
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
        super.parse(context);
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
    }

    @Override
    public Mapper parse(ParseContext context) throws IOException {
        return null;
    }

    @Override
    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        if (this.fieldType().indexOptions() == IndexOptions.NONE && !this.fieldType().stored()) {
            return;
        }
        fields.add(new Field(this.fieldType().name(), context.sourceToParse().type(), (FieldType)this.fieldType()));
        if (this.fieldType().hasDocValues()) {
            fields.add(new SortedSetDocValuesField(this.fieldType().name(), new BytesRef(context.sourceToParse().type())));
        }
    }

    @Override
    protected String contentType() {
        return "_type";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder;
    }

    @Override
    protected void doMerge(Mapper mergeWith, boolean updateAllTypes) {
    }

    public static class TypesQuery
    extends Query {
        private static final int BOOLEAN_REWRITE_TERM_COUNT_THRESHOLD = 16;
        private final BytesRef[] types;

        public TypesQuery(BytesRef ... types) {
            if (types == null) {
                throw new NullPointerException("types cannot be null.");
            }
            if (types.length == 0) {
                throw new IllegalArgumentException("types must contains at least one value.");
            }
            this.types = types;
        }

        public BytesRef[] getTerms() {
            return this.types;
        }

        @Override
        public Query rewrite(IndexReader reader) throws IOException {
            int threshold = Math.min(16, BooleanQuery.getMaxClauseCount());
            if (this.types.length <= threshold) {
                HashSet<BytesRef> uniqueTypes = new HashSet<BytesRef>();
                BooleanQuery.Builder bq = new BooleanQuery.Builder();
                int totalDocFreq = 0;
                for (BytesRef type : this.types) {
                    if (!uniqueTypes.add(type)) continue;
                    Term term = new Term("_type", type);
                    TermContext context = TermContext.build(reader.getContext(), term);
                    if (context.docFreq() == 0) continue;
                    if ((totalDocFreq += context.docFreq()) >= reader.maxDoc()) {
                        assert (totalDocFreq == reader.maxDoc());
                        return new MatchAllDocsQuery();
                    }
                    bq.add(new TermQuery(term, context), BooleanClause.Occur.SHOULD);
                }
                return new ConstantScoreQuery(bq.build());
            }
            return new TermInSetQuery("_type", this.types);
        }

        @Override
        public boolean equals(Object obj) {
            if (!this.sameClassAs(obj)) {
                return false;
            }
            TypesQuery that = (TypesQuery)obj;
            return Arrays.equals(this.types, that.types);
        }

        @Override
        public int hashCode() {
            return 31 * this.classHash() + Arrays.hashCode(this.types);
        }

        @Override
        public String toString(String field) {
            StringBuilder builder = new StringBuilder();
            for (BytesRef type : this.types) {
                if (builder.length() > 0) {
                    builder.append(' ');
                }
                builder.append(new Term("_type", type).toString());
            }
            return builder.toString();
        }
    }

    static final class TypeFieldType
    extends StringFieldType {
        private boolean fielddata;

        TypeFieldType() {
            this.fielddata = false;
        }

        protected TypeFieldType(TypeFieldType ref) {
            super(ref);
            this.fielddata = ref.fielddata;
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            TypeFieldType that = (TypeFieldType)o;
            return this.fielddata == that.fielddata;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.fielddata);
        }

        @Override
        public MappedFieldType clone() {
            return new TypeFieldType(this);
        }

        @Override
        public String typeName() {
            return "_type";
        }

        public boolean fielddata() {
            return this.fielddata;
        }

        public void setFielddata(boolean fielddata) {
            this.checkIfFrozen();
            this.fielddata = fielddata;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder() {
            if (this.hasDocValues()) {
                return new DocValuesIndexFieldData.Builder();
            }
            if (this.fielddata) {
                return new PagedBytesIndexFieldData.Builder(TextFieldMapper.Defaults.FIELDDATA_MIN_FREQUENCY, TextFieldMapper.Defaults.FIELDDATA_MAX_FREQUENCY, TextFieldMapper.Defaults.FIELDDATA_MIN_SEGMENT_SIZE);
            }
            Function<MapperService, String> typeFunction = mapperService -> {
                Collection<String> types = mapperService.types();
                if (types.size() > 1) {
                    throw new AssertionError();
                }
                String type = types.iterator().next();
                return type;
            };
            return new ConstantIndexFieldData.Builder(typeFunction);
        }

        @Override
        public FieldStats<?> stats(IndexReader reader) throws IOException {
            if (reader.maxDoc() == 0) {
                return null;
            }
            return new FieldStats.Text(reader.maxDoc(), reader.numDocs(), reader.maxDoc(), reader.maxDoc(), this.isSearchable(), this.isAggregatable());
        }

        @Override
        public boolean isSearchable() {
            return true;
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            return this.termsQuery(Arrays.asList(value), context);
        }

        @Override
        public Query termsQuery(List<?> values, QueryShardContext context) {
            if (context.getIndexSettings().isSingleType()) {
                Collection<String> indexTypes = context.getMapperService().types();
                if (indexTypes.isEmpty()) {
                    return new MatchNoDocsQuery("No types");
                }
                assert (indexTypes.size() == 1);
                BytesRef indexType = this.indexedValueForSearch(indexTypes.iterator().next());
                if (values.stream().map(this::indexedValueForSearch).anyMatch(indexType::equals)) {
                    if (context.getMapperService().hasNested()) {
                        return Queries.newNonNestedFilter();
                    }
                    return new MatchAllDocsQuery();
                }
                return new MatchNoDocsQuery("Type list does not contain the index type");
            }
            if (this.indexOptions() == IndexOptions.NONE) {
                throw new AssertionError();
            }
            BytesRef[] types = (BytesRef[])values.stream().map(this::indexedValueForSearch).toArray(BytesRef[]::new);
            return new TypesQuery(types);
        }

        @Override
        public void checkCompatibility(MappedFieldType other, List<String> conflicts, boolean strict) {
            super.checkCompatibility(other, conflicts, strict);
            TypeFieldType otherType = (TypeFieldType)other;
            if (strict && this.fielddata() != otherType.fielddata()) {
                conflicts.add("mapper [" + this.name() + "] is used by multiple types. Set update_all_types to true to update [fielddata] across all types.");
            }
        }
    }

    public static class TypeParser
    implements MetadataFieldMapper.TypeParser {
        @Override
        public MetadataFieldMapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            throw new MapperParsingException("_type is not configurable");
        }

        @Override
        public MetadataFieldMapper getDefault(MappedFieldType fieldType, Mapper.TypeParser.ParserContext context) {
            Settings indexSettings = context.mapperService().getIndexSettings().getSettings();
            return new TypeFieldMapper(indexSettings, fieldType);
        }
    }

    public static class Defaults {
        public static final String NAME = "_type";
        public static final MappedFieldType FIELD_TYPE = new TypeFieldType();

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setStored(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setSearchAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setName("_type");
            FIELD_TYPE.freeze();
        }
    }
}

