/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.document.DoublePoint;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.document.Field;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.document.FloatPoint;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.document.HalfFloatPoint;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.document.IntPoint;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.document.LongPoint;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.document.SortedNumericDocValuesField;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.document.StoredField;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.FieldInfo;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexOptions;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexReader;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexableField;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.MultiFields;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.PointValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.BoostQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.IndexOrDocValuesQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.MatchNoDocsQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Query;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.NumericUtils;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.Version;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.fieldstats.FieldStats;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Explicit;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.lucene.search.Queries;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Setting;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentParser;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.IndexFieldData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.plain.DocValuesIndexFieldData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.FieldMapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.LegacyByteFieldMapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.LegacyDoubleFieldMapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.LegacyFloatFieldMapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.LegacyIntegerFieldMapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.LegacyLongFieldMapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.LegacyNumberFieldMapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.LegacyShortFieldMapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.MappedFieldType;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.Mapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.MapperParsingException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.ParseContext;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.TypeParsers;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.QueryShardContext;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.DocValueFormat;
import org.graylog.shaded.elasticsearch5.org.joda.time.DateTimeZone;

public class NumberFieldMapper
extends FieldMapper {
    static final Setting<Boolean> COERCE_SETTING = Setting.boolSetting("index.mapping.coerce", true, Setting.Property.IndexScope);
    private Boolean includeInAll;
    private Explicit<Boolean> ignoreMalformed;
    private Explicit<Boolean> coerce;

    private NumberFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> coerce, Boolean includeInAll, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, indexSettings, multiFields, copyTo);
        this.ignoreMalformed = ignoreMalformed;
        this.coerce = coerce;
        this.includeInAll = includeInAll;
    }

    @Override
    public NumberFieldType fieldType() {
        return (NumberFieldType)super.fieldType();
    }

    @Override
    protected String contentType() {
        return this.fieldType.typeName();
    }

    @Override
    protected NumberFieldMapper clone() {
        return (NumberFieldMapper)super.clone();
    }

    @Override
    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        Object value;
        boolean includeInAll = context.includeInAll(this.includeInAll, this);
        XContentParser parser = context.parser();
        Number numericValue = null;
        if (context.externalValueSet()) {
            value = context.externalValue();
        } else if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
            value = null;
        } else if (this.coerce.value().booleanValue() && parser.currentToken() == XContentParser.Token.VALUE_STRING && parser.textLength() == 0) {
            value = null;
        } else {
            try {
                numericValue = this.fieldType().type.parse(parser, (boolean)this.coerce.value());
            }
            catch (IllegalArgumentException e) {
                if (this.ignoreMalformed.value().booleanValue()) {
                    return;
                }
                throw e;
            }
            value = includeInAll ? parser.textOrNull() : numericValue;
        }
        if (value == null) {
            value = this.fieldType().nullValue();
        }
        if (value == null) {
            return;
        }
        if (numericValue == null) {
            numericValue = this.fieldType().type.parse(value, (boolean)this.coerce.value());
        }
        if (includeInAll) {
            context.allEntries().addText(this.fieldType().name(), value.toString(), this.fieldType().boost());
        }
        boolean indexed = this.fieldType().indexOptions() != IndexOptions.NONE;
        boolean docValued = this.fieldType().hasDocValues();
        boolean stored = this.fieldType().stored();
        fields.addAll(this.fieldType().type.createFields(this.fieldType().name(), numericValue, indexed, docValued, stored));
    }

    @Override
    protected void doMerge(Mapper mergeWith, boolean updateAllTypes) {
        super.doMerge(mergeWith, updateAllTypes);
        NumberFieldMapper other = (NumberFieldMapper)mergeWith;
        this.includeInAll = other.includeInAll;
        if (other.ignoreMalformed.explicit()) {
            this.ignoreMalformed = other.ignoreMalformed;
        }
        if (other.coerce.explicit()) {
            this.coerce = other.coerce;
        }
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || this.ignoreMalformed.explicit()) {
            builder.field("ignore_malformed", this.ignoreMalformed.value());
        }
        if (includeDefaults || this.coerce.explicit()) {
            builder.field("coerce", this.coerce.value());
        }
        if (includeDefaults || this.fieldType().nullValue() != null) {
            builder.field("null_value", this.fieldType().nullValue());
        }
        if (this.includeInAll != null) {
            builder.field("include_in_all", this.includeInAll);
        } else if (includeDefaults) {
            builder.field("include_in_all", false);
        }
    }

    public static final class NumberFieldType
    extends MappedFieldType {
        NumberType type;

        public NumberFieldType(NumberType type) {
            this.type = Objects.requireNonNull(type);
            this.setTokenized(false);
            this.setHasDocValues(true);
            this.setOmitNorms(true);
        }

        NumberFieldType(NumberFieldType other) {
            super(other);
            this.type = other.type;
        }

        @Override
        public MappedFieldType clone() {
            return new NumberFieldType(this);
        }

        @Override
        public String typeName() {
            return this.type.name;
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            this.failIfNotIndexed();
            Query query = this.type.termQuery(this.name(), value);
            if (this.boost() != 1.0f) {
                query = new BoostQuery(query, this.boost());
            }
            return query;
        }

        public Query termsQuery(List values, QueryShardContext context) {
            this.failIfNotIndexed();
            Query query = this.type.termsQuery(this.name(), values);
            if (this.boost() != 1.0f) {
                query = new BoostQuery(query, this.boost());
            }
            return query;
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, QueryShardContext context) {
            this.failIfNotIndexed();
            Query query = this.type.rangeQuery(this.name(), lowerTerm, upperTerm, includeLower, includeUpper, this.hasDocValues());
            if (this.boost() != 1.0f) {
                query = new BoostQuery(query, this.boost());
            }
            return query;
        }

        @Override
        public FieldStats stats(IndexReader reader) throws IOException {
            return this.type.stats(reader, this.name(), this.isSearchable(), this.isAggregatable());
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder() {
            this.failIfNoDocValues();
            return new DocValuesIndexFieldData.Builder().numericType(this.type.numericType());
        }

        @Override
        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            return this.type.valueForSearch((Number)value);
        }

        @Override
        public DocValueFormat docValueFormat(String format, DateTimeZone timeZone) {
            if (timeZone != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom time zones");
            }
            if (format == null) {
                return DocValueFormat.RAW;
            }
            return new DocValueFormat.Decimal(format);
        }
    }

    public static enum NumberType {
        HALF_FLOAT("half_float", IndexNumericFieldData.NumericType.HALF_FLOAT){

            @Override
            Float parse(Object value, boolean coerce) {
                return (Float)FLOAT.parse(value, false);
            }

            @Override
            Float parse(XContentParser parser, boolean coerce) throws IOException {
                return Float.valueOf(parser.floatValue(coerce));
            }

            @Override
            Query termQuery(String field, Object value) {
                float v = this.parse(value, false).floatValue();
                return HalfFloatPoint.newExactQuery(field, v);
            }

            @Override
            Query termsQuery(String field, List<Object> values) {
                float[] v = new float[values.size()];
                for (int i = 0; i < values.size(); ++i) {
                    v[i] = this.parse(values.get(i), false).floatValue();
                }
                return HalfFloatPoint.newSetQuery(field, v);
            }

            @Override
            Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues) {
                float l = Float.NEGATIVE_INFINITY;
                float u = Float.POSITIVE_INFINITY;
                if (lowerTerm != null) {
                    l = this.parse(lowerTerm, false).floatValue();
                    if (includeLower) {
                        l = HalfFloatPoint.nextDown(l);
                    }
                    l = HalfFloatPoint.nextUp(l);
                }
                if (upperTerm != null) {
                    u = this.parse(upperTerm, false).floatValue();
                    if (includeUpper) {
                        u = HalfFloatPoint.nextUp(u);
                    }
                    u = HalfFloatPoint.nextDown(u);
                }
                Query query = HalfFloatPoint.newRangeQuery(field, l, u);
                if (hasDocValues) {
                    Query dvQuery = SortedNumericDocValuesField.newRangeQuery(field, HalfFloatPoint.halfFloatToSortableShort(l), HalfFloatPoint.halfFloatToSortableShort(u));
                    query = new IndexOrDocValuesQuery(query, dvQuery);
                }
                return query;
            }

            @Override
            public List<Field> createFields(String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                ArrayList<Field> fields = new ArrayList<Field>();
                if (indexed) {
                    fields.add(new HalfFloatPoint(name, value.floatValue()));
                }
                if (docValued) {
                    fields.add(new SortedNumericDocValuesField(name, HalfFloatPoint.halfFloatToSortableShort(value.floatValue())));
                }
                if (stored) {
                    fields.add(new StoredField(name, value.floatValue()));
                }
                return fields;
            }

            FieldStats.Double stats(IndexReader reader, String fieldName, boolean isSearchable, boolean isAggregatable) throws IOException {
                FieldInfo fi = MultiFields.getMergedFieldInfos(reader).fieldInfo(fieldName);
                if (fi == null) {
                    return null;
                }
                long size = PointValues.size(reader, fieldName);
                if (size == 0L) {
                    return new FieldStats.Double(reader.maxDoc(), 0L, -1L, -1L, isSearchable, isAggregatable);
                }
                int docCount = PointValues.getDocCount(reader, fieldName);
                byte[] min = PointValues.getMinPackedValue(reader, fieldName);
                byte[] max = PointValues.getMaxPackedValue(reader, fieldName);
                return new FieldStats.Double(reader.maxDoc(), docCount, -1L, size, isSearchable, isAggregatable, HalfFloatPoint.decodeDimension(min, 0), HalfFloatPoint.decodeDimension(max, 0));
            }
        }
        ,
        FLOAT("float", IndexNumericFieldData.NumericType.FLOAT){

            @Override
            Float parse(Object value, boolean coerce) {
                if (value instanceof Number) {
                    return Float.valueOf(((Number)value).floatValue());
                }
                if (value instanceof BytesRef) {
                    value = ((BytesRef)value).utf8ToString();
                }
                return Float.valueOf(Float.parseFloat(value.toString()));
            }

            @Override
            Float parse(XContentParser parser, boolean coerce) throws IOException {
                return Float.valueOf(parser.floatValue(coerce));
            }

            @Override
            Query termQuery(String field, Object value) {
                float v = this.parse(value, false).floatValue();
                return FloatPoint.newExactQuery(field, v);
            }

            @Override
            Query termsQuery(String field, List<Object> values) {
                float[] v = new float[values.size()];
                for (int i = 0; i < values.size(); ++i) {
                    v[i] = this.parse(values.get(i), false).floatValue();
                }
                return FloatPoint.newSetQuery(field, v);
            }

            @Override
            Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues) {
                float l = Float.NEGATIVE_INFINITY;
                float u = Float.POSITIVE_INFINITY;
                if (lowerTerm != null) {
                    l = this.parse(lowerTerm, false).floatValue();
                    if (!includeLower) {
                        l = FloatPoint.nextUp(l);
                    }
                }
                if (upperTerm != null) {
                    u = this.parse(upperTerm, false).floatValue();
                    if (!includeUpper) {
                        u = FloatPoint.nextDown(u);
                    }
                }
                Query query = FloatPoint.newRangeQuery(field, l, u);
                if (hasDocValues) {
                    Query dvQuery = SortedNumericDocValuesField.newRangeQuery(field, NumericUtils.floatToSortableInt(l), NumericUtils.floatToSortableInt(u));
                    query = new IndexOrDocValuesQuery(query, dvQuery);
                }
                return query;
            }

            @Override
            public List<Field> createFields(String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                ArrayList<Field> fields = new ArrayList<Field>();
                if (indexed) {
                    fields.add(new FloatPoint(name, value.floatValue()));
                }
                if (docValued) {
                    fields.add(new SortedNumericDocValuesField(name, NumericUtils.floatToSortableInt(value.floatValue())));
                }
                if (stored) {
                    fields.add(new StoredField(name, value.floatValue()));
                }
                return fields;
            }

            FieldStats.Double stats(IndexReader reader, String fieldName, boolean isSearchable, boolean isAggregatable) throws IOException {
                FieldInfo fi = MultiFields.getMergedFieldInfos(reader).fieldInfo(fieldName);
                if (fi == null) {
                    return null;
                }
                long size = PointValues.size(reader, fieldName);
                if (size == 0L) {
                    return new FieldStats.Double(reader.maxDoc(), 0L, -1L, -1L, isSearchable, isAggregatable);
                }
                int docCount = PointValues.getDocCount(reader, fieldName);
                byte[] min = PointValues.getMinPackedValue(reader, fieldName);
                byte[] max = PointValues.getMaxPackedValue(reader, fieldName);
                return new FieldStats.Double(reader.maxDoc(), docCount, -1L, size, isSearchable, isAggregatable, FloatPoint.decodeDimension(min, 0), FloatPoint.decodeDimension(max, 0));
            }
        }
        ,
        DOUBLE("double", IndexNumericFieldData.NumericType.DOUBLE){

            @Override
            Double parse(Object value, boolean coerce) {
                return NumberType.objectToDouble(value);
            }

            @Override
            Double parse(XContentParser parser, boolean coerce) throws IOException {
                return parser.doubleValue(coerce);
            }

            @Override
            Query termQuery(String field, Object value) {
                double v = this.parse(value, false);
                return DoublePoint.newExactQuery(field, v);
            }

            @Override
            Query termsQuery(String field, List<Object> values) {
                double[] v = new double[values.size()];
                for (int i = 0; i < values.size(); ++i) {
                    v[i] = this.parse(values.get(i), false);
                }
                return DoublePoint.newSetQuery(field, v);
            }

            @Override
            Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues) {
                double l = Double.NEGATIVE_INFINITY;
                double u = Double.POSITIVE_INFINITY;
                if (lowerTerm != null) {
                    l = this.parse(lowerTerm, false);
                    if (!includeLower) {
                        l = DoublePoint.nextUp(l);
                    }
                }
                if (upperTerm != null) {
                    u = this.parse(upperTerm, false);
                    if (!includeUpper) {
                        u = DoublePoint.nextDown(u);
                    }
                }
                Query query = DoublePoint.newRangeQuery(field, l, u);
                if (hasDocValues) {
                    Query dvQuery = SortedNumericDocValuesField.newRangeQuery(field, NumericUtils.doubleToSortableLong(l), NumericUtils.doubleToSortableLong(u));
                    query = new IndexOrDocValuesQuery(query, dvQuery);
                }
                return query;
            }

            @Override
            public List<Field> createFields(String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                ArrayList<Field> fields = new ArrayList<Field>();
                if (indexed) {
                    fields.add(new DoublePoint(name, value.doubleValue()));
                }
                if (docValued) {
                    fields.add(new SortedNumericDocValuesField(name, NumericUtils.doubleToSortableLong(value.doubleValue())));
                }
                if (stored) {
                    fields.add(new StoredField(name, value.doubleValue()));
                }
                return fields;
            }

            FieldStats.Double stats(IndexReader reader, String fieldName, boolean isSearchable, boolean isAggregatable) throws IOException {
                FieldInfo fi = MultiFields.getMergedFieldInfos(reader).fieldInfo(fieldName);
                if (fi == null) {
                    return null;
                }
                long size = PointValues.size(reader, fieldName);
                if (size == 0L) {
                    return new FieldStats.Double(reader.maxDoc(), 0L, -1L, -1L, isSearchable, isAggregatable);
                }
                int docCount = PointValues.getDocCount(reader, fieldName);
                byte[] min = PointValues.getMinPackedValue(reader, fieldName);
                byte[] max = PointValues.getMaxPackedValue(reader, fieldName);
                return new FieldStats.Double(reader.maxDoc(), docCount, -1L, size, isSearchable, isAggregatable, DoublePoint.decodeDimension(min, 0), DoublePoint.decodeDimension(max, 0));
            }
        }
        ,
        BYTE("byte", IndexNumericFieldData.NumericType.BYTE){

            @Override
            Byte parse(Object value, boolean coerce) {
                double doubleValue = NumberType.objectToDouble(value);
                if (doubleValue < -128.0 || doubleValue > 127.0) {
                    throw new IllegalArgumentException("Value [" + value + "] is out of range for a byte");
                }
                if (!coerce && doubleValue % 1.0 != 0.0) {
                    throw new IllegalArgumentException("Value [" + value + "] has a decimal part");
                }
                if (value instanceof Number) {
                    return ((Number)value).byteValue();
                }
                return (byte)doubleValue;
            }

            @Override
            Short parse(XContentParser parser, boolean coerce) throws IOException {
                int value = parser.intValue(coerce);
                if (value < -128 || value > 127) {
                    throw new IllegalArgumentException("Value [" + value + "] is out of range for a byte");
                }
                return (short)value;
            }

            @Override
            Query termQuery(String field, Object value) {
                return INTEGER.termQuery(field, value);
            }

            @Override
            Query termsQuery(String field, List<Object> values) {
                return INTEGER.termsQuery(field, values);
            }

            @Override
            Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues) {
                return INTEGER.rangeQuery(field, lowerTerm, upperTerm, includeLower, includeUpper, hasDocValues);
            }

            @Override
            public List<Field> createFields(String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                return INTEGER.createFields(name, value, indexed, docValued, stored);
            }

            FieldStats.Long stats(IndexReader reader, String fieldName, boolean isSearchable, boolean isAggregatable) throws IOException {
                return (FieldStats.Long)INTEGER.stats(reader, fieldName, isSearchable, isAggregatable);
            }

            @Override
            Number valueForSearch(Number value) {
                return value.byteValue();
            }
        }
        ,
        SHORT("short", IndexNumericFieldData.NumericType.SHORT){

            @Override
            Short parse(Object value, boolean coerce) {
                double doubleValue = NumberType.objectToDouble(value);
                if (doubleValue < -32768.0 || doubleValue > 32767.0) {
                    throw new IllegalArgumentException("Value [" + value + "] is out of range for a short");
                }
                if (!coerce && doubleValue % 1.0 != 0.0) {
                    throw new IllegalArgumentException("Value [" + value + "] has a decimal part");
                }
                if (value instanceof Number) {
                    return ((Number)value).shortValue();
                }
                return (short)doubleValue;
            }

            @Override
            Short parse(XContentParser parser, boolean coerce) throws IOException {
                return parser.shortValue(coerce);
            }

            @Override
            Query termQuery(String field, Object value) {
                return INTEGER.termQuery(field, value);
            }

            @Override
            Query termsQuery(String field, List<Object> values) {
                return INTEGER.termsQuery(field, values);
            }

            @Override
            Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues) {
                return INTEGER.rangeQuery(field, lowerTerm, upperTerm, includeLower, includeUpper, hasDocValues);
            }

            @Override
            public List<Field> createFields(String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                return INTEGER.createFields(name, value, indexed, docValued, stored);
            }

            FieldStats.Long stats(IndexReader reader, String fieldName, boolean isSearchable, boolean isAggregatable) throws IOException {
                return (FieldStats.Long)INTEGER.stats(reader, fieldName, isSearchable, isAggregatable);
            }

            @Override
            Number valueForSearch(Number value) {
                return value.shortValue();
            }
        }
        ,
        INTEGER("integer", IndexNumericFieldData.NumericType.INT){

            @Override
            Integer parse(Object value, boolean coerce) {
                double doubleValue = NumberType.objectToDouble(value);
                if (doubleValue < -2.147483648E9 || doubleValue > 2.147483647E9) {
                    throw new IllegalArgumentException("Value [" + value + "] is out of range for an integer");
                }
                if (!coerce && doubleValue % 1.0 != 0.0) {
                    throw new IllegalArgumentException("Value [" + value + "] has a decimal part");
                }
                if (value instanceof Number) {
                    return ((Number)value).intValue();
                }
                return (int)doubleValue;
            }

            @Override
            Integer parse(XContentParser parser, boolean coerce) throws IOException {
                return parser.intValue(coerce);
            }

            @Override
            Query termQuery(String field, Object value) {
                if (this.hasDecimalPart(value)) {
                    return Queries.newMatchNoDocsQuery("Value [" + value + "] has a decimal part");
                }
                int v = this.parse(value, true);
                return IntPoint.newExactQuery(field, v);
            }

            @Override
            Query termsQuery(String field, List<Object> values) {
                int[] v = new int[values.size()];
                int upTo = 0;
                for (int i = 0; i < values.size(); ++i) {
                    Object value = values.get(i);
                    if (this.hasDecimalPart(value)) continue;
                    v[upTo++] = this.parse(value, true);
                }
                if (upTo == 0) {
                    return Queries.newMatchNoDocsQuery("All values have a decimal part");
                }
                if (upTo != v.length) {
                    v = Arrays.copyOf(v, upTo);
                }
                return IntPoint.newSetQuery(field, v);
            }

            @Override
            Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues) {
                int l = Integer.MIN_VALUE;
                int u = Integer.MAX_VALUE;
                if (lowerTerm != null) {
                    l = this.parse(lowerTerm, true);
                    boolean lowerTermHasDecimalPart = this.hasDecimalPart(lowerTerm);
                    if (!lowerTermHasDecimalPart && !includeLower || lowerTermHasDecimalPart && this.signum(lowerTerm) > 0.0) {
                        if (l == Integer.MAX_VALUE) {
                            return new MatchNoDocsQuery();
                        }
                        ++l;
                    }
                }
                if (upperTerm != null) {
                    u = this.parse(upperTerm, true);
                    boolean upperTermHasDecimalPart = this.hasDecimalPart(upperTerm);
                    if (!upperTermHasDecimalPart && !includeUpper || upperTermHasDecimalPart && this.signum(upperTerm) < 0.0) {
                        if (u == Integer.MIN_VALUE) {
                            return new MatchNoDocsQuery();
                        }
                        --u;
                    }
                }
                Query query = IntPoint.newRangeQuery(field, l, u);
                if (hasDocValues) {
                    Query dvQuery = SortedNumericDocValuesField.newRangeQuery(field, l, u);
                    query = new IndexOrDocValuesQuery(query, dvQuery);
                }
                return query;
            }

            @Override
            public List<Field> createFields(String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                ArrayList<Field> fields = new ArrayList<Field>();
                if (indexed) {
                    fields.add(new IntPoint(name, value.intValue()));
                }
                if (docValued) {
                    fields.add(new SortedNumericDocValuesField(name, value.intValue()));
                }
                if (stored) {
                    fields.add(new StoredField(name, value.intValue()));
                }
                return fields;
            }

            FieldStats.Long stats(IndexReader reader, String fieldName, boolean isSearchable, boolean isAggregatable) throws IOException {
                FieldInfo fi = MultiFields.getMergedFieldInfos(reader).fieldInfo(fieldName);
                if (fi == null) {
                    return null;
                }
                long size = PointValues.size(reader, fieldName);
                if (size == 0L) {
                    return new FieldStats.Long(reader.maxDoc(), 0L, -1L, -1L, isSearchable, isAggregatable);
                }
                int docCount = PointValues.getDocCount(reader, fieldName);
                byte[] min = PointValues.getMinPackedValue(reader, fieldName);
                byte[] max = PointValues.getMaxPackedValue(reader, fieldName);
                return new FieldStats.Long(reader.maxDoc(), docCount, -1L, size, isSearchable, isAggregatable, IntPoint.decodeDimension(min, 0), IntPoint.decodeDimension(max, 0));
            }
        }
        ,
        LONG("long", IndexNumericFieldData.NumericType.LONG){

            @Override
            Long parse(Object value, boolean coerce) {
                double doubleValue = NumberType.objectToDouble(value);
                if (doubleValue < -9.223372036854776E18 || doubleValue > 9.223372036854776E18) {
                    throw new IllegalArgumentException("Value [" + value + "] is out of range for a long");
                }
                if (!coerce && doubleValue % 1.0 != 0.0) {
                    throw new IllegalArgumentException("Value [" + value + "] has a decimal part");
                }
                if (value instanceof Number) {
                    return ((Number)value).longValue();
                }
                String stringValue = value instanceof BytesRef ? ((BytesRef)value).utf8ToString() : value.toString();
                try {
                    return Long.parseLong(stringValue);
                }
                catch (NumberFormatException e) {
                    return (long)Double.parseDouble(stringValue);
                }
            }

            @Override
            Long parse(XContentParser parser, boolean coerce) throws IOException {
                return parser.longValue(coerce);
            }

            @Override
            Query termQuery(String field, Object value) {
                if (this.hasDecimalPart(value)) {
                    return Queries.newMatchNoDocsQuery("Value [" + value + "] has a decimal part");
                }
                long v = this.parse(value, true);
                return LongPoint.newExactQuery(field, v);
            }

            @Override
            Query termsQuery(String field, List<Object> values) {
                long[] v = new long[values.size()];
                int upTo = 0;
                for (int i = 0; i < values.size(); ++i) {
                    Object value = values.get(i);
                    if (this.hasDecimalPart(value)) continue;
                    v[upTo++] = this.parse(value, true);
                }
                if (upTo == 0) {
                    return Queries.newMatchNoDocsQuery("All values have a decimal part");
                }
                if (upTo != v.length) {
                    v = Arrays.copyOf(v, upTo);
                }
                return LongPoint.newSetQuery(field, v);
            }

            @Override
            Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues) {
                long l = Long.MIN_VALUE;
                long u = Long.MAX_VALUE;
                if (lowerTerm != null) {
                    l = this.parse(lowerTerm, true);
                    boolean lowerTermHasDecimalPart = this.hasDecimalPart(lowerTerm);
                    if (!lowerTermHasDecimalPart && !includeLower || lowerTermHasDecimalPart && this.signum(lowerTerm) > 0.0) {
                        if (l == Long.MAX_VALUE) {
                            return new MatchNoDocsQuery();
                        }
                        ++l;
                    }
                }
                if (upperTerm != null) {
                    u = this.parse(upperTerm, true);
                    boolean upperTermHasDecimalPart = this.hasDecimalPart(upperTerm);
                    if (!upperTermHasDecimalPart && !includeUpper || upperTermHasDecimalPart && this.signum(upperTerm) < 0.0) {
                        if (u == Long.MIN_VALUE) {
                            return new MatchNoDocsQuery();
                        }
                        --u;
                    }
                }
                Query query = LongPoint.newRangeQuery(field, l, u);
                if (hasDocValues) {
                    Query dvQuery = SortedNumericDocValuesField.newRangeQuery(field, l, u);
                    query = new IndexOrDocValuesQuery(query, dvQuery);
                }
                return query;
            }

            @Override
            public List<Field> createFields(String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                ArrayList<Field> fields = new ArrayList<Field>();
                if (indexed) {
                    fields.add(new LongPoint(name, value.longValue()));
                }
                if (docValued) {
                    fields.add(new SortedNumericDocValuesField(name, value.longValue()));
                }
                if (stored) {
                    fields.add(new StoredField(name, value.longValue()));
                }
                return fields;
            }

            FieldStats.Long stats(IndexReader reader, String fieldName, boolean isSearchable, boolean isAggregatable) throws IOException {
                FieldInfo fi = MultiFields.getMergedFieldInfos(reader).fieldInfo(fieldName);
                if (fi == null) {
                    return null;
                }
                long size = PointValues.size(reader, fieldName);
                if (size == 0L) {
                    return new FieldStats.Long(reader.maxDoc(), 0L, -1L, -1L, isSearchable, isAggregatable);
                }
                int docCount = PointValues.getDocCount(reader, fieldName);
                byte[] min = PointValues.getMinPackedValue(reader, fieldName);
                byte[] max = PointValues.getMaxPackedValue(reader, fieldName);
                return new FieldStats.Long(reader.maxDoc(), docCount, -1L, size, isSearchable, isAggregatable, LongPoint.decodeDimension(min, 0), LongPoint.decodeDimension(max, 0));
            }
        };

        private final String name;
        private final IndexNumericFieldData.NumericType numericType;

        private NumberType(String name, IndexNumericFieldData.NumericType numericType) {
            this.name = name;
            this.numericType = numericType;
        }

        public final String typeName() {
            return this.name;
        }

        final IndexNumericFieldData.NumericType numericType() {
            return this.numericType;
        }

        abstract Query termQuery(String var1, Object var2);

        abstract Query termsQuery(String var1, List<Object> var2);

        abstract Query rangeQuery(String var1, Object var2, Object var3, boolean var4, boolean var5, boolean var6);

        abstract Number parse(XContentParser var1, boolean var2) throws IOException;

        abstract Number parse(Object var1, boolean var2);

        public abstract List<Field> createFields(String var1, Number var2, boolean var3, boolean var4, boolean var5);

        abstract FieldStats<? extends Number> stats(IndexReader var1, String var2, boolean var3, boolean var4) throws IOException;

        Number valueForSearch(Number value) {
            return value;
        }

        boolean hasDecimalPart(Object number) {
            if (number instanceof Number) {
                double doubleValue = ((Number)number).doubleValue();
                return doubleValue % 1.0 != 0.0;
            }
            if (number instanceof BytesRef) {
                number = ((BytesRef)number).utf8ToString();
            }
            if (number instanceof String) {
                return Double.parseDouble((String)number) % 1.0 != 0.0;
            }
            return false;
        }

        double signum(Object value) {
            if (value instanceof Number) {
                double doubleValue = ((Number)value).doubleValue();
                return Math.signum(doubleValue);
            }
            if (value instanceof BytesRef) {
                value = ((BytesRef)value).utf8ToString();
            }
            return Math.signum(Double.parseDouble(value.toString()));
        }

        private static double objectToDouble(Object value) {
            double doubleValue = value instanceof Number ? ((Number)value).doubleValue() : (value instanceof BytesRef ? Double.parseDouble(((BytesRef)value).utf8ToString()) : Double.parseDouble(value.toString()));
            return doubleValue;
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        final NumberType type;

        public TypeParser(NumberType type) {
            this.type = type;
        }

        @Override
        public Mapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            if (parserContext.indexVersionCreated().before(Version.V_5_0_0_alpha2)) {
                switch (this.type) {
                    case BYTE: {
                        return new LegacyByteFieldMapper.TypeParser().parse(name, node, parserContext);
                    }
                    case SHORT: {
                        return new LegacyShortFieldMapper.TypeParser().parse(name, node, parserContext);
                    }
                    case INTEGER: {
                        return new LegacyIntegerFieldMapper.TypeParser().parse(name, node, parserContext);
                    }
                    case LONG: {
                        return new LegacyLongFieldMapper.TypeParser().parse(name, node, parserContext);
                    }
                    case FLOAT: {
                        return new LegacyFloatFieldMapper.TypeParser().parse(name, node, parserContext);
                    }
                    case DOUBLE: {
                        return new LegacyDoubleFieldMapper.TypeParser().parse(name, node, parserContext);
                    }
                }
                throw new AssertionError();
            }
            Builder builder = new Builder(name, this.type);
            TypeParsers.parseField(builder, name, node, parserContext);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = entry.getKey();
                Object propNode = entry.getValue();
                if (propName.equals("null_value")) {
                    if (propNode == null) {
                        throw new MapperParsingException("Property [null_value] cannot be null.");
                    }
                    builder.nullValue(this.type.parse(propNode, false));
                    iterator.remove();
                    continue;
                }
                if (propName.equals("ignore_malformed")) {
                    builder.ignoreMalformed(TypeParsers.nodeBooleanValue(name, "ignore_malformed", propNode));
                    iterator.remove();
                    continue;
                }
                if (!propName.equals("coerce")) continue;
                builder.coerce(TypeParsers.nodeBooleanValue(name, "coerce", propNode));
                iterator.remove();
            }
            return builder;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder, NumberFieldMapper> {
        private Boolean ignoreMalformed;
        private Boolean coerce;

        public Builder(String name, NumberType type) {
            super(name, new NumberFieldType(type), new NumberFieldType(type));
            this.builder = this;
        }

        public Builder ignoreMalformed(boolean ignoreMalformed) {
            this.ignoreMalformed = ignoreMalformed;
            return (Builder)this.builder;
        }

        protected Explicit<Boolean> ignoreMalformed(Mapper.BuilderContext context) {
            if (this.ignoreMalformed != null) {
                return new Explicit<Boolean>(this.ignoreMalformed, true);
            }
            if (context.indexSettings() != null) {
                return new Explicit<Boolean>(FieldMapper.IGNORE_MALFORMED_SETTING.get(context.indexSettings()), false);
            }
            return LegacyNumberFieldMapper.Defaults.IGNORE_MALFORMED;
        }

        public Builder coerce(boolean coerce) {
            this.coerce = coerce;
            return (Builder)this.builder;
        }

        protected Explicit<Boolean> coerce(Mapper.BuilderContext context) {
            if (this.coerce != null) {
                return new Explicit<Boolean>(this.coerce, true);
            }
            if (context.indexSettings() != null) {
                return new Explicit<Boolean>(COERCE_SETTING.get(context.indexSettings()), false);
            }
            return LegacyNumberFieldMapper.Defaults.COERCE;
        }

        @Override
        protected void setupFieldType(Mapper.BuilderContext context) {
            super.setupFieldType(context);
        }

        @Override
        public NumberFieldMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            return new NumberFieldMapper(this.name, this.fieldType, this.defaultFieldType, this.ignoreMalformed(context), this.coerce(context), this.includeInAll, context.indexSettings(), this.multiFieldsBuilder.build(this, context), this.copyTo);
        }
    }
}

