/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.Analyzer;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.TokenStream;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.codecs.PostingsFormat;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.document.Field;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.document.FieldType;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexableField;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ElasticsearchParseException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.Version;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.ParseField;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentParser;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.NamedAnalyzer;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.FieldMapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.MappedFieldType;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.Mapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.MapperException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.MapperParsingException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.ParseContext;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.TermBasedFieldType;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.TypeParsers;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.suggest.completion2x.AnalyzingCompletionLookupProvider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.suggest.completion2x.Completion090PostingsFormat;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.suggest.completion2x.CompletionTokenStream;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.suggest.completion2x.context.ContextBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.suggest.completion2x.context.ContextMapping;

public class CompletionFieldMapper2x
extends FieldMapper {
    public static final String CONTENT_TYPE = "completion";
    public static final Set<String> ALLOWED_CONTENT_FIELD_NAMES = new HashSet<String>();
    private static final BytesRef EMPTY;
    private int maxInputLength;

    public CompletionFieldMapper2x(String simpleName, MappedFieldType fieldType, int maxInputLength, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, Defaults.FIELD_TYPE, indexSettings, multiFields, copyTo);
        this.maxInputLength = maxInputLength;
    }

    @Override
    public CompletionFieldType fieldType() {
        return (CompletionFieldType)super.fieldType();
    }

    @Override
    public Mapper parse(ParseContext context) throws IOException {
        XContentParser parser = context.parser();
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.VALUE_NULL) {
            throw new MapperParsingException("completion field [" + this.fieldType().name() + "] does not support null values");
        }
        String surfaceForm = null;
        BytesRef payload = null;
        long weight = -1L;
        ArrayList<String> inputs = new ArrayList<String>(4);
        TreeMap<String, ContextMapping.ContextConfig> contextConfig = null;
        if (token == XContentParser.Token.VALUE_STRING) {
            inputs.add(parser.text());
            this.multiFields.parse(this, context);
        } else {
            Object currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    if (ALLOWED_CONTENT_FIELD_NAMES.contains(currentFieldName)) continue;
                    throw new IllegalArgumentException("Unknown field name[" + (String)currentFieldName + "], must be one of " + ALLOWED_CONTENT_FIELD_NAMES);
                }
                if ("context".equals(currentFieldName)) {
                    TreeMap<Object, ContextMapping.ContextConfig> treeMap = new TreeMap<Object, ContextMapping.ContextConfig>();
                    if (token == XContentParser.Token.START_OBJECT) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            String name = parser.currentName();
                            ContextMapping mapping = (ContextMapping)this.fieldType().getContextMapping().get(name);
                            if (mapping == null) {
                                throw new ElasticsearchParseException("context [{}] is not defined", name);
                            }
                            token = parser.nextToken();
                            treeMap.put(name, mapping.parseContext(context, parser));
                        }
                        contextConfig = new TreeMap();
                        for (ContextMapping mapping : this.fieldType().getContextMapping().values()) {
                            ContextMapping.ContextConfig config = (ContextMapping.ContextConfig)treeMap.get(mapping.name());
                            contextConfig.put(mapping.name(), config == null ? mapping.defaultConfig() : config);
                        }
                        continue;
                    }
                    throw new ElasticsearchParseException("context must be an object", new Object[0]);
                }
                if ("payload".equals(currentFieldName)) {
                    if (!this.isStoringPayloads()) {
                        throw new MapperException("Payloads disabled in mapping");
                    }
                    if (token == XContentParser.Token.START_OBJECT) {
                        XContentBuilder xContentBuilder = XContentFactory.contentBuilder(parser.contentType()).copyCurrentStructure(parser);
                        payload = xContentBuilder.bytes().toBytesRef();
                        xContentBuilder.close();
                        continue;
                    }
                    if (token.isValue()) {
                        payload = parser.utf8BytesOrNull();
                        continue;
                    }
                    throw new MapperException("payload doesn't support type " + (Object)((Object)token));
                }
                if (token == XContentParser.Token.VALUE_STRING) {
                    Long l;
                    if ("output".equals(currentFieldName)) {
                        surfaceForm = parser.text();
                    }
                    if ("input".equals(currentFieldName)) {
                        inputs.add(parser.text());
                    }
                    if (!"weight".equals(currentFieldName)) continue;
                    try {
                        l = Long.parseLong(parser.text());
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Weight must be a string representing a numeric value, but was [" + parser.text() + "]");
                    }
                    weight = l;
                    this.checkWeight(weight);
                    continue;
                }
                if (token == XContentParser.Token.VALUE_NUMBER) {
                    if (!"weight".equals(currentFieldName)) continue;
                    XContentParser.NumberType numberType = parser.numberType();
                    if (XContentParser.NumberType.LONG != numberType && XContentParser.NumberType.INT != numberType) {
                        throw new IllegalArgumentException("Weight must be an integer, but was [" + parser.numberValue() + "]");
                    }
                    weight = parser.longValue();
                    this.checkWeight(weight);
                    continue;
                }
                if (token != XContentParser.Token.START_ARRAY || !"input".equals(currentFieldName)) continue;
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    inputs.add(parser.text());
                }
            }
        }
        if (contextConfig == null) {
            contextConfig = new TreeMap<String, ContextMapping.ContextConfig>();
            for (ContextMapping contextMapping : this.fieldType().getContextMapping().values()) {
                contextConfig.put(contextMapping.name(), contextMapping.defaultConfig());
            }
        }
        ContextMapping.Context ctx = new ContextMapping.Context(contextConfig, context.doc());
        BytesRef bytesRef = payload = payload == null ? EMPTY : payload;
        if (surfaceForm == null) {
            for (String input : inputs) {
                if (input.length() == 0) continue;
                BytesRef suggestPayload = this.fieldType().analyzingSuggestLookupProvider.buildPayload(new BytesRef(input), weight, payload);
                context.doc().add(this.getCompletionField(ctx, input, suggestPayload));
            }
        } else {
            BytesRef bytesRef2 = this.fieldType().analyzingSuggestLookupProvider.buildPayload(new BytesRef(surfaceForm), weight, payload);
            for (String input : inputs) {
                if (input.length() == 0) continue;
                context.doc().add(this.getCompletionField(ctx, input, bytesRef2));
            }
        }
        return null;
    }

    private void checkWeight(long weight) {
        if (weight < 0L || weight > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Weight must be in the interval [0..2147483647], but was [" + weight + "]");
        }
    }

    public Field getCompletionField(ContextMapping.Context ctx, String input, BytesRef payload) {
        String originalInput = input;
        if (input.length() > this.maxInputLength) {
            int len = CompletionFieldMapper2x.correctSubStringLen(input, Math.min(this.maxInputLength, input.length()));
            input = input.substring(0, len);
        }
        for (int i = 0; i < input.length(); ++i) {
            if (!CompletionFieldMapper2x.isReservedChar(input.charAt(i))) continue;
            throw new IllegalArgumentException("Illegal input [" + originalInput + "] UTF-16 codepoint  [0x" + Integer.toHexString(input.charAt(i)).toUpperCase(Locale.ROOT) + "] at position " + i + " is a reserved character");
        }
        return new SuggestField(this.fieldType().name(), ctx, input, this.fieldType(), payload, this.fieldType().analyzingSuggestLookupProvider);
    }

    public static int correctSubStringLen(String input, int len) {
        if (Character.isHighSurrogate(input.charAt(len - 1))) {
            assert (input.length() >= len + 1 && Character.isLowSurrogate(input.charAt(len)));
            return len + 1;
        }
        return len;
    }

    public BytesRef buildPayload(BytesRef surfaceForm, long weight, BytesRef payload) throws IOException {
        return this.fieldType().analyzingSuggestLookupProvider.buildPayload(surfaceForm, weight, payload);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.simpleName()).field("type", CONTENT_TYPE);
        builder.field("analyzer", this.fieldType().indexAnalyzer().name());
        if (!this.fieldType().indexAnalyzer().name().equals(this.fieldType().searchAnalyzer().name())) {
            builder.field(Fields.SEARCH_ANALYZER.getPreferredName(), this.fieldType().searchAnalyzer().name());
        }
        builder.field("payloads", this.fieldType().analyzingSuggestLookupProvider.hasPayloads());
        builder.field(Fields.PRESERVE_SEPARATORS.getPreferredName(), this.fieldType().analyzingSuggestLookupProvider.getPreserveSep());
        builder.field(Fields.PRESERVE_POSITION_INCREMENTS.getPreferredName(), this.fieldType().analyzingSuggestLookupProvider.getPreservePositionsIncrements());
        builder.field(Fields.MAX_INPUT_LENGTH.getPreferredName(), this.maxInputLength);
        this.multiFields.toXContent(builder, params);
        if (this.fieldType().requiresContext()) {
            builder.startObject("context");
            for (ContextMapping mapping : this.fieldType().getContextMapping().values()) {
                builder.value((Object)mapping);
            }
            builder.endObject();
        }
        return builder.endObject();
    }

    @Override
    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    public boolean isStoringPayloads() {
        return this.fieldType().analyzingSuggestLookupProvider.hasPayloads();
    }

    @Override
    protected void doMerge(Mapper mergeWith, boolean updateAllTypes) {
        super.doMerge(mergeWith, updateAllTypes);
        CompletionFieldMapper2x fieldMergeWith = (CompletionFieldMapper2x)mergeWith;
        this.maxInputLength = fieldMergeWith.maxInputLength;
    }

    public static boolean isReservedChar(char character) {
        switch (character) {
            case '\u0000': 
            case '\u001d': 
            case '\u001e': 
            case '\u001f': {
                return true;
            }
        }
        return false;
    }

    static {
        ALLOWED_CONTENT_FIELD_NAMES.add("input");
        ALLOWED_CONTENT_FIELD_NAMES.add("output");
        ALLOWED_CONTENT_FIELD_NAMES.add("payload");
        ALLOWED_CONTENT_FIELD_NAMES.add("weight");
        ALLOWED_CONTENT_FIELD_NAMES.add("context");
        EMPTY = new BytesRef();
    }

    private static final class SuggestField
    extends Field {
        private final BytesRef payload;
        private final CompletionTokenStream.ToFiniteStrings toFiniteStrings;
        private final ContextMapping.Context ctx;

        SuggestField(String name, ContextMapping.Context ctx, String value, MappedFieldType type, BytesRef payload, CompletionTokenStream.ToFiniteStrings toFiniteStrings) {
            super(name, value, (FieldType)type);
            this.payload = payload;
            this.toFiniteStrings = toFiniteStrings;
            this.ctx = ctx;
        }

        @Override
        public TokenStream tokenStream(Analyzer analyzer, TokenStream previous) {
            TokenStream ts = this.ctx.wrapTokenStream(super.tokenStream(analyzer, previous));
            return new CompletionTokenStream(ts, this.payload, this.toFiniteStrings);
        }
    }

    public static final class CompletionFieldType
    extends TermBasedFieldType {
        private PostingsFormat postingsFormat;
        private AnalyzingCompletionLookupProvider analyzingSuggestLookupProvider;
        private SortedMap<String, ContextMapping> contextMapping = ContextMapping.EMPTY_MAPPING;

        public CompletionFieldType() {
        }

        protected CompletionFieldType(CompletionFieldType ref) {
            super(ref);
            this.postingsFormat = ref.postingsFormat;
            this.analyzingSuggestLookupProvider = ref.analyzingSuggestLookupProvider;
            this.contextMapping = ref.contextMapping;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CompletionFieldType)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CompletionFieldType fieldType = (CompletionFieldType)o;
            return this.analyzingSuggestLookupProvider.getPreserveSep() == fieldType.analyzingSuggestLookupProvider.getPreserveSep() && this.analyzingSuggestLookupProvider.getPreservePositionsIncrements() == fieldType.analyzingSuggestLookupProvider.getPreservePositionsIncrements() && this.analyzingSuggestLookupProvider.hasPayloads() == fieldType.analyzingSuggestLookupProvider.hasPayloads() && Objects.equals(this.getContextMapping(), fieldType.getContextMapping());
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.analyzingSuggestLookupProvider.getPreserveSep(), this.analyzingSuggestLookupProvider.getPreservePositionsIncrements(), this.analyzingSuggestLookupProvider.hasPayloads(), this.getContextMapping());
        }

        @Override
        public CompletionFieldType clone() {
            return new CompletionFieldType(this);
        }

        @Override
        public String typeName() {
            return CompletionFieldMapper2x.CONTENT_TYPE;
        }

        @Override
        public void checkCompatibility(MappedFieldType fieldType, List<String> conflicts, boolean strict) {
            super.checkCompatibility(fieldType, conflicts, strict);
            CompletionFieldType other = (CompletionFieldType)fieldType;
            if (this.analyzingSuggestLookupProvider.hasPayloads() != other.analyzingSuggestLookupProvider.hasPayloads()) {
                conflicts.add("mapper [" + this.name() + "] has different [payload] values");
            }
            if (this.analyzingSuggestLookupProvider.getPreservePositionsIncrements() != other.analyzingSuggestLookupProvider.getPreservePositionsIncrements()) {
                conflicts.add("mapper [" + this.name() + "] has different [preserve_position_increments] values");
            }
            if (this.analyzingSuggestLookupProvider.getPreserveSep() != other.analyzingSuggestLookupProvider.getPreserveSep()) {
                conflicts.add("mapper [" + this.name() + "] has different [preserve_separators] values");
            }
            if (!ContextMapping.mappingsAreEqual(this.getContextMapping(), other.getContextMapping())) {
                conflicts.add("mapper [" + this.name() + "] has different [context_mapping] values");
            }
        }

        public void setProvider(AnalyzingCompletionLookupProvider provider) {
            this.checkIfFrozen();
            this.analyzingSuggestLookupProvider = provider;
        }

        public synchronized PostingsFormat postingsFormat(PostingsFormat in) {
            if (in instanceof Completion090PostingsFormat) {
                throw new IllegalStateException("Double wrapping of " + Completion090PostingsFormat.class);
            }
            if (this.postingsFormat == null) {
                this.postingsFormat = new Completion090PostingsFormat(in, this.analyzingSuggestLookupProvider);
            }
            return this.postingsFormat;
        }

        public void setContextMapping(SortedMap<String, ContextMapping> contextMapping) {
            this.checkIfFrozen();
            this.contextMapping = contextMapping;
        }

        public SortedMap<String, ContextMapping> getContextMapping() {
            return this.contextMapping;
        }

        public boolean requiresContext() {
            return !this.contextMapping.isEmpty();
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name);
            NamedAnalyzer indexAnalyzer = null;
            NamedAnalyzer searchAnalyzer = null;
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = entry.getKey();
                Object fieldNode = entry.getValue();
                if (fieldName.equals("type")) continue;
                if ("analyzer".equals(fieldName) || fieldName.equals("index_analyzer") && parserContext.indexVersionCreated().before(Version.V_2_0_0_beta1)) {
                    indexAnalyzer = this.getNamedAnalyzer(parserContext, fieldNode.toString());
                    iterator.remove();
                    continue;
                }
                if (Fields.SEARCH_ANALYZER.match(fieldName)) {
                    searchAnalyzer = this.getNamedAnalyzer(parserContext, fieldNode.toString());
                    iterator.remove();
                    continue;
                }
                if (fieldName.equals("payloads")) {
                    builder.payloads(Boolean.parseBoolean(fieldNode.toString()));
                    iterator.remove();
                    continue;
                }
                if (Fields.PRESERVE_SEPARATORS.match(fieldName)) {
                    builder.preserveSeparators(Boolean.parseBoolean(fieldNode.toString()));
                    iterator.remove();
                    continue;
                }
                if (Fields.PRESERVE_POSITION_INCREMENTS.match(fieldName)) {
                    builder.preservePositionIncrements(Boolean.parseBoolean(fieldNode.toString()));
                    iterator.remove();
                    continue;
                }
                if (Fields.MAX_INPUT_LENGTH.match(fieldName)) {
                    builder.maxInputLength(Integer.parseInt(fieldNode.toString()));
                    iterator.remove();
                    continue;
                }
                if (TypeParsers.parseMultiField(builder, name, parserContext, fieldName, fieldNode)) {
                    iterator.remove();
                    continue;
                }
                if (!fieldName.equals("context")) continue;
                builder.contextMapping(ContextBuilder.loadMappings(fieldNode, parserContext.indexVersionCreated()));
                iterator.remove();
            }
            if (indexAnalyzer == null) {
                if (searchAnalyzer != null) {
                    throw new MapperParsingException("analyzer on completion field [" + name + "] must be set when search_analyzer is set");
                }
                indexAnalyzer = searchAnalyzer = parserContext.getIndexAnalyzers().get("simple");
            } else if (searchAnalyzer == null) {
                searchAnalyzer = indexAnalyzer;
            }
            builder.indexAnalyzer(indexAnalyzer);
            builder.searchAnalyzer(searchAnalyzer);
            return builder;
        }

        private NamedAnalyzer getNamedAnalyzer(Mapper.TypeParser.ParserContext parserContext, String name) {
            NamedAnalyzer analyzer = parserContext.getIndexAnalyzers().get(name);
            if (analyzer == null) {
                throw new IllegalArgumentException("Can't find default or mapped analyzer with name [" + name + "]");
            }
            return analyzer;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder, CompletionFieldMapper2x> {
        private boolean preserveSeparators = true;
        private boolean payloads = false;
        private boolean preservePositionIncrements = true;
        private int maxInputLength = 50;
        private SortedMap<String, ContextMapping> contextMapping = ContextMapping.EMPTY_MAPPING;

        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE, Defaults.FIELD_TYPE);
            this.builder = this;
        }

        public Builder payloads(boolean payloads) {
            this.payloads = payloads;
            return this;
        }

        public Builder preserveSeparators(boolean preserveSeparators) {
            this.preserveSeparators = preserveSeparators;
            return this;
        }

        public Builder preservePositionIncrements(boolean preservePositionIncrements) {
            this.preservePositionIncrements = preservePositionIncrements;
            return this;
        }

        public Builder maxInputLength(int maxInputLength) {
            if (maxInputLength <= 0) {
                throw new IllegalArgumentException(Fields.MAX_INPUT_LENGTH.getPreferredName() + " must be > 0 but was [" + maxInputLength + "]");
            }
            this.maxInputLength = maxInputLength;
            return this;
        }

        public Builder contextMapping(SortedMap<String, ContextMapping> contextMapping) {
            this.contextMapping = contextMapping;
            return this;
        }

        @Override
        public CompletionFieldMapper2x build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            CompletionFieldType completionFieldType = (CompletionFieldType)this.fieldType;
            completionFieldType.setProvider(new AnalyzingCompletionLookupProvider(this.preserveSeparators, this.preservePositionIncrements, this.payloads));
            completionFieldType.setContextMapping(this.contextMapping);
            return new CompletionFieldMapper2x(this.name, this.fieldType, this.maxInputLength, context.indexSettings(), this.multiFieldsBuilder.build(this, context), this.copyTo);
        }
    }

    public static class Fields {
        public static final String ANALYZER = "analyzer";
        public static final ParseField SEARCH_ANALYZER = new ParseField("search_analyzer", new String[0]);
        public static final ParseField PRESERVE_SEPARATORS = new ParseField("preserve_separators", new String[0]);
        public static final ParseField PRESERVE_POSITION_INCREMENTS = new ParseField("preserve_position_increments", new String[0]);
        public static final String PAYLOADS = "payloads";
        public static final String TYPE = "type";
        public static final ParseField MAX_INPUT_LENGTH = new ParseField("max_input_length", "max_input_len");
        public static final String CONTENT_FIELD_NAME_INPUT = "input";
        public static final String CONTENT_FIELD_NAME_OUTPUT = "output";
        public static final String CONTENT_FIELD_NAME_PAYLOAD = "payload";
        public static final String CONTENT_FIELD_NAME_WEIGHT = "weight";
        public static final String CONTEXT = "context";
    }

    public static class Defaults {
        public static final CompletionFieldType FIELD_TYPE = new CompletionFieldType();
        public static final boolean DEFAULT_PRESERVE_SEPARATORS = true;
        public static final boolean DEFAULT_POSITION_INCREMENTS = true;
        public static final boolean DEFAULT_HAS_PAYLOADS = false;
        public static final int DEFAULT_MAX_INPUT_LENGTH = 50;

        static {
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.freeze();
        }
    }
}

