/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis;

import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.TokenStream;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.payloads.DelimitedPayloadTokenFilter;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.payloads.FloatEncoder;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.payloads.IdentityEncoder;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.payloads.IntegerEncoder;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.payloads.PayloadEncoder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.env.Environment;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.IndexSettings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.AbstractTokenFilterFactory;

public class DelimitedPayloadTokenFilterFactory
extends AbstractTokenFilterFactory {
    public static final char DEFAULT_DELIMITER = '|';
    public static final PayloadEncoder DEFAULT_ENCODER = new FloatEncoder();
    static final String ENCODING = "encoding";
    static final String DELIMITER = "delimiter";
    char delimiter;
    PayloadEncoder encoder;

    public DelimitedPayloadTokenFilterFactory(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, name, settings);
        String delimiterConf = settings.get(DELIMITER);
        this.delimiter = delimiterConf != null ? delimiterConf.charAt(0) : (char)124;
        if (settings.get(ENCODING) != null) {
            if (settings.get(ENCODING).equals("float")) {
                this.encoder = new FloatEncoder();
            } else if (settings.get(ENCODING).equals("int")) {
                this.encoder = new IntegerEncoder();
            } else if (settings.get(ENCODING).equals("identity")) {
                this.encoder = new IdentityEncoder();
            }
        } else {
            this.encoder = DEFAULT_ENCODER;
        }
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        DelimitedPayloadTokenFilter filter = new DelimitedPayloadTokenFilter(tokenStream, this.delimiter, this.encoder);
        return filter;
    }
}

