/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.env;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.ParseField;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.ObjectParser;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentParser;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentType;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.gateway.MetaDataStateFormat;

public final class NodeMetaData {
    private static final String NODE_ID_KEY = "node_id";
    private final String nodeId;
    private static ObjectParser<Builder, Void> PARSER = new ObjectParser("node_meta_data", () -> new Builder());
    public static final MetaDataStateFormat<NodeMetaData> FORMAT;

    public NodeMetaData(String nodeId) {
        this.nodeId = Objects.requireNonNull(nodeId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeMetaData that = (NodeMetaData)o;
        return Objects.equals(this.nodeId, that.nodeId);
    }

    public int hashCode() {
        return this.nodeId.hashCode();
    }

    public String toString() {
        return "node_id [" + this.nodeId + "]";
    }

    public String nodeId() {
        return this.nodeId;
    }

    static {
        PARSER.declareString(Builder::setNodeId, new ParseField(NODE_ID_KEY, new String[0]));
        FORMAT = new MetaDataStateFormat<NodeMetaData>(XContentType.SMILE, "node-"){

            @Override
            protected XContentBuilder newXContentBuilder(XContentType type, OutputStream stream) throws IOException {
                XContentBuilder xContentBuilder = super.newXContentBuilder(type, stream);
                xContentBuilder.prettyPrint();
                return xContentBuilder;
            }

            @Override
            public void toXContent(XContentBuilder builder, NodeMetaData nodeMetaData) throws IOException {
                builder.field(NodeMetaData.NODE_ID_KEY, nodeMetaData.nodeId);
            }

            @Override
            public NodeMetaData fromXContent(XContentParser parser) throws IOException {
                return ((Builder)PARSER.apply(parser, null)).build();
            }
        };
    }

    private static class Builder {
        String nodeId;

        private Builder() {
        }

        public void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        public NodeMetaData build() {
            return new NodeMetaData(this.nodeId);
        }
    }
}

