/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.common;

import java.util.Base64;
import java.util.concurrent.atomic.AtomicInteger;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.MacAddressProvider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.SecureRandomHolder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.UUIDGenerator;

class TimeBasedUUIDGenerator
implements UUIDGenerator {
    private final AtomicInteger sequenceNumber = new AtomicInteger(SecureRandomHolder.INSTANCE.nextInt());
    private long lastTimestamp;
    private static final byte[] SECURE_MUNGED_ADDRESS = MacAddressProvider.getSecureMungedAddress();

    TimeBasedUUIDGenerator() {
    }

    private static void putLong(byte[] array, long l, int pos, int numberOfLongBytes) {
        for (int i = 0; i < numberOfLongBytes; ++i) {
            array[pos + numberOfLongBytes - i - 1] = (byte)(l >>> i * 8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getBase64UUID() {
        int sequenceId = this.sequenceNumber.incrementAndGet() & 0xFFFFFF;
        long timestamp = System.currentTimeMillis();
        TimeBasedUUIDGenerator timeBasedUUIDGenerator = this;
        synchronized (timeBasedUUIDGenerator) {
            timestamp = Math.max(this.lastTimestamp, timestamp);
            if (sequenceId == 0) {
                ++timestamp;
            }
            this.lastTimestamp = timestamp;
        }
        byte[] uuidBytes = new byte[15];
        TimeBasedUUIDGenerator.putLong(uuidBytes, timestamp, 0, 6);
        System.arraycopy(SECURE_MUNGED_ADDRESS, 0, uuidBytes, 6, SECURE_MUNGED_ADDRESS.length);
        TimeBasedUUIDGenerator.putLong(uuidBytes, sequenceId, 12, 3);
        assert (9 + SECURE_MUNGED_ADDRESS.length == uuidBytes.length);
        return Base64.getUrlEncoder().withoutPadding().encodeToString(uuidBytes);
    }

    static {
        assert (SECURE_MUNGED_ADDRESS.length == 6);
    }
}

