/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.BinaryDocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.DocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexReader;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.MultiFields;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.ReaderUtil;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.Terms;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.TermsEnum;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.queries.function.FunctionValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.queries.function.docvalues.IntDocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.queries.function.valuesource.FieldCacheSource;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.BytesRef;

public class JoinDocFreqValueSource
extends FieldCacheSource {
    public static final String NAME = "joindf";
    protected final String qfield;

    public JoinDocFreqValueSource(String field, String qfield) {
        super(field);
        this.qfield = qfield;
    }

    @Override
    public String description() {
        return "joindf(" + this.field + ":(" + this.qfield + "))";
    }

    @Override
    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        final BinaryDocValues terms = DocValues.getBinary(readerContext.reader(), this.field);
        IndexReader top = ReaderUtil.getTopLevelContext(readerContext).reader();
        Terms t = MultiFields.getTerms(top, this.qfield);
        final TermsEnum termsEnum = t == null ? TermsEnum.EMPTY : t.iterator();
        return new IntDocValues(this){

            @Override
            public int intVal(int doc) {
                try {
                    BytesRef term = terms.get(doc);
                    if (termsEnum.seekExact(term)) {
                        return termsEnum.docFreq();
                    }
                    return 0;
                }
                catch (IOException e) {
                    throw new RuntimeException("caught exception in function " + JoinDocFreqValueSource.this.description() + " : doc=" + doc, e);
                }
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (o.getClass() != JoinDocFreqValueSource.class) {
            return false;
        }
        JoinDocFreqValueSource other = (JoinDocFreqValueSource)o;
        if (!this.qfield.equals(other.qfield)) {
            return false;
        }
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        return this.qfield.hashCode() + super.hashCode();
    }
}

