/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.IntToLongFunction;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.codecs.DocValuesConsumer;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.DocValuesWriter;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.FieldInfo;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.NumericDocValuesWriter;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.SegmentWriteState;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.Sorter;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.SortField;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.SortedNumericSortField;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.ArrayUtil;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.Counter;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.RamUsageEstimator;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.packed.PackedLongValues;

class SortedNumericDocValuesWriter
extends DocValuesWriter {
    private PackedLongValues.Builder pending;
    private PackedLongValues.Builder pendingCounts;
    private final Counter iwBytesUsed;
    private long bytesUsed;
    private final FieldInfo fieldInfo;
    private int currentDoc;
    private long[] currentValues = new long[8];
    private int currentUpto = 0;
    private int maxCount = 0;
    PackedLongValues finalValues;
    PackedLongValues finalValueCounts;
    int[] valueStartPtrs;

    public SortedNumericDocValuesWriter(FieldInfo fieldInfo, Counter iwBytesUsed) {
        this.fieldInfo = fieldInfo;
        this.iwBytesUsed = iwBytesUsed;
        this.pending = PackedLongValues.deltaPackedBuilder(0.0f);
        this.pendingCounts = PackedLongValues.deltaPackedBuilder(0.0f);
        this.bytesUsed = this.pending.ramBytesUsed() + this.pendingCounts.ramBytesUsed();
        iwBytesUsed.addAndGet(this.bytesUsed);
    }

    public void addValue(int docID, long value) {
        if (docID != this.currentDoc) {
            this.finishCurrentDoc();
        }
        while (this.currentDoc < docID) {
            this.pendingCounts.add(0L);
            ++this.currentDoc;
        }
        this.addOneValue(value);
        this.updateBytesUsed();
    }

    private void finishCurrentDoc() {
        Arrays.sort(this.currentValues, 0, this.currentUpto);
        for (int i = 0; i < this.currentUpto; ++i) {
            this.pending.add(this.currentValues[i]);
        }
        this.pendingCounts.add(this.currentUpto);
        this.maxCount = Math.max(this.maxCount, this.currentUpto);
        this.currentUpto = 0;
        ++this.currentDoc;
    }

    @Override
    public void finish(int maxDoc) {
        this.finishCurrentDoc();
        for (int i = this.currentDoc; i < maxDoc; ++i) {
            this.pendingCounts.add(0L);
        }
        assert (this.pendingCounts.size() == (long)maxDoc);
        this.finalValues = this.pending.build();
        this.finalValueCounts = this.pendingCounts.build();
    }

    @Override
    Sorter.DocComparator getDocComparator(int numDoc, SortField sortField) throws IOException {
        SortedNumericSortField sf = (SortedNumericSortField)sortField;
        this.valueStartPtrs = new int[numDoc];
        int ptr = 0;
        int doc = 0;
        PackedLongValues.Iterator it = this.finalValueCounts.iterator();
        while (it.hasNext()) {
            this.valueStartPtrs[doc++] = ptr;
            ptr = (int)((long)ptr + it.next());
        }
        IntToLongFunction function = docID -> {
            int count = (int)this.finalValueCounts.get(docID);
            assert (count > 0);
            int start = this.valueStartPtrs[docID];
            switch (sf.getSelector()) {
                case MIN: {
                    return this.finalValues.get(start);
                }
                case MAX: {
                    return this.finalValues.get(start + count - 1);
                }
            }
            throw new IllegalStateException("Should never happen");
        };
        return NumericDocValuesWriter.getDocComparator(sf, sf.getNumericType(), docID -> this.finalValueCounts.get(docID) > 0L, function);
    }

    private void addOneValue(long value) {
        if (this.currentUpto == this.currentValues.length) {
            this.currentValues = ArrayUtil.grow(this.currentValues, this.currentValues.length + 1);
        }
        this.currentValues[this.currentUpto] = value;
        ++this.currentUpto;
    }

    private void updateBytesUsed() {
        long newBytesUsed = this.pending.ramBytesUsed() + this.pendingCounts.ramBytesUsed() + RamUsageEstimator.sizeOf(this.currentValues);
        this.iwBytesUsed.addAndGet(newBytesUsed - this.bytesUsed);
        this.bytesUsed = newBytesUsed;
    }

    @Override
    public void flush(SegmentWriteState state, final Sorter.DocMap sortMap, DocValuesConsumer dvConsumer) throws IOException {
        int maxDoc = state.segmentInfo.maxDoc();
        if (sortMap != null) {
            this.valueStartPtrs = new int[maxDoc];
            int ptr = 0;
            int doc = 0;
            PackedLongValues.Iterator it = this.finalValueCounts.iterator();
            while (it.hasNext()) {
                this.valueStartPtrs[doc++] = ptr;
                ptr = (int)((long)ptr + it.next());
            }
        }
        dvConsumer.addSortedNumericField(this.fieldInfo, new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                if (sortMap == null) {
                    return new CountIterator(SortedNumericDocValuesWriter.this.finalValueCounts);
                }
                return new SortingCountIterator(SortedNumericDocValuesWriter.this.finalValueCounts, sortMap);
            }
        }, new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                if (sortMap == null) {
                    return new ValuesIterator(SortedNumericDocValuesWriter.this.finalValues);
                }
                return new SortingValuesIterator(SortedNumericDocValuesWriter.this.finalValues, SortedNumericDocValuesWriter.this.finalValueCounts, SortedNumericDocValuesWriter.this.maxCount, sortMap, SortedNumericDocValuesWriter.this.valueStartPtrs);
            }
        });
    }

    private static class SortingCountIterator
    implements Iterator<Number> {
        final PackedLongValues counts;
        final Sorter.DocMap sortMap;
        final int size;
        int currentUpto;

        SortingCountIterator(PackedLongValues valueCounts, Sorter.DocMap sortMap) {
            this.counts = valueCounts;
            this.sortMap = sortMap;
            this.size = (int)valueCounts.size();
        }

        @Override
        public boolean hasNext() {
            return this.currentUpto < this.size;
        }

        @Override
        public Number next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int oldUpto = this.sortMap.newToOld(this.currentUpto++);
            return this.counts.get(oldUpto);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class CountIterator
    implements Iterator<Number> {
        final PackedLongValues.Iterator iter;

        CountIterator(PackedLongValues valueCounts) {
            this.iter = valueCounts.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Number next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.iter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class SortingValuesIterator
    implements Iterator<Number> {
        final PackedLongValues values;
        final PackedLongValues counts;
        final Sorter.DocMap sortMap;
        final int[] startPtrs;
        final long numValues;
        long valueUpto;
        final long[] currentDoc;
        int currentDocSize;
        int docUpto;
        int currentLength;

        private SortingValuesIterator(PackedLongValues values, PackedLongValues counts, int maxCount, Sorter.DocMap sortMap, int[] startPtrs) {
            this.values = values;
            this.numValues = values.size();
            this.counts = counts;
            this.sortMap = sortMap;
            this.startPtrs = startPtrs;
            this.currentDoc = new long[maxCount];
        }

        @Override
        public boolean hasNext() {
            return this.valueUpto < this.numValues;
        }

        @Override
        public Number next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            while (this.currentDocSize == this.currentLength) {
                this.currentDocSize = 0;
                int oldUpto = this.sortMap.newToOld(this.docUpto);
                this.currentLength = (int)this.counts.get(oldUpto);
                int start = this.startPtrs[oldUpto];
                for (int i = 0; i < this.currentLength; ++i) {
                    this.currentDoc[i] = this.values.get(start + i);
                }
                ++this.docUpto;
            }
            long value = this.currentDoc[this.currentDocSize];
            ++this.currentDocSize;
            ++this.valueUpto;
            return value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ValuesIterator
    implements Iterator<Number> {
        final PackedLongValues.Iterator iter;

        ValuesIterator(PackedLongValues values) {
            this.iter = values.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Number next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.iter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

