/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.index;

import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.BufferedUpdates;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.FieldInfos;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.SegmentInfo;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.store.Directory;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.store.IOContext;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.InfoStream;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.MutableBits;

public class SegmentWriteState {
    public final InfoStream infoStream;
    public final Directory directory;
    public final SegmentInfo segmentInfo;
    public final FieldInfos fieldInfos;
    public int delCountOnFlush;
    public final BufferedUpdates segUpdates;
    public MutableBits liveDocs;
    public final String segmentSuffix;
    public final IOContext context;

    public SegmentWriteState(InfoStream infoStream, Directory directory, SegmentInfo segmentInfo, FieldInfos fieldInfos, BufferedUpdates segUpdates, IOContext context) {
        this(infoStream, directory, segmentInfo, fieldInfos, segUpdates, context, "");
    }

    public SegmentWriteState(InfoStream infoStream, Directory directory, SegmentInfo segmentInfo, FieldInfos fieldInfos, BufferedUpdates segUpdates, IOContext context, String segmentSuffix) {
        this.infoStream = infoStream;
        this.segUpdates = segUpdates;
        this.directory = directory;
        this.segmentInfo = segmentInfo;
        this.fieldInfos = fieldInfos;
        assert (this.assertSegmentSuffix(segmentSuffix));
        this.segmentSuffix = segmentSuffix;
        this.context = context;
    }

    public SegmentWriteState(SegmentWriteState state, String segmentSuffix) {
        this.infoStream = state.infoStream;
        this.directory = state.directory;
        this.segmentInfo = state.segmentInfo;
        this.fieldInfos = state.fieldInfos;
        this.context = state.context;
        this.segmentSuffix = segmentSuffix;
        this.segUpdates = state.segUpdates;
        this.delCountOnFlush = state.delCountOnFlush;
        this.liveDocs = state.liveDocs;
    }

    private boolean assertSegmentSuffix(String segmentSuffix) {
        assert (segmentSuffix != null);
        if (!segmentSuffix.isEmpty()) {
            int numParts = segmentSuffix.split("_").length;
            if (numParts == 2) {
                return true;
            }
            if (numParts == 1) {
                Long.parseLong(segmentSuffix, 36);
                return true;
            }
            return false;
        }
        return true;
    }
}

