/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.CodecReader;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.DocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexReader;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReader;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.MergeState;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.MultiDocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.MultiReader;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.NumericDocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.SortedDocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.Sorter;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Sort;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.SortField;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.Bits;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.PriorityQueue;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.packed.PackedLongValues;

final class MultiSorter {
    MultiSorter() {
    }

    static MergeState.DocMap[] sort(Sort sort, List<CodecReader> readers) throws IOException {
        SortField[] fields = sort.getSort();
        final CrossReaderComparator[] comparators = new CrossReaderComparator[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            comparators[i] = MultiSorter.getComparator(readers, fields[i]);
        }
        int leafCount = readers.size();
        PriorityQueue<LeafAndDocID> queue = new PriorityQueue<LeafAndDocID>(leafCount){

            @Override
            public boolean lessThan(LeafAndDocID a, LeafAndDocID b) {
                for (int i = 0; i < comparators.length; ++i) {
                    int cmp = comparators[i].compare(a.readerIndex, a.docID, b.readerIndex, b.docID);
                    if (cmp == 0) continue;
                    return cmp < 0;
                }
                if (a.readerIndex != b.readerIndex) {
                    return a.readerIndex < b.readerIndex;
                }
                return a.docID < b.docID;
            }
        };
        PackedLongValues.Builder[] builders = new PackedLongValues.Builder[leafCount];
        for (int i = 0; i < leafCount; ++i) {
            CodecReader reader = readers.get(i);
            queue.add(new LeafAndDocID(i, reader.getLiveDocs(), reader.maxDoc()));
            builders[i] = PackedLongValues.monotonicBuilder(0.0f);
        }
        int mappedDocID = 0;
        int lastReaderIndex = 0;
        boolean isSorted = true;
        while (queue.size() != 0) {
            LeafAndDocID top = (LeafAndDocID)queue.top();
            if (lastReaderIndex > top.readerIndex) {
                isSorted = false;
            }
            lastReaderIndex = top.readerIndex;
            builders[top.readerIndex].add(mappedDocID);
            if (top.liveDocs == null || top.liveDocs.get(top.docID)) {
                ++mappedDocID;
            }
            ++top.docID;
            if (top.docID < top.maxDoc) {
                queue.updateTop();
                continue;
            }
            queue.pop();
        }
        if (isSorted) {
            return null;
        }
        MergeState.DocMap[] docMaps = new MergeState.DocMap[leafCount];
        for (int i = 0; i < leafCount; ++i) {
            final PackedLongValues remapped = builders[i].build();
            final Bits liveDocs = readers.get(i).getLiveDocs();
            docMaps[i] = new MergeState.DocMap(){

                @Override
                public int get(int docID) {
                    if (liveDocs == null || liveDocs.get(docID)) {
                        return (int)remapped.get(docID);
                    }
                    return -1;
                }
            };
        }
        return docMaps;
    }

    private static CrossReaderComparator getComparator(List<CodecReader> readers, SortField sortField) throws IOException {
        final int reverseMul = sortField.getReverse() ? -1 : 1;
        SortField.Type sortType = Sorter.getSortFieldType(sortField);
        switch (sortType) {
            case STRING: {
                MultiReader multiReader = new MultiReader((IndexReader[])readers.toArray(new LeafReader[readers.size()]));
                final int[] docStarts = new int[readers.size() + 1];
                List<LeafReaderContext> leaves = multiReader.leaves();
                SortedDocValues[] leafValues = new SortedDocValues[readers.size()];
                for (int i = 0; i < readers.size(); ++i) {
                    leafValues[i] = Sorter.getOrWrapSorted(readers.get(i), sortField);
                    docStarts[i] = leaves.get((int)i).docBase;
                }
                docStarts[readers.size()] = multiReader.maxDoc();
                final SortedDocValues sorted = MultiDocValues.getSortedValues(multiReader, leafValues, docStarts);
                final int missingOrd = sortField.getMissingValue() == SortField.STRING_LAST ? Integer.MAX_VALUE : Integer.MIN_VALUE;
                return new CrossReaderComparator(){

                    @Override
                    public int compare(int readerIndexA, int docIDA, int readerIndexB, int docIDB) {
                        int ordB;
                        int ordA = sorted.getOrd(docStarts[readerIndexA] + docIDA);
                        if (ordA == -1) {
                            ordA = missingOrd;
                        }
                        if ((ordB = sorted.getOrd(docStarts[readerIndexB] + docIDB)) == -1) {
                            ordB = missingOrd;
                        }
                        return reverseMul * Integer.compare(ordA, ordB);
                    }
                };
            }
            case LONG: {
                final ArrayList<NumericDocValues> values = new ArrayList<NumericDocValues>();
                final ArrayList<Bits> docsWithFields = new ArrayList<Bits>();
                for (CodecReader reader : readers) {
                    values.add(Sorter.getOrWrapNumeric(reader, sortField));
                    docsWithFields.add(DocValues.getDocsWithField(reader, sortField.getField()));
                }
                final Long missingValue = sortField.getMissingValue() != null ? (Long)sortField.getMissingValue() : Long.valueOf(0L);
                return new CrossReaderComparator(){

                    @Override
                    public int compare(int readerIndexA, int docIDA, int readerIndexB, int docIDB) {
                        long valueA = ((Bits)docsWithFields.get(readerIndexA)).get(docIDA) ? ((NumericDocValues)values.get(readerIndexA)).get(docIDA) : missingValue.longValue();
                        long valueB = ((Bits)docsWithFields.get(readerIndexB)).get(docIDB) ? ((NumericDocValues)values.get(readerIndexB)).get(docIDB) : missingValue.longValue();
                        return reverseMul * Long.compare(valueA, valueB);
                    }
                };
            }
            case INT: {
                final ArrayList<NumericDocValues> values = new ArrayList<NumericDocValues>();
                final ArrayList<Bits> docsWithFields = new ArrayList<Bits>();
                for (CodecReader reader : readers) {
                    values.add(Sorter.getOrWrapNumeric(reader, sortField));
                    docsWithFields.add(DocValues.getDocsWithField(reader, sortField.getField()));
                }
                final Integer missingValue = sortField.getMissingValue() != null ? (Integer)sortField.getMissingValue() : Integer.valueOf(0);
                return new CrossReaderComparator(){

                    @Override
                    public int compare(int readerIndexA, int docIDA, int readerIndexB, int docIDB) {
                        int valueA = ((Bits)docsWithFields.get(readerIndexA)).get(docIDA) ? (int)((NumericDocValues)values.get(readerIndexA)).get(docIDA) : missingValue;
                        int valueB = ((Bits)docsWithFields.get(readerIndexB)).get(docIDB) ? (int)((NumericDocValues)values.get(readerIndexB)).get(docIDB) : missingValue;
                        return reverseMul * Integer.compare(valueA, valueB);
                    }
                };
            }
            case DOUBLE: {
                final ArrayList<NumericDocValues> values = new ArrayList<NumericDocValues>();
                final ArrayList<Bits> docsWithFields = new ArrayList<Bits>();
                for (CodecReader reader : readers) {
                    values.add(Sorter.getOrWrapNumeric(reader, sortField));
                    docsWithFields.add(DocValues.getDocsWithField(reader, sortField.getField()));
                }
                final Double missingValue = sortField.getMissingValue() != null ? (Double)sortField.getMissingValue() : Double.valueOf(0.0);
                return new CrossReaderComparator(){

                    @Override
                    public int compare(int readerIndexA, int docIDA, int readerIndexB, int docIDB) {
                        double valueA = ((Bits)docsWithFields.get(readerIndexA)).get(docIDA) ? Double.longBitsToDouble(((NumericDocValues)values.get(readerIndexA)).get(docIDA)) : missingValue;
                        double valueB = ((Bits)docsWithFields.get(readerIndexB)).get(docIDB) ? Double.longBitsToDouble(((NumericDocValues)values.get(readerIndexB)).get(docIDB)) : missingValue;
                        return reverseMul * Double.compare(valueA, valueB);
                    }
                };
            }
            case FLOAT: {
                final ArrayList<NumericDocValues> values = new ArrayList<NumericDocValues>();
                final ArrayList<Bits> docsWithFields = new ArrayList<Bits>();
                for (CodecReader reader : readers) {
                    values.add(Sorter.getOrWrapNumeric(reader, sortField));
                    docsWithFields.add(DocValues.getDocsWithField(reader, sortField.getField()));
                }
                final Float missingValue = sortField.getMissingValue() != null ? (Float)sortField.getMissingValue() : Float.valueOf(0.0f);
                return new CrossReaderComparator(){

                    @Override
                    public int compare(int readerIndexA, int docIDA, int readerIndexB, int docIDB) {
                        float valueA = ((Bits)docsWithFields.get(readerIndexA)).get(docIDA) ? Float.intBitsToFloat((int)((NumericDocValues)values.get(readerIndexA)).get(docIDA)) : missingValue.floatValue();
                        float valueB = ((Bits)docsWithFields.get(readerIndexB)).get(docIDB) ? Float.intBitsToFloat((int)((NumericDocValues)values.get(readerIndexB)).get(docIDB)) : missingValue.floatValue();
                        return reverseMul * Float.compare(valueA, valueB);
                    }
                };
            }
        }
        throw new IllegalArgumentException("unhandled SortField.getType()=" + (Object)((Object)sortField.getType()));
    }

    private static interface CrossReaderComparator {
        public int compare(int var1, int var2, int var3, int var4);
    }

    private static class LeafAndDocID {
        final int readerIndex;
        final Bits liveDocs;
        final int maxDoc;
        int docID;

        public LeafAndDocID(int readerIndex, Bits liveDocs, int maxDoc) {
            this.readerIndex = readerIndex;
            this.liveDocs = liveDocs;
            this.maxDoc = maxDoc;
        }
    }
}

