/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.miscellaneous;

import java.util.Map;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.TokenStream;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.miscellaneous.LimitTokenOffsetFilter;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.util.TokenFilterFactory;

public class LimitTokenOffsetFilterFactory
extends TokenFilterFactory {
    public static final String MAX_START_OFFSET = "maxStartOffset";
    public static final String CONSUME_ALL_TOKENS_KEY = "consumeAllTokens";
    private int maxStartOffset;
    private boolean consumeAllTokens;

    public LimitTokenOffsetFilterFactory(Map<String, String> args) {
        super(args);
        this.maxStartOffset = this.requireInt(args, MAX_START_OFFSET);
        this.consumeAllTokens = this.getBoolean(args, CONSUME_ALL_TOKENS_KEY, false);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    @Override
    public TokenStream create(TokenStream input) {
        return new LimitTokenOffsetFilter(input, this.maxStartOffset, this.consumeAllTokens);
    }
}

