import yoda

edges = {
 'd01' : [ 0., 1., 5., 7., 10., 15., 20., 30., 50., 100. ],
 'd02' : [ 0., 1., 5., 7., 10., 15., 20., 30., 50., 100. ],
 'd03' : [ 0., 1., 5., 7., 10., 15., 20., 30., 50., 100. ],
 'd04' : [ 0., 1., 5., 7., 10., 15., 20., 30., 50., 100. ],
 'd05' : [ 0., 1., 5., 7., 10., 15., 20., 30., 50., 100. ],
 'd06' : [ 0., 1., 5., 7., 10., 15., 20., 30., 50., 100. ],
 'd07' : [ 0., 1., 5., 7., 10., 15., 20., 30., 50., 100. ],
 'd08' : [ 0., 1., 5., 7., 10., 15., 20., 30., 50., 100. ],
 'd10' : [ 0.1 ] + yoda.linspace(24, 0.2, 5.0),
 'd11' : yoda.linspace(9, -1.6, 2.0),
 'd12' : yoda.linspace(17, 0.0, 3.4) + [ 3.5 ],
 'd13' : yoda.linspace(17, 0.0, 3.4) + [ 3.5 ],
 'd14' : [ 0.1 ] + yoda.linspace(12, 0.2, 2.6),
 'd15' : [ 0.1 ] + yoda.linspace(12, 0.2, 2.6),
 'd16' : [ 0.1 ] + yoda.linspace(24, 0.2, 5.0),
 'd17' : [ 0.1 ] + yoda.linspace(24, 0.2, 5.0),
}

def patch(path, ao):
    did = ao.name()[:3]
    if did not in edges: return ao
    newao = yoda.Estimate1D(edges[did], path, ao.title())
    newao.setAnnotation('IsRef', 1)
    if 'd0' in path:  newao.maskBin(2)
    newidx = 1
    for b in ao.bins():
        if newao.bin(newidx).isMasked():  newidx += 1
        newao.bin(newidx).setVal(b.val())
        for src in b.sources():
            newao.bin(newidx).setErr(b.err(src), src)
        newidx += 1
    return newao

