// -*- C++ -*-
#include "Rivet/Analysis.hh"
#include "Rivet/Projections/FinalState.hh"


namespace Rivet {


  /// @brief Add a short analysis description here
  class CMD2_2007_I728302 : public Analysis {
  public:

    /// Constructor
    RIVET_DEFAULT_ANALYSIS_CTOR(CMD2_2007_I728302);


    /// @name Analysis methods
    /// @{

    /// Book histograms and initialise projections before the run
    void init() {

      // Initialise and register projections
      declare(FinalState(), "FS");

      // Book histograms
      book(_npion, 2,1,1);
      for (double en : allowedEnergies()) {
        if (isCompatibleWithSqrtS(en)) {
          _sqs = round(en/MeV); break;
        }
      }
      raiseBeamErrorIf(_sqs < 0);
    }


    /// Perform the per-event analysis
    void analyze(const Event& event) {
      const FinalState& fs = apply<FinalState>(event, "FS");
      if (fs.particles().size()!=2) vetoEvent;
      for (const Particle& p : fs.particles()) {
        if (p.abspid() != PID::PIPLUS) vetoEvent;
      }
      _npion->fill(_sqs);
    }


    /// Normalise histograms etc., after the run
    void finalize() {
      scale(_npion, crossSection()/sumOfWeights()/nanobarn);
    }

    /// @}


    /// @name Histograms
    /// @{
    BinnedHistoPtr<int> _npion;
    int _sqs = -1;
    /// @}


  };


  RIVET_DECLARE_PLUGIN(CMD2_2007_I728302);
}
