# syntax=docker/dockerfile:1.4
FROM golang:1.25

ARG TARGETPLATFORM

# related to https://github.com/golangci/golangci-lint/issues/3107
ENV GOROOT /usr/local/go

# Allow to download a more recent version of Go.
# https://go.dev/doc/toolchain
# GOTOOLCHAIN=auto is shorthand for GOTOOLCHAIN=local+auto
ENV GOTOOLCHAIN auto

# Set all directories as safe
RUN git config --global --add safe.directory '*'

COPY $TARGETPLATFORM/golangci-lint /usr/bin/
CMD ["golangci-lint"]
