//////////////////////////////////////////////////////////////////////////////
//                                                                          //
//                  Network Security Analysis Tool                          //
//             rpc.cpp - remote procedure call scanning                     //
//                                                                          //
//   Copyright (C) 1999-2001 by Mixter and 2xs ltd. <mixter@2xs.co.il>      //
//                                                                          //
// This program is free software; you can redistribute it and/or modify     //
// it under the terms of the GNU General Public License as published by     //
// the Free Software Foundation; either version 2 of the License, or        //
// (at your option) any later version.                                      //
//                                                                          //
// This program is distributed in the hope that it will be useful,          //
// but WITHOUT ANY WARRANTY; without even the implied warranty of           //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
// GNU General Public License for more details.                             //
//                                                                          //
// You should have received a copy of the GNU General Public License        //
// along with this program; if not, write to the Free Software              //
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

// rpccheck, check an individual host for the desired rpc services
// by sk8@lucid-solutions.com
// nfsscan() is some eleet jsbach stuff
// added service rpc entries by JimJones [zsh]

#include "../nsat.h"
#include "../services.h"
#define PORTMAP
#include <rpc/rpc.h>
#include <rpc/clnt.h>
#include <rpcsvc/mount.h>
#include <rpc/pmap_prot.h>
#include <rpc/pmap_clnt.h>

extern Logging Logger;
extern ProgressIndicator pi;

void
nfsscan(unsigned long host)
{
  CLIENT *aqua;
  static struct mountbody *exportz = NULL;
  struct timeval timeout;
  struct in_addr x;

  x.s_addr = host;
  aqua = clnt_create(inet_ntoa(x), MOUNTPROG, MOUNTVERS, "tcp");
  if (aqua == NULL)
    return;
  timeout.tv_sec = 3;
  timeout.tv_usec = 31337;
#ifdef DARWIN
#else
  CLNT_CALL((CLIENT *) aqua /* call nfs */ ,
	    (unsigned long) MOUNTPROC_DUMP /* remote procedure */ ,
	    (xdrproc_t) xdr_void /* no input to z function */ ,
	    (caddr_t) NULL /* "" */ ,
	    (xdrproc_t) xdr_void /* local procedure? */ ,
	    (caddr_t) exportz /* out args */ ,
	    (struct timeval) timeout);
#endif

  for (; exportz != NULL; exportz = exportz->ml_next)
    {
      if (strcmp(exportz->ml_hostname, "(anon)") == 0)
	{
          Logger.msg(L_EXPORTS, I_RPC, inet_ntoa(x), "%s %s", I_NFS1, exportz->ml_directory);
	}
      else
	{
          Logger.msg(L_EXPORTS, I_RPC, inet_ntoa(x), "%s %s %s", I_NFS2, exportz->ml_hostname, exportz->ml_directory);
	}
    }

#ifdef DARWIN
#else
  clnt_destroy(aqua);
#endif

  return;
}

struct rpcentry
{
  int program;
  char *info;
  int vuln;
};

struct rpcentry rpcentries[] =
{
  {100013, "3270_mapper", 0},
  {100062, "NETlicense", 0},
  {100109, "activity [SunNet Manager]", 0},
  {100087, "admind", 0},
  {100018, "alis", 0},
  {300019, "amd [amq]", 1},
  {390600, "arserverd [Remedy AR System daemons]", 0},
  {390604, "arservtcd", 0},
  {395176, "aseagent", 0},
  {395175, "asedirector", 0},
  {395177, "asehsm", 0},
  {395179, "aselogger", 0},
  {100099, "autofsd", 0},
  {100026, "bootparamd", 1},
  {300433, "bssd", 0},
  {100071, "bugtraqd", 0},
  {545580417, "bwnfsd", 0},
  {100235, "cachefsd", 0},
  {824395111, "cfsd", 0},
  {1092830567, "cfsd", 0},
  {300527, "cluinfod [Cluster Information Server]", 0},
  {100068, "cmsd [dtcalendar]", 1},
  {300484, "cnxagentd [Cluster Agent]", 0},
  {300483, "cnxmond [Cluster Node Monitor]", 0},
  {100016, "database_svc", 0},
  {100066, "debug_svc [dbsrv]", 0},
  {100105, "diskinfo [SunNet Manager]", 0},
  {300598, "dmispd", 0},
  {805306368, "dmispd", 0},
  {300434, "drdd", 0},
  {100118, "etherif", 0},
  {100135, "etherif2 [SunNet Manager]", 0},
  {100010, "etherstatd", 0},
  {100101, "event [SunNet Manager]", 0},
  {200023, "exportmap", 0},
  {600100069, "fypxfrd [FreeBSD YPXFRd]", 0},
  {100117, "hostif", 0},
  {100112, "hostmem", 0},
  {100136, "hostmem2 [SunNet Manager]", 0},
  {100107, "hostperf", 0},
  {555555555, "inetray", 0},
  {555555556, "inetray", 0},
  {555555557, "inetray", 0},
  {555555558, "inetray", 0},
  {555555559, "inetray", 0},
  {555555560, "inetray", 0},
  {555555554, "inetray.start", 0},
  {100055, "ioadmd", 0},
  {100106, "iostat", 0},
  {100137, "iostat2 [SunNet Manager", 0},
  {100119, "ippath [SunNet Manager]", 0},
  {100120, "iproutes", 0},
  {100221, "kcms", 0},
  {100078, "kerbd [Kerberos]", 0},
  {100029, "keyserv", 0},
  {100121, "layers", 0},
  {100131, "layers2 [SunNet Manager]", 0},
  {100020, "llockmgr", 0},
  {100102, "logger [SunNet Manager]", 0},
  {100111, "lpstat [SunNet Manager]", 0},
  {100229, "metad", 0},
  {100230, "metamhd", 0},
  {100005, "mountd", 1},
  {120126, "nf_snmd [SunNet Manager]", 0},
  {120127, "nf_snmd", 0},
  {100003, "nfs", 1},
  {100227, "nfs_acl", 1},
  {100301, "nis_cache", 0},
  {100302, "nis_callback", 0},
  {100300, "nisd", 1},
  {1073741824, "nisd_resolv", 0},
  {100303, "nispasswd", 0},
  {100021, "nlockmgr", 1},
  {100038, "nsed", 0},
  {100039, "nsemntd", 0},
  {390601, "ntserverd", 0},
  {150001, "pcnfsd", 1},
  {100115, "ping", 0},
  {100000, "portmap", 0},
  {390100, "prestoctl [Prestoserve]", 0},
  {300632, "prpasswd", 0},
  {100017, "rexd", 1},
  {100014, "rje_mapper", 0},
  {100116, "rpcnfs", 0},
  {100011, "rquotad", 1},
  {100001, "rstatd [rstat_svc, rup, perfmeter]", 1},
  {100002, "ruserd", 0},
  {100232, "sadmind", 1},
  {100113, "sample", 0},
  {100019, "sched", 0},
  {805306352, "scopeux [HP measureware scopeUX]", 0},
  {20000777, "seagent [Memco/Platinum/CA SeOS Security Product]", 0},
  {100015, "selection_svc", 0},
  {100139, "sender [Cooperative Consoles]", 0},
  {391021, "sgi.ha_ifa", 0},
  {391019, "sgi.ha_ifmx", 0},
  {391018, "sgi.ha_orcl", 0},
  {391020, "sgi.ha_sybs", 0},
  {391002, "sgi_fam", 0},
  {391015, "sgi_ha_appmon", 0},
  {391013, "sgi_ha_hb [ha_heartbeat, ha_hbeat]", 0},
  {391014, "sgi_ha_nc", 0},
  {391010, "sgi_iphone", 0},
  {391017, "sgi_mediad", 0},
  {391004, "sgi_mountd", 0},
  {391007, "sgi_nfs", 0},
  {391003, "sgi_notepad", 0},
  {391006, "sgi_pcsd", 0},
  {391009, "sgi_pod", 0},
  {391008, "sgi_rfind", 0},
  {391005, "sgi_smtd", 0},
  {391000, "sgi_snoopd", 0},
  {391012, "sgi_testcd", 0},
  {391001, "sgi_toolkitbus", 0},
  {391011, "sgi_videod", 0},
  {391016, "sgi_xfsmd", 0},
  {100043, "showfhd", 0},
  {100122, "snmp [snmp-cmc/synoptics/unisys/utk]", 0},
  {100249, "snmpXdmid", 0},
  {100138, "snmpv2 [SunNet Manager]", 0},
  {100012, "sprayd", 0},
  {100023, "statmon", 0},
  {100024, "status", 1},
  {300009, "stdfm", 0},
  {100065, "sunisamd", 0},
  {100033, "sunlink_mapper", 0},
  {100104, "sync",},
  {100037, "tfsd", 0},
  {100123, "traffic", 0},
  {100083, "ttdbserverd [tooltalk]", 1},
  {1342177279, "ttsession", 0},
  {100233, "ufsd", 0},
  {100008, "walld", 0},
  {100114, "x25", 0},
  {100022, "x25.inr", 0},
  {100007, "ypbind", 0},
  {100009, "yppasswdd", 1},
  {100004, "ypserv", 1},
  {100028, "ypupdated", 1},
  {100069, "ypxfrd", 0},
  {0, "", 0}
};

const char *
vulnstate(int servicenum)
{
  int n;

  for (n = 0; (rpcentries[n].info != "ypxfrd"); n++)
    {
      if (rpcentries[n].program == servicenum)
	{
	  return ((rpcentries[n].vuln) ? M_VULNERABLE : "");
	  break;
	}
    }
  return "";
}

char *
getinfo(int servicenum)
{
  int n;

  for (n = 0; (rpcentries[n].info != ""); n++)
    {
      if (rpcentries[n].program == servicenum)
	{
	  return rpcentries[n].info;
	  break;
	}
    }
  if ((servicenum >= 391022) && (servicenum <= 391063))
    return "sgi_reserved";
  else
    return "";
}

void
rpccheck(char *host)
{
  struct sockaddr_in server_addr;
  struct pmaplist *head = NULL;
  int sockett = RPC_ANYSOCK;
  struct timeval minutetimeout;
  register CLIENT *client;

  server_addr.sin_addr.s_addr = inet_addr(host);
  server_addr.sin_family = AF_INET;
  server_addr.sin_port = htons(PMAPPORT);
  minutetimeout.tv_sec = 5;
  minutetimeout.tv_usec = 0;

  if ((client = clnttcp_create(&server_addr, PMAPPROG, PMAPVERS, &sockett, 50, 500)) == NULL)
    return;
#ifdef DARWIN
#else
  if (clnt_call(client, PMAPPROC_DUMP, (xdrproc_t) xdr_void, NULL, (xdrproc_t) xdr_pmaplist, (char *) &head, minutetimeout) != RPC_SUCCESS)
    return;
#endif

#ifdef DARWIN
#else
  clnt_destroy(client);
#endif

  if (pi.ScanRpc < 3)
    {
      for (; head != NULL; head = head->pml_next)
	{
          Logger.msg(L_RPC, I_RPC, host, "%lu", head->pml_map.pm_prog);
	}
    }
  else
    {
      for (; head != NULL; head = head->pml_next)
	{
          Logger.msg(L_RPC, I_RPC, host, " - %lu\t%lu\t%s\t%u\t%lu\t%s",
	   head->pml_map.pm_prog, head->pml_map.pm_port,
           ((head->pml_map.pm_prot == 6) ? "tcp" : "udp"),
	   head->pml_map.pm_vers, getinfo(head->pml_map.pm_prog),
	   vulnstate(head->pml_map.pm_prog));
	  if ((pi.ScanRpc == 4) && (head->pml_map.pm_prog == R_NFS))
	    nfsscan(server_addr.sin_addr.s_addr);
	}
    }

  return;
}
