//////////////////////////////////////////
//    Network Security Analysis Tool    //
//          (c) 2001 by Mixter          //
//////////////////////////////////////////

// ftp scanner for writable anonymous ftp paths
// written by ben-z & shdwknght

#include "../nsat.h"

extern Logging Logger;
extern ProgressIndicator pi;

#define LOGIN_TIMEOUT 30
#define LIST_TIMEOUT 1500

#define sockw(x) write(fd,x,strlen(x));

int port(int, char *);
int eval_list(char *);

char path[1024];
char path2[1024];
char gdest[128];

int
ftptest(int fd, char *dest)
{
  char buff[1024];
#ifdef DARWIN
  int nl = sizeof(struct sockaddr_in);
#else
  unsigned int nl = sizeof(struct sockaddr_in);
#endif
  FILE *fp;
  struct sockaddr_in sock;
  struct sockaddr_in s;

  getpeername(fd, (struct sockaddr *) &sock, &nl);

  fp = fdopen(fd, "r");

  sockw(FTPUSER);
  sockw(FTPPASS);

  strncpy(gdest, dest, 127);

  do
    {
       if (nread(LOGIN_TIMEOUT,fd,buff,sizeof(buff)-1)<=0)
         break;
       // lets see if it works without this.
       // if (fgets(buff, sizeof(buff), fp) == NULL)
       //  break;
      switch (atoi(strtok(buff, " ")))
	{
	case 530:
	  fclose(fp);
	  return (0);
	  break;
	case 230:
          Logger.msg(L_FTP, I_FTP, gdest, I_ANON);
	  if (pi.ScanFtp > 2)
	    {
	      getsockname(fd, (struct sockaddr *) &s, &nl);
	      port(fd, inet_ntoa(s.sin_addr));
	    }
	  break;
	}
    }
  while (atoi(strtok(buff, " ")) != 230);

  fclose(fp);
  return (0);
}

int
port(int fd, char *h)
{
  int i, sockfd, new_fd;
#ifdef DARWIN
  int sl = sizeof(struct sockaddr_in);
#else
  unsigned int sl = sizeof(struct sockaddr_in);
#endif
  struct sockaddr_in my_addr;
  struct sockaddr_in s;
  struct sockaddr_in their_addr;
  FILE *fp;
  char h2[1024];

  if ((sockfd = socket(PF_INET, SOCK_STREAM, IPPROTO_IP)) == -1)
      return (0);

  bzero(&(my_addr.sin_zero), 8);
  my_addr.sin_family = AF_INET;
  my_addr.sin_port = 0;
  my_addr.sin_addr.s_addr = INADDR_ANY;

  if (bind(sockfd, (struct sockaddr *) &my_addr, sizeof(struct sockaddr)) == -1)
      return (0);

  if (listen(sockfd, 1) == -1)
      return (0);

  getsockname(sockfd, (struct sockaddr *) &s, &sl);

  for (i = 0; i != (int) strlen(h); i++)
    if (h[i] == '.')
      h[i] = ',';

  for (i = 4; htons(i + 1) < ntohs(s.sin_port); i++);

  snprintf(h2, sizeof(h2), "PORT %s,%d,%d\r\n", h, i, ntohs(s.sin_port) - htons(i));

  sockw(h2);
  sockw("LIST -lAR\r\n");

  struct timeval tvv;
  fd_set fds;
  tvv.tv_sec = LOGIN_TIMEOUT;
  tvv.tv_usec = LOGIN_TIMEOUT;
  FD_ZERO(&fds);
  FD_SET(sockfd,&fds);

  if ((select(sockfd+1,&fds,NULL,NULL,&tvv)<=0)||(!FD_ISSET(sockfd,&fds)))
     return -1;

  if ((new_fd = accept(sockfd, (struct sockaddr *) &their_addr, &sl)) == -1)
     return -1;

  fp = fdopen(new_fd, "r");

  if (!fp)
      return (0);

  while (fgets(h2, sizeof(h2), fp) != NULL)
      eval_list(h2);

  sockw("QUIT\r\n");
 
  close(sockfd);
  return (0);
}

int
eval_list(char *l)
{
  char *tmp, *m;

  tmp = l + strlen(l);
  while (*(--tmp) != ' ');
  tmp++;
  m = strtok(l, " ");

  if (m[strlen(m) - 3] == ':')
      snprintf(path, sizeof(path), "%s", strtok(m, ":"));

  snprintf(path2, sizeof(path2), "%s/%s", path, tmp);

  if (m[0] != 'd')
    return (0);

  if (m[strlen(m) - 2] == 'w' && m[strlen(m) - 3] == 'r')
    {
      if (path2[0] == '/')
	{
          Logger.msg(L_FTP, I_FTP, gdest, "%s %s", I_WRITE, path2);
	}
      else
	{
          Logger.msg(L_FTP, I_FTP, gdest, "%s /%s", I_WRITE, path2);
	}
      return (1);
    }

  return (0);
}
