// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/recommendationengine/v1beta1/prediction_service.proto

package recommendationengine

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_struct "github.com/golang/protobuf/ptypes/struct"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for Predict method.
type PredictRequest struct {
	// Required. Full resource name of the format:
	// {name=projects/*/locations/global/catalogs/default_catalog/eventStores/default_event_store/placements/*}
	// The id of the recommendation engine placement. This id is used to identify
	// the set of models that will be used to make the prediction.
	//
	// We currently support three placements with the following IDs by default:
	//
	// * `shopping_cart`: Predicts items frequently bought together with one or
	//   more catalog items in the same shopping session. Commonly displayed after
	//   `add-to-cart` events, on product detail pages, or on the shopping cart
	//   page.
	//
	// * `home_page`: Predicts the next product that a user will most likely
	//   engage with or purchase based on the shopping or viewing history of the
	//   specified `userId` or `visitorId`. For example - Recommendations for you.
	//
	// * `product_detail`: Predicts the next product that a user will most likely
	//   engage with or purchase. The prediction is based on the shopping or
	//   viewing history of the specified `userId` or `visitorId` and its
	//   relevance to a specified `CatalogItem`. Typically used on product detail
	//   pages. For example - More items like this.
	//
	// * `recently_viewed_default`: Returns up to 75 items recently viewed by the
	//   specified `userId` or `visitorId`, most recent ones first. Returns
	//   nothing if neither of them has viewed any items yet. For example -
	//   Recently viewed.
	//
	// The full list of available placements can be seen at
	// https://console.cloud.google.com/recommendation/datafeeds/default_catalog/dashboard
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Context about the user, what they are looking at and what action
	// they took to trigger the predict request. Note that this user event detail
	// won't be ingested to userEvent logs. Thus, a separate userEvent write
	// request is required for event logging.
	UserEvent *UserEvent `protobuf:"bytes,2,opt,name=user_event,json=userEvent,proto3" json:"user_event,omitempty"`
	// Optional. Maximum number of results to return per page. Set this property
	// to the number of prediction results required. If zero, the service will
	// choose a reasonable default.
	PageSize int32 `protobuf:"varint,7,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The previous PredictResponse.next_page_token.
	PageToken string `protobuf:"bytes,8,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filter for restricting prediction results. Accepts values for
	// tags and the `filterOutOfStockItems` flag.
	//
	//  * Tag expressions. Restricts predictions to items that match all of the
	//    specified tags. Boolean operators `OR` and `NOT` are supported if the
	//    expression is enclosed in parentheses, and must be separated from the
	//    tag values by a space. `-"tagA"` is also supported and is equivalent to
	//    `NOT "tagA"`. Tag values must be double quoted UTF-8 encoded strings
	//    with a size limit of 1 KiB.
	//
	//  * filterOutOfStockItems. Restricts predictions to items that do not have a
	//    stockState value of OUT_OF_STOCK.
	//
	// Examples:
	//
	//  * tag=("Red" OR "Blue") tag="New-Arrival" tag=(NOT "promotional")
	//  * filterOutOfStockItems  tag=(-"promotional")
	//  * filterOutOfStockItems
	Filter string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Use dryRun mode for this prediction query. If set to true, a
	// dummy model will be used that returns arbitrary catalog items.
	// Note that the dryRun mode should only be used for testing the API, or if
	// the model is not ready.
	DryRun bool `protobuf:"varint,4,opt,name=dry_run,json=dryRun,proto3" json:"dry_run,omitempty"`
	// Optional. Additional domain specific parameters for the predictions.
	//
	// Allowed values:
	//
	// * `returnCatalogItem`: Boolean. If set to true, the associated catalogItem
	//    object will be returned in the
	//   `PredictResponse.PredictionResult.itemMetadata` object in the method
	//    response.
	// * `returnItemScore`: Boolean. If set to true, the prediction 'score'
	//    corresponding to each returned item will be set in the `metadata`
	//    field in the prediction response. The given 'score' indicates the
	//    probability of an item being clicked/purchased given the user's context
	//    and history.
	Params map[string]*_struct.Value `protobuf:"bytes,6,rep,name=params,proto3" json:"params,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. The labels for the predict request.
	//
	//  * Label keys can contain lowercase letters, digits and hyphens, must start
	//    with a letter, and must end with a letter or digit.
	//  * Non-zero label values can contain lowercase letters, digits and hyphens,
	//    must start with a letter, and must end with a letter or digit.
	//  * No more than 64 labels can be associated with a given request.
	//
	// See https://goo.gl/xmQnxf for more information on and examples of labels.
	Labels               map[string]string `protobuf:"bytes,9,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *PredictRequest) Reset()         { *m = PredictRequest{} }
func (m *PredictRequest) String() string { return proto.CompactTextString(m) }
func (*PredictRequest) ProtoMessage()    {}
func (*PredictRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_73deb4cba861f96f, []int{0}
}

func (m *PredictRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PredictRequest.Unmarshal(m, b)
}
func (m *PredictRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PredictRequest.Marshal(b, m, deterministic)
}
func (m *PredictRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PredictRequest.Merge(m, src)
}
func (m *PredictRequest) XXX_Size() int {
	return xxx_messageInfo_PredictRequest.Size(m)
}
func (m *PredictRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PredictRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PredictRequest proto.InternalMessageInfo

func (m *PredictRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *PredictRequest) GetUserEvent() *UserEvent {
	if m != nil {
		return m.UserEvent
	}
	return nil
}

func (m *PredictRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *PredictRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *PredictRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *PredictRequest) GetDryRun() bool {
	if m != nil {
		return m.DryRun
	}
	return false
}

func (m *PredictRequest) GetParams() map[string]*_struct.Value {
	if m != nil {
		return m.Params
	}
	return nil
}

func (m *PredictRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

// Response message for predict method.
type PredictResponse struct {
	// A list of recommended items. The order represents the ranking (from the
	// most relevant item to the least).
	Results []*PredictResponse_PredictionResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	// A unique recommendation token. This should be included in the user event
	// logs resulting from this recommendation, which enables accurate attribution
	// of recommendation model performance.
	RecommendationToken string `protobuf:"bytes,2,opt,name=recommendation_token,json=recommendationToken,proto3" json:"recommendation_token,omitempty"`
	// IDs of items in the request that were missing from the catalog.
	ItemsMissingInCatalog []string `protobuf:"bytes,3,rep,name=items_missing_in_catalog,json=itemsMissingInCatalog,proto3" json:"items_missing_in_catalog,omitempty"`
	// True if the dryRun property was set in the request.
	DryRun bool `protobuf:"varint,4,opt,name=dry_run,json=dryRun,proto3" json:"dry_run,omitempty"`
	// Additional domain specific prediction response metadata.
	Metadata map[string]*_struct.Value `protobuf:"bytes,5,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// If empty, the list is complete. If nonempty, the token to pass to the next
	// request's PredictRequest.page_token.
	NextPageToken        string   `protobuf:"bytes,6,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PredictResponse) Reset()         { *m = PredictResponse{} }
func (m *PredictResponse) String() string { return proto.CompactTextString(m) }
func (*PredictResponse) ProtoMessage()    {}
func (*PredictResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_73deb4cba861f96f, []int{1}
}

func (m *PredictResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PredictResponse.Unmarshal(m, b)
}
func (m *PredictResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PredictResponse.Marshal(b, m, deterministic)
}
func (m *PredictResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PredictResponse.Merge(m, src)
}
func (m *PredictResponse) XXX_Size() int {
	return xxx_messageInfo_PredictResponse.Size(m)
}
func (m *PredictResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PredictResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PredictResponse proto.InternalMessageInfo

func (m *PredictResponse) GetResults() []*PredictResponse_PredictionResult {
	if m != nil {
		return m.Results
	}
	return nil
}

func (m *PredictResponse) GetRecommendationToken() string {
	if m != nil {
		return m.RecommendationToken
	}
	return ""
}

func (m *PredictResponse) GetItemsMissingInCatalog() []string {
	if m != nil {
		return m.ItemsMissingInCatalog
	}
	return nil
}

func (m *PredictResponse) GetDryRun() bool {
	if m != nil {
		return m.DryRun
	}
	return false
}

func (m *PredictResponse) GetMetadata() map[string]*_struct.Value {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *PredictResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// PredictionResult represents the recommendation prediction results.
type PredictResponse_PredictionResult struct {
	// ID of the recommended catalog item
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Additional item metadata / annotations.
	//
	// Possible values:
	//
	// * `catalogItem`: JSON representation of the catalogItem. Will be set if
	//   `returnCatalogItem` is set to true in `PredictRequest.params`.
	// * `score`: Prediction score in double value. Will be set if
	//   `returnItemScore` is set to true in `PredictRequest.params`.
	ItemMetadata         map[string]*_struct.Value `protobuf:"bytes,2,rep,name=item_metadata,json=itemMetadata,proto3" json:"item_metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *PredictResponse_PredictionResult) Reset()         { *m = PredictResponse_PredictionResult{} }
func (m *PredictResponse_PredictionResult) String() string { return proto.CompactTextString(m) }
func (*PredictResponse_PredictionResult) ProtoMessage()    {}
func (*PredictResponse_PredictionResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_73deb4cba861f96f, []int{1, 0}
}

func (m *PredictResponse_PredictionResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PredictResponse_PredictionResult.Unmarshal(m, b)
}
func (m *PredictResponse_PredictionResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PredictResponse_PredictionResult.Marshal(b, m, deterministic)
}
func (m *PredictResponse_PredictionResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PredictResponse_PredictionResult.Merge(m, src)
}
func (m *PredictResponse_PredictionResult) XXX_Size() int {
	return xxx_messageInfo_PredictResponse_PredictionResult.Size(m)
}
func (m *PredictResponse_PredictionResult) XXX_DiscardUnknown() {
	xxx_messageInfo_PredictResponse_PredictionResult.DiscardUnknown(m)
}

var xxx_messageInfo_PredictResponse_PredictionResult proto.InternalMessageInfo

func (m *PredictResponse_PredictionResult) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *PredictResponse_PredictionResult) GetItemMetadata() map[string]*_struct.Value {
	if m != nil {
		return m.ItemMetadata
	}
	return nil
}

func init() {
	proto.RegisterType((*PredictRequest)(nil), "google.cloud.recommendationengine.v1beta1.PredictRequest")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.recommendationengine.v1beta1.PredictRequest.LabelsEntry")
	proto.RegisterMapType((map[string]*_struct.Value)(nil), "google.cloud.recommendationengine.v1beta1.PredictRequest.ParamsEntry")
	proto.RegisterType((*PredictResponse)(nil), "google.cloud.recommendationengine.v1beta1.PredictResponse")
	proto.RegisterMapType((map[string]*_struct.Value)(nil), "google.cloud.recommendationengine.v1beta1.PredictResponse.MetadataEntry")
	proto.RegisterType((*PredictResponse_PredictionResult)(nil), "google.cloud.recommendationengine.v1beta1.PredictResponse.PredictionResult")
	proto.RegisterMapType((map[string]*_struct.Value)(nil), "google.cloud.recommendationengine.v1beta1.PredictResponse.PredictionResult.ItemMetadataEntry")
}

func init() {
	proto.RegisterFile("google/cloud/recommendationengine/v1beta1/prediction_service.proto", fileDescriptor_73deb4cba861f96f)
}

var fileDescriptor_73deb4cba861f96f = []byte{
	// 866 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x55, 0xdd, 0x6e, 0xdc, 0x44,
	0x14, 0x96, 0xbd, 0xd9, 0x4d, 0x76, 0x42, 0xfa, 0x33, 0x14, 0x62, 0x2d, 0x95, 0x58, 0x2d, 0x12,
	0xda, 0x46, 0xad, 0xad, 0x04, 0x24, 0xa8, 0x11, 0x17, 0x49, 0xb4, 0x82, 0x08, 0x2a, 0x05, 0xa7,
	0xa4, 0x80, 0x52, 0x59, 0xb3, 0xf6, 0x89, 0x33, 0xd4, 0x9e, 0x31, 0x33, 0xe3, 0x0d, 0x29, 0x42,
	0x42, 0x7d, 0x05, 0x1e, 0x00, 0x89, 0x4b, 0x1e, 0xa5, 0x57, 0x08, 0xee, 0xb8, 0x02, 0xc1, 0x15,
	0x4f, 0x81, 0x3c, 0x63, 0x6f, 0xbc, 0x61, 0x2f, 0xb6, 0x69, 0xee, 0x3c, 0xe7, 0xfb, 0xe6, 0xfb,
	0xce, 0x99, 0x39, 0xe3, 0x83, 0x76, 0x12, 0xce, 0x93, 0x14, 0xbc, 0x28, 0xe5, 0x45, 0xec, 0x09,
	0x88, 0x78, 0x96, 0x01, 0x8b, 0x89, 0xa2, 0x9c, 0x01, 0x4b, 0x28, 0x03, 0x6f, 0xb2, 0x39, 0x06,
	0x45, 0x36, 0xbd, 0x5c, 0x40, 0x4c, 0xa3, 0x12, 0x08, 0x25, 0x88, 0x09, 0x8d, 0xc0, 0xcd, 0x05,
	0x57, 0x1c, 0xdf, 0x31, 0x1a, 0xae, 0xd6, 0x70, 0xe7, 0x69, 0xb8, 0x95, 0x46, 0xef, 0x76, 0x65,
	0x47, 0x72, 0xea, 0x11, 0xc6, 0xb8, 0xd2, 0x24, 0x69, 0x84, 0x7a, 0x6f, 0x36, 0xd0, 0x63, 0x0a,
	0x69, 0x1c, 0x8e, 0xe1, 0x84, 0x4c, 0x28, 0x17, 0x15, 0xc1, 0x5f, 0x3c, 0xdb, 0x42, 0x82, 0x08,
	0x61, 0x02, 0x4c, 0x55, 0x7b, 0x6b, 0x6b, 0xbd, 0x1a, 0x17, 0xc7, 0x9e, 0x54, 0xa2, 0x88, 0x6a,
	0x74, 0xbd, 0x61, 0x1d, 0xa5, 0x74, 0xba, 0x6d, 0xf0, 0xc7, 0x12, 0xba, 0xb6, 0x6f, 0x2a, 0x0f,
	0xe0, 0x9b, 0x02, 0xa4, 0xc2, 0xeb, 0x68, 0x89, 0x91, 0x0c, 0x1c, 0xab, 0x6f, 0x0d, 0xbb, 0x3b,
	0xad, 0x3f, 0xb7, 0xed, 0x40, 0x07, 0xf0, 0x17, 0x08, 0x9d, 0xdb, 0x3a, 0x76, 0xdf, 0x1a, 0xae,
	0x6e, 0xbd, 0xeb, 0x2e, 0x7c, 0x3a, 0xee, 0xe7, 0x12, 0xc4, 0xa8, 0xdc, 0x6b, 0x44, 0xbb, 0x45,
	0xbd, 0xc6, 0x7d, 0xd4, 0xcd, 0x49, 0x02, 0xa1, 0xa4, 0x4f, 0xc1, 0x59, 0xee, 0x5b, 0xc3, 0x76,
	0x49, 0xb1, 0x82, 0x95, 0x32, 0x7a, 0x40, 0x9f, 0x02, 0x1e, 0x20, 0xa4, 0x19, 0x8a, 0x3f, 0x01,
	0xe6, 0xac, 0xd4, 0xa9, 0x59, 0x81, 0xde, 0xf8, 0xb0, 0x8c, 0xe2, 0x37, 0x50, 0xe7, 0x98, 0xa6,
	0x0a, 0x84, 0xd3, 0x3a, 0xc7, 0xab, 0x10, 0xbe, 0x8d, 0x96, 0x63, 0x71, 0x16, 0x8a, 0x82, 0x39,
	0x4b, 0x7d, 0x6b, 0xb8, 0x52, 0xa1, 0xb1, 0x38, 0x0b, 0x0a, 0x86, 0xc7, 0xa8, 0x93, 0x13, 0x41,
	0x32, 0xe9, 0x74, 0xfa, 0xad, 0xe1, 0xea, 0xd6, 0xe8, 0x05, 0xca, 0x9a, 0x3d, 0x3e, 0x77, 0x5f,
	0xeb, 0x8c, 0x98, 0x12, 0x67, 0x95, 0x87, 0x51, 0x2e, 0x3d, 0x52, 0x32, 0x86, 0x54, 0x3a, 0xdd,
	0x97, 0xf5, 0xf8, 0x54, 0xeb, 0x34, 0x3d, 0x8c, 0x72, 0xef, 0x33, 0xb4, 0xda, 0xf0, 0xc7, 0x37,
	0x50, 0xeb, 0x09, 0x9c, 0x99, 0x9b, 0x0c, 0xca, 0x4f, 0x7c, 0x17, 0xb5, 0x27, 0x24, 0x2d, 0xa0,
	0xba, 0xbe, 0xd7, 0xeb, 0x1c, 0xea, 0xb6, 0x71, 0x0f, 0x4b, 0x34, 0x30, 0x24, 0xdf, 0x7e, 0xdf,
	0xea, 0xdd, 0x47, 0xab, 0x0d, 0xbb, 0x39, 0x92, 0xb7, 0x9a, 0x92, 0xdd, 0xc6, 0xd6, 0xc1, 0xdf,
	0x6d, 0x74, 0x7d, 0x9a, 0xb9, 0xcc, 0x39, 0x93, 0x80, 0x01, 0x2d, 0x0b, 0x90, 0x45, 0xaa, 0xa4,
	0x63, 0xe9, 0x63, 0xf8, 0xe4, 0x32, 0xc7, 0x60, 0xc4, 0xea, 0x35, 0xe5, 0x2c, 0xd0, 0x9a, 0x41,
	0xad, 0x8d, 0x37, 0xd1, 0xad, 0x59, 0xa5, 0xaa, 0x73, 0x4c, 0x8e, 0xaf, 0xce, 0x62, 0xa6, 0x7d,
	0xde, 0x43, 0x0e, 0x55, 0x90, 0xc9, 0x30, 0xa3, 0x52, 0x52, 0x96, 0x84, 0x94, 0x85, 0x11, 0x51,
	0x24, 0xe5, 0x89, 0xd3, 0xea, 0xb7, 0x86, 0xdd, 0xe0, 0x35, 0x8d, 0x3f, 0x30, 0xf0, 0x1e, 0xdb,
	0x35, 0x20, 0x5e, 0xbf, 0xd0, 0x5a, 0xd3, 0xae, 0x8a, 0xd1, 0x4a, 0x06, 0x8a, 0xc4, 0x44, 0x11,
	0xa7, 0xad, 0x8b, 0xfd, 0xf8, 0x25, 0x8a, 0x7d, 0x50, 0x49, 0xe9, 0x7b, 0x08, 0xa6, 0xca, 0xf8,
	0x6d, 0x74, 0x9d, 0xc1, 0xb7, 0x2a, 0x6c, 0xbc, 0x8f, 0x8e, 0xae, 0x72, 0xad, 0x0c, 0xef, 0xd7,
	0xcf, 0xa3, 0xf7, 0x83, 0x8d, 0x6e, 0x5c, 0x3c, 0x30, 0x7c, 0x0d, 0xd9, 0x34, 0xae, 0x6e, 0xd3,
	0xa6, 0x31, 0x7e, 0x66, 0xa1, 0xb5, 0xb2, 0xca, 0x70, 0x9a, 0xb8, 0xad, 0x13, 0x7f, 0x7c, 0x85,
	0xb7, 0xe4, 0xee, 0x29, 0xc8, 0x66, 0xab, 0x79, 0x85, 0x36, 0x42, 0xbd, 0x47, 0xe8, 0xe6, 0xff,
	0x28, 0x57, 0xd2, 0xcb, 0x07, 0x68, 0xed, 0xca, 0x45, 0xb7, 0x7e, 0xb5, 0xd1, 0xcd, 0xf3, 0x12,
	0x0f, 0xcc, 0xec, 0xc0, 0x7f, 0x59, 0x68, 0xb9, 0x8a, 0xe2, 0xfb, 0x97, 0x7e, 0xe9, 0x3d, 0xff,
	0xf2, 0xe7, 0x3e, 0x08, 0x9f, 0xfd, 0xfe, 0xcf, 0x8f, 0xf6, 0x97, 0x83, 0x87, 0xd3, 0xa9, 0xf1,
	0x5d, 0xf9, 0x1f, 0xff, 0x30, 0x17, 0xfc, 0x6b, 0x88, 0x94, 0xf4, 0x36, 0xbc, 0x94, 0x47, 0x66,
	0x44, 0x79, 0x1b, 0x5e, 0xd5, 0xeb, 0xe5, 0xa7, 0xfe, 0xc3, 0x1f, 0x28, 0x2e, 0xa0, 0x5c, 0xe5,
	0x29, 0x89, 0x20, 0x03, 0x56, 0xee, 0xf8, 0xde, 0xaf, 0xe6, 0xa4, 0x6f, 0x6d, 0xf4, 0x1e, 0x3d,
	0xdf, 0x7e, 0x6b, 0x6e, 0x46, 0x26, 0x67, 0x92, 0x53, 0xe9, 0x46, 0x3c, 0xfb, 0x6d, 0xdb, 0x3d,
	0x51, 0x2a, 0x97, 0xbe, 0xe7, 0x9d, 0x9e, 0x9e, 0x5e, 0x00, 0x3d, 0x52, 0xa8, 0x13, 0x33, 0xf1,
	0xee, 0xe5, 0x29, 0x51, 0xc7, 0x5c, 0x64, 0x3b, 0x3f, 0xd9, 0xe8, 0x5e, 0xc4, 0xb3, 0xc5, 0x6b,
	0xdf, 0xb7, 0xbe, 0x7a, 0x5c, 0x91, 0x13, 0x9e, 0x12, 0x96, 0xb8, 0x5c, 0x24, 0x5e, 0x02, 0x4c,
	0x5f, 0x9b, 0x77, 0x6e, 0xb9, 0xc0, 0x6c, 0xfd, 0x60, 0x1e, 0xf8, 0xb3, 0xdd, 0x0e, 0x46, 0xbb,
	0xdb, 0x7b, 0xbf, 0xd8, 0x77, 0x3e, 0x32, 0x3e, 0xbb, 0x3a, 0xa9, 0x60, 0x86, 0x3b, 0x32, 0x49,
	0x1d, 0x6e, 0xee, 0x94, 0x42, 0xcf, 0x6b, 0xee, 0x91, 0xe6, 0x1e, 0xcd, 0xe3, 0x1e, 0x1d, 0x1a,
	0xd3, 0x7f, 0xed, 0xbb, 0x86, 0xeb, 0xfb, 0x9a, 0xec, 0xfb, 0xf3, 0xd8, 0xbe, 0x5f, 0xd1, 0xc7,
	0x1d, 0x5d, 0xd8, 0x3b, 0xff, 0x05, 0x00, 0x00, 0xff, 0xff, 0xbb, 0xe1, 0x16, 0x95, 0xe1, 0x08,
	0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// PredictionServiceClient is the client API for PredictionService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type PredictionServiceClient interface {
	// Makes a recommendation prediction. If using API Key based authentication,
	// the API Key must be registered using the
	// [PredictionApiKeyRegistry][google.cloud.recommendationengine.v1beta1.PredictionApiKeyRegistry]
	// service. [Learn more](/recommendations-ai/docs/setting-up#register-key).
	Predict(ctx context.Context, in *PredictRequest, opts ...grpc.CallOption) (*PredictResponse, error)
}

type predictionServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewPredictionServiceClient(cc grpc.ClientConnInterface) PredictionServiceClient {
	return &predictionServiceClient{cc}
}

func (c *predictionServiceClient) Predict(ctx context.Context, in *PredictRequest, opts ...grpc.CallOption) (*PredictResponse, error) {
	out := new(PredictResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.recommendationengine.v1beta1.PredictionService/Predict", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PredictionServiceServer is the server API for PredictionService service.
type PredictionServiceServer interface {
	// Makes a recommendation prediction. If using API Key based authentication,
	// the API Key must be registered using the
	// [PredictionApiKeyRegistry][google.cloud.recommendationengine.v1beta1.PredictionApiKeyRegistry]
	// service. [Learn more](/recommendations-ai/docs/setting-up#register-key).
	Predict(context.Context, *PredictRequest) (*PredictResponse, error)
}

// UnimplementedPredictionServiceServer can be embedded to have forward compatible implementations.
type UnimplementedPredictionServiceServer struct {
}

func (*UnimplementedPredictionServiceServer) Predict(ctx context.Context, req *PredictRequest) (*PredictResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Predict not implemented")
}

func RegisterPredictionServiceServer(s *grpc.Server, srv PredictionServiceServer) {
	s.RegisterService(&_PredictionService_serviceDesc, srv)
}

func _PredictionService_Predict_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PredictRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PredictionServiceServer).Predict(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recommendationengine.v1beta1.PredictionService/Predict",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PredictionServiceServer).Predict(ctx, req.(*PredictRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _PredictionService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.recommendationengine.v1beta1.PredictionService",
	HandlerType: (*PredictionServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Predict",
			Handler:    _PredictionService_Predict_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/recommendationengine/v1beta1/prediction_service.proto",
}
