/*********************************************************************
 *
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ===================================================================
 * Revision History ::
 * YYYY.MM.DD   Change ID       Developer
 *              Description
 * -------------------------------------------------------------------
 * 2002.04.25                   Vlad Skarzhevskyy
 *              Initial implementation.
 *
 * ===================================================================
 *
 ********************************************************************/

#include "pure-sfv.h"

int sfvInfoInit(crc_info_type* crc_info)
{
    memset(crc_info, 0, sizeof(crc_info_type));
    crc_info->len = 0;
    crc_info->allocated_len = 0;
    crc_info->items = NULL;
    initCnt(&(crc_info->cnt));
    return 0;
}

int sfvInfoFree(crc_info_type* crc_info)
{
    crc_info->len = 0;
    crc_info->allocated_len = 0;
    free(crc_info->items);
    return 0;
}

int sfvInfoItemNULL(crc_info_item_type* item)
{
    memset(item, 0, sizeof(crc_info_item_type));
    return 0;
}

int sfvInfoAdd(crc_info_type* crc_info, crc_info_item_type* item)
{
    int do_sort = 0;
    int insert_position;
    int idx;

    if (crc_info->items == NULL)
    {
        crc_info->items = (crc_info_item_type *) calloc(SFV_INFO_MEMORY_CHUNKS, sizeof(crc_info_item_type));
        if ((crc_info->items) == NULL)
        {
            fprintf(stderr, "sfv: Error in memory allocation\n");
            return ERROR_MEMORY;
        }
        memset(crc_info->items, 0, SFV_INFO_MEMORY_CHUNKS * sizeof(crc_info_item_type));
        crc_info->allocated_len = SFV_INFO_MEMORY_CHUNKS;
        crc_info->len = 0;
    }
    if (crc_info->allocated_len == crc_info->len + 1)
    {
        DBUG_PRINT("sfvInfoAdd", ("Reallocate the list of pointers"));
        crc_info->items = (crc_info_item_type*) realloc((crc_info->items),
                              (crc_info->allocated_len + SFV_INFO_MEMORY_CHUNKS) * sizeof(crc_info_item_type));
        if ((crc_info->items) == NULL)
        {
            fprintf(stderr, "sfv: Error in memory allocation\n");
            return ERROR_MEMORY;
        }
        memset(&(crc_info->items[crc_info->len + 1]), 0, SFV_INFO_MEMORY_CHUNKS * sizeof(crc_info_item_type));
        crc_info->allocated_len = crc_info->allocated_len + SFV_INFO_MEMORY_CHUNKS;
    }

    makeCleanName(item->file_name, item->file_name_clean);
    getFileExtension(item->file_name, item->ext);

#ifdef SFV_INFO_SORT    
    do_sort = 1;
#endif

    if (!do_sort) {
        memcpy(&(crc_info->items[crc_info->len]), item, sizeof(crc_info_item_type));
        crc_info->len ++;
    } else {
        /* Sort by name */
        insert_position = crc_info->len;
        for (idx = 0; idx < crc_info->len; idx ++) {
            if (strcmp(crc_info->items[idx].file_name_clean, item->file_name_clean) > 0) {
                insert_position = idx;
                break;
            }
        }
        if (insert_position == crc_info->len) {
            memcpy(&(crc_info->items[crc_info->len]), item, sizeof(crc_info_item_type));
        } else {
            for (idx = crc_info->len; idx > insert_position; idx --) {
                memcpy(&(crc_info->items[idx]), &(crc_info->items[idx-1]), sizeof(crc_info_item_type));
            }
            memcpy(&(crc_info->items[insert_position]), item, sizeof(crc_info_item_type));
        }
        crc_info->len ++;
    }
    return 0;
}

/* EOF */

