/*
 * Decompiled with CFR 0.152.
 */
package jalview.analysis;

import jalview.analysis.Cluster;
import jalview.analysis.SequenceIdMatcher;
import jalview.datamodel.AlignmentView;
import jalview.datamodel.CigarArray;
import jalview.datamodel.CigarSimple;
import jalview.datamodel.SeqCigar;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.datamodel.SequenceNode;
import jalview.io.NewickFile;
import jalview.schemes.ResidueProperties;
import jalview.schemes.ScoreMatrix;
import jalview.util.Comparison;
import jalview.util.Format;
import java.util.Vector;

public class NJTree {
    Vector cluster;
    SequenceI[] sequence;
    public AlignmentView seqData = null;
    int[] done;
    int noseqs;
    int noClus;
    float[][] distance;
    int mini;
    int minj;
    float ri;
    float rj;
    Vector groups = new Vector();
    SequenceNode maxdist;
    SequenceNode top;
    float maxDistValue;
    float maxheight;
    int ycount;
    Vector node;
    String type;
    String pwtype;
    Object found = null;
    Object leaves = null;
    boolean hasDistances = true;
    boolean hasBootstrap = false;
    private boolean hasRootDistance = true;

    public NJTree(SequenceI[] seqs, AlignmentView odata, NewickFile treefile) {
        this(seqs, treefile);
        if (odata != null) {
            this.seqData = odata;
        }
    }

    public NJTree(SequenceI[] seqs, NewickFile treefile) {
        this.sequence = seqs;
        this.top = treefile.getTree();
        this.hasDistances = treefile.HasDistances();
        this.hasBootstrap = treefile.HasBootstrap();
        this.hasRootDistance = treefile.HasRootDistance();
        this.maxheight = this.findHeight(this.top);
        SequenceIdMatcher algnIds = new SequenceIdMatcher(seqs);
        Vector leaves = new Vector();
        this.findLeaves(this.top, leaves);
        int i = 0;
        int namesleft = seqs.length;
        Vector<SequenceI> one2many = new Vector<SequenceI>();
        int countOne2Many = 0;
        while (i < leaves.size()) {
            SequenceNode j = (SequenceNode)leaves.elementAt(i++);
            String realnam = j.getName();
            SequenceI nam = null;
            if (namesleft > -1) {
                nam = algnIds.findIdMatch(realnam);
            }
            if (nam != null) {
                j.setElement(nam);
                if (one2many.contains(nam)) {
                    ++countOne2Many;
                    continue;
                }
                one2many.addElement(nam);
                --namesleft;
                continue;
            }
            j.setElement(new Sequence(realnam, "THISISAPLACEHLDER"));
            j.setPlaceholder(true);
        }
    }

    public NJTree(SequenceI[] sequence, AlignmentView seqData, String type, String pwtype, int start, int end) {
        int i;
        this.sequence = sequence;
        this.node = new Vector();
        this.type = type;
        this.pwtype = pwtype;
        if (seqData != null) {
            this.seqData = seqData;
        } else {
            CigarSimple[] seqs = new SeqCigar[sequence.length];
            for (int i2 = 0; i2 < sequence.length; ++i2) {
                seqs[i2] = new SeqCigar(sequence[i2], start, end);
            }
            CigarArray sdata = new CigarArray(seqs);
            sdata.addOperation('M', end - start + 1);
            this.seqData = new AlignmentView(sdata, start);
        }
        if (!type.equals("NJ")) {
            type = "AV";
        }
        if (!pwtype.equals("PID") && ResidueProperties.getScoreMatrix(pwtype) == null) {
            type = "BLOSUM62";
        }
        this.done = new int[sequence.length];
        for (i = 0; i < sequence.length && sequence[i] != null; ++i) {
            this.done[i] = 0;
        }
        this.noseqs = i++;
        this.distance = this.findDistances(this.seqData.getSequenceStrings(" .-".charAt(0)));
        this.makeLeaves();
        this.noClus = this.cluster.size();
        this.cluster();
    }

    public String toString() {
        NewickFile fout = new NewickFile(this.getTopNode());
        return fout.print(false, true);
    }

    public void UpdatePlaceHolders(Vector alignment) {
        Vector leaves = new Vector();
        this.findLeaves(this.top, leaves);
        int sz = leaves.size();
        SequenceIdMatcher seqmatcher = null;
        int i = 0;
        while (i < sz) {
            SequenceI nam;
            SequenceNode leaf;
            if (alignment.contains((leaf = (SequenceNode)leaves.elementAt(i++)).element())) {
                leaf.setPlaceholder(false);
                continue;
            }
            if (seqmatcher == null) {
                SequenceI[] seqs = new SequenceI[alignment.size()];
                for (int j = 0; j < seqs.length; ++j) {
                    seqs[j] = (SequenceI)alignment.elementAt(j);
                }
                seqmatcher = new SequenceIdMatcher(seqs);
            }
            if ((nam = seqmatcher.findIdMatch(leaf.getName())) != null) {
                if (!leaf.isPlaceholder()) {
                    // empty if block
                }
                leaf.setPlaceholder(false);
                leaf.setElement(nam);
                continue;
            }
            if (!leaf.isPlaceholder()) {
                leaf.setElement(new Sequence(leaf.getName(), "THISISAPLACEHLDER"));
            }
            leaf.setPlaceholder(true);
        }
    }

    public void cluster() {
        while (this.noClus > 2) {
            if (this.type.equals("NJ")) {
                this.findMinNJDistance();
            } else {
                this.findMinDistance();
            }
            Cluster c = this.joinClusters(this.mini, this.minj);
            this.done[this.minj] = 1;
            this.cluster.setElementAt(null, this.minj);
            this.cluster.setElementAt(c, this.mini);
            --this.noClus;
        }
        boolean onefound = false;
        int one = -1;
        int two = -1;
        for (int i = 0; i < this.noseqs; ++i) {
            if (this.done[i] == 1) continue;
            if (!onefound) {
                two = i;
                onefound = true;
                continue;
            }
            one = i;
        }
        this.joinClusters(one, two);
        this.top = (SequenceNode)this.node.elementAt(one);
        this.reCount(this.top);
        this.findHeight(this.top);
        this.findMaxDist(this.top);
    }

    public Cluster joinClusters(int i, int j) {
        int ii;
        float dist = this.distance[i][j];
        int noi = ((Cluster)this.cluster.elementAt((int)i)).value.length;
        int noj = ((Cluster)this.cluster.elementAt((int)j)).value.length;
        int[] value = new int[noi + noj];
        for (ii = 0; ii < noi; ++ii) {
            value[ii] = ((Cluster)this.cluster.elementAt((int)i)).value[ii];
        }
        for (ii = noi; ii < noi + noj; ++ii) {
            value[ii] = ((Cluster)this.cluster.elementAt((int)j)).value[ii - noi];
        }
        Cluster c = new Cluster(value);
        this.ri = this.findr(i, j);
        this.rj = this.findr(j, i);
        if (this.type.equals("NJ")) {
            this.findClusterNJDistance(i, j);
        } else {
            this.findClusterDistance(i, j);
        }
        SequenceNode sn = new SequenceNode();
        sn.setLeft((SequenceNode)this.node.elementAt(i));
        sn.setRight((SequenceNode)this.node.elementAt(j));
        SequenceNode tmpi = (SequenceNode)this.node.elementAt(i);
        SequenceNode tmpj = (SequenceNode)this.node.elementAt(j);
        if (this.type.equals("NJ")) {
            this.findNewNJDistances(tmpi, tmpj, dist);
        } else {
            this.findNewDistances(tmpi, tmpj, dist);
        }
        tmpi.setParent(sn);
        tmpj.setParent(sn);
        this.node.setElementAt(sn, i);
        return c;
    }

    public void findNewNJDistances(SequenceNode tmpi, SequenceNode tmpj, float dist) {
        tmpi.dist = (dist + this.ri - this.rj) / 2.0f;
        tmpj.dist = dist - tmpi.dist;
        if (tmpi.dist < 0.0f) {
            tmpi.dist = 0.0f;
        }
        if (tmpj.dist < 0.0f) {
            tmpj.dist = 0.0f;
        }
    }

    public void findNewDistances(SequenceNode tmpi, SequenceNode tmpj, float dist) {
        float ih = 0.0f;
        float jh = 0.0f;
        SequenceNode snj = tmpj;
        for (SequenceNode sni = tmpi; sni != null; sni = (SequenceNode)sni.left()) {
            ih += sni.dist;
        }
        while (snj != null) {
            jh += snj.dist;
            snj = (SequenceNode)snj.left();
        }
        tmpi.dist = dist / 2.0f - ih;
        tmpj.dist = dist / 2.0f - jh;
    }

    public void findClusterDistance(int i, int j) {
        int noi = ((Cluster)this.cluster.elementAt((int)i)).value.length;
        int noj = ((Cluster)this.cluster.elementAt((int)j)).value.length;
        float[] newdist = new float[this.noseqs];
        for (int l = 0; l < this.noseqs; ++l) {
            newdist[l] = l != i && l != j ? (this.distance[i][l] * (float)noi + this.distance[j][l] * (float)noj) / (float)(noi + noj) : 0.0f;
        }
        for (int ii = 0; ii < this.noseqs; ++ii) {
            this.distance[i][ii] = newdist[ii];
            this.distance[ii][i] = newdist[ii];
        }
    }

    public void findClusterNJDistance(int i, int j) {
        float[] newdist = new float[this.noseqs];
        for (int l = 0; l < this.noseqs; ++l) {
            newdist[l] = l != i && l != j ? (this.distance[i][l] + this.distance[j][l] - this.distance[i][j]) / 2.0f : 0.0f;
        }
        for (int ii = 0; ii < this.noseqs; ++ii) {
            this.distance[i][ii] = newdist[ii];
            this.distance[ii][i] = newdist[ii];
        }
    }

    public float findr(int i, int j) {
        float tmp = 1.0f;
        for (int k = 0; k < this.noseqs; ++k) {
            if (k == i || k == j || this.done[k] == 1) continue;
            tmp += this.distance[i][k];
        }
        if (this.noClus > 2) {
            tmp /= (float)(this.noClus - 2);
        }
        return tmp;
    }

    public float findMinNJDistance() {
        float min = 100000.0f;
        for (int i = 0; i < this.noseqs - 1; ++i) {
            for (int j = i + 1; j < this.noseqs; ++j) {
                float tmp;
                if (this.done[i] == 1 || this.done[j] == 1 || !((tmp = this.distance[i][j] - (this.findr(i, j) + this.findr(j, i))) < min)) continue;
                this.mini = i;
                this.minj = j;
                min = tmp;
            }
        }
        return min;
    }

    public float findMinDistance() {
        float min = 100000.0f;
        for (int i = 0; i < this.noseqs - 1; ++i) {
            for (int j = i + 1; j < this.noseqs; ++j) {
                if (this.done[i] == 1 || this.done[j] == 1 || !(this.distance[i][j] < min)) continue;
                this.mini = i;
                this.minj = j;
                min = this.distance[i][j];
            }
        }
        return min;
    }

    public float[][] findDistances(String[] sequenceString) {
        float[][] distance = new float[this.noseqs][this.noseqs];
        if (this.pwtype.equals("PID")) {
            for (int i = 0; i < this.noseqs - 1; ++i) {
                for (int j = i; j < this.noseqs; ++j) {
                    if (j == i) {
                        distance[i][i] = 0.0f;
                        continue;
                    }
                    distance[i][j] = 100.0f - Comparison.PID(sequenceString[i], sequenceString[j]);
                    distance[j][i] = distance[i][j];
                }
            }
        } else {
            int j;
            int i;
            ScoreMatrix pwmatrix = ResidueProperties.getScoreMatrix(this.pwtype);
            if (pwmatrix == null) {
                pwmatrix = ResidueProperties.getScoreMatrix("BLOSUM62");
            }
            int maxscore = 0;
            int end = sequenceString[0].length();
            for (i = 0; i < this.noseqs - 1; ++i) {
                for (j = i; j < this.noseqs; ++j) {
                    int score = 0;
                    for (int k = 0; k < end; ++k) {
                        try {
                            score += pwmatrix.getPairwiseScore(sequenceString[i].charAt(k), sequenceString[j].charAt(k));
                            continue;
                        }
                        catch (Exception ex) {
                            System.err.println("err creating BLOSUM62 tree");
                            ex.printStackTrace();
                        }
                    }
                    distance[i][j] = score;
                    if (score <= maxscore) continue;
                    maxscore = score;
                }
            }
            for (i = 0; i < this.noseqs - 1; ++i) {
                for (j = i; j < this.noseqs; ++j) {
                    distance[i][j] = (float)maxscore - distance[i][j];
                    distance[j][i] = distance[i][j];
                }
            }
        }
        return distance;
    }

    public void makeLeaves() {
        this.cluster = new Vector();
        int i = 0;
        while (i < this.noseqs) {
            SequenceNode sn = new SequenceNode();
            sn.setElement(this.sequence[i]);
            sn.setName(this.sequence[i].getName());
            this.node.addElement(sn);
            int[] value = new int[]{i++};
            Cluster c = new Cluster(value);
            this.cluster.addElement(c);
        }
    }

    public Vector findLeaves(SequenceNode node, Vector leaves) {
        if (node == null) {
            return leaves;
        }
        if (node.left() == null && node.right() == null) {
            leaves.addElement(node);
            return leaves;
        }
        this.findLeaves((SequenceNode)node.left(), leaves);
        this.findLeaves((SequenceNode)node.right(), leaves);
        return leaves;
    }

    public Object findLeaf(SequenceNode node, int count) {
        this.found = this._findLeaf(node, count);
        return this.found;
    }

    public Object _findLeaf(SequenceNode node, int count) {
        if (node == null) {
            return null;
        }
        if (node.ycount == (float)count) {
            this.found = node.element();
            return this.found;
        }
        this._findLeaf((SequenceNode)node.left(), count);
        this._findLeaf((SequenceNode)node.right(), count);
        return this.found;
    }

    public void printNode(SequenceNode node) {
        if (node == null) {
            return;
        }
        if (node.left() == null && node.right() == null) {
            System.out.println("Leaf = " + ((SequenceI)node.element()).getName());
            System.out.println("Dist " + node.dist);
            System.out.println("Boot " + node.getBootstrap());
        } else {
            System.out.println("Dist " + node.dist);
            this.printNode((SequenceNode)node.left());
            this.printNode((SequenceNode)node.right());
        }
    }

    public void findMaxDist(SequenceNode node) {
        if (node == null) {
            return;
        }
        if (node.left() == null && node.right() == null) {
            float dist = node.dist;
            if (dist > this.maxDistValue) {
                this.maxdist = node;
                this.maxDistValue = dist;
            }
        } else {
            this.findMaxDist((SequenceNode)node.left());
            this.findMaxDist((SequenceNode)node.right());
        }
    }

    public Vector getGroups() {
        return this.groups;
    }

    public float getMaxHeight() {
        return this.maxheight;
    }

    public void groupNodes(SequenceNode node, float threshold) {
        if (node == null) {
            return;
        }
        if (node.height / this.maxheight > threshold) {
            this.groups.addElement(node);
        } else {
            this.groupNodes((SequenceNode)node.left(), threshold);
            this.groupNodes((SequenceNode)node.right(), threshold);
        }
    }

    public float findHeight(SequenceNode node) {
        if (node == null) {
            return this.maxheight;
        }
        if (node.left() == null && node.right() == null) {
            node.height = ((SequenceNode)node.parent()).height + node.dist;
            if (node.height > this.maxheight) {
                return node.height;
            }
            return this.maxheight;
        }
        if (node.parent() != null) {
            node.height = ((SequenceNode)node.parent()).height + node.dist;
        } else {
            this.maxheight = 0.0f;
            node.height = 0.0f;
        }
        this.maxheight = this.findHeight((SequenceNode)node.left());
        this.maxheight = this.findHeight((SequenceNode)node.right());
        return this.maxheight;
    }

    public SequenceNode reRoot() {
        if (this.maxdist != null) {
            this.ycount = 0;
            float tmpdist = this.maxdist.dist;
            SequenceNode sn = new SequenceNode();
            sn.setParent(null);
            SequenceNode snr = (SequenceNode)this.maxdist.parent();
            this.changeDirection(snr, this.maxdist);
            System.out.println("Printing reversed tree");
            this.printN(snr);
            snr.dist = tmpdist / 2.0f;
            this.maxdist.dist = tmpdist / 2.0f;
            snr.setParent(sn);
            this.maxdist.setParent(sn);
            sn.setRight(snr);
            sn.setLeft(this.maxdist);
            this.top = sn;
            this.ycount = 0;
            this.reCount(this.top);
            this.findHeight(this.top);
        }
        return this.top;
    }

    public boolean hasOriginalSequenceData() {
        return this.seqData != null;
    }

    public String printOriginalSequenceData(char gapChar) {
        if (this.seqData == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        String[] seqdatas = this.seqData.getSequenceStrings(gapChar);
        for (int i = 0; i < seqdatas.length; ++i) {
            sb.append(new Format("%-15s").form(this.sequence[i].getName()));
            sb.append(" " + seqdatas[i] + "\n");
        }
        return sb.toString();
    }

    public void printN(SequenceNode node) {
        if (node == null) {
            return;
        }
        if (node.left() != null && node.right() != null) {
            this.printN((SequenceNode)node.left());
            this.printN((SequenceNode)node.right());
        } else {
            System.out.println(" name = " + ((SequenceI)node.element()).getName());
        }
        System.out.println(" dist = " + node.dist + " " + node.count + " " + node.height);
    }

    public void reCount(SequenceNode node) {
        this.ycount = 0;
        this._reCount(node);
    }

    public void _reCount(SequenceNode node) {
        if (node == null) {
            return;
        }
        if (node.left() != null && node.right() != null) {
            this._reCount((SequenceNode)node.left());
            this._reCount((SequenceNode)node.right());
            SequenceNode l = (SequenceNode)node.left();
            SequenceNode r = (SequenceNode)node.right();
            node.count = l.count + r.count;
            node.ycount = (l.ycount + r.ycount) / 2.0f;
        } else {
            node.count = 1;
            node.ycount = this.ycount++;
        }
    }

    public void swapNodes(SequenceNode node) {
        if (node == null) {
            return;
        }
        SequenceNode tmp = (SequenceNode)node.left();
        node.setLeft(node.right());
        node.setRight(tmp);
    }

    public void changeDirection(SequenceNode node, SequenceNode dir) {
        if (node == null) {
            return;
        }
        if (node.parent() != this.top) {
            this.changeDirection((SequenceNode)node.parent(), node);
            SequenceNode tmp = (SequenceNode)node.parent();
            if (dir == node.left()) {
                node.setParent(dir);
                node.setLeft(tmp);
            } else if (dir == node.right()) {
                node.setParent(dir);
                node.setRight(tmp);
            }
        } else if (dir == node.left()) {
            node.setParent(node.left());
            if (this.top.left() == node) {
                node.setRight(this.top.right());
            } else {
                node.setRight(this.top.left());
            }
        } else {
            node.setParent(node.right());
            if (this.top.left() == node) {
                node.setLeft(this.top.right());
            } else {
                node.setLeft(this.top.left());
            }
        }
    }

    public SequenceNode getMaxDist() {
        return this.maxdist;
    }

    public SequenceNode getTopNode() {
        return this.top;
    }

    public boolean isHasDistances() {
        return this.hasDistances;
    }

    public boolean isHasBootstrap() {
        return this.hasBootstrap;
    }

    public boolean isHasRootDistance() {
        return this.hasRootDistance;
    }
}

