
/*

    battery.h - Header file for battery functions
    Copyright (C) 2002-2004 Mario Pascucci <ilpettegolo (a) yahoo it>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    or
    visit the URL http://www.fsf.org/


*/

/* prevent multiple inclusion */
#ifndef _MP_BATTERY


/* includes limits for path length */
#ifndef PATH_MAX
#include <limits.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif


/* define header ID */
#define _MP_BATTERY


  /* Battery monitor data and configuration vars */
struct battery_monitor {
  int handler;			/* graphic area handler */
  int icon_handler;		/* icons area handler */
  int enable;			/* enabled flag */
  int update_dly;		/* update delay in 2/10 sec */
  int anim_dly;			/* animation rate in 2/10 sec */
  int ac_line_status;		/* ac adapter status (plugged or not) */
  int battery_status;		/* charging, in use, unknown */
  int battery_percentage;	/* charge left */
  char acpi_info[PATH_MAX+1];	/* ACPI battery info file (/proc/acpi/battery/BATn/info) */
  char acpi_status[PATH_MAX+1];	/* ACPI battery status file (/proc/acpi/battery/BATn/state) */
  int battery_mode;		/* Battery poll mode: ACPI or APM */
  char norm_color[30];		/* color for normal charge level */
  char low_color[30];		/* color for low charge level */
  int xb,yb,wb,hb;		/* size and position of charge histogram */
  int xi,yi,wi,hi;		/* size and position for icons */
  int acindex, battindex, battanim;	/* icon indexes for AC, battery and charge animation */
  int percent;			/* battery low percent */
};
  
/* header definitions starts here */

/* reads power and battery status from /proc/apm */ 
void batt_update(struct battery_monitor *bm);

/* reads (badly) the acpi status for the battery BAT0 */
void batt_update_acpi(struct battery_monitor *bm);

/* set size for battery charge histogram */
int batt_size(struct battery_monitor *bm);

/* set size for power status icons (battery and line icons)
 * minimum size for icons is 10*6 pixels */
int batt_icon_size(struct battery_monitor *bm);

/* draw battery histogram */
void batt_draw(struct battery_monitor *bm);

/* draw icon battery */
void batt_icon_draw(struct battery_monitor *bm);

#ifdef __cplusplus
}
#endif

#endif /* _MP_BATTERY */


