/*
 * libwlembed - a Wayland embedded compositor library
 *
 * Copyright (C) 2023-2024 Brian J. Tarricone <brian@tarricone.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef __WLE_PRODUCES_SERIALS__
#define __WLE_PRODUCES_SERIALS__

#include <glib-object.h>
#include <stdint.h>

G_BEGIN_DECLS

typedef struct _WleProducesSerialsInterface WleProducesSerialsIface;

G_DECLARE_INTERFACE(WleProducesSerials, wle_produces_serials, WLE, PRODUCES_SERIALS, GObject)
#define WLE_TYPE_PRODUCES_SERIALS (wle_produces_serials_get_type())

struct _WleProducesSerialsInterface {
    GTypeInterface iface;
};

void wle_produces_serials_new_serial(WleProducesSerials *producer,
                                     uint32_t serial);

G_END_DECLS

#endif /* __WLE_PRODUCES_SERIALS__ */
