// Copyright 2019 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.12.3
// source: google/cloud/vision/v1p4beta1/face.proto

package vision

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Parameters for a celebrity recognition request.
type FaceRecognitionParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource names for one or more
	// [CelebritySet][google.cloud.vision.v1p4beta1.CelebritySet]s. A celebrity
	// set is preloaded and can be specified as "builtin/default". If this is
	// specified, the algorithm will try to match the faces detected in the input
	// image to the Celebrities in the CelebritySets.
	CelebritySet []string `protobuf:"bytes,1,rep,name=celebrity_set,json=celebritySet,proto3" json:"celebrity_set,omitempty"`
}

func (x *FaceRecognitionParams) Reset() {
	*x = FaceRecognitionParams{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1p4beta1_face_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FaceRecognitionParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FaceRecognitionParams) ProtoMessage() {}

func (x *FaceRecognitionParams) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1p4beta1_face_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FaceRecognitionParams.ProtoReflect.Descriptor instead.
func (*FaceRecognitionParams) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1p4beta1_face_proto_rawDescGZIP(), []int{0}
}

func (x *FaceRecognitionParams) GetCelebritySet() []string {
	if x != nil {
		return x.CelebritySet
	}
	return nil
}

// A Celebrity is a group of Faces with an identity.
type Celebrity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the preloaded Celebrity. Has the format
	// `builtin/{mid}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The Celebrity's display name.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The Celebrity's description.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *Celebrity) Reset() {
	*x = Celebrity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1p4beta1_face_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Celebrity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Celebrity) ProtoMessage() {}

func (x *Celebrity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1p4beta1_face_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Celebrity.ProtoReflect.Descriptor instead.
func (*Celebrity) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1p4beta1_face_proto_rawDescGZIP(), []int{1}
}

func (x *Celebrity) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Celebrity) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Celebrity) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

// Information about a face's identity.
type FaceRecognitionResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The [Celebrity][google.cloud.vision.v1p4beta1.Celebrity] that this face was
	// matched to.
	Celebrity *Celebrity `protobuf:"bytes,1,opt,name=celebrity,proto3" json:"celebrity,omitempty"`
	// Recognition confidence. Range [0, 1].
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
}

func (x *FaceRecognitionResult) Reset() {
	*x = FaceRecognitionResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1p4beta1_face_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FaceRecognitionResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FaceRecognitionResult) ProtoMessage() {}

func (x *FaceRecognitionResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1p4beta1_face_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FaceRecognitionResult.ProtoReflect.Descriptor instead.
func (*FaceRecognitionResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1p4beta1_face_proto_rawDescGZIP(), []int{2}
}

func (x *FaceRecognitionResult) GetCelebrity() *Celebrity {
	if x != nil {
		return x.Celebrity
	}
	return nil
}

func (x *FaceRecognitionResult) GetConfidence() float32 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

var File_google_cloud_vision_v1p4beta1_face_proto protoreflect.FileDescriptor

var file_google_cloud_vision_v1p4beta1_face_proto_rawDesc = []byte{
	0x0a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x31, 0x70, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x66, 0x61, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1d, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x70, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x31, 0x70,
	0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x67, 0x65, 0x6f, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x3c, 0x0a, 0x15, 0x46, 0x61, 0x63, 0x65, 0x52, 0x65, 0x63,
	0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x23,
	0x0a, 0x0d, 0x63, 0x65, 0x6c, 0x65, 0x62, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x73, 0x65, 0x74, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x65, 0x6c, 0x65, 0x62, 0x72, 0x69, 0x74, 0x79,
	0x53, 0x65, 0x74, 0x22, 0x64, 0x0a, 0x09, 0x43, 0x65, 0x6c, 0x65, 0x62, 0x72, 0x69, 0x74, 0x79,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7f, 0x0a, 0x15, 0x46, 0x61, 0x63,
	0x65, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x12, 0x46, 0x0a, 0x09, 0x63, 0x65, 0x6c, 0x65, 0x62, 0x72, 0x69, 0x74, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x70, 0x34,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x65, 0x6c, 0x65, 0x62, 0x72, 0x69, 0x74, 0x79, 0x52,
	0x09, 0x63, 0x65, 0x6c, 0x65, 0x62, 0x72, 0x69, 0x74, 0x79, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0a,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x42, 0x84, 0x01, 0x0a, 0x21, 0x63,
	0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x70, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x42, 0x0e, 0x43, 0x65, 0x6c, 0x65, 0x62, 0x72, 0x69, 0x74, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x43, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e,
	0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x31, 0x70, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x3b, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0xf8, 0x01, 0x01, 0xa2, 0x02, 0x04, 0x47, 0x43, 0x56,
	0x4e, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_vision_v1p4beta1_face_proto_rawDescOnce sync.Once
	file_google_cloud_vision_v1p4beta1_face_proto_rawDescData = file_google_cloud_vision_v1p4beta1_face_proto_rawDesc
)

func file_google_cloud_vision_v1p4beta1_face_proto_rawDescGZIP() []byte {
	file_google_cloud_vision_v1p4beta1_face_proto_rawDescOnce.Do(func() {
		file_google_cloud_vision_v1p4beta1_face_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_vision_v1p4beta1_face_proto_rawDescData)
	})
	return file_google_cloud_vision_v1p4beta1_face_proto_rawDescData
}

var file_google_cloud_vision_v1p4beta1_face_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_google_cloud_vision_v1p4beta1_face_proto_goTypes = []interface{}{
	(*FaceRecognitionParams)(nil), // 0: google.cloud.vision.v1p4beta1.FaceRecognitionParams
	(*Celebrity)(nil),             // 1: google.cloud.vision.v1p4beta1.Celebrity
	(*FaceRecognitionResult)(nil), // 2: google.cloud.vision.v1p4beta1.FaceRecognitionResult
}
var file_google_cloud_vision_v1p4beta1_face_proto_depIdxs = []int32{
	1, // 0: google.cloud.vision.v1p4beta1.FaceRecognitionResult.celebrity:type_name -> google.cloud.vision.v1p4beta1.Celebrity
	1, // [1:1] is the sub-list for method output_type
	1, // [1:1] is the sub-list for method input_type
	1, // [1:1] is the sub-list for extension type_name
	1, // [1:1] is the sub-list for extension extendee
	0, // [0:1] is the sub-list for field type_name
}

func init() { file_google_cloud_vision_v1p4beta1_face_proto_init() }
func file_google_cloud_vision_v1p4beta1_face_proto_init() {
	if File_google_cloud_vision_v1p4beta1_face_proto != nil {
		return
	}
	file_google_cloud_vision_v1p4beta1_geometry_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_vision_v1p4beta1_face_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FaceRecognitionParams); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1p4beta1_face_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Celebrity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1p4beta1_face_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FaceRecognitionResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_vision_v1p4beta1_face_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_vision_v1p4beta1_face_proto_goTypes,
		DependencyIndexes: file_google_cloud_vision_v1p4beta1_face_proto_depIdxs,
		MessageInfos:      file_google_cloud_vision_v1p4beta1_face_proto_msgTypes,
	}.Build()
	File_google_cloud_vision_v1p4beta1_face_proto = out.File
	file_google_cloud_vision_v1p4beta1_face_proto_rawDesc = nil
	file_google_cloud_vision_v1p4beta1_face_proto_goTypes = nil
	file_google_cloud_vision_v1p4beta1_face_proto_depIdxs = nil
}
