/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.installer.LoggedInputStream;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class WebAccessor {
    private Thread openerThread = null;
    private InputStream iStream = null;
    private Exception exception = null;
    private Object soloCancelOption = null;
    private Component parent = null;
    private JDialog dialog = null;
    private boolean tryProxy = false;
    private JPanel passwordPanel = null;
    private JLabel promptLabel;
    private JTextField nameField;
    private JPasswordField passField;
    private JPanel proxyPanel = null;
    private JLabel errorLabel;
    private JTextField hostField;
    private JTextField portField;
    private String url;
    private int contentLength = -1;

    public WebAccessor() {
        throw new UnsupportedOperationException();
    }

    public WebAccessor(Component component) {
        this.parent = component;
        Locale locale = null;
        if (component != null) {
            component.getLocale();
        }
        this.soloCancelOption = UIManager.get("OptionPane.cancelButtonText", locale);
        Authenticator.setDefault(new MyDialogAuthenticator());
    }

    public InputStream openInputStream(URL uRL) {
        this.setUrl(uRL.toExternalForm());
        block6: while (true) {
            int n;
            this.startOpening(uRL);
            Thread.yield();
            int n2 = 28;
            while (this.exception == null && this.iStream == null && n2 > 0) {
                try {
                    Thread.sleep(200L);
                    --n2;
                }
                catch (Exception exception) {
                    System.out.println("In openInputStream: " + exception);
                }
            }
            if (this.iStream != null || !this.tryProxy) break;
            JPanel jPanel = this.getProxyPanel();
            this.errorLabel.setText("Unable to connect: " + this.exception.getMessage());
            while ((n = JOptionPane.showConfirmDialog(this.parent, jPanel, "Proxy Configuration", 2, 3)) == 0) {
                String string = null;
                String string2 = null;
                try {
                    InetAddress inetAddress = InetAddress.getByName(this.hostField.getText());
                    string = inetAddress.getHostName();
                }
                catch (Exception exception) {
                    this.errorLabel.setText("Unable to resolve Host");
                    Toolkit.getDefaultToolkit().beep();
                }
                try {
                    if (string != null) {
                        string2 = Integer.valueOf(this.portField.getText()).toString();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.errorLabel.setText("Invalid Port");
                    Toolkit.getDefaultToolkit().beep();
                }
                if (string == null || string2 == null) continue;
                System.getProperties().put("proxySet", "true");
                System.getProperties().put("proxyHost", string);
                System.getProperties().put("proxyPort", string2);
                continue block6;
            }
            break;
        }
        if (this.iStream == null) {
            this.openerThread.interrupt();
        }
        return this.iStream;
    }

    private void startOpening(final URL uRL) {
        final WebAccessor webAccessor = this;
        this.openerThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                WebAccessor.this.iStream = null;
                try {
                    Object object;
                    WebAccessor.this.tryProxy = false;
                    URLConnection uRLConnection = uRL.openConnection();
                    if (uRLConnection instanceof HttpURLConnection) {
                        object = (HttpURLConnection)uRLConnection;
                        WebAccessor.this.contentLength = ((URLConnection)object).getContentLength();
                    }
                    object = uRLConnection.getInputStream();
                    WebAccessor.this.iStream = new LoggedInputStream((InputStream)object, webAccessor);
                }
                catch (ConnectException connectException) {
                    WebAccessor.this.tryProxy = true;
                    WebAccessor.this.exception = connectException;
                }
                catch (Exception exception) {
                    WebAccessor.this.exception = exception;
                }
                finally {
                    if (WebAccessor.this.dialog != null) {
                        Thread.yield();
                        WebAccessor.this.dialog.setVisible(false);
                    }
                }
            }
        };
        this.openerThread.start();
    }

    private JPanel getProxyPanel() {
        if (this.proxyPanel == null) {
            this.proxyPanel = new JPanel(new BorderLayout(5, 5));
            this.errorLabel = new JLabel();
            JPanel jPanel = new JPanel(new GridLayout(2, 2));
            String string = (String)System.getProperties().get("proxyHost");
            String string2 = (String)System.getProperties().get("proxyPort");
            this.hostField = new JTextField(string != null ? string : "");
            this.portField = new JTextField(string2 != null ? string2 : "");
            JLabel jLabel = new JLabel("Host: ");
            JLabel jLabel2 = new JLabel("Port: ");
            jPanel.add(jLabel);
            jPanel.add(this.hostField);
            jPanel.add(jLabel2);
            jPanel.add(this.portField);
            JLabel jLabel3 = new JLabel("e.g. host=\"gatekeeper.example.com\" port=\"80\"");
            this.proxyPanel.add((Component)this.errorLabel, "North");
            this.proxyPanel.add((Component)jPanel, "Center");
            this.proxyPanel.add((Component)jLabel3, "South");
        }
        this.proxyPanel.validate();
        return this.proxyPanel;
    }

    private JPanel getPasswordPanel() {
        if (this.passwordPanel == null) {
            this.passwordPanel = new JPanel(new BorderLayout(5, 5));
            this.promptLabel = new JLabel();
            JPanel jPanel = new JPanel(new GridLayout(2, 2));
            this.nameField = new JTextField();
            this.passField = new JPasswordField();
            JLabel jLabel = new JLabel("Name: ");
            JLabel jLabel2 = new JLabel("Password: ");
            jPanel.add(jLabel);
            jPanel.add(this.nameField);
            jPanel.add(jLabel2);
            jPanel.add(this.passField);
            this.passwordPanel.add((Component)this.promptLabel, "North");
            this.passwordPanel.add((Component)jPanel, "Center");
        }
        this.passField.setText("");
        return this.passwordPanel;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    private class MyDialogAuthenticator
    extends Authenticator {
        private MyDialogAuthenticator() {
        }

        public PasswordAuthentication getPasswordAuthentication() {
            JPanel jPanel = WebAccessor.this.getPasswordPanel();
            String string = this.getRequestingPrompt();
            InetAddress inetAddress = this.getRequestingSite();
            if (inetAddress != null) {
                string = string + " (" + inetAddress.getHostName() + ")";
            }
            WebAccessor.this.promptLabel.setText(string);
            int n = JOptionPane.showConfirmDialog(WebAccessor.this.parent, jPanel, "Enter Password", 2, 3);
            if (n != 0) {
                return null;
            }
            return new PasswordAuthentication(WebAccessor.this.nameField.getText(), WebAccessor.this.passField.getPassword());
        }
    }
}

