Minutes from OpenVDB TSC meeting, December 19th, 2023

Attendees: *Jeff* L., *Andre* P, *Dan* B., *Ken* M.

Additional Attendees: 

Regrets: *Nick* A., *Rich* J.

Agenda:

1) Confirm quorum
2) Secretary
3) Autodesk VTT
4) Read-Only Grids
5) Half Grid Types
6) Next meeting

------------

1) Confirm quorum

Quorum is present.

2) Secretary

Secretary is Dan Bailey.

3) Autodesk VTT

Potential 9th January meeting to discuss VTT responses with Autodesk. To be
proposed.

NanoVTT is being pitched for integration now, VTT for later. VTT is not being
proposed or considered as a replacement for VDB, will be complementary.

One of the key questions is around GridBase/TreeBase integration. Autodesk
suggests TreeBase will be easier, but it is thought there may have been some
confusion there as GridBase is many fewer methods. Curious to understand the
concern better. The Autodesk response appears to rely on expectation that
integrating greater functionality to the tree/grid classes is desired by TSC,
however worth sharing back that efforts have been underway for years to extract
functionality from the object-oriented hierarchy classes and to move more
towards using free-standing tools. Perhaps a better candidate would be to start
from NanoVTT and work towards making that a canidate for VTT.

Autodesk not opposed to the idea about using VDB transforms. Question over
transforms leads to the assumption that VTT does have transforms but that it
exists at a higher-level than VTT in the BiFrost API. Would be good to confirm
this.

Would like to propose an MVP for VTT in addition to considering NanoVTT.
Candidates are conversion (VDB <-> VTT), serialization, sampling and
re-grading.

Reflecting on NanoVDB experience, one learning is that NanoVDB grids were
originally pitched as read-only, however subsequent realization was that
obtaining the memory layout would allow room for modifying the grid values.
GridHandle is one of the more awkward components of NanoVDB that is simpler in
OpenVDB.

While three of the MVP requirements appear to suggest an ability to pre-allocate
memory, grading is expected to require dynamic memory management in VTT.

4) Read-Only Grids

Question over whether there is value in having a VDB grid that uses contiguous
memory to accelerate performance. Even with an allocator like jemalloc, the
smaller fragments of memory in VDB are a considerable source of slowness.
NanoVDB is a grid with a contiguous block of memory and exists on the host as
well as the device. Limitation is that you cannot deserialize vdb files
directly into NanoVDB grids, you have to go via VDB or use nvdb files.

5) Half Grid Types

Brief discussion of Andre's work adding half grid support. Looking very
promising. Main component missing is VDB I/O which should be alleviated by
registering the VDB half grid type. Worth also adding static asserts to disable
tools that either do not support half grid types or have not yet been tested.

Subsequent discussion around extending the std namespace being UB. Ken points
out that this is already done in the math/Coord around hash usage, this should
be resolved. The approach being taken in this PR is the right approach by using
openvdb::is_floating_point. Will also be needed in the pybind11 functionality
that Matt Cong is working on due to needing to specialize std::is_arithmetic.

6) Next meeting

Next meeting is on January 9th, 2024. Intention is to invite Autodesk. 2pm-3pm
EDT (GMT-4).
