/*
  Copyright (C) 2009, 2010 and 2012 Chris Vine

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#ifndef PREFERENCES_H
#define PREFERENCES_H

#include "prog_defs.h"


#include <gtk/gtk.h>

#include <c++-gtk-utils/window.h>

namespace PreferencesCB {
  extern "C" void preferences_selected(GtkWidget*, void*);
}

class Preferences: public WinBase {
  GtkWidget* beep_button;
  GtkWidget* no_notify_button;
  GtkWidget* dialog_notify_button;
  GtkWidget* lib_notify_button;
  GtkWidget* tray_icon_button;
  GtkWidget* tooltip_button;
  GtkWidget* cancel_button;
  GtkWidget* ok_button;

  void get_prefs();
  void save_prefs() const;
public:
  // Objects of this class are not for copying
  Preferences(const Preferences&) = delete;
  Preferences& operator=(const Preferences&) = delete;

  friend void PreferencesCB::preferences_selected(GtkWidget*, void*);

  bool get_beep() const;
  Error::ReportMode get_error_mode() const;
  bool get_tray_icon() const;
  bool get_tooltip() const;

  Preferences(GtkWindow* parent);
};


#endif
