+++
dep = 9
title = "Alternative Container Image Builders"
authors = [ "Matt Fisher <matt.fisher@microsoft.com>" ]
created = 2018-04-23
+++

# Introduction

This document outlines the general design principles around providing alternative container image builders to Draft.

# What is a Container Image Builder

A Container Image Builder is a tool that builds a container image. A container image is a stand-alone executable package of a piece of software that includes everything needed to run it: code, runtime, system tools, system libraries, and settings.

## Where Container Images fit in with Draft

Draft is a CLI tool built around building container images and running them on Kubernetes, providing the "inner loop" of a developer's workflow with running container images on Kubernetes.

# Architecture

The Draft client interfaces with a container image builder much like how it interacts with Tiller.

Container image builders can be configured either through [draft.toml][dep6] or through `draft config set container-builder mycontainerbuilder`.

When `draft up` is invoked, the configured container image builder is invoked, building the image and pushing it to the container registry configured via `draft config set registry`. It also provides a mechanism to retrieve an auth token for the Kubernetes cluster to fetch that image.

As an example, the default Docker container image builder performs the following:

- logs into the container registry with `docker login`
- builds the container image using `docker build`
- pushes the image to the container registry using `docker push`
- creates an [`imagePullSecret`][] so Kubernetes can pull down the image from the container registry

# Rationale

In its current form, all container image builders are part of Draft and configured through `draft config`. It would be useful in future iterations to break this apart into a [Bridge pattern][], such that each of these container builders can be shipped separately as add-ons for Draft, enabling users to try out different container builders while ensuring Draft's core to remain stable.


[bridge pattern]: https://en.wikipedia.org/wiki/Bridge_pattern
[dep6]: dep-006.md
[`imagePullSecret`]: https://kubernetes.io/docs/tasks/configure-pod-container/pull-image-private-registry/
