/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import java.io.File;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.OutputType;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.util.GFileUtils;

public class OutputDirectoryCreatingTaskExecuter
implements TaskExecuter {
    private static final Logger LOGGER = Logging.getLogger(OutputDirectoryCreatingTaskExecuter.class);
    private final TaskExecuter executer;

    public OutputDirectoryCreatingTaskExecuter(TaskExecuter executer) {
        this.executer = executer;
    }

    @Override
    public void execute(TaskInternal task, TaskStateInternal state, TaskExecutionContext context) {
        for (TaskOutputFilePropertySpec outputProperty : context.getTaskProperties().getOutputFileProperties()) {
            OutputType type = outputProperty.getOutputType();
            for (File output : outputProperty.getPropertyFiles()) {
                OutputDirectoryCreatingTaskExecuter.ensureOutput(outputProperty, output, type);
            }
        }
        this.executer.execute(task, state, context);
    }

    private static void ensureOutput(TaskOutputFilePropertySpec outputProperty, File output, OutputType type) {
        if (output == null) {
            LOGGER.debug("Not ensuring directory exists for property {}, because value is null", (Object)outputProperty);
            return;
        }
        switch (type) {
            case DIRECTORY: {
                LOGGER.debug("Ensuring directory exists for property {} at {}", (Object)outputProperty, (Object)output);
                GFileUtils.mkdirs((File)output);
                break;
            }
            case FILE: {
                LOGGER.debug("Ensuring parent directory exists for property {} at {}", (Object)outputProperty, (Object)output);
                GFileUtils.mkdirs((File)output.getParentFile());
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }
}

