RabbitMQ `3.10.7` is a maintenance release in the `3.10.x` release series.

Please refer to the upgrade section from [v3.10.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.10.0)
if upgrading from a version prior to 3.10.0.

This release requires Erlang 24.x and supports Erlang 25.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on
Erlang version requirements for RabbitMQ.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.10.x/release-notes).


### Core Server

#### Enhancements

 * Classic queue that used CQv2 (2nd generation index and message store) could run into an exception when lazy mode
   was enabled for them.

   GitHub issue: [#5252](https://github.com/rabbitmq/rabbitmq-server/issues/5252)

 * Stream coordinator now handles lots of client connections on a single stream more efficiently.
   Previously its memory footprint was likely to begin creeping up.

   GitHub issue: [#5181](https://github.com/rabbitmq/rabbitmq-server/issues/5181)

 * In environments where DNS resolution is not yet available at the time RabbitMQ nodes boot and try to perform [peer discovery](https://www.rabbitmq.com/cluster-formation.html),
   such as CoreDNS with default caching interval of 30s on Kubernetes, nodes now will retry
   hostname resolution (including of their own host) several times with a wait interval.

   The recommended solution is to [decrease CoreDNS caching interval](https://kubernetes.io/docs/concepts/workloads/controllers/statefulset/#stable-network-id).

   GitHub issue: [#5322](https://github.com/rabbitmq/rabbitmq-server/issues/5322)

 * Free disk space monitoring on Windows was reworked to rely on standard runtime features more instead
   of a 3rd party, closed source `handle.exe`.

   GitHub issues: [#5241](https://github.com/rabbitmq/rabbitmq-server/pull/5241), [#4328](https://github.com/rabbitmq/rabbitmq-server/pull/4328)

#### Bug Fixes

 * Reduce log noise when `sysctl` cannot be accessed by node memory monitor.

   GitHub issue: [#5256](https://github.com/rabbitmq/rabbitmq-server/pull/5256)


### Prometheus Plugin

#### Enhancements

 * Prometheus plugin now exposes one more metric, `process_start_time_seconds`, the moment of node process
   startup in seconds.

   GitHub issue: [#4539](https://github.com/rabbitmq/rabbitmq-server/issues/4539)


### Management Plugin

#### Enhancements

 * Three more security-related response headers now can be set for all HTTP API endpoints:

   * `X-Frame-Options`
   * `X-Xss-Protection`
   * `X-Content-Type-Options`

   ``` ini
   management.headers.content_type_options = nosniff
   management.headers.xss_protection = 1; mode=block
   management.headers.frame_options = DENY
   ```

   This is in addition to the [CSP](https://www.rabbitmq.com/management.html#csp), [HSTS](https://www.rabbitmq.com/management.html#hsts), and [CORS](https://www.rabbitmq.com/management.html#cors) headers:

   ``` ini
   management.hsts.policy = max-age=31536000; includeSubDomains
   management.csp.policy = default-src 'self'; script-src 'self' 'unsafe-eval'

   management.headers.content_type_options = nosniff
   management.headers.xss_protection = 1; mode=block
   management.headers.frame_options = DENY
   ```

   GitHub issue: [#5320](https://github.com/rabbitmq/rabbitmq-server/issues/5320)


## Shovel plugin

### Bug Fixes

 * Shovels now handle consumer delivery timeouts gracefully and restart.

   Contributed by @Haster2004.

   GitHub issue: [#5243](https://github.com/rabbitmq/rabbitmq-server/pull/5243)


## Dependency Upgrades

 *  `osiris` upgraded from [`v1.2.7` to `v1.3.0`](https://github.com/rabbitmq/osiris/compare/v1.2.7...v1.3.0)


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.10.7.tar.xz`
instead of the source tarball produced by GitHub.
