      SUBROUTINE DPCIR2(X1,Y1,X2,Y2,
     1IFIG,
     1ILINPA,ILINCO,PLINTH,
     1AREGBA,
     1IREBLI,IREBCO,PREBTH,
     1IREFSW,IREFCO,
     1IREPTY,IREPLI,IREPCO,PREPTH,PREPSP,
     1PTEXHE,PTEXWI,PTEXVG,PTEXHG)
C
C     PURPOSE--DRAW A CIRCLE
C              WITH ONE END OF THE DIAGONAL AT (X1,Y1)
C              AND THE OTHER END AT (X2,Y2).
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--APRIL     1981.
C     UPDATED         --MAY       1982.
C     UPDATED         --JANUARY   1989.  MODIFY CALLS TO DPDRPL (ALAN)
C     UPDATED         --JANUARY   1989.  MODIFY CALL  TO DPFIRE (ALAN)
C     UPDATED         --FEBRAUARY 1993.  USE EQUIVALENCE
C
C-----NON-COMMON VARIABLES-------------------------------------
C
      CHARACTER*4 IFIG
      CHARACTER*4 IPATT2
C
      CHARACTER*4 ILINPA
      CHARACTER*4 ILINCO
C
      CHARACTER*4 IREBLI
      CHARACTER*4 IREBCO
      CHARACTER*4 IREFSW
      CHARACTER*4 IREFCO
      CHARACTER*4 IREPTY
      CHARACTER*4 IREPLI
      CHARACTER*4 IREPCO
C
      CHARACTER*4 IPATT
      CHARACTER*4 ICOLF
      CHARACTER*4 ICOLP
      CHARACTER*4 ICOL
      CHARACTER*4 IFLAG
C
      DIMENSION PX(1000)
      DIMENSION PY(1000)
CCCCC DIMENSION PX3(1000)
CCCCC DIMENSION PY3(1000)
CCCCC FOLLOWING LINES ADDED FEBRUARY 1994
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCOZZ.INC'
      EQUIVALENCE (GARBAG(1),PX(1))
      EQUIVALENCE (GARBAG(1001),PY(1))
CCCCC END CHANGE
C
      DIMENSION ILINPA(*)
      DIMENSION ILINCO(*)
      DIMENSION PLINTH(*)
C
      DIMENSION AREGBA(*)
      DIMENSION IREBLI(*)
      DIMENSION IREBCO(*)
      DIMENSION PREBTH(*)
      DIMENSION IREFSW(*)
      DIMENSION IREFCO(*)
      DIMENSION IREPTY(*)
      DIMENSION IREPLI(*)
      DIMENSION IREPCO(*)
      DIMENSION PREPTH(*)
      DIMENSION PREPSP(*)
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOGR.INC'
      INCLUDE 'DPCOBE.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'CIR2')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF DPCIR2--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)X1,Y1
   53 FORMAT('X1,Y1 = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)X2,Y2
   54 FORMAT('X2,Y2 = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,59)IFIG
   59 FORMAT('IFIG = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,61)ILINPA(1),ILINCO(1),PLINTH(1)
   61 FORMAT('ILINPA(1),ILINCO(1),PLINTH(1) = ',A4,2X,A4,E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,62)AREGBA(1)
   62 FORMAT('AREGBA(1) = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,63)IREBLI(1),IREBCO(1),PREBTH(1)
   63 FORMAT('IREBLI(1),IREBCO(1),PREBTH(1) = ',A4,2X,A4,E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,64)IREFSW(1),IREFCO(1)
   64 FORMAT('IREFSW(1),IREFCO(1) = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,65)IREPTY(1),IREPLI(1),IREPCO(1),PREPTH(1),PREPSP(1)
   65 FORMAT('IREPTY(1),IREPLI(1),IREPCO(1),PREPTH(1),PREPSP(1) = ',
     1A4,2X,A4,2X,A4,2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,69)PTEXHE,PTEXWI
   69 FORMAT('PTEXHE,PTEXWI= ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,70)PTEXVG,PTEXHG
   70 FORMAT('PTEXVG,PTEXHG= ',2E15.6)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,79)IBUGG4,ISUBG4,IERRG4
   79 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
C               *********************************
C               **  STEP 1--                   **
C               **  DETERMINE THE COORDINATES  **
C               **  FOR THE CIRCLE             **
C               *********************************
C
      RATIHV=ANUMHP/ANUMVP
C
      DELX=X2-X1
      DELY=Y2-Y1
      DELX=ABS(DELX)
      DELY=ABS(DELY)
C
      ALEN=0.0
      TERM=DELX**2+DELY**2
      IF(TERM.GT.0.0)ALEN=SQRT(TERM)
      RADIUS=ALEN/2.0
C
      IF(ABS(DELX).GE.0.00001)THETA=ATAN(DELY/DELX)
      IF(ABS(DELX).LT.0.00001.AND.DELY.GE.0.0)THETA=3.1415926/2.0
      IF(ABS(DELX).LT.0.00001.AND.DELY.LT.0.0)THETA=-3.1415926/2.0
      THETA=0.0
C
      XCENT=(X1+X2)/2.0
      YCENT=(Y1+Y2)/2.0
      X3=XCENT-RADIUS
      Y3=YCENT
C
      K=0
C
      X=0.0
      Y=0.0
      Y=Y*RATIHV
      CALL TRANS(X,Y,X3,Y3,THETA,DELX,DELY,XP,YP,KXP,KYP)
      K=K+1
      PX(K)=XP
      PY(K)=YP
C
      DO3010I=181,541,5
      IREV=541-I+181
      PHI2=IREV-1
      PHI2=PHI2*(2.0*3.1415926)/360.0
      X=RADIUS*COS(PHI2)+RADIUS
      Y=RADIUS*SIN(PHI2)
      Y=Y*RATIHV
      CALL TRANS(X,Y,X3,Y3,THETA,DELX,DELY,XP,YP,KXP,KYP)
      K=K+1
      PX(K)=XP
      PY(K)=YP
 3010 CONTINUE
C
      NP=K
C
C               ***********************
C               **  STEP 2--         **
C               **  FILL THE FIGURE  **
C               **  (IF CALLED FOR)  **
C               ***********************
C
      IF(IREFSW(1).EQ.'OFF')GOTO2190
      IPATT=IREPTY(1)
      IPATT2='SOLI'
      PTHICK=PREPTH(1)
      PXGAP=PREPSP(1)
      PYGAP=PREPSP(1)
      ICOLF=IREFCO(1)
      ICOLP=IREPCO(1)
      CALL DPFIRE(PX,PY,NP,
     1IFIG,IPATT,PTHICK,PXGAP,PYGAP,ICOLF,ICOLP,IPATT2)
 2190 CONTINUE
C
C               ***************************
C               **  STEP 3--             **
C               **  DRAW OUT THE FIGURE  **
C               ***************************
C
      IPATT=ILINPA(1)
      PTHICK=PLINTH(1)
      ICOL=ILINCO(1)
      IFLAG='ON'
CCCCC CALL DPDRPL(PX,PY,NP,PX3,PY3,NP3,
CCCCC1IFIG,IPATT,PTHICK,ICOL)
      CALL DPDRPL(PX,PY,NP,
     1IFIG,IPATT,PTHICK,ICOL,
     1JPATT,JTHICK,PTHIC2,JCOL,IFLAG)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'CIR2')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF DPCIR2--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)DELX,DELY
 9012 FORMAT('DELX,DELY = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)XCENT,YCENT,RADIUS,THETA
 9013 FORMAT('XCENT,YCENT,RADIUS,THETA = ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)NP
 9014 FORMAT('NP = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO9015I=1,NP
      WRITE(ICOUT,9016)I,PX(I),PY(I)
 9016 FORMAT('I,PX(I),PY(I) = ',I8,2E15.7)
      CALL DPWRST('XXX','BUG ')
 9015 CONTINUE
      WRITE(ICOUT,9039)IBUGG4,ISUBG4,IERRG4
 9039 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPCIRC(IHARG,IARGT,ARG,NUMARG,
     1PXSTAR,PYSTAR,
     1PXEND,PYEND,
     1ILINPA,ILINCO,PLINTH,
     1AREGBA,
     1IREBLI,IREBCO,PREBTH,
     1IREFSW,IREFCO,
     1IREPTY,IREPLI,IREPCO,PREPTH,PREPSP,
     1PTEXHE,PTEXWI,PTEXVG,PTEXHG,
     1IGRASW,IDIASW,
     1PGRAXF,PGRAYF,PDIAXC,PDIAYC,PDIAX2,PDIAY2,
     1PDIAHE,PDIAWI,PDIAVG,PDIAHG,
     1NUMDEV,
     1IDMANU,IDMODE,IDMOD2,IDMOD3,
     1IDPOWE,IDCONT,IDCOLO,IDNVPP,IDNHPP,IDUNIT,
     1IDNVOF,IDNHOF,
CCCCC ADD FOLLOWING LINE MARCH 1997.
     1IDFONT,
CCCCC ADD FOLLOWING LINE JULY 1997.
     1UNITSW,
     1IBUGD2,IFOUND,IERROR)
C
C     PURPOSE--DRAW ONE OR MORE CIRCLES
C              (DEPENDING ON HOW MANY NUMBERS ARE PROVIDED).
C              THE COORDINATES ARE IN STANDARDIZED UNITS
C              OF 0 TO 100.
C     NOTE--THE INPUT COORDINATES DEFINE THE ENDS OF THE DIAMETER
C           OF THE CIRCLE.
C     NOTE-THE USUAL INPUT NUMBER OF COORDINATES IS 2
C          AND THEREFORE THE USUAL INPUT NUMBER OF NUMBERS IS 2*2 = 4.
C     NOTE--IF 2 NUMBERS ARE PROVIDED,
C           THEN THE DRAWN CIRCLE WILL GO
C           FROM THE LAST CURSOR POSITION
C           TO THE (X,Y) POINT
C           (EITHER ABSOLUTE OR RELATIVE)
C           AS DEFINED BY THE 2 NUMBERS.
C     NOTE--IF 4 NUMBERS ARE PROVIDED,
C           THEN THE DRAWN CIRCLE WILL GO
C           FROM THE ABSOLUTE (X,Y) POSITION
C           AS DEFINED BY THE FIRST 2 NUMBERS
C           TO THE (X,Y) POINT
C           (EITHER ABSOLUTE OR RELATIVE)
C           AS DEFINED BY THE THIRD AND FOURTH NUMBERS.
C     NOTE--IF 6 NUMBERS ARE PROVIDED,
C           THEN THE DRAWN CIRCLE WILL GO
C           FROM THE (X,Y) POSITION
C           AS RESULTING FROM THE THIRD AND FOURTH NUMBERS
C           TO THE (X,Y) POINT
C           (EITHER ABSOLUTE OR RELATIVE)
C           AS DEFINED BY THE FIFTH AND SIXTH NUMBERS.
C     NOTE--AND SO FORTH FOR 8, 10, 12, ... NUMBERS.
C     INPUT  ARGUMENTS--IHARG
C                     --IARGT
C                     --ARG
C                     --NUMARG
C                     --PXSTAR
C                     --PYSTAR
C     OUTPUT ARGUMENTS--PXEND
C                     --PYEND
C                     --IFOUND ('YES' OR 'NO' )
C                     --IERROR ('YES' OR 'NO' )
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--APRIL     1981.
C     UPDATED         --MARCH     1982.
C     UPDATED         --MAY       1982.
C     UPDATED         --NOVEMBER  1982.
C     UPDATED         --JANUARY   1989.  CALL LIST FOR OFFSET VAR (ALAN)
C     UPDATED         --MARCH     1997.  SUPPORT FOR DEVICE FONT (ALAN)
C     UPDATED         --JULY      1997.  SUPPORT FOR "DATA" UNITS (ALAN)
C
C-----NON-COMMON VARIABLES-----------------------------------------
C
      CHARACTER*4 IHARG
      CHARACTER*4 IARGT
C
      CHARACTER*4 ILINPA
      CHARACTER*4 ILINCO
C
      CHARACTER*4 IREBLI
      CHARACTER*4 IREBCO
      CHARACTER*4 IREFSW
      CHARACTER*4 IREFCO
      CHARACTER*4 IREPTY
      CHARACTER*4 IREPLI
      CHARACTER*4 IREPCO
C
      CHARACTER*4 IGRASW
      CHARACTER*4 IDIASW
C
      CHARACTER*4 IDMANU
      CHARACTER*4 IDMODE
      CHARACTER*4 IDMOD2
      CHARACTER*4 IDMOD3
      CHARACTER*4 IDPOWE
      CHARACTER*4 IDCONT
      CHARACTER*4 IDCOLO
CCCCC ADD FOLLOWING LINE MARCH 1997.
      CHARACTER*4 IDFONT
CCCCC ADD FOLLOWING LINE JULY 1997.
      CHARACTER*4 UNITSW
C
      CHARACTER*4 IFOUND
      CHARACTER*4 IBUGD2
      CHARACTER*4 IERROR
      CHARACTER*4 ISUBRO
C
      CHARACTER*4 IFIG
      CHARACTER*4 IBELSW
      CHARACTER*4 IERASW
      CHARACTER*4 IBACCO
      CHARACTER*4 ICOPSW
      CHARACTER*4 ITYPEO
C
      DIMENSION IHARG(*)
      DIMENSION IARGT(*)
      DIMENSION ARG(*)
C
      DIMENSION ILINPA(*)
      DIMENSION ILINCO(*)
      DIMENSION PLINTH(*)
C
      DIMENSION AREGBA(*)
      DIMENSION IREBLI(*)
      DIMENSION IREBCO(*)
      DIMENSION PREBTH(*)
      DIMENSION IREFSW(*)
      DIMENSION IREFCO(*)
      DIMENSION IREPTY(*)
      DIMENSION IREPLI(*)
      DIMENSION IREPCO(*)
      DIMENSION PREPTH(*)
      DIMENSION PREPSP(*)
C
      DIMENSION IDMANU(*)
      DIMENSION IDMODE(*)
      DIMENSION IDMOD2(*)
      DIMENSION IDMOD3(*)
      DIMENSION IDPOWE(*)
      DIMENSION IDCONT(*)
      DIMENSION IDCOLO(*)
CCCCC ADD FOLLOWING LINE MARCH 1997.
      DIMENSION IDFONT(*)
      DIMENSION IDNVPP(*)
      DIMENSION IDNHPP(*)
      DIMENSION IDUNIT(*)
C
      DIMENSION IDNVOF(*)
      DIMENSION IDNHOF(*)
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOGR.INC'
      INCLUDE 'DPCOBE.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IFOUND='NO'
      IERROR='NO'
      IERRG4=IERROR
CCCCC IBUGG4=IBUGD2
CCCCC ISUBG4=ISUBRO
C
      ILOCFN=0
      NUMNUM=0
C
      X1=0.0
      Y1=0.0
      X2=0.0
      Y2=0.0
C
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'CIRC')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF DPCIRC--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)NUMARG
   53 FORMAT('NUMARG = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO55I=1,NUMARG
      WRITE(ICOUT,56)I,IHARG(I),IARGT(I),ARG(I)
   56 FORMAT('I,IHARG(I),IARGT(I),ARG(I) = ',I8,2X,A4,2X,A4,E15.7)
      CALL DPWRST('XXX','BUG ')
   55 CONTINUE
      WRITE(ICOUT,57)PXSTAR,PYSTAR
   57 FORMAT('PXSTAR,PYSTAR = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,58)PXEND,PYEND
   58 FORMAT('PXEND,PYEND = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,61)ILINPA(1),ILINCO(1),PLINTH(1)
   61 FORMAT('ILINPA(1),ILINCO(1),PLINTH(1) = ',A4,2X,A4,E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,62)AREGBA(1)
   62 FORMAT('AREGBA(1) = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,63)IREBLI(1),IREBCO(1),PREBTH(1)
   63 FORMAT('IREBLI(1),IREBCO(1),PREBTH(1) = ',A4,2X,A4,E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,64)IREFSW(1),IREFCO(1)
   64 FORMAT('IREFSW(1),IREFCO(1) = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,65)IREPTY(1),IREPLI(1),IREPCO(1),PREPTH(1),PREPSP(1)
   65 FORMAT('IREPTY(1),IREPLI(1),IREPCO(1),PREPTH(1),PREPSP(1) = ',
     1A4,2X,A4,2X,A4,2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,69)PTEXHE,PTEXWI
   69 FORMAT('PTEXHE,PTEXWI= ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,70)PTEXVG,PTEXHG
   70 FORMAT('PTEXVG,PTEXHG= ',2E15.6)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,76)IGRASW,IDIASW
   76 FORMAT('IGRASW,IDIASW = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,77)PGRAXF,PGRAYF,PDIAXC,PDIAYC
   77 FORMAT('PGRAXF,PGRAYF,PDIAXC,PDIAYC = ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,78)PDIAHE,PDIAWI,PDIAVG,PDIAHG
   78 FORMAT('PDIAHE,PDIAWI,PDIAVG,PDIAHG = ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,80)NUMDEV
   80 FORMAT('NUMDEV= ',I8)
      CALL DPWRST('XXX','BUG ')
      DO81I=1,NUMDEV
      WRITE(ICOUT,82)IDMANU(I),IDMODE(I),IDMOD2(I),IDMOD3(I)
   82 FORMAT('IDMANU(I),IDMODE(I),IDMOD2(I),IDMOD3(I) = ',
     1A4,2X,A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,83)IDPOWE(I),IDCONT(I),IDCOLO(I)
   83 FORMAT('IDPOWE(I),IDCONT(I),IDCOLO(I) = ',
     1A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,84)IDNVPP(I),IDNHPP(I),IDUNIT(I)
   84 FORMAT('IDNVPP(I),IDNHPP(I),IDUNIT(I) = ',
     1I8,I8,I8)
      CALL DPWRST('XXX','BUG ')
   81 CONTINUE
      WRITE(ICOUT,87)IFOUND
   87 FORMAT('IFOUND= ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,88)IBUGG4,ISUBG4,IERRG4
   88 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,89)IBUGD2,IERROR
   89 FORMAT('IBUGD2,IERROR= ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
      IFIG='CIRC'
      NUMPT=2
      NUMPT2=2*NUMPT
C
C               ********************************
C               **  STEP 0--                  **
C               **  STEP THROUGH EACH DEVICE  **
C               ********************************
C
      IF(NUMDEV.LE.0)GOTO9000
      DO8000IDEVIC=1,NUMDEV
C
      IF(IDPOWE(IDEVIC).EQ.'OFF')GOTO8000
C
      IMANUF=IDMANU(IDEVIC)
      IMODEL=IDMODE(IDEVIC)
      IMODE2=IDMOD2(IDEVIC)
      IMODE3=IDMOD3(IDEVIC)
      IGCONT=IDCONT(IDEVIC)
      IGCOLO=IDCOLO(IDEVIC)
CCCCC ADD FOLLOWING LINE MARCH 1997.
      IGFONT=IDFONT(IDEVIC)
      NUMVPP=IDNVPP(IDEVIC)
      NUMHPP=IDNHPP(IDEVIC)
      ANUMVP=NUMVPP
      ANUMHP=NUMHPP
C  AUGUST 1988.  ADD OFFSET VARIABLE
      IOFFSV=IDNVOF(IDEVIC)
      IOFFSH=IDNHOF(IDEVIC)
C
      IGUNIT=IDUNIT(IDEVIC)
C
C               ************************************
C               **  STEP 1--                      **
C               **  CARRY OUT OPENING OPERATIONS  **
C               **  ON THE GRAPHICS DEVICES       **
C               ************************************
C
      CALL DPOPDE
C
      IBELSW='OFF'
      NUMRIN=0
      IERASW='OFF'
      IBACCO='JUNK'
C
      CALL DPOPPL(IGRASW,
     1IBELSW,NUMRIN,IERASW,
     1IBACCO)
C
C               *****************************************
C               **  STEP 2--                           **
C               **  SEARCH FOR COMMAND SPECIFICATIONS  **
C               *****************************************
C
      IF(NUMARG.GE.2.AND.
     1IARGT(1).EQ.'NUMB'.AND.IARGT(2).EQ.'NUMB')
     1GOTO1111
      IF(NUMARG.GE.3.AND.IHARG(1).EQ.'ABSO'.AND.
     1IARGT(2).EQ.'NUMB'.AND.IARGT(3).EQ.'NUMB')
     1GOTO1112
      IF(NUMARG.GE.3.AND.IHARG(1).EQ.'RELA'.AND.
     1IARGT(2).EQ.'NUMB'.AND.IARGT(3).EQ.'NUMB')
     1GOTO1113
      GOTO1130
C
 1111 CONTINUE
      ITYPEO='ABSO'
      ILOCFN=1
      GOTO1119
C
 1112 CONTINUE
      ITYPEO='ABSO'
      ILOCFN=2
      GOTO1119
C
 1113 CONTINUE
      ITYPEO='RELA'
      ILOCFN=2
      GOTO1119
 1119 CONTINUE
C
      IF(ILOCFN.GT.NUMARG)GOTO1129
      DO1120I=ILOCFN,NUMARG
      IF(IARGT(I).EQ.'NUMB')GOTO1120
      GOTO1129
 1120 CONTINUE
      IFOUND='YES'
      GOTO1149
 1129 CONTINUE
      GOTO1130
C
 1130 CONTINUE
      IERRG4='YES'
      WRITE(ICOUT,1131)
 1131 FORMAT('***** ERROR IN DPCIRC--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1132)
 1132 FORMAT('      ILLEGAL FORM FOR CIRCLE ',
     1'COMMAND.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1134)
 1134 FORMAT('      TEST EXAMPLE TO DEMONSTRATE THE ',
     1'PROPER FORM--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1135)
 1135 FORMAT('      SUPPOSE IT IS DESIRED TO DRAW A CIRCLE ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1136)
 1136 FORMAT('      WITH ONE END OF A DIAGONAL AT 20 20 ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1137)
 1137 FORMAT('      AND THE OTHER END OF THE DIAGONAL AT 40 60,')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1141)
 1141 FORMAT('      THEN ALLOWABLE FORMS ARE--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1142)
 1142 FORMAT('      CIRCLE 20 20 40 60')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1143)
 1143 FORMAT('      CIRCLE ABSOLUTE 20 20 40 60')
      CALL DPWRST('XXX','BUG ')
      GOTO9000
 1149 CONTINUE
C
C               ****************************
C               **  STEP 3--              **
C               **  DRAW OUT THE LINE(S)  **
C               ****************************
C
      NUMNUM=NUMARG-ILOCFN+1
      IF(NUMNUM.LT.NUMPT2)GOTO1151
      GOTO1152
C
 1151 CONTINUE
      J=ILOCFN-1
      X1=PXSTAR
      Y1=PYSTAR
      GOTO1159
C
 1152 CONTINUE
      J=ILOCFN
      IF(J.GT.NUMARG)GOTO1190
      X1=ARG(J)
CCCCC THE FOLLOWING LINE WAS ADDED JULY 1997
      IF(UNITSW.EQ.'DATA')CALL DPCODS('X',X1,X1,IBUGD2,ISUBRO,IERROR)
      J=J+1
      IF(J.GT.NUMARG)GOTO1190
      Y1=ARG(J)
CCCCC THE FOLLOWING LINE WAS ADDED JULY 1997
      IF(UNITSW.EQ.'DATA')CALL DPCODS('Y',Y1,Y1,IBUGD2,ISUBRO,IERROR)
      GOTO1159
C
 1159 CONTINUE
C
 1160 CONTINUE
      J=J+1
      IF(J.GT.NUMARG)GOTO1190
      X2=ARG(J)
CCCCC THE FOLLOWING LINE WAS ADDED JULY 1997
      IF(UNITSW.EQ.'DATA')CALL DPCODS('X',X2,X2,IBUGD2,ISUBRO,IERROR)
      IF(ITYPEO.EQ.'RELA')X2=X1+X2
      J=J+1
      IF(J.GT.NUMARG)GOTO1190
      Y2=ARG(J)
CCCCC THE FOLLOWING LINE WAS ADDED JULY 1997
      IF(UNITSW.EQ.'DATA')CALL DPCODS('Y',Y2,Y2,IBUGD2,ISUBRO,IERROR)
      IF(ITYPEO.EQ.'RELA')Y2=Y1+Y2
C
      CALL DPCIR2(X1,Y1,X2,Y2,
     1IFIG,
     1ILINPA,ILINCO,PLINTH,
     1AREGBA,
     1IREBLI,IREBCO,PREBTH,
     1IREFSW,IREFCO,
     1IREPTY,IREPLI,IREPCO,PREPTH,PREPSP,
     1PTEXHE,PTEXWI,PTEXVG,PTEXHG)
C
      X1=X2
      Y1=Y2
C
      GOTO1160
 1190 CONTINUE
C
      PXEND=X2
      PYEND=Y2
C
C               ************************************
C               **  STEP 4--                      **
C               **  CARRY OUT CLOSING OPERATIONS  **
C               **  ON THE GRAPHICS DEVICES       **
C               ************************************
C
      ICOPSW='OFF'
      NUMCOP=0
      CALL DPCLPL(ICOPSW,NUMCOP,
     1PGRAXF,PGRAYF,
     1IGRASW,PDIAXC,PDIAYC,PDIAX2,PDIAY2,
     1PDIAHE,PDIAWI,PDIAVG,PDIAHG)
C
      CALL DPCLDE
C
 8000 CONTINUE
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'CIRC')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF DPCIRC--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)ILOCFN,NUMNUM
 9012 FORMAT('ILOCFN,NUMNUM = ',2I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)X1,Y1,X2,Y2
 9013 FORMAT('X1,Y1,X2,Y2 = ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)PXSTAR,PYSTAR
 9015 FORMAT('PXSTAR,PYSTAR = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9016)PXEND,PYEND
 9016 FORMAT('PXEND,PYEND = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9017)IFIG
 9017 FORMAT('IFIG = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9027)IFOUND
 9027 FORMAT('IFOUND = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9028)IBUGG4,ISUBG4,IERRG4
 9028 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9029)IBUGD2,IERROR
 9029 FORMAT('IBUGD2,IERROR = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPCLCH(PX,PY,NP,PX2,PY2,NP2,X3D2,
     1PXMIN,PXMAX,PYMIN,PYMAX,
     1ISORSW,
     1IFIG,IPATT,IFONT,ICASE,IJUST,IDIR,ANGLE,IFILL,ICOL,
     1PHEIGH,PWIDTH,PVEGAP,PHOGAP,PTHICK,
     1IMPSW2,AMPSCH,AMPSCW,
     1ISYMBL,ISPAC)
C
C     PURPOSE--CARRY OUT CLIPPING (IF NECESSARY)
C              AND DRAW THE POLYMARKERS
C              (OR SERIES OF CLIPPED TRACES)
C              BASED ON THE DATA IN (PX,PY).
C     DANGER--THE INPUT VARIABLES PX(.) AND PY(.) MAY BE
C             CHANGED IN THIS SUBROUTINE (SEE STEP 0 BELOW)
C
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--83.6
C     ORIGINAL VERSION (AS A SEPARATE SUBROUTINE)--MAY       1983.
C     UPDATED       --DECEMBER  1999.  SUPPORT FOR ROWID AND ROW LABEL
C                                      AS CHARACTERS.
C     UPDATED       --JANUARY   2000.  USE ISUB TO GET CORRECT VALUE
C                                      FOR ROWID AND ROW LABEL
C     UPDATED       --JANUARY   2000.  ADD X3D2 TO CALL LIST
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ISORSW
C
      CHARACTER*4 IFIG
      CHARACTER*16 IPATT
      CHARACTER*4 IFONT
      CHARACTER*4 ICASE
      CHARACTER*4 IJUST
      CHARACTER*4 IDIR
      CHARACTER*4 IFILL
      CHARACTER*4 ICOL
C
      CHARACTER*16 ISYMBL
      CHARACTER*4 ISPAC
      CHARACTER*4 IMPSW2
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCOZI.INC'
      DIMENSION IROWID(MAXOBV)
      DIMENSION IJUNK(MAXOBV)
      DIMENSION IJUNK2(MAXOBV)
      EQUIVALENCE (IGARBG(IIGAR1),IROWID(1))
      EQUIVALENCE (IGARBG(IIGAR2),IJUNK(1))
      EQUIVALENCE (IGARBG(IIGAR3),IJUNK2(1))
C
      DIMENSION PX(*)
      DIMENSION PY(*)
C
      DIMENSION X3D2(*)
C
      DIMENSION PX2(*)
      DIMENSION PY2(*)
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOHK.INC'
      INCLUDE 'DPCODA.INC'
      INCLUDE 'DPCOBE.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPCL'
      ISUBN2='CH  '
C
      XMIN=CPUMAX
      YMIN=CPUMAX
      XMAX=CPUMIN
      YMAX=CPUMIN
      J=(-999)
C
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'CLCH')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPCLCH--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,53)PXMIN,PXMAX,PYMIN,PYMAX
   53   FORMAT('PXMIN,PXMAX,PYMIN,PYMAX = ',4F10.5)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,54)IBUGG4,ISUBG4,IERRG4,ISORSW,NP
   54   FORMAT('IBUGG4,ISUBG4,IERRG4,ISORSW,NP = ',4(A4,2X),I8)
        CALL DPWRST('XXX','BUG ')
        DO62I=1,NP
          DEL1=PX(I)-PXMIN
          DEL2=PX(I)-PXMAX
          DEL3=PY(I)-PYMIN
          DEL4=PY(I)-PYMAX
          WRITE(ICOUT,63)I,PX(I),PY(I)
   63     FORMAT('I,PX(I),PY(I)         = ',I8,2G15.7)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,64)I,DEL1,DEL2,DEL3,DEL4
   64     FORMAT('I,DEL1,DEL2,DEL3,DEL4 = ',I8,4E15.7)
          CALL DPWRST('XXX','BUG ')
   62   CONTINUE
      ENDIF
C
C               ******************************************************
C               **  STEP 0B--                                        *
C               **  SET VALUES OF IJUNK TO VALUES OF ISUB = 1.       *
C               **  USED TO GET PROPER INDEX FOR ROWID               *
C               ******************************************************
C
      DO81I=1,MAXOBV
        IJUNK(I)=0
        IJUNK2(I)=0
        IROWID(I)=I
   81 CONTINUE
      J=0
      DO83I=1,MAXOBV
        IF(ISUB(I).EQ.1)THEN
          J=J+1
          IJUNK(J)=I
          IF(J.GE.NP)GOTO89
        ENDIF
   83 CONTINUE
   89 CONTINUE
C
C               ****************************************************************
C               **  STEP 0--                                                   *
C               **  IF NECESSARY,                                              *
C               **  ADJUST (= CHANGE) THE PX(.) AND PY(.) VALUES TO ALLOW FOR  *
C               **  POSSIBLE ROUNDOFF NEAR THE LIMITS (PXMIN,PXMAX)            *
C               **  AND (PYMIN,PYMAX) WHICH WOULD SHOW UP AS A DATA            *
C               **  POINT NOT BEING PLOTTED WHEN IT SHOULD HAVE BEEN           *
C               ****************************************************************
C
      CALL DPSQUE(PX,PY,NP,
     1PXMIN,PXMAX,PYMIN,PYMAX)
C
C               *************************************************
C               **  STEP 1--                                   **
C               **  DETERMINE THE FIRST AND LAST ELEMENTS OF   **
C               **  THE (PX,PY) VECTORS WHICH MUST BE SCANNED  **
C               **  BASED ON WHETHER PX(.) IS SORTED           **
C               **  OR NOT.                                    **
C               *************************************************
C
      ISTEPN='1'
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'CLCH')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(ISORSW.EQ.'ON')THEN
        DO1110I=1,NP
          I2=I
          IF(PX(I).GE.PXMIN)THEN
            IMIN=I2
            GOTO1119
          ENDIF
 1110   CONTINUE
        IMIN=NP+1
 1119   CONTINUE
C
        DO1120I=1,NP
          IREV=NP-I+1
          IF(PX(IREV).LE.PXMAX)THEN
            IMAX=IREV
            GOTO1129
          ENDIF
 1120   CONTINUE
        IMAX=0
 1129   CONTINUE
C
      ELSE
        IMIN=1
        IMAX=NP
      ENDIF
C
      IF(IMIN.GT.IMAX)GOTO9000
C
C               ********************************************************
C               **  STEP 2--                                          **
C               **  COMPUTE THE HORIZONTAL AXIS VARIABLE MIN AND MAX  **
C               **  FOR THE DATA WITHIN THE SUBSET                    **
C               ********************************************************
C
      ISTEPN='2'
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'CLCH')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(ISORSW.EQ.'ON')THEN
        XMIN=PX(IMIN)
        XMAX=PX(IMAX)
      ELSE
        XMIN=CPUMAX
        XMAX=CPUMIN
        DO1260I=IMIN,IMAX
          IF(PX(I).LT.XMIN)XMIN=PX(I)
          IF(PX(I).GT.XMAX)XMAX=PX(I)
 1260   CONTINUE
      ENDIF
C
C               ******************************************************
C               **  STEP 3--                                        **
C               **  COMPUTE THE VERTICAL AXIS VARIABLE MIN AND MAX  **
C               **  FOR THE DATA WITHIN THE SUBSET                  **
C               ******************************************************
C
      ISTEPN='3'
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'CLCH')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      YMIN=CPUMAX
      YMAX=CPUMIN
      DO1300I=IMIN,IMAX
        IF(PY(I).LT.YMIN)YMIN=PY(I)
        IF(PY(I).GT.YMAX)YMAX=PY(I)
 1300 CONTINUE
C
C               *******************************************************
C               **  STEP 21--                                        **
C               **  TREAT THE MOST COMMON AND MOST IMPORTANT CASE--  **
C               **  ALL NP OBSERVATIONS ARE TO BE USED;              **
C               **  ALL X DATA ARE WITHIN THE FRAME;                 **
C               **  ALL Y DATA ARE WITHIN THE FRAME.                 **
C               *******************************************************
C
      IF(IMIN.EQ.1.AND.IMAX.EQ.NP.AND.
     1XMIN.GE.PXMIN.AND.XMAX.LE.PXMAX.AND.
     1YMIN.GE.PYMIN.AND.YMAX.LE.PYMAX)THEN
        ISTEPN='21'
        DO2101I=1,NP
          IROWID(I)=IJUNK(I)
          IJUNK2(I)=1
 2101   CONTINUE
C
        IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'CLCH')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
        CALL DPDRPM(PX,PY,NP,X3D2,IJUNK2,IROWID,IROWLB,
     1              IFIG,IPATT,IFONT,ICASE,IJUST,IDIR,ANGLE,IFILL,ICOL,
     1              PHEIGH,PWIDTH,PVEGAP,PHOGAP,PTHICK,
     1              IMPSW2,AMPSCH,AMPSCW,
     1              ISYMBL,ISPAC)
        NP2=0
        GOTO9000
      ENDIF
C
C               *******************************************************
C               **  STEP 22--                                        **
C               **  TREAT THE NEXT MOST COMMON AND MOST IMPORTANT CASE--  **
C               **  A SUBSET OF THE NP OBSERVATIONS ARE TO BE USED;  **
C               **  ALL X DATA ARE WITHIN THE FRAME;                 **
C               **  ALL Y DATA ARE WITHIN THE FRAME.                 **
C               *******************************************************
C
      IF(XMIN.GE.PXMIN.AND.XMAX.LE.PXMAX.AND.
     1YMIN.GE.PYMIN.AND.YMAX.LE.PYMAX)THEN
        ISTEPN='22'
C
        IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'CLCH')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
        J=0
        DO2210I=IMIN,IMAX
          J=J+1
          PX2(J)=PX(I)
          PY2(J)=PY(I)
          IROWID(J)=IJUNK(I)
          IJUNK2(I)=1
 2210   CONTINUE
        NP2=J
        IF(NP2.GE.1)
     1    CALL DPDRPM(PX2,PY2,NP2,X3D2,IJUNK2,IROWID,IROWLB,
     1                IFIG,IPATT,IFONT,ICASE,IJUST,IDIR,ANGLE,
     1                IFILL,ICOL,
     1                PHEIGH,PWIDTH,PVEGAP,PHOGAP,PTHICK,
     1                IMPSW2,AMPSCH,AMPSCW,
     1                ISYMBL,ISPAC)
        GOTO9000
      ENDIF
C
C               ****************************************************
C               **  STEP 23--                                     **
C               **  TREAT THE CASE WHERE THE SUBSET IS SUCH THAT  **
C               **  ALL X'S ARE INSIDE THE FRAME,                 **
C               **  BUT SOME Y'S ARE OUTSIDE THE FRAME.           **
C               ****************************************************
C
      IF(XMIN.GE.PXMIN.AND.XMAX.LE.PXMAX)THEN
C
        ISTEPN='23'
        IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'CLCH')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
        J=0
        DO2310I=IMIN,IMAX
          IM1=I-1
          IF(PY(I).GE.PYMIN.AND.PY(I).LE.PYMAX)THEN
            J=J+1
            PX2(J)=PX(I)
            PY2(J)=PY(I)
            IROWID(J)=IJUNK(I)
            IJUNK2(I)=1
          ELSE
            NP2=J
            IF(NP2.GE.1)
     1        CALL DPDRPM(PX2,PY2,NP2,X3D2,IJUNK2,IROWID,IROWLB,
     1                    IFIG,IPATT,IFONT,ICASE,IJUST,IDIR,ANGLE,
     1                    IFILL,ICOL,
     1                    PHEIGH,PWIDTH,PVEGAP,PHOGAP,PTHICK,
     1                    IMPSW2,AMPSCH,AMPSCW,
     1                    ISYMBL,ISPAC)
            J=0
          ENDIF
 2310   CONTINUE
C
        NP2=J
        IF(NP2.GE.1)
     1    CALL DPDRPM(PX2,PY2,NP2,X3D2,IJUNK2,IROWID,IROWLB,
     1                IFIG,IPATT,IFONT,ICASE,IJUST,IDIR,ANGLE,
     1                IFILL,ICOL,
     1                PHEIGH,PWIDTH,PVEGAP,PHOGAP,PTHICK,
     1                IMPSW2,AMPSCH,AMPSCW,
     1                ISYMBL,ISPAC)
        GOTO9000
C
      ENDIF
C
C               ****************************************************
C               **  STEP 24--                                     **
C               **  TREAT THE CASE WHERE THE SUBSET IS SUCH THAT  **
C               **  ALL Y'S ARE INSIDE THE FRAME,                 **
C               **  BUT SOME X'S ARE OUTSIDE THE FRAME            **
C               **  (AS IN THE CONSTRUCTION OF MAPS)              **
C               ****************************************************
C
      IF(YMIN.GE.PYMIN.AND.YMAX.LE.PYMAX)THEN
C
        ISTEPN='24'
        IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'CLCH')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
        J=0
        DO2410I=IMIN,IMAX
          IM1=I-1
          IF(PX(I).GE.PXMIN.AND.PX(I).LE.PXMAX)THEN
            J=J+1
            PX2(J)=PX(I)
            PY2(J)=PY(I)
            IROWID(J)=IJUNK(I)
            IJUNK2(I)=1
          ELSE
            NP2=J
            IF(NP2.GE.1)
     1        CALL DPDRPM(PX2,PY2,NP2,X3D2,IJUNK2,IROWID,IROWLB,
     1                    IFIG,IPATT,IFONT,ICASE,IJUST,IDIR,ANGLE,
     1                    IFILL,ICOL,
     1                    PHEIGH,PWIDTH,PVEGAP,PHOGAP,PTHICK,
     1                    IMPSW2,AMPSCH,AMPSCW,
     1                    ISYMBL,ISPAC)
            J=0
          ENDIF
C
 2410   CONTINUE
C
        NP2=J
        IF(NP2.GE.1)
     1    CALL DPDRPM(PX2,PY2,NP2,X3D2,IJUNK2,IROWID,IROWLB,
     1                IFIG,IPATT,IFONT,ICASE,IJUST,IDIR,ANGLE,
     1                IFILL,ICOL,
     1                PHEIGH,PWIDTH,PVEGAP,PHOGAP,PTHICK,
     1                IMPSW2,AMPSCH,AMPSCW,
     1                ISYMBL,ISPAC)
        GOTO9000
C
      ENDIF
C
C               ****************************************************
C               **  STEP 25--                                     **
C               **  TREAT THE GENERAL CASE WHERE THE SUBSET IS SUCH THAT  **
C               **  SOME  X'S MAY BE OUTSIDE THE FRAME, AND/OR    **
C               **  SOME  Y'S MAY BE OUTSIDE THE FRAME            **
C               **  (AS IN THE CONSTRUCTION OF MAPS)              **
C               ****************************************************
C
 2500 CONTINUE
      ISTEPN='25'
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'CLCH')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      J=0
      DO2510I=IMIN,IMAX
        IM1=I-1
        IF(PX(I).GE.PXMIN.AND.PX(I).LE.PXMAX.AND.
     1     PY(I).GE.PYMIN.AND.PY(I).LE.PYMAX)THEN
          J=J+1
          PX2(J)=PX(I)
          PY2(J)=PY(I)
          IROWID(J)=IJUNK(I)
          IJUNK2(I)=1
        ELSE
          NP2=J
          IF(NP2.GE.1)
     1      CALL DPDRPM(PX2,PY2,NP2,X3D2,IJUNK2,IROWID,IROWLB,
     1                  IFIG,IPATT,IFONT,ICASE,IJUST,IDIR,ANGLE,
     1                  IFILL,ICOL,
     1                  PHEIGH,PWIDTH,PVEGAP,PHOGAP,PTHICK,
     1                  IMPSW2,AMPSCH,AMPSCW,
     1                  ISYMBL,ISPAC)
          J=0
        ENDIF
 2510 CONTINUE
C
      NP2=J
      IF(NP2.GE.1)
     1  CALL DPDRPM(PX2,PY2,NP2,X3D2,IJUNK2,IROWID,IROWLB,
     1              IFIG,IPATT,IFONT,ICASE,IJUST,IDIR,ANGLE,
     1              IFILL,ICOL,
     1              PHEIGH,PWIDTH,PVEGAP,PHOGAP,PTHICK,
     1              IMPSW2,AMPSCH,AMPSCW,
     1              ISYMBL,ISPAC)
      GOTO9000
C
 2590 CONTINUE
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'CLCH')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPCLCH--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)PXMIN,PXMAX,PYMIN,PYMAX
 9013   FORMAT('PXMIN,PXMAX,PYMIN,PYMAX = ',4F10.5)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9017)IMIN,IMAX,J,NP,NP2
 9017   FORMAT('IMIN,IMAX,J,NP,NP2 = ',5I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9018)XMIN,XMAX,YMIN,YMAX
 9018   FORMAT('XMIN,XMAX,YMIN,YMAX = ',4G15.7)
        CALL DPWRST('XXX','BUG ')
        DO9022I=1,NP
          DEL1=PX(I)-PXMIN
          DEL2=PX(I)-PXMAX
          DEL3=PY(I)-PYMIN
          DEL4=PY(I)-PYMAX
          WRITE(ICOUT,9023)I,PX(I),PY(I)
 9023     FORMAT('I,PX(I),PY(I)         = ',I8,2G15.7)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,9024)I,DEL1,DEL2,DEL3,DEL4
 9024     FORMAT('I,DEL1,DEL2,DEL3,DEL4 = ',I8,4E15.7)
          CALL DPWRST('XXX','BUG ')
 9022   CONTINUE
        IF(NP2.GT.0)THEN
          DO9032I=1,NP2
            WRITE(ICOUT,9033)I,PX2(I),PY2(I)
 9033       FORMAT('I,PX2(I),YP2(I) = ',I8,2G15.7)
            CALL DPWRST('XXX','BUG ')
 9032     CONTINUE
        ENDIF
        WRITE(ICOUT,9039)IBUGG4,ISUBG4,IERRG4
 9039   FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPCLDE
C
C     PURPOSE--CLOSE A GRAPHICS DEVICE
C
C
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--83.6
C     ORIGINAL VERSION (AS A SEPARATE SUBROUTINE)--MAY       1983.
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOGR.INC'
      INCLUDE 'DPCOBE.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IERRG4='NO'
C
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'CLDE')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF DPCLDE--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IMANUF,IMODEL,IMODE2,IMODE3
   52 FORMAT('IMANUF,IMODEL,IMODE2,IMODE3 = ',A4,2X,A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)IGUNIT,IGCODE
   53 FORMAT('IGUNIT,IGCODE = ',I8,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)ISOFT,ISOFT2,ISOFT3
   54 FORMAT('ISOFT,ISOFT2,ISOFT3 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,55)IGBAUD
   55 FORMAT('IGBAUD = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,56)IBUGG4,ISUBG4,IERRG4
   56 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
C               ******************************
C               **  STEP 1--                **
C               **  CLOSE GRAPHICS SOFTWARE **
C               ******************************
C
CCCCC CALL GRCLSO
C
C               *****************************
C               **  STEP 2--               **
C               **  CLOSE GRAPHICS DEVICES  **
C               *****************************
C
      CALL GRCLDE
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'CLDE')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF DPCLDE--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IMANUF,IMODEL,IMODE2,IMODE3
 9012 FORMAT('IMANUF,IMODEL,IMODE2,IMODE3 = ',A4,2X,A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)IGUNIT,IGCODE
 9013 FORMAT('IGUNIT,IGCODE = ',I8,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)ISOFT,ISOFT2,ISOFT3
 9014 FORMAT('ISOFT,ISOFT2,ISOFT3 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)IGBAUD
 9015 FORMAT('IGBAUD = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9016)IBUGG4,ISUBG4,IERRG4
 9016 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPCLLO(IHARG,IARGT,ARG,NUMARG,
     1CLLIMI,IFOUND,IERROR)
C
C     PURPOSE--DEFINE THE LOWER BOUND OF THE LEFT-MOST CLASS
C              FOR HORIZONTAL VARIABLE OR VERTICAL VARIABLE OR BOTH
C              FOR DISTRIBUTIONAL PLOTS (E.G., HISTOGRAMS).
C              THE 2 LOWER LIMITS (ONE FOR THE X AXIS VARIABLE
C              AND ONE FOR THE Y AXIS VARIABLE)
C              ARE CONTAINED IN THE FIRST AND THIRD ELEMENTS OF THE
C              4-ELEMENT VECTOR CLLIMI(.).
C     INPUT  ARGUMENTS--IHARG  (A  HOLLERITH VECTOR)
C                     --IARGT  (A  HOLLERITH VECTOR)
C                     --ARG    (A  FLOATING POINT VECTOR)
C                     --NUMARG
C     OUTPUT ARGUMENTS--CLLIMI (A 4-ELEMENT FLOATING POINT VECTOR
C                              IN WHICH EACH ELEMENT IS AS FOLLOWS--
C                                 1) LOWER BOUND FOR HORIZONTAL VARIABLE
C                                 2) UPPER BOUND FOR HORIZONTAL VARIABLE
C                                    (NOT AFFECTED)
C                                 3) LOWER BOUND FOR VERTICAL   VARIABLE
C                                 4) UPPER BOUND FOR VERTICAL   VARIABLE
C                                    (NOT AFFECTED)
C                     --IFOUND ('YES' OR 'NO' )
C                     --IERROR ('YES' OR 'NO' )
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--NOVEMBER  1978.
C     UPDATED         --SEPTEMBER 1980.
C     UPDATED         --MAY       1981.
C     UPDATED         --MAY       1982.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IHARG
      CHARACTER*4 IARGT
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
C---------------------------------------------------------------------
C
      DIMENSION IHARG(*)
      DIMENSION IARGT(*)
      DIMENSION ARG(*)
C
      DIMENSION CLLIMI(4)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IFOUND='NO'
      IERROR='NO'
C
C               ************************************************************
C               **  TREAT THE CASE WHEN                                   **
C               **  THE HORIZONTAL VARIABLE LOWER BOUND IS TO BE CHANGED  **
C               ************************************************************
C
      IF(NUMARG.GE.1.AND.IHARG(1).EQ.'XLOW')GOTO1100
      GOTO1199
C
 1100 CONTINUE
      IF(NUMARG.EQ.1)GOTO1110
      IF(IARGT(NUMARG).EQ.'NUMB')GOTO1120
      GOTO1110
C
 1110 CONTINUE
      IFOUND='YES'
      CLLIMI(1)=CPUMIN
C
      IF(IFEEDB.EQ.'OFF')GOTO1119
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1115)
 1115 FORMAT('THE HORIZONTAL AXIS VARIABLE LOWER BOUND ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1116)
 1116 FORMAT('(FOR DISTRIBUTIONAL PLOTS) HAS JUST BEEN SET')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1117)
 1117 FORMAT('SO THAT IT WILL BE    XBAR - 6*XSD')
      CALL DPWRST('XXX','BUG ')
 1119 CONTINUE
      GOTO1900
C
 1120 CONTINUE
      IFOUND='YES'
      CLLIMI(1)=ARG(NUMARG)
C
      IF(IFEEDB.EQ.'OFF')GOTO1129
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1125)
 1125 FORMAT('THE HORIZONTAL AXIS VARIABLE LOWER BOUND ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1126)
 1126 FORMAT('(FOR DISTRIBUTIONAL PLOTS) HAS JUST BEEN SET')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1127)CLLIMI(1)
 1127 FORMAT('TO ',E15.7)
      CALL DPWRST('XXX','BUG ')
 1129 CONTINUE
      GOTO1900
C
 1199 CONTINUE
C
C               ************************************************************
C               **  TREAT THE CASE WHEN                                   **
C               **  THE VERTICAL   VARIABLE LOWER BOUND IS TO BE CHANGED  **
C               ************************************************************
C
      IF(NUMARG.GE.1.AND.IHARG(1).EQ.'YLOW')GOTO1200
      GOTO1299
C
 1200 CONTINUE
      IF(NUMARG.EQ.1)GOTO1210
      IF(IARGT(NUMARG).EQ.'NUMB')GOTO1220
      GOTO1210
C
 1210 CONTINUE
      IFOUND='YES'
      CLLIMI(3)=CPUMIN
C
      IF(IFEEDB.EQ.'OFF')GOTO1219
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1215)
 1215 FORMAT('THE VERTICAL AXIS VARIABLE LOWER BOUND ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1216)
 1216 FORMAT('(FOR DISTRIBUTIONAL PLOTS) HAS JUST BEEN SET')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1217)
 1217 FORMAT('SO THAT IT WILL BE    YBAR - 6*YSD')
      CALL DPWRST('XXX','BUG ')
 1219 CONTINUE
      GOTO1900
C
 1220 CONTINUE
      IFOUND='YES'
      CLLIMI(3)=ARG(NUMARG)
C
      IF(IFEEDB.EQ.'OFF')GOTO1229
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1225)
 1225 FORMAT('THE VERTICAL AXIS VARIABLE LOWER BOUND ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1226)
 1226 FORMAT('(FOR DISTRIBUTIONAL PLOTS) HAS JUST BEEN SET')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1227)CLLIMI(3)
 1227 FORMAT('TO ',E15.7)
      CALL DPWRST('XXX','BUG ')
 1229 CONTINUE
      GOTO1900
C
 1299 CONTINUE
C
C               ************************************************************
C               **  TREAT THE CASE WHEN                                   **
C               **  THE LOWER BOUNDS FOR BOTH VARIABLES ARE TO BE CHANGED **
C               ************************************************************
C
      IF(NUMARG.GE.1.AND.IHARG(1).EQ.'XYLO')GOTO1300
      IF(NUMARG.GE.1.AND.IHARG(1).EQ.'YXLO')GOTO1300
      IF(NUMARG.GE.1.AND.IHARG(1).EQ.'LOWE')GOTO1300
      GOTO1399
C
 1300 CONTINUE
      IF(NUMARG.EQ.1)GOTO1310
      IF(IARGT(NUMARG).EQ.'NUMB')GOTO1320
      GOTO1310
C
 1310 CONTINUE
      IFOUND='YES'
      CLLIMI(1)=CPUMIN
      CLLIMI(3)=CPUMIN
C
      IF(IFEEDB.EQ.'OFF')GOTO1319
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1315)
 1315 FORMAT('THE LOWER BOUNDS (FOR DISTRIBUTIONAL PLOTS) ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1316)
 1316 FORMAT('FOR BOTH VARIABLES HAVE JUST BEEN SET')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1317)
 1317 FORMAT('SO THAT THEY WILL BE    AVERAGE - 6*SD')
      CALL DPWRST('XXX','BUG ')
 1319 CONTINUE
      GOTO1900
C
 1320 CONTINUE
      IFOUND='YES'
      CLLIMI(1)=ARG(NUMARG)
      CLLIMI(3)=ARG(NUMARG)
C
      IF(IFEEDB.EQ.'OFF')GOTO1329
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1325)
 1325 FORMAT('THE LOWER BOUNDS (FOR DISTRIBUTIONAL PLOTS) ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1326)
 1326 FORMAT('FOR BOTH VARIABLES HAVE JUST BEEN SET')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1327)CLLIMI(1)
 1327 FORMAT('TO ',E15.7)
      CALL DPWRST('XXX','BUG ')
 1329 CONTINUE
      GOTO1900
C
 1399 CONTINUE
C
 1900 CONTINUE
      RETURN
      END
      SUBROUTINE DPCLPL(ICOPSW,NUMCOP,
     1PGRAXF,PGRAYF,
     1IGRASW,PDIAXC,PDIAYC,PDIAX2,PDIAY2,
     1PDIAHE,PDIAWI,PDIAVG,PDIAHG)
C
C     PURPOSE--CARRY OUT CLOSING OPERATIONS
C              SUBSEQUENT TO THE GENERATION OF A PLOT.
C
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--83.6
C     ORIGINAL VERSION (AS A SEPARATE SUBROUTINE)--MAY       1983.
C
C-----NON-COMMON VARIABLES (GRAPHICS)-------------------------------------------
C
      CHARACTER*4 IFONT
C
      CHARACTER*4 IGRASW
      CHARACTER*4 ICOPSW
C
      CHARACTER*4 ICASE
C
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOGR.INC'
      INCLUDE 'DPCOBE.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IFONT=IMANUF
C
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'CLPL')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF DPCLPL--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IMANUF,IMODEL,IMODE2,IMODE3
   52 FORMAT('IMANUF,IMODEL,IMODE2,IMODE3 = ',A4,2X,A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)IGUNIT,IGCODE
   53 FORMAT('IGUNIT,IGCODE = ',I8,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)ISOFT,ISOFT2,ISOFT3
   54 FORMAT('ISOFT,ISOFT2,ISOFT3 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,55)IGBAUD
   55 FORMAT('IGBAUD = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,56)IFONT
   56 FORMAT('IFONT = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,61)ICOPSW
   61 FORMAT('ICOPSW= ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,62)NUMCOP
   62 FORMAT('NUMCOP= ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,63)PGRAXF,PGRAYF
   63 FORMAT('PGRAXF,PGRAYF = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,64)IGRASW
   64 FORMAT('IGRASW= ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,65)PDIAXC,PDIAYC,PDIAX2,PDIAY2
   65 FORMAT('PDIAXC,PDIAYC,PDIAX2,PDIAY2 = ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,66)PDIAHE,PDIAWI
   66 FORMAT('PDIAHE,PDIAWI = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,67)PDIAVG,PDIAHG
   67 FORMAT('PDIAVG,PDIAHG = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,69)IBUGG4,ISUBG4,IERRG4
   69 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
C               ************************
C               **  STEP 1--          **
C               **  COPY THE SCREEN,  **
C               **  IF CALLED FOR     **
C               ************************
C
      IF(ICOPSW.EQ.'OFF')GOTO1190
      IF(NUMCOP.LE.0)GOTO1190
      DO1100I=1,NUMCOP
      CALL GRCOSC
 1100 CONTINUE
 1190 CONTINUE
C
C               *************************************************
C               **  STEP 2--                                   **
C               **  MOVE THE BEAM TO THE BOTTOM LEFT VICINITY  **
C               **  OF THE GRAPHICS REGION.                    **
C               *************************************************
C
      CALL GRMOBE(PGRAXF,PGRAYF)
C
C               **********************************************
C               **  STEP 4--                                **
C               **  TRANSLATE THE CHARACTER REPRESENTATION  **
C               **  OF THE DIALOGUE MODE BEAM SIZE          **
C               **  INTO A NUMERIC REPRESENTATION           **
C               **  WHICH CAN BE UNDERSTOOD BY THE          **
C               **  GRAPHICS DEVICE.                        **
C               **********************************************
C
      ICASE='MARK'
C
      PHEIGH=PDIAHE
      PWIDTH=PDIAWI
      PVEGAP=PDIAVG
      PHOGAP=PDIAHG
      CALL GRTRSI(ICASE,IFONT,PHEIGH,PWIDTH,PVEGAP,PHOGAP,
     1JSIZE,
     1JHEIG2,JWIDT2,JVEGA2,JHOGA2,
     1PHEIG2,PWIDT2,PVEGA2,PHOGA2)
C
C               ************************************
C               **  STEP 5--                      **
C               **  SET THE DIALOGUE MODE SIZE    **
C               **  ON THE GRAPHICS DEVICE.       **
C               ************************************
C
      CALL GRSESI(ICASE,IFONT,PHEIGH,PWIDTH,PVEGAP,PHOGAP,
     1JSIZE,
     1JHEIG2,JWIDT2,JVEGA2,JHOGA2,
     1PHEIG2,PWIDT2,PVEGA2,PHOGA2)
C
C               *************************************************
C               **  STEP 6--                                   **
C               **  MOVE THE BEAM TO THE PROPER POINT          **
C               **  (USUALLY IN THE LOWER LEFT)                **
C               **  ON THE SCREEN.                             **
C               *************************************************
C
      CALL GRMOBE(PDIAX2,PDIAY2)
      PSUM=PDIAHE+PDIAVG
      PDIAY2=PDIAY2-PSUM
      IF(PDIAY2.LE.PSUM)PDIAY2=PDIAYC
      IF(PDIAY2.GE.100.0)PDIAY2=PDIAYC
C
C               ***********************************************************
C               **  STEP 11--                                            **
C               **  EXIT OUT OF GRAPHICS MODE AND                        **
C               **  AND MOVE TO DIALOGUE (= MONITOR) MODE.               **
C               **  THE DIALOGUE MODE ON VARIOUS TERMINALS               **
C               **  IS USUALLY OF 3 TYPES--                              **
C               **  1. FOR TERMINALS WITH NO FORMAL DIALOGUE REGION AND  **
C               **     NO BACKGROUND DIALOGUE PLANE                      **
C               **     (AND THUS SUCCEDING NON-GRAPHICS TEXT WILL        **
C               **     OVERWRITE THE GRAPHICS ON THE SCREEN),            **
C               **     THEN DO NOTHING.                                  **
C               **  2. FOR THOSE TERMINALS IN WHICH THE SCREEN           **
C               **     IS SHARED BETWEEN A GRAPHICS REGION AND           **
C               **     A MONITOR REGION (USUALLY AT THE BOTTOM),         **
C               **     THEN GO TO THE MONITOR REGION.                    **
C               **  3. FOR TERMINALS WITH A FULL-SCREEN BACKGROUND       **
C               **     DIALOGUE PLANE THAT THE USER CAN FLIP-FLOP TO     **
C               **     AND WHICH IS INDEPENDENT OF THE GRAPHICS PLANE,   **
C               **     THEN GO TO THE DIALOGUE PLANE.                    **
C               ***********************************************************
C
C     THE FOLLOWING WAS A SIGGRAPH PATCH FOR THE 4129 (DALLAS) AUG. 19, 1986
CCCCC IGRASW='OFF'
      IGRASW='OFF'
      CALL GRSEMO(IGRASW,PDIAXC,PDIAYC)
C
C               *********************
C               **  STEP 6--       **
C               **  REVIVE PROMPT  **
C               *********************
C
CCCCC CALL GRREPR
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'CLPL')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF DPCLPL--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IMANUF,IMODEL,IMODE2,IMODE3
 9012 FORMAT('IMANUF,IMODEL,IMODE2,IMODE3 = ',A4,2X,A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)IGUNIT,IGCODE
 9013 FORMAT('IGUNIT,IGCODE = ',I8,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)ISOFT,ISOFT2,ISOFT3
 9014 FORMAT('ISOFT,ISOFT2,ISOFT3 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)IGBAUD
 9015 FORMAT('IGBAUD = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9021)ICOPSW
 9021 FORMAT('ICOPSW= ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9022)NUMCOP
 9022 FORMAT('NUMCOP= ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9023)PGRAXF,PGRAYF
 9023 FORMAT('PGRAXF,PGRAYF = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9024)IGRASW
 9024 FORMAT('IGRASW= ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9025)PDIAXC,PDIAYC,PDIAX2,PDIAY2
 9025 FORMAT('PDIAXC,PDIAYC,PDIAX2,PDIAY2 = ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9026)PDIAHE,PDIAWI
 9026 FORMAT('PDIAHE,PDIAWI = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9027)PDIAVG,PDIAHG
 9027 FORMAT('PDIAVG,PDIAHG = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9029)IBUGG4,ISUBG4,IERRG4
 9029 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPCLT2(PXOLD,PYOLD,PXCUR,PYCUR,
     1PXMIN,PXMAX,PYMIN,PYMAX,
     1PXNEW,PYNEW)
C
C      PURPOSE--GIVEN THE 2 POINTS (PXOLD,PYOLD) AND (PXNEW,PYNEW)
C               (ONE OF WHICH IS DEFINITELY IN THE FRAME
C               DEFINED BY (PXMIN,PYMIN) AND (PXMAX,PYMAX)
C               AND THE OTHER OF WHICH IS OUTSIDE THAT FRAME,
C               COMPUTE THE POINT (PXNEW,PYNEW) WHICH
C               IS THAT VALUE ON THE FRAME IN WHICH THE LINE SEGMENT
C               INTERSECTS THE FRAME.
C               THIS ALLOWS THE SUBROUTINE DPCLIP
C               TO CARRY OUT CLIPPING.
C
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--83.6
C     ORIGINAL VERSION (AS A SEPARATE SUBROUTINE)--MAY       1983.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOBE.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPCL'
      ISUBN2='P2  '
C
      PX1=PXOLD
      PY1=PYOLD
      PX2=PXCUR
      PY2=PYCUR
      PX3=PXCUR
      PY3=PYCUR
C
      SLOPE=0.0
      AINT=0.0
C
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'CLT2')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF DPCLT2--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)PXOLD,PYOLD
   52 FORMAT('PXOLD,PYOLD = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)PXCUR,PYCUR
   53 FORMAT('PXCUR,PYCUR = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)PXMIN,PYMIN,PXMAX,PYMAX
   54 FORMAT('PXMIN,PYMIN,PXMAX,PYMAX = ',4F10.5)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,59)IBUGG4,ISUBG4,IERRG4
   59 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
C               ************************************************************
C               **  STEP 1--                                              **
C               **  EITHER (PXOLD,PYOLD) OR (PXCUR,PYCUR)                 **
C               **  MUST BE WITHIN THE FRAME.                             **
C               **  DETERMINE WHICH ONE IS.                               **
C               **  (PX1,PY1) WILL REFER TO THE POINT INSIDE  THE FRAME.  **
C               **  (PX2,PY2) WILL REFER TO THE POINT OUTSIDE THE FRAME.  **
C               ************************************************************
C
      ISTEPN='1'
      IF(IBUGG4.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(PXOLD.GE.PXMIN.AND.PXOLD.LE.PXMAX.AND.
     1   PYOLD.GE.PYMIN.AND.PYOLD.LE.PYMAX)GOTO1110
      IF(PXCUR.GE.PXMIN.AND.PXCUR.LE.PXMAX.AND.
     1   PYCUR.GE.PYMIN.AND.PYCUR.LE.PYMAX)GOTO1120
      GOTO1130
C
 1110 CONTINUE
      PX1=PXOLD
      PY1=PYOLD
      PX2=PXCUR
      PY2=PYCUR
      GOTO1190
C
 1120 CONTINUE
      PX1=PXCUR
      PY1=PYCUR
      PX2=PXOLD
      PY2=PYOLD
      GOTO1190
C
 1130 CONTINUE
      IERRG4='YES'
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1131)
 1131 FORMAT('***** INTERNAL ERROR IN DPCLT2--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1132)
 1132 FORMAT('      UPON INPUT TO THIS SUBROUTINE,')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1133)
 1133 FORMAT('      AT LEAST ONE POINT MUST BE')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1134)
 1134 FORMAT('      WITHIN THE FRAME--BUT WAS NOT.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1135)PXMIN,PXMAX,PYMIN,PYMAX
 1135 FORMAT('PXMIN,PXMAX,PYMIN,PYMAX = ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1136)PXOLD,PYOLD,PXCUR,PYCUR
 1136 FORMAT('PXOLD,PYOLD,PXCUR,PYCUR = ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      GOTO9000
C
 1190 CONTINUE
C
C               **********************************
C               **  STEP 2--                    **
C               **  DETERMINE THE FRAME POINT.  **
C               **  THIS WILL BE (PX3,PY3).     **
C               **********************************
C
      ISTEPN='2'
      IF(IBUGG4.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(PX1.EQ.PX2)GOTO1200
      GOTO1250
C
C               **************************************
C               **  STEP 2.1--                      **
C               **  TREAT THE SUBCASE WHEN PX1 = PX2**
C               **************************************
C
 1200 CONTINUE
      ISTEPN='2.1'
      IF(IBUGG4.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      PX3=PX2
C
      PY3=PY2
      IF(PY2.LT.PYMIN)PY3=PYMIN
      IF(PY2.GT.PYMAX)PY3=PYMAX
C
      GOTO1290
C
C               ***************************************************
C               **  STEP 2.2--                                   **
C               **  TREAT THE SUBCASE WHEN PX1 DOES NOT EQUAL PX2**
C               ***************************************************
C
 1250 CONTINUE
      ISTEPN='2.2'
      IF(IBUGG4.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      SLOPE=(PY2-PY1)/(PX2-PX1)
      AINT=PY2-SLOPE*PX2
C
      PX3=PX2
      IF(PX2.LT.PXMIN)PX3=PXMIN
      IF(PX2.GT.PXMAX)PX3=PXMAX
C
      PY3=SLOPE*PX3+AINT
      IF(PY3.LT.PYMIN)GOTO1260
      IF(PY3.GT.PYMAX)GOTO1270
      GOTO1290
C
 1260 CONTINUE
      PY3=PYMIN
      PX3=0.0
      IF(SLOPE.NE.0.0)PX3=(PY3-AINT)/SLOPE
      GOTO1290
C
 1270 CONTINUE
      PY3=PYMAX
      PX3=0.0
      IF(SLOPE.NE.0.0)PX3=(PY3-AINT)/SLOPE
      GOTO1290
C
 1290 CONTINUE
      PXNEW=PX3
      PYNEW=PY3
      GOTO9000
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'CLT2')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF DPCLT2--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)PXOLD,PYOLD
 9012 FORMAT('PXOLD,PYOLD = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)PXCUR,PYCUR
 9013 FORMAT('PXCUR,PYCUR = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)PXMIN,PYMIN,PXMAX,PYMAX
 9014 FORMAT('PXMIN,PYMIN,PXMAX,PYMAX = ',4F10.5)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9021)PX1,PY1
 9021 FORMAT('PX1,PY1 = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9022)PX2,PY2
 9022 FORMAT('PX2,PY2 = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9023)PX3,PY3
 9023 FORMAT('PX3,PY3 = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9025)SLOPE,AINT
 9025 FORMAT('SLOPE,AINT = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9026)PXNEW,PYNEW
 9026 FORMAT('PXNEW,PYNEW = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9029)IBUGG4,ISUBG4,IERRG4
 9029 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPCLTR(PX,PY,NP,PX2,PY2,NP2,PY3,PX3,NP3,
     1PXMIN,PXMAX,PYMIN,PYMAX,
     1ISORSW,
     1IFIG,IPATT,PTHICK,ICOL)
C
C     PURPOSE--CARRY OUT CLIPPING (IF NECESSARY)
C              AND DRAW A TRACE
C              (OR SERIES OF CLIPPED TRACES)
C              BASED ON THE DATA IN (PX,PY).
C     DANGER--THE INPUT VARIABLES PX(.) AND PY(.) MAY BE
C             CHANGED IN THIS SUBROUTINE (SEE STEP 0 BELOW)
C
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--83.6
C     ORIGINAL VERSION (AS A SEPARATE SUBROUTINE)--MAY       1983.
C     UPDATED         --JANUARY   1989.  MODIFY CALLS TO DPDRPL (ALAN)
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ISORSW
C
      CHARACTER*4 IFIG
      CHARACTER*4 IPATT
      CHARACTER*4 ICOL
      CHARACTER*4 IFLAG
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      DIMENSION PX(*)
      DIMENSION PY(*)
C
      DIMENSION PX2(*)
      DIMENSION PY2(*)
C
CCCCC DIMENSION PX3(*)
CCCCC DIMENSION PY3(*)
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOBE.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPCL'
      ISUBN2='PL  '
C
      XMIN=CPUMAX
      YMIN=CPUMAX
      XMAX=CPUMIN
      YMAX=CPUMIN
      J=(-999)
C
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'CLTR')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF DPCLTR--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)PXMIN,PXMAX,PYMIN,PYMAX
   53 FORMAT('PXMIN,PXMAX,PYMIN,PYMAX = ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)ISORSW
   54 FORMAT('ISORSW = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,56)IFIG,IPATT,PTHICK,ICOL
   56 FORMAT('IFIG,IPATT,PTHICK,ICOL = ',A4,2X,A4,E15.7,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,61)NP
   61 FORMAT('NP = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO62I=1,NP
      DEL1=PX(I)-PXMIN
      DEL2=PX(I)-PXMAX
      DEL3=PY(I)-PYMIN
      DEL4=PY(I)-PYMAX
      WRITE(ICOUT,63)I,PX(I),PY(I)
   63 FORMAT('I,PX(I),PY(I)         = ',I8,2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,64)I,DEL1,DEL2,DEL3,DEL4
   64 FORMAT('I,DEL1,DEL2,DEL3,DEL4 = ',I8,4E15.7)
      CALL DPWRST('XXX','BUG ')
   62 CONTINUE
      WRITE(ICOUT,69)IBUGG4,ISUBG4,IERRG4
   69 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
C               ****************************************************************
C               **  STEP 0--                                                   *
C               **  IF NECESSARY,                                              *
C               **  ADJUST (= CHANGE) THE PX(.) AND PY(.) VALUES TO ALLOW FOR  *
C               **  POSSIBLE ROUNDOFF NEAR THE LIMITS (PXMIN,PXMAX)            *
C               **  AND (PYMIN,PYMAX) WHICH WOULD SHOW UP AS A DATA            *
C               **  POINT NOT BEING PLOTTED WHEN IT SHOULD HAVE BEEN           *
C               ****************************************************************
C
      CALL DPSQUE(PX,PY,NP,
     1PXMIN,PXMAX,PYMIN,PYMAX)
C
C               *************************************************
C               **  STEP 1--                                   **
C               **  DETERMINE THE FIRST AND LAST ELEMENTS OF   **
C               **  THE (PX,PY) VECTORS WHICH MUST BE SCANNED  **
C               **  BASED ON WHETHER PX(.) IS SORTED           **
C               **  OR NOT.                                    **
C               *************************************************
C
      ISTEPN='1'
      IF(IBUGG4.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(ISORSW.EQ.'ON')GOTO1100
      GOTO1150
C
 1100 CONTINUE
      DO1110I=1,NP
      I2=I
      IF(PX(I).GE.PXMIN)GOTO1115
 1110 CONTINUE
      IMIN=NP+1
      GOTO1119
 1115 CONTINUE
      IMIN=I2
 1119 CONTINUE
C
      DO1120I=1,NP
      IREV=NP-I+1
      IF(PX(IREV).LE.PXMAX)GOTO1125
 1120 CONTINUE
      IMAX=0
      GOTO1129
 1125 CONTINUE
      IMAX=IREV
 1129 CONTINUE
      GOTO1190
C
 1150 CONTINUE
      IMIN=1
      IMAX=NP
      GOTO1190
C
 1190 CONTINUE
      IF(IMIN.GT.IMAX)GOTO9000
C
C               ********************************************************
C               **  STEP 2--                                          **
C               **  COMPUTE THE HORIZONTAL AXIS VARIABLE MIN AND MAX  **
C               **  FOR THE DATA WITHIN THE SUBSET                    **
C               ********************************************************
C
      ISTEPN='2'
      IF(IBUGG4.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(ISORSW.EQ.'ON')GOTO1210
      GOTO1250
C
 1210 CONTINUE
      XMIN=PX(IMIN)
      XMAX=PX(IMAX)
      GOTO1290
C
 1250 CONTINUE
      XMIN=CPUMAX
      XMAX=CPUMIN
      DO1260I=IMIN,IMAX
      IF(PX(I).LT.XMIN)XMIN=PX(I)
      IF(PX(I).GT.XMAX)XMAX=PX(I)
 1260 CONTINUE
      GOTO1290
C
 1290 CONTINUE
C
C               ******************************************************
C               **  STEP 3--                                        **
C               **  COMPUTE THE VERTICAL AXIS VARIABLE MIN AND MAX  **
C               **  FOR THE DATA WITHIN THE SUBSET                  **
C               ******************************************************
C
      ISTEPN='3'
      IF(IBUGG4.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      YMIN=CPUMAX
      YMAX=CPUMIN
      DO1300I=IMIN,IMAX
      IF(PY(I).LT.YMIN)YMIN=PY(I)
      IF(PY(I).GT.YMAX)YMAX=PY(I)
 1300 CONTINUE
C
C               *******************************************************
C               **  STEP 21--                                        **
C               **  TREAT THE MOST COMMON AND MOST IMPORTANT CASE--  **
C               **  ALL NP OBSERVATIONS ARE TO BE USED;              **
C               **  ALL X DATA ARE WITHIN THE FRAME;                 **
C               **  ALL Y DATA ARE WITHIN THE FRAME.                 **
C               *******************************************************
C
      IF(IMIN.EQ.1.AND.IMAX.EQ.NP.AND.
     1XMIN.GE.PXMIN.AND.XMAX.LE.PXMAX.AND.
     1YMIN.GE.PYMIN.AND.YMAX.LE.PYMAX)GOTO2100
      GOTO2190
C
 2100 CONTINUE
      ISTEPN='21'
      IF(IBUGG4.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
      IFLAG='ON'
CCCCC CALL DPDRPL(PX,PY,NP,PX3,PY3,NP3,
CCCCC1IFIG,IPATT,PTHICK,ICOL)
      CALL DPDRPL(PX,PY,NP,
     1IFIG,IPATT,PTHICK,ICOL,
     1JPATT,JTHICK,PTHIC2,JCOL,IFLAG)
      GOTO9000
C
 2190 CONTINUE
C
C               *******************************************************
C               **  STEP 22--                                        **
C               **  TREAT THE NEXT MOST COMMON AND MOST IMPORTANT CASE--  **
C               **  A SUBSET OF THE NP OBSERVATIONS ARE TO BE USED;  **
C               **  ALL X DATA ARE WITHIN THE FRAME;                 **
C               **  ALL Y DATA ARE WITHIN THE FRAME.                 **
C               *******************************************************
C
      IF(XMIN.GE.PXMIN.AND.XMAX.LE.PXMAX.AND.
     1YMIN.GE.PYMIN.AND.YMAX.LE.PYMAX)GOTO2200
      GOTO2290
C
 2200 CONTINUE
      ISTEPN='22'
      IF(IBUGG4.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
      J=0
      DO2210I=IMIN,IMAX
      J=J+1
      PX2(J)=PX(I)
      PY2(J)=PY(I)
 2210 CONTINUE
      NP2=J
      IFLAG='ON'
CCCCC CALL DPDRPL(PX2,PY2,NP2,PX3,PY3,NP3,
CCCCC1IFIG,IPATT,PTHICK,ICOL)
      CALL DPDRPL(PX2,PY2,NP2,
     1IFIG,IPATT,PTHICK,ICOL,
     1JPATT,JTHICK,PTHIC2,JCOL,IFLAG)
      GOTO9000
C
 2290 CONTINUE
C
C               ****************************************************
C               **  STEP 23--                                     **
C               **  TREAT THE CASE WHERE THE SUBSET IS SUCH THAT  **
C               **  ALL X'S ARE INSIDE THE FRAME,                 **
C               **  BUT SOME Y'S ARE OUTSIDE THE FRAME.           **
C               ****************************************************
C
      IF(XMIN.GE.PXMIN.AND.XMAX.LE.PXMAX)GOTO2300
      GOTO2390
C
 2300 CONTINUE
      ISTEPN='23'
      IF(IBUGG4.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
      J=0
      DO2310I=IMIN,IMAX
      IM1=I-1
      IF(PY(I).GE.PYMIN.AND.PY(I).LE.PYMAX)GOTO2320
      GOTO2330
C
 2320 CONTINUE
      IF(IM1.LT.IMIN)GOTO2325
      PXOLD=PX(IM1)
      PYOLD=PY(IM1)
      PXCUR=PX(I)
      PYCUR=PY(I)
      IF(PYOLD.GE.PYMIN.AND.PYOLD.LE.PYMAX)GOTO2325
      CALL DPCLT2(PXOLD,PYOLD,PXCUR,PYCUR,
     1PXMIN,PXMAX,PYMIN,PYMAX,
     1PXNEW,PYNEW)
      J=J+1
      PX2(J)=PXNEW
      PY2(J)=PYNEW
C
 2325 CONTINUE
      J=J+1
      PX2(J)=PX(I)
      PY2(J)=PY(I)
      GOTO2310
C
 2330 CONTINUE
      IF(IM1.LT.IMIN)GOTO2335
      PXOLD=PX(IM1)
      PYOLD=PY(IM1)
      PXCUR=PX(I)
      PYCUR=PY(I)
      IF(PYOLD.GE.PYMIN.AND.PYOLD.LE.PYMAX)GOTO2333
      GOTO2335
C
 2333 CONTINUE
      CALL DPCLT2(PXOLD,PYOLD,PXCUR,PYCUR,
     1PXMIN,PXMAX,PYMIN,PYMAX,
     1PXNEW,PYNEW)
      J=J+1
      PX2(J)=PXNEW
      PY2(J)=PYNEW
      NP2=J
      IFLAG='ON'
CCCCC CALL DPDRPL(PX2,PY2,NP2,PX3,PY3,NP3,
CCCCC1IFIG,IPATT,PTHICK,ICOL)
      CALL DPDRPL(PX2,PY2,NP2,
     1IFIG,IPATT,PTHICK,ICOL,
     1JPATT,JTHICK,PTHIC2,JCOL,IFLAG)
C
 2335 CONTINUE
      J=0
      GOTO2310
C
 2310 CONTINUE
      NP2=J
      IFLAG='ON'
      IF(NP2.GE.1)
CCCCC1CALL DPDRPL(PX2,PY2,NP2,PX3,PY3,NP3,
CCCCC1IFIG,IPATT,PTHICK,ICOL)
     1CALL DPDRPL(PX2,PY2,NP2,
     1IFIG,IPATT,PTHICK,ICOL,
     1JPATT,JTHICK,PTHIC2,JCOL,IFLAG)
      GOTO9000
C
 2390 CONTINUE
C
C               ****************************************************
C               **  STEP 24--                                     **
C               **  TREAT THE CASE WHERE THE SUBSET IS SUCH THAT  **
C               **  ALL Y'S ARE INSIDE THE FRAME,                 **
C               **  BUT SOME X'S ARE OUTSIDE THE FRAME            **
C               **  (AS IN THE CONSTRUCTION OF MAPS)              **
C               ****************************************************
C
      IF(YMIN.GE.PYMIN.AND.YMAX.LE.PYMAX)GOTO2400
      GOTO2490
C
 2400 CONTINUE
      ISTEPN='24'
      IF(IBUGG4.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
      J=0
      DO2410I=IMIN,IMAX
      IM1=I-1
      IF(PX(I).GE.PXMIN.AND.PX(I).LE.PXMAX)GOTO2420
      GOTO2430
C
 2420 CONTINUE
      IF(IM1.LT.IMIN)GOTO2425
      PXOLD=PX(IM1)
      PYOLD=PY(IM1)
      PXCUR=PX(I)
      PYCUR=PY(I)
      IF(PXOLD.GE.PXMIN.AND.PXOLD.LE.PXMAX)GOTO2425
      CALL DPCLT2(PXOLD,PYOLD,PXCUR,PYCUR,
     1PXMIN,PXMAX,PYMIN,PYMAX,
     1PXNEW,PYNEW)
      J=J+1
      PX2(J)=PXNEW
      PY2(J)=PYNEW
 2425 CONTINUE
      J=J+1
      PX2(J)=PX(I)
      PY2(J)=PY(I)
      GOTO2410
C
 2430 CONTINUE
      IF(IM1.LT.IMIN)GOTO2435
      PXOLD=PX(IM1)
      PYOLD=PY(IM1)
      PXCUR=PX(I)
      PYCUR=PY(I)
      IF(PXOLD.GE.PXMIN.AND.PXOLD.LE.PXMAX)GOTO2433
      GOTO2435
 2433 CONTINUE
      CALL DPCLT2(PXOLD,PYOLD,PXCUR,PYCUR,
     1PXMIN,PXMAX,PYMIN,PYMAX,
     1PXNEW,PYNEW)
      J=J+1
      PX2(J)=PXNEW
      PY2(J)=PYNEW
      NP2=J
      IFLAG='ON'
CCCCC CALL DPDRPL(PX2,PY2,NP2,PX3,PY3,NP3,
CCCCC1IFIG,IPATT,PTHICK,ICOL)
      CALL DPDRPL(PX2,PY2,NP2,
     1IFIG,IPATT,PTHICK,ICOL,
     1JPATT,JTHICK,PTHIC2,JCOL,IFLAG)
 2435 CONTINUE
      J=0
      GOTO2410
C
 2410 CONTINUE
      NP2=J
      IFLAG='ON'
      IF(NP2.GE.1)
CCCCC1CALL DPDRPL(PX2,PY2,NP2,PX3,PY3,NP3,
CCCCC1IFIG,IPATT,PTHICK,ICOL)
     1CALL DPDRPL(PX2,PY2,NP2,
     1IFIG,IPATT,PTHICK,ICOL,
     1JPATT,JTHICK,PTHIC2,JCOL,IFLAG)
      GOTO9000
C
 2490 CONTINUE
C
C               ****************************************************
C               **  STEP 25--                                     **
C               **  TREAT THE GENERAL CASE WHERE THE SUBSET IS SUCH THAT  **
C               **  SOME  X'S MAY BE OUTSIDE THE FRAME, AND/OR    **
C               **  SOME  Y'S MAY BE OUTSIDE THE FRAME            **
C               **  (AS IN THE CONSTRUCTION OF MAPS)              **
C               ****************************************************
C
 2500 CONTINUE
      ISTEPN='25'
      IF(IBUGG4.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
      J=0
      DO2510I=IMIN,IMAX
      IM1=I-1
      IF(PX(I).GE.PXMIN.AND.PX(I).LE.PXMAX.AND.
     1   PY(I).GE.PYMIN.AND.PY(I).LE.PYMAX)GOTO2520
      GOTO2530
C
 2520 CONTINUE
      IF(IM1.LT.IMIN)GOTO2525
      PXOLD=PX(IM1)
      PYOLD=PY(IM1)
      PXCUR=PX(I)
      PYCUR=PY(I)
      IF(PXOLD.GE.PXMIN.AND.PXOLD.LE.PXMAX.AND.
     1   PYOLD.GE.PYMIN.AND.PYOLD.LE.PYMAX)GOTO2525
      CALL DPCLT2(PXOLD,PYOLD,PXCUR,PYCUR,
     1PXMIN,PXMAX,PYMIN,PYMAX,
     1PXNEW,PYNEW)
      J=J+1
      PX2(J)=PXNEW
      PY2(J)=PYNEW
 2525 CONTINUE
      J=J+1
      PX2(J)=PX(I)
      PY2(J)=PY(I)
      GOTO2510
C
 2530 CONTINUE
      IF(IM1.LT.IMIN)GOTO2535
      PXOLD=PX(IM1)
      PYOLD=PY(IM1)
      PXCUR=PX(I)
      PYCUR=PY(I)
      IF(PXOLD.GE.PXMIN.AND.PXOLD.LE.PXMAX.AND.
     1   PYOLD.GE.PYMIN.AND.PYOLD.LE.PYMAX)GOTO2533
      GOTO2535
 2533 CONTINUE
      CALL DPCLT2(PXOLD,PYOLD,PXCUR,PYCUR,
     1PXMIN,PXMAX,PYMIN,PYMAX,
     1PXNEW,PYNEW)
      J=J+1
      PX2(J)=PXNEW
      PY2(J)=PYNEW
      NP2=J
      IFLAG='ON'
CCCCC CALL DPDRPL(PX2,PY2,NP2,PX3,PY3,NP3,
CCCCC1IFIG,IPATT,PTHICK,ICOL)
      CALL DPDRPL(PX2,PY2,NP2,
     1IFIG,IPATT,PTHICK,ICOL,
     1JPATT,JTHICK,PTHIC2,JCOL,IFLAG)
 2535 CONTINUE
      J=0
      GOTO2510
C
 2510 CONTINUE
      NP2=J
      IFLAG='ON'
      IF(NP2.GE.1)
CCCCC1CALL DPDRPL(PX2,PY2,NP2,PX3,PY3,NP3,
CCCCC1IFIG,IPATT,PTHICK,ICOL)
     1CALL DPDRPL(PX2,PY2,NP2,
     1IFIG,IPATT,PTHICK,ICOL,
     1JPATT,JTHICK,PTHIC2,JCOL,IFLAG)
      GOTO9000
C
 2590 CONTINUE
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'CLTR')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF DPCLTR--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)PXMIN,PXMAX,PYMIN,PYMAX
 9013 FORMAT('PXMIN,PXMAX,PYMIN,PYMAX = ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)ISORSW
 9014 FORMAT('ISORSW = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9016)IFIG,IPATT,PTHICK,ICOL
 9016 FORMAT('IFIG,IPATT,PTHICK,ICOL = ',A4,2X,A4,E15.7,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9017)IMIN,IMAX,J
 9017 FORMAT('IMIN,IMAX,J = ',3I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9018)XMIN,XMAX,YMIN,YMAX
 9018 FORMAT('XMIN,XMAX,YMIN,YMAX = ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9021)NP
 9021 FORMAT('NP = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO9022I=1,NP
      DEL1=PX(I)-PXMIN
      DEL2=PX(I)-PXMAX
      DEL3=PY(I)-PYMIN
      DEL4=PY(I)-PYMAX
      WRITE(ICOUT,9023)I,PX(I),PY(I)
 9023 FORMAT('I,PX(I),PY(I)         = ',I8,2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9024)I,DEL1,DEL2,DEL3,DEL4
 9024 FORMAT('I,DEL1,DEL2,DEL3,DEL4 = ',I8,4E15.7)
      CALL DPWRST('XXX','BUG ')
 9022 CONTINUE
      WRITE(ICOUT,9031)NP2
 9031 FORMAT('NP2 = ',I8)
      CALL DPWRST('XXX','BUG ')
CCCCC DO9032I=1,NP2
      DO9032I=1,NP
      WRITE(ICOUT,9033)I,PX2(I),PY2(I)
 9033 FORMAT('I,PX2(I),YP2(I) = ',I8,2E15.7)
      CALL DPWRST('XXX','BUG ')
 9032 CONTINUE
      WRITE(ICOUT,9039)IBUGG4,ISUBG4,IERRG4
 9039 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPCLUP(IHARG,IARGT,ARG,NUMARG,
     1CLLIMI,IFOUND,IERROR)
C
C     PURPOSE--DEFINE THE UPPER BOUND OF THE LEFT-MOST CLASS
C              FOR HORIZONTAL VARIABLE OR VERTICAL VARIABLE OR BOTH
C              FOR DISTRIBUTIONAL PLOTS (E.G., HISTOGRAMS).
C              THE 2 UPPER LIMITS (ONE FOR THE X AXIS VARIABLE
C              AND ONE FOR THE Y AXIS VARIABLE)
C              ARE CONTAINED IN THE SECOND AND FOURTH ELEMENTS OF THE
C              4-ELEMENT VECTOR CLLIMI(.).
C     INPUT  ARGUMENTS--IHARG  (A  HOLLERITH VECTOR)
C                     --IARGT  (A  HOLLERITH VECTOR)
C                     --ARG    (A  FLOATING POINT VECTOR)
C                     --NUMARG
C     OUTPUT ARGUMENTS--CLLIMI (A 4-ELEMENT FLOATING POINT VECTOR
C                              IN WHICH EACH ELEMENT IS AS FOLLOWS--
C                                 1) LOWER BOUND FOR HORIZONTAL VARIABLE
C                                    (NOT AFFECTED)
C                                 2) UPPER BOUND FOR HORIZONTAL VARIABLE
C                                 3) LOWER BOUND FOR VERTICAL   VARIABLE
C                                    (NOT AFFECTED)
C                                 4) UPPER BOUND FOR VERTICAL   VARIABLE
C                     --IFOUND ('YES' OR 'NO' )
C                     --IERROR ('YES' OR 'NO' )
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--NOVEMBER  1978.
C     UPDATED         --SEPTEMBER 1980.
C     UPDATED         --MAY       1981.
C     UPDATED         --OCTOBER   1981.
C     UPDATED         --MAY       1982.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IHARG
      CHARACTER*4 IARGT
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
C---------------------------------------------------------------------
C
      DIMENSION IHARG(*)
      DIMENSION IARGT(*)
      DIMENSION ARG(*)
C
      DIMENSION CLLIMI(4)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IFOUND='NO'
      IERROR='NO'
C
C               ************************************************************
C               **  TREAT THE CASE WHEN                                   **
C               **  THE HORIZONTAL VARIABLE UPPER BOUND IS TO BE CHANGED  **
C               ************************************************************
C
      IF(NUMARG.GE.1.AND.IHARG(1).EQ.'XUPP')GOTO1100
      GOTO1199
C
 1100 CONTINUE
      IF(NUMARG.EQ.1)GOTO1110
      IF(IARGT(NUMARG).EQ.'NUMB')GOTO1120
      GOTO1110
C
 1110 CONTINUE
      IFOUND='YES'
      CLLIMI(2)=CPUMAX
C
      IF(IFEEDB.EQ.'OFF')GOTO1119
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1115)
 1115 FORMAT('THE HORIZONTAL AXIS VARIABLE UPPER BOUND ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1116)
 1116 FORMAT('(FOR DISTRIBUTIONAL PLOTS) HAS JUST BEEN SET')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1117)
 1117 FORMAT('SO THAT IT WILL BE    XBAR + 6*XSD')
      CALL DPWRST('XXX','BUG ')
 1119 CONTINUE
      GOTO1900
C
 1120 CONTINUE
      IFOUND='YES'
      CLLIMI(2)=ARG(NUMARG)
C
      IF(IFEEDB.EQ.'OFF')GOTO1129
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1125)
 1125 FORMAT('THE HORIZONTAL AXIS VARIABLE UPPER BOUND ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1126)
 1126 FORMAT('(FOR DISTRIBUTIONAL PLOTS) HAS JUST BEEN SET')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1127)CLLIMI(1)
 1127 FORMAT('TO ',E15.7)
      CALL DPWRST('XXX','BUG ')
 1129 CONTINUE
      GOTO1900
C
 1199 CONTINUE
C
C               ************************************************************
C               **  TREAT THE CASE WHEN                                   **
C               **  THE VERTICAL   VARIABLE UPPER BOUND IS TO BE CHANGED  **
C               ************************************************************
C
      IF(NUMARG.GE.1.AND.IHARG(1).EQ.'YUPP')GOTO1200
      GOTO1299
C
 1200 CONTINUE
      IF(NUMARG.EQ.1)GOTO1210
      IF(IARGT(NUMARG).EQ.'NUMB')GOTO1220
      GOTO1210
C
 1210 CONTINUE
      IFOUND='YES'
      CLLIMI(4)=CPUMAX
C
      IF(IFEEDB.EQ.'OFF')GOTO1219
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1215)
 1215 FORMAT('THE VERTICAL AXIS VARIABLE UPPER BOUND ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1216)
 1216 FORMAT('(FOR DISTRIBUTIONAL PLOTS) HAS JUST BEEN SET')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1217)
 1217 FORMAT('SO THAT IT WILL BE    YBAR + 6*YSD')
      CALL DPWRST('XXX','BUG ')
 1219 CONTINUE
      GOTO1900
C
 1220 CONTINUE
      IFOUND='YES'
      CLLIMI(4)=ARG(NUMARG)
C
      IF(IFEEDB.EQ.'OFF')GOTO1229
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1225)
 1225 FORMAT('THE VERTICAL AXIS VARIABLE UPPER BOUND ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1226)
 1226 FORMAT('(FOR DISTRIBUTIONAL PLOTS) HAS JUST BEEN SET')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1227)CLLIMI(4)
 1227 FORMAT('TO ',E15.7)
      CALL DPWRST('XXX','BUG ')
 1229 CONTINUE
      GOTO1900
C
 1299 CONTINUE
C
C               ************************************************************
C               **  TREAT THE CASE WHEN                                   **
C               **  THE UPPER BOUNDS FOR BOTH VARIABLES ARE TO BE CHANGED **
C               ************************************************************
C
      IF(NUMARG.GE.1.AND.IHARG(1).EQ.'XYUP')GOTO1300
      IF(NUMARG.GE.1.AND.IHARG(1).EQ.'YXUP')GOTO1300
      IF(NUMARG.GE.1.AND.IHARG(1).EQ.'UPPE')GOTO1300
      GOTO1399
C
 1300 CONTINUE
      IF(NUMARG.EQ.1)GOTO1310
      IF(IARGT(NUMARG).EQ.'NUMB')GOTO1320
      GOTO1310
C
 1310 CONTINUE
      IFOUND='YES'
      CLLIMI(2)=CPUMAX
      CLLIMI(4)=CPUMAX
C
      IF(IFEEDB.EQ.'OFF')GOTO1319
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1315)
 1315 FORMAT('THE UPPER BOUNDS (FOR DISTRIBUTIONAL PLOTS) ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1316)
 1316 FORMAT('FOR BOTH VARIABLES HAVE JUST BEEN SET')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1317)
 1317 FORMAT('SO THAT THEY WILL BE    AVERAGE + 6*SD')
      CALL DPWRST('XXX','BUG ')
 1319 CONTINUE
      GOTO1900
C
 1320 CONTINUE
      IFOUND='YES'
      CLLIMI(2)=ARG(NUMARG)
      CLLIMI(4)=ARG(NUMARG)
C
      IF(IFEEDB.EQ.'OFF')GOTO1329
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1325)
 1325 FORMAT('THE UPPER BOUNDS (FOR DISTRIBUTIONAL PLOTS) ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1326)
 1326 FORMAT('FOR BOTH VARIABLES HAVE JUST BEEN SET')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1327)CLLIMI(2)
 1327 FORMAT('TO ',E15.7)
      CALL DPWRST('XXX','BUG ')
 1329 CONTINUE
      GOTO1900
C
 1399 CONTINUE
C
 1900 CONTINUE
      RETURN
      END
      SUBROUTINE DPCLWI(IHARG,IARGT,ARG,NUMARG,
     1CLWIDT,IFOUND,IERROR)
C
C     PURPOSE--DEFINE THE CLASS WIDTH
C              FOR HORIZONTAL VARIABLE OR VERTICAL VARIABLE OR BOTH
C              FOR DISTRIBUTIONAL PLOTS (E.G., HISTOGRAMS).
C              THE 2 CLASS WIDTHS (ONE FOR THE X AXIS VARIABLE
C              AND ONE FOR THE Y AXIS VARIABLE)
C              ARE CONTAINED IN THE FIRST AND SECOND ELEMENTS OF THE
C              2-ELEMENT VECTOR CLWIDT(.).
C     INPUT  ARGUMENTS--IHARG  (A  HOLLERITH VECTOR)
C                     --IARGT  (A  HOLLERITH VECTOR)
C                     --ARG    (A  FLOATING POINT VECTOR)
C                     --NUMARG
C     OUTPUT ARGUMENTS--CLWIDT (A 2-ELEMENT FLOATING POINT VECTOR
C                              IN WHICH EACH ELEMENT IS AS FOLLOWS--
C                                 1) CLASS WIDTH FOR HORIZONTAL VARIABLE
C                                 2) CLASS WIDTH FOR VERTICAL VARIABLE
C                     --IFOUND ('YES' OR 'NO' )
C                     --IERROR ('YES' OR 'NO' )
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--NOVEMBER  1978.
C     UPDATED         --SEPTEMBER 1980.
C     UPDATED         --MAY       1981.
C     UPDATED         --MAY       1982.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IHARG
      CHARACTER*4 IARGT
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
C---------------------------------------------------------------------
C
      DIMENSION IHARG(*)
      DIMENSION IARGT(*)
      DIMENSION ARG(*)
C
      DIMENSION CLWIDT(2)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IFOUND='NO'
      IERROR='NO'
C
C               ************************************************************
C               **  TREAT THE CASE WHEN                                   **
C               **  THE HORIZONTAL VARIABLE CLASS WIDTH IS TO BE CHANGED  **
C               ************************************************************
C
      IF(NUMARG.GE.1.AND.IHARG(1).EQ.'XWID')GOTO1100
      GOTO1199
C
 1100 CONTINUE
      IF(NUMARG.EQ.1)GOTO1110
      IF(IARGT(NUMARG).EQ.'NUMB')GOTO1120
      GOTO1110
C
 1110 CONTINUE
      IFOUND='YES'
      CLWIDT(1)=CPUMIN
C
      IF(IFEEDB.EQ.'OFF')GOTO1119
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1115)
 1115 FORMAT('THE HORIZONTAL AXIS VARIABLE CLASS WIDTH ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1116)
 1116 FORMAT('(FOR DISTRIBUTIONAL PLOTS) HAS JUST BEEN SET')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1117)
 1117 FORMAT('SO THAT IT WILL BE    0.3*XSD')
      CALL DPWRST('XXX','BUG ')
 1119 CONTINUE
      GOTO1900
C
 1120 CONTINUE
      IFOUND='YES'
      CLWIDT(1)=ARG(NUMARG)
C
      IF(IFEEDB.EQ.'OFF')GOTO1129
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1125)
 1125 FORMAT('THE HORIZONTAL AXIS VARIABLE CLASS WIDTH ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1126)
 1126 FORMAT('(FOR DISTRIBUTIONAL PLOTS) HAS JUST BEEN SET')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1127)CLWIDT(1)
 1127 FORMAT('TO ',E15.7)
      CALL DPWRST('XXX','BUG ')
 1129 CONTINUE
      GOTO1900
C
 1199 CONTINUE
C
C               ************************************************************
C               **  TREAT THE CASE WHEN                                   **
C               **  THE VERTICAL   VARIABLE CLASS WIDTH IS TO BE CHANGED  **
C               ************************************************************
C
      IF(NUMARG.GE.1.AND.IHARG(1).EQ.'YWID')GOTO1200
      GOTO1299
C
 1200 CONTINUE
      IF(NUMARG.EQ.1)GOTO1210
      IF(IARGT(NUMARG).EQ.'NUMB')GOTO1220
      GOTO1210
C
 1210 CONTINUE
      IFOUND='YES'
      CLWIDT(2)=CPUMIN
C
      IF(IFEEDB.EQ.'OFF')GOTO1219
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1215)
 1215 FORMAT('THE VERTICAL AXIS VARIABLE CLASS WIDTH ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1216)
 1216 FORMAT('(FOR DISTRIBUTIONAL PLOTS) HAS JUST BEEN SET')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1217)
 1217 FORMAT('SO THAT IT WILL BE    0.3*YSD')
      CALL DPWRST('XXX','BUG ')
 1219 CONTINUE
      GOTO1900
C
 1220 CONTINUE
      IFOUND='YES'
      CLWIDT(2)=ARG(NUMARG)
C
      IF(IFEEDB.EQ.'OFF')GOTO1229
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1225)
 1225 FORMAT('THE VERTICAL AXIS VARIABLE CLASS WIDTH ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1226)
 1226 FORMAT('(FOR DISTRIBUTIONAL PLOTS) HAS JUST BEEN SET')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1227)CLWIDT(2)
 1227 FORMAT('TO ',E15.7)
      CALL DPWRST('XXX','BUG ')
 1229 CONTINUE
      GOTO1900
C
 1299 CONTINUE
C
C               ************************************************************
C               **  TREAT THE CASE WHEN                                   **
C               **  THE CLASS WIDTHS FOR BOTH VARIABLES ARE TO BE CHANGED **
C               ************************************************************
C
      IF(NUMARG.GE.1.AND.IHARG(1).EQ.'XYWI')GOTO1300
      IF(NUMARG.GE.1.AND.IHARG(1).EQ.'YXWI')GOTO1300
      IF(NUMARG.GE.1.AND.IHARG(1).EQ.'WIDT')GOTO1300
      GOTO1399
C
 1300 CONTINUE
      IF(NUMARG.EQ.1)GOTO1310
      IF(IARGT(NUMARG).EQ.'NUMB')GOTO1320
      GOTO1310
C
 1310 CONTINUE
      IFOUND='YES'
      CLWIDT(1)=CPUMIN
      CLWIDT(2)=CPUMIN
C
      IF(IFEEDB.EQ.'OFF')GOTO1319
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1315)
 1315 FORMAT('THE CLASS WIDTHS (FOR DISTRIBUTIONAL PLOTS) ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1316)
 1316 FORMAT('FOR BOTH VARIABLES HAVE JUST BEEN SET')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1317)
 1317 FORMAT('SO THAT THEY WILL BE    0.3*SD')
      CALL DPWRST('XXX','BUG ')
 1319 CONTINUE
      GOTO1900
C
 1320 CONTINUE
      IFOUND='YES'
      CLWIDT(1)=ARG(NUMARG)
      CLWIDT(2)=ARG(NUMARG)
C
      IF(IFEEDB.EQ.'OFF')GOTO1329
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1325)
 1325 FORMAT('THE CLASS WIDTHS (FOR DISTRIBUTIONAL PLOTS) ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1326)
 1326 FORMAT('FOR BOTH VARIABLES HAVE JUST BEEN SET')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1327)CLWIDT(1)
 1327 FORMAT('TO ',E15.7)
      CALL DPWRST('XXX','BUG ')
 1329 CONTINUE
      GOTO1900
C
 1399 CONTINUE
C
 1900 CONTINUE
      RETURN
      END
      SUBROUTINE DPCMGP(Y,N,
     1                  XTEMP,MAXNXT,
     1                  GAMMA,A,GAMMSD,THRESH,
     1                  TEMP1,TEMP2,TEMP3,ITEMP1,
     1                  ALIKE,AIC,AICC,BIC,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE CME
C              ESTIMATES FOR THE GENERALIZED PARETO DISTRIBUTION.
C              THIS IS USED IN EXTREME VALUE APPLICATIONS.
C     EXAMPLE--CME Y
C     REFERENCE: GROSS, HECKERT, LECHNER, AND SIMIU (1995).  "EXTREME
C                WIND ESTIMATES BY THE CONDITIONAL MEAN EXCEEDANCE
C                PROCEDURE", NISTIT 5531.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--98/5
C     ORIGINAL VERSION--MAY       1998.
C     UPDATED         --JUNE      2004. SUPPORT FOR IGEPDF
C     UPDATED         --APRIL     2005. A NUMBER OF ENHANCEMENTS
C     UPDATED         --OCTOBER   2010. SLIGHT TWEAK TO ALGORITHM
C                                       IN REGARD TO THE THRESHOLD
C     UPDATED         --OCTOBER   2010. CALL GEPLI1 TO OBTAIN
C                                       LIKELIHOOD, AIC VALUES
C     UPDATED         --OCTOBER   2010. USE DPDTA1 TO PRINT
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*4 IWRITE
      CHARACTER*8 ISIGN1
      CHARACTER*8 ISIGN2
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION XTEMP(*)
C
      DIMENSION TEMP1(*)
      DIMENSION TEMP2(*)
      DIMENSION TEMP3(*)
      DIMENSION ITEMP1(*)
C
      DOUBLE PRECISION DGAMMA
      DOUBLE PRECISION DA
      DOUBLE PRECISION DB
      EXTERNAL DGAMMA
C
      INCLUDE 'DPCOST.INC'
C
      PARAMETER (MAXROW=40)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*60 ITEXT(MAXROW)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      LOGICAL IFIRST
      LOGICAL ILAST
C
      CHARACTER*40 IDIST
C
      DIMENSION QP(1)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA PI / 3.1415926535/
      DATA MINSIZ /5/
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPCM'
      ISUBN2='GP  '
C
      GAMMA=CPUMIN
      GAMMSD=CPUMIN
      A=CPUMIN
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CMGP')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPCMGP--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,53)IBUGA3,ISUBRO
   53   FORMAT('IBUGA3,ISUBRO = ',A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,55)N,MINSIZ,PPOTTO,THRESH
   55   FORMAT('N,MINSIZ,PPOTTO,THRESH = ',2I8,2G15.7)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,N
          WRITE(ICOUT,57)I,Y(I)
   57     FORMAT('I,Y(I) = ',I8,G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
       ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CMGP')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NPERC=0
      NTEMP=MINSIZ-1
      CALL CKDIST(Y,N,NTEMP,QP,NPERC,ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      IDIST='GENERALIZED PARETO (CME)'
      IFLAG=0
C
      CALL SUMRAW(Y,N,IDIST,IFLAG,
     1            XMEAN,XVAR,XSD,XMIN,XMAX,
     1            ISUBRO,IBUGA3,IERROR)
C
C
C               ********************************************
C               **  STEP 21--                             **
C               **  CARRY OUT CALCULATIONS                **
C               **  FOR CME    ESTIMATE                   **
C               **  SORT THE DATA                         **
C               **  AND IDENTIFY POINTS ABOVE THE THRESHOLD*
C               ********************************************
C
 2100 CONTINUE
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CMGP')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     NOTE 10/2010: DEFINE THRESHOLD AS MINIMUM VALUE, NOT
C     MINIMUM MINUS EPSILON.
C
      CALL SORT(Y,N,Y)
      EPS=0.0001
CCCCC IF(THRESH.LE.0.0)THRESH=Y(1)-EPS
      IF(THRESH.LE.0.0)THRESH=Y(1)
      DO2110I=1,N
        IF(Y(I).GT.THRESH)THEN
          IFRST=I
          GOTO2119
        ENDIF
 2110 CONTINUE
      IFRST=N+1
 2119 CONTINUE
C
      NUSE=N-IFRST+1
      IF(NUSE.LT.2)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1111)
 1111   FORMAT('****** ERROR IN GENERALIZED PARETO CME ESTIMATION--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2121)
 2121   FORMAT('      NO POINTS ARE ABOVE THE THRESHOLD.')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2123)THRESH
 2123   FORMAT('      THRESHOLD          = ',G15.7)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2125)Y(N)
 2125   FORMAT('      MAXIMUM DATA POINT = ',G15.7)
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      IF(Y(IFRST).LT.0.0)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1111)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2131)
 2131   FORMAT('      NEGATIVE VALUES ENCOUNTERED IN THE INPUT DATA.')
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      CALL CMESUB(Y(IFRST),NUSE,THRESH,SLOPE,R1,
     1            TEMP1,TEMP2,TEMP3,ITEMP1,GAMMSD)
      IF(SLOPE.EQ.CPUMIN)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1111)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2141)
 2141   FORMAT('      UNABLE TO COMPUTE CME ESTIMATES.')
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      GAMMA=SLOPE/(1.0+SLOPE)
      A=R1*(1.0-GAMMA)
C
      IWRITE='OFF'
      CALL MEAN(Y(IFRST),NUSE,IWRITE,ZMEAN,IBUGA3,IERROR)
      CALL VAR(Y(IFRST),NUSE,IWRITE,ZVAR,IBUGA3,IERROR)
      ZSD=SQRT(ZVAR)
      IF(ABS(GAMMA).LE.PPOTTO)THEN
        SCALE=ZSD*SQRT(6.0)/PI
        ALOC=ZMEAN - 0.57722*SCALE
      ELSEIF(GAMMA.LT.0.0)THEN
        GAMMA2=-1.0/GAMMA
        DA=DGAMMA(DBLE((GAMMA2+1.0)/GAMMA2))
        DB=DGAMMA(DBLE((GAMMA2+2.0)/GAMMA2)) - DA*DA
        IF(DB.GT.0.0D0)THEN
          SCALE=ZSD/REAL(DSQRT(DB))
          ALOC=ZMEAN + SCALE*REAL(DA)
        ELSE
          SCALE=0.0
          ALOC=0.0
        ENDIF
      ELSE
      ENDIF
C
C  DEPENDING ON WHAT DEFINITION OF GENERALIZED PARETO PREFERRED,
C  REVERSE SIGN OF GAMMA.
C
      IF(IGEPDF.EQ.'SIMI')THEN
        GAMMSV=GAMMA
        ISIGN1='negative'
        ISIGN2='positive'
      ELSE
        GAMMSV=-GAMMA
        ISIGN1='positive'
        ISIGN2='negative'
      ENDIF
C
C     NOTE THAT LIKELIHOOD IS NOT ALWAYS DEFINED (CAN GET LOG OF
C     NEGATIVE NUMBER).  SO PRINTING IS CONDITIONAL ON THESE VALUES
C     ACTUALLY BEING COMPUTED.
C
      ALIKE=CPUMIN
      AIC=CPUMIN
      AICC=CPUMIN
      BIC=CPUMIN
      MINMXZ=2
      CALL GEPLI1(Y(IFRST),NUSE,MINMXZ,IGEPDF,
     1            ALOC,A,GAMMSV,
     1            ALIKE,AIC,AICC,BIC,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *********************************
C               **   STEP 42--                 **
C               **   WRITE OUT EVERYTHING      **
C               **   FOR CME         ESTIMATE  **
C               *********************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CMGP')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IPRINT.EQ.'OFF')GOTO9000
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='Generalized Pareto Parameter Estimation (CME)'
      NCTITL=45
      ITITLZ='(Maximum Case)'
      NCTITZ=14
      ICNT=1
      ITEXT(ICNT)='Summary Statistics (Full Data Set):'
      NCTEXT(ICNT)=35
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(N)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=XMEAN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=XSD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Minimum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMIN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Maximum:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=XMAX
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Summary Statistics for'
      NCTEXT(ICNT)=22
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Observations Above Threshold:'
      NCTEXT(ICNT)=29
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Threshold:'
      NCTEXT(ICNT)=10
      AVALUE(ICNT)=THRESH
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations Above Threshold:'
      NCTEXT(ICNT)=39
      AVALUE(ICNT)=REAL(NUSE)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=ZMEAN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=ZSD
      IDIGIT(ICNT)=NUMDIG
C
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='CME Parameter Estimates:'
      NCTEXT(ICNT)=24
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Location Parameter:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=THRESH
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Scale Parameter:'
      NCTEXT(ICNT)=16
      AVALUE(ICNT)=A
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Shape Parameter (Gamma):'
      NCTEXT(ICNT)=24
      AVALUE(ICNT)=GAMMSV
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Standard Deviation of Gamma:'
      NCTEXT(ICNT)=28
      AVALUE(ICNT)=GAMMSD
      IDIGIT(ICNT)=NUMDIG
      IF(ALIKE.NE.CPUMIN)THEN
        ICNT=ICNT+1
        ITEXT(ICNT)='Log-likelihood:'
        NCTEXT(ICNT)=15
        AVALUE(ICNT)=ALIKE
        IDIGIT(ICNT)=-7
        ICNT=ICNT+1
        ITEXT(ICNT)='AIC:'
        NCTEXT(ICNT)=4
        AVALUE(ICNT)=AIC
        IDIGIT(ICNT)=-7
        ICNT=ICNT+1
        ITEXT(ICNT)='AICc:'
        NCTEXT(ICNT)=5
        AVALUE(ICNT)=AICC
        IDIGIT(ICNT)=-7
        ICNT=ICNT+1
        ITEXT(ICNT)='BIC:'
        NCTEXT(ICNT)=4
        AVALUE(ICNT)=BIC
        IDIGIT(ICNT)=-7
      ENDIF
C
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      IF(GAMMA.LT.-PPOTTO)THEN
        ICNT=ICNT+1
        ITEXT(ICNT)(1:4)='For '
        WRITE(ITEXT(ICNT)(5:12),'(A8)')ISIGN1
        ITEXT(ICNT)(13:42)=' Gamma, the generalized Pareto'
        NCTEXT(ICNT)=42
        AVALUE(ICNT)=0.0
        IDIGIT(ICNT)=-1
        ICNT=ICNT+1
        ITEXT(ICNT)(1:34)='is equivalent to a reverse Weibull'
        NCTEXT(ICNT)=34
        AVALUE(ICNT)=0.0
        IDIGIT(ICNT)=-1
        ICNT=ICNT+1
        ITEXT(ICNT)(1:22)='(SET MINMAX MAX) with:'
        NCTEXT(ICNT)=22
        AVALUE(ICNT)=0.0
        IDIGIT(ICNT)=-1
        ICNT=ICNT+1
        ITEXT(ICNT)='Shape Parameter (Gamma):'
        NCTEXT(ICNT)=24
        AVALUE(ICNT)=GAMMA2
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Location Parameter:'
        NCTEXT(ICNT)=19
        AVALUE(ICNT)=ALOC
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Scale Parameter:'
        NCTEXT(ICNT)=16
        AVALUE(ICNT)=SCALE
        IDIGIT(ICNT)=NUMDIG
      ELSEIF(ABS(GAMMA).LE.PPOTTO)THEN
        ICNT=ICNT+1
        ITEXT(ICNT)(1:40)='For Gamma = zero, the generalized Pareto'
        NCTEXT(ICNT)=40
        AVALUE(ICNT)=0.0
        IDIGIT(ICNT)=-1
        ICNT=ICNT+1
        ITEXT(ICNT)(1:40)='is equivalent to an extreme value type I'
        NCTEXT(ICNT)=34
        AVALUE(ICNT)=0.0
        IDIGIT(ICNT)=-1
        ICNT=ICNT+1
        ITEXT(ICNT)(1:14)='(Gumbel) with:'
        NCTEXT(ICNT)=14
        AVALUE(ICNT)=0.0
        IDIGIT(ICNT)=-1
        ICNT=ICNT+1
        ITEXT(ICNT)='Location Parameter:'
        NCTEXT(ICNT)=19
        AVALUE(ICNT)=ALOC
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Scale Parameter:'
        NCTEXT(ICNT)=16
        AVALUE(ICNT)=SCALE
        IDIGIT(ICNT)=NUMDIG
      ELSE
        ICNT=ICNT+1
        ITEXT(ICNT)(1:4)='For '
        WRITE(ITEXT(ICNT)(5:12),'(A8)')ISIGN2
        ITEXT(ICNT)(13:42)=' Gamma, the generalized Pareto'
        NCTEXT(ICNT)=42
        AVALUE(ICNT)=0.0
        IDIGIT(ICNT)=-1
        ICNT=ICNT+1
        ITEXT(ICNT)(1:28)='is equivalent to a (maximum)'
        NCTEXT(ICNT)=28
        AVALUE(ICNT)=0.0
        IDIGIT(ICNT)=-1
        ICNT=ICNT+1
        ITEXT(ICNT)(1:31)='extreme value type II (Frechet)'
        NCTEXT(ICNT)=31
        AVALUE(ICNT)=0.0
        IDIGIT(ICNT)=-1
        ICNT=ICNT+1
        ITEXT(ICNT)='Shape Parameter (Gamma):'
        NCTEXT(ICNT)=24
        AVALUE(ICNT)=GAMMA2
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Location Parameter:'
        NCTEXT(ICNT)=19
        AVALUE(ICNT)=ALOC
        IDIGIT(ICNT)=NUMDIG
        ICNT=ICNT+1
        ITEXT(ICNT)='Scale Parameter:'
        NCTEXT(ICNT)=16
        AVALUE(ICNT)=SCALE
        IDIGIT(ICNT)=NUMDIG
      ENDIF
C
      NUMROW=ICNT
      DO2320I=1,NUMROW
        NTOT(I)=15
 2320 CONTINUE
C
      IFIRST=.TRUE.
      ILAST=.TRUE.
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFIRST,
     1            ISUBRO,IBUGA3,IERROR)
C
      IF(ICAPSW.EQ.'OFF' .AND. ICAPTY.EQ.'TEXT')THEN
      IF(IFEEDB.EQ.'ON')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,4941)
 4941   FORMAT('GAMMA, SDGAMMA, AND A WILL BE SAVED AS INTERNAL ',
     1         'PARAMETERS.')
        CALL DPWRST('XXX','BUG ')
        IF(GAMMA.LT.-PPOTTO)THEN
          WRITE(ICOUT,4951)
 4951     FORMAT('THE REVERSE WEIBULL PARAMETERS WILL BE SAVED AS')
          CALL DPWRST('XXX','WRIT')
          WRITE(ICOUT,4953)
 4953     FORMAT('THE INTERNAL PARAMETERS GAMMA2, LOC, AND SCALE, ',
     1           ' RESPECTIVELY.')
          CALL DPWRST('XXX','WRIT')
        ELSEIF(ABS(GAMMA).LT.PPOTTO)THEN
          WRITE(ICOUT,4961)
 4961     FORMAT('THE GUMBEL PARAMETERS WILL BE SAVED AS THE ',
     1           'INTERNAL PARAMETERS LOC AND SCALE, RESPECTIVELY.')
          CALL DPWRST('XXX','BUG ')
        ENDIF
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
      ENDIF
      ENDIF
C
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CMGP')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPCMGP--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)N,IBUGA3,IERROR
 9012   FORMAT('N,IBUGA3,IERROR = ',I8,2X,A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPCME(NPLOTV,NPLOTP,NS,ICASPL,IAND1,IAND2,
     1                 IBUGG2,IBUGG3,IBUGQ,ISUBRO,IFOUND,IERROR)
C
C     PURPOSE--GENERATE A PAIR OF COORDINATE VECTORS
C              THAT WILL DEFINE ONE OF THE FOLLOWING 4
C              CONDITIONAL EXCEEDANCE PLOTS--
C                 CONDITIONAL EXCEEDANCE PLOT Y
C                 CONDITIONAL MEAN EXCEEDANCE PLOT Y (= CME PLOT Y)
C                 CONDITIONAL MEDIAN EXCEEDANCE PLOT Y
C                 CONDITIONAL MIDMEAN EXCEEDANCE PLOT Y
C     NOTE--THERE ARE MANY SYNONYMS FOR THE CME PLOT--
C              YANG PLOT
C              MEAN RESIDUAL LIFE PLOT
C              LIFE EXPECTANCY PLOT
C              MEAN LIFE EXPECTANCY PLOT
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--93/12
C     ORIGINAL VERSION--DECEMBER  1993.
C     UPDATED         --DECEMBER  1993. LINFIT ARGS: PROTECT RESSD/DF
C     UPDATED         --JANUARY   2012. USE DPPARS
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICASPL
      CHARACTER*4 IAND1
      CHARACTER*4 IAND2
      CHARACTER*4 IBUGG2
      CHARACTER*4 IBUGG3
      CHARACTER*4 IBUGQ
      CHARACTER*4 ISUBRO
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
      CHARACTER*4 IH
      CHARACTER*4 IH2
      CHARACTER*4 ISUBN0
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*4 IWRITE
C
      CHARACTER*4 ICASE
      CHARACTER*40 INAME
      PARAMETER (MAXSPN=10)
      CHARACTER*4 IVARN1(MAXSPN)
      CHARACTER*4 IVARN2(MAXSPN)
      CHARACTER*4 IVARTY(MAXSPN)
      REAL PVAR(MAXSPN)
      INTEGER ILIS(MAXSPN)
      INTEGER NRIGHT(MAXSPN)
      INTEGER ICOLR(MAXSPN)
C
C---------------------------------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCOZZ.INC'
C
      DIMENSION Y1(MAXOBV)
      DIMENSION XTEMP1(MAXOBV)
      DIMENSION XTEMP2(MAXOBV)
      DIMENSION XTEMP3(MAXOBV)
      DIMENSION XTEMP4(MAXOBV)
      EQUIVALENCE (GARBAG(IGARB1),Y1(1))
      EQUIVALENCE (GARBAG(IGARB2),XTEMP1(1))
      EQUIVALENCE (GARBAG(IGARB3),XTEMP2(1))
      EQUIVALENCE (GARBAG(IGARB4),XTEMP3(1))
      EQUIVALENCE (GARBAG(IGARB5),XTEMP4(1))
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOHK.INC'
      INCLUDE 'DPCODA.INC'
      INCLUDE 'DPCOHO.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IFOUND='NO'
      IERROR='NO'
C
      ISUBN1='DPCM'
      ISUBN2='E   '
C
      MAXCP1=MAXCOL+1
      MAXCP2=MAXCOL+2
      MAXCP3=MAXCOL+3
      MAXCP4=MAXCOL+4
      MAXCP5=MAXCOL+5
      MAXCP6=MAXCOL+6
C
C               **************************************************
C               **  TREAT THE COND. ... EXCEEDANCE    PLOT CASE **
C               **************************************************
C
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'CME')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPCME--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)ICASPL,IAND1,IAND2,MAXCOL
   52   FORMAT('ICASPL,IAND1,IAND2,MAXCOL = ',3(A4,2X),I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,53)IBUGG2,IBUGG3,IBUGQ,ISUBRO
   53   FORMAT('IBUGG2,IBUGG3,IBUGQ,ISUBRO = ',3(A4,2X),A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               ***************************
C               **  STEP 1--             **
C               **  EXTRACT THE COMMAND  **
C               ***************************
C
      ISTEPN='1'
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'CME')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      ICASPL='CME'
C
      IF(ICOM.EQ.'CME')THEN
         IF(NUMARG.GE.1)THEN
            IF(IHARG(1).EQ.'PLOT')THEN
               ICASPL='MEAN'
               ILASTC=1
               GOTO111
            ENDIF
         ENDIF
      ENDIF
C
      IF(ICOM.EQ.'COND')THEN
         IF(NUMARG.GE.2)THEN
            IF(IHARG(1).EQ.'EXCE'.AND.IHARG(2).EQ.'PLOT')THEN
               ICASPL='SCAT'
               ILASTC=2
               GOTO111
            ENDIF
         ENDIF
C
         IF(NUMARG.GE.3)THEN
            IF(IHARG(1).EQ.'SCAT'.AND.IHARG(2).EQ.'EXCE'.AND.
     1      IHARG(3).EQ.'PLOT')THEN
               ICASPL='SCAT'
               ILASTC=3
               GOTO111
            ENDIF
         ENDIF
         IF(NUMARG.GE.3)THEN
            IF(IHARG(1).EQ.'MEAN'.AND.IHARG(2).EQ.'EXCE'.AND.
     1      IHARG(3).EQ.'PLOT')THEN
               ICASPL='MEAN'
               ILASTC=3
               GOTO111
            ENDIF
         ENDIF
         IF(NUMARG.GE.3)THEN
            IF(IHARG(1).EQ.'MEDI'.AND.IHARG(2).EQ.'EXCE'.AND.
     1      IHARG(3).EQ.'PLOT')THEN
               ICASPL='MEDI'
               ILASTC=3
               GOTO111
            ENDIF
         ENDIF
         IF(NUMARG.GE.3)THEN
            IF(IHARG(1).EQ.'MIDM'.AND.IHARG(2).EQ.'EXCE'.AND.
     1      IHARG(3).EQ.'PLOT')THEN
               ICASPL='MIDM'
               ILASTC=3
               GOTO111
            ENDIF
         ENDIF
      ENDIF
C
      IF(ICOM.EQ.'YANG')THEN
         IF(NUMARG.GE.1)THEN
            IF(IHARG(1).EQ.'PLOT')THEN
               ICASPL='MEAN'
               ILASTC=1
               GOTO111
            ENDIF
         ENDIF
      ENDIF
C
      IF(ICOM.EQ.'LIFE')THEN
         IF(NUMARG.GE.2)THEN
            IF(IHARG(1).EQ.'EXPE'.AND.IHARG(2).EQ.'PLOT')THEN
               ICASPL='MEAN'
               ILASTC=2
               GOTO111
            ENDIF
         ENDIF
      ENDIF
C
      IF(ICOM.EQ.'MEAN')THEN
         IF(NUMARG.GE.3)THEN
            IF(IHARG(1).EQ.'LIFE'.AND.IHARG(2).EQ.'EXPE'.AND.
     1      IHARG(3).EQ.'PLOT')THEN
               ICASPL='MEAN'
               ILASTC=3
               GOTO111
            ENDIF
         ENDIF
      ENDIF
C
      IF(ICOM.EQ.'MEAN')THEN
         IF(NUMARG.GE.3)THEN
            IF(IHARG(1).EQ.'RESI'.AND.IHARG(2).EQ.'LIFE'.AND.
     1      IHARG(3).EQ.'PLOT')THEN
               ICASPL='MEAN'
               ILASTC=3
               GOTO111
            ENDIF
         ENDIF
      ENDIF
C
      GOTO9000
C
  111 CONTINUE
      CALL ADJUST(ILASTC,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG)
      IFOUND='YES'
C
C               ****************************************
C               **  STEP 2--                          **
C               **  EXTRACT THE VARIABLE LIST         **
C               ****************************************
C
      ISTEPN='2'
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'CME')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      INAME='CME PLOT'
      MINNA=1
      MAXNA=100
      MINN2=1
      IFLAGE=1
      IFLAGM=1
      IFLAGP=0
      JMIN=1
      JMAX=NUMARG
      MINNVA=1
      MAXNVA=1
C
      CALL DPPARS(IHARG,IHARG2,IARGT,ARG,NUMARG,IANS,IWIDTH,
     1            IHNAME,IHNAM2,IUSE,NUMNAM,IN,IVALUE,VALUE,
     1            JMIN,JMAX,
     1            MINN2,MINNA,MAXNA,MAXSPN,IFLAGE,INAME,
     1            IVARN1,IVARN2,IVARTY,PVAR,
     1            ILIS,NRIGHT,ICOLR,ISUB,NQ,ILOCQ,NUMVAR,
     1            MINNVA,MAXNVA,
     1            IFLAGM,IFLAGP,
     1            IBUGG3,IBUGQ,ISUBRO,IFOUND,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'CME')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,281)
  281   FORMAT('***** AFTER CALL DPPARS--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,282)NQ,NUMVAR
  282   FORMAT('NQ,NUMVAR = ',2I8)
        CALL DPWRST('XXX','BUG ')
        IF(NUMVAR.GT.0)THEN
          DO285I=1,NUMVAR
            WRITE(ICOUT,287)I,IVARN1(I),IVARN2(I),ILIS(I),NRIGHT(I),
     1                      ICOLR(I)
  287       FORMAT('I,IVARN1(I),IVARN2(I),ILIS(I),NRIGHT(I),',
     1             'ICOLR(I) = ',I8,2X,A4,A4,2X,3I8)
            CALL DPWRST('XXX','BUG ')
  285     CONTINUE
        ENDIF
      ENDIF
C
C               *****************************************************
C               **  STEP 9--                                       **
C               **  FORM THE VERTICAL AND HORIZONTAL AXIS          **
C               **  VALUES Y(.) AND X(.) FOR THE PLOT.             **
C               **  RESET THE VECTOR D(.) TO ALL ONES.             **
C               **  DEFINE THE NUMBER OF PLOT POINTS    (NPLOTP).  **
C               **  DEFINE THE NUMBER OF PLOT VARIABLES (NPLOTV).  **
C               *****************************************************
C
      ISTEPN='9'
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'CME')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      ICOL=1
      CALL DPPAR3(ICOL,IVALUE,IVALU2,IN,MAXN,MAXOBV,
     1            INAME,IVARN1,IVARN2,IVARTY,
     1            ILIS,NRIGHT,ICOLR,ISUB,NQ,NUMVAR,
     1            MAXCOL,MAXCP1,MAXCP2,MAXCP3,
     1            MAXCP4,MAXCP5,MAXCP6,
     1            V,PRED,RES,YPLOT,XPLOT,X2PLOT,TAGPLO,
     1            Y1,Y1,Y1,NLOCAL,NLOCAL,NLOCAL,ICASE,
     1            IBUGG3,ISUBRO,IFOUND,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      MAXNT1=MAXOBV
      MAXNT2=MAXOBV
      CALL DPCME2(Y1,NLOCAL,ICASPL,XTEMP1,MAXNT1,XTEMP2,MAXNT2,
     1            XTEMP3,XTEMP4,
     1            Y,X,D,NPLOTP,NPLOTV,IBUGG3,ISUBRO,IERROR)
C
C               ****************************************
C               **  STEP 10--                         **
C               **  COMPUTE SLOPE ESTIMATES OF THE    **
C               **  RESULTING TRACE                   **
C               ****************************************
C
      IWRITE='OFF'
      ISUBN0='DPPP'
      CALL LINFIT(Y,X,NPLOTP,
     1ALPHA,BETA,XRESSD,XRESDF,CCXY,SDALPH,SDBETA,CCALBE,
     1ISUBRO,IBUGG3,IERROR)
C
      IH='CMEC'
      IH2='C   '
      VALUE0=CCXY
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='CMEA'
      IH2='0   '
      VALUE0=ALPHA
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='CMEA'
      IH2='1   '
      VALUE0=BETA
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='SDCM'
      IH2='EA0 '
      VALUE0=SDALPH
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='SDCM'
      IH2='EA1 '
      VALUE0=SDBETA
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='CMER'
      IH2='ESSD'
      VALUE0=XRESSD
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='CMER'
      IH2='ESDF'
      VALUE0=XRESDF
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'CME')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPCME--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)IFOUND,IERROR
 9012   FORMAT('IFOUND,IERROR = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)NPLOTV,NPLOTP,NS,ICASPL,IAND1,IAND2
 9013   FORMAT('NPLOTV,NPLOTP,NS,ICASPL,IAND1,IAND2 = ',3I8,3(2X,A4))
        CALL DPWRST('XXX','BUG ')
        IF(NPLOTP.GT.0)THEN
          DO9020I=1,NPLOTP
            WRITE(ICOUT,9021)I,Y(I),X(I),D(I)
 9021       FORMAT('I,Y(I),X(I),D(I) = ',I8,3F12.5)
            CALL DPWRST('XXX','BUG ')
 9020     CONTINUE
        ENDIF
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPCME2(Y,N,ICASPL,XTEMP1,MAXNT1,XTEMP2,MAXNT2,
     1                  Z,ZITEMS,
     1                  Y2,X2,D2,N2,NPLOTV,IBUGG3,ISUBRO,IERROR)
C
C     PURPOSE--GENERATE A PAIR OF COORDINATE VECTORS
C              THAT WILL DEFINE ONE OF THE FOLLOWING 4
C              CONDITIONAL EXCEEDANCE PLOTS--
C                 CONDITIONAL EXCEEDANCE PLOT Y
C                 CONDITIONAL MEAN EXCEEDANCE PLOT Y (= CME PLOT Y)
C                 CONDITIONAL MEDIAN EXCEEDANCE PLOT Y
C                 CONDITIONAL MIDMEAN EXCEEDANCE PLOT Y
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--93/12
C     ORIGINAL VERSION--DECEMBER   1993.
C     UPDATED         --FEBRUARY   1994. HANDLE TIES CORRECTLY
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICASPL
      CHARACTER*4 IBUGG3
      CHARACTER*4 ISUBRO
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION XTEMP1(*)
      DIMENSION XTEMP2(*)
      DIMENSION Y2(*)
      DIMENSION X2(*)
      DIMENSION D2(*)
CCCCC FEBRUARY 1994.  ADD FOLLOWING 2 LINES
      DIMENSION Z(*)
      DIMENSION ZITEMS(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPCM'
      ISUBN2='E2  '
C
      IERROR='NO'
C
      IF(IBUGG3.EQ.'ON'.OR.ISUBRO.EQ.'CME2')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,71)
   71   FORMAT('***** AT THE BEGINNING OF DPCME2--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,72)ICASPL,N,NPLOTV
   72   FORMAT('ICASPL,N,NPLOTV = ',A4,2X,I8,I8)
        CALL DPWRST('XXX','BUG ')
        IF(N.GT.0)THEN
          DO85I=1,N
            WRITE(ICOUT,86)I,Y(I)
   86       FORMAT('I,Y(I) = ',I8,G15.7)
            CALL DPWRST('XXX','BUG ')
   85     CONTINUE
        ENDIF
      ENDIF
C               ********************************************
C               **  STEP 1--                              **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      IF(N.LT.2)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,111)
  111   FORMAT('***** ERROR IN CME PLOT--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,112)
  112   FORMAT('      THE NUMBER OF OBSERVATIONS MUST BE AT LEAST 2.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,114)N
  114   FORMAT('      THE ENTERED NUMBER OF OBSERVATIONS HERE = ',I6)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
CCCCC FOLLOWING ALGORITHM UPDATED TO HANDLE TIES CORRECTLY.  
CCCCC FIRST,, DETERMINE IF TIES EXIST AND BRANCH TO DISTINCT SECTION
CCCCC IF THEY DO.  FEBRUARY 1994.
C
C               ****************************************
C               **  STEP 1A--                         **
C               **  DETERMINE IF TIES EXIST.          **
C               ****************************************
C
      DO99I=1,N
      ZITEMS(I)=0.0
 99   CONTINUE
      NZ=0
      DO100I=1,N
        IF(I.EQ.1)GOTO130
        DO120J=1,NZ
          IF(Y(I).EQ.Z(J))THEN
            ZITEMS(J)=ZITEMS(J)+1.0
            GOTO100
          ENDIF
 120   CONTINUE
 130   CONTINUE
       NZ=NZ+1
       Z(NZ)=Y(I)
       ZITEMS(J)=1.0
 100  CONTINUE
C
      IF(IBUGG3.EQ.'ON'.OR.ISUBRO.EQ.'CME2')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,171)
  171   FORMAT('***** AFTER CHECKING FOR TIES--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,172)N,NZ
  172   FORMAT('N,NZ = ',2I8)
        CALL DPWRST('XXX','BUG ')
        IF(NZ.GT.0)THEN
          DO185I=1,NZ
            WRITE(ICOUT,186)I,Z(I)
  186       FORMAT('I,Z(I) = ',I8,G15.7)
            CALL DPWRST('XXX','BUG ')
  185     CONTINUE
        ENDIF
      ENDIF
C
      IF(NZ.LT.N)GOTO2000
C
C               ****************************************
C               **  CASE WITH NO TIES                 **
C               ****************************************
C
C               ****************************************
C               **  STEP 1--                          **
C               **  DETERMINE PLOT COORDINATES        **
C               ****************************************
C
      CALL SORT(Y,N,Y)
C
      IWRITE='OFF'
      J=0
      NM1=N-1
      DO1100I=1,NM1
         Y0=Y(I)
         IP1=I+1
C
         NTEMP1=0
         DO1200K=IP1,N
            NTEMP1=NTEMP1+1
            XTEMP1(NTEMP1)=Y(K)-Y0
 1200    CONTINUE
C
         IF(ICASPL.EQ.'SCAT')THEN
            DO1210L=1,NTEMP1
               J=J+1
               Y2(J)=XTEMP1(L)
               X2(J)=Y0
               D2(J)=I
 1210    CONTINUE
C
         ELSEIF(ICASPL.EQ.'MEAN')THEN
            CALL MEAN(XTEMP1,NTEMP1,IWRITE,XMEAN,IBUGG3,IERROR)
            J=J+1
            Y2(J)=XMEAN
            X2(J)=Y0
            D2(J)=1.0
C
         ELSEIF(ICASPL.EQ.'MEDI')THEN
            CALL MEDIAN(XTEMP1,NTEMP1,IWRITE,XTEMP2,MAXNT2,XMED,
     1                  IBUGG3,IERROR)
            J=J+1
            Y2(J)=XMED
            X2(J)=Y0
            D2(J)=1.0
C
         ELSEIF(ICASPL.EQ.'MIDM')THEN
            IF(NTEMP1.EQ.1)THEN
              XMIDM=XTEMP1(1)
            ELSE
              CALL MIDMEA(XTEMP1,NTEMP1,IWRITE,XTEMP2,MAXNT2,XMIDM,
     1                  IBUGG3,IERROR)
            ENDIF
            J=J+1
            Y2(J)=XMIDM
            X2(J)=Y0
            D2(J)=1.0
         ENDIF
C
 1100 CONTINUE
      N2=J
      NPLOTV=2
      GOTO9000
C
 2000 CONTINUE
C
C               ****************************************
C               **  CASE WITH TIES                    **
C               ****************************************
C
C               ****************************************
C               **  STEP 1--                          **
C               **  DETERMINE PLOT COORDINATES        **
C               ****************************************
C
      CALL SORTC(Z,ZITEMS,NZ,Z,ZITEMS)
C
      IWRITE='OFF'
      J=0
      NM1=NZ-1
      DO2100I=1,NM1
         Z0=Z(I)
         IP1=I+1
C
         NTEMP1=0
         IF(ICASPL.EQ.'SCAT')THEN
           DO2200K=IP1,NZ
             NTEMP1=NTEMP1+1
             XTEMP1(NTEMP1)=Z(K)-Z0
 2200      CONTINUE
         ELSEIF(ICASPL.EQ.'MEAN')THEN
           ATEMP=0.0
           DO2210K=IP1,NZ
             NTEMP1=NTEMP1+1
             XTEMP1(NTEMP1)=Z(K)-Z0
             XTEMP2(NTEMP1)=ZITEMS(K)
 2210      CONTINUE
         ELSEIF(ICASPL.EQ.'MEDI'.OR.ICASPL.EQ.'MIDM')THEN
           DO2220K=IP1,NZ
             NITEMS=INT(ZITEMS(K)+0.5)
             DO2225KK=1,NITEMS
               NTEMP1=NTEMP1+1
               XTEMP1(NTEMP1)=Z(K)-Z0
 2225        CONTINUE
 2220      CONTINUE
         ENDIF
C
         IF(ICASPL.EQ.'SCAT')THEN
            DO2310L=1,NTEMP1
               J=J+1
               Y2(J)=XTEMP1(L)
               X2(J)=Z0
               D2(J)=I
 2310      CONTINUE
C
         ELSEIF(ICASPL.EQ.'MEAN')THEN
            IF(NTEMP1.EQ.1)THEN
              XMEAN=XTEMP1(1)
            ELSE
              CALL WEMEAN(XTEMP1,XTEMP2,NTEMP1,IWRITE,XMEAN,
     1                  IBUGG3,IERROR)
            ENDIF
            J=J+1
            Y2(J)=XMEAN
            X2(J)=Z0
            D2(J)=1.0
C
         ELSEIF(ICASPL.EQ.'MEDI')THEN
            CALL MEDIAN(XTEMP1,NTEMP1,IWRITE,XTEMP2,MAXNT2,XMED,
     1                  IBUGG3,IERROR)
            J=J+1
            Y2(J)=XMED
            X2(J)=Z0
            D2(J)=1.0
C
         ELSEIF(ICASPL.EQ.'MIDM')THEN
            IF(NTEMP1.EQ.1)THEN
              XMIDM=XTEMP1(1)
            ELSE
              CALL MIDMEA(XTEMP1,NTEMP1,IWRITE,XTEMP2,MAXNT2,XMIDM,
     1                  IBUGG3,IERROR)
            ENDIF
            J=J+1
            Y2(J)=XMIDM
            X2(J)=Z0
            D2(J)=1.0
         ENDIF
C
 2100 CONTINUE
      N2=J
      NPLOTV=2
      GOTO9000
C
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG3.EQ.'ON'.OR.ISUBRO.EQ.'CME2')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPCME2--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)ICASPL,IERROR,N,N2,NPLOTV
 9012   FORMAT('ICASPL,IERROR,N,N2,NPLOTV = ',2(A4,2X),3I8)
        CALL DPWRST('XXX','BUG ')
        DO9015I=1,N2
          WRITE(ICOUT,9016)I,Y2(I),X2(I),D2(I)
 9016     FORMAT('I,Y2(I),X2(I),D2(I) = ',I8,3G15.7)
          CALL DPWRST('XXX','BUG ')
 9015   CONTINUE
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPCMPL(NPLOTV,NPLOTP,NS,ICASPL,IAND1,IAND2,
     1ICAPSW,ICAPTY,
     1IFORSW,ISEED,IBOOSS,
     1ISUBRO,IBUGG2,IBUGG3,IBUGQ,IFOUND,IERROR)
C
C     PURPOSE--GENERATE A CONSENSUS MEAN PLOT--
C              THE COMMAND HAS THE FOLLOWING FORMAT:
C                  CONSENSUS MEAN PLOT Y X 
C              OR
C                  CONSENSUS MEAN PLOT YMEAN YSD NI
C              THIS PLOT DISPLAYS THE RESULTS OF A CONSENSUS MEAN ANALYSIS.
C              IT IS USEFUL FOR PROVIDING A COMPARISON OF THE VARIOUS
C              METHODS OF COMPUTING CONSENSUS MEANS.
C     EXAMPLE--CONSENSUS MEAN PLOT Y X
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2001/8
C     ORIGINAL VERSION--AUGUST    2001.
C     UPDATED         --OCTOBER   2002. ADD ICAPSW, ICAPTY TO CALL
C                                       LIST (PASS TO DPCMP2)
C     UPDATED         --MARCH     2006. ADD IFORSW TO CALL LIST
C     UPDATED         --MAY       2010. UPDATE LIST OF SUPPORTED
C                                       METHODS
C     UPDATED         --MAY       2010. USE DPPARS
C     UPDATED         --OCTOBER   2011. ADD LAB DATA TO PLOT
C     UPDATED         --OCTOBER   2011. OPTION TO SORT METHODS BASED
C                                       ON INTERVAL WIDTH
C     UPDATED         --JUNE      2012. ADD "IBOOSS" TO CALL LIST (FOR
C                                       BOOTSTRAP COMPUTATIONS)
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 ICASPL
      CHARACTER*4 IAND1
      CHARACTER*4 IAND2
      CHARACTER*4 IBUGG2
      CHARACTER*4 IBUGG3
      CHARACTER*4 IBUGQ
      CHARACTER*4 ISUBRO
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
      CHARACTER*4 IH
      CHARACTER*4 IH1
      CHARACTER*4 IH2
      CHARACTER*4 IHWUSE
      CHARACTER*4 MESSAG
      CHARACTER*4 ICASEQ
C
      DOUBLE PRECISION YDL
      DOUBLE PRECISION DLOWD4
      DOUBLE PRECISION DHIGD4
      DOUBLE PRECISION DLOWD5
      DOUBLE PRECISION DHIGD5
      DOUBLE PRECISION DLOWD6
      DOUBLE PRECISION DHIGD6
C
      CHARACTER*40 INAME
      PARAMETER (MAXSPN=10)
      CHARACTER*4 IVARN1(MAXSPN)
      CHARACTER*4 IVARN2(MAXSPN)
      CHARACTER*4 IVARTY(MAXSPN)
      REAL PVAR(MAXSPN)
      INTEGER ILIS(MAXSPN)
      INTEGER NRIGHT(MAXSPN)
      INTEGER ICOLR(MAXSPN)
C
      CHARACTER*4 ISUBN0
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
C
      DIMENSION Y1(MAXOBV)
      DIMENSION Y2(MAXOBV)
      DIMENSION Y3(MAXOBV)
C
      INTEGER IZ(MAXOBV)
      INTEGER IZ2(MAXOBV)
      INTEGER ITEMP1(MAXOBV)
      INTEGER IZFULL(MAXOBV)
C
      DOUBLE PRECISION Z2(MAXOBV)
      DOUBLE PRECISION Z3(MAXOBV)
      DOUBLE PRECISION Z4(MAXOBV)
      DOUBLE PRECISION DTEMP1(MAXOBV)
      DOUBLE PRECISION DTEMP2(MAXOBV)
      DOUBLE PRECISION DTEMP3(MAXOBV)
C
      DIMENSION Z1(MAXOBV)
      DIMENSION Z6(MAXOBV)
      DIMENSION Z7(MAXOBV)
      DIMENSION Z8(MAXOBV)
      DIMENSION Z9(MAXOBV)
      DIMENSION PLABID(MAXOBV)
      DIMENSION XTEMP1(MAXOBV)
      DIMENSION XTEMP2(MAXOBV)
      DIMENSION XTEMP3(MAXOBV)
      DIMENSION XTEMP4(MAXOBV)
      DIMENSION XPLOTZ(MAXOBV)
      DIMENSION YPLOTZ(MAXOBV)
C
      INCLUDE 'DPCOZ2.INC'
      EQUIVALENCE (G2RBAG(IGAR11),Y1(1))
      EQUIVALENCE (G2RBAG(IGAR12),Y2(1))
      EQUIVALENCE (G2RBAG(IGAR13),Y3(1))
      EQUIVALENCE (G2RBAG(IGAR14),Z1(1))
      EQUIVALENCE (G2RBAG(IGAR23),Z6(1))
      EQUIVALENCE (G2RBAG(IGAR24),Z7(1))
      EQUIVALENCE (G2RBAG(IGAR25),Z8(1))
      EQUIVALENCE (G2RBAG(IGAR26),Z9(1))
      EQUIVALENCE (G2RBAG(IGAR27),PLABID(1))
      EQUIVALENCE (G2RBAG(IGAR28),XTEMP1(1))
      EQUIVALENCE (G2RBAG(IGAR29),XTEMP2(1))
      EQUIVALENCE (G2RBAG(IGAR30),XTEMP3(1))
      EQUIVALENCE (G2RBAG(IGAR31),XTEMP4(1))
      EQUIVALENCE (G2RBAG(IGAR32),XPLOTZ(1))
      EQUIVALENCE (G2RBAG(IGAR33),YPLOTZ(1))
C
      INCLUDE 'DPCOZD.INC'
      EQUIVALENCE (DGARBG(IDGAR1),Z2(1))
      EQUIVALENCE (DGARBG(IDGAR2),Z3(1))
      EQUIVALENCE (DGARBG(IDGAR3),Z4(1))
      EQUIVALENCE (DGARBG(IDGAR4),DTEMP1(1))
      EQUIVALENCE (DGARBG(IDGAR5),DTEMP2(1))
      EQUIVALENCE (DGARBG(IDGAR6),DTEMP3(1))
C
      INCLUDE 'DPCOZI.INC'
      EQUIVALENCE (IGARBG(IIGAR1),IZ(1))
      EQUIVALENCE (IGARBG(IIGAR2),IZ2(1))
      EQUIVALENCE (IGARBG(IIGAR3),ITEMP1(1))
      EQUIVALENCE (IGARBG(IIGAR4),IZFULL(1))
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOHO.INC'
      INCLUDE 'DPCOHK.INC'
      INCLUDE 'DPCODA.INC'
      INCLUDE 'DPCOST.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IERROR='NO'
      IFOUND='NO'
      ISUBN1='DPCM'
      ISUBN2='PL  '
      ICASPL='CMPL'
C
      MAXCP1=MAXCOL+1
      MAXCP2=MAXCOL+2
      MAXCP3=MAXCOL+3
      MAXCP4=MAXCOL+4
      MAXCP5=MAXCOL+5
      MAXCP6=MAXCOL+6
C
C               *******************************************
C               **  TREAT THE CONSENSUS MEAN PLOT CASE   **
C               *******************************************
C
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'CMPL')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPCMPL--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGG2,IBUGG3,IBUGQ,ISUBRO
   52   FORMAT('IBUGG2,IBUGG3,IBUGQ,ISUBRO = ',A4,2X,A4,2X,A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,53)ICASPL,IAND1,IAND2,MAXN
   53   FORMAT('ICASPL,IAND1,IAND2,MAXN = ',3(A4,2X),I8)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               ***************************
C               **  STEP 1--             **
C               **  EXTRACT THE COMMAND  **
C               ***************************
C
      ISTEPN='11'
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'CMPL')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(NUMARG.GE.2.AND.IHARG(1).EQ.'MEAN'.AND.IHARG(2).EQ.'PLOT')
     1   THEN
         ILASTC=2
         CALL ADJUST(ILASTC,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG)
         IFOUND='YES'
      ELSE
         IFOUND='NO'
         GOTO9000
      ENDIF
C
C               ****************************************
C               **  STEP 2--                          **
C               **  EXTRACT THE VARIABLE LIST         **
C               ****************************************
C
      ISTEPN='2'
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'CMPL')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      INAME='CONSENSUS MEAN PLOT'
      MINNA=2
      MAXNA=100
      MINN2=2
      IFLAGE=1
      IFLAGM=0
      IFLAGP=0
      JMIN=1
      JMAX=NUMARG
      MINNVA=2
      MAXNVA=4
C
      CALL DPPARS(IHARG,IHARG2,IARGT,ARG,NUMARG,IANS,IWIDTH,
     1            IHNAME,IHNAM2,IUSE,NUMNAM,IN,IVALUE,VALUE,
     1            JMIN,JMAX,
     1            MINN2,MINNA,MAXNA,MAXSPN,IFLAGE,INAME,
     1            IVARN1,IVARN2,IVARTY,PVAR,
     1            ILIS,NRIGHT,ICOLR,ISUB,NQ,ILOCQ,NUMVAR,
     1            MINNVA,MAXNVA,
     1            IFLAGM,IFLAGP,
     1            IBUGG3,IBUGQ,ISUBRO,IFOUND,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'CMPL')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,281)
  281   FORMAT('***** AFTER CALL DPPARS--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,282)NQ,NUMVAR
  282   FORMAT('NQ,NUMVAR = ',2I8)
        CALL DPWRST('XXX','BUG ')
        IF(NUMVAR.GT.0)THEN
          DO285I=1,NUMVAR
            WRITE(ICOUT,287)I,IVARN1(I),IVARN2(I),ILIS(I),NRIGHT(I),
     1                      ICOLR(I)
  287       FORMAT('I,IVARN1(I),IVARN2(I),ILIS(I),NRIGHT(I),',
     1             'ICOLR(I) = ',I8,2X,A4,A4,2X,3I8)
            CALL DPWRST('XXX','BUG ')
  285     CONTINUE
        ENDIF
      ENDIF
C
C               ****************************************
C               **  STEP 3--                          **
C               **  EXTRACT THE DATA                  **
C               ****************************************
C
      ICOL=1
      CALL DPPAR5(ICOL,IVALUE,IVALU2,IN,MAXN,MAXOBV,
     1            INAME,IVARN1,IVARN2,IVARTY,
     1            ILIS,NRIGHT,ICOLR,ISUB,NQ,NUMVAR,
     1            MAXCOL,MAXCP1,MAXCP2,MAXCP3,
     1            MAXCP4,MAXCP5,MAXCP6,
     1            V,PRED,RES,YPLOT,XPLOT,X2PLOT,TAGPLO,
     1            Y1,Y2,Y3,PLABID,Z9,Z9,Z9,NLOCAL,
     1            IBUGG3,ISUBRO,IFOUND,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
C               *******************************************************
C               **  STEP 8--                                         **
C               **  FORM THE VERTICAL AND HORIZONTAL AXIS            **
C               **  VALUES Y(.) AND X(.) FOR THE PLOT.               **
C               **  DEFINE THE NUMBER OF PLOT POINTS    (NPLOTP).    **
C               **  DEFINE THE NUMBER OF PLOT VARIABLES (NPLOTV).    **
C               *******************************************************
C
      ISTEPN='5'
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'CMPL')THEN
        CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
        WRITE(ICOUT,5001)NLOCAL,ICASPL
 5001   FORMAT('NLOCAL,ICASPL=',I5,1X,A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      IH='SIGM'
      IH2='AH  '
      IHWUSE='P'
      MESSAG='NO'
      CALL CHECKN(IH,IH2,IHWUSE,
     1IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOCP,IERROR)
      IF(IERROR.EQ.'YES')THEN
        SIGMAH=0.0
      ELSE
        SIGMAH=VALUE(ILOCP)
        IF(SIGMAH.LT.0.0)SIGMAH=0.0
      ENDIF
      IH='DFH '
      IH2='    '
      IHWUSE='P'
      MESSAG='NO'
      CALL CHECKN(IH,IH2,IHWUSE,
     1IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOCP,IERROR)
      IF(IERROR.EQ.'YES')THEN
        IDFH=1
      ELSE
        IDFH=INT(VALUE(ILOCP)+ 0.5)
      ENDIF
      IF(IDFH.LE.0)IDFH=1
C
C     MARCH 2006.  ADD IFORSW TO CALL LIST.
C
      MAXNXT=MAXOBV
      CALL DPCMP2(Y1,Y2,Y3,PLABID,NLOCAL,ICASPL,NUMVAR,MAXNXT,
     1            Z1,Z2,Z3,Z4,
     1            Z6,Z7,IZ,
     1            Z8,Z9,IZFULL,
     1            XTEMP1,XTEMP2,XTEMP3,XTEMP4,ITEMP1,
     1            DTEMP1,DTEMP2,DTEMP3,
     1            XPLOTZ,YPLOTZ,NPLOT,
     1            IVARN1(1),IVARN2(1),IVARN1(2),IVARN2(2),
     1            IVARN1(3),IVARN2(3),
     1            SIGMAH,IDFH,
     1            XGRAND,S2WPOO,SW,ASD2,ASD3,
     1            SET1,SET2,
     1            XMPS,S2BMPS,SEMP,
     1            XMMPS,S2BMMP,SEMMP,
     1            XMLS,S2BMLS,SEML,
     1            XSE,XSES2,ABIAS,ISEDF,
     1            ASM,ASB,AKU,
CCCCC             MARCH   2006.  ADD FOLLOWING 2 LINES TO CALL LIST
     1            XGD,XGDS2,
     1            XGCI,XDL,XDLS2,YDL,SEDLK1,SEHDK1,SERUK1,XDLK2,XDLK3,
     1            SEBOK1,SEBOK2,DLOWD4,DHIGD4,
     1            DLOWD5,DHIGD5,DLOWD6,DHIGD6,
     1            SEGCI,XFW,SEFWK1,SEFWK2,
     1            XBCP,XBCPSE,XBCPK1,XBCPK2,
     1            Y,X,D,
CCCCC             OCTOBER 2002. ADD ICAPSW, ICAPTY TO CALL LIST
     1            ICAPSW,ICAPTY,IFORSW,ISEED,IBOOSS,
     1            ICMPSO,ICMPDA,ICMPER,
     1            NPLOTP,NPLOTV,IBUGG3,ISUBRO,IERROR)
C
C               ***************************************
C               **  STEP 10--                        **
C               **  UPDATE INTERNAL DATAPLOT TABLES  **
C               ***************************************
C
      ISTEPN='10'
      IF(IBUGG2.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IH='XGRA'
      IH2='ND  '
      VALUE0=XGRAND
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='S2PO'
      IH2='OOL '
      VALUE0=S2WPOO
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='YBAR'
      IH2='SD1 '
      VALUE0=ASD2
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='YBAR'
      IH2='SD2 '
      VALUE0=ASD3
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='T1ST'
      IH2='DERR'
      VALUE0=SET1
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='T2ST'
      IH2='DERR'
      VALUE0=SET2
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='SEME'
      IH2='AN  '
      VALUE0=XSE
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='SES2'
      IH2='    '
      VALUE0=XSES2
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='BIAS'
      IH2='ALLO'
      VALUE0=ABIAS
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='SEDF'
      IH2='    '
      VALUE0=REAL(ISEDF)
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='MPME'
      IH2='AN  '
      VALUE0=XMPS
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='MPS2'
      IH2='    '
      VALUE0=S2BMPS
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='SEMP'
      IH2='    '
      VALUE0=SEMP
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='MMPM'
      IH2='EAN '
      VALUE0=XMMPS
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='MMPS'
      IH2='2   '
      VALUE0=S2BMMP
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='SEMM'
      IH2='P   '
      VALUE0=SEMMP
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='MLME'
      IH2='AN  '
      VALUE0=XMLS
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='MLS2'
      IH2='    '
      VALUE0=S2BMLS
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='SEML'
      IH2='    '
      VALUE0=SEML
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='BOBM'
      IH2='EAN '
      VALUE0=ASM
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='BOBS'
      IH2='2   '
      VALUE0=ASB
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='BOBS'
      IH2='2W  '
      VALUE0=SW
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='BOBK'
      IH2='U   '
      VALUE0=AKU
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='GDME'
      IH2='AN  '
      VALUE0=XGD
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='GDS2'
      IH2='    '
      VALUE0=XGDS2
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='GCIM'
      IH2='EAN '
      VALUE0=XGCI
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='GCIS'
      IH2='E   '
      VALUE0=SEGCI
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='DERS'
      IH2='MEAN'
      VALUE0=XDL
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='YDL '
      IH2='    '
      VALUE0=YDL
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='DERS'
      IH2='VARI'
      VALUE0=XDLS2
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='DERS'
      IH2='SE  '
      VALUE0=SEDLK1
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='DERS'
      IH2='SEHD'
      VALUE0=SEHDK1
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='DERS'
      IH2='SERU'
      VALUE0=SERUK1
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='DERS'
      IH2='SEBS'
      VALUE0=SEBOK1
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='DERS'
      IH2='BOK2'
      VALUE0=XDLK2
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='DERS'
      IH2='BOK3'
      VALUE0=XDLK3
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='FAIR'
      IH2='MEAN'
      VALUE0=XFW
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='FAIR'
      IH2='SE  '
      VALUE0=SEFWK1
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='BCPM'
      IH2='EAN '
      VALUE0=XBCP
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
      IH='BCPS'
      IH2='E   '
      VALUE0=XBCPSE
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
C               *****************
C               **  STEP 9--   **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'CMPL')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPCMPL--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)IBUGG2,IBUGG3,IBUGQ,ISUBRO
 9012   FORMAT('IBUGG2,IBUGG3,IBUGQ,ISUBRO = ',3(A4,2X),A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)IFOUND,IERROR,NLOCAL,NPLOTP
 9013   FORMAT('IFOUND,IERROR,NLOCAL,NPLOTP = ',A4,2X,A4,2X,2I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9014)NPLOTV,NPLOTP,NLOCAL,ICASPL,IAND1,IAND2
 9014   FORMAT('NPLOTV,NPLOTP,NLOCAL,ICASPL,IAND1,IAND2 = ',
     1         I8,I8,I8,2X,A4,2X,A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        IF(NPLOTP.GT.0)THEN
          DO9052I=1,NPLOTP
            WRITE(ICOUT,9053)I,Y(I),X(I),D(I)
 9053       FORMAT('I,Y(I),X(I),D(I) = ',I8,3F12.5)
            CALL DPWRST('XXX','BUG ')
 9052     CONTINUE
        ENDIF
 9090 ENDIF
C
      RETURN
      END
      SUBROUTINE DPCMP2(Y1,Y2,Y3,PLABID,NZ,ICASPL,NUMV2,MAXNXT,
     1                  DAT,DX,T,W,
     1                  AMEAN,ASD,N,
     1                  AMEANF,ASDF,NFULL,
     1                  XTEMP1,XTEMP2,XTEMP3,XTEMP4,ITEMP1,
     1                  DTEMP1,DTEMP2,DTEMP3,
     1                  XPLOT,YPLOT,NPLOT,
     1                  IHLEFT,IHLEF2,IHRIGH,IHRIG2,IHRI21,IHRI22,
     1                  SIGMAH,IDFH,
     1                  XGRAND,S2WPOO,SW,ASD2,ASD3,
     1                  SET1,SET2,
     1                  XMPS,S2BMPS,SEMP,
     1                  XMMPS,S2BMMP,SEMMP,
     1                  XMLS,S2BMLS,SEML,
     1                  XSE,XSES2,ABIAS,ISEDF,
     1                  ASM,ASB,AKU,
     1                  XGD,XGDS2,
     1                  XGCI,XDL,XDLS2,YDL,SEDLK1,SEHDK1,SERUK1,
     1                  XDLK2,XDLK3,
     1                  SEBOK1,SEBOK2,DLOWD4,DHIGD4,
     1                  DLOWD5,DHIGD5,DLOWD6,DHIGD6,
     1                  SEGCI,XFW,SEFWK1,SEFWK2,
     1                  XBCP,XBCPSE,XBCPK1,XBCPK2,
     1                  Y,X,D,
CCCCC                   OCTOBER 2002. ADD ICAPSW, ICAPTY TO CALL LIST
CCCCC                   MARCH   2006. ADD IFORSW TO CALL LIST
     1                  ICAPSW,ICAPTY,IFORSW,ISEED,IBOOSS,
     1                  ICMPSO,ICMPDA,ICMPER,
     1                  N2,NPLOTV,IBUGG3,ISUBRO,IERROR)
C
C     PURPOSE--GENERATE A PAIR OF COORDINATE VECTORS THAT WILL DEFINE A
C              CONSENSUS MEAN PLOT
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2001/8
C     ORIGINAL VERSION--AUGUST    2001.
C     UPDATED  VERSION--APRIL     2002. PRINT OUT ORDER OF METHODS ON
C                                       PLOT
C     UPDATED  VERSION--OCTOBER   2002. ADD ICAPSW, ICAPTY TO CALL
C                                       LIST (PASS TO DPMAN2)
C     UPDATED  VERSION--MAY       2010. UPDATE LIST OF METHODS
C     UPDATED  VERSION--OCTOBER   2011. LABID VARIABLE (PLABID)
C     UPDATED  VERSION--OCTOBER   2011. ADD LABS TO THE PLOT
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IWRITE
      CHARACTER*4 ICASPL
      CHARACTER*4 IFORSW
      CHARACTER*4 ICMPDA
      CHARACTER*4 ICMPSO
      CHARACTER*4 ICMPER
      CHARACTER*4 IBUGG3
      CHARACTER*4 ISUBRO
      CHARACTER*4 IERROR
C
      CHARACTER*4 IHLEFT
      CHARACTER*4 IHLEF2
      CHARACTER*4 IHRIGH
      CHARACTER*4 IHRIG2
      CHARACTER*4 IHRI21
      CHARACTER*4 IHRI22
C
      CHARACTER*4 ISUBN0
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
      DOUBLE PRECISION YDL
      DOUBLE PRECISION DLOWD4
      DOUBLE PRECISION DHIGD4
      DOUBLE PRECISION DLOWD5
      DOUBLE PRECISION DHIGD5
      DOUBLE PRECISION DLOWD6
      DOUBLE PRECISION DHIGD6
C
C---------------------------------------------------------------------
C
      DIMENSION XMID(20)
      DOUBLE PRECISION DXLOW(20)
      DOUBLE PRECISION DXHIGH(20)
      CHARACTER*30 ILAB(20)
C
      DIMENSION Y1(*)
      DIMENSION Y2(*)
      DIMENSION Y3(*)
      DIMENSION PLABID(*)
      DIMENSION AMEAN(*)
      DIMENSION ASD(*)
      DIMENSION AMEANF(*)
      DIMENSION ASDF(*)
      DIMENSION DAT(*)
      DIMENSION XTEMP1(*)
      DIMENSION XTEMP2(*)
      DIMENSION XTEMP3(*)
      DIMENSION XTEMP4(*)
      DIMENSION XPLOT(*)
      DIMENSION YPLOT(*)
C
      DIMENSION Y(*)
      DIMENSION X(*)
      DIMENSION D(*)
C
      DOUBLE PRECISION DX(*)
      DOUBLE PRECISION T(*)
      DOUBLE PRECISION W(*)
      DOUBLE PRECISION DTEMP1(*)
      DOUBLE PRECISION DTEMP2(*)
      DOUBLE PRECISION DTEMP3(*)
C
      INTEGER N(*)
      INTEGER NFULL(*)
      INTEGER ITEMP1(*)
C
      CHARACTER*4 IOP
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPCM'
      ISUBN2='P2  '
      IERROR='NO'
      ISUBN0='CMP2'
C
      IF(IBUGG3.EQ.'ON'.OR.ISUBRO.EQ.'CMP2')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,71)
   71   FORMAT('***** AT THE BEGINNING OF DPCMP2--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,72)ICASPL,NZ,N2,NPLOTV,NUMV2
   72   FORMAT('ICASPL,NZ,N2,NPLOTV,NUMV2 = ',A4,2X,4I8)
        CALL DPWRST('XXX','BUG ')
        IF(NZ.GT.0)THEN
          DO81I=1,NZ
            WRITE(ICOUT,82)I,Y1(I),Y2(I),Y3(I),PLABID(I)
   82       FORMAT('I,Y1(I),Y2(I),Y3(I),PLABID(I) = ',I8,4G15.7)
   81     CONTINUE
        ENDIF
      ENDIF
C
C               ********************************************
C               **  STEP 1--                              **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      IF(NZ.LT.2)THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,31)
   31   FORMAT('***** ERROR IN CONSENSUS MEAN PLOT--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,32)
   32   FORMAT('      THE NUMBER OF OBSERVATIONS MUST BE AT LEAST TWO;')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,34)NZ
   34   FORMAT('      THE ENTERED NUMBER OF OBSERVATIONS HERE = ',I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
C               ****************************************
C               **  STEP 1--                          **
C               **  CALL DPMAN2 TO OBTAIN CONSENSUS   **
C               **  MEAN ESTIMATES.                   **
C               ****************************************
C
      IWRITE='OFF'
CCCCC IWRITE='ON'
      CALL DPMAN2(Y1,Y2,Y3,PLABID,NZ,NUMV2,MAXNXT,
     1            DAT,DX,T,W,
     1            AMEAN,ASD,N,
     1            AMEANF,ASDF,NFULL,
     1            XTEMP1,XTEMP2,XTEMP3,XTEMP4,ITEMP1,
     1            DTEMP1,DTEMP2,DTEMP3,
     1            XPLOT,YPLOT,NPLOT,
     1            IHLEFT,IHLEF2,IHRIGH,IHRIG2,IHRI21,IHRI22,
     1            SIGMAH,IDFH,
     1            XGRAND,S2WPOO,SW,ASD2,ASD3,
     1            SET1,SET2,
     1            XMPS,S2BMPS,SEMP,
     1            XMMPS,S2BMMP,SEMMP,
     1            XMLS,S2BMLS,SEML,
     1            XSE,XSES2,ABIAS,ISEDF,
     1            ASM,ASB,AKU,
     1            XGD,XGDS2,
     1            XGCI,XDL,XDLS2,YDL,SEDLK1,SEHDK1,SERUK1,XDLK2,XDLK3,
     1            SEBOK1,SEBOK2,DLOWD4,DHIGD4,
     1            DLOWD5,DHIGD5,DLOWD6,DHIGD6,
     1            SEGCI,XFW,SEFWK1,SEFWK2,
     1            XBCP,XBCPSE,XBCPK1,XBCPK2,
     1            IWRITE,
     1            ICAPSW,ICAPTY,IFORSW,ISEED,IBOOSS,
     1            ISUBRO,IBUGG3,IERROR)
C
C               ****************************************
C               **  STEP 2--                          **
C               **  READ VALUES BACK FROM FILE        **
C               ****************************************
C
      IOP='OPEN'
      IFLAG1=1
      IFLAG2=1
      IFLAG3=1
      IFLAG4=0
      IFLAG5=0
      CALL DPAUFI(IOP,IFLAG1,IFLAG2,IFLAG3,IFLAG4,IFLAG5,
     1            IOUNI1,IOUNI2,IOUNI3,IOUNI4,IOUNI5,
     1            IBUGG3,ISUBRO,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      IROW=0
      DO200I=1,20
        IF(ICMPER.EQ.'CONF')THEN
          READ(IOUNI2,'(3E15.7,15X,A30)',END=209,ERR=205)
     1        XMID(I),DXLOW(I),DXHIGH(I),ILAB(I)
        ELSE
          READ(IOUNI3,'(3E15.7,15X,A30)',END=209,ERR=205)
     1         XMID(I),AJUNK2
          IF(ICMPER.EQ.'1SE')THEN
            DXLOW(I)=XMID(I) - AJUNK2
            DXHIGH(I)=XMID(I) + AJUNK2
          ELSEIF(ICMPER.EQ.'2SE')THEN
            DXLOW(I) =XMID(I) - 2.0*AJUNK2
            DXHIGH(I)=XMID(I) + 2.0*AJUNK2
          ENDIF
        ENDIF
        IROW=IROW+1
  200 CONTINUE
      GOTO209
C
  205 CONTINUE
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,31)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,206)
  206 FORMAT('      UNABLE TO READ VALUES FROM DPST2F.DAT FILE.')
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
C
  209 CONTINUE
      NMETH=IROW
C
C     IF SORT OPTION REQUESTED, SORT BY WIDTH OF INTERVAL
C
C     AFTER SORTC, Y3 WILL CONTAIN THE INDEX
C
      IF(ICMPSO.EQ.'ON')THEN
        DO220I=1,NMETH
          Y1(I)=DXHIGH(I) - DXLOW(I)
          Y2(I)=REAL(I)
  220   CONTINUE
        CALL SORTC(Y1,Y2,NMETH,Y1,Y3)
      ENDIF
C
      IROW=0
      DO250I=1,1000
        READ(IOUNI1,'(F6.0,F8.0,2X,3E15.7)',END=259,ERR=255)
     1      PLABID(I),AMEANF(I),AMEAN(I),AJUNK,ASD(I)
        IROW=IROW+1
  250 CONTINUE
      GOTO259
C
  255 CONTINUE
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,31)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,256)
  256 FORMAT('      UNABLE TO READ VALUES FROM DPST1F.DAT FILE.')
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
C
  259 CONTINUE
      NLABID=IROW
C
      IOP='CLOS'
      CALL DPAUFI(IOP,IFLAG1,IFLAG2,IFLAG3,IFLAG4,IFLAG5,
     1            IOUNI1,IOUNI2,IOUNI3,IOUNI4,IOUNI5,
     1            IBUGG3,ISUBRO,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      IOP='OPEN'
      IFLAG1=0
      IFLAG2=0
      IFLAG3=1
      CALL DPAUFI(IOP,IFLAG1,IFLAG2,IFLAG3,IFLAG4,IFLAG5,
     1            IOUNI1,IOUNI2,IOUNI3,IOUNI4,IOUNI5,
     1            IBUGG3,ISUBRO,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C               ****************************************
C               ****************************************
C               **  STEP 3--                          **
C               **  CREATE THE X, Y, D ARRAYS FOR     **
C               **  PLOTTING                          **
C               ****************************************
C
CCCCC IBOB=1
CCCCC IF(IROW.LT.8)IBOB=0
C
      N2=0
      DO300I=1,NMETH
        IINDX=I
        IF(ICMPSO.EQ.'ON')IINDX=INT(Y3(I)+0.5)
        N2=N2+1
        X(N2)=REAL(I)
        Y(N2)=XMID(IINDX)
        D(N2)=1.0
  300 CONTINUE
C
      IF(ICMPDA.EQ.'ON')THEN
        DO305IINDX=1,NLABID
          N2=N2+1
          ICNT3=NMETH+INT(PLABID(IINDX)+0.5)
          X(N2)=REAL(ICNT3)
          Y(N2)=AMEAN(IINDX)
          D(N2)=1.0
  305   CONTINUE
      ENDIF
C
      ICNT2=1
      DO310I=1,NMETH
        IINDX=I
        IF(ICMPSO.EQ.'ON')IINDX=INT(Y3(I)+0.5)
        N2=N2+1
        ICNT2=ICNT2+1
        X(N2)=REAL(I)
        Y(N2)=DXLOW(IINDX)
        D(N2)=REAL(ICNT2)
C
        N2=N2+1
        X(N2)=REAL(I)
        Y(N2)=DXHIGH(IINDX)
        D(N2)=REAL(ICNT2)
  310 CONTINUE
C
      IF(ICMPDA.EQ.'ON')THEN
        DO315IINDX=1,NLABID
          ICNT2=ICNT2+1
          ICNT3=NMETH+INT(PLABID(IINDX)+0.5)
C
          N2=N2+1
          X(N2)=REAL(ICNT3)
          ALOWT=AMEAN(IINDX) - 2.0*ASD(IINDX)/SQRT(AMEANF(IINDX))
          Y(N2)=ALOWT
          D(N2)=REAL(ICNT2)
C
          N2=N2+1
          AHIGT=AMEAN(IINDX) + 2.0*ASD(IINDX)/SQRT(AMEANF(IINDX))
          X(N2)=REAL(ICNT3)
          Y(N2)=AHIGT
          D(N2)=REAL(ICNT2)
  315   CONTINUE
      ENDIF
C
 8000 CONTINUE
      NPLOTV=3
      DO8010I=1,NMETH
        IINDX=I
        IF(ICMPSO.EQ.'ON')IINDX=INT(Y3(I)+0.5)
        WRITE(ICOUT,8011)I,ILAB(IINDX)
 8011   FORMAT(I2,'. ',A30)
        CALL DPWRST('XXX','BUG ')
        WRITE(IOUNI3,'(I5)')IINDX
 8010 CONTINUE
C
      IF(IFEEDB.EQ.'ON')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,8001)
 8001   FORMAT('The accompying plot has the consensus value and ',
     1         'confidence limits.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,8003)
 8003   FORMAT('The ordering of methods on the accompaning consensus ',
     1         'mean plot is:')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
C
      IOP='CLOS'
      CALL DPAUFI(IOP,IFLAG1,IFLAG2,IFLAG3,IFLAG4,IFLAG5,
     1            IOUNI1,IOUNI2,IOUNI3,IOUNI4,IOUNI5,
     1            IBUGG3,ISUBRO,IERROR)
C
      IF(IBUGG3.EQ.'ON'.OR.ISUBRO.EQ.'CMP2')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPCMP2--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)ICASPL,NZ,N2,NPLOTV,IERROR
 9012   FORMAT('ICASPL,NZ,N2,NPLOTV,IERROR = ',A4,3I8,2X,A4)
        CALL DPWRST('XXX','BUG ')
        DO9035I=1,N2
          WRITE(ICOUT,9036)I,Y(I),X(I),D(I)
 9036     FORMAT('I,Y(I),X(I),D(I) = ',I8,2E15.7,F9.2)
          CALL DPWRST('XXX','BUG ')
 9035   CONTINUE
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPCNF2(Y,N,X,N2,XTEMP1,XTEMP2,MAXNXT,
     1                  PID,IVARID,IVARI2,NREPL,
     1                  CUTL90,CUTU90,CUTL95,CUTU95,CUTL99,CUTU99,
     1                  ICAPSW,ICAPTY,IFORSW,ICASAN,ICASAT,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE GENERATES CONFIDENCE LIMITS
C              FOR THE MEAN
C              FOR THE DATA IN THE INPUT VECTOR Y.
C     NOTE--ASSUMPTION--MODEL IS   RESPONSE = CONSTANT + ERROR.
C     INPUT  ARGUMENTS--Y      = THE SINGLE PRECISION VECTOR
C                                OF EQUALLY-SPACED OBSERVATIONS
C                                TO BE SMOOTHED.
C                       N      = THE INTEGER NUMBER OF
C                                OBSERVATIONS IN THE VECTOR Y.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--JULY      1981.
C     UPDATED         --NOVEMBER  1981.
C     UPDATED         --FEBRUARY  1982.
C     UPDATED         --MAY       1982.
C     UPDATED         --FEBRUARY  1994. DPWRST: 'BUG ' => 'WRIT'
C     UPDATED         --FEBRUARY  1994. E FORMAT => G FORMAT
C     UPDATED         --MARCH     1999. DIFFERENCE OF MEANS CASE
C     UPDATED         --FEBRUARY  2003. SUPPORT FOR CUTL..,CUTH..
C     UPDATED         --OCTOBER   2003. SUPPORT FOR HTML, LATEX OUTPUT
C     UPDATED         --AUGUST    2005. FOR DIFF OF MEANS CASE:
C                                       A) HTML PRINTED OUT WRONG
C                                          VALUES FOR SECOND VARIABLE
C                                       B) ADDED AN ELSE STATEMENT TO
C                                          ACTIVATE THE ASCII OUTPUT
C     UPDATED         --OCTOBER   2006. CALL LIST TO TPPF
C     UPDATED         --MARCH     2010. USE DPDTA2 AND DPDTA4 TO
C                                       GENERATE OUTPUT (ADDS RTF
C                                       SUPPORT)
C     UPDATED         --MARCH     2010. SOME MODIFICATIONS TO THE
C                                       OUTPUT (AESTHETIC, NOT
C                                       SUBSTANTIVE)
C     UPDATED         --APRIL     2013. SUPPORT FOR ONE-SIDED INTERVALS
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*4 ICASAN
      CHARACTER*4 ICASAT
      CHARACTER*4 ICASA2
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
C
      CHARACTER*4 IVARID(*)
      CHARACTER*4 IVARI2(*)
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION X(*)
      DIMENSION XTEMP1(*)
      DIMENSION XTEMP2(*)
      DIMENSION PID(*)
C
      PARAMETER (NUMALP=8)
C
      DIMENSION CONF(NUMALP)
      DIMENSION T(NUMALP)
      DIMENSION TSDM(NUMALP)
      DIMENSION ALOWER(NUMALP)
      DIMENSION AUPPER(NUMALP)
C
      PARAMETER(NUMCLI=5)
      PARAMETER(MAXLIN=2)
      PARAMETER (MAXROW=20)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*60 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(NUMCLI)
      CHARACTER*4  VALIGN(NUMCLI)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      INTEGER      IWHTML(NUMCLI)
      INTEGER      IWRTF(NUMCLI)
      LOGICAL IFRST
      LOGICAL ILAST
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPCN'
      ISUBN2='F2  '
C
      IERROR='NO'
      IWRITE='OFF'
      ICASA2='CONF'
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      CONF(1)=50.0
      CONF(2)=75.0
      CONF(3)=90.0
      CONF(4)=95.0
      CONF(5)=99.0
      CONF(6)=99.9
      CONF(7)=99.99
      CONF(8)=99.999
C
      CUTL90=CPUMIN
      CUTU90=CPUMIN
      CUTL95=CPUMIN
      CUTU95=CPUMIN
      CUTL99=CPUMIN
      CUTU99=CPUMIN
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'CNF2')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPCNF2--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)N,IBUGA3
   52   FORMAT('N,IBUGA3 = ',I8,2X,A4)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,N
          WRITE(ICOUT,57)I,Y(I),X(I)
   57     FORMAT('I,Y(I),X(I) = ',I8,3E15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
        WRITE(ICOUT,58)ICASAN
   58   FORMAT('ICASAN   = ',A4)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      IF(ICASAN.EQ.'TWOV')GOTO2000
C
C               ********************************************
C               **  STEP 1--                              **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'CNF2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(N.LE.1)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,101)
  101   FORMAT('***** ERROR IN CONFIDENCE LIMITS FOR THE MEAN--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,103)
  103   FORMAT('      THE NUMBER OF OBSERVATIONS IN THE RESPONSE ',
     1         'VARIABLE IS LESS THAN TWO.')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,105)N
  105   FORMAT('SAMPLE SIZE = ',I8)
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      HOLD=Y(1)
      DO135I=2,N
        IF(Y(I).NE.HOLD)GOTO139
  135 CONTINUE
  130 CONTINUE
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,101)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,131)HOLD
  131 FORMAT('      THE RESPONSE VARIABLE HAS ALL ELEMENTS = ',G15.7)
      CALL DPWRST('XXX','WRIT')
      GOTO9000
      IERROR='YES'
  139 CONTINUE
C
C               ***************************************************
C               **  STEP 3--                                     **
C               **  COMPUTE THE MEAN.                            **
C               **  COMPUTE THE STANDARD DEVIATION.              **
C               **  COMPUTE THE STANDARD DEVIATION OF THE MEAN.  **
C               ***************************************************
C
C
      ISTEPN='3'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CNF2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      CALL MEAN(Y,N,IWRITE,YMEAN,IBUGA3,IERROR)
      CALL SD(Y,N,IWRITE,YSD,IBUGA3,IERROR)
      AN=N
      YSDMEA=YSD/SQRT(AN)
C
C               ***************************************
C               **  STEP 4--                         **
C               **  COMPUTE CONFIDENCE LIMITS        **
C               **  FOR VARIOUS PROBABILITY VALUES.  **
C               ***************************************
C
      ISTEPN='4'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CNF2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      DO1400I=1,8
        PCONF=CONF(I)/100.0
        CDF=PCONF
        IF(ICASAT.EQ.'TWOS')CDF=0.5+PCONF/2.0
        NM1=N-1
        CALL TPPF(CDF,REAL(NM1),T(I))
        TSDM(I)=T(I)*YSDMEA
        IF(ICASAT.EQ.'TWOS')THEN
          ALOWER(I)=YMEAN-TSDM(I)
          AUPPER(I)=YMEAN+TSDM(I)
        ELSEIF(ICASAT.EQ.'LOWE')THEN
          ALOWER(I)=YMEAN-TSDM(I)
          AUPPER(I)=CPUMIN
        ELSEIF(ICASAT.EQ.'UPPE')THEN
          ALOWER(I)=CPUMIN
          AUPPER(I)=YMEAN+TSDM(I)
        ENDIF
 1400 CONTINUE
      CUTL90=ALOWER(3)
      CUTU90=AUPPER(3)
      CUTL95=ALOWER(4)
      CUTU95=AUPPER(4)
      CUTL99=ALOWER(5)
      CUTU99=AUPPER(5)
C
C     ADD A FUDGE FACTOR SO THAT CONFIDENCE LEVEL WILL
C     BE PRINTED CORRECTLY TO 3 DECIMAL PLACES.
C
      CONF(1)=50.0001
      CONF(2)=75.0001
      CONF(3)=90.0001
      CONF(4)=95.0001
      CONF(5)=99.0001
      CONF(6)=99.9001
      CONF(7)=99.9901
      CONF(8)=99.9991
C
C               ****************************
C               **  STEP 5--              **
C               **  WRITE EVERYTHING OUT  **
C               ****************************
C
      ISTEPN='5'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CNF2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IPRINT.EQ.'OFF')GOTO9000
C
      ITITLE='Confidence Limits for the Mean'
      NCTITL=30
      IF(ICASAT.EQ.'TWOS')THEN
        ITITLZ='(Two-Sided)'
        NCTITZ=11
      ELSEIF(ICASAT.EQ.'LOWE')THEN
        ITITLZ='(Lower One-Sided)'
        NCTITZ=17
      ELSEIF(ICASAT.EQ.'UPPE')THEN
        ITITLZ='(Upper One-Sided)'
        NCTITZ=17
      ENDIF
C
      ICNT=1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Response Variable: '
      WRITE(ITEXT(ICNT)(20:23),'(A4)')IVARID(1)(1:4)
      WRITE(ITEXT(ICNT)(24:27),'(A4)')IVARI2(1)(1:4)
      NCTEXT(ICNT)=27
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      IF(NREPL.GT.0)THEN
        NRESP=1
        DO4101I=1,NREPL
          ICNT=ICNT+1
          ITEMP=I+NRESP
          ITEXT(ICNT)='Factor Variable  : '
          WRITE(ITEXT(ICNT)(17:17),'(I1)')I
          WRITE(ITEXT(ICNT)(20:23),'(A4)')IVARID(ITEMP)(1:4)
          WRITE(ITEXT(ICNT)(24:27),'(A4)')IVARI2(ITEMP)(1:4)
          NCTEXT(ICNT)=27
          AVALUE(ICNT)=PID(ITEMP)
          IDIGIT(ICNT)=NUMDIG
 4101   CONTINUE
      ENDIF
C
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=1
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(N)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=YMEAN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=YSD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation of the Mean:'
      NCTEXT(ICNT)=38
      AVALUE(ICNT)=YSDMEA
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=1
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      NUMROW=ICNT
      DO4210I=1,NUMROW
        NTOT(I)=15
 4210 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.TRUE.
C
      ISTEPN='5A'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CNF2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
      ISTEPN='5B'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CNF2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      CALL DPDT11(CONF,T,TSDM,ALOWER,AUPPER,
     1            ICASA2,ICAPSW,ICAPTY,NUMDIG,
     1            ISUBRO,IBUGA3,IERROR)
C
      GOTO9000
C
 2000 CONTINUE
C
C               ********************************************
C               **  STEP 6--                              **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='6'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CNF2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(N.LE.1.OR.N2.LE.1)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2111)
 2111   FORMAT('***** ERROR IN DIIFERENCE OF MEANS CONFIDENCE LIMITS--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2112)
 2112   FORMAT('      BOTH VARIABLES MUST HAVE AT LEAST TWO ',
     1         'OBSERVATIONS.')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2113)IVARID(1),IVARI2(1),N
 2113   FORMAT('      SAMPLE SIZE FOR ',A4,A4,' = ',I8)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2114)IVARID(2),IVARI2(2),N2
 2114   FORMAT('      SAMPLE SIZE FOR ',A4,A4,' = ',I8)
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ENDIF
C
C               ***************************************************
C               **  STEP 7--                                     **
C               **  COMPUTE THE MEAN.                            **
C               **  COMPUTE THE STANDARD DEVIATION.              **
C               **  COMPUTE THE STANDARD DEVIATION OF THE MEAN.  **
C               ***************************************************
C
C
      ISTEPN='7'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CNF2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      CALL MEAN(Y,N,IWRITE,YMEAN1,IBUGA3,IERROR)
      CALL SD(Y,N,IWRITE,YSD1,IBUGA3,IERROR)
      AN1=N
      YTEMP1=YSD1**2/AN1
C
      CALL MEAN(X,N2,IWRITE,YMEAN2,IBUGA3,IERROR)
      CALL SD(X,N2,IWRITE,YSD2,IBUGA3,IERROR)
      AN2=N2
      YTEMP2=YSD2**2/AN2
C
      YDIFF=YMEAN1-YMEAN2
      YSTERR=SQRT(YTEMP1 + YTEMP2)
      TERM1=(YTEMP1 + YTEMP2)**2
      TERM2=YTEMP1*YTEMP1/(AN1-1.0) + YTEMP2*YTEMP2/(AN2-1.0)
      V=TERM1/TERM2
      IV=INT(V+0.5)
C
C               ***************************************
C               **  STEP 8--                         **
C               **  COMPUTE CONFIDENCE LIMITS        **
C               **  FOR VARIOUS PROBABILITY VALUES.  **
C               ***************************************
C
      ISTEPN='8'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CNF2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      DO2400I=1,8
        PCONF=CONF(I)/100.0
        CDF=PCONF
        IF(ICASAT.EQ.'TWOS')CDF=0.5+PCONF/2.0
        CALL TPPF(CDF,REAL(IV),T(I))
        TSDM(I)=T(I)*YSTERR
        IF(ICASAT.EQ.'TWOS')THEN
          ALOWER(I)=YDIFF-TSDM(I)
          AUPPER(I)=YDIFF+TSDM(I)
        ELSEIF(ICASAT.EQ.'LOWE')THEN
          ALOWER(I)=YDIFF-TSDM(I)
          AUPPER(I)=CPUMIN
        ELSEIF(ICASAT.EQ.'UPPE')THEN
          ALOWER(I)=CPUMIN
          AUPPER(I)=YDIFF+TSDM(I)
        ENDIF
 2400 CONTINUE
      CUTL90=ALOWER(3)
      CUTU90=AUPPER(3)
      CUTL95=ALOWER(4)
      CUTU95=AUPPER(4)
      CUTL99=ALOWER(5)
      CUTU99=AUPPER(5)
C
C               ****************************
C               **  STEP 9--              **
C               **  WRITE EVERYTHING OUT  **
C               ****************************
C
      ISTEPN='9'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CNF2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IPRINT.EQ.'OFF')GOTO9000
C
      ITITLE='Confidence Limits for the Difference Between Means'
      NCTITL=50
      IF(ICASAT.EQ.'TWOS')THEN
        ITITLZ='(Two-Sided)'
        NCTITZ=11
      ELSEIF(ICASAT.EQ.'LOWE')THEN
        ITITLZ='(Lower One-Sided)'
        NCTITZ=17
      ELSEIF(ICASAT.EQ.'UPPE')THEN
        ITITLZ='(Upper One-Sided)'
        NCTITZ=17
      ENDIF
C
      ICNT=1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Response Variable 1: '
      WRITE(ITEXT(ICNT)(22:25),'(A4)')IVARID(1)(1:4)
      WRITE(ITEXT(ICNT)(26:29),'(A4)')IVARI2(1)(1:4)
      NCTEXT(ICNT)=29
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Response Variable 2: '
      WRITE(ITEXT(ICNT)(22:25),'(A4)')IVARID(2)(1:4)
      WRITE(ITEXT(ICNT)(26:29),'(A4)')IVARI2(2)(1:4)
      NCTEXT(ICNT)=29
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      IF(NREPL.GT.0)THEN
        NRESP=2
        DO5101I=1,NREPL
          ICNT=ICNT+1
          ITEMP=I+NRESP
          ITEXT(ICNT)='Factor Variable  : '
          WRITE(ITEXT(ICNT)(17:17),'(I1)')I
          WRITE(ITEXT(ICNT)(20:23),'(A4)')IVARID(ITEMP)(1:4)
          WRITE(ITEXT(ICNT)(24:27),'(A4)')IVARI2(ITEMP)(1:4)
          NCTEXT(ICNT)=27
          AVALUE(ICNT)=PID(ITEMP)
          IDIGIT(ICNT)=NUMDIG
 5101   CONTINUE
      ENDIF
C
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=1
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=1
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Summary Statistics for Variable 1:'
      NCTEXT(ICNT)=34
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(N)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=YMEAN1
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=YSD1
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=1
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Summary Statistics for Variable 2:'
      NCTEXT(ICNT)=34
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(N2)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=YMEAN2
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=YSD2
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=1
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Difference Between Sample Means:'
      NCTEXT(ICNT)=32
      AVALUE(ICNT)=YDIFF
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Standard Error:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=YSTERR
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=1
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      NUMROW=ICNT
      DO5210I=1,NUMROW
        NTOT(I)=15
 5210 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.TRUE.
C
      ISTEPN='9A'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CNF2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
      ISTEPN='9B'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CNF2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      ICASA2='CON2'
      CALL DPDT11(CONF,T,TSDM,ALOWER,AUPPER,
     1            ICASA2,ICAPSW,ICAPTY,NUMDIG,
     1            ISUBRO,IBUGA3,IERROR)
C
      GOTO9000
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'CNF2')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPCNF2--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)N,N2,IBUGA3,IERROR
 9012   FORMAT('N,N2,IBUGA3,IERROR = ',2I8,2X,A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        DO9016I=1,N
          WRITE(ICOUT,9017)I,Y(I)
 9017     FORMAT('I,Y(I) = ',I8,G15.7)
          CALL DPWRST('XXX','WRIT')
 9016   CONTINUE
        IF(ICASAN.EQ.'TWOV')THEN
          DO9026I=1,N2
            WRITE(ICOUT,9027)I,X(I)
 9027       FORMAT('I,Y2(I) = ',I8,G15.7)
            CALL DPWRST('XXX','WRIT')
 9026     CONTINUE
        ENDIF
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPCNF3(CUTL90,CUTU90,CUTL95,CUTU95,CUTL99,CUTU99,
     1                  IFLAGU,IFRST,ILAST,ICASPL,
     1                  IBUGA2,IBUGA3,ISUBRO,IERROR)
C
C     PURPOSE--UTILITY ROUTINE USED BY DPCONF.  THIS ROUTINE
C              UPDATES THE PARAMETERS "CUTLOW90", CUTUPP90",
C              "CUTLOW95", CUTUPP95", "CUTLOW99", AND "CUTUPP99"
C              AFTER COMPUTING THE CONFIDENCE LIMITS FOR THE MEAN
C              (OR FOR THE DIFFERENCE OF THE MEANS).
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORAOTRY
C                 NATIONAL INSTITUTE OF STANDARDS OF TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS OF TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2010/03
C     ORIGINAL VERSION--MARCH     2010.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IFLAGU
      CHARACTER*4 ICASPL
      CHARACTER*4 IBUGA2
      CHARACTER*4 IBUGA3
      CHARACTER*4 ISUBRO
      CHARACTER*4 IERROR
C
      LOGICAL IFRST
      LOGICAL ILAST
C
      CHARACTER*4 IH
      CHARACTER*4 IH2
      CHARACTER*4 ISUBN0
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCOHK.INC'
      INCLUDE 'DPCOHO.INC'
      INCLUDE 'DPCOF2.INC'
C
      CHARACTER*80 IFILE1
      CHARACTER*12 ISTAT1
      CHARACTER*12 IFORM1
      CHARACTER*12 IACCE1
      CHARACTER*12 IPROT1
      CHARACTER*12 ICURS1
      CHARACTER*4 IERRF1
      CHARACTER*4 IENDF1
      CHARACTER*4 IREWI1
C
C-----COMMON----------------------------------------------------------
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IF(IBUGA2.EQ.'ON' .OR. ISUBRO.EQ.'CNF3')THEN
        ISTEPN='1'
        CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPCNF3--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,54)CUTL90,CUTL95,CUTL99
   54   FORMAT('CUTL90,CUTL95,CUTL99 = ',3G15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,56)CUTU90,CUTU95,CUTU99
   56   FORMAT('CUTU90,CUTU95,CUTU99 = ',3G15.7)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      IF(IFLAGU.EQ.'FILE')THEN
        IOUNI1=IST1NU
        IFILE1=IST1NA
        ISTAT1=IST1ST
        IFORM1=IST1FO
        IACCE1=IST1AC
        IPROT1=IST1PR
        ICURS1=IST1CS
        ISUBN0='CNF3'
        IERRF1='NO'
        IREWI1='ON'
C
        IF(IFRST)THEN
          CALL DPOPFI(IOUNI1,IFILE1,ISTAT1,IFORM1,IACCE1,IPROT1,ICURS1,
     1                IREWI1,ISUBN0,IERRF1,IBUGA3,ISUBRO,IERRF1)
          IST1CS=ICURS1
C
          IF(IBUGA2.EQ.'ON' .OR. ISUBRO.EQ.'CNF3')THEN
            ISTEPN='2A'
            CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,201)
  201       FORMAT('AFTER CALL DPOPFI, IERRF1 = ',A4)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,203)IOUNI1,IFILE1
  203       FORMAT('IOUNI1,IFILE1 = ',I5,A80)
            CALL DPWRST('XXX','BUG ')
          ENDIF
C
          IF(IERRF1.EQ.'YES')GOTO9000
          WRITE(IOUNI1,295)
  295     FORMAT(7X,'CUTLOW90',7X,'CUTUPP90',7X,'CUTLOW95',
     1           7X,'CUTUPP95',7X,'CUTLOW99',7X,'CUTUPP99')
        ENDIF
        WRITE(IOUNI1,299)CUTL90,CUTU90,CUTL95,CUTU95,CUTL99,CUTU99
  299   FORMAT(7E15.7)
      ELSEIF(IFLAGU.EQ.'ON')THEN
C
        IF(CUTL90.NE.CPUMIN)THEN
          IH='CUTL'
          IH2='OW90'
          VALUE0=CUTL90
          CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1                IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1                IANS,IWIDTH,IBUGA3,IERROR)
        ENDIF
C
        IF(CUTU90.NE.CPUMIN)THEN
          IH='CUTU'
          IH2='PP90'
          VALUE0=CUTU90
          CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1                IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1                IANS,IWIDTH,IBUGA3,IERROR)
        ENDIF
C
        IF(CUTL95.NE.CPUMIN)THEN
          IH='CUTL'
          IH2='OW95'
          VALUE0=CUTL95
          CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1                IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1                IANS,IWIDTH,IBUGA3,IERROR)
        ENDIF
C
        IF(CUTU95.NE.CPUMIN)THEN
          IH='CUTU'
          IH2='PP95'
          VALUE0=CUTU95
          CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1                IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1                IANS,IWIDTH,IBUGA3,IERROR)
        ENDIF
C
        IF(CUTL99.NE.CPUMIN)THEN
          IH='CUTL'
          IH2='OW99'
          VALUE0=CUTL99
          CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1                IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1                IANS,IWIDTH,IBUGA3,IERROR)
        ENDIF
C
        IF(CUTU99.NE.CPUMIN)THEN
          IH='CUTU'
          IH2='PP99'
          VALUE0=CUTU99
          CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1                IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1                IANS,IWIDTH,IBUGA3,IERROR)
        ENDIF
C
      ENDIF
C
      IF(IFLAGU.EQ.'FILE')THEN
        IF(ILAST)THEN
          IERRF1='NO'
          IENDF1='OFF'
          IREWI1='ON'
          CALL DPCLFI(IOUNI1,IFILE1,ISTAT1,IFORM1,IACCE1,IPROT1,ICURS1,
     1                IENDF1,IREWI1,ISUBN0,IERRF1,IBUGA3,ISUBRO,IERRF1)
C
          IF(IBUGA2.EQ.'ON' .OR. ISUBRO.EQ.'CNF3')THEN
            ISTEPN='3A'
            CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,301)
  301       FORMAT('AFTER CALL DPCLFI, IERRF1 = ',A4)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,303)IOUNI1,IFILE1
  303       FORMAT('IOUNI1,IFILE1 = ',I5,A80)
            CALL DPWRST('XXX','BUG ')
          ENDIF
C
          IF(IERRF1.EQ.'YES')GOTO9000
        ENDIF
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
C
      IF(IBUGA2.EQ.'ON' .OR. ISUBRO.EQ.'CNF3')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END OF DPCNF3--')
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPCOCH(YTEMP,XTEMP,MAXNXT,
     1                  ICAPSW,IFORSW,
     1                  IBUGA2,IBUGA3,IBUGQ,ISUBRO,IFOUND,IERROR)
C
C     PURPOSE--CARRY OUT COCHRAN TEST ANALYSIS OF A RANDOMIZED COMPLETE
C              BLOCK DESIGN WHERE THE OUTCOME CAN BE EITHER "SUCCESS" OR
C              "FAILURE" (OR ANY TWO MUTUALLY EXCLUSIVE OUTCOMES).
C              THESE ARE CODED AS ZERO AND ONE.  IN DATAPLOT, THE COLUMNS
C              REPRESENT TREATMENTS AND THE ROWS REPRESENT SUBJECTS.
C     EXAMPLE--COCHRAN TEST Y X1 X2
C     REFERENCE--W. J. CONOVER, 1999, "PRACTICAL NONPARAMETRIC
C                STATISTICS", THIRD EDITION, WILEY, PP. 251-256.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2004/10
C     ORIGINAL VERSION--OCTOBER   2004.
C     UPDATED         --DECEMBER  2005. RECODE TO USE
C                                         COCHRAN TEST Y X1 X2
C                                       INSTEAD OF
C                                         COCHRAN TEST Y X1 ... XK
C                                       IN ORDER TO BE CONSISTENT
C                                       WITH OTHER DATAPLOT COMMANDS.
C     UPDATED         --APRIL     2011. USE DPPARS AND DPPAR3
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 IFORSW
      CHARACTER*4 IBUGA2
      CHARACTER*4 IBUGA3
      CHARACTER*4 IBUGQ
      CHARACTER*4 ISUBRO
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
      CHARACTER*4 IHWUSE
      CHARACTER*4 MESSAG
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*4 IH
      CHARACTER*4 IH2
      CHARACTER*4 IHOST1
      CHARACTER*4 ISUBN0
C
      LOGICAL IFRST
      LOGICAL ILAST
      CHARACTER*4 IFLAGU
      CHARACTER*4 ICASE
      CHARACTER*40 INAME
      PARAMETER (MAXSPN=30)
      CHARACTER*4 IVARN1(MAXSPN)
      CHARACTER*4 IVARN2(MAXSPN)
      CHARACTER*4 IVARTY(MAXSPN)
      REAL PVAR(MAXSPN)
      REAL PID(MAXSPN)
      INTEGER ILIS(MAXSPN)
      INTEGER NRIGHT(MAXSPN)
      INTEGER ICOLR(MAXSPN)
C
C---------------------------------------------------------------------
C
      DIMENSION YTEMP(*)
      DIMENSION XTEMP(*)
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
C
      PARAMETER(MAXCOC=20)
C
      DIMENSION Z(MAXOBV,MAXCOC)
      INCLUDE 'DPCOZ2.INC'
      EQUIVALENCE (G2RBAG(IGAR11),Z(1,1))
C
      DIMENSION XTEMP1(MAXOBV)
      DIMENSION XTEMP2(MAXOBV)
      DIMENSION XTEMP3(MAXOBV)
      DIMENSION XTEMP4(MAXOBV)
      DIMENSION XTEMP5(MAXOBV)
C
      INCLUDE 'DPCOZZ.INC'
      EQUIVALENCE(GARBAG(IGARB1),XTEMP1(1))
      EQUIVALENCE(GARBAG(IGARB2),XTEMP2(1))
      EQUIVALENCE(GARBAG(IGARB3),XTEMP3(1))
      EQUIVALENCE(GARBAG(IGARB4),XTEMP4(1))
      EQUIVALENCE(GARBAG(IGARB5),XTEMP5(1))
C
      INCLUDE 'DPCOHK.INC'
      INCLUDE 'DPCOSU.INC'
      INCLUDE 'DPCODA.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPCO'
      ISUBN2='CH  '
C
      MAXCP1=MAXCOL+1
      MAXCP2=MAXCOL+2
      MAXCP3=MAXCOL+3
      MAXCP4=MAXCOL+4
      MAXCP5=MAXCOL+5
      MAXCP6=MAXCOL+6
C
      IFOUND='YES'
      IERROR='NO'
C
C               ******************************************
C               **  TREAT THE COCHRAN TEST CASE         **
C               ******************************************
C
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'COCH')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPCOCH--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGA2,IBUGA3,IBUGQ,ISUBRO,MAXNXT
   52   FORMAT('IBUGA2,IBUGA3,IBUBQ,ISUBRO,MAXNXT = ',4(A4,2X),I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,53)ICAPSW,ICAPTY,IFORSW
   53   FORMAT('ICAPSW,ICAPTY,IFORSW = ',2(A4,2X),A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               *********************************
C               **  STEP 1--                   **
C               **  EXTRACT THE VARIABLE LIST  **
C               *********************************
C
      ISTEPN='1'
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'COCH')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      INAME='COCHRAN TEST'
      MINNA=3
      MAXNA=100
      MINNVA=3
      MAXNVA=3
      IFLAGE=1
      IFLAGM=0
      MINN2=2
      IFLAGP=0
      JMIN=1
      JMAX=NUMARG
C
      CALL DPPARS(IHARG,IHARG2,IARGT,ARG,NUMARG,IANS,IWIDTH,
     1            IHNAME,IHNAM2,IUSE,NUMNAM,IN,IVALUE,VALUE,
     1            JMIN,JMAX,
     1            MINN2,MINNA,MAXNA,MAXSPN,IFLAGE,INAME,
     1            IVARN1,IVARN2,IVARTY,PVAR,
     1            ILIS,NRIGHT,ICOLR,ISUB,NQ,ILOCQ,NUMVAR,
     1            MINNVA,MAXNVA,
     1            IFLAGM,IFLAGP,
     1            IBUGA3,IBUGQ,ISUBRO,IFOUND,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'COCH')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,181)
  181   FORMAT('***** AFTER CALL DPPARS--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,182)NQ,NUMVAR,IMULT
  182   FORMAT('NQ,NUMVAR,IMULT = ',2I8,2X,A4)
        CALL DPWRST('XXX','BUG ')
        IF(NUMVAR.GT.0)THEN
          DO185I=1,NUMVAR
            WRITE(ICOUT,187)I,IVARN1(I),IVARN2(I),ILIS(I),NRIGHT(I),
     1                      ICOLR(I)
  187       FORMAT('I,IVARN1(I),IVARN2(I),ILIS(I),NRIGHT(I),',
     1             'ICOLR(I) = ',I8,2X,A4,A4,2X,3I8)
            CALL DPWRST('XXX','BUG ')
  185     CONTINUE
        ENDIF
      ENDIF
C
C               **********************************
C               **  STEP 52--                   **
C               **  CARRY OUT THE DURBIN TEST   **
C               **********************************
C
      ISTEPN='52'
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'DURB')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      ICOL=1
      NUMVA2=3
      CALL DPPAR3(ICOL,IVALUE,IVALU2,IN,MAXN,MAXOBV,
     1            INAME,IVARN1,IVARN2,IVARTY,
     1            ILIS,NRIGHT,ICOLR,ISUB,NQ,NUMVA2,
     1            MAXCOL,MAXCP1,MAXCP2,MAXCP3,
     1            MAXCP4,MAXCP5,MAXCP6,
     1            V,PRED,RES,YPLOT,XPLOT,X2PLOT,TAGPLO,
     1            Y,X,XTEMP2,NS1,NS1,NS1,ICASE,
     1            IBUGA3,ISUBRO,IFOUND,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      IF(IBUGA2.EQ.'ON' .OR. ISUBRO.EQ.'COCH')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,5211)
 5211   FORMAT('***** FROM DPDURB, AS WE ARE ABOUT TO CALL DPCOC2--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,5212)NS1
 5212   FORMAT('NS1 = ',I8)
        CALL DPWRST('XXX','BUG ')
        DO5215I=1,NS1
          WRITE(ICOUT,5216)I,Y(I),X(I),XTEMP2(I)
 5216     FORMAT('I,Y(I),X(I),XTEMP2(I) = ',I8,3G15.7)
          CALL DPWRST('XXX','BUG ')
 5215   CONTINUE
      ENDIF
C
      CALL DPCOC2(Y,X,XTEMP2,NS1,IVARN1,IVARN2,
     1            Z,XTEMP1,XTEMP3,XTEMP4,XTEMP5,
     1            MAXNXT,MAXCOC,
     1            STATVA,STATCD,PVAL,
     1            CUT0,CUT50,CUT75,CUT90,CUT95,CUT975,
     1            CUT99,CUT999,
     1            ICAPSW,ICAPTY,IFORSW,
     1            IBUGA3,ISUBRO,IERROR)
C
      IFLAGU='ON'
      IFRST=.TRUE.
      ILAST=.TRUE.
      CALL DPFRT5(STATVA,STATCD,PVAL,
     1            CUT0,CUT50,CUT75,CUT90,CUT95,
     1            CUT975,CUT99,CUT999,
     1            IFLAGU,IFRST,ILAST,
     1            IBUGA2,IBUGA3,ISUBRO,IERROR)
C
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA2.EQ.'ON' .OR. ISUBRO.EQ.'COCH')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPCOCH--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9016)IFOUND,IERROR
 9016   FORMAT('IFOUND,IERROR = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPCOC2(Y,BLOCK,TREAT,N,IVARID,IVARI2,
     1                  Z,C,R,TEMP1,TEMP2,
     1                  MAXNXT,MAXCOC,
     1                  STATVA,STATCD,PVAL,
     1                  CUT0,CUT50,CUT75,CUT90,CUT95,CUT975,
     1                  CUT99,CUT999,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  IBUGA3,ISUBRO,IERROR)
C
C     PURPOSE--THIS ROUTINE CARRIES OUT COCHRAN'S TEST
C              ANALYSIS OF A RANDOMIZED COMPLETE BLOCK DESIGN
C              WHERE THE OUTCOME CAN BE EITHER "SUCCESS" OR
C              "FAILURE" (OR ANY TWO MUTUALLY EXCLUSIVE OUTCOMES).
C              THESE ARE CODED AS ZERO AND ONE.
C              IN DATAPLOT, THE COLUMNS REPRESENT TREATMENTS AND
C              THE ROWS REPRESENT SUBJECTS.
C
C              THE TEST STATISTIC IS:
C
C                 T = c*(c-1)*SUM[J=1 to c][(C(j) - N/c)**2]/
C                     SUM[i=1 to r][R(i)*(c - R(i))]
C
C              WITH c, r, C(j), R(i) AND N denoting the
C              NUMBER OF COLUMNS, NUMBER OF ROWS, COLUMN TOTALS,
C              ROW TOTALS, AND GRAND TOTAL RESPECTIVELY.
C
C              THE CRITICAL VALUE IS:
C
C                 CHSPPF(c-1,ALPHA)
C
C     EXAMPLE--COCHRAN TEST Y X1 X2
C     REFERENCE--W. J., CONOVER, 1999, "PRACTICAL NON-PARAMETRIC
C                STATSTICS", THIRD EDITION, WILEY, PP. 251-256.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2004/10
C     ORIGINAL VERSION--OCTOBER   2004.
C     UPDATED         --DECEMBER  2005. RECODE TO USE
C                                         COCHRAN TEST Y X1 X2
C                                       INSTEAD OF
C                                         COCHRAN TEST Y X1 ... XK
C                                       IN ORDER TO BE CONSISTENT
C                                       WITH OTHER DATAPLOT COMMANDS.
C     UPDATED         --APRIL     2011. USE DPDTA1 AND DPDTA4 TO PRINT
C                                       TABLES.  THIS ADDS RTF SUPPORT
C                                       AND SPECIFICATION OF THE NUMBER
C                                       OF DIGITS.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*1 IBASLC
      CHARACTER*4 IBUGA3
      CHARACTER*4 ISUBRO
      CHARACTER*4 IERROR
      CHARACTER*4 IVARID(*)
      CHARACTER*4 IVARI2(*)
C
      CHARACTER*4 IWRITE
      CHARACTER*4 ISUBN0
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*4 IOP
C
      CHARACTER*3 IATEMP
C
      DOUBLE PRECISION DSUM1
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION BLOCK(*)
      DIMENSION TREAT(*)
      DIMENSION C(*)
      DIMENSION R(*)
      DIMENSION TEMP1(*)
      DIMENSION TEMP2(*)
      DIMENSION Z(MAXNXT,MAXCOC)
C
      PARAMETER (NUMALP=8)
      REAL ALPHA(NUMALP)
C
      PARAMETER(NUMCLI=6)
      PARAMETER(MAXLIN=2)
      PARAMETER (MAXROW=50)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*60 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(NUMCLI)
      CHARACTER*4  VALIGN(NUMCLI)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      CHARACTER*60 ITITL2(MAXLIN,NUMCLI)
      CHARACTER*15 IVALUE(MAXROW,NUMCLI)
      CHARACTER*4  ITYPCO(NUMCLI)
      INTEGER      NCTIT2(MAXLIN,NUMCLI)
      INTEGER      NCVALU(MAXROW,NUMCLI)
      INTEGER      IWHTML(NUMCLI)
      INTEGER      IWRTF(NUMCLI)
      REAL         AMAT(MAXROW,NUMCLI)
      LOGICAL IFRST
      LOGICAL ILAST
      LOGICAL IFLAG1
      LOGICAL IFLAG2
      LOGICAL IFLAGS
      LOGICAL IFLAGE
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      DATA ALPHA/
     1 0.0, 50.0, 75.0, 90.0, 95.0, 97.5, 99.0, 99.9/
C
      ISUBN1='DPCO'
      ISUBN2='C2  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'COC2')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPCOC2--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N
   52   FORMAT('IBUGA3,ISUBRO,N = ',2(A4,2X),I8)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,N
          WRITE(ICOUT,57)I,Y(I),BLOCK(I),TREAT(I)
   57     FORMAT('I,Y(I),BLOCK(I),TREAT(I) = ',I8,3G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'COC2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      ALOW=Y(1)
      AHIGH=CPUMAX
      IDIST=1
C
      DO110I=1,N
        ATEMP=Y(I)
        IF(IDIST.EQ.1)THEN
          IF(ATEMP.EQ.ALOW)THEN
            GOTO110
          ELSE
            IDIST=IDIST+1
            AHIGH=ATEMP
            GOTO110
          ENDIF
        ELSEIF(IDIST.EQ.2)THEN
          IF(ATEMP.EQ.ALOW .OR. ATEMP.EQ.AHIGH)THEN
            GOTO110
          ELSE
            IDIST=IDIST+1
            GOTO129
          ENDIF
        ELSE
          GOTO129
        ENDIF
  110 CONTINUE
C
  129 CONTINUE
C
      IF(IDIST.GT.2)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,161)
  161   FORMAT('***** ERROR FROM COCHRAN TEST--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,163)
  163   FORMAT('      MORE THAN TWO DISTINCT VALUES DETECTED IN')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,165)
  165   FORMAT('      INPUT DATA.  THE COCHRAN TEST IS FOR')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,167)
  167   FORMAT('      DICHOTOMOUS DATA.  NOTHING DONE.')
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      IF(ALOW.GT.AHIGH)THEN
        ATEMP=ALOW
        ALOW=AHIGH
        AHIGH=ATEMP
      ENDIF
C
      DO220I=1,N
        IF(Y(I).EQ.ALOW)Y(I)=0.0
        IF(Y(I).EQ.AHIGH)Y(I)=1.0
  220 CONTINUE
C
C               ******************************************
C               **  STEP 31--                          **
C               **  COMPUTE DISTINCT ROWS AND COLUMNS. **
C               **  INITIALIZE Z MATRIX TO -99 SO WE   **
C               **  CAN DETECT EMPTY CELLS (COCHRAN    **
C               **  TEST ASSUMES COMPLETE BLOCKS)      **
C               *****************************************
C
      ISTEPN='31'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'COC2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IWRITE='OFF'
      CALL CODE(BLOCK,N,IWRITE,TEMP1,TEMP2,MAXNXT,IBUGA3,IERROR)
      DO301I=1,N
        BLOCK(I)=TEMP1(I)
  301 CONTINUE
      CALL MAXIM(BLOCK,N,IWRITE,XMAX,IBUGA3,IERROR)
      NROW=INT(XMAX+0.5)
C
      CALL CODE(TREAT,N,IWRITE,TEMP1,TEMP2,MAXNXT,IBUGA3,IERROR)
      DO303I=1,N
        TREAT(I)=TEMP1(I)
  303 CONTINUE
      CALL MAXIM(TREAT,N,IWRITE,XMAX,IBUGA3,IERROR)
      NCOL=INT(XMAX+0.5)
C
      DO310J=1,NCOL
        DO320I=1,NROW
          Z(I,J)=-99.0
  320   CONTINUE
  310 CONTINUE
C
      DO330I=1,N
        IROW=INT(BLOCK(I)+0.5)
        ICOL=INT(TREAT(I)+0.5)
        Z(IROW,ICOL)=Y(I)
  330 CONTINUE
C
      DO340J=1,NCOL
        DO350I=1,NROW
          IF(Z(I,J).LT.-0.5)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,161)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,363)
  363       FORMAT('      AN INCOMPLETE BLOCK DESIGN WAS DETECTED.')
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,365)IROW,ICOL
  365       FORMAT('      ROW ',I8,' AND COLUMM ',I8,' WAS EMPTY.')
            CALL DPWRST('XXX','WRIT')
            IERROR='YES'
            GOTO9000
          ENDIF
  350   CONTINUE
  340 CONTINUE
      IF(NROW*NCOL.NE.N)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,161)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,363)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,367)NROW,NCOL
  367   FORMAT('      THE NUMBER OF ROWS (',I8,') TIMES THE ',
     1         'NUMBER OF COLUMMS ( ',I8,')')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,369)N
  369   FORMAT('      DOES NOT EQUAL THE SAMPLE SIZE (',I8,').')
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ENDIF
C
C
C               ******************************
C               **  STEP 41--               **
C               **  CARRY OUT CALCULATIONS  **
C               **  FOR COCHRAN TEST        **
C               ******************************
C
      ISTEPN='41'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'COC2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IWRITE='OFF'
C
C  STEP 1: COMPUTE ROW AND COLUMN TOTALS
C
      AN=0.0
      DO410J=1,NCOL
        SUM1=0.0
        DO420I=1,NROW
          SUM1=SUM1 + Z(I,J)
  420   CONTINUE
        C(J)=SUM1
        AN=AN + SUM1
  410 CONTINUE
C
      DO460I=1,NROW
        SUM1=0.0
        DO470J=1,NCOL
          SUM1=SUM1 + Z(I,J)
  470   CONTINUE
        R(I)=SUM1
  460 CONTINUE
C
C  STEP 2: COMPUTE TEST STATISTIC
C
      ANCOL=REAL(NCOL)
      ANROW=REAL(NROW)
C
      ANUM=0.0
      DO510J=1,NCOL
        ANUM=ANUM + (C(J) - AN/ANCOL)**2
  510 CONTINUE
C
      ADEN=0.0
      DO520I=1,NROW
        ADEN=ADEN + R(I)*(ANCOL - R(I))
  520 CONTINUE
C
      STATVA=ANCOL*(ANCOL-1.0)*ANUM/ADEN
 
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'COC2')THEN
        WRITE(ICOUT,531)ANUM,ADEN,STATVA
  531   FORMAT('ANUM,ADEN,STATVA = ',3G15.7)
        CALL DPWRST('XXX','BUG ')
        DO541J=1,NCOL
          WRITE(ICOUT,543)J,C(J)
  543     FORMAT('J,C(J) = ',I8,G15.7)
          CALL DPWRST('XXX','BUG ')
  541   CONTINUE
        DO551I=1,NROW
          WRITE(ICOUT,553)I,R(I)
  553     FORMAT('I,R(I) = ',I8,G15.7)
          CALL DPWRST('XXX','BUG ')
  551   CONTINUE
      ENDIF
C
      NUMDF1=NCOL-1
      CALL CHSCDF(STATVA,NUMDF1,STATCD)
      PVAL=1.0 - STATCD
C
      CUT0=0.0
      CALL CHSPPF(.50,NUMDF1,CUT50)
      CALL CHSPPF(.75,NUMDF1,CUT75)
      CALL CHSPPF(.90,NUMDF1,CUT90)
      CALL CHSPPF(.95,NUMDF1,CUT95)
      CALL CHSPPF(.975,NUMDF1,CUT975)
      CALL CHSPPF(.99,NUMDF1,CUT99)
      CALL CHSPPF(.999,NUMDF1,CUT999)
C
C               ******************************
C               **   STEP 43--              **
C               **   WRITE OUT EVERYTHING   **
C               **   FOR COCHRAN  TEST      **
C               ******************************
C
      ISTEPN='43'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'COC2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IPRINT.EQ.'OFF')GOTO9000
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE=
     1 'Cochran Test for Two-Way Randomized Complete Block Designs'
      NCTITL=58
      ITITLZ='(Dichotomous Data)'
      NCTITZ=28
C
      ICNT=1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Response Variable: '
      WRITE(ITEXT(ICNT)(20:23),'(A4)')IVARID(1)(1:4)
      WRITE(ITEXT(ICNT)(24:27),'(A4)')IVARI2(1)(1:4)
      NCTEXT(ICNT)=27
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='First Group-ID Variable: '
      WRITE(ITEXT(ICNT)(26:29),'(A4)')IVARID(2)(1:4)
      WRITE(ITEXT(ICNT)(30:33),'(A4)')IVARI2(2)(1:4)
      NCTEXT(ICNT)=33
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Second Group-ID Variable: '
      WRITE(ITEXT(ICNT)(27:30),'(A4)')IVARID(3)(1:4)
      WRITE(ITEXT(ICNT)(31:34),'(A4)')IVARI2(3)(1:4)
      NCTEXT(ICNT)=34
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=1
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='H0: Treatments Have Identical Effects'
      NCTEXT(ICNT)=37
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Ha: Treatments Do Not Have Identical Effects'
      NCTEXT(ICNT)=44
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=1
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Total Number of Observations:'
      NCTEXT(ICNT)=29
      AVALUE(ICNT)=REAL(N)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Blocks:'
      NCTEXT(ICNT)=17
      AVALUE(ICNT)=REAL(NROW)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Treatments:'
      NCTEXT(ICNT)=21
      AVALUE(ICNT)=REAL(NCOL)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=1
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Test:'
      NCTEXT(ICNT)=5
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Cochran Test Statistic:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=STATVA
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='CDF of Test Statistic:'
      NCTEXT(ICNT)=22
      AVALUE(ICNT)=STATCD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='P-Value:'
      NCTEXT(ICNT)=8
      AVALUE(ICNT)=PVAL
      IDIGIT(ICNT)=NUMDIG
C
      NUMROW=ICNT
      DO4210I=1,NUMROW
        NTOT(I)=15
 4210 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.TRUE.
C
      ISTEPN='42A'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DUR2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
      ITITLE=' '
      NCTITL=0
      ITITL9=' '
      NCTIT9=0
      ITITLE='Percent Points of the Chi-Square Reference Distribution'
      NCTITL=55
      NUMLIN=1
      NUMROW=8
      NUMCOL=3
      ITITL2(1,1)='Percent Point'
      ITITL2(1,2)=' '
      ITITL2(1,3)='Value'
      NCTIT2(1,1)=13
      NCTIT2(1,2)=1
      NCTIT2(1,3)=5
C
      NMAX=0
      DO4221I=1,NUMCOL
        VALIGN(I)='b'
        ALIGN(I)='r'
        NTOT(I)=15
        IF(I.EQ.2)NTOT(I)=5
        NMAX=NMAX+NTOT(I)
        IDIGIT(I)=NUMDIG
        ITYPCO(I)='NUME'
 4221 CONTINUE
      ITYPCO(2)='ALPH'
      IDIGIT(1)=1
      IDIGIT(3)=3
      DO4223I=1,NUMROW
        DO4225J=1,NUMCOL
          NCVALU(I,J)=0
          IVALUE(I,J)=' '
          NCVALU(I,J)=0
          AMAT(I,J)=0.0
          IF(J.EQ.1)THEN
            AMAT(I,J)=ALPHA(I)
          ELSEIF(J.EQ.2)THEN
            IVALUE(I,J)='='
            NCVALU(I,J)=1
          ELSEIF(J.EQ.3)THEN
            IF(I.EQ.1)THEN
              AMAT(I,J)=RND(CUT0,IDIGIT(J))
            ELSEIF(I.EQ.2)THEN
              AMAT(I,J)=RND(CUT50,IDIGIT(J))
            ELSEIF(I.EQ.3)THEN
              AMAT(I,J)=RND(CUT75,IDIGIT(J))
            ELSEIF(I.EQ.4)THEN
              AMAT(I,J)=RND(CUT90,IDIGIT(J))
            ELSEIF(I.EQ.5)THEN
              AMAT(I,J)=RND(CUT95,IDIGIT(J))
            ELSEIF(I.EQ.6)THEN
              AMAT(I,J)=RND(CUT975,IDIGIT(J))
            ELSEIF(I.EQ.7)THEN
              AMAT(I,J)=RND(CUT99,IDIGIT(J))
            ELSEIF(I.EQ.8)THEN
              AMAT(I,J)=RND(CUT999,IDIGIT(J))
            ENDIF
          ENDIF
 4225   CONTINUE
 4223 CONTINUE
C
      IWHTML(1)=150
      IWHTML(2)=50
      IWHTML(3)=150
      IWRTF(1)=2000
      IWRTF(2)=IWRTF(1)+500
      IWRTF(3)=IWRTF(2)+2000
      IFRST=.TRUE.
      ILAST=.TRUE.
C
      ISTEPN='42C'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'DUR2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      CALL DPDTA4(ITITL9,NCTIT9,
     1            ITITLE,NCTITL,ITITL2,NCTIT2,
     1            MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1            IVALUE,NCVALU,AMAT,ITYPCO,MAXROW,NUMROW,
     1            IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1            ICAPSW,ICAPTY,IFRST,ILAST,
     1            ISUBRO,IBUGA3,IERROR)
C
      CDF1=CUT90
      CDF2=CUT95
      CDF3=CUT975
      CDF4=CUT99
C
      ITITL9=' '
      NCTIT9=0
      ITITLE='Conclusions (Upper 1-Tailed Test)'
      NCTITL=33
      NUMLIN=1
      NUMROW=4
      NUMCOL=4
      ITITL2(1,1)='Alpha'
      ITITL2(1,2)='CDF'
      ITITL2(1,3)='Critical Value'
      ITITL2(1,4)='Conclusion'
      NCTIT2(1,1)=5
      NCTIT2(1,2)=3
      NCTIT2(1,3)=14
      NCTIT2(1,4)=10
C
      NMAX=0
      DO4321I=1,NUMCOL
        VALIGN(I)='b'
        ALIGN(I)='r'
        NTOT(I)=15
        IF(I.EQ.1 .OR. I.EQ.2)NTOT(I)=7
        IF(I.EQ.3)NTOT(I)=17
        NMAX=NMAX+NTOT(I)
        IDIGIT(I)=3
        ITYPCO(I)='ALPH'
 4321 CONTINUE
      ITYPCO(3)='NUME'
      IDIGIT(1)=0
      IDIGIT(2)=0
      DO4323I=1,NUMROW
        DO4325J=1,NUMCOL
          NCVALU(I,J)=0
          IVALUE(I,J)=' '
          NCVALU(I,J)=0
          AMAT(I,J)=0.0
 4325   CONTINUE
 4323 CONTINUE
      IVALUE(1,1)='10%'
      IVALUE(2,1)='5%'
      IVALUE(3,1)='2.5%'
      IVALUE(4,1)='1%'
      IVALUE(1,2)='90%'
      IVALUE(2,2)='95%'
      IVALUE(3,2)='97.5%'
      IVALUE(4,2)='99%'
      NCVALU(1,1)=3
      NCVALU(2,1)=2
      NCVALU(3,1)=4
      NCVALU(4,1)=2
      NCVALU(1,2)=3
      NCVALU(2,2)=3
      NCVALU(3,2)=5
      NCVALU(4,2)=3
      IVALUE(1,4)='Accept H0'
      IVALUE(2,4)='Accept H0'
      IVALUE(3,4)='Accept H0'
      IVALUE(4,4)='Accept H0'
      NCVALU(1,4)=9
      NCVALU(2,4)=9
      NCVALU(3,4)=9
      NCVALU(4,4)=9
      IF(STATVA.GT.CUT90)IVALUE(1,4)='Reject H0'
      IF(STATVA.GT.CUT95)IVALUE(2,4)='Reject H0'
      IF(STATVA.GT.CUT975)IVALUE(3,4)='Reject H0'
      IF(STATVA.GT.CUT99)IVALUE(4,4)='Reject H0'
      AMAT(1,3)=RND(CUT90,IDIGIT(3))
      AMAT(2,3)=RND(CUT95,IDIGIT(3))
      AMAT(3,3)=RND(CUT975,IDIGIT(3))
      AMAT(4,3)=RND(CUT99,IDIGIT(3))
C
      IWHTML(1)=150
      IWHTML(2)=150
      IWHTML(3)=150
      IWHTML(4)=150
      IWRTF(1)=1500
      IWRTF(2)=IWRTF(1)+1500
      IWRTF(3)=IWRTF(2)+2000
      IWRTF(4)=IWRTF(3)+2000
      IFRST=.FALSE.
      ILAST=.TRUE.
C
      ISTEPN='42E'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'COC2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      CALL DPDTA4(ITITL9,NCTIT9,
     1            ITITLE,NCTITL,ITITL2,NCTIT2,
     1            MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1            IVALUE,NCVALU,AMAT,ITYPCO,MAXROW,NUMROW,
     1            IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1            ICAPSW,ICAPTY,IFRST,ILAST,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'COC2')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPCOC2--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)NROW,NCOL,IBUGA3,IERROR
 9012   FORMAT('NROW,NCOL,IBUGA3,IERROR = ',2I8,2X,A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9014)STATVA,STATCD,PVAL
 9014   FORMAT('STATVA,STATCD,PVAL = ',3G15.7)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPCOD2(IDIG,IHDIG,IBUGD3,IERROR)
C
C     NOTE--THIS SUBROUTINE IS IDENTICAL TO DPCODH.
C           IT HAS BEEN DUPLICATED AND PLACED
C           ON THIS BRANCH OF THE OVERLAY/SEGMENTATION
C           TREE STRUCTURE IN ORDER TO ACHIEVE
C           FASTER EXECUTION TIME.
C
C     PURPOSE--CONVERT NUMERIC DIGIT INTO CORRESPONDING
C              CHARACTER.
C
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--MARCH   1983.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IHDIG
      CHARACTER*4 IBUGD3
      CHARACTER*4 IERROR
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT---------------------------------------------------------
C
      IHDIG='-999'
      IF(IDIG.EQ.1)IHDIG='1'
      IF(IDIG.EQ.2)IHDIG='2'
      IF(IDIG.EQ.3)IHDIG='3'
      IF(IDIG.EQ.4)IHDIG='4'
      IF(IDIG.EQ.5)IHDIG='5'
      IF(IDIG.EQ.6)IHDIG='6'
      IF(IDIG.EQ.7)IHDIG='7'
      IF(IDIG.EQ.8)IHDIG='8'
      IF(IDIG.EQ.9)IHDIG='9'
      IF(IDIG.EQ.0)IHDIG='0'
      GOTO9000
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGD3.EQ.'OFF')GOTO9090
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END OF DPCOD2--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IDIG,IHDIG
 9012 FORMAT('IDIG,IHDIG = ',I8,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)IBUGD3,IERROR
 9013 FORMAT('IBUGD3,IERROR = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPCODH(IDIG,IHDIG,IBUGD3,IERROR)
C
C     PURPOSE--CONVERT NUMERIC DIGIT INTO CORRESPONDING
C              CHARACTER.
C
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--MARCH   1983.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IHDIG
      CHARACTER*4 IBUGD3
      CHARACTER*4 IERROR
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT---------------------------------------------------------
C
      IHDIG='-999'
      IF(IDIG.EQ.1)IHDIG='1'
      IF(IDIG.EQ.2)IHDIG='2'
      IF(IDIG.EQ.3)IHDIG='3'
      IF(IDIG.EQ.4)IHDIG='4'
      IF(IDIG.EQ.5)IHDIG='5'
      IF(IDIG.EQ.6)IHDIG='6'
      IF(IDIG.EQ.7)IHDIG='7'
      IF(IDIG.EQ.8)IHDIG='8'
      IF(IDIG.EQ.9)IHDIG='9'
      IF(IDIG.EQ.0)IHDIG='0'
      GOTO9000
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGD3.EQ.'OFF')GOTO9090
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END OF DPCODH--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IDIG,IHDIG
 9012 FORMAT('IDIG,IHDIG = ',I8,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)IBUGD3,IERROR
 9013 FORMAT('IBUGD3,IERROR = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPCODS(ICASE,D,P,IBUGD2,ISUBRO,IERROR)
C
C     PURPOSE--CONVERT AN INPUT X OR Y VALUE (IN DATA UNITS)
C              (RELATIVE TO THE LAST PLOT THAT APPEARED)
C              INTO ABSOLUTE (0. TO 100.) X OR Y SCREEN UNITS.
C     NOTE--CHARACTER*1 ICASE WILL BE EITHER 'X' OR 'Y'
C     ORIGINAL VERSION--NOVEMBER 1992
C     UPDATED         --MARCH    2001 SUPPORT FOR LOG SCALES (BUT NOT
C                                     WEIBULL AND NORMAL)
C     UPDATED         --APRIL    2010 USE "FX1MAX" AND "FY1MAX" INSTEAD
C                                     OF "FX2MAX" AND "FY2MAX".  BUG
C                                     IF "X1TIC MARK OFFSET" USED
C                                     INSTEAD OF "XTIC MARK OFFSET
C                                     (UPPER LIMIT WILL NOT INCORPORATE
C                                     THE OFFSET).
C
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*1 ICASE
      CHARACTER*4 IBUGD2
      CHARACTER*4 ISUBRO
      CHARACTER*4 IERROR
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCOPC.INC'
C
C-----COMMON VARIABLES (GENERAL)-----------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IERROR='NO'
C
      IF(IBUGD2.NE.'ON'.AND.ISUBRO.NE.'CODS')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF DPCODS--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)IBUGD2,ISUBRO,IERROR
   53 FORMAT('IBUGD2,ISUBRO,IERROR = ',2(A4,2X),A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)ICASE,D,P
   54 FORMAT('ICASE,D,P = ',A1,2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,61)PXMIN,PXMAX,PYMIN,PYMAX
   61 FORMAT('PXMIN,PXMAX,PYMIN,PYMAX = ',4G15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,62)FX1MIN,FX1MAX,FY1MIN,FY2MAX
   62 FORMAT('FX1MIN,FX2MAX,FY1MIN,FY2MAX = ',4G15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,63)GX1MIN,GX2MAX,GY1MIN,GY2MAX
   63 FORMAT('GX1MIN,GX2MAX,GY1MIN,GY2MAX = ',4G15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,64)IX1TSC,IY1TSC
   64 FORMAT('IX1TSC,IY1TSC = ',2(A4,2X))
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
      IF(ICASE.EQ.'X')THEN
        IF(IX1TSC.EQ.'LOG')THEN
          IF(FX1MIN.LE.0.0 .OR. D.LE.0.0)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,121)
  121 FORMAT('***** FROM DPCODS: NEGATIVE NUMBER ENCOUNTERED FOR')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,123)
  123 FORMAT('      EITHER THE AXIS MINIMUM OR THE X COORDINATE')
            CALL DPWRST('XXX','BUG ')
            XFRACT=(D-FX1MIN)/(FX1MAX-FX1MIN)
            P=PXMIN+XFRACT*(PXMAX-PXMIN)
            GOTO299
          ENDIF
          ARG1=LOG10(FX1MIN)
          ARG2=LOG10(FX1MAX)
          ARG3=LOG10(D)
          XFRACT=(ARG3-ARG1)/(ARG2-ARG1)
          P=PXMIN+XFRACT*(PXMAX-PXMIN)
        ELSEIF(IX1TSC.EQ.'WEIB')THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,111)
  111 FORMAT('***** FROM DPCODS: WEIBULL SCALE NOT SUPPORTED FOR ',
     1       'X AXIS')
          XFRACT=(D-FX1MIN)/(FX1MAX-FX1MIN)
          P=PXMIN+XFRACT*(PXMAX-PXMIN)
        ELSEIF(IX1TSC.EQ.'NORM')THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,101)
  101 FORMAT('***** FROM DPCODS: NORMAL SCALE NOT SUPPORTED FOR ',
     1       'X AXIS')
          CALL DPWRST('XXX','BUG ')
          XFRACT=(D-FX1MIN)/(FX1MAX-FX1MIN)
          P=PXMIN+XFRACT*(PXMAX-PXMIN)
        ELSE
          XFRACT=(D-FX1MIN)/(FX1MAX-FX1MIN)
          P=PXMIN+XFRACT*(PXMAX-PXMIN)
        ENDIF
      ELSE
        IF(IY1TSC.EQ.'LOG')THEN
          IF(FY1MIN.LE.0.0 .OR. D.LE.0.0)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,221)
  221 FORMAT('***** FROM DPCODS: NEGATIVE NUMBER ENCOUNTERED FOR')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,223)
  223 FORMAT('      EITHER THE AXIS MINIMUM OR THE Y COORDINATE')
            CALL DPWRST('XXX','BUG ')
            YFRACT=(D-FY1MIN)/(FY1MAX-FY1MIN)
            P=PYMIN+YFRACT*(PYMAX-PYMIN)
            GOTO299
          ENDIF
          ARG1=LOG10(FY1MIN)
          ARG2=LOG10(FY1MAX)
          ARG3=LOG10(D)
          YFRACT=(ARG3-ARG1)/(ARG2-ARG1)
          P=PYMIN+YFRACT*(PYMAX-PYMIN)
        ELSEIF(IY1TSC.EQ.'WEIB')THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,211)
  211 FORMAT('***** FROM DPCODS: WEIBULL SCALE NOT SUPPORTED FOR ',
     1       'Y AXIS')
          YFRACT=(D-FY1MIN)/(FY1MAX-FY1MIN)
          P=PYMIN+YFRACT*(PYMAX-PYMIN)
        ELSEIF(IY1TSC.EQ.'NORM')THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,201)
  201 FORMAT('***** FROM DPCODS: NORMAL SCALE NOT SUPPORTED FOR ',
     1       'Y AXIS')
          YFRACT=(D-FY1MIN)/(FY1MAX-FY1MIN)
          P=PYMIN+YFRACT*(PYMAX-PYMIN)
        ELSE
          YFRACT=(D-FY1MIN)/(FY1MAX-FY1MIN)
          P=PYMIN+YFRACT*(PYMAX-PYMIN)
        ENDIF
      ENDIF
  299 CONTINUE
C
C               ****************
C               **  STEP 90-- **
C               **  EXIT.     **
C               ****************
C
 9000 CONTINUE
      IF(IBUGD2.NE.'ON'.AND.ISUBRO.NE.'CODS')GOTO9090
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE BEGINNING OF DPCODS--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)IBUGD2,ISUBRO,IERROR
 9013 FORMAT('IBUGD2,ISUBRO,IERROR = ',2(A4,2X),A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)ICASE,D,P
 9014 FORMAT('ICASE,D,P = ',A1,2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9021)PXMIN,PXMAX,PYMIN,PYMAX
 9021 FORMAT('PXMIN,PXMAX,PYMIN,PYMAX = ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9022)FX1MIN,FX2MAX,FY1MIN,FY2MAX
 9022 FORMAT('FX1MIN,FX2MAX,FY1MIN,FY2MAX = ',4E15.7)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPCOFH(IL1,IL2,IFUNC,NUMCHF,IH,NH,IBUGD2,IERROR)
C
C     PURPOSE--COPY OVER THE FUNCTION STRING IN LOCATIONS
C              IL1 TO IL2 OF IFUNC(.) AND PLACE IT IN
C              LOCATIONS 1 TO NH (= ILOC2-ILOC1+1)
C              OF THE ARRAY IH(.)
C
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--86/7
C     ORIGINAL VERSION--JUNE  1986.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IFUNC
      CHARACTER*4 IH
      CHARACTER*4 IBUGD2
      CHARACTER*4 IERROR
C
      DIMENSION IFUNC(*)
      DIMENSION IH(*)
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
CCCCC CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPCO'
      ISUBN2='FH  '
C
      IF(IBUGD2.EQ.'OFF')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF DPCOFH--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IL1,IL2
   52 FORMAT('IL1,IL2 = ',2I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)NUMCHF
   54 FORMAT('NUMCHF = ',I8)
      CALL DPWRST('XXX','BUG ')
      IMAX=NUMCHF
      IF(IMAX.GT.100)IMAX=100
      WRITE(ICOUT,55)(IFUNC(I),I=1,IMAX)
   55 FORMAT('IFUNC(.) = ',100A1)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
C               *********************************
C               **  STEP 11--                  **
C               **  COPY OVER THE STRING       **
C               *********************************
      J=0
      IF(IL1.GT.IL2)GOTO1150
      DO1100I=IL1,IL2
      J=J+1
      IH(J)=IFUNC(I)
 1100 CONTINUE
 1150 CONTINUE
      NH=J
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGD2.EQ.'OFF')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF DPCOFH--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IL1,IL2
 9012 FORMAT('IL1,IL2 = ',2I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)NUMCHF
 9014 FORMAT('NUMCHF = ',I8)
      CALL DPWRST('XXX','BUG ')
      IMAX=NUMCHF
      IF(IMAX.GT.100)IMAX=100
      WRITE(ICOUT,9015)(IFUNC(I),I=1,IMAX)
 9015 FORMAT('IFUNC(.) = ',100A1)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9024)NH
 9024 FORMAT('NH = ',I8)
      CALL DPWRST('XXX','BUG ')
      IMAX=NH
      IF(IMAX.GT.100)IMAX=100
      WRITE(ICOUT,9025)(IH(I),I=1,IMAX)
 9025 FORMAT('IH(.) = ',100A1)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPCOFI(ICOM,IANSLC,IWIDTH,IHARG,IHARG2,NUMARG,
     1IBUGS2,IBUGQ,ISUBRO,IFOUND,IERROR)
C
C     PURPOSE--COPY AN INPUT FILE TO AN OUTPUT FILE.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--94/1
C     ORIGINAL VERSION--MAY       1994.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICOM
      CHARACTER*4 IANSLC
      CHARACTER*4 IHARG
      CHARACTER*4 IHARG2
      CHARACTER*4 IBUGS2
      CHARACTER*4 IBUGQ
      CHARACTER*4 ISUBRO
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
      CHARACTER*80 IFILE1
      CHARACTER*12 ISTAT1
      CHARACTER*12 IFORM1
      CHARACTER*12 IACCE1
      CHARACTER*12 IPROT1
      CHARACTER*12 ICURS1
C
      CHARACTER*80 IFILE2
      CHARACTER*12 ISTAT2
      CHARACTER*12 IFORM2
      CHARACTER*12 IACCE2
      CHARACTER*12 IPROT2
      CHARACTER*12 ICURS2
C
      CHARACTER*4 IENDFI
      CHARACTER*4 IREWIN
      CHARACTER*4 ISUBN0
      CHARACTER*4 IERRFI
C
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      CHARACTER*4 ICASEQ
C
      CHARACTER*4 IANSI
      CHARACTER*80 ICANS
      CHARACTER*80 ISTRIN
CCCCC CHARACTER*40 ICJUNK
C
      DIMENSION IANSLC(*)
C
      DIMENSION IHARG(*)
      DIMENSION IHARG2(*)
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCODA.INC'
      INCLUDE 'DPCOF2.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPCO'
      ISUBN2='FI  '
C
      IFOUND='YES'
      IERROR='NO'
C
      MINN2=1
      NCSTRI=(-999)
C
      IF(IBUGS2.EQ.'OFF'.AND.ISUBRO.NE.'COFI')GOTO100
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF DPCOFI--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)ICOM
   52 FORMAT('ICOM = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)IBUGS2,ISUBRO,IERROR
   53 FORMAT('IBUGS2,ISUBRO,IERROR = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)IWIDTH
   54 FORMAT('IWIDTH = ',I8)
      CALL DPWRST('XXX','BUG ')
      IF(IWIDTH.GE.1)WRITE(ICOUT,55)(IANSLC(I),I=1,IWIDTH)
   55 FORMAT('(IANSLC(I),I=1,IWIDTH) = ',80A1)
      IF(IWIDTH.GE.1)CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,61)ILISNU
   61 FORMAT('ILISNU = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,62)ILISNA
   62 FORMAT('ILISNA = ',A80)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,63)ILISST
   63 FORMAT('ILISST = ',A12)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,64)ILISFO
   64 FORMAT('ILISFO = ',A12)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,65)ILISAC
   65 FORMAT('ILISAC = ',A12)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,66)ILISFO
   66 FORMAT('ILISFO = ',A12)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,67)ILISCS
   67 FORMAT('ILISCS = ',A12)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,71)ICONNU
   71 FORMAT('ICONNU = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,72)ICONNA
   72 FORMAT('ICONNA = ',A80)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,73)ICONST
   73 FORMAT('ICONST = ',A12)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,74)ICONFO
   74 FORMAT('ICONFO = ',A12)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,75)ICONAC
   75 FORMAT('ICONAC = ',A12)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,76)ICONFO
   76 FORMAT('ICONFO = ',A12)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,77)ICONCS
   77 FORMAT('ICONCS = ',A12)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,81)IDIRNU
   81 FORMAT('IDIRNU = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,82)IDIRNA
   82 FORMAT('IDIRNA = ',A80)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,83)IDIRST
   83 FORMAT('IDIRST = ',A12)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,84)IDIRFO
   84 FORMAT('IDIRFO = ',A12)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,85)IDIRAC
   85 FORMAT('IDIRAC = ',A12)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,86)IDIRFO
   86 FORMAT('IDIRFO = ',A12)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,87)IDIRCS
   87 FORMAT('IDIRCS = ',A12)
      CALL DPWRST('XXX','BUG ')
  100 CONTINUE
C
C               **************************
C               **  STEP 11--           **
C               **  COPY OVER VARIABLES **
C               **************************
C
      ISTEPN='11'
      IF(IBUGS2.EQ.'ON'.OR.ISUBRO.EQ.'COFI')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IOUNI1=ILISNU
      IFILE1=ILISNA
      ISTAT1=ILISST
      IFORM1=ILISFO
      IACCE1=ILISAC
      IPROT1=ILISPR
      ICURS1=ILISCS
C
      IOUNI2=IWRINU
      IFILE2=IWRINA
      ISTAT2=IWRIST
      IFORM2=IWRIFO
      IACCE2=IWRIAC
      IPROT2=IWRIPR
      ICURS2=IWRICS
C
      ISUBN0='COFI'
      IERRFI='NO'
C
      IF(IBUGS2.EQ.'OFF'.AND.ISUBRO.NE.'COFI')GOTO1199
      WRITE(ICOUT,1181)IOUNI1
 1181 FORMAT('IOUNI1 = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1182)IFILE1
 1182 FORMAT('IFILE1 = ',A80)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1183)ISTAT2,IFORM2,IACCE2,IPROT2,ICURS2
 1183 FORMAT('ISTAT2,IFORM2,IACCE2,IPROT2,ICURS2 = ',
     1A12,2X,A12,2X,A12,2X,A12,2X,A12)
      CALL DPWRST('XXX','BUG ')
C
      WRITE(ICOUT,1191)IOUNI2
 1191 FORMAT('IOUNI2 = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1192)IFILE2
 1192 FORMAT('IFILE2 = ',A80)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1193)ISTAT1,IFORM1,IACCE1,IPROT1,ICURS1
 1193 FORMAT('ISTAT1,IFORM1,IACCE1,IPROT1,ICURS1 = ',
     1A12,2X,A12,2X,A12,2X,A12,2X,A12)
      CALL DPWRST('XXX','BUG ')
C
      WRITE(ICOUT,1198)ISUBN0,IERRFI
 1198 FORMAT('ISUBN0,IERRFI = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
 1199 CONTINUE
C
C               ***********************************************
C               **  STEP 12--                                **
C               **  CHECK TO SEE IF THE COPY FILE MAY EXIST  **
C               ***********************************************
C
      ISTEPN='12'
      IF(IBUGS2.EQ.'ON'.OR.ISUBRO.EQ.'COFI')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
CCCCC OCTOBER 1994.
CCCCC IF(ISTAT.EQ.'NONE')GOTO1200
      IF(ISTAT1.EQ.'NONE')GOTO1200
      GOTO1290
 1200 CONTINUE
      IERROR='YES'
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1211)
 1211 FORMAT('***** IMPLEMENTATION ERROR IN DPCOFI--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1212)
 1212 FORMAT('      THE DESIRED LISTING')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1213)
 1213 FORMAT('      CANNOT BE CARRIED OUT BECAUSE')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1214)
 1214 FORMAT('      THE INTERNAL VARIABLE    ILISST ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1215)
 1215 FORMAT('      WHICH ALLOWS SUCH LISTING')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1216)
 1216 FORMAT('      HAS BEEN SET TO    NONE.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1217)ISTAT1,ILISST
 1217 FORMAT('ISTAT1,ILISST = ',A12,2X,A12)
      CALL DPWRST('XXX','BUG ')
      GOTO9000
 1290 CONTINUE
C
C               ***************************************
C               **  STEP 13--                        **
C               **  EXTRACT THE INPUT  FILE NAME.    **
C               ***************************************
C
      ISTEPN='13'
      IF(IBUGS2.EQ.'ON'.OR.ISUBRO.EQ.'COFI')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      DO1310I=1,80
      IANSI=IANSLC(I)
      ICANS(I:I)=IANSI(1:1)
 1310 CONTINUE
C
      ISTART=1
      ISTOP=IWIDTH
      IWORD=2
      CALL DPEXWO(ICANS,ISTART,ISTOP,IWORD,
     1ICOL1,ICOL2,IFILE1,NCFIL1,
     1IBUGS2,ISUBRO,IERROR)
C
      ISTART=1
      ISTOP=IWIDTH
      IWORD=3
      CALL DPEXWO(ICANS,ISTART,ISTOP,IWORD,
     1ICOL1,ICOL2,IFILE2,NCFIL2,
     1IBUGS2,ISUBRO,IERROR)
C
 1370 CONTINUE
      IF(NCFIL1.GE.1.AND.NCFIL2.GE.1)GOTO1390
      IERROR='YES'
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1371)
 1371 FORMAT('***** ERROR IN DPCOFI--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1372)
 1372 FORMAT('      2 FILE NAMES--AN INPUT AND AN OUTPUT--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1373)
 1373 FORMAT('      ARE REQUIRED IN THE COPY COMMAND')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1374)
 1374 FORMAT('      (FOR EXAMPLE,    COPY BOXSPRIN.DAT TEMP.)')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1375)
 1375 FORMAT('      BUT 2 NAMES WERE NOT GIVEN HERE.')
      CALL DPWRST('XXX','BUG ')
C
      IF(NCFIL1.GE.1)THEN
         WRITE(ICOUT,1381)(IFILE1(I:I),I=1,NCFIL1)
 1381    FORMAT('   INPUT  FILE--',80A1)
         CALL DPWRST('XXX','BUG ')
      ELSE
         WRITE(ICOUT,1382)
 1382    FORMAT('   INPUT  FILE--')
         CALL DPWRST('XXX','BUG ')
      ENDIF
C
      IF(NCFIL2.GE.1)THEN
         WRITE(ICOUT,1383)(IFILE2(I:I),I=1,NCFIL2)
 1383    FORMAT('   OUTPUT FILE--',80A1)
         CALL DPWRST('XXX','BUG ')
      ELSE
         WRITE(ICOUT,1384)
 1384    FORMAT('   OUTPUT FILE--')
         CALL DPWRST('XXX','BUG ')
      ENDIF
C
      WRITE(ICOUT,1386)
 1386 FORMAT('      THE ENTERED COMMAND LINE WAS AS FOLLOWS--')
      CALL DPWRST('XXX','BUG ')
      IF(IWIDTH.GE.1)THEN
         WRITE(ICOUT,1387)(IANSLC(I),I=1,IWIDTH)
 1387    FORMAT('      ',80A1)
         CALL DPWRST('XXX','BUG ')
      ENDIF
      IF(IWIDTH.LE.0)WRITE(ICOUT,999)
      IF(IWIDTH.LE.0)CALL DPWRST('XXX','BUG ')
      GOTO9000
C
 1390 CONTINUE
      IF(IERROR.EQ.'YES')GOTO9000
C
C               *****************************************
C               **  STEP 21--                          **
C               **  CHECK TO SEE THE TYPE CASE--       **
C               **    1) UNQUALIFIED (THAT IS, FULL);  **
C               **    2) SUBSET/EXCEPT; OR             **
C               **    3) FOR.                          **
C               *****************************************
C
      ISTEPN='21'
      IF(IBUGS2.EQ.'ON'.OR.ISUBRO.EQ.'COFI')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      ICASEQ='FULL'
      ILOCQ=NUMARG+1
      IF(NUMARG.LT.1)GOTO2190
      DO2100J=1,NUMARG
      J1=J
      IF(IHARG(J).EQ.'SUBS'.AND.IHARG2(J).EQ.'ET  ') GOTO2110
      IF(IHARG(J).EQ.'EXCE'.AND.IHARG2(J).EQ.'PT  ') GOTO2110
      IF(IHARG(J).EQ.'FOR '.AND.IHARG2(J).EQ.'    ') GOTO2120
 2100 CONTINUE
      GOTO2190
 2110 CONTINUE
      ICASEQ='SUBS'
      ILOCQ=J1
      GOTO2190
 2120 CONTINUE
      ICASEQ='FOR'
      ILOCQ=J1
      GOTO2190
 2190 CONTINUE
      IF(IBUGS2.EQ.'OFF'.AND.ISUBRO.NE.'COFI')GOTO2195
      WRITE(ICOUT,2191)NUMARG,ILOCQ
 2191 FORMAT('NUMARG,ILOCQ = ',2I8)
      CALL DPWRST('XXX','BUG ')
 2195 CONTINUE
C
C               *********************************************
C               **  STEP 22--                              **
C               **  BRANCH    TO THE APPROPRIATE SUBCASE   **
C               **  (FULL, SUBSET, OR FOR).                **
C               *********************************************
C
      ISTEPN='22'
      IF(IBUGS2.EQ.'ON'.OR.ISUBRO.EQ.'COFI')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(ICASEQ.EQ.'FULL')GOTO2210
      IF(ICASEQ.EQ.'SUBS')GOTO2220
      IF(ICASEQ.EQ.'FOR')GOTO2230
C
 2210 CONTINUE
      DO2215I=1,MAXN
      ISUB(I)=1
 2215 CONTINUE
      NQ=MAXN
      GOTO2270
C
 2220 CONTINUE
      NIOLD=MAXN
      CALL DPSUBS(NIOLD,ILOCS,NS,IBUGQ,IERROR)
      NQ=NIOLD
      GOTO2270
C
 2230 CONTINUE
      NIOLD=MAXN
      CALL DPFOR(NIOLD,NFOR,IROW1,IROWN,
     1NLOCAL,ILOCS,NS,IBUGQ,IERROR)
      NQ=NFOR
      NMXFOR=IROWN
      GOTO2270
C
 2270 CONTINUE
      IF(NQ.GE.MINN2)GOTO2290
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2271)
 2271 FORMAT('***** ERROR IN DPCOFI--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2272)
 2272 FORMAT('      AFTER THE APPROPRIATE SUBSET HAS BEEN ',
     1'EXTRACTED,')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2273)
 2273 FORMAT('      THE NUMBER OF SPECIFIED FILE LINES')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2274)
 2274 FORMAT('      TO BE LISTED ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2276)MINN2
 2276 FORMAT('      MUST BE ',I8,' OR LARGER;')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2277)
 2277 FORMAT('      SUCH WAS NOT THE CASE HERE.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2278)
 2278 FORMAT('      THE ENTERED COMMAND LINE WAS AS FOLLOWS--')
      CALL DPWRST('XXX','BUG ')
      IF(IWIDTH.GE.1)WRITE(ICOUT,2279)(IANSLC(I),I=1,IWIDTH)
 2279 FORMAT('      ',80A1)
      IF(IWIDTH.GE.1)CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
C
 2290 CONTINUE
      NS=NQ
C
C               ****************************************
C               **  STEP 51--                         **
C               **  OPEN  THE INPUT AND OUTPUT FILES  **
C               **  (UNLESS ITS THE                   **
C               **  CONCLUSIONS FILE).                **
C               ****************************************
C
      ISTEPN='31'
      IF(IBUGS2.EQ.'ON'.OR.ISUBRO.EQ.'COFI')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
      IF(IBUGS2.EQ.'ON'.OR.ISUBRO.EQ.'COFI')THEN
         WRITE(ICOUT,3111)IFILE1
 3111    FORMAT('IFILE1 = ',A80)
         CALL DPWRST('XXX','BUG ')
         WRITE(ICOUT,3112)IFILE2
 3112    FORMAT('IFILE2 = ',A80)
         CALL DPWRST('XXX','BUG ')
      ENDIF
C
      IF(IFILE2.EQ.ICONNA)GOTO3190
C
      IREWIN='ON'
      CALL DPOPFI(IOUNI1,IFILE1,ISTAT1,IFORM1,IACCE1,IPROT1,ICURS1,
     1IREWIN,ISUBN0,IERRFI,IBUGS2,ISUBRO,IERROR)
      IF(IERRFI.EQ.'YES')GOTO9000
      CALL DPOPFI(IOUNI2,IFILE2,ISTAT2,IFORM2,IACCE2,IPROT2,ICURS2,
     1IREWIN,ISUBN0,IERRFI,IBUGS2,ISUBRO,IERROR)
      IF(IERRFI.EQ.'YES')GOTO9000
C
 3190 CONTINUE
C
C               ***********************************
C               **  STEP 41--                    **
C               **  READ IN THE INPUT FILE.      **
C               **  WRITE OUT THE OUTPUT FILE.   **
C               ***********************************
C
      ISTEPN='41'
      IF(IBUGS2.EQ.'ON'.OR.ISUBRO.EQ.'COFI')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IMAX=1000000
      IF(ICASEQ.EQ.'SUBS')IMAX=MAXN
      IF(ICASEQ.EQ.'FOR')IMAX=IROWN
C
      DO4110I=1,IMAX
C
      READ(IOUNI1,4111,END=4190)(ISTRIN(J:J),J=1,80)
 4111 FORMAT(80A1)
 
      IF(ISUB(I).EQ.1)THEN
         CALL DPDB80(ISTRIN,JMAX,IBUGS2,ISUBRO,IERROR)
         NCSTRI=JMAX
         WRITE(IOUNI2,4112)(ISTRIN(J:J),J=1,80)
 4112    FORMAT(80A1)
      ENDIF
C
 4110 CONTINUE
 4190 CONTINUE
C
C               **************************
C               **  STEP 51--           **
C               **  CLOSE THE 2 FILES   **
C               **  (UNLESS ITS THE     **
C               **  CONCLUSIONS FILE).  **
C               **************************
C
      ISTEPN='51'
      IF(IBUGS2.EQ.'ON'.OR.ISUBRO.EQ.'COFI')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IFILE2.EQ.ICONNA)GOTO5190
C
      IENDFI='OFF'
      IREWIN='ON'
      CALL DPCLFI(IOUNI1,IFILE1,ISTAT1,IFORM1,IACCE1,IPROT1,ICURS1,
     1IENDFI,IREWIN,ISUBN0,IERRFI,IBUGS2,ISUBRO,IERROR)
      CALL DPCLFI(IOUNI2,IFILE2,ISTAT2,IFORM2,IACCE2,IPROT2,ICURS2,
     1IENDFI,IREWIN,ISUBN0,IERRFI,IBUGS2,ISUBRO,IERROR)
C
 5190 CONTINUE
C
C               ****************
C               **  STEP 90-- **
C               **  EXIT.     **
C               ****************
C
 9000 CONTINUE
      IF(IBUGS2.EQ.'OFF'.AND.ISUBRO.NE.'COFI')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF DPCOFI--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGS2,ISUBRO,IERROR
 9012 FORMAT('IBUGS2,ISUBRO,IERROR = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)ICOM
 9013 FORMAT('ICOM = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9021)IOUNI1,IOUNI2
 9021 FORMAT('IOUNI1,IOUNI2 = ',I8,I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9022)IFILE1
 9022 FORMAT('IFILE1  = ',A80)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9023)IFILE2
 9023 FORMAT('IFILE2  = ',A80)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9024)ISTAT1,ISTAT2
 9024 FORMAT('ISTAT1,ISTAT2  = ',A12,A12)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9025)IFORM1,IFORM2
 9025 FORMAT('IFORM1,IFORM2  = ',A12,A12)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9026)IACCE1,IACCE2
 9026 FORMAT('IACCE1,IACCE2 = ',A12,A12)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9027)IPROT1,IPROT2
 9027 FORMAT('IPROT1,IPROT2  = ',A12,A12)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9028)ICURS1,ICURS2
 9028 FORMAT('ICURS1,ICURS2 = ',A12,A12)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9029)IENDFI
 9029 FORMAT('IENDFI = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9030)IREWIN
 9030 FORMAT('IREWIN = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9031)ISUBN0
 9031 FORMAT('ISUBN0 = ',A12)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9032)IERRFI
 9032 FORMAT('IERRFI = ',A12)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9041)ICASEQ,NQ,NS
 9041 FORMAT('ICASEQ,NQ,NS = ',A4,I8,I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9042)JMAX,NCSTRI
 9042 FORMAT('JMAX,NCSTRI = ',2I8)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPCOHI(ISTART,ISTOP,IANS2,N2,IVALID,VALCON,IVALCO,
     1IBUGA3,IERROR)
C
C     PURPOSE--DETERMINE IF THE STRING DEFINED
C              IN LOCATIONS ISTART THROUGH ISTOP (INCLUSIVE) IN IANS2(.).
C              IS A VALID NUMBER REPRESENTATION
C              AND IF SO, COMPUTE THE VALUE OF THE NUMBER.
C     NOTE--THIS SUBROUTINE IS IDENTICAL TO DPHOCO EXCEPT
C           FOR THE FACT THAT DPHOCO HAS THE INPUT STRING
C           IN LOCATIONS 1 THROUGH N2 OF IANS2(.)
C           WHEREAS DPCOHI HAS THE INPUT STRING
C           IN LOCATIONS ISTART THROUGH ISTOP OF IANS(.).
C
C     ORIGINAL VERSION--JANUARY   1979.
C     UPDATED         --JANUARY   1981.
C     UPDATED         --NOVEMBER  1989.  ITYPE2='NUMBER' BUG
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IANS2
      CHARACTER*4 IVALID
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 ITYPE2
C
      CHARACTER*4 ISTEPN
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
      DIMENSION IANS2(*)
C
C-----COMMON VARIABLES (GENERAL)-----------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPCO'
      ISUBN2='HI  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'OFF')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,81)
   81 FORMAT('***** AT THE BEGINNING OF DPCOHI--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,82)N2,ISTART,ISTOP
   82 FORMAT('N2,ISTART,ISTOP = ',3I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,83)(IANS2(I),I=1,N2)
   83 FORMAT('IANS2(.) = ',115A1)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
C               **********************************
C               **  STEP 1--                    **
C               **  INITIALIZE SOME VARIABLES.  **
C               **********************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IVALID='NO'
C
C               ********************************************************
C               **  STEP 7--                                          **
C               **  CONVERT (IF POSSIBLE) THE STRING INTO A FLOATING  **
C               **  POINT ARGUMENT.                                   **
C               **  OUTPUT THIS FLOATING POINT VALUE IN FLOAT.        **
C               ********************************************************
C
      ISTEPN='7'
      IF(IBUGA3.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      AMIN=-1000000.
      AMAX=+1000000.
      IERROR='NO'
      IVALID='YES'
CCCCC THE FOLLOWING LINE WAS FIXED NOVEMBER 1989
CCCCC ITYPE2='NUMBER'
      ITYPE2='NUMB'
      VALCON=-999.0
      IVALCO=-999
C
      ISTAR2=ISTART
      ISTOP2=ISTOP
C
      ILOC=0
      IDECPT=0
      DO3060I=ISTAR2,ISTOP2
      IF(IANS2(I).EQ.'.')ILOC=I
      IF(IANS2(I).EQ.'.')IDECPT=IDECPT+1
 3060 CONTINUE
      IF(IDECPT.GE.2)GOTO3900
      IF(IDECPT.EQ.1)GOTO3150
      DO3100I=ISTAR2,ISTOP2
      IREV=ISTOP2-(I-ISTAR2)
      IF(IANS2(IREV).EQ.' ')GOTO3100
      IF(IANS2(IREV).EQ.'0')GOTO3110
      IF(IANS2(IREV).EQ.'1')GOTO3110
      IF(IANS2(IREV).EQ.'2')GOTO3110
      IF(IANS2(IREV).EQ.'3')GOTO3110
      IF(IANS2(IREV).EQ.'4')GOTO3110
      IF(IANS2(IREV).EQ.'5')GOTO3110
      IF(IANS2(IREV).EQ.'6')GOTO3110
      IF(IANS2(IREV).EQ.'7')GOTO3110
      IF(IANS2(IREV).EQ.'8')GOTO3110
      IF(IANS2(IREV).EQ.'9')GOTO3110
      IERROR='YES'
      IF(IANS2(IREV).EQ.'+')GOTO3900
      IF(IANS2(IREV).EQ.'-')GOTO3900
      GOTO3900
 3100 CONTINUE
      IERROR='YES'
      GOTO3900
 3110 ILOC=IREV+1
 3150 CONTINUE
      IF(IBUGA3.EQ.'ON')WRITE(ICOUT,3111)ILOC,IDECPT
 3111 FORMAT('ILOC = ',I8,'    IDECPT = ',I8)
      IF(IBUGA3.EQ.'ON')CALL DPWRST('XXX','BUG ')
C
C     SECONDLY, COMPUTE THE INTEGER PART OF THE VALUE
C
      SIGN=1.0
      IDIGI=0
      ISIGN=0
      SUMI=0
      ILOCM1=ILOC-1
      IF(ILOCM1.LT.ISTAR2)GOTO3250
      DO3200I=ISTAR2,ILOCM1
      IREV=ILOCM1-(I-ISTAR2)
      IF(IANS2(IREV).EQ.' ')GOTO3200
      IF(IANS2(IREV).EQ.'0')GOTO3210
      IF(IANS2(IREV).EQ.'1')GOTO3211
      IF(IANS2(IREV).EQ.'2')GOTO3232
      IF(IANS2(IREV).EQ.'3')GOTO3213
      IF(IANS2(IREV).EQ.'4')GOTO3214
      IF(IANS2(IREV).EQ.'5')GOTO3215
      IF(IANS2(IREV).EQ.'6')GOTO3216
      IF(IANS2(IREV).EQ.'7')GOTO3217
      IF(IANS2(IREV).EQ.'8')GOTO3218
      IF(IANS2(IREV).EQ.'9')GOTO3219
      IF(IANS2(IREV).EQ.'+')GOTO3220
      IF(IANS2(IREV).EQ.'-')GOTO3221
      IERROR='YES'
      GOTO3900
 3210 ITERM=0
      GOTO3225
 3211 ITERM=1
      GOTO3225
 3232 ITERM=2
      GOTO3225
 3213 ITERM=3
      GOTO3225
 3214 ITERM=4
      GOTO3225
 3215 ITERM=5
      GOTO3225
 3216 ITERM=6
      GOTO3225
 3217 ITERM=7
      GOTO3225
 3218 ITERM=8
      GOTO3225
 3219 ITERM=9
      GOTO3225
 3220 ISIGN=ISIGN+1
      GOTO3200
 3221 ISIGN=ISIGN+1
      SIGN=-SIGN
      GOTO3200
 3225 IDIGI=IDIGI+1
      TERM=ITERM
      IEXP=IDIGI-1
      SUMI=SUMI+TERM*(10.0**IEXP)
 3200 CONTINUE
 3250 CONTINUE
      IF(ISIGN.GE.2)GOTO3900
      IF(IBUGA3.EQ.'ON')WRITE(ICOUT,3255)IDIGI,SUMI
 3255 FORMAT('IDIGI = ',I8,'    SUMI = ',E15.7)
      IF(IBUGA3.EQ.'ON')CALL DPWRST('XXX','BUG ')
C
C     THIRDLY, COMPUTE THE DECIMAL PART OF THE VALUE
C
      IDIGD=0
      SUMD=0.0
      ILOCP1=ILOC+1
      IF(ILOCP1.GT.ISTOP2)GOTO3350
      DO3300I=ILOCP1,ISTOP2
      IF(IANS2(I).EQ.' ')GOTO3300
      IF(IANS2(I).EQ.'0')GOTO3310
      IF(IANS2(I).EQ.'1')GOTO3311
      IF(IANS2(I).EQ.'2')GOTO3312
      IF(IANS2(I).EQ.'3')GOTO3333
      IF(IANS2(I).EQ.'4')GOTO3314
      IF(IANS2(I).EQ.'5')GOTO3315
      IF(IANS2(I).EQ.'6')GOTO3316
      IF(IANS2(I).EQ.'7')GOTO3317
      IF(IANS2(I).EQ.'8')GOTO3318
      IF(IANS2(I).EQ.'9')GOTO3319
      IERROR='YES'
      GOTO3900
 3310 ITERM=0
      GOTO3325
 3311 ITERM=1
      GOTO3325
 3312 ITERM=2
      GOTO3325
 3333 ITERM=3
      GOTO3325
 3314 ITERM=4
      GOTO3325
 3315 ITERM=5
      GOTO3325
 3316 ITERM=6
      GOTO3325
 3317 ITERM=7
      GOTO3325
 3318 ITERM=8
      GOTO3325
 3319 ITERM=9
      GOTO3325
 3325 IDIGD=IDIGD+1
      TERM=ITERM
      SUMD=SUMD+TERM/(10.0**IDIGD)
 3300 CONTINUE
 3350 CONTINUE
      IF(IBUGA3.EQ.'ON')WRITE(ICOUT,3355)IDIGD,SUMD
 3355 FORMAT('IDIGD = ',I8,'    SUMD = ',E15.7)
      IF(IBUGA3.EQ.'ON')CALL DPWRST('XXX','BUG ')
      IDIGT=IDIGI+IDIGD
      IF(IDIGT.LE.0)GOTO3900
      VALCON=SUMI+SUMD
      IVALCO=VALCON+0.00001
      IF(SIGN.LT.0.0)VALCON=-VALCON
      IF(SIGN.LT.0.0)IVALCO=-IVALCO
      IF(AMIN.LE.VALCON.AND.VALCON.LE.AMAX)GOTO3000
      GOTO3900
C
 3900 CONTINUE
      IF(IERROR.EQ.'YES')ITYPE2='WORD'
 3000 CONTINUE
 3999 CONTINUE
      GOTO9000
C
 9000 CONTINUE
C
      ISTEPN='8'
      IF(IBUGA3.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IERROR.EQ.'YES')IVALID='NO'
      IF(IERROR.EQ.'NO')IVALID='YES'
C
C               ****************
C               **  STEP 90-- **
C               **  EXIT.     **
C               ****************
C
      IF(IBUGA3.EQ.'OFF')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9001)
 9001 FORMAT('***** AT THE END       OF DPCOHI--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9002)IVALID,VALCON,IVALCO
 9002 FORMAT('IVALID,VALCON,IVALCO = ',A4,2X,E15.7,I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9005)IERROR
 9005 FORMAT('IERROR = ',A4)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPCOIH(IVAL,IHOUT,NOUT,IVALID,IBUGA3,ISUBRO,IERROR)
C
C     PURPOSE--CONVERT AN INTEGER VARIABLE
C              TO A 1-CHARACTER-PER-WORD HOLLARITH STRING.
C
C     ORIGINAL VERSION--JANUARY  1979.
C     UPDATED         --MAY      1986.
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IHOUT
      CHARACTER*4 IVALID
      CHARACTER*4 IBUGA3
      CHARACTER*4 ISUBRO
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISIGN
      CHARACTER*4 IHDIG
C
      DIMENSION IHOUT(*)
C
C-----COMMON VARIABLES (GENERAL)-----------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C     MAXDIG IS THE MAXIMUM NUMBER OF DIGITS
C     FOR AN INTEGER VARIABLE.
C     THIS WILL VARY FROM ONE COMPUTER TO THE NEXT
C     DEPENDING ON THE NUMBER OF BITS FOR A WORD.
C     THE FOLLOWING DEFINED VALUE (= 10)
C     HAS BEEN SET FOR THE VAX 11/780.
C
CCCCC MAXDIG=11
      MAXDIG=9
      NUMDIG=(-999)
C
      IF(IBUGA3.EQ.'OFF'.AND.ISUBRO.NE.'COIH')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF DPCOIH--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGA3,ISUBRO,IERROR
   52 FORMAT('IBUGA3,ISUBRO,IERROR = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)IVAL
   53 FORMAT('IVAL = ',I11)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)NUMDIG
   54 FORMAT('NUMDIG = ',I8)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
C               **********************************
C               **  STEP 1--                    **
C               **  INITIALIZE SOME VARIABLES.  **
C               **********************************
C
      IERROR='NO'
      IVALID='YES'
      IVAL2=IVAL
C
C               ***********************
C               **  STEP 2--         **
C               **  DETERMINE SIGN.  **
C               ***********************
C
      ISIGN='+'
      IF(IVAL2.LT.0)ISIGN='-'
      IVAL2=IABS(IVAL2)
C
C               ***********************************
C               **  STEP 3--                     **
C               **  DETERMINE NUMBER OF DIGITS.  **
C               ***********************************
C
      IMIN=1
      IMAX=MAXDIG
      DO300I=IMIN,IMAX
      IREV=IMAX-I+IMIN
      IDIV=INT(10.0**(IREV-1) + 0.01)
      IDIG=IVAL2/IDIV
      IF(IDIG.NE.0)GOTO350
  300 CONTINUE
      NUMDIG=1
      GOTO390
  350 CONTINUE
      NUMDIG=IREV
  390 CONTINUE
C
C               ***************************************
C               **  STEP 4--                         **
C               **  IF NEGATIVE,                     **
C               **  INSERT SIGN INTO OUTPUT VECTOR.  **
C               ***************************************
C
      J=0
      IF(ISIGN.EQ.'-')J=J+1
      IF(ISIGN.EQ.'-')IHOUT(J)='-'
C
C               **************************
C               **  STEP 5--            **
C               **  INSERT DIGITS INTO  **
C               **  OUTPUT VECTOR.      **
C               **************************
C
      IMIN=1
      IMAX=NUMDIG
      DO500I=IMIN,IMAX
      IREV=IMAX-I+IMIN
      IDIV=INT(10.0**(IREV-1) + 0.01)
      IDIG=IVAL2/IDIV
C
      IF(IDIG.EQ.0)GOTO510
      IF(IDIG.EQ.1)GOTO511
      IF(IDIG.EQ.2)GOTO512
      IF(IDIG.EQ.3)GOTO513
      IF(IDIG.EQ.4)GOTO514
      IF(IDIG.EQ.5)GOTO515
      IF(IDIG.EQ.6)GOTO516
      IF(IDIG.EQ.7)GOTO517
      IF(IDIG.EQ.8)GOTO518
      IF(IDIG.EQ.9)GOTO519
  510 CONTINUE
      IHDIG='0'
      GOTO529
  511 CONTINUE
      IHDIG='1'
      GOTO529
  512 CONTINUE
      IHDIG='2'
      GOTO529
  513 CONTINUE
      IHDIG='3'
      GOTO529
  514 CONTINUE
      IHDIG='4'
      GOTO529
  515 CONTINUE
      IHDIG='5'
      GOTO529
  516 CONTINUE
      IHDIG='6'
      GOTO529
  517 CONTINUE
      IHDIG='7'
      GOTO529
  518 CONTINUE
      IHDIG='8'
      GOTO529
  519 CONTINUE
      IHDIG='9'
      GOTO529
  529 CONTINUE
C
      J=J+1
      IHOUT(J)=IHDIG
      IVAL2=IVAL2-IDIG*IDIV
  500 CONTINUE
      NOUT=J
C
C               ****************
C               **  STEP 6--  **
C               **  EXIT.     **
C               ****************
C
      IF(IBUGA3.EQ.'OFF'.AND.ISUBRO.NE.'COIH')GOTO9090
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF DPCOIH--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGA3,ISUBRO,IERROR
 9012 FORMAT('IBUGA3,ISUBRO,IERROR = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)IVAL
 9013 FORMAT('IVAL = ',I11)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)NOUT
 9014 FORMAT('NOUT = ',I11)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)(IHOUT(I),I=1,NOUT)
 9015 FORMAT('IHOUT(.) = ',80A1)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPCOIP(XP,YP,XC,YC,SLOPE,ABSSLO,SLOEPS,
     1XHORIZ,AUPPER,ALOWER,NHORP,IPHORI,ICHORI,
     1ISTART,ICASHO,ICASIN,
     1XMIN,XMAX,
     1XTEMP2,YTEMP2,ITHORI,
     1IBUGU2,ISUBRO,IERROR)
C
C     PURPOSE--GIVEN THAT THE DATA LINE (XP,YP) TO (XC,YC)
C              IS SUCH THAT (XP,YP) IS TO THE
C              IMMEDIATE LEFT OF THE ISTART-TH ELEMENT
C              OF THE HORIZON TABLE,
C              DETERMINE THE INTERSECTION POINT
C              (XTEMP2,YTEMP2) WHERE THE DATA LINE
C              INTERSECTS THE HORIZON LINE.
C     ORIGINAL VERSION--SEPTEMBER 1988
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICASHO
      CHARACTER*4 ICASIN
C
      CHARACTER*4 IBUGU2
      CHARACTER*4 ISUBRO
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
CCCCC CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      DIMENSION XHORIZ(*)
      DIMENSION AUPPER(*)
      DIMENSION ALOWER(*)
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPCO'
      ISUBN2='IP  '
C
      IF(IBUGU2.EQ.'ON'.OR.ISUBRO.EQ.'COIP')GOTO50
      GOTO90
   50 CONTINUE
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF DPCOIP--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGU2,ISUBRO,IERROR
   52 FORMAT('IBUGU2,ISUBRO,IERROR = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)XP,YP,XC,YC
   53 FORMAT('XP,YP,XC,YC = ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)SLOPE,ABSSLO,SLOEPS
   54 FORMAT('SLOPE,ABSSLO,SLOEPS = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,61)NHORP,IPHORI,ICHORI
   61 FORMAT('NHORP,IPHORI,ICHORI = ',3I8)
      CALL DPWRST('XXX','BUG ')
      DO63I=IPHORI,ICHORI
      WRITE(ICOUT,64)I,XHORIZ(I),AUPPER(I),ALOWER(I)
   64 FORMAT('I,XHORIZ(I),AUPPER(I),ALOWER(I) = ',I8,3E15.7)
      CALL DPWRST('XXX','BUG ')
   63 CONTINUE
      DO65I=IPHORI,ICHORI
      WRITE(ICOUT,66)I,AUPPER(I),ALOWER(I),XHORIZ(I)
   66 FORMAT('I,AUPPER(I),ALOWER(I),XHORIZ(I) = ',I8,3E15.7)
      CALL DPWRST('XXX','BUG ')
   65 CONTINUE
      WRITE(ICOUT,67)ISTART,ICASHO,ICASIN
   67 FORMAT('ISTART,ICASHO,ICASIN = ',I8,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,68)XMIN,XMAX
   68 FORMAT('XMIN,XMAX = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,72)ITHORI
   72 FORMAT('ITHORI = ',I8)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
      I=ISTART-1
      IF(I.LE.0)I=1
      XTEMPO=XHORIZ(I)
      YTEMPO=YP+(XTEMPO-XP)*SLOPE
      YCUTOL=ALOWER(I)
      IF(ICASHO.EQ.'UPPE')YCUTOL=AUPPER(I)
C
      DO1100I=ISTART,ICHORI
      I2=I
      XTEMP=XHORIZ(I)
      YTEMP=YP+(XTEMP-XP)*SLOPE
      YCUT=ALOWER(I)
      IF(ICASHO.EQ.'UPPE')YCUT=AUPPER(I)
      IF(ICASIN.EQ.'LE'.AND.YTEMP.LE.YCUT)GOTO1150
      IF(ICASIN.EQ.'GE'.AND.YTEMP.GE.YCUT)GOTO1150
      XTEMPO=XTEMP
      YTEMPO=YTEMP
      YCUTOL=YCUT
 1100 CONTINUE
C
      XTEMP2=XC
      YTEMP2=YC
      ITHORI=ICHORI
      GOTO1190
C
 1150 CONTINUE
      IF(ABSSLO.LE.SLOEPS)GOTO1160
      GOTO1170
C
 1160 CONTINUE
      XTEMP2=XTEMP
      YTEMP2=YCUT
      ITHORI=I2
      GOTO1190
C
 1170 CONTINUE
      CALL DPCOI2(XTEMPO,YTEMPO,YCUTOL,XTEMP,YTEMP,YCUT,
     1XTEMP2,YTEMP2,IBUGU2,ISUBRO,IERROR)
      CALL HORIND(XTEMP2,XMIN,XMAX,1,NHORP,ITHORI,IBUGU2,ISUBRO,IERROR)
      GOTO1190
C
 1190 CONTINUE
      IF(ICASHO.EQ.'LOWE'.AND.YCUT.LT.ALOWER(ITHORI))ALOWER(ITHORI)=YCUT
      IF(ICASHO.EQ.'UPPE'.AND.YCUT.GT.AUPPER(ITHORI))AUPPER(ITHORI)=YCUT
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
      IF(IBUGU2.EQ.'ON'.OR.ISUBRO.EQ.'COIP')GOTO9010
      GOTO9090
 9010 CONTINUE
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END        OF DPCOIP--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGU2,ISUBRO,IERROR
 9012 FORMAT('IBUGU2,ISUBRO,IERROR = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)XP,YP,XC,YC
 9013 FORMAT('XP,YP,XC,YC = ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)SLOPE,ABSSLO,SLOEPS
 9014 FORMAT('SLOPE,ABSSLO,SLOEPS = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9021)NHORP,IPHORI,ICHORI
 9021 FORMAT('NHORP,IPHORI,ICHORI = ',3I8)
      CALL DPWRST('XXX','BUG ')
      DO9023I=IPHORI,ICHORI
      WRITE(ICOUT,9024)I,XHORIZ(I),AUPPER(I),ALOWER(I)
 9024 FORMAT('I,XHORIZ(I),AUPPER(I),ALOWER(I) = ',I8,3E15.7)
      CALL DPWRST('XXX','BUG ')
 9023 CONTINUE
      DO9025I=IPHORI,ICHORI
      WRITE(ICOUT,9026)I,AUPPER(I),ALOWER(I),XHORIZ(I)
 9026 FORMAT('I,AUPPER(I),ALOWER(I),XHORIZ(I) = ',I8,3E15.7)
      CALL DPWRST('XXX','BUG ')
 9025 CONTINUE
      WRITE(ICOUT,9027)ISTART,ICASHO,ICASIN
 9027 FORMAT('ISTART,ICASHO,ICASIN = ',I8,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9028)XMIN,XMAX
 9028 FORMAT('XMIN,XMAX = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9031)XTEMP2,YTEMP2
 9031 FORMAT('XTEMP2,YTEMP2 = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9032)ITHORI
 9032 FORMAT('ITHORI = ',I8)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPCOI2(X1,Y11,Y12,X2,Y21,Y22,
     1X3,Y3,IBUGU2,ISUBRO,IERROR)
C
C     PURPOSE--COMPUTE THE INTERSECTION POINT (X3,Y3) OF 2 LINES
C              FOR THE SPECIAL CASE WHEN ONLY HAVE
C              2 DISTINCT X VALUES  (RATHER THAN 4)
C              FOR THE 4 Y VALUES.
C              THUS ONE X VALUE HAS 2 Y VALUES,
C              AND THE OTHER X VALUE HAS 2 Y VALUES.
C     ASSUMPTION--THE 2 LINES DO IN FACT INTERSECT.
C     METHOD--FOR THIS SPECIAL CASE WHEN HAVE A COMMON
C             X VALUE FOR THE LEFT DATA AND ANOTHER COMMON
C             X VALUE FOR THE RIGHT DATA, THEN THE
C             SOLUTION FOR THE INTERSECTION POINT
C             IS GEOMETRICALLY QUITE SIMPLE--THE X VALUE IS
C             A CERTAIN PROPORTION P ACROSS AND
C             THE Y VALUE IS THE SAME PROPORTION P
C             BETWEEN THE Y VALUES ON A GIVEN LINE.
C             THAT PROPORTION IS
C                P = DEL1 /(DEL1 + DEL2)
C             WHERE DEL1 = DIFFERENCE OF Y VALUES ON LEFT,
C             AND   DEL2 = DIFFERENCE OF Y VALUES ON RIGHT.
C     ORIGINAL VERSION--SEPTEMBER 1988
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IBUGU2
      CHARACTER*4 ISUBRO
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
CCCCC CHARACTER*4 ISTEPN
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPCO'
      ISUBN2='I2  '
C
      IF(IBUGU2.EQ.'ON'.OR.ISUBRO.EQ.'COI2')GOTO50
      GOTO90
   50 CONTINUE
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF DPCOI2--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGU2,ISUBRO,IERROR
   52 FORMAT('IBUGU2,ISUBRO,IERROR = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)X1,Y11,Y12
   53 FORMAT('X1,Y11,Y12 = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)X2,Y21,Y22
   54 FORMAT('X2,Y21,Y22 = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
C               **************************************************
C               **  STEP 10--                                   **
C               **  COMPUTE THE INTERSECTION POINT              **
C               **************************************************
C
      YDEL1=Y12-Y11
      YDEL2=Y22-Y21
      YDEL2=(-YDEL2)
      YDEL12=YDEL1+YDEL2
      P=YDEL1/YDEL12
      X3=X1+P*(X2-X1)
      Y3=Y11+P*(Y21-Y11)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
      IF(IBUGU2.EQ.'ON'.OR.ISUBRO.EQ.'COI2')GOTO9010
      GOTO9090
 9010 CONTINUE
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF DPCOI2--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGU2,ISUBRO,IERROR
 9012 FORMAT('IBUGU2,ISUBRO,IERROR = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)X1,Y11,Y12
 9013 FORMAT('X1,Y11,Y12 = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)X2,Y21,Y22
 9014 FORMAT('X2,Y21,Y22 = ',3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9021)YDEL1,YDEL2,YDEL12,P
 9021 FORMAT('YDEL1,YDEL2,YDEL12,P = ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9022)X3,Y3
 9022 FORMAT('X3,Y3 = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
      RETURN
      END
      SUBROUTINE DPCOLL(IDEFC1,IDEFC2,IFCOL1,IFCOL2,NUMRCM,
     1IFCOLL,IFCOLU,
     1IFOUND,IERROR)
C
C     PURPOSE--DEFINE COLUMN LIMITS
C              WHICH WILL DEFINE THE EXTREME
C              COLUMNS (WITHIN A FILE) TO BE SCANNED IN CARRYING
C              OUT THE READ AND SERIAL READ COMMANDS.
C              THE 2 LIMITS ARE CONTAINED IN THE
C              2 ARGUMENTS IFCOL1 AND IFCOL2, RESPECTIVELY.
C     INPUT  ARGUMENTS--IHARG  (A  HOLLERITH VECTOR)
C                     --IARGT  (A  HOLLERITH VECTOR)
C                     --IARG   (AN INTEGER VECTOR)
C                     --NUMARG
C                     --IDEFC1
C                     --IDEFC2
C     OUTPUT ARGUMENTS--IFCOL1 (AN INTEGER VARIABLE
C                       CONTAINING THE MINIMUM COLUMN
C                       IN THE DATA FILE TO BE SCANNED
C                       DURING A    READ    OR A    SERIAL READ.
C                     --IFCOL2 (AN INTEGER VARIABLE
C                       CONTAINING THE MAXIMUM COLUMN
C                       IN THE DATA FILE TO BE SCANNED
C                       DURING A    READ    OR A    SERIAL READ.
C                     --IFOUND ('YES' OR 'NO' )
C                     --IERROR ('YES' OR 'NO' )
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--NOVEMBER  1980.
C     UPDATED         --MAY       1982.
C     UPDATED         --FEBRUARY  2003. TEST AGAINST MAXIMUM RECORD
C                                       LENGTH FOR DATA FILE (NUMRCM)
C     UPDATED         --JANUARY   2004. IFCOLL, IFCOLU FOR ARRAYS OF
C                                       COLUMN LIMITS
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
      CHARACTER*4 IHWUSE
      CHARACTER*4 IH11
      CHARACTER*4 IH12
      CHARACTER*4 MESSAG
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
      INTEGER IFCOL3(50)
      INTEGER AINDEX(50)
C
C---------------------------------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCODA.INC'
      INCLUDE 'DPCOHK.INC'
      INCLUDE 'DPCOM2.INC'
C
      DIMENSION IFCOLL(*)
      DIMENSION IFCOLU(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IFOUND='NO'
      IERROR='NO'
C
      IHOLD1=0
      IHOLD2=0
C
C               ****************************************************
C               **  TREAT THE CASE WHEN                           **
C               **  THE COLUMN LIMITS ARE TO BE CHANGED           **
C               ****************************************************
C
 1100 CONTINUE
      IF(NUMARG.LE.0)GOTO9000
      IF(NUMARG.GE.1.AND.IHARG(1).EQ.'LIMI')GOTO1110
      GOTO1190
C
 1110 CONTINUE
      IF(NUMARG.EQ.1)GOTO1120
      IF(IHARG(NUMARG).EQ.'ON')GOTO1120
      IF(IHARG(NUMARG).EQ.'OFF')GOTO1120
      IF(IHARG(NUMARG).EQ.'AUTO')GOTO1120
      IF(IHARG(NUMARG).EQ.'DEFA')GOTO1120
      IF(IHARG(NUMARG).EQ.'?')GOTO8100
      IF(NUMARG.GE.3.AND.IARGT(2).EQ.'NUMB'.AND.
     1IARGT(3).EQ.'NUMB')GOTO1130
      IF(NUMARG.GE.3.AND.IARGT(2).EQ.'WORD'.AND.
     1IARGT(3).EQ.'WORD')GOTO3140
      GOTO1190
C
 1120 CONTINUE
      I1=IDEFC1
      I2=IDEFC2
      IF(I1.LE.I2)IHOLD1=I1
      IF(I1.LE.I2)IHOLD2=I2
      IF(I1.GT.I2)IHOLD1=I2
      IF(I1.GT.I2)IHOLD2=I1
      DO1122I=1,50
        IFCOLL(I)=0
        IFCOLU(I)=0
 1122 CONTINUE
      GOTO1180
C
 1130 CONTINUE
      I1=IARG(2)
      I2=IARG(3)
      IF(I1.LE.I2)IHOLD1=I1
      IF(I1.LE.I2)IHOLD2=I2
      IF(I1.GT.I2)IHOLD1=I2
      IF(I1.GT.I2)IHOLD2=I1
      GOTO1180
C
 1180 CONTINUE
      IFOUND='YES'
      IFCOL1=IHOLD1
      IFCOL2=IHOLD2
C
CCCCC FEBRAURY 2003: CHECK AGAINST MAXIMUM RECORD LENGTH
C
      IF(IFCOL2.GT.NUMRCM)IFCOL2=NUMRCM
C
      IF(IFEEDB.EQ.'OFF')GOTO1189
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1185)
 1185 FORMAT('THE COLUMN LIMITS (FOR READ AND SERIAL READ)')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1186)IFCOL1,IFCOL2
 1186 FORMAT('HAVE JUST BEEN SET TO ',I8,I8)
      CALL DPWRST('XXX','BUG ')
 1189 CONTINUE
      GOTO9000
C
 1190 CONTINUE
C
C               ****************************************************
C               **  TREAT THE CASE WHEN                           **
C               **  THE COLUMN MINIMUM IS TO BE CHANGED           **
C               ****************************************************
C
 1200 CONTINUE
      IF(NUMARG.GE.1.AND.IHARG(1).EQ.'MINI')GOTO1210
      GOTO1290
C
 1210 CONTINUE
      IF(NUMARG.EQ.1)GOTO1220
      IF(IHARG(NUMARG).EQ.'ON')GOTO1220
      IF(IHARG(NUMARG).EQ.'OFF')GOTO1220
      IF(IHARG(NUMARG).EQ.'AUTO')GOTO1220
      IF(IHARG(NUMARG).EQ.'DEFA')GOTO1220
      IF(NUMARG.GE.2.AND.IARGT(2).EQ.'NUMB')GOTO1230
      GOTO1290
C
 1220 CONTINUE
      IHOLD1=IDEFC1
      DO1222I=1,50
        IFCOLL(I)=0
        IFCOLU(I)=0
 1222 CONTINUE
      GOTO1280
C
 1230 CONTINUE
      IHOLD1=IARG(2)
      GOTO1280
C
 1280 CONTINUE
      IFOUND='YES'
      IFCOL1=IHOLD1
C
      IF(IFEEDB.EQ.'OFF')GOTO1289
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1285)
 1285 FORMAT('THE COLUMN MINIMUM (FOR READ AND SERIAL READ)')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1286)IFCOL1
 1286 FORMAT('HAS JUST BEEN SET TO ',I8)
      CALL DPWRST('XXX','BUG ')
 1289 CONTINUE
      GOTO9000
C
 1290 CONTINUE
C
C               ****************************************************
C               **  TREAT THE CASE WHEN                           **
C               **  THE COLUMN MAXIMUM IS TO BE CHANGED           **
C               ****************************************************
C
 1300 CONTINUE
      IF(NUMARG.GE.1.AND.IHARG(1).EQ.'MAXI')GOTO1310
      GOTO1390
C
 1310 CONTINUE
      IF(NUMARG.EQ.1)GOTO1320
      IF(IHARG(NUMARG).EQ.'ON')GOTO1320
      IF(IHARG(NUMARG).EQ.'OFF')GOTO1320
      IF(IHARG(NUMARG).EQ.'AUTO')GOTO1320
      IF(IHARG(NUMARG).EQ.'DEFA')GOTO1320
      IF(NUMARG.GE.2.AND.IARGT(2).EQ.'NUMB')GOTO1330
      GOTO1390
C
 1320 CONTINUE
      IHOLD2=IDEFC2
      DO1322I=1,50
        IFCOLL(I)=0
        IFCOLU(I)=0
 1322 CONTINUE
      GOTO1380
C
 1330 CONTINUE
      IHOLD2=IARG(2)
      GOTO1380
C
 1380 CONTINUE
      IFOUND='YES'
      IFCOL2=IHOLD2
C
CCCCC FEBRAURY 2003: CHECK AGAINST MAXIMUM RECORD LENGTH
C
      IF(IFCOL2.GT.NUMRCM)IFCOL2=NUMRCM
C
      IF(IFEEDB.EQ.'OFF')GOTO1389
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1385)
 1385 FORMAT('THE COLUMN MAXIMUM (FOR READ AND SERIAL READ)')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1386)IFCOL1
 1386 FORMAT('HAS JUST BEEN SET TO ',I8)
      CALL DPWRST('XXX','BUG ')
 1389 CONTINUE
      GOTO9000
C
 1390 CONTINUE
C
C               ********************************************
C               **  STEP 81--                             **
C               **  TREAT THE    ?    CASE--              **
C               **  DUMP OUT CURRENT AND DEFAULT VALUES.  **
C               ********************************************
C
 8100 CONTINUE
      IFOUND='YES'
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,8111)IFCOL1,IFCOL2
 8111 FORMAT('THE CURRENT COLUMN LIMITS ARE ',I8,I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,8112)IDEFC1,IDEFC2
 8112 FORMAT('THE DEFAULT COLUMN LIMITS ARE ',I8,I8)
      CALL DPWRST('XXX','BUG ')
      GOTO9000
C
 3140 CONTINUE
C
      IH11=IHARG(2)
      IH12=IHARG2(2)
      IHWUSE='V'
      MESSAG='YES'
      CALL CHECKN(IH11,IH12,IHWUSE,
     1IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOCV,IERROR)
      IF(IERROR.EQ.'NO')THEN
        ICOL1=IVALUE(ILOCV)
        N1=IN(ILOCV)
      ELSE
        GOTO9000
      ENDIF
C
      IH11=IHARG(3)
      IH12=IHARG2(3)
      IHWUSE='V'
      MESSAG='YES'
      CALL CHECKN(IH11,IH12,IHWUSE,
     1IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOCV,IERROR)
      IF(IERROR.EQ.'NO')THEN
        ICOL2=IVALUE(ILOCV)
        N2=IN(ILOCV)
      ELSE
        GOTO9000
      ENDIF
C
      IF(N1.NE.N2)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,3411)
 3411   FORMAT('***** ERROR: FOR THE VECTOR FORM OF THE COLUMN LIMITS')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,3413)
 3413   FORMAT('      COMMAND, THE NUMBER OF COLUMNS IS NOT EQUAL.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,3415)IHARG(2),IHARG2(2),N1
 3415   FORMAT('      VARIABLE ',A4,A4,' HAS ',I8,' ELEMENTS.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,3415)IHARG(3),IHARG2(3),N2
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
      J=0
      IMAX=MIN(50,N1)
      DO3160I=1,50
        J=J+1
        IFCOLL(J)=0
        IFCOLU(J)=0
        IF(I.GT.IMAX)GOTO3160
C
        IJ=MAXN*(ICOL1-1)+I
        IF(ICOL1.LE.MAXCOL)IFCOLL(J)=INT(V(IJ) + 0.5)
        IF(ICOL1.EQ.MAXCP1)IFCOLL(J)=INT(PRED(I) + 0.5)
        IF(ICOL1.EQ.MAXCP2)IFCOLL(J)=INT(RES(I) + 0.5)
        IF(ICOL1.EQ.MAXCP3)IFCOLL(J)=INT(YPLOT(I) + 0.5)
        IF(ICOL1.EQ.MAXCP4)IFCOLL(J)=INT(XPLOT(I) + 0.5)
        IF(ICOL1.EQ.MAXCP5)IFCOLL(J)=INT(X2PLOT(I) + 0.5)
        IF(ICOL1.EQ.MAXCP6)IFCOLL(J)=INT(TAGPLO(I) + 0.5)
C
        IJ=MAXN*(ICOL2-1)+I
        IF(ICOL2.LE.MAXCOL)IFCOLU(J)=INT(V(IJ) + 0.5)
        IF(ICOL2.EQ.MAXCP1)IFCOLU(J)=INT(PRED(I) + 0.5)
        IF(ICOL2.EQ.MAXCP2)IFCOLU(J)=INT(RES(I) + 0.5)
        IF(ICOL2.EQ.MAXCP3)IFCOLU(J)=INT(YPLOT(I) + 0.5)
        IF(ICOL2.EQ.MAXCP4)IFCOLU(J)=INT(XPLOT(I) + 0.5)
        IF(ICOL2.EQ.MAXCP5)IFCOLU(J)=INT(X2PLOT(I) + 0.5)
        IF(ICOL2.EQ.MAXCP6)IFCOLU(J)=INT(TAGPLO(I) + 0.5)
C
 3160 CONTINUE
C
      DO3180I=1,IMAX
        IF(IFCOLL(I).GT.IFCOLU(I))THEN
          ITEMP=IFCOLL(I)
          IFCOLL(I)=IFCOLU(I)
          IFCOLU(I)=ITEMP
        ENDIF
 3180 CONTINUE
C
C  SORT THE COLUMNS (FROM SMALLEST TO LARGEST VALUE OF IFCOLL)
C
      CALL SORTII(IFCOLL,IMAX,IFCOL3,AINDEX)
      DO3187I=1,IMAX
        IFCOLL(I)=IFCOL3(I)
 3187 CONTINUE
C
      DO3188I=1,IMAX
        J=AINDEX(I)
        IFCOL3(I)=IFCOLU(J)
 3188 CONTINUE
C
      DO3189I=1,IMAX
        IFCOLU(I)=IFCOL3(I)
 3189 CONTINUE
C
      IFCOL1=IFCOLL(1)
      IFCOL2=IFCOLU(IMAX)
C
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3191)
 3191 FORMAT('THE FOLLOWING COLUMN LIMITS HAVE BEEN SET:')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3193)
 3193 FORMAT('VARIABLE         LOWER LIMIT      UPPER LIMIT')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,3195)
 3195 FORMAT('---------------------------------------------')
      CALL DPWRST('XXX','BUG ')
      DO3199I=1,IMAX
        WRITE(ICOUT,3197)I,IFCOLL(I),IFCOLU(I)
        CALL DPWRST('XXX','BUG ')
 3199 CONTINUE
 3197 FORMAT(I8,12X,I8,9X,I8)
C
      IFOUND='YES'
      GOTO9000
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE DPCOLO(IHARG,NUMARG,
     1IDEFCO,
     1ITEXCO,
     1IBUGD2,ISUBRO,IFOUND,IERROR)
C
C     PURPOSE--DEFINE THE COLOR FOR THE LINES
C              IN TEXT AND FIGURES.
C              THE COLOR WILL BE PLACED
C              IN THE CHARACTER VARIABLE ITEXCO.
C     INPUT  ARGUMENTS--IHARG  (A  CHARACTER VECTOR)
C                     --NUMARG
C                     --IDEFCO
C     OUTPUT ARGUMENTS--ITEXCO
C                     --IBUGD2
C                     --IFOUND ('YES' OR 'NO' )
C                     --IERROR ('YES' OR 'NO' )
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--DECEMBER  1982.
C     UPDATED         --OCTOBER   2011. SUPPORT FOR "?"
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IHARG
      CHARACTER*4 IDEFCO
      CHARACTER*4 ITEXCO
      CHARACTER*4 IBUGD2
      CHARACTER*4 ISUBRO
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
C---------------------------------------------------------------------
C
      DIMENSION IHARG(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IFOUND='NO'
      IERROR='NO'
C
      IF(IBUGD2.EQ.'ON')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPCOLO--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,53)IDEFCO,NUMARG
   53   FORMAT('IDEFCO,NUMARG = ',A4,2X,I8)
        CALL DPWRST('XXX','BUG ')
        DO55I=1,NUMARG
          WRITE(ICOUT,56)I,IHARG(I)
   56     FORMAT('I,IHARG(I) = ',I8,2X,A4)
          CALL DPWRST('XXX','BUG ')
   55   CONTINUE
      ENDIF
C
C     THE FOLLOWING LINES HAVE BEEN COMMENTED OUT (NOV. 1983)
C     DUE TO CONFLICTS WITH THE DPDECL SUBROUTINE
C     WHICH SPECIFIES WHETHER OR NOT THE TERMINAL
C     IS A COLOR DEVICE OR NOT.
C
CCCCC IF(NUMARG.EQ.0)GOTO1160
CCCCC IF(IHARG(NUMARG).EQ.'ON')GOTO1160
CCCCC IF(IHARG(NUMARG).EQ.'OFF')GOTO1160
      IF(NUMARG.EQ.0)GOTO9000
      IF(IHARG(NUMARG).EQ.'ON')GOTO9000
      IF(IHARG(NUMARG).EQ.'OFF')GOTO9000
      IF(IHARG(NUMARG).EQ.'AUTO' .OR. IHARG(NUMARG).EQ.'DEFA')THEN
        ITEXCO=IDEFCO
      ELSEIF(IHARG(NUMARG).EQ.'?')THEN
        IFOUND='YES'
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1191)ITEXCO
 1191   FORMAT('THE CURRENT COLOR IS ',A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1193)IDEFCO
 1193   FORMAT('THE DEFAULT COLOR IS ',A4)
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ELSE
        ITEXCO=IHARG(NUMARG)
      ENDIF
C
      IFOUND='YES'
      IF(IFEEDB.EQ.'ON')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1181)
 1181   FORMAT('THE COLOR (FOR LINES IN TEXT AND FIGURES)')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1182)ITEXCO
 1182   FORMAT('HAS JUST BEEN SET TO ',A4)
        CALL DPWRST('XXX','BUG ')
 1189   CONTINUE
      ENDIF
C
 9000 CONTINUE
      IF(IBUGD2.EQ.'ON')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPCOLO--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)IBUGD2,ISUBRO,IFOUND,IERROR
 9012   FORMAT('IBUGD2,ISUBRO,IFOUND,IERROR = ',A4,2X,A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)IDEFCO,ITEXCO
 9013   FORMAT('IDEFCO,ITEXCO = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPCOMB(Y,X,N,MINSIZ,
     1Y2,XLOW,XUPP,N2,IBUGA3,IERROR)
C
C     PURPOSE--FOR THE CHI-SQUARE GOODNESS OF FIT, IT IS RECOMMENDED
C              THAT CLASSES WITH LESS THAN 5 OBSERVATIONS BE COMBINED
C              IN ORDER FOR THE CHI-SQUARE GOODNESS OF FIT TES TO BE
C              VALID.  THE COMMAND IS:
C
C                 LET Y2 XLOW XHIGH = COMBINE FREQUENCY TABLE YCOUNT XMID
C
C              IT IS ASSUMED THAT THE INPUT CLASSES HAVE EQUAL WIDTH
C              AND THERE ARE NO MISSING CLASSES.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2004/10
C     ORIGINAL VERSION--OCTOBER   2004.
C     UPDATED         --FEBRUARY  2006. MODIFY ALGORITHM.
C                                       ORIGINAL ALGORITHM JUST WENT
C                                       FROM LEFT TO RIGHT.  REVISE
C                                       TO GO FROM LEFT TO CENTER
C                                       AND THEN FROM RIGHT TO
C                                       CENTER.  DO THIS SINCE WE
C                                       TYPICALLY WANT TO COMBINE
C                                       BINS WITH SMALL COUNTS IN
C                                       THE TAILS.
C     UPDATED         --JANUARY   2010. CASE WHERE THERE ARE MANY
C                                       EMPTY BINS CAN CAUSE PROBLEMS.
C                                       TO DEAL WITH THIS, REMOVE
C                                       EMPTY BINS FIRST (BUT COMPUTE
C                                       BIN WIDTH FIRST)
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRIT2
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION X(*)
      DIMENSION Y2(*)
      DIMENSION XLOW(*)
      DIMENSION XUPP(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPCO'
      ISUBN2='MB  '
C
      IERROR='NO'
C
      CALL SORTC(X,Y,N,X,Y)
C
      N2=0
      IFLAG=0
      ISTRT=1
C
C               ********************************************
C               **  STEP 1--                              **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      IF(N.LT.2)THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,31)
   31   FORMAT('***** ERROR IN COMBINE FREQUENCY TABLE--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,32)
   32   FORMAT('      THE NUMBER OF INPUT CLASSES IS LESS THAN TWO.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,34)N
   34   FORMAT('      THE ENTERED NUMBER OF INPUT CLASSES HERE = ',I6)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      DO60I=1,N
        IF(Y(I).LT.0.0)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,31)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,62)
   62     FORMAT('      A NEGATIVE FREQUENCY WAS ENCOUNTERED.')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,63)I,Y(I)
   63     FORMAT('      ROW ',I8,' = ',G15.7)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          IERROR='YES'
          GOTO9000
        ENDIF
   60 CONTINUE
C
      IF(IBUGA3.EQ.'ON')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,70)
   70   FORMAT('***** AT THE BEGINNING OF DPCOMB--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,72)N,MINSIZ
   72   FORMAT('N,MINSIZ = ',2I8)
        CALL DPWRST('XXX','BUG ')
        DO73I=1,N
          WRITE(ICOUT,74)I,X(I),Y(I)
   74     FORMAT('I,X(I),Y(I) = ',I8,2G15.7)
          CALL DPWRST('XXX','BUG ')
   73   CONTINUE
      ENDIF
C
C               **********************************************
C               **  STEP 2--                                **
C               **  COMBINE CLASSES WITH A FREQUECNY LESS   **
C               **  THAN MINSIZ.                            **
C               **********************************************
C
      DELTA=X(2) - X(1)
      DO100I=2,N
        ATEMP=X(I) - X(I-1)
        IF(ATEMP.LT.DELTA)DELTA=ATEMP
  100 CONTINUE
      AINC=DELTA/2.0
C
      ICNT=0
      DO105I=1,N
        IF(Y(I).GT.0.5)THEN
          ICNT=ICNT+1
          Y(ICNT)=Y(I)
          X(ICNT)=X(I)
        ENDIF
  105 CONTINUE
      N=ICNT
C
      AMINSZ=REAL(MINSIZ)
      IFLAG=0
      ICNT=0
      ISTRT=-1
      EPS=1.0E-10
C
C  FEBRUARY 2006:  SINCE SMALL FREQUENCIES TEND TO OCCUR IN THE
C                  TAILS, MODIFY THE ALGORITHM TO WORK FROM THE
C                  LEFT TAIL TO THE CENTER AND THEN THE RIGHT
C                  TAIL TO THE CENTER (ORIGINAL IMPLEMENTATION
C                  WENT FROM LEFT TAIL TO RIGHT TAIL).
C
CCCCC DO200I=1,N
CCCCC   AMID=X(I)
CCCCC   ATEMP=REAL(INT(Y(I)+0.5))
CCCCC   IF(IFLAG.EQ.0)THEN
CCCCC     IF(ATEMP+EPS.GE.AMINSZ)THEN
CCCCC       ICNT=ICNT+1
CCCCC       XLOW(ICNT)=AMID - AINC
CCCCC       XUPP(ICNT)=AMID + AINC
CCCCC       Y2(ICNT)=ATEMP
CCCCC     ELSE
CCCCC       IFLAG=1
CCCCC       ASUM=ATEMP
CCCCC       ISTRT=I
CCCCC     ENDIF
CCCCC   ELSE
CCCCC     ASUM=ASUM + ATEMP
CCCCC     IF(ASUM+EPS.GE.AMINSZ)THEN
CCCCC       ICNT=ICNT + 1
CCCCC       XLOW(ICNT)=X(ISTRT) - AINC
CCCCC       XUPP(ICNT)=AMID + AINC
CCCCC       Y2(ICNT)=ASUM
CCCCC       ISTRT=-1
CCCCC       IFLAG=0
CCCCC     ENDIF
CCCCC   ENDIF
CC200 CONTINUE
C
CCCCC IF(IFLAG.EQ.1 .AND. ASUM.GT.0.0)THEN
CCCCC   XUPP(ICNT)=X(N) + AINC
CCCCC   Y2(ICNT)=Y2(ICNT) + ASUM
CCCCC ENDIF
CCCCC N2=ICNT
C
       IMID=N/2
C
C  LEFT TAIL TO CENTER
C
      DO200I=1,IMID
        AMID=X(I)
        ATEMP=REAL(INT(Y(I)+0.5))
        IF(IFLAG.EQ.0)THEN
          IF(ATEMP+EPS.GE.AMINSZ)THEN
            ICNT=ICNT+1
            XLOW(ICNT)=AMID - AINC
            XUPP(ICNT)=AMID + AINC
            Y2(ICNT)=ATEMP
          ELSE
            IFLAG=1
            ASUM=ATEMP
            ISTRT=I
          ENDIF
        ELSE
          ASUM=ASUM + ATEMP
          IF(ASUM+EPS.GE.AMINSZ)THEN
            ICNT=ICNT + 1
            XLOW(ICNT)=X(ISTRT) - AINC
            XUPP(ICNT)=AMID + AINC
            Y2(ICNT)=ASUM
            ISTRT=-1
            IFLAG=0
          ENDIF
        ENDIF
  200 CONTINUE
C
      IF(IFLAG.EQ.1 .AND. ASUM.GT.0.0)THEN
        XUPP(ICNT)=X(IMID) + AINC
        Y2(ICNT)=Y2(ICNT) + ASUM
      ENDIF
      IFLAG=0
      N2LEFT=ICNT
C
      IF(IBUGA3.EQ.'ON')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,270)
  270   FORMAT('***** DPCOMB--AFTER LEFT TAIL FREQUENCIES')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,272)IMID,ICNT
  272   FORMAT('IMID,ICNT = ',2I8)
        CALL DPWRST('XXX','BUG ')
        DO273I=1,ICNT
          WRITE(ICOUT,274)I,XLOW(I),XUPP(I),Y2(I)
  274     FORMAT('I,XLOW(I),XUPP(I),Y2(I) = ',I8,3G15.7)
          CALL DPWRST('XXX','BUG ')
  273   CONTINUE
      ENDIF
C
C
C  RIGHT TAIL TO CENTER.  TEMPORARILY STORE IN UPPER PART OF
C  XLOW, XUPP, AND Y2 ARRARYS, WILL THEN FLIP THE SORT AT THE
C  END.
C
      ICNT2=N
      IMID2=IMID+1
      IF(IMID2.GT.N)THEN
        N2=ICNT
        GOTO9000
      ENDIF
C
      DO300I=N,IMID2,-1
        AMID=X(I)
        ATEMP=REAL(INT(Y(I)+0.5))
        IF(IFLAG.EQ.0)THEN
          IF(ATEMP+EPS.GE.AMINSZ)THEN
            ICNT2=ICNT2+1
            XLOW(ICNT2)=AMID - AINC
            XUPP(ICNT2)=AMID + AINC
            Y2(ICNT2)=ATEMP
          ELSE
            IFLAG=1
            ASUM=ATEMP
            ISTOP=I
          ENDIF
        ELSE
          ASUM=ASUM + ATEMP
          IF(ASUM+EPS.GE.AMINSZ)THEN
            ICNT2=ICNT2 + 1
            XLOW(ICNT2)=AMID - AINC
            XUPP(ICNT2)=X(ISTOP) + AINC
            Y2(ICNT2)=ASUM
            ISTOP=-1
            IFLAG=0
          ENDIF
        ENDIF
  300 CONTINUE
C
      IF(IFLAG.EQ.1 .AND. ASUM.GT.0.0)THEN
        XLOW(ICNT2)=X(IMID2) - AINC
        Y2(ICNT2)=Y2(ICNT2) + ASUM
      ENDIF
      N2RGHT=ICNT2
C
C  NOW COPY REVERSE ORDER RIGHT TAIL ENTRIES
C
      DO400I=ICNT2,N+1,-1
        ICNT=ICNT+1
        Y2(ICNT)=Y2(I)
        XLOW(ICNT)=XLOW(I)
        XUPP(ICNT)=XUPP(I)
  400 CONTINUE
      N2=ICNT
C
C               ******************
C               **   STEP 90--  **
C               **   EXIT       **
C               ******************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END OF DPCOMB--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)IERROR,N2
 9012   FORMAT('IERROR,N2 = ',A4,2X,I8)
        CALL DPWRST('XXX','BUG ')
        DO9015I=1,N2
          WRITE(ICOUT,9016)I,Y2(I),XLOW(I),XUPP(I)
 9016     FORMAT('I,Y2(I),XLOW(I),XUPP(I) = ',I8,3G15.7)
          CALL DPWRST('XXX','BUG ')
 9015   CONTINUE
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPCOMM(IHARG,NUMARG,
     1IDEFCZ,
     1ICOMCH,
     1ICOMFL,
     1IBUGS2,IFOUND,IERROR)
C
C     PURPOSE--DEFINE THE COMMENT CHARACTOR (DEFAULT IS ".").
C              ALSO CHECK FOR "COMMENT CHECK ON/OFF" COMMAND).
C
C              THE COMMENT CHARACTER IS STORED IN 4 CHARACTERS,
C              BUT ONLY THE FIRST CHARACTER IS USED.
C
C     INPUT  ARGUMENTS--IHARG  (A  CHARACTER VECTOR)
C                     --NUMARG (AN INTEGER VARIABLE)
C                     --IDEFCZ (A  CHARACTER VARIABLE)
C                     --IBUGS2 (A  CHARACTER VARIABLE)
C     OUTPUT ARGUMENTS--ICOMCH (A CHARACTER VARIABLE)
C                     --ICOMFL (A CHARACTER VARIABLE)
C                     --IFOUND ('YES' OR 'NO' )
C                     --IERROR ('YES' OR 'NO' )
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--MAY      1990.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IHARG
      CHARACTER*4 IDEFCZ
      CHARACTER*4 ICOMCH
      CHARACTER*4 ICOMFL
      CHARACTER*4 IBUGS2
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
      CHARACTER*4 IHOLD
C
C---------------------------------------------------------------------
C
      DIMENSION IHARG(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IF(IBUGS2.EQ.'OFF')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF DPCOMM--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)IDEFCZ
   53 FORMAT('IDEFCZ = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)NUMARG
   54 FORMAT('NUMARG = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO55I=1,NUMARG
      WRITE(ICOUT,56)I,IHARG(I)
   56 FORMAT('I,IHARG(I) = ',I8,2X,A4)
      CALL DPWRST('XXX','BUG ')
   55 CONTINUE
   90 CONTINUE
C
      IFOUND='NO'
      IERROR='NO'
C
      IF(NUMARG.LE.1.OR.NUMARG.GE.3)GOTO9000
      GOTO1110
C
 1110 CONTINUE
      IF(IHARG(1).EQ.'CHAR')GOTO1120
      IF(IHARG(1).EQ.'CHEC')GOTO2120
      GOTO2120
C
 1120 CONTINUE
      IF(IHARG(2).EQ.'AUTO')GOTO1150
      IF(IHARG(2).EQ.'DEFA')GOTO1150
      GOTO1160
C
 1150 CONTINUE
      IHOLD=IDEFCZ
      GOTO1180
C
 1160 CONTINUE
      IHOLD=IHARG(2)
      GOTO1180
C
 1180 CONTINUE
      IFOUND='YES'
      ICOMCH=IHOLD
C
      IF(IFEEDB.EQ.'OFF')GOTO1189
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1181)ICOMCH(1:1)
 1181 FORMAT('THE COMMENT CHARACTER HAS JUST BEEN SET TO ',
     1A1)
      CALL DPWRST('XXX','BUG ')
 1189 CONTINUE
      GOTO9000
C
 2120 CONTINUE
      IF(IHARG(2).EQ.'ON')GOTO2150
      IF(IHARG(2).EQ.'OFF')GOTO2160
      IF(IHARG(2).EQ.'AUTO')GOTO2150
      IF(IHARG(2).EQ.'DEFA')GOTO2150
      GOTO2160
C
 2150 CONTINUE
      IHOLD='ON'
      GOTO2180
C
 2160 CONTINUE
      IHOLD='OFF'
      GOTO2180
C
 2180 CONTINUE
      IFOUND='YES'
      ICOMFL=IHOLD
C
      IF(IFEEDB.EQ.'OFF')GOTO2189
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      IF(ICOMFL.EQ.'ON')WRITE(ICOUT,2181)
 2181 FORMAT('THE FIRST CHARACTER OF DATA FILES WILL BE CHECKED ',
     1'FOR THE COMMENT CHARACTER.')
      IF(ICOMFL.EQ.'ON')CALL DPWRST('XXX','BUG ')
      IF(ICOMFL.EQ.'OFF')WRITE(ICOUT,2182)
 2182 FORMAT('THE FIRST CHARACTER OF DATA FILES WILL NOT BE ',
     1'CHECKED FOR THE COMMENT CHARACTER.')
      IF(ICOMFL.EQ.'OFF')CALL DPWRST('XXX','BUG ')
 2189 CONTINUE
      GOTO9000
C
 9000 CONTINUE
      IF(IBUGS2.EQ.'OFF')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF DPCOMM-')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGS2,IFOUND,IERROR
 9012 FORMAT('IBUGS2,IFOUND,IERROR = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)IDEFCZ,ICOMCH
 9013 FORMAT('IDEFCZ,ICOMCH = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPCON2(IVAL,VAL,IH,NH,NMDID0,IBUGD2,IERROR)
C
C     NOTE--EXCEPT FOR THE NMDID0 ARGUMENT
C           (AND SOME BUG WRITE STATEMENTS),
C           THIS SUBROUTINE IS IDENTICAL TO DPCONH.
C           IT HAS BEEN DUPLICATED AND PLACED
C           ON THIS BRANCH OF THE OVERLAY/SEGMENTATION
C           TREE STRUCTURE IN ORDER TO ACHIEVE
C           FASTER EXECUTION TIME.
C
C     NOTE--UPON INPUT, IVALUE IS USUALLY INT(VALUE+0.5), BUT
C           FOR NEGATIVE VALUE, IVALUE SHOULD BE INT(VALUE-0.5)
C
C     NOTE--NMDID0 = THE NUMBER OF DECIMAL
C           PLACES DESIRED A PRIORI.
C           IF NMDID0 IS NEGATIVE, THEN THIS IMPLIES
C           THAT THE ACTUAL NUMBER OF DECIMAL PLACES
C           DESIRED IS NOT SET A PRIORI AND SO SHOULD
C           FLOAT WITH THE DATA VALUE.
C
C     PURPOSE--CONVERT NUMERIC VALUE INTO CORRESPONDING
C              CHARACTER STRING.
C
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--MARCH     1983.
C     UPDATED         --FEBRUARY  2011. FIX TO EXTEND THE PRECISION
C                                       A FEW EXTRA PLACES
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IH
      CHARACTER*4 IBUGD2
      CHARACTER*4 IERROR
C
      CHARACTER*4 IHREM
      CHARACTER*4 IHNUM
      CHARACTER*4 IHTEMI
      CHARACTER*4 IHTEMD
C
      DIMENSION IH(*)
      DIMENSION IHTEMI(10)
      DIMENSION IHTEMD(10)
C
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOBE.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----DATA STATEMENTS-------------------------------------------------
C
C-----START POINT---------------------------------------------------------
C
      AINUM=0.0
      FRACT=0.0
      NUMDID=0
      IMAX=0
C
CCCCC IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'CON2')GOTO90
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'CON2'.AND.IBUGD2.EQ.'OFF')
     1GOTO90
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF DPCON2--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IVAL,VAL
   52 FORMAT('IVAL,VAL = ',I8,E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)NMDID0
   53 FORMAT('NMDID0 = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,59)IBUGG4,ISUBG4,IERRG4
   59 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
      ABSVAL=ABS(VAL)
C
      AIVAL=IVAL
      DEL=AIVAL-VAL
      ABSDEL=ABS(DEL)
C
      ABSRAT=ABSDEL
      IF(ABSVAL.GE.1.0)ABSRAT=ABSDEL/ABSVAL
C
CCCCC CUTDEL=10.0**(-16)
C
      CUTDEL=10.0**(-6)
      CUTRAT=10.0**(-6)
C
CCCCC IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'CON2')GOTO919
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'CON2'.AND.IBUGD2.EQ.'OFF')
     1GOTO919
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,911)
  911 FORMAT('***** FROM THE MIDDLE OF DPCON2--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,912)ABSVAL
  912 FORMAT('ABSVAL = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,913)VAL,IVAL,AIVAL,DEL,ABSDEL
  913 FORMAT('VAL,IVAL,AIVAL,DEL,ABSDEL = ',E15.7,I8,3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,914)ABSDEL,CUTDEL
  914 FORMAT('ABSDEL,CUTDEL = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,915)ABSRAT,CUTRAT
  915 FORMAT('ABSRAT,CUTRAT = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
  919 CONTINUE
C
      IF(ABSVAL.LT.1.0.AND.ABSDEL.LE.CUTDEL)GOTO1000
      IF(ABSVAL.GE.1.0.AND.ABSRAT.LE.CUTRAT)GOTO1000
      GOTO2000
C
C               ******************************
C               **  STEP XX--               **
C               **  TREAT THE INTEGER CASE  **
C               ******************************
C
 1000 CONTINUE
C
CCCCC IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'CON2')WRITE(ICOUT,1005)
CCCCC IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'CON2')CALL DPWRST('XXX','BUG ')
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'CON2'.OR.IBUGD2.EQ.'ON')
     1WRITE(ICOUT,1005)
 1005 FORMAT('*****INTEGER CASE*****')
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'CON2'.OR.IBUGD2.EQ.'ON')
     1CALL DPWRST('XXX','BUG ')
C
      INUM=IABS(IVAL)
      NUMDII=0
      IF(INUM.EQ.0)NUMDII=NUMDII+1
      IF(INUM.EQ.0)IHTEMI(NUMDII)='0'
      IF(INUM.EQ.0)GOTO1190
C
      DO1100I=1,10
      IF(INUM.LE.0)GOTO1190
      IRATIO=INUM/10
      IREM=INUM-10*IRATIO
      INUM=IRATIO
      NUMDII=NUMDII+1
      CALL DPCOD2(IREM,IHREM,IBUGD2,IERROR)
      IHTEMI(NUMDII)=IHREM
 1100 CONTINUE
 1190 CONTINUE
      IF(IVAL.LT.0)NUMDII=NUMDII+1
      IF(IVAL.LT.0)IHTEMI(NUMDII)='-'
C
      NH=NUMDII
      IF(NUMDII.LE.0)GOTO1290
      DO1200I=1,NUMDII
      IREV=NUMDII-I+1
      IH(I)=IHTEMI(IREV)
 1200 CONTINUE
 1290 CONTINUE
C
      IF(NMDID0.GE.1)GOTO2500
      GOTO9000
C
C               **********************************
C               **  STEP XX--                   **
C               **  TREAT THE NON-INTEGER CASE  **
C               **********************************
C
 2000 CONTINUE
C
CCCCC IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'CON2')WRITE(ICOUT,2005)
CCCCC IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'CON2')CALL DPWRST('XXX','BUG ')
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'CON2'.OR.IBUGD2.EQ.'ON')
     1WRITE(ICOUT,2005)
 2005 FORMAT('*****NON-INTEGER CASE*****')
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'CON2'.OR.IBUGD2.EQ.'ON')
     1CALL DPWRST('XXX','BUG ')
C
      INUM=ABSVAL
      AINUM=INUM
      FRACT=ABSVAL-AINUM
C
      NUMDII=0
      IF(INUM.EQ.0)NUMDII=NUMDII+1
      IF(INUM.EQ.0)IHTEMI(NUMDII)='0'
      IF(INUM.EQ.0)GOTO2190
C
      DO2100I=1,10
      IF(INUM.LE.0)GOTO2190
      IRATIO=INUM/10
      IREM=INUM-10*IRATIO
      INUM=IRATIO
      NUMDII=NUMDII+1
      CALL DPCOD2(IREM,IHREM,IBUGD2,IERROR)
      IHTEMI(NUMDII)=IHREM
 2100 CONTINUE
 2190 CONTINUE
      IF(VAL.LT.0)NUMDII=NUMDII+1
      IF(VAL.LT.0)IHTEMI(NUMDII)='-'
C
      NUMDID=0
      IF(FRACT.EQ.0.0)NUMDID=0
      IF(FRACT.EQ.0.0)GOTO2390
C
      ANUM=FRACT
CCCCC NOTE 2011/2: LOSING ACCURACY AT ABOUT 6 DECIMAL PLACES.
CCCCC              INCREASE VALUE OF NLOOP SO THAT WE OBTAIN
CCCCC              A FEW EXTRA DIGITS OF ACCURACY.
CCCCC NLOOP=8-NUMDII
      NLOOP=12-NUMDII
CCCCC CUTOF2=10.0**(-NLOOP+1)
CCCCC CUTOF3=1.0-CUTOF2
      IF(NLOOP.LE.0)GOTO2390
      DO2300I=1,NLOOP
      CUTOF2=10.0**(-NLOOP+I+1)
      CUTOF3=1.0-CUTOF2
      ANUM=ANUM*10.0
      INUM=ANUM
      AINUM=INUM
      DEL3=ANUM-AINUM
CCCCC IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'CON2')WRITE(ICOUT,2311)
CCCCC IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'CON2')CALL DPWRST('XXX','BUG ')
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'CON2'.OR.IBUGD2.EQ.'ON')
     1WRITE(ICOUT,2311)
     1NLOOP,I,CUTOF3,CUTOF2
 2311 FORMAT('NLOOP,I,CUTOF3,CUTOF2 = ',I8,I8,2E15.7)
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'CON2'.OR.IBUGD2.EQ.'ON')
     1CALL DPWRST('XXX','BUG ')
CCCCC IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'CON2')WRITE(ICOUT,2312)
CCCCC IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'CON2')CALL DPWRST('XXX','BUG ')
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'CON2'.OR.IBUGD2.EQ.'ON')
     1WRITE(ICOUT,2312)
     1ANUM,AINUM,DEL3,CUTOF3
 2312 FORMAT('ANUM,AINUM,DEL3,CUTOF3 = ',4E15.7)
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'CON2'.OR.IBUGD2.EQ.'ON')
     1CALL DPWRST('XXX','BUG ')
      IF(DEL3.GE.CUTOF3)INUM=INUM+1
      IF(DEL3.GE.CUTOF3)ANUM=INUM
      NUMDID=NUMDID+1
      CALL DPCOD2(INUM,IHNUM,IBUGD2,IERROR)
      IHTEMD(NUMDID)=IHNUM
      AINUM=INUM
      DEL2=ANUM-AINUM
      ANUM=DEL2
CCCCC IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'CON2')WRITE(ICOUT,2313)
CCCCC IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'CON2')CALL DPWRST('XXX','BUG ')
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'CON2'.OR.IBUGD2.EQ.'ON')
     1WRITE(ICOUT,2313)
     1ANUM,AINUM,DEL2,CUTOF2
 2313 FORMAT('ANUM,AINUM,DEL2,CUTOF2 = ',4E15.7)
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'CON2'.OR.IBUGD2.EQ.'ON')
     1CALL DPWRST('XXX','BUG ')
      IF(DEL2.LE.CUTOF2)GOTO2390
 2300 CONTINUE
 2390 CONTINUE
C
      NH=0
      IF(NUMDII.LE.0)GOTO2490
      DO2400I=1,NUMDII
      NH=NH+1
      IREV=NUMDII-I+1
      IH(NH)=IHTEMI(IREV)
 2400 CONTINUE
 2490 CONTINUE
C
 2500 CONTINUE
      NH=NH+1
      IH(NH)='.'
C
      IMAX=NMDID0
      IF(NMDID0.LT.0)IMAX=NUMDID
C
      IF(IMAX.LE.0)GOTO2690
      DO2600I=1,IMAX
      NH=NH+1
      IF(NMDID0.LT.0)IH(NH)=IHTEMD(I)
      IF(NMDID0.GE.0.AND.I.LE.NUMDID)IH(NH)=IHTEMD(I)
      IF(NMDID0.GE.0.AND.I.GT.NUMDID)IH(NH)='0'
 2600 CONTINUE
 2690 CONTINUE
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
CCCCC IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'CON2')GOTO9090
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'CON2'.AND.IBUGD2.EQ.'OFF')
     1GOTO9090
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF DPCON2--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IVAL,VAL
 9012 FORMAT('IVAL,VAL = ',I8,E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)AIVAL,VAL,DEL,ABSDEL,CUTDEL
 9013 FORMAT('AIVAL,VAL,DEL,ABSDEL,CUTDEL = ',5E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)ABSVAL,INUM,AINUM,FRACT
 9014 FORMAT('ABSVAL,INUM,AINUM,FRACT = ',E15.7,2X,I8,2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)NUMDII
 9015 FORMAT('NUMDII = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9016)(IHTEMI(I),I=1,NUMDII)
 9016 FORMAT('(IHTEMI(I),I=1,NUMDII) = ',20A1)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9025)NMDID0,NUMDID,IMAX
 9025 FORMAT('NMDID0,NUMDID,IMAX = ',3I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9026)(IHTEMD(I),I=1,NUMDID)
 9026 FORMAT('(IHTEMD(I),I=1,NUMDID) = ',20A1)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9031)NH
 9031 FORMAT('NH = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9032)(IH(I),I=1,NH)
 9032 FORMAT('(IH(I),I=1,NH) = ',20A1)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9039)IBUGG4,ISUBG4,IERRG4
 9039 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPCOND(NPLOTV,NPLOTP,NS,ICASPL,IAND1,IAND2,
     1                  IANGLU,MAXNPP,
     1                  CLLIMI,CLWIDT,
     1                  ICONT,NUMHPP,NUMVPP,IMANUF,
     1                  XMATN,YMATN,XMITN,YMITN,
     1                  ISQUAR,
     1                  IVGMSW,IHGMSW,
     1                  IMPSW,IMPNR,IMPNC,IMPCO,
     1                  PMXMIN,PMXMAX,PMYMIN,PMYMAX,
     1                  MAXNXT,
     1                  ALOWFR,ALOWDG,
     1                  IFORSW,
     1                  ANOPL1,ANOPL2,ISEED,IBOOSS,BARHEF,BARWEF,
     1                  ICAPSW,
     1                  IBUGG2,IBUGG3,IBUGCO,IBUGEV,IBUGQ,
     1                  IBUGUG,IBUGU2,IBUGU3,IBUGU4,ISUBRO,
     1                  IFOUND,IERROR)
C
C     PURPOSE--GENERATE A CONDITIONING PLOT (COPLOT)
C            --ALLOWABLE SYNTAXES:
C                CONDITIONING PLOT Y COND
C                CONDITIONING PLOT Y X COND
C                CONDITIONING PLOT Y X COND TAG
C                CONDITIONING PLOT Y X COND1 COND2
C                CONDITIONING PLOT Y X COND1 COND2 TAG
C                CONDITIONING PLOT Y1 ... YK X COND TAG
C             --THAT IS, THERE ARE:
C               1) ONE OR MORE RESPONSE VARIABLES (DETERMINED BY
C                  SET COND PLOT RESPONSE VARIABLES <VALUE>
C               2) AN OPTIONAL INDEPENDENT VARIABLE.  THIS IS
C                  DETERMINED BT THE PLOT TYPE.
C                  NOTE: 3D PLOT TYPES WILL HAVE EITHER 2 OR 3
C                  INDEPENDENT VARIABLES.
C               3) EITHER ONE OR TWO CONDITIONING VARIABLES (DETERMINED
C                  BY: SET COND PLOT CONDITION VARIABLES <1/2>)
C               4) AN OPTIONAL TAG VARIABLE (DETERMINED BY 
C                  SET COND PLOT TAG <ON/OFF>)
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--99/9
C     ORIGINAL VERSION --SEPTEMBER 1999.
C     UPDATED          --APRIL     2007. ADD ROSE PLOT
C     UPDATED          --AUGUST    2007. CALL LIST TO MAINGR
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES---------------
C
      REAL CLLIMI(*)
      REAL CLWIDT(*)
C
      INCLUDE 'DPCOPA.INC'
C
      CHARACTER*4 ICASPL
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICASEQ
      CHARACTER*4 ICONT
      CHARACTER*4 IAND1
      CHARACTER*4 IAND2
      CHARACTER*4 IANGLU
      CHARACTER*4 IFORSW
C
      CHARACTER*4 IBUGG2
      CHARACTER*4 IBUGG3
      CHARACTER*4 IBUGUG
      CHARACTER*4 IBUGU2
      CHARACTER*4 IBUGU3
      CHARACTER*4 IBUGU4
      CHARACTER*4 IBUGCO
      CHARACTER*4 IBUGEV
      CHARACTER*4 IBUGQ
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 ISUBN0
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISQUAR
      CHARACTER*4 IVGMSW
      CHARACTER*4 IHGMSW
      CHARACTER*4 IREPCH
      CHARACTER*4 IMPSW
C
      CHARACTER*4 ICPLLD
      CHARACTER*4 ICPLDI
      CHARACTER*4 IEMPTY
      CHARACTER*4 IFEED9
      CHARACTER*4 ICPLFZ
      CHARACTER*4 ICPLPZ
      CHARACTER*4 ICPLLZ
      CHARACTER*4 ICPLTZ
      CHARACTER*4 ICPLL2
      CHARACTER*4 ICPLXZ
      CHARACTER*4 ICPLYZ
      CHARACTER*4 ICPLDZ
      CHARACTER*4 ICPLZT
      CHARACTER*4 ICPLZ2
      CHARACTER*4 ICPLZ3
      CHARACTER*4 ICPLZ4
      CHARACTER*4 ILFLAX
      CHARACTER*4 ILFLAY
C
      CHARACTER*4 IMANUF
      CHARACTER*4 IPLTTY
      CHARACTER*4 IPLOTT
      CHARACTER*4 IFLGIN
      CHARACTER*4 IFLGX
      CHARACTER*4 IFLGY
      CHARACTER*4 IWRITE
      CHARACTER*4 ISUBSZ
C
      CHARACTER*4 ICT
      CHARACTER*4 IC2T
      CHARACTER*4 IHT(25)
      CHARACTER*4 IH2T(25)
      CHARACTER*4 IARGTT(25)
      REAL ARGT(25)
C
C  MAXY IS THE MAXIMUM NUMBER OF VARIABLES TO USE IN CREATING THE
C  CONDITIONING PLOT   CURVE
C
      PARAMETER(MAXY=50)
      CHARACTER*40 INAME
      CHARACTER*4 IVARN1(MAXY)
      CHARACTER*4 IVARN2(MAXY)
      CHARACTER*4 IVARTY(MAXY)
      DIMENSION ILIS(MAXY)
      DIMENSION PVAR(MAXY)
      DIMENSION NRIGHT(MAXY)
      DIMENSION ICOLL(MAXY)
C
      CHARACTER*4 IHRIGH
      CHARACTER*4 IHRIG2
      CHARACTER*4 IHWUSE
      CHARACTER*4 MESSAG
      CHARACTER*4 ISTEPN
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
      DIMENSION TEMP(MAXOBV)
      DIMENSION TEMP2(MAXOBV)
      DIMENSION TEMP3(MAXOBV)
      DIMENSION XTEMP1(MAXOBV)
      DIMENSION XTEMP2(MAXOBV)
C
C-----COMMON------------------------------------------------------
C
      DIMENSION ADIST1(MAXY)
      DIMENSION ADIST2(MAXY)
C
      INCLUDE 'DPCOZ3.INC'
      INCLUDE 'DPCOPC.INC'
      INCLUDE 'DPCOHK.INC'
      INCLUDE 'DPCODA.INC'
      INCLUDE 'DPCOST.INC'
      INCLUDE 'DPCOSP.INC'
C
      EQUIVALENCE (G3RBAG(KGARB1),TEMP(1))
      EQUIVALENCE (G3RBAG(KGARB2),TEMP2(1))
      EQUIVALENCE (G3RBAG(KGARB3),TEMP3(1))
      EQUIVALENCE (G3RBAG(KGARB4),XTEMP1(1))
      EQUIVALENCE (G3RBAG(KGARB5),XTEMP2(1))
C
C
C-----COMMON VARIABLES (GENERAL)----------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-------------------------------------------------
C
      IFOUND='YES'
      IERROR='NO'
C
      ISUBN1='DPCOND'
      ISUBN2='    '
C
      ICASPL='COND'
      ICPLLD='ON'
      ICPLDI='BLAN'
C
      IPLTTY='BIVA'
      IF(ICPLPT.EQ.'HIST')IPLTTY='UNIV'
      IF(ICPLPT.EQ.'RUNS')IPLTTY='UNIV'
      IF(ICPLPT.EQ.'PERC')IPLTTY='UNIV'
      IF(ICPLPT.EQ.'AUTO')IPLTTY='UNIV'
      IF(ICPLPT.EQ.'LAG ')IPLTTY='UNIV'
      IF(ICPLPT.EQ.'PROB')IPLTTY='UNIV'
      IF(ICPLPT.EQ.'PPCC')IPLTTY='UNIV'
      IF(ICPLPT.EQ.'DENS')IPLTTY='UNIV'
      IF(ICPLPT.EQ.'ROSE')IPLTTY='UNIV'
      ICPLXV=1
      IF(IPLTTY.EQ.'UNIV')ICPLXV=0
      IF(ICPLPT.EQ.'YACU')ICPLXV=3
      IF(ICPLPT.EQ.'3DPL')ICPLXV=2
C
      ICPLRV=INT(PCPLRV+0.5)
      IF(ICPLRV.LT.1)ICPLRV=1
      ITAG=0
      IF(ICPLTA.EQ.'ON'.AND.ICPLPT.EQ.'PLOT')ITAG=1
      ICPLTV=INT(PCPLTV+0.5)
      IF(ICPLTV.LT.1)ICPLTV=1
      IF(ICPLTV.GT.2)ICPLTV=2
C
      IFLAGV=ICPLRV+ICPLXV+ICPLTV+ITAG
C
      IRC1=1
      IRC2=ICPLRV
      ICOL=IRC2
      IF(ICPLXV.GE.1)ICOL=ICOL+1
      IXC1=ICOL
      IF(ICPLXV.GE.2)THEN
        ICOL=ICOL+1
        IXC2=ICOL
      ENDIF
      IF(ICPLXV.GE.3)THEN
        ICOL=ICOL+1
        IXC3=ICOL
      ENDIF
      ICOL=ICOL+1
      ICC1=ICOL
      IF(ICPLTV.EQ.2)ICOL=ICOL+1
      ICC2=ICOL
      IF(ITAG.GT.0)ICOL=ICOL+1
      ITC1=ICOL
C
C               *****************************************
C               **  TREAT THE CONDITIONING PLOT   CASE **
C               *****************************************
C
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'COND')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPCOND--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)ICASPL,IAND1,IAND2,NUMARG
   52   FORMAT('ICASPL,IAND1,IAND2,NUMARG = ',3(A4,2X),I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,53)IBUGG2,IBUGG3,IBUGQ,ISUBRO
   53   FORMAT('IBUGG2,IBUGG3,IBUGQ,ISUBRO = ',3(A4,2X),A4)
        CALL DPWRST('XXX','BUG ')
        IF(NUMARG.GT.0)THEN
          DO61I=1,NUMARG
            WRITE(ICOUT,62)I,IHARG(I),IARGT(I)
   62       FORMAT('I,IHARG(I),IARGT(I) = ',I8,2X,A4,2X,A4)
            CALL DPWRST('XXX','BUG ')
   61     CONTINUE
        ENDIF
        WRITE(ICOUT,71)ICPLLA,ICPLTA,ICPLPT,ICPLFI,ICPLFR
   71   FORMAT('ICPLLA,ICPLTA,ICPLPT,ICPLFI,ICPLFR = ',4(A4,2X),A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               ******************************************************
C               **  STEP 1--                                        **
C               **  SHIFT COMMAND LINE ARGMENTS                     **
C               ******************************************************
C
      ISTEPN='1'
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'COND')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(NUMARG.GE.1.AND.IHARG(1).EQ.'PLOT')THEN
        ISHIFT=1
        CALL SHIFTL(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1              IBUGG2,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
      ENDIF
      ICOM='PLOT'
      ICOM2='    '
      IFOUND='YES'
C
C               *******************************************************
C               **  STEP 2--                                         **
C               **  CHECK FOR THE PROPER NUMBER OF INPUT ARGUMENTS.  **
C               *******************************************************
C
      ISTEPN='2'
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'COND')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      INAME='CONDITION PLOT'
      MINNA=1
      MAXNA=100
      MINN2=2
      IFLAGE=1
      IF(IFPLPT.EQ.'HIST')IFLAGE=0
      IFLAGM=1
      IFLAGP=0
      JMIN=1
      JMAX=NUMARG
      MINNVA=1
      MAXNVA=MAXY
C
      CALL DPPARS(IHARG,IHARG2,IARGT,ARG,NUMARG,IANS,IWIDTH,
     1            IHNAME,IHNAM2,IUSE,NUMNAM,IN,IVALUE,VALUE,
     1            JMIN,JMAX,
     1            MINN2,MINNA,MAXNA,MAXY,IFLAGE,INAME,
     1            IVARN1,IVARN2,IVARTY,PVAR,
     1            ILIS,NRIGHT,ICOLL,ISUB,NQ,ILOCQ,NUMVAR,
     1            MINNVA,MAXNVA,
     1            IFLAGM,IFLAGP,
     1            IBUGG3,IBUGQ,ISUBRO,IFOUND,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'COND')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,281)
  281   FORMAT('***** AFTER CALL DPPARS--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,282)NQ,NUMVAR
  282   FORMAT('NQ,NUMVAR = ',2I8)
        CALL DPWRST('XXX','BUG ')
        IF(NUMVAR.GT.0)THEN
          DO285I=1,NUMVAR
            WRITE(ICOUT,287)I,IVARN1(I),IVARN2(I),ILIS(I),NRIGHT(I),
     1                      ICOLL(I)
  287       FORMAT('I,IVARN1(I),IVARN2(I),ILIS(I),NRIGHT(I),',
     1             'ICOLL(I) = ',I8,2X,A4,A4,2X,3I8)
            CALL DPWRST('XXX','BUG ')
  285     CONTINUE
        ENDIF
      ENDIF
C
C               **************************************************
C               **  STEP 12B-                                   **
C               **  NUMBER OF VARIABLES MUST EQUAL IFLAGV       **
C               **************************************************
C
      ISTEPN='12B'
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'COND')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(NUMVAR.NE.IFLAGV)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1291)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1293)ICPLRV
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1294)ICPLXV
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1295)ICPLTV
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1296)ITAG
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1297)NUMVAR
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1328)
 1328   FORMAT('THE ENTERED COMMAND LINE WAS AS FOLLOWS--')
        CALL DPWRST('XXX','BUG ')
        IF(IWIDTH.GE.1)THEN
          WRITE(ICOUT,1329)(IANS(J),J=1,MIN(IWIDTH,100))
 1329     FORMAT('    ',100A1)
          CALL DPWRST('XXX','BUG ')
        ENDIF
        IERROR='YES'
        GOTO9000
      ENDIF
 1291 FORMAT('***** ERROR IN DPCOND--EXPECTED')
 1293 FORMAT('         ',I8,'RESPONSE VARIABLES')
 1294 FORMAT('         ',I8,'INDEPENDENT VARIABLES')
 1295 FORMAT('         ',I8,'CONDITIONING VARIABLES')
 1296 FORMAT('         ',I8,'TAG VARIABLES')
 1297 FORMAT('      DETECTED ',I8,' VARIABLES.')
C
 1290 CONTINUE
C
C               ***************************************
C               **  STEP 13--                        **
C               **  CHECK THE VALIDITY OF EACH       **
C               **  OF THE VARIABLES.                **
C               **  ALSO CHECK TO ASSURE THAT EACH   **
C               **  OF THE VARIABLES HAS AT LEAST    **
C               **  2 OBSERVATIONS.                  **
C               ***************************************
C
      ISTEPN='13'
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'COND')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      MAXCP1=MAXCOL+1
      MAXCP2=MAXCOL+2
      MAXCP3=MAXCOL+3
      MAXCP4=MAXCOL+4
      MAXCP5=MAXCOL+5
      MAXCP6=MAXCOL+6
C
      IFLAG=0
      IFLAG2=0
      DO1300I=1,NUMVAR
C
        IF(I.EQ.ICC1)THEN
          ICOL=ICOLL(I)
          J=0
          DO1261ITEMP=1,NRIGHT(I)
            J=J+1
            NIN=J
            IJ=MAXN*(ICOL-1)+ITEMP
            IF(ICOL.LE.MAXCOL)TEMP(J)=V(IJ)
            IF(ICOL.EQ.MAXCP1)TEMP(J)=PRED(ITEMP)
            IF(ICOL.EQ.MAXCP2)TEMP(J)=RES(ITEMP)
            IF(ICOL.EQ.MAXCP3)TEMP(J)=YPLOT(ITEMP)
            IF(ICOL.EQ.MAXCP4)TEMP(J)=XPLOT(ITEMP)
            IF(ICOL.EQ.MAXCP5)TEMP(J)=X2PLOT(ITEMP)
            IF(ICOL.EQ.MAXCP6)TEMP(J)=TAGPLO(ITEMP)
 1261     CONTINUE
          IWRITE='OFF'
          CALL DISTIN(TEMP,NIN,IWRITE,XTEMP1,NOUT,IBUGG3,IERROR)
          IF(NOUT.GT.MAXY)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,1266)
 1266       FORMAT('***** ERROR IN CONDITIONING PLOT--')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,1267)NOUT
 1267       FORMAT('      NUMBER OF DISTINCT SUBSETS, ',I8,
     1             ' EXCEEDS THE ')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,1268)MAXY
 1268       FORMAT('      MAXIMUM ALLOWABLE OF ',I8)
            CALL DPWRST('XXX','BUG ')
            IERROR='YES'
            GOTO9000
          ELSE
            DO1269KK=1,NOUT
              ADIST1(KK)=XTEMP1(KK)
 1269       CONTINUE
          ENDIF
        ENDIF
C
        IF(ICPLTV.EQ.2.AND.I.EQ.ICC2)THEN
          ICOL=ICOLL(I)
          J=0
          DO1271ITEMP=1,NRIGHT(I)
            J=J+1
            NIN2=J
            IJ=MAXN*(ICOL-1)+ITEMP
            IF(ICOL.LE.MAXCOL)TEMP2(J)=V(IJ)
            IF(ICOL.EQ.MAXCP1)TEMP2(J)=PRED(ITEMP)
            IF(ICOL.EQ.MAXCP2)TEMP2(J)=RES(ITEMP)
            IF(ICOL.EQ.MAXCP3)TEMP2(J)=YPLOT(ITEMP)
            IF(ICOL.EQ.MAXCP4)TEMP2(J)=XPLOT(ITEMP)
            IF(ICOL.EQ.MAXCP5)TEMP2(J)=X2PLOT(ITEMP)
            IF(ICOL.EQ.MAXCP6)TEMP2(J)=TAGPLO(ITEMP)
 1271     CONTINUE
          IWRITE='OFF'
          CALL DISTIN(TEMP2,NIN2,IWRITE,XTEMP1,NOUT2,IBUGG3,IERROR)
          IF(NOUT2.GT.MAXY)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,1276)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,1277)NOUT2
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,1278)MAXY
            CALL DPWRST('XXX','BUG ')
            IERROR='YES'
            GOTO9000
          ELSE
            DO1279KK=1,NOUT
              ADIST2(KK)=XTEMP1(KK)
 1279       CONTINUE
          ENDIF
        ENDIF
 1276 FORMAT('***** ERROR IN CONDITIONING PLOT--')
 1277 FORMAT('      NUMBER OF DISTINCT SUBSETS, ',I8,' EXCEEDS THE ')
 1278 FORMAT('      MAXIMUM ALLOWABLE OF ',I8)
C
 1300 CONTINUE
C
C               **************************************************
C               **   STEP 1--                                   **
C               **   SAVE INITIAL SETTINGS                      **
C               **************************************************
C
      ISTEPN='1'
      IF(IBUGG3.EQ.'ON'.OR.ISUBRO.EQ.'COND')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IFLAG=1
      CALL DPSPM5(IFLAG,IMPSW,IMPCO,IMPNR,IMPNC,IOUNI5,
     1            IBUGG2,ISUBRO,IFOUND,IERROR)
C
      ICPLFZ=ICPLFR
      ICPLL2=ICPLLA
      IF(ICPLFR.EQ.'CONN')ICPLFR='DEFA'
      IF(ICPLFR.EQ.'USER'.AND.ICPLLA.EQ.'BOX')ICPLLA='ON'
      IF(ICPLLA.EQ.'BOX ')THEN
        ICPLLD='ON'
      ENDIF
      ICPLTZ=ICPLTA
      ICPLPZ=ICPLPT
      ICPLLZ=ICPLLD
      ICPLZT=ICPLST
      ICPLZ2=ICPLS2
      ICPLZ3=ICPLS3
      ICPLZ4=ICPLS4
      ICPLXZ=ICPLXA
      ICPLYZ=ICPLYA
      ICPLDZ=ICPLDI
C
      ILFLAX='OFF'
      ILFLAY='OFF'
      IF(IY1MIN.EQ.'FIXE'.AND.IY1MAX.EQ.'FIXE')THEN
        ILFLAY='ON'
      ENDIF
      IF(IX1MIN.EQ.'FIXE'.AND.IX2MAX.EQ.'FIXE')THEN
        ILFLAX='ON'
      ENDIF
C
      IFEED9=IFEEDB
      IFLGIN='OFF'
      IFLGY='OFF'
      IFLGX='OFF'
C
      IF(ICPLTA.EQ.'ON'.AND.ICPLPT.EQ.'PLOT')THEN
        ISHIFT=ILOCQ-1
        CALL SHIFTL(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1              IBUGG2,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        ISHIFT=NUMVAR-1
        CALL SHIFTR(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1              IBUGG2,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        DO1509I=1,ISHIFT
          IHARG(I)=IVARN1(I)
          IHARG2(I)=IVARN2(I)
 1509   CONTINUE
        NUMVAR=NUMVAR-1
        IF(IPLTTY.EQ.'UNIV')THEN
          IF(NUMVAR.LT.1)GOTO9000
        ELSEIF(IPLTTY.EQ.'BIVA')THEN
          IF(NUMVAR.LT.2)GOTO9000
        ENDIF
        ILOCQ=ISHIFT+1
      ENDIF
C
      IMPSW3=IMPSW
      IMPCO2=IMPCO
      IMPNR2=IMPNR
      IMPNC2=IMPNC
      IMPSW='ON'
      IMPCO=1
      IMPCO9=IMPCO
C
C  DETERMINE NUMBER OF ROWS AND COLUMNS FOR PLOT.  BASED ON
C  BOTH THE NUMBER OF RESPONSE VARIABLES AND NUMBER OF DISTINCT
C  VALUES IN THE CONDITIONING VARIABLES.
C
      IF(ICPLRV.EQ.1)THEN
        IF(ICPLTV.EQ.1)THEN
          NPLOTS=NOUT
          IF(IMPNR*IMPNC.LT.NPLOTS)THEN
            IMPNC=INT(SQRT(REAL(NPLOTS-1)))+1
            IMPNR=1
            IF(NPLOTS.GE.11)THEN
              IMPNR=INT(NPLOTS/IMPNC)+1
            ELSEIF(NPLOTS.GE.7)THEN
              IMPNR=3
            ELSEIF(NPLOTS.GE.3)THEN
              IMPNR=2
            ENDIF
          ENDIF
          IFACTV=NPLOTS
        ELSE
          NPLOTS=NOUT*NOUT2
          IMPNR=NOUT
          IMPNC=NOUT2
          IFACTV=NPLOTS
        ENDIF
      ELSE
        IF(ICPLTV.EQ.1)THEN
          IMPNR=ICPLRV
          IMPNC=NOUT
          NPLOTS=IMPNR*IMPNC
          IFACTV=NOUT
        ELSE
          IMPNR=ICPLRV*NOUT
          IMPNC=NOUT2
          NPLOTS=IMPNR*IMPNC
          IFACTV=NOUT*NOUT2
        ENDIF
      ENDIF
C
      IROWT=ICPLRV
      ICOLT=IFACTV
      IF(ICPLLA.EQ.'BOX')THEN
        IMPNR=IMPNR+1
        IMPNC=IMPNC+1
        IROWT=ICPLRV+1
        ICOLT=IFACTV+1
      ENDIF
C
      IXAXIS=0
      IYAXIS=0
C
C  2-VARIABLE PLOTS
C
      IF(ICPLPT.EQ.'PLOT')THEN
        ICT='PLOT'
        IC2T='    '
        NCCOMM=0
        IPLOTT='PLOT'
        IFLGIN='NO'
        IF((IY1MIN.EQ.'FLOA'.AND.IY1MAX.EQ.'FLOA').OR.
     1     (IX1MIN.EQ.'FLOA'.AND.IX1MAX.EQ.'FLOA'))THEN
          IF((PCPYLL(1).EQ.CPUMIN.AND.PCPYUL(1).EQ.CPUMIN).OR.
     1       (PCPXLL(1).EQ.CPUMIN.AND.PCPYUL(1).EQ.CPUMIN))THEN
            IFLGIN='YES'
            IFLGY='ON'
            IFLGX='ON'
          ENDIF
        ENDIF
        GOTO6999
      ENDIF
      IF(ICPLPT.EQ.'STAT')THEN
        ICT=ICPLST
        IC2T=ICPLS2
        NCCOMM=0
        IF(ICPLS3.NE.'    ')THEN
          NCCOMM=NCCOMM+1
          IHT(NCCOMM)=ICPLS3
          IH2T(NCCOMM)=ICPLS4
        ENDIF
        NCCOMM=NCCOMM+1
        IHT(NCCOMM)='PLOT'
        IH2T(NCCOMM)='    '
        IPLOTT='STAT'
        IFLGIN='NO'
        GOTO6999
      ENDIF
      IF(ICPLPT.EQ.'BIHI')THEN
        ICT='RELA'
        IC2T='TIVE'
        IHT(1)='BIHI'
        IH2T(1)='STOG'
        NCCOMM=1
        IPLOTT='BIHI'
        IFLGIN='NO'
        IF(IY1MIN.EQ.'FLOA'.AND.IY1MAX.EQ.'FLOA')THEN
          IF(PCPYLL(1).EQ.CPUMIN.AND.PCPYUL(1).EQ.CPUMIN)THEN
            IRHSTG='PERC'
            GY1MIN=-0.6
            GY1MAX=0.6
            GY2MIN=-0.6
            GY2MAX=0.6
            IY1MIN='FIXE'
            IY1MAX='FIXE'
            IY2MIN='FIXE'
            IY2MAX='FIXE'
            IYAXIS=1
          ENDIF
        ENDIF
        GOTO6999
      ENDIF
C
      IF(ICPLPT.EQ.'BOXC')THEN
        ICT='BOX '
        IC2T='    '
        IHT(1)='COX '
        IH2T(1)='    '
        IHT(2)='LINE'
        IH2T(2)='ARIT'
        IHT(3)='PLOT'
        IH2T(3)='    '
        NCCOMM=3
        IPLOTT='CBXC'
        IFLGIN='NO'
        IF(IY1MIN.EQ.'FLOA'.AND.IY1MAX.EQ.'FLOA')THEN
          IF(PCPYLL(1).EQ.CPUMIN.AND.PCPYUL(1).EQ.CPUMIN)THEN
            GY1MIN=-1.0
            GY1MAX=1.0
            GY2MIN=-1.0
            GY2MAX=1.0
            IY1MIN='FIXE'
            IY1MAX='FIXE'
            IY2MIN='FIXE'
            IY2MAX='FIXE'
            IYAXIS=1
          ENDIF
        ENDIF
        GOTO6999
      ENDIF
      IF(ICPLPT.EQ.'QQPL')THEN
        ICT='QUAN'
        IC2T='TILE'
        IHT(1)='QUAN'
        IH2T(1)='TILE'
        IHT(2)='PLOT'
        IH2T(2)='    '
        NCCOMM=2
        IPLOTT='QQSP'
        IFLGIN='NO'
        IF((IY1MIN.EQ.'FLOA'.AND.IY1MAX.EQ.'FLOA').OR.
     1     (IX1MIN.EQ.'FLOA'.AND.IX1MAX.EQ.'FLOA'))THEN
          IF((PCPYLL(1).EQ.CPUMIN.AND.PCPYUL(1).EQ.CPUMIN).OR.
     1       (PCPXLL(1).EQ.CPUMIN.AND.PCPYUL(1).EQ.CPUMIN))THEN
            IFLGIN='YES'
            IFLGY='ON'
            IFLGX='ON'
          ENDIF
        ENDIF
        GOTO6999
      ENDIF
      IF(ICPLPT.EQ.'ROS2')THEN
        ICT='ROSE'
        IC2T='    '
        IHT(1)='PLOT'
        IH2T(1)='    '
        NCCOMM=1
        IPLOTT='ROSE'
        IFLGIN='NO'
        IFLGY='OFF'
        IFLGX='OFF'
        GOTO6999
      ENDIF
CCCCC IF(ICPLPT.EQ.'CROS')THEN
CCCCC   GOTO7999
CCCCC ENDIF
C
C 3-D PLOTS
C
      IF(ICPLPT.EQ.'YACU')THEN
        ICT='YATE'
        IC2T='S   '
        IHT(1)='CUBE'
        IH2T(1)='    '
        IHT(2)='PLOT'
        IH2T(2)='    '
        NCCOMM=2
        IPLOTT='YACU'
        IFLGIN='NO'
        GOTO7499
      ENDIF
      IF(ICPLPT.EQ.'3DPL')THEN
        ICT='3D  '
        IC2T='    '
        IHT(1)='PLOT'
        IH2T(1)='    '
        NCCOMM=1
        IPLOTT='3DPL'
        IFLGIN='NO'
        GOTO7499
      ENDIF
C
C
C  1-VARIABLE PLOTS
C
      IF(ICPLPT.EQ.'HIST')THEN
        ICT='RELA'
        IC2T='TIVE'
        IHT(1)='HIST'
        IH2T(1)='OGRA'
        NCCOMM=1
        IPLOTT='HIST'
        IFLGIN='NO'
        IF(IY1MIN.EQ.'FLOA'.AND.IY1MAX.EQ.'FLOA')THEN
          IF(PCPYLL(1).EQ.CPUMIN.AND.PCPYUL(1).EQ.CPUMIN)THEN
            IRHSTG='PERC'
            GY1MIN=0.0
            GY1MAX=0.6
            GY2MIN=0.0
            GY2MAX=0.6
            IY1MIN='FIXE'
            IY1MAX='FIXE'
            IY2MIN='FIXE'
            IY2MAX='FIXE'
            IYAXIS=1
          ENDIF
        ENDIF
        GOTO5999
      ENDIF
      IF(ICPLPT.EQ.'DENS')THEN
        ICT='KERN'
        IC2T='EL  '
        IHT(1)='DENS'
        IH2T(1)='ITY '
        IHT(2)='PLOT'
        IH2T(2)='    '
        NCCOMM=2
        IPLOTT='CDEN'
        IFLGIN='NO'
        IF(IY1MIN.EQ.'FLOA'.AND.IY1MAX.EQ.'FLOA')THEN
          IF(PCPYLL(1).EQ.CPUMIN.AND.PCPYUL(1).EQ.CPUMIN)THEN
            IRHSTG='PERC'
            GY1MIN=0.0
            GY1MAX=0.6
            GY2MIN=0.0
            GY2MAX=0.6
            IY1MIN='FIXE'
            IY1MAX='FIXE'
            IY2MIN='FIXE'
            IY2MAX='FIXE'
            IYAXIS=1
          ENDIF
        ENDIF
        GOTO5999
      ENDIF
      IF(ICPLPT.EQ.'RUNS')THEN
        ICT='RUN '
        IC2T='    '
        IHT(1)='SEQU'
        IH2T(1)='ENCE'
        IHT(2)='PLOT'
        IH2T(2)='    '
        NCCOMM=2
        IPLOTT='CRUN'
        IFLGIN='NO'
        IF(IY1MIN.EQ.'FLOA'.AND.IY1MAX.EQ.'FLOA')THEN
          IF(PCPYLL(1).EQ.CPUMIN.AND.PCPYUL(1).EQ.CPUMIN)THEN
            IFLGIN='YES'
            IFLGY='ON'
            IFLGX='OFF'
          ENDIF
        ENDIF
        GOTO5999
      ENDIF
      IF(ICPLPT.EQ.'PERC')THEN
        ICT='PERC'
        IC2T='ENT '
        IHT(1)='POIN'
        IH2T(1)='T   '
        IHT(2)='PLOT'
        IH2T(2)='    '
        NCCOMM=2
        IPLOTT='CPER'
        IFLGIN='NO'
        IF(IY1MIN.EQ.'FLOA'.AND.IY1MAX.EQ.'FLOA')THEN
          IF(PCPYLL(1).EQ.CPUMIN.AND.PCPYUL(1).EQ.CPUMIN)THEN
            IFLGIN='YES'
            IFLGY='ON'
            IFLGX='OFF'
          ENDIF
        ENDIF
        GOTO5999
      ENDIF
      IF(ICPLPT.EQ.'AUTO')THEN
        ICT='AUTO'
        IC2T='CORR'
        IHT(1)='PLOT'
        IH2T(1)='    '
        NCCOMM=1
        IPLOTT='CRUN'
        IFLGIN='NO'
        IF(IY1MIN.EQ.'FLOA'.AND.IY1MAX.EQ.'FLOA')THEN
          IF(PCPYLL(1).EQ.CPUMIN.AND.PCPYUL(1).EQ.CPUMIN)THEN
            GY1MIN=-1.0
            GY1MAX=1.0
            GY2MIN=-1.0
            GY2MAX=1.0
            IY1MIN='FIXE'
            IY1MAX='FIXE'
            IY2MIN='FIXE'
            IY2MAX='FIXE'
            IYAXIS=1
          ENDIF
        ENDIF
        GOTO5999
      ENDIF
      IF(ICPLPT.EQ.'SPEC')THEN
        ICT='SPEC'
        IC2T='TRAL'
        IHT(1)='PLOT'
        IH2T(1)='    '
        NCCOMM=1
        IPLOTT='SPEC'
        IFLGIN='NO'
        GOTO5999
      ENDIF
      IF(ICPLPT.EQ.'ROSE')THEN
        ICT='ROSE'
        IC2T='    '
        IHT(1)='PLOT'
        IH2T(1)='    '
        NCCOMM=1
        IPLOTT='ROSE'
        IFLGIN='NO'
        GOTO5999
      ENDIF
      IF(ICPLPT.EQ.'LAG ')THEN
        ICT='LAG '
        IC2T='    '
        IHT(1)='PLOT'
        IH2T(1)='    '
        NCCOMM=1
        IPLOTT='LAG '
        IFLGIN='NO'
        IF((IY1MIN.EQ.'FLOA'.AND.IY1MAX.EQ.'FLOA').OR.
     1     (IX1MIN.EQ.'FLOA'.AND.IX1MAX.EQ.'FLOA'))THEN
          IF((PCPYLL(1).EQ.CPUMIN.AND.PCPYUL(1).EQ.CPUMIN).OR.
     1       (PCPXLL(1).EQ.CPUMIN.AND.PCPYUL(1).EQ.CPUMIN))THEN
            IFLGIN='YES'
            IFLGY='ON'
            IFLGX='ON'
          ENDIF
        ENDIF
        GOTO5999
      ENDIF
      IF(ICPLPT.EQ.'PROB')THEN
        ICT=ICPLP1
        IC2T='    '
        NCCOMM=0
        IF(ICPLP2.NE.'    ')THEN
          NCCOMM=NCCOMM+1
          IHT(NCCOMM)=ICPLP2
          IH2T(NCCOMM)='    '
        ENDIF
        IF(ICPLP3.NE.'    ')THEN
          NCCOMM=NCCOMM+1
          IHT(NCCOMM)=ICPLP3
          IH2T(NCCOMM)='    '
        ENDIF
        IF(ICPLP4.NE.'    ')THEN
          NCCOMM=NCCOMM+1
          IHT(NCCOMM)=ICPLP4
          IH2T(NCCOMM)='    '
        ENDIF
        IF(ICPLP5.NE.'    ')THEN
          NCCOMM=NCCOMM+1
          IHT(NCCOMM)=ICPLP5
          IH2T(NCCOMM)='    '
        ENDIF
        NCCOMM=NCCOMM+1
        IHT(NCCOMM)='PROB'
        IH2T(NCCOMM)='ABIL'
        NCCOMM=NCCOMM+1
        IHT(NCCOMM)='PLOT'
        IH2T(NCCOMM)='    '
        IPLOTT='PROB'
        IFLGIN='NO'
        IF((IY1MIN.EQ.'FLOA'.AND.IY1MAX.EQ.'FLOA').OR.
     1     (IX1MIN.EQ.'FLOA'.AND.IX1MAX.EQ.'FLOA'))THEN
          IF((PCPYLL(1).EQ.CPUMIN.AND.PCPYUL(1).EQ.CPUMIN).OR.
     1       (PCPXLL(1).EQ.CPUMIN.AND.PCPYUL(1).EQ.CPUMIN))THEN
            IFLGIN='YES'
            IFLGY='ON'
            IFLGX='ON'
          ENDIF
        ENDIF
        GOTO5999
      ENDIF
      IF(ICPLPT.EQ.'PPCC')THEN
        ICT=ICPLC1
        IC2T='    '
        NCCOMM=0
        IF(ICPLC2.NE.'    ')THEN
          NCCOMM=NCCOMM+1
          IHT(NCCOMM)=ICPLC2
          IH2T(NCCOMM)='    '
        ENDIF
        IF(ICPLC3.NE.'    ')THEN
          NCCOMM=NCCOMM+1
          IHT(NCCOMM)=ICPLC3
          IH2T(NCCOMM)='    '
        ENDIF
        IF(ICPLC4.NE.'    ')THEN
          NCCOMM=NCCOMM+1
          IHT(NCCOMM)=ICPLC4
          IH2T(NCCOMM)='    '
        ENDIF
        IF(ICPLC5.NE.'    ')THEN
          NCCOMM=NCCOMM+1
          IHT(NCCOMM)=ICPLC5
          IH2T(NCCOMM)='    '
        ENDIF
        NCCOMM=NCCOMM+1
        IHT(NCCOMM)='PPCC'
        IH2T(NCCOMM)='    '
        NCCOMM=NCCOMM+1
        IHT(NCCOMM)='PLOT'
        IH2T(NCCOMM)='    '
        IPLOTT='PPCC'
        IFLGIN='NO'
        GOTO5999
      ENDIF
      GOTO8000
C
C               *******************************************
C               **   STEP 21--                           **
C               **   GENERATE THE RUN SEQUENCE    PLOTS  **
C               **   GENERATE THE HISTOGRAM       PLOTS  **
C               **   GENERATE THE PERCENTILE      PLOTS  **
C               **   GENERATE THE AUTOCORRELATION PLOTS  **
C               **   GENERATE THE SPECTRAL        PLOTS  **
C               **   GENERATE THE LAG             PLOTS  **
C               **   GENERATE THE PROBABILITY     PLOTS  **
C               **   GENERATE THE PPCC            PLOTS  **
C               **   GENERATE THE KERNEL DENSITY  PLOTS  **
C               *******************************************
C
 5999 CONTINUE
C
C  IF NO PRIOR LIMITS SET FOR Y AXIS, USE 0 TO 0.6 (THIS MAY NOT
C  BE OPTIMAL, BUT IT WILL ALWAYS SHOW ALL THE DATA).
C
      IF(NPLOTS.LT.1)GOTO8000
C
      ISHIFT=ILOCQ-1
      CALL SHIFTL(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1IBUGG2,IERROR)
      IF(IERROR.EQ.'YES')GOTO8000
C
C  CREATE BASIC COMMAND LINE, FOR EXAMPLE:
C    RELATIVE HISTOGRAM Y SUBSET COND1 = <VAL> SUBSET COND2 = <VAL>
C  WHERE COND2 IS OPTIONAL
C
C  FOR SOME PLOT TYPES, NEED TO DO AN INITIAL PLOT TO SET PLOT LIMITS
C
      ISHIFT=NCCOMM+1
      IF(ICPLTV.GE.1)ISHIFT=ISHIFT+4
      IF(ICPLTV.GE.2)ISHIFT=ISHIFT+4
      CALL SHIFTR(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1            IBUGG2,IERROR)
      ICOM=ICT
      ICOM2=IC2T
      DO6006II=1,NCCOMM
        IHARG(II)=IHT(II)
        IHARG2(II)=IH2T(II)
        IARGT(II)='WORD'
 6006 CONTINUE
      NWORD=NCCOMM+1
      NPOS=NWORD
      IHARG(NWORD)=IVARN1(1)
      IHARG2(NWORD)=IVARN2(1)
      IARGT(NWORD)='WORD'
C
      NWORD=NWORD+1
      IHARG(NWORD)='SUBS'
      IHARG2(NWORD)='ET  '
      IARGT(NWORD)='WORD'
C
      NWORD=NWORD+1
      IHARG(NWORD)=IVARN1(ICC1)
      IHARG2(NWORD)=IVARN2(ICC1)
      IARGT(NWORD)='WORD'
C
      NWORD=NWORD+1
      IHARG(NWORD)='=   '
      IHARG2(NWORD)='    '
      IARGT(NWORD)='WORD'
C
      NWORD=NWORD+1
      IHARG(NWORD)='0  '
      IHARG2(NWORD)='    '
      IARGT(NWORD)='NUMB'
      NPOS1=NWORD
C
      IF(ICPLTV.EQ.2)THEN
        NWORD=NWORD+1
        IHARG(NWORD)='SUBS'
        IHARG2(NWORD)='ET  '
        IARGT(NWORD)='WORD'
C
        NWORD=NWORD+1
        IHARG(NWORD)=IVARN1(ICC2)
        IHARG2(NWORD)=IVARN2(ICC2)
        IARGT(NWORD)='WORD'
C
        NWORD=NWORD+1
        IHARG(NWORD)='=   '
        IHARG2(NWORD)='    '
        IARGT(NWORD)='WORD'
C
        NWORD=NWORD+1
        IHARG(NWORD)='0  '
        IHARG2(NWORD)='    '
        IARGT(NWORD)='NUMB'
        NPOS2=NWORD
      ENDIF
      NARGT=NUMARG
C
      DO6020I=1,NARGT
        IHT(I)=IHARG(I)
        IH2T(I)=IHARG2(I)
        IARGTT(I)=IARGT(I)
        ARGT(I)=ARG(I)
 6020 CONTINUE
C
      IPLOT=0
      DO6200IRES=1,IROWT
C
C  CREATE INITIAL PLOT TO DETERMINE SCALE
C
      IF(IFLGIN.EQ.'YES')THEN
        ISHIFT=NWORD
        CALL SHIFTL(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1              IBUGG2,IERROR)
        ISHIFT=NCCOMM+1
        CALL SHIFTR(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1              IBUGG2,IERROR)
        ICOM=ICT
        ICOM2=IC2T
        DO6210II=1,NCCOMM
          IHARG(II)=IHT(II)
          IHARG2(II)=IH2T(II)
          IARGT(II)='WORD'
 6210   CONTINUE
        NTEMP=NCCOMM+1
        IHARG(NTEMP)=IVARN1(IRES)
        IHARG2(NTEMP)=IVARN2(IRES)
        IARGT(NTEMP)='WORD'
C
C  GENERATE THE DUMMY PLOT
C
        ICHAPA(1)='BLAN'
        ILINPA(1)='BLAN'
        IBARSW(1)='OFF'
        ISPISW(1)='OFF'
C
        GY1MIN=CPUMIN
        GY1MAX=CPUMAX
        GY2MIN=CPUMIN
        GY2MAX=CPUMAX
        GX1MIN=CPUMIN
        GX1MAX=CPUMAX
        GX2MIN=CPUMIN
        GX2MAX=CPUMAX
        IY1MIN='FLOA'
        IY1MAX='FLOA'
        IY2MIN='FLOA'
        IY2MAX='FLOA'
        IX1MIN='FLOA'
        IX1MAX='FLOA'
        IX2MIN='FLOA'
        IX2MAX='FLOA'
        CALL MAINGR(ANOPL1,ANOPL2,NPLOTV,NPLOTP,NS,ICASPL,
     1              MAXNPP,ISEED,IBOOSS,
     1              IX1TSV,IX2TSV,IY1TSV,IY2TSV,
     1              IX1ZSV,IX2ZSV,IY1ZSV,IY2ZSV,
     1              BARHEF,BARWEF,
     1              IRHSTG,IHSTCW,IHSTEB,IHSTOU,IASHWT,
     1              ICAPSW,IFORSW,
     1              IGUIFL,IERRFA,
     1              IAND1,IAND2,ICONT,NUMHPP,NUMVPP,
CCCCC1              TEMP,TEMP2,TEMP3,XTEMP1,XTEMP2,MAXNXT,
     1              MAXNXT,
     1              ISUBRO,IFOUND,IERROR)
C
        IX1TSW='OFF'
        IX1ZSW='OFF'
        IX2TSW='OFF'
        IX2ZSW='OFF'
        IY1TSW='OFF'
        IY1ZSW='OFF'
        IY2TSW='OFF'
        IY2ZSW='OFF'
        IX1FSW='OFF'
        IX2FSW='OFF'
        IY1FSW='OFF'
        IY2FSW='OFF'
        IERASW='ON'
        DO6250I=1,MAXCH
          IX1LTE(I)='    '
          IX2LTE(I)='    '
          IY1LTE(I)='    '
          IY2LTE(I)='    '
 6250   CONTINUE
        NCX1LA=0
        NCX2LA=0
        NCY1LA=0
        NCY2LA=0
        NCTITL=0
        ICONT=IDCONT(1)
        NUMHPP=IDNHPP(1)
        IMPARG=2
        CALL DPGRAP(Y,X,X3D,D,N,NPLOTP,ICASPL,ICONT,NUMHPP,
     1              XMATN,YMATN,XMITN,YMITN,
     1              ISQUAR,
     1              IVGMSW,IHGMSW,
     1              IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,
     1              IVSTAR,IVSTOP,IFUNC,NUMCHF,IREPCH,
     1              YPLOT,XPLOT,X2PLOT,TAGPLO,
     1              IMPSW,IMPNR,IMPNC,IMPCO,IMPCO9,
     1              IMPARG,
     1              PMXMIN,PMXMAX,PMYMIN,PMYMAX,
     1              MAXCOL,
     1              DSIZE,DSYMB,DCOLOR,DFILL,
     1              ICAPSW,
     1              IBUGUG,IBUGU2,IBUGU3,IBUGU4,ISUBRO,
     1              IERROR)
        IF(IERROR.EQ.'NO')IAND1=IAND2
        IMPCO=IMPCO-1
        IF(IFLGY.EQ.'ON')THEN
          GY1MIN=FY1MNZ
          GY1MAX=FY1MXZ
          GY2MIN=FY2MNZ
          GY2MAX=FY2MXZ
          IY1MIN='FIXE'
          IY1MAX='FIXE'
          IY2MIN='FIXE'
          IY2MAX='FIXE'
        ELSE
          GY1MIN=GY1MNS
          GY1MAX=GY1MXS
          GY2MIN=GY2MNS
          GY2MAX=GY2MXS
          IY1MIN=IY1MNS
          IY1MAX=IY1MXS
          IY2MIN=IY2MNS
          IY2MAX=IY2MXS
        ENDIF
        IF(IFLGX.EQ.'ON')THEN
          GX1MIN=FX1MNZ
          GX1MAX=FX1MXZ
          GX2MIN=FX2MNZ
          GX2MAX=FX2MXZ
          IX1MIN='FIXE'
          IX1MAX='FIXE'
          IX2MIN='FIXE'
          IX2MAX='FIXE'
        ELSE
          GX1MIN=GX1MNS
          GX1MAX=GX1MXS
          GX2MIN=GX2MNS
          GX2MAX=GX2MXS
          IX1MIN=IX1MNS
          IX1MAX=IX1MXS
          IX2MIN=IX2MNS
          IX2MAX=IX2MXS
        ENDIF
C
        IX1TSW=IX1TSV
        IX1ZSW=IX1ZSV
        IX2TSW=IX2TSV
        IX2ZSW=IX2ZSV
        IY1TSW=IY1TSV
        IY1ZSW=IY1ZSV
        IY2TSW=IY2TSV
        IY2ZSW=IY2ZSV
        IX1FSW=IX1FSV
        IX2FSW=IX2FSV
        IY1FSW=IY1FSV
        IY2FSW=IY2FSV
        IERASW='OFF'
C
C  RESTORE COMMAND LINE
C
        ISHIFT=NARGT-NUMARG
        IF(ISHIFT.GT.0)THEN
          CALL SHIFTR(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1                IBUGG2,IERROR)
        ELSEIF(ISHIFT.LT.0)THEN
          ISHIFT=-ISHIFT
          CALL SHIFTL(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1                IBUGG2,IERROR)
        ENDIF
        DO6220II=1,NARGT
          IHARG(II)=IHT(II)
          IHARG2(II)=IH2T(II)
          IARGT(II)=IARGTT(II)
          ARG(II)=ARGT(II)
 6220   CONTINUE
      ENDIF
C
      DO6100IFAC=1,ICOLT
C
        IPLOT=IPLOT+1
        IX=IXC1
        IXLIST=1
        IROW=INT(IPLOT/IMPNC)+1
        IF(MOD(IPLOT,IMPNC).EQ.0)IROW=IROW-1
        ICOL=MOD(IPLOT,IMPNC)
        IF(ICOL.EQ.0)ICOL=IMPNC
C
        IHARG(NPOS)=IVARN1(IRES)
        IHARG2(NPOS)=IVARN2(IRES)
C
        IEMPTY='NO'
        IF(ICPLLA.EQ.'BOX')THEN
          ICOL=ICOL-1
          IF(ICOL.EQ.0)IEMPTY='YES'
          IF(IROW.EQ.IMPNR)IEMPTY='YES'
        ENDIF
C
        IF(ICPLRV.EQ.1)THEN
          IF(ICPLTV.EQ.1)THEN
            ARG(NPOS1)=ADIST1(IFAC)
          ELSE
            ARG(NPOS1)=ADIST1(IROW)
            ARG(NPOS2)=ADIST2(ICOL)
          ENDIF
        ELSE
          IF(ICPLTV.EQ.1)THEN
            ARG(NPOS1)=ADIST1(IFAC)
          ELSE
            ARG(NPOS1)=ADIST1(MOD(IROW-1,ICPLRV)+1)
            ARG(NPOS2)=ADIST2(ICOL)
          ENDIF
        ENDIF
C
        IF(IEMPTY.EQ.'YES')THEN
          DO6104I=1,MAXSUB
            ISU2SW(I)=ISUBSW(I)
            ISUBSW(I)='OFF'
 6104     CONTINUE
        ENDIF
        ICASPL='COND'
        IOPTN=3
        IDY=IRES
        IDX=1
        CALL DPSPM4(ICASPL,IOPTN,IDX,IDY,
     1              ISUBNU,ISUBSW,
     1              ASUBXL,ASUBXU,ASUBYL,ASUBYU,
     1              ISUBN9,ISUBSZ,
     1              ASBXL2,ASBXU2,ASBYL2,ASBYU2,
     1              PCPXSL,PCPXSU,PCPYSL,PCPYSU,
     1              IBUGG2,ISUBRO,IERROR)
C
        CALL DPSPM1(ICASPL,IVARN1,IVARN2,ICOLL,
     1              IMPNR,IMPNC,IROW,ICOL,IRES,IX,IPLOT,
     1              NPLOTS,NUMVAR,
     1              ICHAP2,ILINP2,
     1              GY1MNS,GY1MXS,GY2MNS,GY2MXS,
     1              GX1MNS,GX1MXS,GX2MNS,GX2MXS,
     1              IY1MNS,IY1MXS,IY2MNS,IY2MXS,
     1              IX1MNS,IX1MXS,IX2MNS,IX2MXS,
     1              IX1TSV,IX2TSV,IY1TSV,IY2TSV,
     1              IX1ZSV,IX2ZSV,IY1ZSV,IY2ZSV,
     1              PX1LD2,PX2LD2,
     1              IY1LJ2,IY1LD2,PY1LD2,PY1LA2,
     1              IX1LT2,IX2LT2,IY1LT2,IY2LT2,
     1              NCX1L2,NCX2L2,NCY1L2,NCY2L2,
     1              PCPXLL,PCPXUL,PCPYLL,PCPYUL,IXLIST,
     1              ICPLLA,ISPMLD,IPLOTT,ICPLFR,ICPLXA,ICPLYA,
     1              ISPMDI,
     1              ICPLTD,PCPLTD,IVNMEX,
     1              IBUGG2,ISUBRO)
C
CCCCC   ITITTE(1)='S'
CCCCC   ITITTE(2)='U'
CCCCC   ITITTE(3)='B'
CCCCC   ITITTE(4)='S'
CCCCC   ITITTE(5)='E'
CCCCC   ITITTE(6)='T'
CCCCC   ITITTE(7)=' '
CCCCC   NCTEMP=7
        NCTEMP=0
        DO6161I=1,4
          IF(IVARN1(ICC1)(I:I).NE.' ')THEN
            NCTEMP=NCTEMP+1
            ITITTE(NCTEMP)=IVARN1(ICC1)(I:I)
          ENDIF
 6161   CONTINUE
        DO6163I=1,4
          IF(IVARN2(ICC1)(I:I).NE.' ')THEN
            NCTEMP=NCTEMP+1
            ITITTE(NCTEMP)=IVARN2(ICC1)(I:I)
          ENDIF
 6163   CONTINUE
        NCTEMP=NCTEMP+1
        ITITTE(NCTEMP)=' '
        NCTEMP=NCTEMP+1
        ITITTE(NCTEMP)='='
        NCTEMP=NCTEMP+1
        ITITTE(NCTEMP)=' '
        NCTEMP=NCTEMP+1
        VAL=ARG(NPOS1)
        IVAL=INT(VAL+0.5)
        IF(VAL.LT.0.0)IVAL=INT(VAL-0.5)
        CALL DPCONH(IVAL,VAL,ITITTE(NCTEMP),NH,IBUGG2,IERROR)
        NCTEMP=NCTEMP+NH-1
        IF(ICPLTV.EQ.1)GOTO6189
        DO6169I=1,15
          NCTEMP=NCTEMP+1
          ITITTE(NCTEMP)=' '
 6169   CONTINUE
        DO6171I=1,4
          IF(IVARN1(ICC2)(I:I).NE.' ')THEN
            NCTEMP=NCTEMP+1
            ITITTE(NCTEMP)=IVARN1(ICC2)(I:I)
          ENDIF
 6171   CONTINUE
        DO6173I=1,4
          IF(IVARN2(ICC2)(I:I).NE.' ')THEN
            NCTEMP=NCTEMP+1
            ITITTE(NCTEMP)=IVARN2(ICC2)(I:I)
          ENDIF
 6173   CONTINUE
        NCTEMP=NCTEMP+1
        ITITTE(NCTEMP)=' '
        NCTEMP=NCTEMP+1
        ITITTE(NCTEMP)='='
        NCTEMP=NCTEMP+1
        ITITTE(NCTEMP)=' '
        NCTEMP=NCTEMP+1
        VAL=ARG(NPOS2)
        IVAL=INT(VAL+0.5)
        IF(VAL.LT.0.0)IVAL=INT(VAL-0.5)
        CALL DPCONH(IVAL,VAL,ITITTE(NCTEMP),NH,IBUGG2,IERROR)
        NCTEMP=NCTEMP+NH-1
 6189   CONTINUE
        NCTITL=NCTEMP
        IF(ICPLFR.EQ.'DEFA')THEN
          PTITDS=-ABS(PTITDZ)
        ENDIF
C
        CALL MAINGR(ANOPL1,ANOPL2,NPLOTV,NPLOTP,NS,ICASPL,
     1              MAXNPP,ISEED,IBOOSS,
     1              IX1TSV,IX2TSV,IY1TSV,IY2TSV,
     1              IX1ZSV,IX2ZSV,IY1ZSV,IY2ZSV,
     1              BARHEF,BARWEF,
     1              IRHSTG,IHSTCW,IHSTEB,IHSTOU,IASHWT,
     1              ICAPSW,IFORSW,
     1              IGUIFL,IERRFA,
     1              IAND1,IAND2,ICONT,NUMHPP,NUMVPP,
CCCCC1              TEMP,TEMP2,TEMP3,XTEMP1,XTEMP2,MAXNXT,
     1              MAXNXT,
     1              ISUBRO,IFOUND,IERROR)
        IF(IEMPTY.EQ.'NO')THEN
          CALL DPSPM3(ICASPL,IOUNI5,
     1                IROW,ICOL,
     1                PX2LD2,NPLOTP,
     1                IFORSW,
     1                IFPX2L,ISPX2P,ISPX2S,
     1                IHRIGH,IHRIG2,IHWUSE,
     1                ISUBN1,ISUBN2,MESSAG,
     1                IBUGG2,ISUBRO,IERROR)
        ENDIF
C
        ICONT=IDCONT(1)
        NUMHPP=IDNHPP(1)
        IMPARG=2
        CALL DPGRAP(Y,X,X3D,D,N,NPLOTP,ICASPL,ICONT,NUMHPP,
     1              XMATN,YMATN,XMITN,YMITN,
     1              ISQUAR,
     1              IVGMSW,IHGMSW,
     1              IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,
     1              IVSTAR,IVSTOP,IFUNC,NUMCHF,IREPCH,
     1              YPLOT,XPLOT,X2PLOT,TAGPLO,
     1              IMPSW,IMPNR,IMPNC,IMPCO,IMPCO9,
     1              IMPARG,
     1              PMXMIN,PMXMAX,PMYMIN,PMYMAX,
     1              MAXCOL,
     1              DSIZE,DSYMB,DCOLOR,DFILL,
     1              ICAPSW,
     1              IBUGUG,IBUGU2,IBUGU3,IBUGU4,ISUBRO,
     1              IERROR)
        IF(IERROR.EQ.'NO')IAND1=IAND2
        IF(IERROR.EQ.'YES')GOTO6199
C
        IF(ICPLPT.NE.'PLOT')GOTO6199
        IF(ICPLFI.EQ.'NONE')GOTO6199
        IF(IEMPTY.EQ.'YES')GOTO6199
C
        IMPCO=IMPCO-1
        IF(IMPCO.LE.1)IERASW='OFF'
C
C  NOTE: NO FITTING DONE SINCE ONLY ONE VARIABLE PLOTTED
C        HERE.
C
 6199   CONTINUE
        ISHIFT=NARGT-NUMARG
        IF(ISHIFT.GT.0)THEN
          CALL SHIFTR(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1                IBUGG2,IERROR)
        ELSEIF(ISHIFT.LT.0)THEN
          ISHIFT=-ISHIFT
          CALL SHIFTL(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1                IBUGG2,IERROR)
        ENDIF
        ICOM=ICT
        ICOM2=IC2T
        DO6101II=1,NARGT
          IHARG(II)=IHT(II)
          IHARG2(II)=IH2T(II)
          IARGT(II)=IARGTT(II)
          ARG(II)=ARGT(II)
 6101   CONTINUE
C
        PX1LDS=PX1LD2
        IF(IYAXIS.EQ.0.AND.IFLGIN.EQ.'NO')THEN
          GY1MIN=GY1MNS
          GY1MAX=GY1MXS
          GY2MIN=GY2MNS
          GY2MAX=GY2MXS
          IY1MIN=IY1MNS
          IY1MAX=IY1MXS
          IY2MIN=IY2MNS
          IY2MAX=IY2MXS
        ENDIF
        IF(IXAXIS.EQ.0.AND.IFLGIN.EQ.'NO')THEN
          GX1MIN=GX1MNS
          GX1MAX=GX1MXS
          GX2MIN=GX2MNS
          GX2MAX=GX2MXS
          IX1MIN=IX1MNS
          IX1MAX=IX1MXS
          IX2MIN=IX2MNS
          IX2MAX=IX2MXS
        ENDIF
        PX1ZDS=PX1ZD2
        PX2ZDS=PX2ZD2
        PY1ZDS=PY1ZD2
        PY2ZDS=PY2ZD2
        IF(IEMPTY.EQ.'YES')THEN
          DO6107I=1,MAXSUB
            ISUBSW(I)=ISU2SW(I)
 6107     CONTINUE
        ENDIF
        DO6108I=1,100
            ICHAPA(I)=ICHAP2(I)
            ILINPA(I)=ILINP2(I)
            ISPISW(I)=ISPIS2(I)
            IBARSW(I)=IBARS2(I)
 6108     CONTINUE
C
 6100 CONTINUE
 6200 CONTINUE
      IF(IYAXIS.EQ.1)THEN
        GY1MIN=GY1MNS
        GY1MAX=GY1MXS
        GY2MIN=GY2MNS
        GY2MAX=GY2MXS
        IY1MIN=IY1MNS
        IY1MAX=IY1MXS
        IY2MIN=IY2MNS
        IY2MAX=IY2MXS
      ENDIF
      IF(IXAXIS.EQ.1)THEN
        GX1MIN=GX1MNS
        GX1MAX=GX1MXS
        GX2MIN=GX2MNS
        GX2MAX=GX2MXS
        IX1MIN=IX1MNS
        IX1MAX=IX1MXS
        IX2MIN=IX2MNS
        IX2MAX=IX2MXS
      ENDIF
      GOTO8000
C
C               **********************************************
C               **   STEP 21--                              **
C               **   GENERATE THE PLOT               PLOTS  **
C               **   GENERATE THE BIHISTOGRAM        PLOTS  **
C               **   GENERATE THE QUANTILE-QUANTILE  PLOTS  **
C               **   GENERATE THE BOX-COX LINEARITY  PLOTS  **
C               **   GENERATE THE STATISTIC       PLOTS     **
C               **   GENERATE THE CROSS-TABULATE  PLOTS     **
C               **   GENERATE THE ROSE            PLOTS     **
C               **********************************************
C
 6999 CONTINUE
C
C  IF NO PRIOR LIMITS SET FOR Y AXIS, USE 0 TO 0.6 (THIS MAY NOT
C  BE OPTIMAL, BUT IT WILL ALWAYS SHOW ALL THE DATA).
C
      IF(NPLOTS.LT.1)GOTO8000
C
      ISHIFT=ILOCQ-1
      CALL SHIFTL(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1IBUGG2,IERROR)
      IF(IERROR.EQ.'YES')GOTO8000
C
C  CREATE BASIC COMMAND LINE, FOR EXAMPLE:
C    RELATIVE BIHISTOGRAM Y1 Y2 SUBSET COND1 = <VAL> SUBSET COND2 = <VAL>
C  WHERE COND2 IS OPTIONAL
C
C  FOR SOME PLOT TYPES, NEED TO DO AN INITIAL PLOT TO SET PLOT LIMITS
C
      ISHIFT=NCCOMM+2
      IF(ICPLTV.GE.1)ISHIFT=ISHIFT+4
      IF(ICPLTV.GE.2)ISHIFT=ISHIFT+4
      CALL SHIFTR(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1            IBUGG2,IERROR)
      ICOM=ICT
      ICOM2=IC2T
      DO7006II=1,NCCOMM
        IHARG(II)=IHT(II)
        IHARG2(II)=IH2T(II)
        IARGT(II)='WORD'
 7006 CONTINUE
      NWORD=NCCOMM+1
      NPOSA=NWORD
      IHARG(NWORD)=IVARN1(1)
      IHARG2(NWORD)=IVARN2(1)
      IARGT(NWORD)='WORD'
      NWORD=NCCOMM+2
      NPOSB=NWORD
      IHARG(NWORD)=IVARN1(IXC1)
      IHARG2(NWORD)=IVARN2(IXC1)
      IARGT(NWORD)='WORD'
C
      NWORD=NWORD+1
      IHARG(NWORD)='SUBS'
      IHARG2(NWORD)='ET  '
      IARGT(NWORD)='WORD'
C
      NWORD=NWORD+1
      IHARG(NWORD)=IVARN1(ICC1)
      IHARG2(NWORD)=IVARN2(ICC1)
      IARGT(NWORD)='WORD'
C
      NWORD=NWORD+1
      IHARG(NWORD)='=   '
      IHARG2(NWORD)='    '
      IARGT(NWORD)='WORD'
C
      NWORD=NWORD+1
      IHARG(NWORD)='0  '
      IHARG2(NWORD)='    '
      IARGT(NWORD)='NUMB'
      NPOS1=NWORD
C
      IF(ICPLTV.EQ.2)THEN
        NWORD=NWORD+1
        IHARG(NWORD)='SUBS'
        IHARG2(NWORD)='ET  '
        IARGT(NWORD)='WORD'
C
        NWORD=NWORD+1
        IHARG(NWORD)=IVARN1(ICC2)
        IHARG2(NWORD)=IVARN2(ICC2)
        IARGT(NWORD)='WORD'
C
        NWORD=NWORD+1
        IHARG(NWORD)='=   '
        IHARG2(NWORD)='    '
        IARGT(NWORD)='WORD'
C
        NWORD=NWORD+1
        IHARG(NWORD)='0  '
        IHARG2(NWORD)='    '
        IARGT(NWORD)='NUMB'
        NPOS2=NWORD
      ENDIF
      NARGT=NUMARG
C
      DO7020I=1,NARGT
        IHT(I)=IHARG(I)
        IH2T(I)=IHARG2(I)
        IARGTT(I)=IARGT(I)
        ARGT(I)=ARG(I)
 7020 CONTINUE
C
      IPLOT=0
      DO7200IRES=1,IROWT
C
C  CREATE INITIAL PLOT TO DETERMINE SCALE
C
      IF(IFLGIN.EQ.'YES')THEN
        ISHIFT=NWORD
        CALL SHIFTL(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1              IBUGG2,IERROR)
        ISHIFT=NCCOMM+2
        CALL SHIFTR(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1              IBUGG2,IERROR)
        ICOM=ICT
        ICOM2=IC2T
        DO7210II=1,NCCOMM+2
          IHARG(II)=IHT(II)
          IHARG2(II)=IH2T(II)
          IARGT(II)='WORD'
 7210   CONTINUE
        NTEMP=NCCOMM+1
        IHARG(NTEMP)=IVARN1(IRES)
        IHARG2(NTEMP)=IVARN2(IRES)
        IARGT(NTEMP)='WORD'
C
C  GENERATE THE DUMMY PLOT
C
        ICHAPA(1)='BLAN'
        ILINPA(1)='BLAN'
        IBARSW(1)='OFF'
        ISPISW(1)='OFF'
        GY1MIN=CPUMIN
        GY1MAX=CPUMAX
        GY2MIN=CPUMIN
        GY2MAX=CPUMAX
        GX1MIN=CPUMIN
        GX1MAX=CPUMAX
        GX2MIN=CPUMIN
        GX2MAX=CPUMAX
        IY1MIN='FLOA'
        IY1MAX='FLOA'
        IY2MIN='FLOA'
        IY2MAX='FLOA'
        IX1MIN='FLOA'
        IX1MAX='FLOA'
        IX2MIN='FLOA'
        IX2MAX='FLOA'
        CALL MAINGR(ANOPL1,ANOPL2,NPLOTV,NPLOTP,NS,ICASPL,
     1              MAXNPP,ISEED,IBOOSS,
     1              IX1TSV,IX2TSV,IY1TSV,IY2TSV,
     1              IX1ZSV,IX2ZSV,IY1ZSV,IY2ZSV,
     1              BARHEF,BARWEF,
     1              IRHSTG,IHSTCW,IHSTEB,IHSTOU,IASHWT,
     1              ICAPSW,IFORSW,
     1              IGUIFL,IERRFA,
     1              IAND1,IAND2,ICONT,NUMHPP,NUMVPP,
CCCCC1              TEMP,TEMP2,TEMP3,XTEMP1,XTEMP2,MAXNXT,
     1              MAXNXT,
     1              ISUBRO,IFOUND,IERROR)
C
        IX1TSW='OFF'
        IX1ZSW='OFF'
        IX2TSW='OFF'
        IX2ZSW='OFF'
        IY1TSW='OFF'
        IY1ZSW='OFF'
        IY2TSW='OFF'
        IY2ZSW='OFF'
        IX1FSW='OFF'
        IX2FSW='OFF'
        IY1FSW='OFF'
        IY2FSW='OFF'
        IERASW='ON'
        DO7250I=1,MAXCH
          IX1LTE(I)='    '
          IX2LTE(I)='    '
          IY1LTE(I)='    '
          IY2LTE(I)='    '
 7250   CONTINUE
        NCX1LA=0
        NCX2LA=0
        NCY1LA=0
        NCY2LA=0
        NCTITL=0
        ICONT=IDCONT(1)
        NUMHPP=IDNHPP(1)
        IMPARG=2
        CALL DPGRAP(Y,X,X3D,D,N,NPLOTP,ICASPL,ICONT,NUMHPP,
     1              XMATN,YMATN,XMITN,YMITN,
     1              ISQUAR,
     1              IVGMSW,IHGMSW,
     1              IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,
     1              IVSTAR,IVSTOP,IFUNC,NUMCHF,IREPCH,
     1              YPLOT,XPLOT,X2PLOT,TAGPLO,
     1              IMPSW,IMPNR,IMPNC,IMPCO,IMPCO9,
     1              IMPARG,
     1              PMXMIN,PMXMAX,PMYMIN,PMYMAX,
     1              MAXCOL,
     1              DSIZE,DSYMB,DCOLOR,DFILL,
     1              ICAPSW,
     1              IBUGUG,IBUGU2,IBUGU3,IBUGU4,ISUBRO,
     1              IERROR)
        IF(IERROR.EQ.'NO')IAND1=IAND2
        IMPCO=IMPCO-1
        IF(IFLGY.EQ.'ON')THEN
          GY1MIN=FY1MNZ
          GY1MAX=FY1MXZ
          GY2MIN=FY2MNZ
          GY2MAX=FY2MXZ
          IY1MIN='FIXE'
          IY1MAX='FIXE'
          IY2MIN='FIXE'
          IY2MAX='FIXE'
        ELSE
          GY1MIN=GY1MNS
          GY1MAX=GY1MXS
          GY2MIN=GY2MNS
          GY2MAX=GY2MXS
          IY1MIN=IY1MNS
          IY1MAX=IY1MXS
          IY2MIN=IY2MNS
          IY2MAX=IY2MXS
        ENDIF
        IF(IFLGX.EQ.'ON')THEN
          GX1MIN=FX1MNZ
          GX1MAX=FX1MXZ
          GX2MIN=FX2MNZ
          GX2MAX=FX2MXZ
          IX1MIN='FIXE'
          IX1MAX='FIXE'
          IX2MIN='FIXE'
          IX2MAX='FIXE'
        ELSE
          GX1MIN=GX1MNS
          GX1MAX=GX1MXS
          GX2MIN=GX2MNS
          GX2MAX=GX2MXS
          IX1MIN=IX1MNS
          IX1MAX=IX1MXS
          IX2MIN=IX2MNS
          IX2MAX=IX2MXS
        ENDIF
C
        IX1TSW=IX1TSV
        IX1ZSW=IX1ZSV
        IX2TSW=IX2TSV
        IX2ZSW=IX2ZSV
        IY1TSW=IY1TSV
        IY1ZSW=IY1ZSV
        IY2TSW=IY2TSV
        IY2ZSW=IY2ZSV
        IX1FSW=IX1FSV
        IX2FSW=IX2FSV
        IY1FSW=IY1FSV
        IY2FSW=IY2FSV
        IERASW='OFF'
C
C  RESTORE COMMAND LINE
C
        ISHIFT=NARGT-NUMARG
        IF(ISHIFT.GT.0)THEN
          CALL SHIFTR(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1                IBUGG2,IERROR)
        ELSEIF(ISHIFT.LT.0)THEN
          ISHIFT=-ISHIFT
          CALL SHIFTL(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1                IBUGG2,IERROR)
        ENDIF
        DO7220II=1,NARGT
          IHARG(II)=IHT(II)
          IHARG2(II)=IH2T(II)
          IARGT(II)=IARGTT(II)
          ARG(II)=ARGT(II)
 7220   CONTINUE
      ENDIF
C
      DO7100IFAC=1,ICOLT
C
        IPLOT=IPLOT+1
        IX=IXC1
        IXLIST=1
        IROW=INT(IPLOT/IMPNC)+1
        IF(MOD(IPLOT,IMPNC).EQ.0)IROW=IROW-1
        ICOL=MOD(IPLOT,IMPNC)
        IF(ICOL.EQ.0)ICOL=IMPNC
C
        IHARG(NPOSA)=IVARN1(IRES)
        IHARG2(NPOSA)=IVARN2(IRES)
C
        IEMPTY='NO'
        ITEMP=IFAC
        IF(ICPLLA.EQ.'BOX')THEN
          ICOL=ICOL-1
          ITEMP=IFAC-1
          IF(ITEMP.EQ.0)IEMPTY='YES'
          IF(IROW.EQ.IMPNR)IEMPTY='YES'
        ENDIF
C
        IF(ICPLRV.EQ.1)THEN
          IF(ICPLTV.EQ.1)THEN
            IF(ITEMP.GT.0)THEN
              ARG(NPOS1)=ADIST1(ITEMP)
            ELSE
              ARG(NPOS1)=ADIST1(1)
            ENDIF
          ELSE
            IJUNK=IROW
            IF(IJUNK.GT.NOUT)IJUNK=NOUT
            IF(IJUNK.LT.1)IJUNK=1
            ARG(NPOS1)=ADIST1(IJUNK)
            IJUNK=ICOL
            IF(IJUNK.GT.NOUT2)IJUNK=NOUT2
            IF(IJUNK.LT.1)IJUNK=1
            ARG(NPOS2)=ADIST2(IJUNK)
          ENDIF
        ELSE
          IF(ICPLTV.EQ.1)THEN
            IJUNK=ITEMP
            IF(IJUNK.LT.1)IJUNK=1
            IF(IJUNK.GT.NOUT)IJUNK=NOUT
            ARG(NPOS1)=ADIST1(IJUNK)
          ELSE
            IJUNK=MOD(IROW-1,ICPLRV)+1
            IF(IJUNK.LT.1)IJUNK=1
            IF(IJUNK.GT.NOUT)IJUNK=NOUT
            ARG(NPOS1)=ADIST1(IJUNK)
            IJUNK=ITEMP
            IF(IJUNK.GT.NOUT2)IJUNK=NOUT2
            IF(IJUNK.LT.1)IJUNK=1
            ARG(NPOS2)=ADIST2(IJUNK)
          ENDIF
        ENDIF
C
        IF(IEMPTY.EQ.'YES')THEN
          DO7104I=1,MAXSUB
            ISU2SW(I)=ISUBSW(I)
            ISUBSW(I)='OFF'
 7104     CONTINUE
        ENDIF
        ICASPL='COND'
        IOPTN=3
        IDY=IRES
        IDX=1
        CALL DPSPM4(ICASPL,IOPTN,IDX,IDY,
     1              ISUBNU,ISUBSW,
     1              ASUBXL,ASUBXU,ASUBYL,ASUBYU,
     1              ISUBN9,ISUBSZ,
     1              ASBXL2,ASBXU2,ASBYL2,ASBYU2,
     1              PCPXSL,PCPXSU,PCPYSL,PCPYSU,
     1              IBUGG2,ISUBRO,IERROR)
C
        CALL DPSPM1(ICASPL,IVARN1,IVARN2,ICOLL,
     1              IMPNR,IMPNC,IROW,ICOL,IRES,IX,IPLOT,
     1              NPLOTS,NUMVAR,
     1              ICHAP2,ILINP2,
     1              GY1MNS,GY1MXS,GY2MNS,GY2MXS,
     1              GX1MNS,GX1MXS,GX2MNS,GX2MXS,
     1              IY1MNS,IY1MXS,IY2MNS,IY2MXS,
     1              IX1MNS,IX1MXS,IX2MNS,IX2MXS,
     1              IX1TSV,IX2TSV,IY1TSV,IY2TSV,
     1              IX1ZSV,IX2ZSV,IY1ZSV,IY2ZSV,
     1              PX1LD2,PX2LD2,
     1              IY1LJ2,IY1LD2,PY1LD2,PY1LA2,
     1              IX1LT2,IX2LT2,IY1LT2,IY2LT2,
     1              NCX1L2,NCX2L2,NCY1L2,NCY2L2,
     1              PCPXLL,PCPXUL,PCPYLL,PCPYUL,IXLIST,
     1              ICPLLA,ISPMLD,IPLOTT,ICPLFR,ICPLXA,ICPLYA,
     1              ISPMDI,
     1              ICPLTD,PCPLTD,IVNMEX,
     1              IBUGG2,ISUBRO)
C
CCCCC   ITITTE(1)='S'
CCCCC   ITITTE(2)='U'
CCCCC   ITITTE(3)='B'
CCCCC   ITITTE(4)='S'
CCCCC   ITITTE(5)='E'
CCCCC   ITITTE(6)='T'
CCCCC   ITITTE(7)=' '
CCCCC   NCTEMP=7
        NCTEMP=0
        DO7161I=1,4
          IF(IVARN1(ICC1)(I:I).NE.' ')THEN
            NCTEMP=NCTEMP+1
            ITITTE(NCTEMP)=IVARN1(ICC1)(I:I)
          ENDIF
 7161   CONTINUE
        DO7163I=1,4
          IF(IVARN2(ICC1)(I:I).NE.' ')THEN
            NCTEMP=NCTEMP+1
            ITITTE(NCTEMP)=IVARN2(ICC1)(I:I)
          ENDIF
 7163   CONTINUE
        NCTEMP=NCTEMP+1
        ITITTE(NCTEMP)=' '
        NCTEMP=NCTEMP+1
        ITITTE(NCTEMP)='='
        NCTEMP=NCTEMP+1
        ITITTE(NCTEMP)=' '
        NCTEMP=NCTEMP+1
        VAL=ARG(NPOS1)
        IVAL=INT(VAL+0.5)
        IF(VAL.LT.0.0)IVAL=INT(VAL-0.5)
        CALL DPCONH(IVAL,VAL,ITITTE(NCTEMP),NH,IBUGG2,IERROR)
        NCTEMP=NCTEMP+NH-1
        IF(ICPLTV.EQ.1)GOTO7189
        DO7169I=1,15
          NCTEMP=NCTEMP+1
          ITITTE(NCTEMP)=' '
 7169   CONTINUE
        DO7171I=1,4
          IF(IVARN1(ICC2)(I:I).NE.' ')THEN
            NCTEMP=NCTEMP+1
            ITITTE(NCTEMP)=IVARN1(ICC2)(I:I)
          ENDIF
 7171   CONTINUE
        DO7173I=1,4
          IF(IVARN2(ICC2)(I:I).NE.' ')THEN
            NCTEMP=NCTEMP+1
            ITITTE(NCTEMP)=IVARN2(ICC2)(I:I)
          ENDIF
 7173   CONTINUE
        NCTEMP=NCTEMP+1
        ITITTE(NCTEMP)=' '
        NCTEMP=NCTEMP+1
        ITITTE(NCTEMP)='='
        NCTEMP=NCTEMP+1
        ITITTE(NCTEMP)=' '
        NCTEMP=NCTEMP+1
        VAL=ARG(NPOS2)
        IVAL=INT(VAL+0.5)
        IF(VAL.LT.0.0)IVAL=INT(VAL-0.5)
        CALL DPCONH(IVAL,VAL,ITITTE(NCTEMP),NH,IBUGG2,IERROR)
        NCTEMP=NCTEMP+NH-1
 7189   CONTINUE
        NCTITL=NCTEMP
        IF(ICPLFR.EQ.'DEFA')THEN
          PTITDS=-ABS(PTITDZ)
        ENDIF
        IF(IEMPTY.EQ.'YES')THEN
          DO5306I=1,100
            ICHAPA(I)='BLAN'
            ILINPA(I)='BLAN'
            ISPISW(I)='OFF'
            IBARSW(I)='OFF'
 5306     CONTINUE
          NCTITL=0
        ENDIF
C
        IF(ICPLPT.EQ.'ROSE' .OR. ICPLPT.EQ.'ROS2')THEN
          NCTITL=0
        ENDIF
C
        CALL MAINGR(ANOPL1,ANOPL2,NPLOTV,NPLOTP,NS,ICASPL,
     1              MAXNPP,ISEED,IBOOSS,
     1              IX1TSV,IX2TSV,IY1TSV,IY2TSV,
     1              IX1ZSV,IX2ZSV,IY1ZSV,IY2ZSV,
     1              BARHEF,BARWEF,
     1              IRHSTG,IHSTCW,IHSTEB,IHSTOU,IASHWT,
     1              ICAPSW,IFORSW,
     1              IGUIFL,IERRFA,
     1              IAND1,IAND2,ICONT,NUMHPP,NUMVPP,
CCCCC1              TEMP,TEMP2,TEMP3,XTEMP1,XTEMP2,MAXNXT,
     1              MAXNXT,
     1              ISUBRO,IFOUND,IERROR)
        IF(IEMPTY.EQ.'NO' .AND. ICPLPT.NE.'ROS2')THEN
          CALL DPSPM3(ICASPL,IOUNI5,
     1                IROW,ICOL,
     1                PX2LD2,NPLOTP,
     1                IFORSW,
     1                IFPX2L,ISPX2P,ISPX2S,
     1                IHRIGH,IHRIG2,IHWUSE,
     1                ISUBN1,ISUBN2,MESSAG,
     1                IBUGG2,ISUBRO,IERROR)
        ENDIF
C
        ICONT=IDCONT(1)
        NUMHPP=IDNHPP(1)
        IMPARG=2
        CALL DPGRAP(Y,X,X3D,D,N,NPLOTP,ICASPL,ICONT,NUMHPP,
     1              XMATN,YMATN,XMITN,YMITN,
     1              ISQUAR,
     1              IVGMSW,IHGMSW,
     1              IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,
     1              IVSTAR,IVSTOP,IFUNC,NUMCHF,IREPCH,
     1              YPLOT,XPLOT,X2PLOT,TAGPLO,
     1              IMPSW,IMPNR,IMPNC,IMPCO,IMPCO9,
     1              IMPARG,
     1              PMXMIN,PMXMAX,PMYMIN,PMYMAX,
     1              MAXCOL,
     1              DSIZE,DSYMB,DCOLOR,DFILL,
     1              ICAPSW,
     1              IBUGUG,IBUGU2,IBUGU3,IBUGU4,ISUBRO,
     1              IERROR)
        IF(IERROR.EQ.'NO')IAND1=IAND2
        IF(IERROR.EQ.'YES')GOTO7199
C
        IF(ICPLPT.NE.'PLOT')GOTO7199
        IF(ICPLFI.EQ.'NONE')GOTO7199
        IF(IEMPTY.EQ.'YES')GOTO7199
C
        IMPCO=IMPCO-1
        IF(IMPCO.LE.1)IERASW='OFF'
C
        CALL DPSPM2(ICASPL,IVARN1,IVARN2,ICOLL,NUMVAR,NPLOTP,
     1              IRES,IX,
     1              TEMP,TEMP2,TEMP3,XTEMP1,XTEMP2,MAXNXT,
     1              ALOWFR,ALOWDG,
     1              IANGLU,MAXNPP,IAND1,IAND2,
     1              ICPLFI,ICPLTA,
     1              XMATN,YMATN,XMITN,YMITN,
     1              ISQUAR,
     1              IVGMSW,IHGMSW,
     1              IMPSW,IMPNR,IMPNC,IMPCO,IMPCO9,
     1              IREPCH,
     1              PMXMIN,PMXMAX,PMYMIN,PMYMAX,
     1              IBUGG2,IBUGG3,IBUGCO,IBUGEV,IBUGQ,
     1              IBUGUG,IBUGU2,IBUGU3,IBUGU4,
     1              ISUBRO,IFOUND,IERROR)
        IF(IERROR.EQ.'YES')GOTO7199
C
 7199   CONTINUE
        ISHIFT=NARGT-NUMARG
        IF(ISHIFT.GT.0)THEN
          CALL SHIFTR(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1                IBUGG2,IERROR)
        ELSEIF(ISHIFT.LT.0)THEN
          ISHIFT=-ISHIFT
          CALL SHIFTL(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1                IBUGG2,IERROR)
        ENDIF
        ICOM=ICT
        ICOM2=IC2T
        DO7101II=1,NARGT
          IHARG(II)=IHT(II)
          IHARG2(II)=IH2T(II)
          IARGT(II)=IARGTT(II)
          ARG(II)=ARGT(II)
 7101   CONTINUE
C
        PX1LDS=PX1LD2
        IF(IYAXIS.EQ.0.AND.IFLGIN.EQ.'NO')THEN
          GY1MNS=GY1MIN
          GY1MXS=GY1MAX
          GY2MNS=GY2MIN
          GY2MXS=GY2MAX
          IY1MNS=IY1MIN
          IY1MXS=IY1MAX
          IY2MNS=IY2MIN
          IY2MXS=IY2MAX
        ENDIF
        IF(IXAXIS.EQ.0.AND.IFLGIN.EQ.'NO')THEN
          GX1MNS=GX1MIN
          GX1MXS=GX1MAX
          GX2MNS=GX2MIN
          GX2MXS=GX2MAX
          IX1MNS=IX1MIN
          IX1MXS=IX1MAX
          IX2MNS=IX2MIN
          IX2MXS=IX2MAX
        ENDIF
        PX1ZDS=PX1ZD2
        PX2ZDS=PX2ZD2
        PY1ZDS=PY1ZD2
        PY2ZDS=PY2ZD2
        IF(IEMPTY.EQ.'YES')THEN
          DO7107I=1,MAXSUB
            ISUBSW(I)=ISU2SW(I)
 7107     CONTINUE
        ENDIF
        DO7108I=1,100
            ICHAPA(I)=ICHAP2(I)
            ILINPA(I)=ILINP2(I)
            ISPISW(I)=ISPIS2(I)
            IBARSW(I)=IBARS2(I)
 7108     CONTINUE
C
 7100 CONTINUE
 7200 CONTINUE
      IF(IYAXIS.EQ.1)THEN
        GY1MIN=GY1MNS
        GY1MAX=GY1MXS
        GY2MIN=GY2MNS
        GY2MAX=GY2MXS
        IY1MIN=IY1MNS
        IY1MAX=IY1MXS
        IY2MIN=IY2MNS
        IY2MAX=IY2MXS
      ENDIF
      IF(IXAXIS.EQ.1)THEN
        GX1MIN=GX1MNS
        GX1MAX=GX1MXS
        GX2MIN=GX2MNS
        GX2MAX=GX2MXS
        IX1MIN=IX1MNS
        IX1MAX=IX1MXS
        IX2MIN=IX2MNS
        IX2MAX=IX2MXS
      ENDIF
      GOTO8000
C
C               **********************************************
C               **   STEP 21--                              **
C               **   GENERATE THE 3D                 PLOTS  **
C               **   GENERATE THE YATES CUBE         PLOTS  **
C               **********************************************
C
 7499 CONTINUE
C
      IF(NPLOTS.LT.1)GOTO8000
C
      ISHIFT=ILOCQ-1
      CALL SHIFTL(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1IBUGG2,IERROR)
      IF(IERROR.EQ.'YES')GOTO8000
C
C  CREATE BASIC COMMAND LINE, FOR EXAMPLE:
C    YATES CUBE PLOT Y X1 X2 X3 SUBSET COND1 = <VAL> SUBSET COND2 = <VAL>
C  WHERE COND2 IS OPTIONAL
C
      ISHIFT=NCCOMM+4
      IF(ICPLTV.GE.1)ISHIFT=ISHIFT+4
      IF(ICPLTV.GE.2)ISHIFT=ISHIFT+4
      CALL SHIFTR(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1            IBUGG2,IERROR)
      ICOM=ICT
      ICOM2=IC2T
      DO7506II=1,NCCOMM
        IHARG(II)=IHT(II)
        IHARG2(II)=IH2T(II)
        IARGT(II)='WORD'
 7506 CONTINUE
      NWORD=NCCOMM+1
      NPOSA=NWORD
      IHARG(NWORD)=IVARN1(1)
      IHARG2(NWORD)=IVARN2(1)
      IARGT(NWORD)='WORD'
      NWORD=NCCOMM+2
      NPOSB=NWORD
      IHARG(NWORD)=IVARN1(IXC1)
      IHARG2(NWORD)=IVARN2(IXC1)
      IARGT(NWORD)='WORD'
C
      IF(ICPLXV.GE.2)THEN
        NWORD=NWORD+1
        IHARG(NWORD)=IVARN1(IXC2)
        IHARG2(NWORD)=IVARN2(IXC2)
        IARGT(NWORD)='WORD'
      ENDIF
C
      IF(ICPLXV.GE.3)THEN
        NWORD=NWORD+1
        IHARG(NWORD)=IVARN1(IXC3)
        IHARG2(NWORD)=IVARN2(IXC3)
        IARGT(NWORD)='WORD'
      ENDIF
C
      NWORD=NWORD+1
      IHARG(NWORD)='SUBS'
      IHARG2(NWORD)='ET  '
      IARGT(NWORD)='WORD'
C
      NWORD=NWORD+1
      IHARG(NWORD)=IVARN1(ICC1)
      IHARG2(NWORD)=IVARN2(ICC1)
      IARGT(NWORD)='WORD'
C
      NWORD=NWORD+1
      IHARG(NWORD)='=   '
      IHARG2(NWORD)='    '
      IARGT(NWORD)='WORD'
C
      NWORD=NWORD+1
      IHARG(NWORD)='0  '
      IHARG2(NWORD)='    '
      IARGT(NWORD)='NUMB'
      NPOS1=NWORD
C
      IF(ICPLTV.EQ.2)THEN
        NWORD=NWORD+1
        IHARG(NWORD)='SUBS'
        IHARG2(NWORD)='ET  '
        IARGT(NWORD)='WORD'
C
        NWORD=NWORD+1
        IHARG(NWORD)=IVARN1(ICC2)
        IHARG2(NWORD)=IVARN2(ICC2)
        IARGT(NWORD)='WORD'
C
        NWORD=NWORD+1
        IHARG(NWORD)='=   '
        IHARG2(NWORD)='    '
        IARGT(NWORD)='WORD'
C
        NWORD=NWORD+1
        IHARG(NWORD)='0  '
        IHARG2(NWORD)='    '
        IARGT(NWORD)='NUMB'
        NPOS2=NWORD
      ENDIF
      NARGT=NUMARG
C
      DO7520I=1,NARGT
        IHT(I)=IHARG(I)
        IH2T(I)=IHARG2(I)
        IARGTT(I)=IARGT(I)
        ARGT(I)=ARG(I)
 7520 CONTINUE
C
      IPLOT=0
      IEMPTY='NO'
      DO7700IRES=1,IROWT
      DO7600IFAC=1,ICOLT
C
        IPLOT=IPLOT+1
        IX=IXC1
        IXLIST=1
        IROW=INT(IPLOT/IMPNC)+1
        IF(MOD(IPLOT,IMPNC).EQ.0)IROW=IROW-1
        ICOL=MOD(IPLOT,IMPNC)
        IF(ICOL.EQ.0)ICOL=IMPNC
C
        IHARG(NPOSA)=IVARN1(IRES)
        IHARG2(NPOSA)=IVARN2(IRES)
C
        IEMPTY='NO'
        ITEMP=IFAC
C
        IF(ICPLTV.EQ.1)THEN
          IF(ITEMP.GT.0)THEN
            ARG(NPOS1)=ADIST1(ITEMP)
          ELSE
            ARG(NPOS1)=ADIST1(1)
          ENDIF
        ELSE
          IJUNK=IROW
          IF(IJUNK.GT.NOUT)IJUNK=NOUT
          IF(IJUNK.LT.1)IJUNK=1
          ARG(NPOS1)=ADIST1(IJUNK)
          IJUNK=ICOL
          IF(IJUNK.GT.NOUT2)IJUNK=NOUT2
          IF(IJUNK.LT.1)IJUNK=1
          ARG(NPOS2)=ADIST2(IJUNK)
        ENDIF
C
        ICASPL='COND'
        NCTEMP=0
        DO7661I=1,4
          IF(IVARN1(ICC1)(I:I).NE.' ')THEN
            NCTEMP=NCTEMP+1
            ITITTE(NCTEMP)=IVARN1(ICC1)(I:I)
          ENDIF
 7661   CONTINUE
        DO7663I=1,4
          IF(IVARN2(ICC1)(I:I).NE.' ')THEN
            NCTEMP=NCTEMP+1
            ITITTE(NCTEMP)=IVARN2(ICC1)(I:I)
          ENDIF
 7663   CONTINUE
        NCTEMP=NCTEMP+1
        ITITTE(NCTEMP)=' '
        NCTEMP=NCTEMP+1
        ITITTE(NCTEMP)='='
        NCTEMP=NCTEMP+1
        ITITTE(NCTEMP)=' '
        NCTEMP=NCTEMP+1
        VAL=ARG(NPOS1)
        IVAL=INT(VAL+0.5)
        IF(VAL.LT.0.0)IVAL=INT(VAL-0.5)
        CALL DPCONH(IVAL,VAL,ITITTE(NCTEMP),NH,IBUGG2,IERROR)
        NCTEMP=NCTEMP+NH-1
        IF(ICPLTV.EQ.1)GOTO7689
        DO7669I=1,15
          NCTEMP=NCTEMP+1
          ITITTE(NCTEMP)=' '
 7669   CONTINUE
        DO7671I=1,4
          IF(IVARN1(ICC2)(I:I).NE.' ')THEN
            NCTEMP=NCTEMP+1
            ITITTE(NCTEMP)=IVARN1(ICC2)(I:I)
          ENDIF
 7671   CONTINUE
        DO7673I=1,4
          IF(IVARN2(ICC2)(I:I).NE.' ')THEN
            NCTEMP=NCTEMP+1
            ITITTE(NCTEMP)=IVARN2(ICC2)(I:I)
          ENDIF
 7673   CONTINUE
        NCTEMP=NCTEMP+1
        ITITTE(NCTEMP)=' '
        NCTEMP=NCTEMP+1
        ITITTE(NCTEMP)='='
        NCTEMP=NCTEMP+1
        ITITTE(NCTEMP)=' '
        NCTEMP=NCTEMP+1
        VAL=ARG(NPOS2)
        IVAL=INT(VAL+0.5)
        IF(VAL.LT.0.0)IVAL=INT(VAL-0.5)
        CALL DPCONH(IVAL,VAL,ITITTE(NCTEMP),NH,IBUGG2,IERROR)
        NCTEMP=NCTEMP+NH-1
 7689   CONTINUE
        NCTITL=NCTEMP
        IF(ICPLFR.EQ.'DEFA')THEN
          PTITDS=-ABS(PTITDZ)
        ENDIF
C
        CALL MAINGR(ANOPL1,ANOPL2,NPLOTV,NPLOTP,NS,ICASPL,
     1              MAXNPP,ISEED,IBOOSS,
     1              IX1TSV,IX2TSV,IY1TSV,IY2TSV,
     1              IX1ZSV,IX2ZSV,IY1ZSV,IY2ZSV,
     1              BARHEF,BARWEF,
     1              IRHSTG,IHSTCW,IHSTEB,IHSTOU,IASHWT,
     1              ICAPSW,IFORSW,
     1              IGUIFL,IERRFA,
     1              IAND1,IAND2,ICONT,NUMHPP,NUMVPP,
CCCCC1              TEMP,TEMP2,TEMP3,XTEMP1,XTEMP2,MAXNXT,
     1              MAXNXT,
     1              ISUBRO,IFOUND,IERROR)
C
        ICONT=IDCONT(1)
        NUMHPP=IDNHPP(1)
        IMPARG=2
        CALL DPGRAP(Y,X,X3D,D,N,NPLOTP,ICASPL,ICONT,NUMHPP,
     1              XMATN,YMATN,XMITN,YMITN,
     1              ISQUAR,
     1              IVGMSW,IHGMSW,
     1              IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,
     1              IVSTAR,IVSTOP,IFUNC,NUMCHF,IREPCH,
     1              YPLOT,XPLOT,X2PLOT,TAGPLO,
     1              IMPSW,IMPNR,IMPNC,IMPCO,IMPCO9,
     1              IMPARG,
     1              PMXMIN,PMXMAX,PMYMIN,PMYMAX,
     1              MAXCOL,
     1              DSIZE,DSYMB,DCOLOR,DFILL,
     1              ICAPSW,
     1              IBUGUG,IBUGU2,IBUGU3,IBUGU4,ISUBRO,
     1              IERROR)
        IF(IERROR.EQ.'NO')IAND1=IAND2
        IF(IERROR.EQ.'YES')GOTO7699
C
 7699   CONTINUE
        ISHIFT=NARGT-NUMARG
        IF(ISHIFT.GT.0)THEN
          CALL SHIFTR(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1                IBUGG2,IERROR)
        ELSEIF(ISHIFT.LT.0)THEN
          ISHIFT=-ISHIFT
          CALL SHIFTL(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1                IBUGG2,IERROR)
        ENDIF
        ICOM=ICT
        ICOM2=IC2T
        DO7601II=1,NARGT
          IHARG(II)=IHT(II)
          IHARG2(II)=IH2T(II)
          IARGT(II)=IARGTT(II)
          ARG(II)=ARGT(II)
 7601   CONTINUE
C
 7600 CONTINUE
 7700 CONTINUE
      GOTO8000
C
C               **************************************************
C               **   STEP 28--                                  **
C               **   REINSTATE INITIAL SETTINGS                 **
C               **************************************************
C
 8000 CONTINUE
 2800 CONTINUE
C
      ISTEPN='28'
      IF(IBUGG3.EQ.'ON'.OR.ISUBRO.EQ.'COND')THEN
        CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
        WRITE(ICOUT,8807)IMANUF,NUMDEV,IDMANU(1)
 8807   FORMAT('IMANUF,NUMDEV,IDMANU(1) = ',A4,I8,2X,A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      IFLAG=2
      CALL DPSPM5(IFLAG,IMPSW,IMPCO,IMPNR,IMPNC,IOUNI5,
     1            IBUGG2,ISUBRO,IFOUND,IERROR)
      ICPLFR=ICPLFZ
      IFEEDB=IFEED9
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG2.EQ.'ON' .OR. ISUBRO.EQ.'COND')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPCOND--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)IFOUND,IERROR
 9012   FORMAT('IFOUND,IERROR = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)NPLOTV,NPLOTP,NS,ICASPL,IAND1,IAND2
 9013   FORMAT('NPLOTV,NPLOTP,NS,ICASPL,IAND1,IAND2 = ',31I8,3(2X,A4))
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPCONF(XTEMP1,XTEMP2,MAXNXT,ICASAN,
     1                  ICAPSW,IFORSW,IMULT,IREPL,
     1                  ISUBRO,IBUGA2,IBUGA3,IBUGQ,IFOUND,IERROR)
C
C     PURPOSE--GENERATE (SYMMETRIC) CONFIDENCE LIMITS FOR THE MEAN
C              FOR PROBABILITY VALUE P = .90, .95, .99, .999, AND .9999.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--JULY      1984.
C     UPDATED         --JUNE      1990. TEMPORARY ARRAYS TO GARBAGE COMMON
C     UPDATED         --MARCH     1999. IF 2 VARIABLES SPECIFIED,
C                                       COMPUTE CONFIDENCE INTERVAL
C                                       FOR DIFFERENCE BETWEEN MEANS
C     UPDATED         --MARCH     2003. SAVE CONFIDENCE BOUNDS AS
C                                       INTERNAL PARAMETERS
C     UPDATED         --OCTOBER   2003. SUPPORT FOR HTML, LATEX OUTPUT
C     UPDATED         --MARCH     2010. USE DPPARS
C     UPDATED         --MARCH     2010. USE DPDTA1, DPDTA4 TO GENERATE
C                                       HTML, LATEX, RTF FORMAT
C     UPDATED         --MARCH     2010. SUPPORT FOR MULTIPLE RESPONSE
C                                       VARIABLES AND FOR GROUP-ID
C                                       VARIABLES (I.E., REPLICATION
C                                       CASE)
C     UPDATED         --MARCH     2010. USE DPPAR3 TO EXTRACT EITHER A
C                                       RESPONSE VARIABLE OR A MATRIX
C                                       NAME
C     UPDATED         --APRIL     2013. SUPPORT <LOWER/UPPER> OPTION
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 IFORSW
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA2
      CHARACTER*4 IBUGA3
      CHARACTER*4 IBUGQ
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
      CHARACTER*4 IHWUSE
      CHARACTER*4 MESSAG
      CHARACTER*4 ICASEQ
      CHARACTER*4 IH
      CHARACTER*4 IH2
C
      CHARACTER*4 ICASAN
      CHARACTER*4 ICASA2
      CHARACTER*4 ICTMP0
      CHARACTER*4 ICTMP1
      CHARACTER*4 ICTMP2
      CHARACTER*4 ICTMP3
      CHARACTER*4 ICTMP4
      CHARACTER*4 ICTMP5
      CHARACTER*4 ICASE
C
      CHARACTER*4 ISUBN0
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      CHARACTER*4 IFLAGU
C
      LOGICAL IFRST
      LOGICAL ILAST
C
      CHARACTER*4 IREPL
      CHARACTER*4 IMULT
C
      CHARACTER*40 INAME
      PARAMETER (MAXSPN=30)
      CHARACTER*4 IVARN1(MAXSPN)
      CHARACTER*4 IVARN2(MAXSPN)
      CHARACTER*4 IVARTY(MAXSPN)
      CHARACTER*4 IVARID(MAXSPN)
      CHARACTER*4 IVARI2(MAXSPN)
      REAL PVAR(MAXSPN)
      REAL PID(MAXSPN)
      INTEGER ILIS(MAXSPN)
      INTEGER NRIGHT(MAXSPN)
      INTEGER ICOLR(MAXSPN)
C
C---------------------------------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
C
      DIMENSION XTEMP1(*)
      DIMENSION XTEMP2(*)
      DIMENSION TEMP1(MAXOBV)
      DIMENSION TEMP2(MAXOBV)
C
      DIMENSION XDESGN(MAXOBV,6)
      DIMENSION XIDTEM(MAXOBV)
      DIMENSION XIDTE2(MAXOBV)
      DIMENSION XIDTE3(MAXOBV)
      DIMENSION XIDTE4(MAXOBV)
      DIMENSION XIDTE5(MAXOBV)
      DIMENSION XIDTE6(MAXOBV)
C
      INCLUDE 'DPCOZZ.INC'
      EQUIVALENCE (GARBAG(IGARB1),XIDTEM(1))
      EQUIVALENCE (GARBAG(IGARB2),XIDTE2(1))
      EQUIVALENCE (GARBAG(IGARB3),XIDTE3(1))
      EQUIVALENCE (GARBAG(IGARB4),XIDTE4(1))
      EQUIVALENCE (GARBAG(IGARB5),XIDTE5(1))
      EQUIVALENCE (GARBAG(IGARB6),XIDTE6(1))
      EQUIVALENCE (GARBAG(IGARB7),TEMP1(1))
      EQUIVALENCE (GARBAG(IGARB8),TEMP2(1))
      EQUIVALENCE (GARBAG(IGARB9),XDESGN(1,1))
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOHK.INC'
      INCLUDE 'DPCOSU.INC'
      INCLUDE 'DPCODA.INC'
      INCLUDE 'DPCOHO.INC'
      INCLUDE 'DPCOST.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPCO'
      ISUBN2='NF  '
C
      MAXCP1=MAXCOL+1
      MAXCP2=MAXCOL+2
      MAXCP3=MAXCOL+3
      MAXCP4=MAXCOL+4
      MAXCP5=MAXCOL+5
      MAXCP6=MAXCOL+6
C
      IFOUND='YES'
      IERROR='NO'
C
C               ****************************************
C               **  TREAT THE CONFIDENCE LIMITS CASE  **
C               ****************************************
C
      IF(IBUGA2.EQ.'ON' .OR. ISUBRO.EQ.'CONF')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPCONF--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGA2,IBUGA3,IBUGQ,ISUBRO
   52   FORMAT('IBUGA2,IBUGA3,IBUGQ,ISUBRO = ',3(A4,2X),A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,55)MAXNXT,ICASAN,MAXV2
   55   FORMAT('MAXNXT,ICASAN,MAXV2 = ',I8,2X,A4,2X,I5)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               *********************************
C               **  STEP 1--                   **
C               **  EXTRACT THE COMMAND        **
C               *********************************
C
      ISTEPN='1'
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'CONF')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     THE FOLLOWING COMMANDS ARE ACCEPTED:
C
C         CONFIDENCE LIMITS Y               (TWO SIDED)
C         LOWER CONFIDENCE LIMITS Y         (ONE SIDED)
C         UPPER PREDICTION LIMITS Y         (ONE SIDED)
C
C         DIFFERENCE OF MEAN CONFIDENCE LIMITS Y1 Y2   (TWO SIDED)
C         DIFFERENCE OF MEAN LOWER CONFIDENCE LIMITS Y (ONE SIDED)
C         DIFFERENCE OF MEAN UPPER PREDICTION LIMITS Y (ONE SIDED)
C
C     IN ADDITION, CHECK FOR THE "MULTIPLE" AND "REPLICATION" OPTIONS.
C
      ILASTZ=9999
      IFOUND='NO'
      ICASAN='ONEV'
      ICASA2='TWOS'
C
      DO100I=0,NUMARG-1
C
        ICTMP0='XXXX'
        IF(I.EQ.0)THEN
          ICTMP1=ICOM
          ICTMP2=IHARG(I+1)
          ICTMP3=IHARG(I+2)
          ICTMP4=IHARG(I+3)
          ICTMP5=IHARG(I+4)
        ELSE
          IF(I.GE.2)ICTMP0=IHARG(I-1)
          ICTMP1=IHARG(I)
          ICTMP2=IHARG(I+1)
          ICTMP3=IHARG(I+2)
          ICTMP4=IHARG(I+3)
          ICTMP5=IHARG(I+4)
        ENDIF
C
        IF(ICTMP1.EQ.'=   ')GOTO9000
        IF(ICTMP1.EQ.'BIWE' .AND. ICTMP2.EQ.'CONF')GOTO9000
        IF(ICTMP1.EQ.'MEDI' .AND. ICTMP2.EQ.'CONF')GOTO9000
        IF(ICTMP1.EQ.'QUAN' .AND. ICTMP2.EQ.'CONF')GOTO9000
        IF(ICTMP1.EQ.'CORR' .AND. ICTMP2.EQ.'CONF')GOTO9000
        IF(ICTMP1.EQ.'TRIM' .AND. ICTMP2.EQ.'MEAN')GOTO9000
C
        IF(ICTMP1.EQ.'DIFF' .AND. ICTMP2.EQ.'OF  ' .AND.
     1         ICTMP3.EQ.'MEAN' .AND. ICTMP4.EQ.'CONF' .AND.
     1         (ICTMP5.EQ.'LIMI' .OR. ICTMP5.EQ.'INTE'))THEN
          IFOUND='YES'
          ILASTZ=I+4
          ICASAN='TWOV'
          GOTO109
        ELSEIF(ICTMP1.EQ.'CONF' .AND. ICTMP2.EQ.'INTE' .AND.
     1     ICTMP0.NE.'SD  ' .AND. ICTMP0.NE.'DEVI' .AND.
     1     ICASAN.NE.'TWOV')THEN
          IFOUND='YES'
          ILASTZ=I+1
          ICASAN='ONEV'
          GOTO109
        ELSEIF(ICTMP1.EQ.'CONF' .AND. ICTMP2.EQ.'LIMI' .AND.
     1     ICTMP0.NE.'SD  ' .AND. ICTMP0.NE.'DEVI' .AND.
     1     ICASAN.NE.'TWOV')THEN
          IFOUND='YES'
          ILASTZ=I+1
          ICASAN='ONEV'
          GOTO109
        ELSEIF(ICTMP1.EQ.'LOWE')THEN
          ICASA2='LOWE'
        ELSEIF(ICTMP1.EQ.'UPPE')THEN
          ICASA2='UPPE'
        ELSEIF(ICTMP1.EQ.'REPL')THEN
          IREPL='ON'
        ELSEIF(ICTMP1.EQ.'MULT')THEN
          IMULT='ON'
        ENDIF
  100 CONTINUE
  109 CONTINUE
C
      IF(IBUGA2.EQ.'ON' .OR. ISUBRO.EQ.'CONF')THEN
        WRITE(ICOUT,111)ICASAN,ICASA2,IREPL
  111   FORMAT('ICASAN,ICASA2,IREPL=',2(A4,2X),A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      IF(IFOUND.EQ.'NO')GOTO9000
      ISHIFT=ILASTZ
      CALL SHIFTL(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1            IBUGA2,IERROR)
C
      IF(IMULT.EQ.'ON')THEN
        IF(IREPL.EQ.'ON')THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,101)
  101     FORMAT('***** ERROR IN CONFIDENCE LIMITS--')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,102)
  102     FORMAT('      YOU CANNOT SPECIFY BOTH "MULTIPLE" AND ',
     1           '"REPLICATION" FOR THE CONFIDENCE LIMITS COMMAND.')
          CALL DPWRST('XXX','BUG ')
          IERROR='YES'
          GOTO9000
        ENDIF
      ENDIF
C
C               *********************************
C               **  STEP 1--                   **
C               **  EXTRACT THE VARIABLE LIST  **
C               *********************************
C
      ISTEPN='1'
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'CONF')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      MINNA=1
      MAXNA=100
      MINNVA=1
      MAXNVA=100
      IFLAGP=0
      JMIN=1
      JMAX=NUMARG
      MINN2=2
C
      IF(ICASAN.EQ.'TWOV')THEN
        INAME='DIFFERENCE OF THE MEANS CONFIDENCE LIMIT'
        IFLAGE=0
        IFLAGM=1
        MINNA=2
        MINNVA=2
        MAXNVA=30
        IF(IREPL.EQ.'ON')THEN
          MAXNVA=8
          IFLAGE=1
          IFLAGM=0
        ENDIF
      ELSE
        INAME='CONFIDENCE LIMITS FOR THE MEAN'
        MINNVA=1
        MAXNVA=30
        IFLAGE=0
        IFLAGM=1
        IF(IREPL.EQ.'ON')THEN
          MINNVA=2
          MAXNVA=7
          IFLAGE=0
          IFLAGM=0
        ENDIF
      ENDIF
C
      CALL DPPARS(IHARG,IHARG2,IARGT,ARG,NUMARG,IANS,IWIDTH,
     1            IHNAME,IHNAM2,IUSE,NUMNAM,IN,IVALUE,VALUE,
     1            JMIN,JMAX,
     1            MINN2,MINNA,MAXNA,MAXSPN,IFLAGE,INAME,
     1            IVARN1,IVARN2,IVARTY,PVAR,
     1            ILIS,NRIGHT,ICOLR,ISUB,NQ,ILOCQ,NUMVAR,
     1            MINNVA,MAXNVA,
     1            IFLAGM,IFLAGP,
     1            IBUGA3,IBUGQ,ISUBRO,IFOUND,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'CONF')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,181)
  181   FORMAT('***** AFTER CALL DPPARS--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,182)NQ,NUMVAR,IMULT,IREPL
  182   FORMAT('NQ,NUMVAR,IMULT,IREPL = ',2I8,2(2X,A4))
        CALL DPWRST('XXX','BUG ')
        IF(NUMVAR.GT.0)THEN
          DO185I=1,NUMVAR
            WRITE(ICOUT,187)I,IVARN1(I),IVARN2(I),ILIS(I),NRIGHT(I),
     1                      ICOLR(I)
  187       FORMAT('I,IVARN1(I),IVARN2(I),ILIS(I),NRIGHT(I),',
     1             'ICOLR(I) = ',I8,2X,A4,A4,2X,3I8)
            CALL DPWRST('XXX','BUG ')
  185     CONTINUE
        ENDIF
      ENDIF
C
C               ***********************************************
C               **  STEP 2--                                 **
C               **  DETERMINE:                               **
C               **  1) NUMBER OF REPLICATION VARIABLES (0-6) **
C               **  2) NUMBER OF RESPONSE    VARIABLES (>= 1)**
C               ***********************************************
C
      ISTEPN='2'
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'CONF')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NRESP=NUMVAR
      NREPL=0
C
      IF(IREPL.EQ.'ON')THEN
        NRESP=1
        IF(ICASAN.EQ.'TWOV')NRESP=2
        NREPL=NUMVAR-NRESP
        IF(NREPL.LT.1 .OR. NREPL.GT.6)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,101)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,211)
  211     FORMAT('      FOR THE REPLICATION CASE, THE NUMBER OF ',
     1           'REPLICATION VARIABLES')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,213)NREPL
  213     FORMAT('      THE NUMBER OF REPLICATION VARIABLES = ',I5)
          CALL DPWRST('XXX','BUG ')
          IERROR='YES'
          GOTO9000
        ENDIF
      ENDIF
C
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'CONF')THEN
        WRITE(ICOUT,221)NRESP,NREPL
  221   FORMAT('NRESP,NREPL = ',2I5)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               *******************************************
C               **  STEP 3--                             **
C               **  CASE 1: NO REPLICATION CASE.         **
C               *******************************************
C
      IF(IREPL.EQ.'OFF' .AND. ICASAN.EQ.'ONEV')THEN
C
        ISTEPN='3'
        IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'CONF')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C       LOOP THROUGH EACH OF THE RESPONSE VARIABLES
C
        NCURVE=0
        DO310IRESP=1,NRESP
          NCURVE=NCURVE+1
C
          IINDX=ICOLR(IRESP)
          PID(1)=CPUMIN
          IVARID(1)=IVARN1(IRESP)
          IVARI2(1)=IVARN2(IRESP)
C
          IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'CONF')THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,311)IRESP,NCURVE
  311       FORMAT('IRESP,NCURVE = ',2I5)
            CALL DPWRST('XXX','BUG ')
          ENDIF
C
          ICOL=IRESP
          NUMVA2=1
          CALL DPPAR3(ICOL,IVALUE,IVALU2,IN,MAXN,MAXOBV,
     1                INAME,IVARN1,IVARN2,IVARTY,
     1                ILIS,NRIGHT,ICOLR,ISUB,NQ,NUMVA2,
     1                MAXCOL,MAXCP1,MAXCP2,MAXCP3,
     1                MAXCP4,MAXCP5,MAXCP6,
     1                V,PRED,RES,YPLOT,XPLOT,X2PLOT,TAGPLO,
     1                Y,XTEMP1,XTEMP2,NLOCAL,NLOCA2,NLOCA3,ICASE,
     1                IBUGA3,ISUBRO,IFOUND,IERROR)
          IF(IERROR.EQ.'YES')GOTO9000
C
C         *****************************************************
C         **  STEP 3B--                                      **
C         *****************************************************
C
          ISTEPN='3B'
          IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'CONF')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
          IF(IBUGA2.EQ.'ON' .OR. ISUBRO.EQ.'CONF')THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,322)
  322       FORMAT('***** FROM THE MIDDLE  OF DPCONF--')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,323)ICASAN,NUMVAR,NLOCAL,IRESP
  323       FORMAT('ICASAN,NUMVAR,NLOCAL,IRESP = ',A4,3I8)
            CALL DPWRST('XXX','BUG ')
            IF(NLOCAL.GE.1)THEN
              DO325I=1,NLOCAL
                WRITE(ICOUT,326)I,Y(I)
  326           FORMAT('I,Y(I) = ',I8,F12.5)
                CALL DPWRST('XXX','BUG ')
  325         CONTINUE
            ENDIF
          ENDIF
C
          CALL DPCNF2(Y,NLOCAL,X,NLOCA2,
     1                XTEMP1,XTEMP2,MAXNXT,
     1                PID,IVARID,IVARI2,NREPL,
     1                CUTL90,CUTU90,CUTL95,CUTU95,CUTL99,CUTU99,
     1                ICAPSW,ICAPTY,IFORSW,ICASAN,ICASA2,
     1                ISUBRO,IBUGA3,IERROR)
C
          IFLAGU='FILE'
          IFRST=.FALSE.
          ILAST=.FALSE.
          IF(IRESP.EQ.1)IFRST=.TRUE.
          IF(IRESP.EQ.NRESP)ILAST=.TRUE.
          CALL DPCNF3(CUTL90,CUTU90,CUTL95,CUTU95,CUTL99,CUTU99,
     1                IFLAGU,IFRST,ILAST,ICASAN,
     1                IBUGA2,IBUGA3,ISUBRO,IERROR)
C
  310   CONTINUE
C
C               ****************************************************
C               **  STEP 5A--                                     **
C               **  CASE 3: ONE OR MORE REPLICATION VARIABLES.    **
C               **          FOR THIS CASE, ALL VARIABLES MUST     **
C               **          HAVE THE SAME LENGTH.                 **
C               ****************************************************
C
      ELSEIF(IREPL.EQ.'OFF' .AND. ICASAN.EQ.'TWOV')THEN
C
        ISTEPN='4A'
        IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'CONF')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
        NUMVA2=1
        DO410I=1,NUMVAR
          DO420J=I+1,NUMVAR
            ICOL=I
            CALL DPPAR3(ICOL,IVALUE,IVALU2,IN,MAXN,MAXOBV,
     1                  INAME,IVARN1,IVARN2,IVARTY,
     1                  ILIS,NRIGHT,ICOLR,ISUB,NQ,NUMVA2,
     1                  MAXCOL,MAXCP1,MAXCP2,MAXCP3,
     1                  MAXCP4,MAXCP5,MAXCP6,
     1                  V,PRED,RES,YPLOT,XPLOT,X2PLOT,TAGPLO,
     1                  Y,Y,Y,NS1,NLOCA2,NLOCA3,ICASE,
     1                  IBUGA3,ISUBRO,IFOUND,IERROR)
            IF(IERROR.EQ.'YES')GOTO9000
C
            ICOL=J
            CALL DPPAR3(ICOL,IVALUE,IVALU2,IN,MAXN,MAXOBV,
     1                  INAME,IVARN1,IVARN2,IVARTY,
     1                  ILIS,NRIGHT,ICOLR,ISUB,NQ,NUMVA2,
     1                  MAXCOL,MAXCP1,MAXCP2,MAXCP3,
     1                  MAXCP4,MAXCP5,MAXCP6,
     1                  V,PRED,RES,YPLOT,XPLOT,X2PLOT,TAGPLO,
     1                  X,X,X,NS2,NLOCA2,NLOCA3,ICASE,
     1                  IBUGA3,ISUBRO,IFOUND,IERROR)
            IF(IERROR.EQ.'YES')GOTO9000
C
C               *****************************************
C               **  STEP 4B--                          **
C               **  PERFORM DIFFERENCE OF MEANS        **
C               **          CONFIDENCE LIMITS          **
C               *****************************************
C
            ISTEPN='52'
            IF(IBUGA2.EQ.'ON' .OR. ISUBRO.EQ.'CONF')THEN
              CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
              WRITE(ICOUT,999)
              CALL DPWRST('XXX','BUG ')
              WRITE(ICOUT,411)
 411          FORMAT('***** FROM DPCONF, BEFORE CALL DPCNF2--')
              CALL DPWRST('XXX','BUG ')
              WRITE(ICOUT,412)I,J,NS1,NS2,MAXN
 412          FORMAT('I,J,NS1,NS2,MAXN = ',5I8)
              CALL DPWRST('XXX','BUG ')
              DO415II=1,MAX(NS1,NS2)
                WRITE(ICOUT,416)II,Y(II),X(II)
 416            FORMAT('I,Y(I),X(I) = ',I8,2G15.7)
                CALL DPWRST('XXX','BUG ')
 415          CONTINUE
            ENDIF
C
            IVARID(1)=IVARN1(I)
            IVARI2(1)=IVARN2(I)
            IVARID(2)=IVARN1(J)
            IVARI2(2)=IVARN2(J)
            CALL DPCNF2(Y,NS1,X,NS2,
     1                  XTEMP1,XTEMP2,MAXNXT,
     1                  PID,IVARID,IVARI2,NREPL,
     1                  CUTL90,CUTU90,CUTL95,CUTU95,CUTL99,CUTU99,
     1                  ICAPSW,ICAPTY,IFORSW,ICASAN,ICASA2,
     1                  ISUBRO,IBUGA3,IERROR)
C
C               ***************************************
C               **  STEP 8C--                        **
C               **  UPDATE INTERNAL DATAPLOT TABLES  **
C               ***************************************
C
            ISTEPN='8C'
            IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'CNF2')
     1        CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
            IF(NUMVAR.GT.2)THEN
              IFLAGU='FILE'
            ELSE
              IFLAGU='ON'
            ENDIF
            IFRST=.FALSE.
            ILAST=.FALSE.
            IF(I.EQ.1 .AND. J.EQ.2)IFRST=.TRUE.
            IF(I.EQ.NUMVAR .AND. J.EQ.NUMVAR)ILAST=.TRUE.
            CALL DPCNF3(CUTL90,CUTU90,CUTL95,CUTU95,CUTL99,CUTU99,
     1                  IFLAGU,IFRST,ILAST,ICASAN,
     1                  IBUGA2,IBUGA3,ISUBRO,IERROR)
C
 420        CONTINUE
 410      CONTINUE
C
      ELSEIF(IREPL.EQ.'ON')THEN
        ISTEPN='5A'
        IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'CONF')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
        J=0
        IMAX=NRIGHT(1)
        IF(NQ.LT.NRIGHT(1))IMAX=NQ
        DO510I=1,IMAX
          IF(ISUB(I).EQ.0)GOTO510
          J=J+1
C
C         RESPONSE VARIABLE IN Y
C
          ICOLC=1
          IJ=MAXN*(ICOLR(ICOLC)-1)+I
          IF(ICOLR(ICOLC).LE.MAXCOL)Y(J)=V(IJ)
          IF(ICOLR(ICOLC).EQ.MAXCP1)Y(J)=PRED(I)
          IF(ICOLR(ICOLC).EQ.MAXCP2)Y(J)=RES(I)
          IF(ICOLR(ICOLC).EQ.MAXCP3)Y(J)=YPLOT(I)
          IF(ICOLR(ICOLC).EQ.MAXCP4)Y(J)=XPLOT(I)
          IF(ICOLR(ICOLC).EQ.MAXCP5)Y(J)=X2PLOT(I)
          IF(ICOLR(ICOLC).EQ.MAXCP6)Y(J)=TAGPLO(I)
C
C         SECOND RESPONSE VARIABLE FOR DIFFERENCE OF MEANS CASE
C
          IF(ICASAN.EQ.'TWOV')THEN
            ICOLC=ICOLC+1
            ICOLT=ICOLR(ICOLC)
            IJ=MAXN*(ICOLT-1)+I
            IF(ICOLT.LE.MAXCOL)X(J)=V(IJ)
            IF(ICOLT.EQ.MAXCP1)X(J)=PRED(I)
            IF(ICOLT.EQ.MAXCP2)X(J)=RES(I)
            IF(ICOLT.EQ.MAXCP3)X(J)=YPLOT(I)
            IF(ICOLT.EQ.MAXCP4)X(J)=XPLOT(I)
            IF(ICOLT.EQ.MAXCP5)X(J)=X2PLOT(I)
            IF(ICOLT.EQ.MAXCP6)X(J)=TAGPLO(I)
          ELSE
            X(J)=0.0
          ENDIF
C
          IF(NREPL.GE.1)THEN
            DO520IR=1,MIN(NREPL,6)
              ICOLC=ICOLC+1
              ICOLT=ICOLR(ICOLC)
              IJ=MAXN*(ICOLT-1)+I
              IF(ICOLT.LE.MAXCOL)XDESGN(J,IR)=V(IJ)
              IF(ICOLT.EQ.MAXCP1)XDESGN(J,IR)=PRED(I)
              IF(ICOLT.EQ.MAXCP2)XDESGN(J,IR)=RES(I)
              IF(ICOLT.EQ.MAXCP3)XDESGN(J,IR)=YPLOT(I)
              IF(ICOLT.EQ.MAXCP4)XDESGN(J,IR)=XPLOT(I)
              IF(ICOLT.EQ.MAXCP5)XDESGN(J,IR)=X2PLOT(I)
              IF(ICOLT.EQ.MAXCP6)XDESGN(J,IR)=TAGPLO(I)
  520       CONTINUE
          ENDIF
C
  510   CONTINUE
        NLOCAL=J
C
        ISTEPN='5B'
        IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'CONF')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
        PID(1)=CPUMIN
        IVARID(1)=IVARN1(1)
        IVARI2(1)=IVARN2(1)
        IADD=1
        IF(ICASAN.EQ.'TWOV')THEN
          IADD=2
          PID(2)=CPUMIN
          IVARID(2)=IVARN1(2)
          IVARI2(2)=IVARN2(2)
        ENDIF
        DO540II=1,NREPL
          IVARID(II+IADD)=IVARN1(II+IADD)
          IVARI2(II+IADD)=IVARN2(II+IADD)
          IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'CONF')THEN
            WRITE(ICOUT,532)IADD,II,IVARID(II+IADD),IVARN1(II+IADD)
  532       FORMAT('IADD,II,IVARID(II+IADD),IVARN1(II+IADD) = ',
     1             2I8,A4,2X,A4)
          CALL DPWRST('XXX','BUG ')
          ENDIF
  540   CONTINUE
C
C       *****************************************************
C       **  STEP 5C--                                      **
C       **                                                 **
C       **  FOR THIS CASE, WE NEED TO LOOP THROUGH THE     **
C       **  VARIOUS REPLICATIONS.                          **
C       *****************************************************
C
        ISTEPN='5C'
        IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'CONF')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
        IF(IBUGA2.EQ.'ON' .OR. ISUBRO.EQ.'CONF')THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,541)
  541     FORMAT('***** FROM THE MIDDLE  OF DPCONF--')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,542)ICASAN,NUMVAR,NLOCAL,NLOCA2,NREPL
  542     FORMAT('ICASAN,NUMVAR,NLOCAL,NLOCA2,NREPL = ',A4,2X,4I8)
          CALL DPWRST('XXX','BUG ')
          IF(NLOCAL.GE.1)THEN
            DO545I=1,NLOCAL
              WRITE(ICOUT,546)I,Y(I),X(I),XDESGN(I,1),XDESGN(I,2)
  546         FORMAT('I,Y(I),X(I),XDESGN(I,1),XDESGN(I,2) = ',
     1               I8,4F12.5)
              CALL DPWRST('XXX','BUG ')
  545       CONTINUE
          ENDIF
        ENDIF
C
C       *****************************************************
C       **  STEP 5C--                                      **
C       **  FIND THE DISTINCT VALUES IN EACH OF THE        **
C       **  REPLICATION VARIABLES.                         **
C       *****************************************************
C
        CALL DPPP5(XDESGN(1,1),XDESGN(1,2),XDESGN(1,3),
     1             XDESGN(1,4),XDESGN(1,5),XDESGN(1,6),
     1             NREPL,NLOCAL,MAXOBV,
     1             XIDTEM,XIDTE2,XIDTE3,XIDTE4,XIDTE5,XIDTE6,
     1             XTEMP1,XTEMP2,
     1             NUMSE1,NUMSE2,NUMSE3,NUMSE4,NUMSE5,NUMSE6,
     1             IBUGA3,ISUBRO,IERROR)
C
C       *****************************************************
C       **  STEP 5D--                                      **
C       **  NOW LOOP THROUGH THE VARIOUS REPLICATIONS      **
C       *****************************************************
C
        NPLOTP=0
        NCURVE=0
        IF(NREPL.EQ.1)THEN
          J=0
          DO1110ISET1=1,NUMSE1
            K=0
            PID(IADD+1)=XIDTEM(ISET1)
            DO1130I=1,NLOCAL
              IF(XIDTEM(ISET1).EQ.XDESGN(I,1))THEN
                K=K+1
                TEMP1(K)=Y(I)
                TEMP2(K)=X(I)
              ENDIF
 1130       CONTINUE
            NTEMP=K
            NCURVE=NCURVE+1
            IF(NTEMP.GT.0)THEN
              CALL DPCNF2(TEMP1,NTEMP,TEMP2,NTEMP,
     1                    XTEMP1,XTEMP2,MAXNXT,
     1                    PID,IVARID,IVARI2,NREPL,
     1                    CUTL90,CUTU90,CUTL95,CUTU95,CUTL99,CUTU99,
     1                    ICAPSW,ICAPTY,IFORSW,ICASAN,ICASA2,
     1                    ISUBRO,IBUGA3,IERROR)
            ENDIF
C
            IFLAGU='FILE'
            IFRST=.FALSE.
            ILAST=.FALSE.
            IF(NCURVE.EQ.1)IFRST=.TRUE.
            IF(NCURVE.EQ.NUMSE1)ILAST=.TRUE.
            CALL DPCNF3(CUTL90,CUTU90,CUTL95,CUTU95,CUTL99,CUTU99,
     1                  IFLAGU,IFRST,ILAST,ICASAN,
     1                  IBUGA2,IBUGA3,ISUBRO,IERROR)
 1110     CONTINUE
        ELSEIF(NREPL.EQ.2)THEN
          J=0
          NTOT=NUMSE1*NUMSE2
          DO1210ISET1=1,NUMSE1
          DO1220ISET2=1,NUMSE2
            K=0
            PID(1+IADD)=XIDTEM(ISET1)
            PID(2+IADD)=XIDTE2(ISET2)
            DO1290I=1,NLOCAL
              IF(
     1           XIDTEM(ISET1).EQ.XDESGN(I,1) .AND.
     1           XIDTE2(ISET2).EQ.XDESGN(I,2)
     1          )THEN
                K=K+1
                TEMP1(K)=Y(I)
                TEMP2(K)=X(I)
              ENDIF
 1290       CONTINUE
            NTEMP=K
            NCURVE=NCURVE+1
            NPLOT1=NPLOTP
            IF(NTEMP.GT.0)THEN
              CALL DPCNF2(TEMP1,NTEMP,TEMP2,NTEMP,
     1                    XTEMP1,XTEMP2,MAXNXT,
     1                    PID,IVARID,IVARI2,NREPL,
     1                    CUTL90,CUTU90,CUTL95,CUTU95,CUTL99,CUTU99,
     1                    ICAPSW,ICAPTY,IFORSW,ICASAN,ICASA2,
     1                    ISUBRO,IBUGA3,IERROR)
            ENDIF
            NPLOT2=NPLOTP
            IFLAGU='FILE'
            IFRST=.FALSE.
            ILAST=.FALSE.
            IF(NCURVE.EQ.1)IFRST=.TRUE.
            IF(NCURVE.EQ.NTOT)ILAST=.TRUE.
            CALL DPCNF3(CUTL90,CUTU90,CUTL95,CUTU95,CUTL99,CUTU99,
     1                  IFLAGU,IFRST,ILAST,ICASAN,
     1                  IBUGA2,IBUGA3,ISUBRO,IERROR)
 1220     CONTINUE
 1210     CONTINUE
        ELSEIF(NREPL.EQ.3)THEN
          J=0
          NTOT=NUMSE1*NUMSE2*NUMSE3
          DO1310ISET1=1,NUMSE1
          DO1320ISET2=1,NUMSE2
          DO1330ISET3=1,NUMSE3
            K=0
            PID(1+IADD)=XIDTEM(ISET1)
            PID(2+IADD)=XIDTE2(ISET2)
            PID(3+IADD)=XIDTE3(ISET3)
            DO1390I=1,NLOCAL
              IF(
     1           XIDTEM(ISET1).EQ.XDESGN(I,1) .AND.
     1           XIDTE2(ISET2).EQ.XDESGN(I,2) .AND.
     1           XIDTE3(ISET3).EQ.XDESGN(I,3)
     1          )THEN
                K=K+1
                TEMP1(K)=Y(I)
                TEMP2(K)=X(I)
              ENDIF
 1390       CONTINUE
            NTEMP=K
            NCURVE=NCURVE+1
            IF(NTEMP.GT.0)THEN
              CALL DPCNF2(TEMP1,NTEMP,TEMP2,NTEMP,
     1                    XTEMP1,XTEMP2,MAXNXT,
     1                    PID,IVARID,IVARI2,NREPL,
     1                    CUTL90,CUTU90,CUTL95,CUTU95,CUTL99,CUTU99,
     1                    ICAPSW,ICAPTY,IFORSW,ICASAN,ICASA2,
     1                    ISUBRO,IBUGA3,IERROR)
            ENDIF
            IFLAGU='FILE'
            IFRST=.FALSE.
            ILAST=.FALSE.
            IF(NCURVE.EQ.1)IFRST=.TRUE.
            IF(NCURVE.EQ.NTOT)ILAST=.TRUE.
            CALL DPCNF3(CUTL90,CUTU90,CUTL95,CUTU95,CUTL99,CUTU99,
     1                  IFLAGU,IFRST,ILAST,ICASAN,
     1                  IBUGA2,IBUGA3,ISUBRO,IERROR)
 1330     CONTINUE
 1320     CONTINUE
 1310     CONTINUE
        ELSEIF(NREPL.EQ.4)THEN
          J=0
          NTOT=NUMSE1*NUMSE2*NUMSE3*NUMSE4
          DO1410ISET1=1,NUMSE1
          DO1420ISET2=1,NUMSE2
          DO1430ISET3=1,NUMSE3
          DO1440ISET4=1,NUMSE4
            K=0
            PID(1+IADD)=XIDTEM(ISET1)
            PID(2+IADD)=XIDTE2(ISET2)
            PID(3+IADD)=XIDTE3(ISET3)
            PID(4+IADD)=XIDTE4(ISET4)
            DO1490I=1,NLOCAL
              IF(
     1           XIDTEM(ISET1).EQ.XDESGN(I,1) .AND.
     1           XIDTE2(ISET2).EQ.XDESGN(I,2) .AND.
     1           XIDTE3(ISET3).EQ.XDESGN(I,3) .AND.
     1           XIDTE4(ISET4).EQ.XDESGN(I,4)
     1          )THEN
                K=K+1
                TEMP1(K)=Y(I)
                TEMP2(K)=X(I)
              ENDIF
 1490       CONTINUE
            NTEMP=K
            NCURVE=NCURVE+1
            IF(NTEMP.GT.0)THEN
              CALL DPCNF2(TEMP1,NTEMP,TEMP2,NTEMP,
     1                    XTEMP1,XTEMP2,MAXNXT,
     1                    PID,IVARID,IVARI2,NREPL,
     1                    CUTL90,CUTU90,CUTL95,CUTU95,CUTL99,CUTU99,
     1                    ICAPSW,ICAPTY,IFORSW,ICASAN,ICASA2,
     1                    ISUBRO,IBUGA3,IERROR)
            ENDIF
            IFLAGU='FILE'
            IFRST=.FALSE.
            ILAST=.FALSE.
            IF(NCURVE.EQ.1)IFRST=.TRUE.
            IF(NCURVE.EQ.NTOT)ILAST=.TRUE.
            CALL DPCNF3(CUTL90,CUTU90,CUTL95,CUTU95,CUTL99,CUTU99,
     1                  IFLAGU,IFRST,ILAST,ICASAN,
     1                  IBUGA2,IBUGA3,ISUBRO,IERROR)
 1440     CONTINUE
 1430     CONTINUE
 1420     CONTINUE
 1410     CONTINUE
        ELSEIF(NREPL.EQ.5)THEN
          J=0
          NTOT=NUMSE1*NUMSE2*NUMSE3*NUMSE4*NUMSE5
          DO1510ISET1=1,NUMSE1
          DO1520ISET2=1,NUMSE2
          DO1530ISET3=1,NUMSE3
          DO1540ISET4=1,NUMSE4
          DO1550ISET5=1,NUMSE5
            K=0
            PID(1+IADD)=XIDTEM(ISET1)
            PID(2+IADD)=XIDTE2(ISET2)
            PID(3+IADD)=XIDTE3(ISET3)
            PID(4+IADD)=XIDTE4(ISET4)
            PID(5+IADD)=XIDTE5(ISET4)
            DO1590I=1,NLOCAL
              IF(
     1           XIDTEM(ISET1).EQ.XDESGN(I,1) .AND.
     1           XIDTE2(ISET2).EQ.XDESGN(I,2) .AND.
     1           XIDTE3(ISET3).EQ.XDESGN(I,3) .AND.
     1           XIDTE4(ISET4).EQ.XDESGN(I,4) .AND.
     1           XIDTE5(ISET5).EQ.XDESGN(I,5)
     1          )THEN
                K=K+1
                TEMP1(K)=Y(I)
                TEMP2(K)=X(I)
              ENDIF
 1590       CONTINUE
            NTEMP=K
            NCURVE=NCURVE+1
            IF(NTEMP.GT.0)THEN
              CALL DPCNF2(TEMP1,NTEMP,TEMP2,NTEMP,
     1                    XTEMP1,XTEMP2,MAXNXT,
     1                    PID,IVARID,IVARI2,NREPL,
     1                    CUTL90,CUTU90,CUTL95,CUTU95,CUTL99,CUTU99,
     1                    ICAPSW,ICAPTY,IFORSW,ICASAN,ICASA2,
     1                    ISUBRO,IBUGA3,IERROR)
            ENDIF
            IFLAGU='FILE'
            IFRST=.FALSE.
            ILAST=.FALSE.
            IF(NCURVE.EQ.1)IFRST=.TRUE.
            IF(NCURVE.EQ.NTOT)ILAST=.TRUE.
            CALL DPCNF3(CUTL90,CUTU90,CUTL95,CUTU95,CUTL99,CUTU99,
     1                  IFLAGU,IFRST,ILAST,ICASAN,
     1                  IBUGA2,IBUGA3,ISUBRO,IERROR)
 1550     CONTINUE
 1540     CONTINUE
 1530     CONTINUE
 1520     CONTINUE
 1510     CONTINUE
        ELSEIF(NREPL.EQ.6)THEN
          J=0
          NTOT=NUMSE1*NUMSE2*NUMSE3*NUMSE4*NUMSE5*NUMSE6
          DO1610ISET1=1,NUMSE1
          DO1620ISET2=1,NUMSE2
          DO1630ISET3=1,NUMSE3
          DO1640ISET4=1,NUMSE4
          DO1650ISET5=1,NUMSE5
          DO1660ISET6=1,NUMSE6
            K=0
            PID(1+IADD)=XIDTEM(ISET1)
            PID(2+IADD)=XIDTE2(ISET2)
            PID(3+IADD)=XIDTE3(ISET3)
            PID(4+IADD)=XIDTE4(ISET4)
            PID(5+IADD)=XIDTE5(ISET4)
            PID(6+IADD)=XIDTE6(ISET4)
            DO1690I=1,NLOCAL
              IF(
     1           XIDTEM(ISET1).EQ.XDESGN(I,1) .AND.
     1           XIDTE2(ISET2).EQ.XDESGN(I,2) .AND.
     1           XIDTE3(ISET3).EQ.XDESGN(I,3) .AND.
     1           XIDTE4(ISET4).EQ.XDESGN(I,4) .AND.
     1           XIDTE5(ISET5).EQ.XDESGN(I,5) .AND.
     1           XIDTE6(ISET6).EQ.XDESGN(I,6)
     1          )THEN
                K=K+1
                TEMP1(K)=Y(I)
                TEMP2(K)=X(I)
              ENDIF
 1690       CONTINUE
            NTEMP=K
            NCURVE=NCURVE+1
            IF(NTEMP.GT.0)THEN
              CALL DPCNF2(TEMP1,NTEMP,TEMP2,NTEMP,
     1                    XTEMP1,XTEMP2,MAXNXT,
     1                    PID,IVARID,IVARI2,NREPL,
     1                    CUTL90,CUTU90,CUTL95,CUTU95,CUTL99,CUTU99,
     1                    ICAPSW,ICAPTY,IFORSW,ICASAN,ICASA2,
     1                    ISUBRO,IBUGA3,IERROR)
            ENDIF
            IFLAGU='FILE'
            IFRST=.FALSE.
            ILAST=.FALSE.
            IF(NCURVE.EQ.1)IFRST=.TRUE.
            IF(NCURVE.EQ.NTOT)ILAST=.TRUE.
            CALL DPCNF3(CUTL90,CUTU90,CUTL95,CUTU95,CUTL99,CUTU99,
     1                  IFLAGU,IFRST,ILAST,ICASAN,
     1                  IBUGA2,IBUGA3,ISUBRO,IERROR)
 1660     CONTINUE
 1650     CONTINUE
 1640     CONTINUE
 1630     CONTINUE
 1620     CONTINUE
 1610     CONTINUE
        ENDIF
C
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA2.EQ.'ON' .OR. ISUBRO.EQ.'CONF')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPCONF--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9014)NRIGHT(1),NRIGHT(2)
 9014   FORMAT('NRIGHT(1),NRIGHT(2) = ',2I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9016)IFOUND,IERROR
 9016   FORMAT('IFOUND,IERROR = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPCONH(IVAL,VAL,IH,NH,IBUGD2,IERROR)
C
C     NOTE--THIS SUBROUTINE IS IDENTICAL TO DPCON2.
C           IT HAS BEEN DUPLICATED AND PLACED
C           ON THIS BRANCH OF THE OVERLAY/SEGMENTATION
C           TREE STRUCTURE IN ORDER TO ACHIEVE
C           FASTER EXECUTION TIME.
C
C     NOTE--UPON INPUT, IVALUE IS USUALLY INT(VALUE+0.5), BUT
C       FOR NEGATIVE VALUE, IVALUE SHOULD BE INT(VALUE-0.5)
C
C     PURPOSE--CONVERT NUMERIC VALUE INTO CORRESPONDING
C              CHARACTER STRING.
C
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--MARCH   1983.
C     UPDATED         --JANUARY  2000. SUPPORT FOR EXPONENTIAL
C                                      EXPANSION (THIS IS PRIMARILY
C                                      FOR USE WITH THE FIT COMMAND)
C     UPDATED         --FEBRUARY 2005. SUPPORT FOR "SET PARAMETER
C                                      EXPAND DIGITS"
C     UPDATED         --FEBRUARY  2011. FIX TO EXTEND THE PRECISION
C                                       A FEW EXTRA PLACES
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IH
      CHARACTER*4 IBUGD2
      CHARACTER*4 IERROR
C
      CHARACTER*4 IHREM
      CHARACTER*4 IHNUM
      CHARACTER*4 IHTEMI
      CHARACTER*4 IHTEMD
C
      CHARACTER*25 IJUNK
      CHARACTER*10 IFORMT
C
      DIMENSION IH(*)
      DIMENSION IHTEMI(10)
      DIMENSION IHTEMD(10)
C
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOST.INC'
      INCLUDE 'DPCOBE.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----DATA STATEMENTS-------------------------------------------------
C
C-----START POINT---------------------------------------------------------
C
      AINUM=0.0
      FRACT=0.0
      NUMDID=0
C
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'CONH')GOTO90
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF DPCONH--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IVAL,VAL
   52 FORMAT('IVAL,VAL = ',I8,E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,59)IBUGG4,ISUBG4,IERRG4
   59 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
      IF(IEXPPA.EQ.'EXPO')THEN
        IJUNK=' '
        WRITE(IJUNK,'(D20.12)')DBLE(VAL)
        NH=1
        IH(1)='('
        DO1010I=1,20
          IF(IJUNK(I:I).EQ.'D')THEN
            DO1020J=1,MAX(1,I-1)
              IF(IJUNK(J:J).EQ.' ')GOTO1020
              NH=NH+1
              IH(NH)=IJUNK(J:J)
 1020       CONTINUE
            IPOS=I+1
            GOTO1019
          ENDIF
 1010   CONTINUE
 1019   CONTINUE
C
        NH=NH+1
        IH(NH)='*'
        NH=NH+1
        IH(NH)='1'
        NH=NH+1
        IH(NH)='0'
        NH=NH+1
        IH(NH)='*'
        NH=NH+1
        IH(NH)='*'
        NH=NH+1
        IH(NH)='('
        DO1040I=IPOS,20
          IF(IJUNK(I:I).EQ.' ')GOTO1040
          NH=NH+1
          IH(NH)=IJUNK(I:I)
 1040   CONTINUE
C
        NH=NH+1
        IH(NH)=')'
        NH=NH+1
        IH(NH)=')'
        GOTO9000
      ELSEIF(IEXPDI.GT.0)THEN
C
        IJUNK=' '
        IFORMT=' '
        IFORMT(1:8)='(F  .  )'
        NJUNK=IEXPDI
        IF(NJUNK.GT.9)NJUNK=9
        WRITE(IFORMT(6:7),'(I2)')NJUNK
        NJUNK=NJUNK+8
        WRITE(IFORMT(3:4),'(I2)')NJUNK
        WRITE(IJUNK,IFORMT)VAL
C
        NH=0
        DO1050I=1,NJUNK
          IF(NH.EQ.0 .AND. IJUNK(I:I).EQ.' ')GOTO1050
          NH=NH+1
          IH(NH)=IJUNK(I:I)
 1050   CONTINUE
        GOTO9000
      ELSEIF(IEXPDI.EQ.0)THEN
C
        IJUNK=' '
        IFORMT=' '
        IFORMT(1:5)='(I15)'
        WRITE(IJUNK,IFORMT)INT(VAL+0.5)
C
        NH=0
        DO1060I=1,15
          IF(NH.EQ.0 .AND. IJUNK(I:I).EQ.' ')GOTO1060
          NH=NH+1
          IH(NH)=IJUNK(I:I)
 1060   CONTINUE
        GOTO9000
      ENDIF
C
      ABSVAL=ABS(VAL)
C
      AIVAL=IVAL
      DEL=AIVAL-VAL
      ABSDEL=ABS(DEL)
C
      ABSRAT=ABSDEL
      IF(ABSVAL.GE.1.0)ABSRAT=ABSDEL/ABSVAL
C
CCCCC CUTDEL=10.0**(-16)
      CUTDEL=10.0**(-6)
      CUTRAT=10.0**(-6)
C
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'CONH')GOTO919
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,911)
  911 FORMAT('***** FROM THE MIDDLE OF DPCONH--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,912)ABSVAL
  912 FORMAT('ABSVAL = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,913)VAL,IVAL,AIVAL,DEL,ABSDEL
  913 FORMAT('VAL,IVAL,AIVAL,DEL,ABSDEL = ',E15.7,I8,3E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,914)ABSDEL,CUTDEL
  914 FORMAT('ABSDEL,CUTDEL = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,915)ABSRAT,CUTRAT
  915 FORMAT('ABSRAT,CUTRAT = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
  919 CONTINUE
C
      IF(ABSVAL.LT.1.0.AND.ABSDEL.LE.CUTDEL)GOTO1000
      IF(ABSVAL.GE.1.0.AND.ABSRAT.LE.CUTRAT)GOTO1000
      GOTO2000
C
C               ******************************
C               **  STEP XX--               **
C               **  TREAT THE INTEGER CASE  **
C               ******************************
C
 1000 CONTINUE
C
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'CONH')WRITE(ICOUT,1005)
 1005 FORMAT('*****INTEGER CASE*****')
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'CONH')CALL DPWRST('XXX','BUG ')
C
      INUM=IABS(IVAL)
      NUMDII=0
      IF(INUM.EQ.0)NUMDII=NUMDII+1
      IF(INUM.EQ.0)IHTEMI(NUMDII)='0'
      IF(INUM.EQ.0)GOTO1190
C
      DO1100I=1,10
      IF(INUM.LE.0)GOTO1190
      IRATIO=INUM/10
      IREM=INUM-10*IRATIO
      INUM=IRATIO
      NUMDII=NUMDII+1
      CALL DPCODH(IREM,IHREM,IBUGD2,IERROR)
      IHTEMI(NUMDII)=IHREM
 1100 CONTINUE
 1190 CONTINUE
      IF(IVAL.LT.0)NUMDII=NUMDII+1
      IF(IVAL.LT.0)IHTEMI(NUMDII)='-'
C
      NH=NUMDII
      IF(NUMDII.LE.0)GOTO1290
      DO1200I=1,NUMDII
      IREV=NUMDII-I+1
      IH(I)=IHTEMI(IREV)
 1200 CONTINUE
 1290 CONTINUE
C
      GOTO9000
C
C               **********************************
C               **  STEP XX--                   **
C               **  TREAT THE NON-INTEGER CASE  **
C               **********************************
C
 2000 CONTINUE
C
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'CONH')WRITE(ICOUT,2005)
 2005 FORMAT('*****NON-INTEGER CASE*****')
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'CONH')CALL DPWRST('XXX','BUG ')
C
      INUM=ABSVAL
      AINUM=INUM
      FRACT=ABSVAL-AINUM
C
      NUMDII=0
      IF(INUM.EQ.0)NUMDII=NUMDII+1
      IF(INUM.EQ.0)IHTEMI(NUMDII)='0'
      IF(INUM.EQ.0)GOTO2190
C
      DO2100I=1,10
      IF(INUM.LE.0)GOTO2190
      IRATIO=INUM/10
      IREM=INUM-10*IRATIO
      INUM=IRATIO
      NUMDII=NUMDII+1
      CALL DPCODH(IREM,IHREM,IBUGD2,IERROR)
      IHTEMI(NUMDII)=IHREM
 2100 CONTINUE
 2190 CONTINUE
      IF(VAL.LT.0)NUMDII=NUMDII+1
      IF(VAL.LT.0)IHTEMI(NUMDII)='-'
C
      NUMDID=0
      IF(FRACT.EQ.0.0)NUMDID=0
      IF(FRACT.EQ.0.0)GOTO2390
C
      ANUM=FRACT
CCCCC NOTE 2011/2: ADD A FEW EXTRA DIGITS OF PRECISION
CCCCC NLOOP=8-NUMDII
      NLOOP=12-NUMDII
CCCCC CUTOF2=10.0**(-NLOOP+1)
CCCCC CUTOF3=1.0-CUTOF2
      IF(NLOOP.LE.0)GOTO2390
      DO2300I=1,NLOOP
      CUTOF2=10.0**(-NLOOP+I+1)
      CUTOF3=1.0-CUTOF2
      ANUM=ANUM*10.0
      INUM=INT(ANUM)
      AINUM=REAL(INUM)
      DEL3=ANUM-AINUM
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'CONH')WRITE(ICOUT,2311)
     1NLOOP,I,CUTOF3,CUTOF2
 2311 FORMAT('NLOOP,I,CUTOF3,CUTOF2 = ',I8,I8,2E15.7)
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'CONH')CALL DPWRST('XXX','BUG ')
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'CONH')WRITE(ICOUT,2312)
     1ANUM,AINUM,DEL3,CUTOF3
 2312 FORMAT('ANUM,AINUM,DEL3,CUTOF3 = ',4E15.7)
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'CONH')CALL DPWRST('XXX','BUG ')
      IF(CUTOF3.GT.0.0000001)THEN
        IF(DEL3.GE.CUTOF3)INUM=INUM+1
        IF(DEL3.GE.CUTOF3)ANUM=INUM
      ELSE
        IF(DEL3.GE.0.5)INUM=INUM+1
        IF(DEL3.GE.0.5)ANUM=INUM
      ENDIF
      NUMDID=NUMDID+1
      CALL DPCODH(INUM,IHNUM,IBUGD2,IERROR)
      IHTEMD(NUMDID)=IHNUM
      AINUM=INUM
      DEL2=ANUM-AINUM
      ANUM=DEL2
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'CONH')WRITE(ICOUT,2313)
     1ANUM,AINUM,DEL2,CUTOF2
 2313 FORMAT('ANUM,AINUM,DEL2,CUTOF2 = ',4E15.7)
      IF(IBUGG4.EQ.'ON'.OR.ISUBG4.EQ.'CONH')CALL DPWRST('XXX','BUG ')
      IF(DEL2.LE.CUTOF2)GOTO2390
 2300 CONTINUE
 2390 CONTINUE
C
      NH=0
      IF(NUMDII.LE.0)GOTO2490
      DO2400I=1,NUMDII
      NH=NH+1
      IREV=NUMDII-I+1
      IH(NH)=IHTEMI(IREV)
 2400 CONTINUE
 2490 CONTINUE
C
      NH=NH+1
      IH(NH)='.'
C
      IF(NUMDID.LE.0)GOTO2590
      DO2500I=1,NUMDID
      NH=NH+1
      IH(NH)=IHTEMD(I)
 2500 CONTINUE
 2590 CONTINUE
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'CONH')GOTO9090
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF DPCONH--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IVAL,VAL
 9012 FORMAT('IVAL,VAL = ',I8,E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)AIVAL,VAL,DEL,ABSDEL,CUTDEL
 9013 FORMAT('AIVAL,VAL,DEL,ABSDEL,CUTDEL = ',5E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)ABSVAL,INUM,AINUM,FRACT
 9014 FORMAT('ABSVAL,INUM,AINUM,FRACT = ',E15.7,2X,I8,2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)NUMDII
 9015 FORMAT('NUMDII = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9016)(IHTEMI(I),I=1,NUMDII)
 9016 FORMAT('(IHTEMI(I),I=1,NUMDII) = ',20A1)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9025)NUMDID
 9025 FORMAT('NUMDID = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9026)(IHTEMD(I),I=1,NUMDID)
 9026 FORMAT('(IHTEMD(I),I=1,NUMDID) = ',20A1)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9031)NH
 9031 FORMAT('NH = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9032)(IH(I),I=1,NH)
 9032 FORMAT('(IH(I),I=1,NH) = ',20A1)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9039)IBUGG4,ISUBG4,IERRG4
 9039 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPCONX(IX,IC)
C
C     PURPOSE--CONVERT IX = INTEGER IN INTERVAL 0 - 255 TO
C              HEX EQUIVALENT (CHARACTER*2).
C              USE BUILT TABLE FOR PEFORMANCE.
C
C
C     WRITTEN BY--JAMES J. FILLIBEN
C     LANGUAGE--ANSI FORTRAN (1977)
C     ORIGINAL VERSION--MARCH     2002.
C
C--------------------------------------------------------------------
C
      CHARACTER*2 IC
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      CHARACTER*2 HEXTAB(256)
C
C-----DATA STATEMENTS-------------------------------------------------
C
C     DATA STATEMENTS FOR IBM EBCDIC COMPUTERS
C
      DATA HEXTAB(  1) /'00'/
      DATA HEXTAB(  2) /'01'/
      DATA HEXTAB(  3) /'02'/
      DATA HEXTAB(  4) /'03'/
      DATA HEXTAB(  5) /'04'/
      DATA HEXTAB(  6) /'05'/
      DATA HEXTAB(  7) /'06'/
      DATA HEXTAB(  8) /'07'/
      DATA HEXTAB(  9) /'08'/
      DATA HEXTAB( 10) /'09'/
      DATA HEXTAB( 11) /'0A'/
      DATA HEXTAB( 12) /'0B'/
      DATA HEXTAB( 13) /'0C'/
      DATA HEXTAB( 14) /'0D'/
      DATA HEXTAB( 15) /'0E'/
      DATA HEXTAB( 16) /'0F'/
      DATA HEXTAB( 17) /'10'/
      DATA HEXTAB( 18) /'11'/
      DATA HEXTAB( 19) /'12'/
      DATA HEXTAB( 20) /'13'/
      DATA HEXTAB( 21) /'14'/
      DATA HEXTAB( 22) /'15'/
      DATA HEXTAB( 23) /'16'/
      DATA HEXTAB( 24) /'17'/
      DATA HEXTAB( 25) /'18'/
      DATA HEXTAB( 26) /'19'/
      DATA HEXTAB( 27) /'1A'/
      DATA HEXTAB( 28) /'1B'/
      DATA HEXTAB( 29) /'1C'/
      DATA HEXTAB( 30) /'1D'/
      DATA HEXTAB( 31) /'1E'/
      DATA HEXTAB( 32) /'1F'/
      DATA HEXTAB( 33) /'20'/
      DATA HEXTAB( 34) /'21'/
      DATA HEXTAB( 35) /'22'/
      DATA HEXTAB( 36) /'23'/
      DATA HEXTAB( 37) /'24'/
      DATA HEXTAB( 38) /'25'/
      DATA HEXTAB( 39) /'26'/
      DATA HEXTAB( 40) /'27'/
      DATA HEXTAB( 41) /'28'/
      DATA HEXTAB( 42) /'29'/
      DATA HEXTAB( 43) /'2A'/
      DATA HEXTAB( 44) /'2B'/
      DATA HEXTAB( 45) /'2C'/
      DATA HEXTAB( 46) /'2D'/
      DATA HEXTAB( 47) /'2E'/
      DATA HEXTAB( 48) /'2F'/
      DATA HEXTAB( 49) /'30'/
      DATA HEXTAB( 50) /'31'/
      DATA HEXTAB( 51) /'32'/
      DATA HEXTAB( 52) /'33'/
      DATA HEXTAB( 53) /'34'/
      DATA HEXTAB( 54) /'35'/
      DATA HEXTAB( 55) /'36'/
      DATA HEXTAB( 56) /'37'/
      DATA HEXTAB( 57) /'38'/
      DATA HEXTAB( 58) /'39'/
      DATA HEXTAB( 59) /'3A'/
      DATA HEXTAB( 60) /'3B'/
      DATA HEXTAB( 61) /'3C'/
      DATA HEXTAB( 62) /'3D'/
      DATA HEXTAB( 63) /'3E'/
      DATA HEXTAB( 64) /'3F'/
      DATA HEXTAB( 65) /'40'/
      DATA HEXTAB( 66) /'41'/
      DATA HEXTAB( 67) /'42'/
      DATA HEXTAB( 68) /'43'/
      DATA HEXTAB( 69) /'44'/
      DATA HEXTAB( 70) /'45'/
      DATA HEXTAB( 71) /'46'/
      DATA HEXTAB( 72) /'47'/
      DATA HEXTAB( 73) /'48'/
      DATA HEXTAB( 74) /'49'/
      DATA HEXTAB( 75) /'4A'/
      DATA HEXTAB( 76) /'4B'/
      DATA HEXTAB( 77) /'4C'/
      DATA HEXTAB( 78) /'4D'/
      DATA HEXTAB( 79) /'4E'/
      DATA HEXTAB( 80) /'4F'/
      DATA HEXTAB( 81) /'50'/
      DATA HEXTAB( 82) /'51'/
      DATA HEXTAB( 83) /'52'/
      DATA HEXTAB( 84) /'53'/
      DATA HEXTAB( 85) /'54'/
      DATA HEXTAB( 86) /'55'/
      DATA HEXTAB( 87) /'56'/
      DATA HEXTAB( 88) /'57'/
      DATA HEXTAB( 89) /'58'/
      DATA HEXTAB( 90) /'59'/
      DATA HEXTAB( 91) /'5A'/
      DATA HEXTAB( 92) /'5B'/
      DATA HEXTAB( 93) /'5C'/
      DATA HEXTAB( 94) /'5D'/
      DATA HEXTAB( 95) /'5E'/
      DATA HEXTAB( 96) /'5F'/
      DATA HEXTAB( 97) /'60'/
      DATA HEXTAB( 98) /'61'/
      DATA HEXTAB( 99) /'62'/
      DATA HEXTAB(100) /'63'/
      DATA HEXTAB(101) /'64'/
      DATA HEXTAB(102) /'65'/
      DATA HEXTAB(103) /'66'/
      DATA HEXTAB(104) /'67'/
      DATA HEXTAB(105) /'68'/
      DATA HEXTAB(106) /'69'/
      DATA HEXTAB(107) /'6A'/
      DATA HEXTAB(108) /'6B'/
      DATA HEXTAB(109) /'6C'/
      DATA HEXTAB(110) /'6D'/
      DATA HEXTAB(111) /'6E'/
      DATA HEXTAB(112) /'6F'/
      DATA HEXTAB(113) /'70'/
      DATA HEXTAB(114) /'71'/
      DATA HEXTAB(115) /'72'/
      DATA HEXTAB(116) /'73'/
      DATA HEXTAB(117) /'74'/
      DATA HEXTAB(118) /'75'/
      DATA HEXTAB(119) /'76'/
      DATA HEXTAB(120) /'77'/
      DATA HEXTAB(121) /'78'/
      DATA HEXTAB(122) /'79'/
      DATA HEXTAB(123) /'7A'/
      DATA HEXTAB(124) /'7B'/
      DATA HEXTAB(125) /'7C'/
      DATA HEXTAB(126) /'7D'/
      DATA HEXTAB(127) /'7E'/
      DATA HEXTAB(128) /'7F'/
      DATA HEXTAB(129) /'80'/
      DATA HEXTAB(130) /'81'/
      DATA HEXTAB(131) /'82'/
      DATA HEXTAB(132) /'83'/
      DATA HEXTAB(133) /'84'/
      DATA HEXTAB(134) /'85'/
      DATA HEXTAB(135) /'86'/
      DATA HEXTAB(136) /'87'/
      DATA HEXTAB(137) /'88'/
      DATA HEXTAB(138) /'89'/
      DATA HEXTAB(139) /'8A'/
      DATA HEXTAB(140) /'8B'/
      DATA HEXTAB(141) /'8C'/
      DATA HEXTAB(142) /'8D'/
      DATA HEXTAB(143) /'8E'/
      DATA HEXTAB(144) /'8F'/
      DATA HEXTAB(145) /'90'/
      DATA HEXTAB(146) /'91'/
      DATA HEXTAB(147) /'92'/
      DATA HEXTAB(148) /'93'/
      DATA HEXTAB(149) /'94'/
      DATA HEXTAB(150) /'95'/
      DATA HEXTAB(151) /'96'/
      DATA HEXTAB(152) /'97'/
      DATA HEXTAB(153) /'98'/
      DATA HEXTAB(154) /'99'/
      DATA HEXTAB(155) /'9A'/
      DATA HEXTAB(156) /'9B'/
      DATA HEXTAB(157) /'9C'/
      DATA HEXTAB(158) /'9D'/
      DATA HEXTAB(159) /'9E'/
      DATA HEXTAB(160) /'9F'/
      DATA HEXTAB(161) /'A0'/
      DATA HEXTAB(162) /'A1'/
      DATA HEXTAB(163) /'A2'/
      DATA HEXTAB(164) /'A3'/
      DATA HEXTAB(165) /'A4'/
      DATA HEXTAB(166) /'A5'/
      DATA HEXTAB(167) /'A6'/
      DATA HEXTAB(168) /'A7'/
      DATA HEXTAB(169) /'A8'/
      DATA HEXTAB(170) /'A9'/
      DATA HEXTAB(171) /'AA'/
      DATA HEXTAB(172) /'AB'/
      DATA HEXTAB(173) /'AC'/
      DATA HEXTAB(174) /'AD'/
      DATA HEXTAB(175) /'AE'/
      DATA HEXTAB(176) /'AF'/
      DATA HEXTAB(177) /'B0'/
      DATA HEXTAB(178) /'B1'/
      DATA HEXTAB(179) /'B2'/
      DATA HEXTAB(180) /'B3'/
      DATA HEXTAB(181) /'B4'/
      DATA HEXTAB(182) /'B5'/
      DATA HEXTAB(183) /'B6'/
      DATA HEXTAB(184) /'B7'/
      DATA HEXTAB(185) /'B8'/
      DATA HEXTAB(186) /'B9'/
      DATA HEXTAB(187) /'BA'/
      DATA HEXTAB(188) /'BB'/
      DATA HEXTAB(189) /'BC'/
      DATA HEXTAB(190) /'BD'/
      DATA HEXTAB(191) /'BE'/
      DATA HEXTAB(192) /'BF'/
      DATA HEXTAB(193) /'C0'/
      DATA HEXTAB(194) /'C1'/
      DATA HEXTAB(195) /'C2'/
      DATA HEXTAB(196) /'C3'/
      DATA HEXTAB(197) /'C4'/
      DATA HEXTAB(198) /'C5'/
      DATA HEXTAB(199) /'C6'/
      DATA HEXTAB(200) /'C7'/
      DATA HEXTAB(201) /'C8'/
      DATA HEXTAB(202) /'C9'/
      DATA HEXTAB(203) /'CA'/
      DATA HEXTAB(204) /'CB'/
      DATA HEXTAB(205) /'CC'/
      DATA HEXTAB(206) /'CD'/
      DATA HEXTAB(207) /'CE'/
      DATA HEXTAB(208) /'CF'/
      DATA HEXTAB(209) /'D0'/
      DATA HEXTAB(210) /'D1'/
      DATA HEXTAB(211) /'D2'/
      DATA HEXTAB(212) /'D3'/
      DATA HEXTAB(213) /'D4'/
      DATA HEXTAB(214) /'D5'/
      DATA HEXTAB(215) /'D6'/
      DATA HEXTAB(216) /'D7'/
      DATA HEXTAB(217) /'D8'/
      DATA HEXTAB(218) /'D9'/
      DATA HEXTAB(219) /'DA'/
      DATA HEXTAB(220) /'DB'/
      DATA HEXTAB(221) /'DC'/
      DATA HEXTAB(222) /'DD'/
      DATA HEXTAB(223) /'DE'/
      DATA HEXTAB(224) /'DF'/
      DATA HEXTAB(225) /'E0'/
      DATA HEXTAB(226) /'E1'/
      DATA HEXTAB(227) /'E2'/
      DATA HEXTAB(228) /'E3'/
      DATA HEXTAB(229) /'E4'/
      DATA HEXTAB(230) /'E5'/
      DATA HEXTAB(231) /'E6'/
      DATA HEXTAB(232) /'E7'/
      DATA HEXTAB(233) /'E8'/
      DATA HEXTAB(234) /'E9'/
      DATA HEXTAB(235) /'EA'/
      DATA HEXTAB(236) /'EB'/
      DATA HEXTAB(237) /'EC'/
      DATA HEXTAB(238) /'ED'/
      DATA HEXTAB(239) /'EE'/
      DATA HEXTAB(240) /'EF'/
      DATA HEXTAB(241) /'F0'/
      DATA HEXTAB(242) /'F1'/
      DATA HEXTAB(243) /'F2'/
      DATA HEXTAB(244) /'F3'/
      DATA HEXTAB(245) /'F4'/
      DATA HEXTAB(246) /'F5'/
      DATA HEXTAB(247) /'F6'/
      DATA HEXTAB(248) /'F7'/
      DATA HEXTAB(249) /'F8'/
      DATA HEXTAB(250) /'F9'/
      DATA HEXTAB(251) /'FA'/
      DATA HEXTAB(252) /'FB'/
      DATA HEXTAB(253) /'FC'/
      DATA HEXTAB(254) /'FD'/
      DATA HEXTAB(255) /'FE'/
      DATA HEXTAB(256) /'FF'/
C
C-----START POINT-----------------------------------------------------
C
      IF(IX.LE.0)THEN
        IC=HEXTAB(1)
      ELSEIF(IX.GE.255)THEN
        IC=HEXTAB(256)
      ELSE
        IC=HEXTAB(IX+1)
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPCOPY(IHARG,IARGT,IARG,NUMARG,
     1NUMDEV,
     1IDMANU,IDMODE,IDMOD2,IDMOD3,
     1IDPOWE,IDCONT,IDCOLO,IDNVPP,IDNHPP,IDUNIT,
CCCCC ADD FOLLOWING LINE MARCH 1997.
     1IDFONT,
     1IBUGD2,ISUBRO,IFOUND,IERROR)
C
C     PURPOSE--CARRY OUT AN IMMEDIATE COPY OF THE SCREEN
C              ONTO THE LOCAL HARDCOPY UNIT
C              FOR DISPLAY TERMINALS
C     INPUT  ARGUMENTS--IHARG  (A  CHARACTER VECTOR)
C                     --IARGT  (A  CHARACTER VECTOR)
C                     --IARG   (AN INTEGER VECTOR)
C                     --NUMARG
C     OUTPUT ARGUMENTS--IFOUND ('YES' OR 'NO')
C                     --IERROR ('YES' OR 'NO' )
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--NOVEMBER  1980.
C     UPDATED         --APRIL     1982.
C     UPDATED         --MAY       1982.
C     UPDATED         --MARCH     1997.  SUPPORT FOR DEVICE FONT (ALAN)
C
C-----NON-COMMON VARIABLES----------------------------------------
C
      CHARACTER*4 IHARG
      CHARACTER*4 IARGT
C
      CHARACTER*4 IDMANU
      CHARACTER*4 IDMODE
      CHARACTER*4 IDMOD2
      CHARACTER*4 IDMOD3
C
      CHARACTER*4 IDPOWE
      CHARACTER*4 IDCONT
      CHARACTER*4 IDCOLO
CCCCC ADD FOLLOWING LINE MARCH 1997.
      CHARACTER*4 IDFONT
C
      CHARACTER*4 IFOUND
      CHARACTER*4 IBUGD2
      CHARACTER*4 ISUBRO
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      DIMENSION IHARG(*)
      DIMENSION IARGT(*)
      DIMENSION IARG(*)
C
      DIMENSION IDMANU(*)
      DIMENSION IDMODE(*)
      DIMENSION IDMOD2(*)
      DIMENSION IDMOD3(*)
C
      DIMENSION IDPOWE(*)
      DIMENSION IDCONT(*)
      DIMENSION IDCOLO(*)
CCCCC ADD FOLLOWING LINE MARCH 1997.
      DIMENSION IDFONT(*)
      DIMENSION IDNVPP(*)
      DIMENSION IDNHPP(*)
      DIMENSION IDUNIT(*)
C
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOGR.INC'
      INCLUDE 'DPCOBE.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPCO'
      ISUBN2='SC  '
C
      IFOUND='NO'
      IERROR='NO'
C
      IBUGG4=IBUGD2
      ISUBG4=ISUBRO
      IERRG4=IERROR
C
      NUMCOP=1
C
      IF(IBUGD2.EQ.'OFF')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('AT THE BEGINNING OF DPCOPY--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)IBUGD2,IBUGG4
   53 FORMAT('IBUGD2,IBUGG4 = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)IFOUND,IERROR
   54 FORMAT('IFOUND,IERROR = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,55)NUMCOP
   55 FORMAT('NUMCOP = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,60)NUMARG
   60 FORMAT('NUMARG = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO61I=1,NUMARG
      WRITE(ICOUT,62)I,IHARG(I),IARGT(I),IARG(I)
   62 FORMAT('I,IHARG(I),IARGT(I),IARG(I) = ',
     1I8,2X,A4,2X,A4,2X,I8)
      CALL DPWRST('XXX','BUG ')
   61 CONTINUE
      WRITE(ICOUT,70)NUMDEV
   70 FORMAT('NUMDEV = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO71I=1,NUMDEV
      WRITE(ICOUT,72)I,IDMANU(I),IDMODE(I),IDMOD2(I),IDMOD3(I)
   72 FORMAT('I,IDMANU(I),IDMODE(I),IDMOD2(I),IDMOD3(I) = ',
     1I8,2X,A4,2X,A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,73)I,IDPOWE(I),IDCONT(I),IDCOLO(I)
   73 FORMAT('I,IDPOWE(I),IDCONT(I),IDCOLO(I) = ',
     1I8,2X,A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,74)I,IDNVPP(I),IDNHPP(I),IDUNIT(I)
   74 FORMAT('I,IDNVPP(I),IDNHPP(I),IDUNIT(I) = ',
     1I8,2X,I8,2X,I8,2X,I8)
      CALL DPWRST('XXX','BUG ')
   71 CONTINUE
      WRITE(ICOUT,82)IMANUF,IMODEL,IMODE2,IMODE3
   82 FORMAT('IMANUF,IMODEL,IMODE2,IMODE3 = ',A4,2X,A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,83)IGCONT,IGCOLO
   83 FORMAT('IGCONT,IGCOLO = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,84)NUMVPP,NUMHPP,ANUMVP,ANUMHP
   84 FORMAT('NUMVPP,NUMHPP,ANUMVP,ANUMHP = ',2I8,2E15.7)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
C               ********************************************************
C               **  STEP 1--                                          **
C               **  EXTRACT NEEDED INFORMATION FROM THE COMMAND LINE  **
C               ********************************************************
C
      IF(NUMARG.GE.1.AND.IARGT(NUMARG).EQ.'NUMB')GOTO1120
      GOTO1110
C
 1110 CONTINUE
      NUMCOP=1
      GOTO1150
C
 1120 CONTINUE
      NUMCOP=IARG(NUMARG)
      GOTO1150
C
 1150 CONTINUE
      IFOUND='YES'
C
C               ********************************
C               **  STEP 2--                  **
C               **  STEP THROUGH EACH DEVICE  **
C               ********************************
C
      IF(NUMDEV.LE.0)GOTO9000
      DO8000IDEVIC=1,NUMDEV
C
      IF(IDPOWE(IDEVIC).EQ.'OFF')GOTO8000
C
      IMANUF=IDMANU(IDEVIC)
      IMODEL=IDMODE(IDEVIC)
      IMODE2=IDMOD2(IDEVIC)
      IMODE3=IDMOD3(IDEVIC)
      IGCONT=IDCONT(IDEVIC)
      IGCOLO=IDCOLO(IDEVIC)
CCCCC ADD FOLLOWING LINE MARCH 1997.
      IGFONT=IDFONT(IDEVIC)
      NUMVPP=IDNVPP(IDEVIC)
      NUMHPP=IDNHPP(IDEVIC)
      ANUMVP=NUMVPP
      ANUMHP=NUMHPP
      IGUNIT=IDUNIT(IDEVIC)
C
C               ******************************************************
C               **  STEP 2.1--                                      **
C               **  TREAT THE COPY  CASE FOR PRINTERS  **
C               **  AND DISCRETE TERMINALS                          **
C               **  (NO COPY IS DONE)              ZZ
C               ******************************************************
C
      ISTEPN='2.1'
      IF(IBUGD2.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IGCONT.EQ.'ON')GOTO1900
      GOTO8000
 1900 CONTINUE
C
C               ****************************************
C               **  STEP 2.2--                        **
C               **  TREAT THE COPY CASE               **
C               **  FOR CONTINUOUS TERMINALS.         **
C               ****************************************
C
      ISTEPN='2.2'
      IF(IBUGD2.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(NUMCOP.LE.0)GOTO1290
      DO1200I=1,NUMCOP
      IF(IBUGD2.EQ.'ON')WRITE(ICOUT,1205)
 1205 FORMAT('***** A COPY SHOULD BE MADE NOW *****')
      IF(IBUGD2.EQ.'ON')CALL DPWRST('XXX','BUG ')
      CALL GRCOSC
 1200 CONTINUE
 1290 CONTINUE
C
 8000 CONTINUE
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGD2.EQ.'OFF')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('AT THE END       OF DPCOPY--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)IBUGD2,IBUGG4
 9013 FORMAT('IBUGD2,IBUGG4 = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)IFOUND,IERROR
 9014 FORMAT('IFOUND,IERROR = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)NUMCOP
 9015 FORMAT('NUMCOP = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9020)NUMARG
 9020 FORMAT('NUMARG = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO9021I=1,NUMARG
      WRITE(ICOUT,9022)I,IHARG(I),IARGT(I),IARG(I)
 9022 FORMAT('I,IHARG(I),IARGT(I),IARG(I) = ',
     1I8,2X,A4,2X,A4,2X,I8)
      CALL DPWRST('XXX','BUG ')
 9021 CONTINUE
      WRITE(ICOUT,9030)NUMDEV
 9030 FORMAT('NUMDEV = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO9031I=1,NUMDEV
      WRITE(ICOUT,9032)I,IDMANU(I),IDMODE(I),IDMOD2(I),IDMOD3(I)
 9032 FORMAT('I,IDMANU(I),IDMODE(I),IDMOD2(I),IDMOD3(I) = ',
     1I8,2X,A4,2X,A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9033)I,IDPOWE(I),IDCONT(I),IDCOLO(I)
 9033 FORMAT('I,IDPOWE(I),IDCONT(I),IDCOLO(I) = ',
     1I8,2X,A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9034)I,IDNVPP(I),IDNHPP(I),IDUNIT(I)
 9034 FORMAT('I,IDNVPP(I),IDNHPP(I),IDUNIT(I) = ',
     1I8,2X,I8,2X,I8,2X,I8)
      CALL DPWRST('XXX','BUG ')
 9031 CONTINUE
      WRITE(ICOUT,9042)IMANUF,IMODEL,IMODE2,IMODE3
 9042 FORMAT('IMANUF,IMODEL,IMODE2,IMODE3 = ',A4,2X,A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9043)IGCONT,IGCOLO
 9043 FORMAT('IGCONT,IGCOLO = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9044)NUMVPP,NUMHPP,ANUMVP,ANUMHP
 9044 FORMAT('NUMVPP,NUMHPP,ANUMVP,ANUMHP = ',2I8,2E15.7)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPCOR2(Y1,Y2,N,NCURVE,ICASPL,NUMLAG,MAXN,
     1                  IAUTCP,IAUTL0,TEMP1,TEMP2,
     1                  Y,X,D,TOP,BOTTOM,PCC,NPLOTP,NPLOTV,
     1                  IBUGG3,ISUBRO,IERROR)
C
C     PURPOSE--GENERATE A PAIR OF COORDINATE VECTORS
C              THAT WILL DEFINE
C                   1) AN AUTOCORRELATION PLOT
C                   2) A CROSS-CORRELATION PLOT
C                   3) A PARTIAL AUTOCORRELATION PLOT
C                   4) AN AUTOCOMOVEMENT PLOT
C                   5) A CROSS-COMOVEMENT PLOT
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-921-3651
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--APRIL     1978.
C     UPDATED         --MAY       1978.
C     UPDATED         --JUNE      1978.
C     UPDATED         --OCTOBER   1978.
C     UPDATED         --MARCH     1979.
C     UPDATED         --APRIL     1979.
C     UPDATED         --JANUARY   1981.
C     UPDATED         --DECEMBER  1981.
C     UPDATED         --MAY       1982.
C     UPDATED         --MAY       1992. REWRITE AUTOCORR. FOR SMALL N
C     UPDATED         --FEBRUARY  1993. PARTIAL AUTOCORRELATION PLOT
C     UPDATED         --DECEMBER  1994. FIX XLIMITS /REF. LINES PROBLEM
C     UPDATED         --JULY      1999. SUPPORT FIXED OR MOVING ERROR
C                                       LIMITS.
C     UPDATED         --FEBRUARY  2003. SUPPORT OPTION TO OMIT LAG 0 ON
C                                       AUTOCORRELATION AND PARTIAL
C                                       AUTOCORRELATION PLOT (IAUTL0)
C     UPDATED         --JANUARY   2012. FOLD IN COMOVEMENT PLOTS
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
CCCCC ADD FOLLOWING LINE JULY 1999
      CHARACTER*4 IAUTCP
CCCCC ADD FOLLOWING LINE FEBRUARY 2003
      CHARACTER*4 IAUTL0
      CHARACTER*4 ICASPL
      CHARACTER*4 IBUGG3
      CHARACTER*4 ISUBRO
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*4 IFOUND
      CHARACTER*4 IWRITE
C
C---------------------------------------------------------------------
C
      DIMENSION Y1(*)
      DIMENSION Y2(*)
      DIMENSION TEMP1(*)
      DIMENSION TEMP2(*)
      DIMENSION Y(*)
      DIMENSION X(*)
      DIMENSION D(*)
C
CCCCC TO DO--THE FOLLOWING DIMENSIONS MUST BE GENERALIZED BEYOND 1000
CCCCC 2/93
CCCCC MOVE FOLLOWING DIMENSIONS TO DPCORR.   OCTOBER 1997
CCCCC DIMENSION TOP(1000)
CCCCC DIMENSION BOTTOM(1000)
CCCCC DIMENSION PCC(1000)
      DIMENSION TOP(*)
      DIMENSION BOTTOM(*)
      DIMENSION PCC(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPCO'
      ISUBN2='R2  '
C
      IERROR='NO'
      IWRITE='OFF'
C
      J=(-999)
      KMAX=(-999)
C
      IF(IBUGG3.EQ.'ON'.OR.ISUBRO.EQ.'COR2')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,70)
   70   FORMAT('***** AT THE BEGINNING OF DPCOR2--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,71)ICASPL,N,NUMLAG,MAXN
   71   FORMAT('ICASPL,N,NUMLAG,MAXN = ',A4,2X,3I8)
        CALL DPWRST('XXX','BUG ')
        DO73I=1,N
          WRITE(ICOUT,74)I,Y1(I),Y2(I)
   74     FORMAT('I,Y1(I),Y2(I) = ',I8,2G15.7)
          CALL DPWRST('XXX','BUG ')
   73   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 1--                              **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      IF(N.LT.3)THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,31)
   31   FORMAT('***** ERROR IN ...CORRELATION/COMOVEMENT PLOT--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,32)
   32   FORMAT('      THE NUMBER OF OBSERVATIONS MUST BE AT LEAST 2.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,34)N
   34   FORMAT('      THE NUMBER OF OBSERVATIONS = ',I6)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      HOLD=Y1(1)
      DO60I=1,N
        IF(Y1(I).NE.HOLD)GOTO69
   60 CONTINUE
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,31)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,62)HOLD
   62 FORMAT('      ALL ELEMENTS IN Y1 ARE IDENTICALLY EQUAL TO ',G15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
   69 CONTINUE
C
C               *******************************
C               **  STEP 2--                 **
C               **  IF NECESSARY,            **
C               **  COMPUTE THE MAXIMUM LAG  **
C               *******************************
C
      ISTEPN='2'
      IF(IBUGG3.EQ.'ON'.OR.ISUBRO.EQ.'COR2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      MAXLAG=MAXN
      IF(NUMLAG.GE.1)KMAX=NUMLAG
      IF(NUMLAG.LE.0)KMAX=N/4
      IF(NUMLAG.LE.0.AND.N.LE.32)KMAX=N/2
      IF(NUMLAG.LE.0.AND.N.LE.16)KMAX=N
      IF(KMAX.GT.MAXLAG)KMAX=MAXLAG
      NM1=N-1
      IF(KMAX.GT.NM1)KMAX=NM1
CCCCC THE FOLLOWING 4 LINES WERE ADDED MAY 1992 (JJF)
      IF(N.LE.16)THEN
         NM2=N-2
         IF(KMAX.GT.NM2)KMAX=NM2
      ENDIF
      KMAXM1=KMAX-1
      AKMAXM=KMAXM1
      AN=N
C
C               **************************************
C               **  STEP 4--                        **
C               **  BRANCH TO THE APPROPRIATE CASE  **
C               **  AND DETERMINE PLOT COORDINATES  **
C               **************************************
C
      ISTEPN='4'
      IF(IBUGG3.EQ.'ON'.OR.ISUBRO.EQ.'COR2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C
      IF(ICASPL.EQ.'AUCO')THEN
C
C        ******************************************************
C        **  STEP 4.1--                                      **
C        **  COMPUTE THE AUTOCORRELATIONS FOR THE X  DATA    **
C        **  DO SO IN 3 STEPS--                              **
C        **     1) COMPUTE THE SAMPLE MEAN;                  **
C        **     2) COMPUTE THE SAMPLE VARIANCE;              **
C        **     3) COMPUTE THE AUTOCORRELATIONS;             **
C        **  REFERENCE--JENKINS AND WATTS, PAGE 382 (9.3.1)  **
C        ******************************************************
C
        ISTEPN='4.1'
        IF(IBUGG3.EQ.'ON'.OR.ISUBRO.EQ.'COR2')
     1     CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
        IF(N.LE.16)THEN
C
C         COMPUTE AUTOCORRELATIONS FOR N <= 16
C
          DO1110K=1,KMAXM1
            NMK=N-K
            ANMK=NMK
            SUM1=0.0
            SUM2=0.0
            DO1120I=1,NMK
              J=I+K
              SUM1=SUM1+Y1(I)
              SUM2=SUM2+Y1(J)
 1120       CONTINUE
            Y1BAR=SUM1/ANMK
            Y2BAR=SUM2/ANMK
C
            SUM1=0.0
            SUM2=0.0
            DO1130I=1,NMK
              J=I+K
              SUM1=SUM1+(Y1(I)-Y1BAR)**2
              SUM2=SUM2+(Y1(J)-Y2BAR)**2
 1130       CONTINUE
            SSQ1=SUM1
            SSQ2=SUM2
C
            SUM1=0.0
            DO1140I=1,NMK
              J=I+K
              SUM1=SUM1+(Y1(I)-Y1BAR)*(Y1(J)-Y2BAR)
 1140       CONTINUE
            ANUM=SUM1
C
            SQRT1=0.0
            IF(SSQ1.GT.0.0)SQRT1=SQRT(SSQ1)
            SQRT2=0.0
            IF(SSQ2.GT.0.0)SQRT2=SQRT(SSQ2)
            DENOM=SQRT1*SQRT2
            AC=0.0
            IF(DENOM.GT.0.0)AC=ANUM/DENOM
            TEMP1(K)=AC
 1110     CONTINUE
        ELSE
C
C         COMPUTE AUTOCORRELATIONS FOR N >= 17
C
          SUM1=0.0
          DO1210I=1,N
            SUM1=SUM1+Y1(I)
 1210     CONTINUE
          Y1BAR=SUM1/AN
C
          SUM1=0.0
          DO1220I=1,N
            SUM1=SUM1+(Y1(I)-Y1BAR)*(Y1(I)-Y1BAR)
 1220     CONTINUE
          VARB1=SUM1/AN
          VAR1=SUM1/(AN-1.0)
C
          DO1230K=1,KMAXM1
            SUM1=0.0
            NMK=N-K
            DO1240I=1,NMK
              J=I+K
              SUM1=SUM1+(Y1(I)-Y1BAR)*(Y1(J)-Y1BAR)
 1240       CONTINUE
            TEMP1(K)=SUM1/AN
            TEMP1(K)=TEMP1(K)/VARB1
 1230     CONTINUE
        ENDIF
C
C       FORM OUTPUT VECTORS FOR BOTH AUTOCORRELATION CASES
C
        YMID=0.0
        SDR=1.0/SQRT(AN)
        YUPP95=1.96*SDR
        YLOW95=(-YUPP95)
        YUPP99=2.576*SDR
        YLOW99=(-YUPP99)
        IOUT=0
        IFACT=6
        AFACT=1.0/AN
        YSUM1=0.0
        YSUM2=0.0
        YSUM3=0.0
        YSUM4=0.0
C
        J=0
        IF(IAUTL0.EQ.'ON')THEN
          J=J+1
          Y(J+NPLOTP)=1.0
          X(J+NPLOTP)=0.0
          D(J+NPLOTP)=REAL(1 + IFACT*(NCURVE-1))
          IF(IAUTCP.EQ.'BOXJ')THEN
            J=J+1
            Y(J+NPLOTP)=YMID
            X(J+NPLOTP)=0.0
            D(J+NPLOTP)=REAL(3 + IFACT*(NCURVE-1))
            J=J+1
            Y(J+NPLOTP)=YMID
            X(J+NPLOTP)=0.0
            D(J+NPLOTP)=REAL(4 + IFACT*(NCURVE-1))
            J=J+1
            Y(J+NPLOTP)=YMID
            X(J+NPLOTP)=0.0
            D(J+NPLOTP)=REAL(5 + IFACT*(NCURVE-1))
            J=J+1
            Y(J+NPLOTP)=YMID
            X(J+NPLOTP)=0.0
            D(J+NPLOTP)=REAL(6 + IFACT*(NCURVE-1))
          ENDIF
        ENDIF
C
        DO1310K=1,KMAXM1
          J=J+1
          Y(J+NPLOTP)=TEMP1(K)
          X(J+NPLOTP)=REAL(K)
          D(J+NPLOTP)=REAL(1 + IFACT*(NCURVE-1))
          IF(Y(J).GT.YUPP95)IOUT=IOUT+1
          IF(Y(J).LT.YLOW95)IOUT=IOUT+1
          J=J+1
          Y(J+NPLOTP)=YMID
          X(J+NPLOTP)=REAL(K)
          D(J+NPLOTP)=REAL(2 + IFACT*(NCURVE-1))
CCCCC     SUPPORT FIXED CONFIDENCE BANDS FOR TESTING FOR WHITE NOISE.
CCCCC     MOVING BANDS FOR BOX-JENKINS MODELING.
          IF(IAUTCP.NE.'BOXJ')THEN
            J=J+1
            Y(J+NPLOTP)=YUPP95
            X(J+NPLOTP)=REAL(K)
            D(J+NPLOTP)=REAL(3 + IFACT*(NCURVE-1))
            J=J+1
            Y(J+NPLOTP)=YLOW95
            X(J+NPLOTP)=REAL(K)
            D(J+NPLOTP)=REAL(4 + IFACT*(NCURVE-1))
            J=J+1
            Y(J+NPLOTP)=YUPP99
            X(J+NPLOTP)=REAL(K)
            D(J+NPLOTP)=REAL(5 + IFACT*(NCURVE-1))
            J=J+1
            Y(J+NPLOTP)=YLOW99
            X(J+NPLOTP)=REAL(K)
            D(J+NPLOTP)=REAL(6 + IFACT*(NCURVE-1))
          ELSE
C
            IF(K.EQ.1)THEN
              J=J+1
              YSUM1=YSUM1 + TEMP1(K)**2
              Y(J+NPLOTP)=YUPP95
              X(J+NPLOTP)=1.0
              D(J+NPLOTP)=REAL(3 + IFACT*(NCURVE-1))
              YSUM2=YSUM2 + TEMP1(K)**2
              J=J+1
              Y(J+NPLOTP)=YLOW95
              X(J+NPLOTP)=1.0
              D(J+NPLOTP)=REAL(4 + IFACT*(NCURVE-1))
              YSUM3=YSUM3 + TEMP1(K)**2
              J=J+1
              Y(J+NPLOTP)=YUPP99
              X(J+NPLOTP)=1.0
              D(J+NPLOTP)=REAL(5 + IFACT*(NCURVE-1))
              YSUM4=YSUM4 + TEMP1(K)**2
              J=J+1
              Y(J+NPLOTP)=YLOW99
              X(J+NPLOTP)=1
              D(J+NPLOTP)=REAL(6 + IFACT*(NCURVE-1))
            ELSE
              YSUM1=YSUM1 + TEMP1(K)**2
              J=J+1
              Y(J+NPLOTP)=1.96*SQRT(AFACT*(1.0+2.0*YSUM1))
              X(J+NPLOTP)=REAL(K)
              D(J+NPLOTP)=REAL(3 + IFACT*(NCURVE-1))
              YSUM2=YSUM2 + TEMP1(K)**2
              J=J+1
              Y(J+NPLOTP)=YLOW95
              Y(J+NPLOTP)=-1.96*SQRT(AFACT*(1.0+2.0*YSUM2))
              X(J+NPLOTP)=REAL(K)
              D(J+NPLOTP)=REAL(4 + IFACT*(NCURVE-1))
              YSUM3=YSUM3 + TEMP1(K)**2
              J=J+1
              Y(J+NPLOTP)=2.576*SQRT(AFACT*(1.0+2.0*YSUM3))
              X(J+NPLOTP)=REAL(K)
              D(J+NPLOTP)=REAL(5 + IFACT*(NCURVE-1))
              YSUM4=YSUM4 + TEMP1(K)**2
              J=J+1
              Y(J+NPLOTP)=-2.576*SQRT(AFACT*(1.0+2.0*YSUM))
              X(J+NPLOTP)=REAL(K)
              D(J+NPLOTP)=REAL(6 + IFACT*(NCURVE-1))
            ENDIF
C
          ENDIF
C
 1310   CONTINUE
        AIOUT=IOUT
        AKMAXM=KMAXM1
        PEROUT=100.0*(AIOUT/AKMAXM)
C
        NPLOTP=NPLOTP+J
        NPLOTV=3
C
        CALL DPWCCP(ICASPL,
     1              YLOW95,YUPP95,IOUT,KMAXM1,PEROUT,
     1              IBUGG3,ISUBRO,IFOUND,IERROR)
C
      ELSEIF(ICASPL.EQ.'CRCO')THEN
C
C           **********************************************************
C           **  STEP 4.2--                                          **
C           **  COMPUTE CROSS-CORRELATIONS FOR THE X AND Y  DATA    **
C           **  DO SO IN 3 STEPS--                                  **
C           **     1) COMPUTE THE SAMPLE MEAN;                      **
C           **     2) COMPUTE THE SAMPLE VARIANCE;                  **
C           **     3) COMPUTE THE AUTOCORRELATIONS;                 **
C           **  REFERENCE--JENKINS AND WATTS, PAGE 382 (9.3.1)      **
C           **********************************************************
C
        ISTEPN='4.2'
        IF(IBUGG3.EQ.'ON'.OR.ISUBRO.EQ.'COR2')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
        SUM1=0.0
        SUM2=0.0
        DO2110I=1,N
          SUM1=SUM1+Y1(I)
          SUM2=SUM2+Y2(I)
 2110   CONTINUE
        Y1BAR=SUM1/AN
        Y2BAR=SUM2/AN
C
        SUM1=0.0
        SUM2=0.0
        DO2120I=1,N
          SUM1=SUM1+(Y1(I)-Y1BAR)*(Y1(I)-Y1BAR)
          SUM2=SUM2+(Y2(I)-Y2BAR)*(Y2(I)-Y2BAR)
 2120   CONTINUE
        VARB1=SUM1/AN
        VARB2=SUM2/AN
        VAR1=SUM1/(AN-1.0)
        VAR2=SUM2/(AN-1.0)
        DENOM=0.0
        PROD=VAR1*VAR2
        IF(PROD.GT.0.0)DENOM=SQRT(PROD)
C
        INDEX=0
C
        DO2130K=1,KMAXM1
          INDEX=INDEX+1
          KREV=KMAXM1-K+1
          SUM12=0.0
          NMKREV=N-KREV
          DO2132I=1,NMKREV
            J=I+KREV
            SUM12=SUM12+(Y1(J)-Y1BAR)*(Y2(I)-Y2BAR)
 2132     CONTINUE
          TEMP1(INDEX)=SUM12/AN
 2130   CONTINUE
C
        K=0
        INDEX=INDEX+1
        SUM12=0.0
        DO2134I=1,N
          J=I
          SUM12=SUM12+(Y1(I)-Y1BAR)*(Y2(J)-Y2BAR)
 2134   CONTINUE
        TEMP1(INDEX)=SUM12/AN
C
        DO2136K=1,KMAXM1
          INDEX=INDEX+1
          SUM12=0.0
          NMK=N-K
          DO2138I=1,NMK
            J=I+K
            SUM12=SUM12+(Y1(I)-Y1BAR)*(Y2(J)-Y2BAR)
 2138     CONTINUE
          TEMP1(INDEX)=SUM12/AN
 2136   CONTINUE
C
        YMID=0.0
        SDR=1.0/SQRT(AN)
        YUPP95=1.96*SDR
        YLOW95=(-YUPP95)
        YUPP99=2.576*SDR
        YLOW99=(-YUPP99)
        IFACT=6
C
        L=(-KMAXM1-1)
        J=0
        DO2150J2=1,INDEX
          J=J+1
          L=L+1
          Y(J+NPLOTP)=1.0
          IF(DENOM.GT.0.0)Y(J+NPLOTP)=TEMP1(J2)/DENOM
          X(J+NPLOTP)=REAL(L)
          D(J+NPLOTP)=REAL(1 + IFACT*(NCURVE-1))
C
          J=J+1
          Y(J+NPLOTP)=YMID
          X(J+NPLOTP)=REAL(L)
          D(J+NPLOTP)=REAL(2 + IFACT*(NCURVE-1))
          J=J+1
          Y(J+NPLOTP)=YUPP95
          X(J+NPLOTP)=REAL(L)
          D(J+NPLOTP)=REAL(3 + IFACT*(NCURVE-1))
          J=J+1
          Y(J+NPLOTP)=YLOW95
          X(J+NPLOTP)=REAL(L)
          D(J+NPLOTP)=REAL(4 + IFACT*(NCURVE-1))
          J=J+1
          Y(J)=YUPP99
          X(J+NPLOTP)=REAL(L)
          D(J+NPLOTP)=REAL(5 + IFACT*(NCURVE-1))
          J=J+1
          Y(J)=YLOW99
          X(J+NPLOTP)=REAL(L)
          D(J+NPLOTP)=REAL(6 + IFACT*(NCURVE-1))
 2150   CONTINUE
C
        NPLOTP=NPLOTP+J
        NPLOTV=3
C
      ELSEIF(ICASPL.EQ.'PACO')THEN
C
CCCCC   THE FOLLOWING ENTIRE SECTION WAS ADDED FEBRUARY 1993
C           ******************************************************
C           **  STEP 4.3--                                      **
C           **  COMPUTE THE PARTIAL AUTOCORRELATIONS FOR THE X  **
C           **  DATA.   DO SO IN 4 STEPS--                      **
C           **     1) COMPUTE THE SAMPLE MEAN;                  **
C           **     2) COMPUTE THE SAMPLE VARIANCE;              **
C           **     3) COMPUTE THE AUTOCORRELATIONS;             **
C           **     4) COMPUTE THE PARTIAL AUTOCORRELATIONS;     **
C           **  REFERENCE--JENKINS AND WATTS, PAGE 382 (9.3.1)  **
C           **  REFERENCE--WEISS, COMMUNICATIONS IN STATISTICS, **
C           **             PAGE 382 (9.3.1)                     **
C           ******************************************************
C
        ISTEPN='4.3'
        IF(IBUGG3.EQ.'ON'.OR.ISUBRO.EQ.'COR2')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C
C       IF N <= 16, COMPUTE (SIMPLE) AUTOCORRELATIONS
C
        IF(N.LE.16)THEN
          AN=N
C
          DO3110K=1,KMAXM1
            NMK=N-K
            ANMK=NMK
            SUM1=0.0
            SUM2=0.0
            DO3120I=1,NMK
               J=I+K
               SUM1=SUM1+Y1(I)
               SUM2=SUM2+Y1(J)
 3120       CONTINUE
            Y1BAR=SUM1/ANMK
            Y2BAR=SUM2/ANMK
C
            SUM1=0.0
            SUM2=0.0
            DO3130I=1,NMK
               J=I+K
               SUM1=SUM1+(Y1(I)-Y1BAR)**2
               SUM2=SUM2+(Y1(J)-Y2BAR)**2
 3130       CONTINUE
            SSQ1=SUM1
            SSQ2=SUM2
C
            SUM1=0.0
            DO3140I=1,NMK
               J=I+K
               SUM1=SUM1+(Y1(I)-Y1BAR)*(Y1(J)-Y2BAR)
 3140       CONTINUE
            ANUM=SUM1
C
            SQRT1=0.0
            IF(SSQ1.GT.0.0)SQRT1=SQRT(SSQ1)
            SQRT2=0.0
            IF(SSQ2.GT.0.0)SQRT2=SQRT(SSQ2)
            DENOM=SQRT1*SQRT2
            AC=0.0
            IF(DENOM.GT.0.0)AC=ANUM/DENOM
            TEMP1(K)=AC
 3110     CONTINUE
C
C         IF N >= 17, COMPUTE (SIMPLE) AUTOCORRELATIONS
C
        ELSEIF(N.GE.17)THEN
          AN=N
C
          SUM1=0.0
          DO3210I=1,N
            SUM1=SUM1+Y1(I)
 3210     CONTINUE
          Y1BAR=SUM1/AN
C
          SUM1=0.0
          DO3220I=1,N
            SUM1=SUM1+(Y1(I)-Y1BAR)*(Y1(I)-Y1BAR)
 3220     CONTINUE
          VARB1=SUM1/AN
          VAR1=SUM1/(AN-1.0)
C
          DO3230K=1,KMAXM1
            SUM1=0.0
            NMK=N-K
            DO3240I=1,NMK
              J=I+K
              SUM1=SUM1+(Y1(I)-Y1BAR)*(Y1(J)-Y1BAR)
 3240       CONTINUE
            TEMP1(K)=SUM1/AN
            TEMP1(K)=TEMP1(K)/VARB1
 3230     CONTINUE
        ENDIF
C
C       FORM PARTIAL AUTOCORRELATIONS FROM SIMPLE AUTOCORRELATIONS
C       REFERENCE--WEISS, COMMUN. OF STAT., 1984, P. 541-542.
C
        K=KMAXM1
        I=0
        I2=I+1
        TOP(I2)=1.0
        BOTTOM(I2)=1.0
        DO3310I=1,K
          I2=I+1
          TOP(I2)=TEMP1(I)
          BOTTOM(I2)=TEMP1(I)
 3310   CONTINUE
C
        PCC(1)=1.0
        DO3320J=1,K
          J2=J+1
          PCC(J2)=TOP(1+1)/BOTTOM(0+1)
C
          IF(IBUGG3.EQ.'ON' .OR. ISUBRO.EQ.'COR2')THEN
            WRITE(ICOUT,3321)J,J2,PCC(J2)
 3321       FORMAT('J,J2,PCC(J2) = ',2I8,F10.5)
            CALL DPWRST('XXX','BUG ')
          ENDIF
C
          KMJ=K-J
          DO3330I=1,KMJ
            I2=I+1
            BOTTOM(I2-1)=BOTTOM(I2-1)-TOP(I2)*PCC(J2)
            TOP(I2)=TOP(I2+1)-BOTTOM(I2)*PCC(J2)
 3330     CONTINUE
 3320   CONTINUE
C
C       FORM OUTPUT VECTORS
C
        YMID=0.0
        SDR=1.0/SQRT(AN)
        YUPP95=1.96*SDR
        YLOW95=(-YUPP95)
        YUPP99=2.576*SDR
        YLOW99=(-YUPP99)
        IOUT=0
C
        J=0
        IF(IAUTL0.EQ.'ON')THEN
          J=J+1
          Y(J+NPLOTP)=PCC(1)
          X(J+NPLOTP)=0.0
          D(J+NPLOTP)=REAL(1 + IFACT*(NCURVE-1))
        ENDIF
C
        DO3410K=1,KMAXM1
          J=J+1
          Y(J+NPLOTP)=PCC(K+1)
          X(J+NPLOTP)=REAL(K)
          D(J+NPLOTP)=REAL(1 + IFACT*(NCURVE-1))
          IF(Y(J+NPLOTP).GT.YUPP95)IOUT=IOUT+1
          IF(Y(J+NPLOTP).LT.YLOW95)IOUT=IOUT+1
          J=J+1
          Y(J+NPLOTP)=YMID
          X(J+NPLOTP)=REAL(K)
          D(J+NPLOTP)=REAL(2 + IFACT*(NCURVE-1))
          J=J+1
          Y(J+NPLOTP)=YUPP95
          X(J+NPLOTP)=REAL(K)
          D(J+NPLOTP)=REAL(3 + IFACT*(NCURVE-1))
          J=J+1
          Y(J+NPLOTP)=YLOW95
          X(J+NPLOTP)=REAL(K)
          D(J+NPLOTP)=REAL(4 + IFACT*(NCURVE-1))
          J=J+1
          Y(J+NPLOTP)=YUPP99
          X(J+NPLOTP)=REAL(K)
          D(J+NPLOTP)=REAL(5 + IFACT*(NCURVE-1))
          J=J+1
          Y(J+NPLOTP)=YLOW99
          X(J+NPLOTP)=REAL(K)
          D(J+NPLOTP)=REAL(6 + IFACT*(NCURVE-1))
 3410   CONTINUE
        AIOUT=IOUT
        AKMAXM=KMAXM1
        PEROUT=100.0*(AIOUT/AKMAXM)
C
        NPLOTP=NPLOTP+J
        NPLOTV=3
C
        CALL DPWCCP(ICASPL,
     1              YLOW95,YUPP95,IOUT,KMAXM1,PEROUT,
     1              IBUGG3,ISUBRO,IFOUND,IERROR)
C
C           ******************************************************
C           **  STEP 4.4--                                      **
C           **  COMPUTE THE AUTOCOMOVEMENT FOR THE X DATA.      **
C           ******************************************************
C
      ELSEIF(ICASPL.EQ.'AUCM')THEN
        IFACT=2
        YMID=0.0
        J=1
        X(J+NPLOTP)=0.0
        Y(J+NPLOTP)=1.0
        D(J+NPLOTP)=REAL(1 + IFACT*(NCURVE-1))
C
        DO4110K=1,KMAXM1
          NMK=N-K
          ANMK=NMK
          DO4120I=1,NMK
            JJ=I+K
            TEMP1(I)=Y1(I)
            TEMP2(I)=Y1(JJ)
 4120     CONTINUE
          CALL COMOVE(TEMP1,TEMP2,NMK,IWRITE,XYCOMO,IBUGG3,IERROR) 
          J=J+1
          X(J+NPLOTP)=REAL(K)
          Y(J+NPLOTP)=XYCOMO
          D(J+NPLOTP)=REAL(1 + IFACT*(NCURVE-1))
          J=J+1
          Y(J+NPLOTP)=YMID
          X(J+NPLOTP)=REAL(K)
          D(J+NPLOTP)=REAL(2 + IFACT*(NCURVE-1))
 4110   CONTINUE
C
        NPLOTP=NPLOTP+J
        NPLOTV=3
C
      ELSEIF(ICASPL.EQ.'CRCM')THEN
C
C       **********************************************************
C       **  STEP 5.2--                                          **
C       **  COMPUTE CROSS-COMOVEMENTS  FOR THE X AND Y  DATA    **
C       **********************************************************
C
        IFACT=2
        YMID=0.0
        J=0
        L=(-KMAXM1-1)
        DO5110K=1,KMAXM1
          KREV=KMAXM1-K+1
          NMK=N-KREV
          ANMK=NMK
          DO5120I=1,NMK
            JJ=I+KREV
            TEMP1(I)=Y1(JJ)
            TEMP2(I)=Y2(I)
 5120     CONTINUE
          CALL COMOVE(TEMP1,TEMP2,NMK,IWRITE,XYCOMO,IBUGG3,IERROR) 
          J=J+1
          L=L+1
          X(J+NPLOTP)=REAL(L)
          Y(J+NPLOTP)=XYCOMO
          D(J+NPLOTP)=REAL(1 + IFACT*(NCURVE-1))
          J=J+1
          Y(J+NPLOTP)=YMID
          X(J+NPLOTP)=REAL(L)
          D(J+NPLOTP)=REAL(2 + IFACT*(NCURVE-1))
 5110   CONTINUE
C
        J=J+1
        X(J+NPLOTP)=0.0
        Y(J+NPLOTP)=1.0
        D(J+NPLOTP)=REAL(1 + IFACT*(NCURVE-1))
        J=J+1
        X(J+NPLOTP)=0.0
        Y(J+NPLOTP)=0.0
        D(J+NPLOTP)=REAL(2 + IFACT*(NCURVE-1))
C
        DO5210K=1,KMAXM1
          NMK=N-K
          ANMK=NMK
          DO5220I=1,NMK
            JJ=I+K
            TEMP1(I)=Y1(I)
            TEMP2(I)=Y2(JJ)
 5220     CONTINUE
          CALL COMOVE(TEMP1,TEMP2,NMK,IWRITE,XYCOMO,IBUGG3,IERROR) 
          J=J+1
          X(J+NPLOTP)=REAL(K)
          Y(J+NPLOTP)=XYCOMO
          D(J+NPLOTP)=REAL(1 + IFACT*(NCURVE-1))
          J=J+1
          Y(J+NPLOTP)=YMID
          X(J+NPLOTP)=REAL(K)
          D(J+NPLOTP)=REAL(2 + IFACT*(NCURVE-1))
 5210   CONTINUE
C
        NPLOTP=NPLOTP+J
        NPLOTV=3
C
      ELSE
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,31)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,112)
  112   FORMAT('      ICASPL SHOULD BE ONE OF')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1013)
 1013   FORMAT('      AUCO, CRCO, PACO, AUCM, OR CRCM, BUT IS NOT.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1014)ICASPL
 1014   FORMAT('      ICASPL = ',A4)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
      ENDIF
C
C               ******************
C               **   STEP 90--  **
C               **   EXIT       **
C               ******************
C
 9000 CONTINUE
      IF(IBUGG3.EQ.'ON'.OR.ISUBRO.EQ.'COR2')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPCOR2--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)ICASPL,NUMLAG,N,KMAX,NPLOTP,IERROR
 9012   FORMAT('ICASPL,NUMLAG,N,KMAX,NPLOTP,IERROR = ',A4,4I8,2X,A4)
        CALL DPWRST('XXX','BUG ')
        DO9015I=1,NPLOTP
          WRITE(ICOUT,9016)I,Y(I),X(I),D(I)
 9016     FORMAT('I,Y(I),X(I),D(I) = ',I8,3G15.7)
          CALL DPWRST('XXX','BUG ')
 9015   CONTINUE
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        DO9020I=1,10
          WRITE(ICOUT,9021)I,D(I),TOP(I),BOTTOM(I),PCC(I)
 9021     FORMAT('I,D(I),TOP(I),BOTTOM(I),PCC(I) = ',I8,4G15.7)
          CALL DPWRST('XXX','BUG ')
 9020   CONTINUE
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPCORR(NPLOTV,NPLOTP,NS,ICASPL,IAND1,IAND2,
     1                  IBUGG2,IBUGG3,IBUGQ,ISUBRO,IFOUND,IERROR)
C
C     PURPOSE--FORM
C              1) AUTOCORRELATION PLOT
C              2) CROSS-CORRELATION PLOT
C              3) PARTIAL AUTOCORRELATION PLOT
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--MAY       1978.
C     UPDATED         --JUNE      1978.
C     UPDATED         --JULY      1979.
C     UPDATED         --JANUARY   1981.
C     UPDATED         --DECEMBER  1981.
C     UPDATED         --MARCH     1982.
C     UPDATED         --MAY       1982.
C     UPDATED         --JUNE      1990.  TEMPORARY ARRAYS TO GARBAGE COMMON
C     UPDATED         --FEBRUARY  1990.  PARTIAL AUTOECORRELATION PLOT
C     UPDATED         --OCTOBER   1997.  MOVE SOME DIMENSIONS TO DPCORR
C     UPDATED         --JULY      1999.  ADD IAUTCP PARAMETER
C     UPDATED         --FEBRUARY  2003.  ADD IAUTL0 PARAMETER
C     UPDATED         --JANAURY   2012.  USE DPPARS
C     UPDATED         --JANAURY   2012.  FOLD IN COMOVEMENT PLOT
C     UPDATED         --JANAURY   2012.  SUPPORT FOR "MULTIPLE" AND
C                                        "REPLICATION" OPTIONS
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICASPL
      CHARACTER*4 IAND1
      CHARACTER*4 IAND2
      CHARACTER*4 IBUGG2
      CHARACTER*4 IBUGG3
      CHARACTER*4 IBUGQ
      CHARACTER*4 ISUBRO
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
      CHARACTER*4 IHWUSE
      CHARACTER*4 MESSAG
      CHARACTER*4 IH
      CHARACTER*4 IH2
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      CHARACTER*4 IREPL
      CHARACTER*4 IMULT
      CHARACTER*4 ICASE
      CHARACTER*40 INAME
      PARAMETER (MAXSPN=30)
      CHARACTER*4 IVARN1(MAXSPN)
      CHARACTER*4 IVARN2(MAXSPN)
      CHARACTER*4 IVARTY(MAXSPN)
      REAL PVAR(MAXSPN)
      INTEGER ILIS(MAXSPN)
      INTEGER NRIGHT(MAXSPN)
      INTEGER ICOLR(MAXSPN)
C
C---------------------------------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCOZZ.INC'
C
      DIMENSION Y1(MAXOBV)
      DIMENSION Y2(MAXOBV)
      DIMENSION TOP(MAXOBV)
      DIMENSION BOTTOM(MAXOBV)
      DIMENSION PCC(MAXOBV)
      DIMENSION XIDTEM(MAXOBV)
      DIMENSION XIDTE2(MAXOBV)
      DIMENSION XIDTE3(MAXOBV)
      DIMENSION TEMP1(MAXOBV)
      DIMENSION TEMP2(MAXOBV)
      DIMENSION ZY1(MAXOBV)
      DIMENSION ZY2(MAXOBV)
      DIMENSION XDESGN(MAXOBV,2)
C
      EQUIVALENCE (GARBAG(IGARB1),Y1(1))
      EQUIVALENCE (GARBAG(IGARB2),Y2(1))
      EQUIVALENCE (GARBAG(IGARB3),TOP(1))
      EQUIVALENCE (GARBAG(IGARB4),BOTTOM(1))
      EQUIVALENCE (GARBAG(IGARB5),PCC(1))
      EQUIVALENCE (GARBAG(IGARB7),TEMP1(1))
      EQUIVALENCE (GARBAG(IGARB8),TEMP2(1))
      EQUIVALENCE (GARBAG(IGARB9),XIDTEM(1))
      EQUIVALENCE (GARBAG(IGAR10),XIDTE2(1))
      EQUIVALENCE (GARBAG(JGAR11),XIDTE3(1))
      EQUIVALENCE (GARBAG(JGAR12),ZY1(1))
      EQUIVALENCE (GARBAG(JGAR13),ZY2(1))
      EQUIVALENCE (GARBAG(JGAR14),XDESGN(1,1))
CCCCC END CHANGE
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOHK.INC'
      INCLUDE 'DPCODA.INC'
CCCCC ADD FOLLOWING LINE JULY 1999
      INCLUDE 'DPCOST.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IFOUND='NO'
      IERROR='NO'
      IMULT='OFF'
      IREPL='OFF'
C
      ISUBN1='DPCO'
      ISUBN2='RR  '
C
      MAXCP1=MAXCOL+1
      MAXCP2=MAXCOL+2
      MAXCP3=MAXCOL+3
      MAXCP4=MAXCOL+4
      MAXCP5=MAXCOL+5
      MAXCP6=MAXCOL+6
C
C               **************************************************
C               **  TREAT THE FOLLOWING CASES--                  *
C               **        1) AUTOCORRELATION                     *
C               **        2) CROSS-CORRELATION;                  *
C               **        3) PARTIAL AUTO-CORRELATION;           *
C               **************************************************
C
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'CORR')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPCORR--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)ICASPL,IAND1,IAND2
   52   FORMAT('ICASPL,IAND1,IAND2 = ',2(A4,2X),A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,53)IBUGG2,IBUGG3,IBUGQ,ISUBRO
   53   FORMAT('IBUGG2,IBUGG3,IBUGQ,ISUBRO = ',3(A4,2X),A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               ***************************
C               **  STEP 1--             **
C               **  EXTRACT THE COMMAND  **
C               ***************************
C
      ISTEPN='1'
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'CORR')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C               ***************************************
C               **  STEP 1.1--                       **
C               **  SEARCH FOR AUTOCORRELATION PLOT, **
C               **  PARTIAL CORRELATION, OR          **
C               **  CROSS-CORRELATION.  ALSO LOOK    **
C               **  MULTIPLE OR REPLICATION.         **
C               ***************************************
C
      IF(ICOM.EQ.'MULT')IMULT='ON'
      IF(ICOM.EQ.'REPL')IREPL='ON'
C
      IF(NUMARG.GE.2 .AND.
     1   ICOM.EQ.'AUTO'.AND.IHARG(1).EQ.'CORR'.AND.
     1   IHARG(2).EQ.'PLOT')THEN
        ICASPL='AUCO'
        ILASTC=2
      ELSEIF(NUMARG.GE.1 .AND.
     1   ICOM.EQ.'AUTO'.AND.ICOM2.EQ.'CORR'.AND.
     1   IHARG(1).EQ.'PLOT')THEN
        ICASPL='AUCO'
        ILASTC=1
      ELSEIF(NUMARG.GE.2 .AND.
     1   IHARG(1).EQ.'AUTO'.AND.IHARG2(1).EQ.'CORR'.AND.
     1   IHARG(2).EQ.'PLOT')THEN
        ICASPL='AUCO'
        ILASTC=2
      ELSEIF(NUMARG.GE.3 .AND.
     1   IHARG(1).EQ.'AUTO'.AND.IHARG(2).EQ.'CORR'.AND.
     1   IHARG(3).EQ.'PLOT')THEN
        ICASPL='AUCO'
        ILASTC=3
      ELSEIF(NUMARG.GE.2 .AND.
     1   ICOM.EQ.'CROS'.AND.IHARG(1).EQ.'CORR'.AND.
     1   IHARG(2).EQ.'PLOT')THEN
        ICASPL='CRCO'
        ILASTC=2
      ELSEIF(NUMARG.GE.1 .AND.
     1   ICOM.EQ.'CROS'.AND.ICOM2.EQ.'SCOR'.AND.
     1   IHARG(1).EQ.'PLOT')THEN
        ICASPL='CRCO'
        ILASTC=1
      ELSEIF(NUMARG.GE.3 .AND.
     1   IHARG(1).EQ.'CROS'.AND.IHARG(2).EQ.'CORR'.AND.
     1   IHARG(3).EQ.'PLOT')THEN
        ICASPL='CRCO'
        ILASTC=3
      ELSEIF(NUMARG.GE.1 .AND.
     1   IHARG(1).EQ.'CROS'.AND.IHARG2(1).EQ.'SCOR'.AND.
     1   IHARG(2).EQ.'PLOT')THEN
        ICASPL='CRCO'
        ILASTC=2
      ELSEIF(NUMARG.GE.3 .AND.
     1   ICOM.EQ.'PART'.AND.IHARG(1).EQ.'AUTO'.AND.
     1   IHARG(2).EQ.'CORR'.AND.IHARG(3).EQ.'PLOT')THEN
        ICASPL='PACO'
        ILASTC=3
      ELSEIF(NUMARG.GE.2 .AND.
     1   ICOM.EQ.'PART'.AND.IHARG(1).EQ.'AUTO'.AND.
     1   IHARG2(1).EQ.'CORR'.AND.IHARG(2).EQ.'PLOT')THEN
        ICASPL='PACO'
        ILASTC=2
      ELSEIF(NUMARG.GE.4 .AND.
     1   IHARG(1).EQ.'PART'.AND.IHARG(2).EQ.'AUTO'.AND.
     1   IHARG(3).EQ.'CORR'.AND.IHARG(4).EQ.'PLOT')THEN
        ICASPL='PACO'
        ILASTC=4
      ELSEIF(NUMARG.GE.3 .AND.
     1   IHARG(1).EQ.'PART'.AND.IHARG(2).EQ.'AUTO'.AND.
     1   IHARG2(2).EQ.'CORR'.AND.IHARG(3).EQ.'PLOT')THEN
        ICASPL='PACO'
        ILASTC=3
      ELSEIF(NUMARG.GE.2 .AND.
     1   ICOM.EQ.'AUTO'.AND.IHARG(1).EQ.'COMO'.AND.
     1   IHARG(2).EQ.'PLOT')THEN
        ICASPL='AUCM'
        ILASTC=2
      ELSEIF(NUMARG.GE.1 .AND.
     1   ICOM.EQ.'AUTO'.AND.ICOM2.EQ.'COMO'.AND.
     1   IHARG(1).EQ.'PLOT')THEN
        ICASPL='AUCM'
        ILASTC=1
      ELSEIF(NUMARG.GE.2 .AND.
     1   IHARG(1).EQ.'AUTO'.AND.IHARG2(1).EQ.'COMO'.AND.
     1   IHARG(2).EQ.'PLOT')THEN
        ICASPL='AUCM'
        ILASTC=2
      ELSEIF(NUMARG.GE.3 .AND.
     1   IHARG(1).EQ.'AUTO'.AND.IHARG(2).EQ.'CORR'.AND.
     1   IHARG(3).EQ.'PLOT')THEN
        ILASTC=3
      ELSEIF(NUMARG.GE.2 .AND.
     1   ICOM.EQ.'CROS'.AND.IHARG(1).EQ.'COMO'.AND.
     1   IHARG(2).EQ.'PLOT')THEN
        ICASPL='CRCM'
        ILASTC=2
      ELSEIF(NUMARG.GE.1 .AND.
     1   ICOM.EQ.'CROS'.AND.ICOM2.EQ.'SCOM'.AND.
     1   IHARG(1).EQ.'PLOT')THEN
        ICASPL='CRCM'
        ILASTC=1
      ELSEIF(NUMARG.GE.3 .AND.
     1   IHARG(1).EQ.'CROS'.AND.IHARG(2).EQ.'COMO'.AND.
     1   IHARG(3).EQ.'PLOT')THEN
        ICASPL='CRCM'
        ILASTC=3
      ELSEIF(NUMARG.GE.1 .AND.
     1   IHARG(1).EQ.'CROS'.AND.IHARG2(1).EQ.'SCOM'.AND.
     1   IHARG(2).EQ.'PLOT')THEN
        ICASPL='CRCM'
        ILASTC=2
      ELSE
        ICASPL='    '
        IFOUND='NO'
        GOTO9000
      ENDIF
C
      IF(IMULT.EQ.'ON')THEN
        IF(IREPL.EQ.'ON')THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,101)
  101     FORMAT('***** ERROR IN ...CORRELATION/COMOVEMENT PLOT--')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,102)
  102     FORMAT('      YOU CANNOT SPECIFY BOTH "MULTIPLE" AND ',
     1           '"REPLICATION" FOR THIS PLOT.')
          CALL DPWRST('XXX','BUG ')
          IERROR='YES'
          GOTO9000
        ELSEIF(ICASPL.NE.'AUCO' .AND. ICASPL.NE.'AUCM')THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,101)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,107)
  107     FORMAT('      THE "MULTIPLE" OPTION IS ONLY SUPPORTED FOR')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,109)
  109     FORMAT('      AUTOCORRELATION PLOT.')
          CALL DPWRST('XXX','BUG ')
          IERROR='YES'
          GOTO9000
        ENDIF
      ENDIF
C
      CALL ADJUST(ILASTC,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG)
      IFOUND='YES'
C
C               ****************************************
C               **  STEP 2--                          **
C               **  EXTRACT THE VARIABLE LIST         **
C               ****************************************
C
      ISTEPN='2'
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'CORR')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      INAME='AUTOCORRELATION PLOT'
      IF(ICASPL.EQ.'PACO')INAME='PARTIAL AUTOCORRELATION PLOT'
      IF(ICASPL.EQ.'CRCO')INAME='CROSS-CORRELATION PLOT'
      IF(ICASPL.EQ.'AUCM')INAME='AUTOCOMOVEMENT PLOT'
      IF(ICASPL.EQ.'CRCM')INAME='CROSS-COMOVEMENT PLOT'
      MINNA=1
      MAXNA=100
      MINN2=1
      IFLAGE=1
      IFLAGM=1
      IFLAGP=0
      JMIN=1
      JMAX=NUMARG
      IF(ICASPL.EQ.'AUCO' .OR. ICASPL.EQ.'AUCM')THEN
        MINNVA=1
        MAXNVA=1
      ELSE
        MINNVA=2
        MAXNVA=2
      ENDIF
      IF(IREPL.EQ.'ON')THEN
        MINNVA=MINNVA+1
        MAXNVA=MAXNVA+2
      ELSEIF(IMULT.EQ.'ON')THEN
        MINNVA=1
        MAXNVA=MAXSPN
        IFLAGE=0
      ENDIF
C
      CALL DPPARS(IHARG,IHARG2,IARGT,ARG,NUMARG,IANS,IWIDTH,
     1            IHNAME,IHNAM2,IUSE,NUMNAM,IN,IVALUE,VALUE,
     1            JMIN,JMAX,
     1            MINN2,MINNA,MAXNA,MAXSPN,IFLAGE,INAME,
     1            IVARN1,IVARN2,IVARTY,PVAR,
     1            ILIS,NRIGHT,ICOLR,ISUB,NQ,ILOCQ,NUMVAR,
     1            MINNVA,MAXNVA,
     1            IFLAGM,IFLAGP,
     1            IBUGG3,IBUGQ,ISUBRO,IFOUND,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'CORR')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,281)
  281   FORMAT('***** AFTER CALL DPPARS--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,282)NQ,NUMVAR
  282   FORMAT('NQ,NUMVAR = ',2I8)
        CALL DPWRST('XXX','BUG ')
        IF(NUMVAR.GT.0)THEN
          DO285I=1,NUMVAR
            WRITE(ICOUT,287)I,IVARN1(I),IVARN2(I),ILIS(I),NRIGHT(I),
     1                      ICOLR(I)
  287       FORMAT('I,IVARN1(I),IVARN2(I),ILIS(I),NRIGHT(I),',
     1             'ICOLR(I) = ',I8,2X,A4,A4,2X,3I8)
            CALL DPWRST('XXX','BUG ')
  285     CONTINUE
        ENDIF
      ENDIF
C
      NRESP=0
      NREPL=0
      IF(ICASPL.NE.'AUCO' .OR. ICASPL.EQ.'AUCM')THEN
        IF(IREPL.EQ.'OFF' .AND. NUMVAR.GT.1)IMULT='ON'
      ENDIF
      IF(IMULT.EQ.'ON')THEN
        NRESP=NUMVAR
      ELSEIF(IREPL.EQ.'ON')THEN
        NRESP=1
        NREPL=NUMVAR-NRESP
        IF(NREPL.LT.1 .OR. NREPL.GT.2)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,101)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,511)
  511     FORMAT('      FOR THE REPLICATION CASE, THE NUMBER OF ',
     1           'REPLICATION VARIABLES')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,512)
  512     FORMAT('      MUST BE BETWEEN 1 AND 2;  SUCH WAS NOT THE ',
     1           'CASE HERE.')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,513)NREPL
  513     FORMAT('      THE NUMBER OF REPLICATION VARIABLES = ',I5)
          CALL DPWRST('XXX','BUG ')
          IERROR='YES'
          GOTO9000
        ENDIF
      ELSE
        NRESP=1
      ENDIF
C
      IF(IBUGG2.EQ.'ON' .OR. ISUBRO.EQ.'CORR')THEN
        WRITE(ICOUT,112)ICASPL,IMULT,IREPL
  112   FORMAT('ICASPL,IMULT,IREPL = ',2(A4,2X),A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               **********************************************************
C               **  STEP 8--                                            **
C               **  DETERMINE IF THE ANALYST                            **
C               **  HAS SPECIFIED THE NUMBER OF LAGS DESIRED            **
C               **  FOR THE CROSS-CORRELATION PLOT.                     **
C               **  THE LAG SETTING IS DONE BY SEARCHING THE            **
C               **  INTERNAL TABLE FOR THE PARAMETER NAMES              **
C               **  LAGS, LAG, OR NUMLAG                                **
C               **  (WITH THE SEARCH CONDUCTED IN THAT ORDER            **
C               **  AND WITH THE FIRST FIND TERMINATING                 **
C               **  THE SEARCH.)                                        **
C               **  IF FOUND, USE THE SPECIFIED VALUE                   **
C               **  (WHICH MUST BE BETWEEN 1 AND 1000, INCLUSIVE);      **
C               **  IF NOT FOUND, USE THE DEFAULT VALUE                 **
C               **  (USUALLY NS/4) WHICH WILL BE DEFINED                **
C               **  IN THE SUBROUTINE DPCOR2.                           **
C               **********************************************************
C
      ISTEPN='8'
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'CORR')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NUMLAG=0
C
      IH='LAGS'
      IH2='    '
      IHWUSE='P'
      MESSAG='NO'
      CALL CHECKN(IH,IH2,IHWUSE,
     1IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOCV,IERROR)
      IF(IERROR.EQ.'NO')THEN
        NUMLAG=VALUE(ILOCV)+0.5
        GOTO790
      ENDIF
C
      IH='LAG '
      IH2='    '
      IHWUSE='P'
      MESSAG='NO'
      CALL CHECKN(IH,IH2,IHWUSE,
     1IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOCV,IERROR)
      IF(IERROR.EQ.'NO')THEN
        NUMLAG=VALUE(ILOCV)+0.5
        IF(IERROR.EQ.'NO')GOTO790
      ENDIF
C
      IH='NUML'
      IH2='AG  '
      IHWUSE='P'
      MESSAG='NO'
      CALL CHECKN(IH,IH2,IHWUSE,
     1IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOCV,IERROR)
      IF(IERROR.EQ.'NO')THEN
        NUMLAG=VALUE(ILOCV)+0.5
        IF(IERROR.EQ.'NO')GOTO790
      ENDIF
C
  790 CONTINUE
C
C               ********************************************
C               **  STEP 6--                              **
C               **  GENERATE THE CORRELATION    PLOTS FOR **
C               **  THE VARIOUS CASES.                    **
C               ********************************************
C
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'CORR')THEN
        ISTEPN='6'
        CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
        WRITE(ICOUT,601)NRESP,NREPL
  601   FORMAT('NRESP,NREPL = ',2I5)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      IF(NREPL.EQ.0)THEN
        ISTEPN='8A'
        IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'CORR')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C       LOOP THROUGH EACH OF THE RESPONSE VARIABLES
C
        NPLOTP=0
        ISKIP=2
        IF(ICASPL.EQ.'AUCO' .OR. ICASPL.EQ.'AUCM')ISKIP=1
        DO810IRESP=1,NRESP,ISKIP
          NCURVE=IRESP
C
          IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'CORR')THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,811)IRESP,NCURVE
  811       FORMAT('IRESP,NCURVE = ',2I5)
            CALL DPWRST('XXX','BUG ')
          ENDIF
C
          ICOL=IRESP
          NUMVA2=2
          IF(ICASPL.EQ.'AUCO' .OR. ICASPL.EQ.'AUCM')NUMVA2=1
          CALL DPPAR3(ICOL,IVALUE,IVALU2,IN,MAXN,MAXOBV,
     1                INAME,IVARN1,IVARN2,IVARTY,
     1                ILIS,NRIGHT,ICOLR,ISUB,NQ,NUMVA2,
     1                MAXCOL,MAXCP1,MAXCP2,MAXCP3,
     1                MAXCP4,MAXCP5,MAXCP6,
     1                V,PRED,RES,YPLOT,XPLOT,X2PLOT,TAGPLO,
     1                Y1,Y2,Y2,NS,NS,NS,ICASE,
     1                IBUGG3,ISUBRO,IFOUND,IERROR)
          IF(IERROR.EQ.'YES')GOTO9000
C
C               *****************************************************
C               **  STEP 8B--                                      **
C               **  FORM THE VERTICAL AND HORIZONTAL AXIS          **
C               **  VALUES Y(.) AND X(.) FOR THE PLOT.             **
C               *****************************************************
C
         CALL DPCOR2(Y1,Y2,NS,NCURVE,ICASPL,NUMLAG,MAXN,
     1               IAUTCP,IAUTL0,TEMP1,TEMP2,
     1               Y,X,D,TOP,BOTTOM,PCC,NPLOTP,NPLOTV,
     1               IBUGG3,ISUBRO,IERROR)
C
  810   CONTINUE
C
C               *****************************************************
C               **  STEP 9A--                                      **
C               **  CASE 3: ONE OR TWO  REPLICATION VARIABLES.     **
C               **          FOR THIS CASE, THE NUMBER OF RESPONSE  **
C               **          VARIABLES MUST BE EXACTLY 1.           **
C               *****************************************************
C
      ELSEIF(NREPL.GE.1)THEN
        ISTEPN='9A'
        IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'CORR')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
        J=0
        IMAX=NRIGHT(1)
        IF(NQ.LT.NRIGHT(1))IMAX=NQ
        DO910I=1,IMAX
          IF(ISUB(I).EQ.0)GOTO910
          J=J+1
C
C         RESPONSE VARIABLE IN Y1
C
          IJ=MAXN*(ICOLR(1)-1)+I
          IF(ICOLR(1).LE.MAXCOL)Y1(J)=V(IJ)
          IF(ICOLR(1).EQ.MAXCP1)Y1(J)=PRED(I)
          IF(ICOLR(1).EQ.MAXCP2)Y1(J)=RES(I)
          IF(ICOLR(1).EQ.MAXCP3)Y1(J)=YPLOT(I)
          IF(ICOLR(1).EQ.MAXCP4)Y1(J)=XPLOT(I)
          IF(ICOLR(1).EQ.MAXCP5)Y1(J)=X2PLOT(I)
          IF(ICOLR(1).EQ.MAXCP6)Y1(J)=TAGPLO(I)
          ICOLC=1
C
C         SECOND RESPONSE VARIABLE IN Y2
C
          IF(ICASPL.NE.'AUCO' .AND. ICASPL.NE.'AUCM')THEN
            IJ=MAXN*(ICOLR(2)-1)+I
            IF(ICOLR(2).LE.MAXCOL)Y2(J)=V(IJ)
            IF(ICOLR(2).EQ.MAXCP1)Y2(J)=PRED(I)
            IF(ICOLR(2).EQ.MAXCP2)Y2(J)=RES(I)
            IF(ICOLR(2).EQ.MAXCP3)Y2(J)=YPLOT(I)
            IF(ICOLR(2).EQ.MAXCP4)Y2(J)=XPLOT(I)
            IF(ICOLR(2).EQ.MAXCP5)Y2(J)=X2PLOT(I)
            IF(ICOLR(2).EQ.MAXCP6)Y2(J)=TAGPLO(I)
            ICOLC=2
          ENDIF
C
          DO920IR=1,MIN(NREPL,2)
            ICOLC=ICOLC+1
            ICOLT=ICOLR(ICOLC)
            IJ=MAXN*(ICOLT-1)+I
            IF(ICOLT.LE.MAXCOL)XDESGN(J,IR)=V(IJ)
            IF(ICOLT.EQ.MAXCP1)XDESGN(J,IR)=PRED(I)
            IF(ICOLT.EQ.MAXCP2)XDESGN(J,IR)=RES(I)
            IF(ICOLT.EQ.MAXCP3)XDESGN(J,IR)=YPLOT(I)
            IF(ICOLT.EQ.MAXCP4)XDESGN(J,IR)=XPLOT(I)
            IF(ICOLT.EQ.MAXCP5)XDESGN(J,IR)=X2PLOT(I)
            IF(ICOLT.EQ.MAXCP6)XDESGN(J,IR)=TAGPLO(I)
  920     CONTINUE
C
  910   CONTINUE
        NLOCAL=J
C
C       *****************************************************
C       **  STEP 9B--                                      **
C       **  FORM THE VERTICAL AND HORIZONTAL AXIS          **
C       **  VALUES Y(.) AND X(.) FOR THE PLOT.             **
C       **                                                 **
C       **  FOR THIS CASE, WE NEED TO LOOP THROUGH THE     **
C       **  VARIOUS REPLICATIONS.                          **
C       *****************************************************
C
        ISTEPN='9B'
        IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'CORR')THEN
          CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,931)
  931     FORMAT('***** FROM THE MIDDLE  OF DPCORR--')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,932)ICASPL,NUMVAR,NLOCAL
  932     FORMAT('ICASPL,NUMVAR,NLOCAL = ',A4,2I8)
          CALL DPWRST('XXX','BUG ')
          IF(NLOCAL.GE.1)THEN
            DO935I=1,NLOCAL
              WRITE(ICOUT,936)I,Y1(I),XDESGN(I,1),XDESGN(I,2)
  936         FORMAT('I,Y1(I),XDESGN(I,1),XDESGN(I,2) = ',I8,3F12.5)
              CALL DPWRST('XXX','BUG ')
  935       CONTINUE
          ENDIF
        ENDIF
C
C       *****************************************************
C       **  STEP 9C--                                      **
C       **  FIND THE DISTINCT VALUES IN EACH OF THE        **
C       **  REPLICATION VARIABLES.                         **
C       *****************************************************
C
        CALL DPFRE5(XDESGN(1,1),XDESGN(1,2),
     1             NREPL,NLOCAL,MAXOBV,
     1             XIDTEM,XIDTE2,
     1             TEMP1,TEMP2,
     1             NUMSE1,NUMSE2,
     1             IBUGG3,ISUBRO,IERROR)
C
C       *****************************************************
C       **  STEP 9D--                                      **
C       **  NOW LOOP THROUGH THE VARIOUS REPLICATIONS      **
C       *****************************************************
C
        NPLOTP=0
        NCURVE=0
        IF(NREPL.EQ.1)THEN
          J=0
          DO1110ISET1=1,NUMSE1
            K=0
            DO1130I=1,NLOCAL
              IF(XIDTEM(ISET1).EQ.XDESGN(I,1))THEN
                K=K+1
                ZY1(K)=Y1(I)
                ZY2(K)=Y2(I)
              ENDIF
 1130       CONTINUE
            NTEMP=K
            NCURVE=NCURVE+1
            IF(NTEMP.GT.0)THEN
              CALL DPCOR2(ZY1,ZY2,NTEMP,NCURVE,ICASPL,NUMLAG,MAXN,
     1                    IAUTCP,IAUTL0,TEMP1,TEMP2,
     1                    Y,X,D,TOP,BOTTOM,PCC,NPLOTP,NPLOTV,
     1                    IBUGG3,ISUBRO,IERROR)
            ENDIF
 1110     CONTINUE
        ELSEIF(NREPL.EQ.2)THEN
          J=0
          NTOT=NUMSE1*NUMSE2
          DO1210ISET1=1,NUMSE1
          DO1220ISET2=1,NUMSE2
            K=0
            DO1290I=1,NLOCAL
              IF(
     1           XIDTEM(ISET1).EQ.XDESGN(I,1) .AND.
     1           XIDTE2(ISET2).EQ.XDESGN(I,2)
     1          )THEN
                K=K+1
                ZY1(K)=Y1(I)
                ZY2(K)=Y2(I)
              ENDIF
 1290       CONTINUE
            NTEMP=K
            NCURVE=NCURVE+1
            IF(NTEMP.GT.0)THEN
              CALL DPCOR2(ZY1,ZY2,NTEMP,NCURVE,ICASPL,NUMLAG,MAXN,
     1                    IAUTCP,IAUTL0,TEMP1,TEMP2,
     1                    Y,X,D,TOP,BOTTOM,PCC,NPLOTP,NPLOTV,
     1                    IBUGG3,ISUBRO,IERROR)
            ENDIF
 1220     CONTINUE
 1210     CONTINUE
        ENDIF
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'CORR')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPCORR--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)IFOUND,IERROR,NUMLAG,MAXN
 9012   FORMAT('IFOUND,IERROR,NUMLAG,MAXN = ',2(A4,2X),2I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)NPLOTV,NPLOTP,NS,ICASPL,IAND1,IAND2
 9013   FORMAT('NPLOTV,NPLOTP,NS,ICASPL,IAND1,IAND2 = ',3I8,3(2X,A4))
        CALL DPWRST('XXX','BUG ')
        IF(NPLOTP.LE.0)THEN
          DO9015I=1,NPLOTP
            WRITE(ICOUT,9016)I,Y(I),X(I),D(I)
 9016       FORMAT('I,Y(I),X(I),D(I) = ',I8,3G15.7)
            CALL DPWRST('XXX','BUG ')
 9015     CONTINUE
        ENDIF
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPCOVA(K,NLEFT,XOUT)
C
C     PURPOSE--COPY THE NLEFT ELEMENTS OF VARIABLE K INTO XOUT().
C
C---------------------------------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCODA.INC'
C
      DIMENSION XOUT(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      J=0
      DO1000I=1,NLEFT
      IF(ISUB(I).EQ.0)GOTO1000
      J=J+1
      IJ=MAXN*(K-1)+I
      IF(K.LE.MAXCOL)XOUT(J)=V(IJ)
      IF(K.EQ.(MAXCOL+1))XOUT(J)=PRED(I)
      IF(K.EQ.(MAXCOL+2))XOUT(J)=RES(I)
      IF(K.EQ.(MAXCOL+3))XOUT(J)=YPLOT(I)
      IF(K.EQ.(MAXCOL+4))XOUT(J)=XPLOT(I)
      IF(K.EQ.(MAXCOL+5))XOUT(J)=X2PLOT(I)
      IF(K.EQ.(MAXCOL+6))XOUT(J)=TAGPLO(I)
 1000 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPCPU(ICOM,IHARG,IHARG2,IARGT,IARG,ARG,NUMARG,
     1                 ATIME,
     1                 IBUGS2,ISUBRO,IFOUND,IERROR)
C
C     PURPOSE--RETURN THE AMOUNT OF CPU TIME CURRENTLY USED AND SAVE
C              IN THE INTERNAL PARAMETER   CPUTIME  .
C              THERE IS A FORTRAN 90 STANDARD, BUT NOT A FORTRAN 77
C              STANDARD, SO CALL DPCPUT (IN THE DP1.FOR
C              MACHINE DEPENDENT CODE FILE).
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 STATISTICAL ENGINEEERING DIVISION
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2009.5
C     ORIGINAL VERSION--MAY        2009.
C
C-----NON-COMMON VARIABLES (GRAPHICS)---------------------------------
C
      CHARACTER*4 ICOM
      CHARACTER*4 IHARG
      CHARACTER*4 IHARG2
      CHARACTER*4 IARGT
C
      CHARACTER*4 IBUGS2
      CHARACTER*4 ISUBRO
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
      DIMENSION IHARG(*)
      DIMENSION IHARG2(*)
      DIMENSION IARG(*)
      DIMENSION ARG(*)
      DIMENSION IARGT(*)
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IFOUND='NO'
      IERROR='NO'
C
      J2=0
C
      IF(IBUGS2.EQ.'ON'.OR.ISUBRO.EQ.'PCPU')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPCPU--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,81)IBUGS2,ISUBRO
   81   FORMAT('IBUGS2,ISUBRO = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,82)IFOUND,IERROR
   82   FORMAT('IFOUND,IERROR = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               *****************************************************
C               **  STEP 1--                                       **
C               **  CHECK FOR THE COMMAND                          **
C               *****************************************************
C
      IF(ICOM.EQ.'CPU ')THEN
        IFOUND='YES'
        CALL DPCPUT(ATIME,IBUGS2,ISUBRO,IFOUND,IERROR)
C
        IF(IFEEDB.EQ.'ON')THEN
          WRITE(ICOUT,1001)ATIME
 1001     FORMAT('THE CURRENT CPU USAGE IS ',G15.7)
          CALL DPWRST('XXX','BUG ')
        ENDIF
C
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGS2.EQ.'ON'.OR.ISUBRO.EQ.'PCPU')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPCPU--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9031)IBUGS2,ISUBRO
 9031   FORMAT('IBUGS2,ISUBRO = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9032)IFOUND,IERROR
 9032   FORMAT('IFOUND,IERROR = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9033)ATIME
 9033   FORMAT('ATIME = ',G15.7)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPCR(IHARG,NUMARG,
     1IDEFCR,
     1ITEXCR,
     1IBUGD2,ISUBRO,IFOUND,IERROR)
C
C     PURPOSE--DEFINE THE CARRIAGE RETURN SWITCH (ON OR OFF) FOR
C              TEXT SCRIPT.
C              THE CARRIAGE RETURN SWITCH WILL BE PLACED
C              IN THE CHARACTER VARIABLE ITEXCR.
C     INPUT  ARGUMENTS--IHARG  (A  CHARACTER VECTOR)
C                     --NUMARG
C                     --IDEFCR
C                     --IBUGD2
C     OUTPUT ARGUMENTS--ITEXCR
C                     --IFOUND ('YES' OR 'NO' )
C                     --IERROR ('YES' OR 'NO' )
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--APRIL     1981.
C     UPDATED         --MAY       1982.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IHARG
      CHARACTER*4 IDEFCR
      CHARACTER*4 ITEXCR
      CHARACTER*4 IBUGD2
      CHARACTER*4 ISUBRO
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
C---------------------------------------------------------------------
C
      DIMENSION IHARG(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IFOUND='NO'
      IERROR='NO'
C
      IF(IBUGD2.EQ.'OFF')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF DPCR--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)IDEFCR
   53 FORMAT('IDEFCR = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)NUMARG
   54 FORMAT('NUMARG = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO55I=1,NUMARG
      WRITE(ICOUT,56)I,IHARG(I)
   56 FORMAT('I,IHARG(I) = ',I8,2X,A4)
      CALL DPWRST('XXX','BUG ')
   55 CONTINUE
   90 CONTINUE
C
C               **************************************
C               **  TREAT THE CARRIAGE RETURN CASE  **
C               **************************************
C
      IF(NUMARG.LE.0)GOTO1161
      IF(NUMARG.EQ.1.AND.IHARG(1).EQ.'RETU')GOTO1161
      IF(IHARG(NUMARG).EQ.'ON')GOTO1161
      IF(IHARG(NUMARG).EQ.'OFF')GOTO1162
      IF(IHARG(NUMARG).EQ.'AUTO')GOTO1161
      IF(IHARG(NUMARG).EQ.'DEFA')GOTO1165
      GOTO1170
C
 1161 CONTINUE
      ITEXCR='ON'
      GOTO1180
C
 1162 CONTINUE
      ITEXCR='OFF'
      GOTO1180
C
 1165 CONTINUE
      ITEXCR=IDEFCR
      GOTO1180
C
 1170 CONTINUE
      IERROR='YES'
      WRITE(ICOUT,1171)
 1171 FORMAT('***** ERROR IN DPCR--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1172)
 1172 FORMAT('      ILLEGAL ENTRY FOR CARRIAGE RETURN ',
     1'COMMAND.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1173)
 1173 FORMAT('      TEST EXAMPLE TO DEMONSTRATE THE ',
     1'PROPER FORM--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1174)
 1174 FORMAT('      SUPPOSE THE THE ANALYST WISHES ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1175)
 1175 FORMAT('      TO HAVE A CARRIAGE RETURN AFTER THE TEXT ',
     1'COMMAND,')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1177)
 1177 FORMAT('      THEN ALLOWABLE FORMS ARE--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1178)
 1178 FORMAT('           CARRIAGE RETURN ON     (OR   CR ON) ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1179)
 1179 FORMAT('           CARRIAGE RETURN        (OR   CR) ')
      CALL DPWRST('XXX','BUG ')
      GOTO9000
C
 1180 CONTINUE
      IFOUND='YES'
C
      IF(IFEEDB.EQ.'OFF')GOTO1189
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1181)
 1181 FORMAT('THE CARRIAGE RETURN (AFTER TEXT) ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1182)ITEXCR
 1182 FORMAT('HAS JUST BEEN SET TO ',A4)
      CALL DPWRST('XXX','BUG ')
 1189 CONTINUE
      GOTO9000
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGD2.EQ.'OFF')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF DPCR')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGD2,ISUBRO,IFOUND,IERROR
 9012 FORMAT('IBUGD2,ISUBRO,IFOUND,IERROR = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)IDEFCR,ITEXCR
 9013 FORMAT('IDEFCR,ITEXCR = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPCRCI(XTEMP1,XTEMP2,MAXNXT,
     1                  ICAPSW,IFORSW,
     1                  IBUGA2,IBUGA3,IBUGQ,ISUBRO,IFOUND,IERROR)
C
C     PURPOSE--GENERATE CONFIDENCE LIMITS FOR THE CORRELATION
C              COEFFICIENT
C     EXAMPLE--CORRELATION CONFIDENCE LIMTIS Y1 Y2
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2012/6
C     ORIGINAL VERSION--JUNE      2012.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 IFORSW
      CHARACTER*4 IBUGA2
      CHARACTER*4 IBUGA3
      CHARACTER*4 IBUGQ
      CHARACTER*4 ISUBRO
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
      CHARACTER*4 IHWUSE
      CHARACTER*4 MESSAG
C
      CHARACTER*4 IH
      CHARACTER*4 IH2
      CHARACTER*4 IHOST1
      CHARACTER*4 ISUBN0
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      CHARACTER*4 ICASE
      CHARACTER*4 IVARID
      CHARACTER*4 IVARI2
      CHARACTER*4 IVARI3
      CHARACTER*4 IVARI4
      CHARACTER*40 INAME
      PARAMETER (MAXSPN=30)
      CHARACTER*4 IVARN1(MAXSPN)
      CHARACTER*4 IVARN2(MAXSPN)
      CHARACTER*4 IVARTY(MAXSPN)
      REAL PVAR(MAXSPN)
      INTEGER ILIS(MAXSPN)
      INTEGER NRIGHT(MAXSPN)
      INTEGER ICOLR(MAXSPN)
C
      CHARACTER*4 IFLAGU
      LOGICAL IFRST
      LOGICAL ILAST
C
C---------------------------------------------------------------------
C
      DIMENSION XTEMP1(*)
      DIMENSION XTEMP2(*)
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCOHK.INC'
      INCLUDE 'DPCOSU.INC'
      INCLUDE 'DPCODA.INC'
      INCLUDE 'DPCOST.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPCR'
      ISUBN2='CI  '
C
      MAXCP1=MAXCOL+1
      MAXCP2=MAXCOL+2
      MAXCP3=MAXCOL+3
      MAXCP4=MAXCOL+4
      MAXCP5=MAXCOL+5
      MAXCP6=MAXCOL+6
C
      IFOUND='YES'
      IERROR='NO'
C
C               *******************************************************
C               **  TREAT THE CORRELATION CONFIDENCE LIMITS CASE     **
C               *******************************************************
C
      IF(IBUGA2.EQ.'ON' .OR. ISUBRO.EQ.'CRCI')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPCRCI--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGA2,IBUGA3,IBUGQ,ISUBRO,MAXNXT
   52   FORMAT('IBUGA2,IBUGA3,IBUGQ,ISUBRO,MAXNXT = ',4(A4,2X),I8)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               ****************************************
C               **  STEP 2--                          **
C               **  EXTRACT THE VARIABLE LIST         **
C               ****************************************
C
      ISTEPN='2'
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'CRCI')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      INAME='CORRELATION CONFIDENCE LIMITS'
      MINNA=1
      MAXNA=100
      MINN2=4
      IFLAGE=1
      IFLAGM=1
      MINNVA=2
      MAXNVA=MAXSPN
      IFLAGP=0
      JMIN=1
      JMAX=NUMARG
C
      CALL DPPARS(IHARG,IHARG2,IARGT,ARG,NUMARG,IANS,IWIDTH,
     1            IHNAME,IHNAM2,IUSE,NUMNAM,IN,IVALUE,VALUE,
     1            JMIN,JMAX,
     1            MINN2,MINNA,MAXNA,MAXSPN,IFLAGE,INAME,
     1            IVARN1,IVARN2,IVARTY,PVAR,
     1            ILIS,NRIGHT,ICOLR,ISUB,NQ,ILOCQ,NUMVAR,
     1            MINNVA,MAXNVA,
     1            IFLAGM,IFLAGP,
     1            IBUGA3,IBUGQ,ISUBRO,IFOUND,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'CRCI')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,281)
  281   FORMAT('***** AFTER CALL DPPARS--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,282)NQ,NUMVAR
  282   FORMAT('NQ,NUMVAR = ',2I8)
        CALL DPWRST('XXX','BUG ')
        IF(NUMVAR.GT.0)THEN
          DO285I=1,NUMVAR
            WRITE(ICOUT,287)I,IVARN1(I),IVARN2(I),ILIS(I),NRIGHT(I),
     1                      ICOLR(I)
  287       FORMAT('I,IVARN1(I),IVARN2(I),ILIS(I),NRIGHT(I),',
     1             'ICOLR(I) = ',I8,2X,A4,A4,2X,3I8)
            CALL DPWRST('XXX','BUG ')
  285     CONTINUE
        ENDIF
      ENDIF
C
C               *****************************************
C               **  STEP 3A--                          **
C               **  CASE 1: TWO RESPONSE VARIABLES     **
C               **          WITH NO REPLICATION        **
C               *****************************************
C
      ISTEPN='3A'
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'CRCI')
     1  CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NUMVA2=1
      DO5210I=1,NUMVAR
        DO5220J=I+1,NUMVAR
          ICOL=I
          CALL DPPAR3(ICOL,IVALUE,IVALU2,IN,MAXN,MAXOBV,
     1                INAME,IVARN1,IVARN2,IVARTY,
     1                ILIS,NRIGHT,ICOLR,ISUB,NQ,NUMVA2,
     1                MAXCOL,MAXCP1,MAXCP2,MAXCP3,
     1                MAXCP4,MAXCP5,MAXCP6,
     1                V,PRED,RES,YPLOT,XPLOT,X2PLOT,TAGPLO,
     1                Y,Y,Y,NS1,NLOCA2,NLOCA3,ICASE,
     1                IBUGA3,ISUBRO,IFOUND,IERROR)
          IF(IERROR.EQ.'YES')GOTO9000
C
          ICOL=J
          CALL DPPAR3(ICOL,IVALUE,IVALU2,IN,MAXN,MAXOBV,
     1                INAME,IVARN1,IVARN2,IVARTY,
     1                ILIS,NRIGHT,ICOLR,ISUB,NQ,NUMVA2,
     1                MAXCOL,MAXCP1,MAXCP2,MAXCP3,
     1                MAXCP4,MAXCP5,MAXCP6,
     1                V,PRED,RES,YPLOT,XPLOT,X2PLOT,TAGPLO,
     1                X,X,X,NS1,NLOCA2,NLOCA3,ICASE,
     1                IBUGA3,ISUBRO,IFOUND,IERROR)
          IF(IERROR.EQ.'YES')GOTO9000
C
C               ***********************************************
C               **  STEP 52--                                **
C               **  GENERATE CORRELATION CONFIDENCE LIMITS   **
C               ***********************************************
C
          ISTEPN='52'
          IF(IBUGA2.EQ.'ON' .OR. ISUBRO.EQ.'CRCI')THEN
            CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,5211)
 5211       FORMAT('***** FROM DPCRCI, BEFORE CALL DPCRCI--')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,5212)I,J,NS1,MAXN
 5212       FORMAT('I,J,NS1,MAXN = ',4I8)
            CALL DPWRST('XXX','BUG ')
            DO5215II=1,MAX(NS1,NS2)
              WRITE(ICOUT,5216)II,Y(II),X(II)
 5216         FORMAT('I,Y(I),X(I) = ',I8,2G15.7)
              CALL DPWRST('XXX','BUG ')
 5215       CONTINUE
          ENDIF
C
          IVARID=IVARN1(I)
          IVARI2=IVARN2(I)
          IVARI3=IVARN1(J)
          IVARI4=IVARN2(J)
          CALL DPCRC2(Y,X,NS1,
     1                ICAPSW,ICAPTY,IFORSW,
     1                IVARID,IVARI2,IVARI3,IVARI4,
     1                CUTL90,CUTU90,CUTL95,CUTU95,CUTL99,CUTU99,
     1                IBUGA3,ISUBRO,IERROR)
          IF(IERROR.EQ.'YES')GOTO9000
C
C               ***************************************
C               **  STEP 8C--                        **
C               **  UPDATE INTERNAL DATAPLOT TABLES  **
C               ***************************************
C
          ISTEPN='8C'
          IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'CRCI')
     1      CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
          IF(NUMVAR.GT.2)THEN
            IFLAGU='FILE'
          ELSE
            IFLAGU='ON'
          ENDIF
          IFRST=.FALSE.
          ILAST=.FALSE.
          IF(I.EQ.1 .AND. J.EQ.2)IFRST=.TRUE.
          IF(I.EQ.NUMVAR .AND. J.EQ.NUMVAR)ILAST=.TRUE.
          CALL DPCRC5(CUTL90,CUTU90,CUTL95,CUTU95,CUTL99,CUTU99,
     1                IFLAGU,IFRST,ILAST,
     1                IBUGA2,IBUGA3,ISUBRO,IERROR)
C
 5220   CONTINUE
 5210 CONTINUE
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA2.EQ.'ON' .OR. ISUBRO.EQ.'CRCI')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPCRCI--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9016)IFOUND,IERROR
 9016   FORMAT('IFOUND,IERROR = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPCRC2(Y1,Y2,N,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  IVARID,IVARI2,IVARI3,IVARI4,
     1                  CUTL90,CUTU90,CUTL95,CUTU95,CUTL99,CUTU99,
     1                  IBUGA3,ISUBRO,IERROR)
C
C     PURPOSE--THIS ROUTINE GENERATES A CONFIDENCE LIMITS FOR THE
C              CORRELATION COEFFICIENT BASED ON FISHER'S NORMAL
C              APPROXIMATION.
C
C                LCL = TANH(Z - NORPPF(1 - ALPHA/2)/SQRT(N-3))
C                UCL = TANH(Z + NORPPF(1 - ALPHA/2)/SQRT(N-3))
C
C              WHERE
C
C                Z = TANH**(-1)(R)
C                  = LOG[(1+R)/(1-R)]/2
C
C     EXAMPLE--CORRELATION COEFICIENT Y1 Y2
C              SAMPLE 1 IS IN INPUT VECTOR Y1 (WITH N OBSERVATIONS).
C              SAMPLE 2 IS IN INPUT VECTOR Y2 (WITH N OBSERVATIONS).
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2012/6
C     ORIGINAL VERSION--JUNE      2012.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 IVARID
      CHARACTER*4 IVARI2
      CHARACTER*4 IVARI3
      CHARACTER*4 IVARI4
      CHARACTER*4 ICASA2
      CHARACTER*4 IBUGA3
      CHARACTER*4 ISUBRO
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      DIMENSION Y1(*)
      DIMENSION Y2(*)
C
      PARAMETER (NUMALP=7)
      REAL ALPHA(NUMALP)
      REAL ALPHSV(NUMALP)
      REAL LOWLIM(NUMALP)
      REAL UPPLIM(NUMALP)
      REAL NORVAL(NUMALP)
C
      PARAMETER(NUMCLI=4)
      PARAMETER(MAXLIN=2)
      PARAMETER (MAXROW=20)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*60 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(NUMCLI)
      CHARACTER*4  VALIGN(NUMCLI)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      INTEGER      IWHTML(NUMCLI)
      INTEGER      IWRTF(NUMCLI)
      LOGICAL IFRST
      LOGICAL ILAST
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA ALPHA/0.50, 0.75, 0.80, 0.90, 0.95, 0.99, 0.999/
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPCR'
      ISUBN2='C2  '
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'CRC2')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPCRC2--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N
   52   FORMAT('IBUGA3,ISUBRO,N = ',2(A4,2X),I8)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,N
          WRITE(ICOUT,57)I,Y1(I),Y2(I)
   57     FORMAT('I,Y1(I),Y2(I) = ',I8,2G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ******************************
C               **  STEP 1--                **
C               **  ERROR CHECK             **
C               ******************************
C
      IF(N.LT.4)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,101)
  101   FORMAT('****** ERROR IN CORRELATION CONFIDENCE LIMITS--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,113)
  113   FORMAT('     THE NUMBER OF OBSERVATIONS IS LESS THAN FOUR.')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,115)N
  115   FORMAT('     THE NUMBER OF OBSERVATIONS = ',I8)
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ENDIF
C
C
C               *****************************************
C               **  STEP 2--                           **
C               **  CARRY OUT CALCULATIONS             **
C               **  FOR CORRELATION CONFIDENCE LIMITS  **
C               *****************************************
C
      ISTEPN='2'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CRC2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IWRITE='OFF'
      CALL CORR(Y1,Y2,N,IWRITE,ACORR,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
      CALL MEAN(Y1,N,IWRITE,YMEAN1,IBUGA3,IERROR)
      CALL SD(Y1,N,IWRITE,YSD1,IBUGA3,IERROR)
      CALL MEAN(Y2,N,IWRITE,YMEAN2,IBUGA3,IERROR)
      CALL SD(Y2,N,IWRITE,YSD2,IBUGA3,IERROR)
C
      DO200I=1,NUMALP
        ALPHT=ALPHA(I)
        CALL DPCRC3(ACORR,N,ALPHT,U,Z,
     1              ALOWLM,AUPPLM,
     1              IBUGA3,ISUBRO,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
        LOWLIM(I)=ALOWLM
        UPPLIM(I)=AUPPLM
        NORVAL(I)=U
  200 CONTINUE
C
      CUTL90=LOWLIM(5)
      CUTL95=LOWLIM(6)
      CUTL99=LOWLIM(7)
      CUTU90=UPPLIM(5)
      CUTU95=UPPLIM(6)
      CUTU99=UPPLIM(7)
C
C               ******************************
C               **   STEP 3-                **
C               **   WRITE OUT EVERYTHING   **
C               ******************************
C
      ISTEPN='3'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CRC2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IPRINT.EQ.'OFF')GOTO9000
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='Confidence Limits for the Correlation Coefficient'
      NCTITL=49
      ITITLZ='(Based on Fisher Normal Approximation)'
      NCTITZ=38
C
      ICNT=1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Response Variable 1: '
      WRITE(ITEXT(ICNT)(22:25),'(A4)')IVARID(1:4)
      WRITE(ITEXT(ICNT)(26:29),'(A4)')IVARI2(1:4)
      NCTEXT(ICNT)=29
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Response Variable 2: '
      WRITE(ITEXT(ICNT)(22:25),'(A4)')IVARI3(1:4)
      WRITE(ITEXT(ICNT)(26:29),'(A4)')IVARI4(1:4)
      NCTEXT(ICNT)=29
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=1
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=1
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Summary Statistics for Variable 1:'
      NCTEXT(ICNT)=34
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(N)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=YMEAN1
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=YSD1
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=1
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Summary Statistics for Variable 2:'
      NCTEXT(ICNT)=34
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(N)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=YMEAN2
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=YSD2
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=1
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Correlation Coefficient (r):'
      NCTEXT(ICNT)=28
      AVALUE(ICNT)=ACORR
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='atanh(r):'
      NCTEXT(ICNT)=9
      AVALUE(ICNT)=Z
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=1
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      NUMROW=ICNT
      DO5210I=1,NUMROW
        NTOT(I)=15
 5210 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.TRUE.
C
      ISTEPN='9A'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CNF2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
      ISTEPN='9B'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CNF2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      ICASA2='CORR'
      DO4210I=1,NUMALP
        ALPHSV(I)=100.*ALPHA(I)
 4210 CONTINUE
      CALL DPDT11(ALPHSV,NORVAL,NORVAL,LOWLIM,UPPLIM,
     1            ICASA2,ICAPSW,ICAPTY,NUMDIG,
     1            ISUBRO,IBUGA3,IERROR)
C
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'CRC2')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPCRC2--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)IERROR
 9012   FORMAT('IERROR = ',A4)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPCRC3(R,N,ALPHA,U,Z,
     1                  ALOWLM,AUPPLM,
     1                  IBUGA3,ISUBRO,IERROR)
C
C     PURPOSE--THIS ROUTINE GENERATES A CONFIDENCE LIMITS FOR THE
C              CORRELATION COEFFICIENT BASED ON FISHER'S NORMAL
C              APPROXIMATION.
C
C                LCL = TANH(Z - NORPPF(1 - ALPHA/2)/SQRT(N-3))
C                UCL = TANH(Z + NORPPF(1 - ALPHA/2)/SQRT(N-3))
C
C              WHERE
C
C                Z = TANH**(-1)(R)
C                  = LOG[(1+R)/(1-R)]/2
C
C     EXAMPLE--CORRELATION COEFICIENT Y1 Y2
C              SAMPLE 1 IS IN INPUT VECTOR Y1 (WITH N OBSERVATIONS).
C              SAMPLE 2 IS IN INPUT VECTOR Y2 (WITH N OBSERVATIONS).
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2012/6
C     ORIGINAL VERSION--JUNE      2012.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IBUGA3
      CHARACTER*4 ISUBRO
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPCR'
      ISUBN2='C3  '
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'CRC3')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPCRC3--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N,R,ALPHA
   52   FORMAT('IBUGA3,ISUBRO,N,R,ALPHA = ',2(A4,2X),I8,2G15.7)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
C               **************************************
C               **  STEP 21--                       **
C               **  COMPUTE THE CONFIDENCE  LIMITS  **
C               **  FOR GIVEN VALUES OF R AND ALPHA **
C               **************************************
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CRC3')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      ALOWLM=CPUMIN
      AUPPLM=CPUMIN
C
      IF(R.LT.-1.0 .OR. R.GT.1.0)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,101)
  101   FORMAT('**** ERROR IN CORRELATION CONFIDENCE INTERVAL--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,103)
  103   FORMAT('     THE VALUE OF R IS OUTSIDE THE (-1,1) INTERVAL.')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,105)R
  105   FORMAT('     THE VALUE OF R = ',G15.7)
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      IF(N.LT.4)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,101)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,113)
  113   FORMAT('     THE NUMBER OF OBSERVATIONS IS LESS THAN FOUR.')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,115)N
  115   FORMAT('     THE NUMBER OF OBSERVATIONS = ',I8)
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      ALPHSV=ALPHA
      IF(ALPHA.GT.1.0 .AND. ALPHA.LE.100.0)ALPHA=ALPHA/100.0
      IF(ALPHA.LE.0.0 .OR. ALPHA.GE.1.0)THEN
        IERROR='YES'
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,101)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,172)
  172   FORMAT('      THE VALUE OF ALPHA IS OUTSIDE THE (0,1) ',
     1         'INTERVAL.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,177)ALPHA
  177   FORMAT('      THE VALUE OF ALPHA = ',G15.7)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      ALP=ALPHA
      IF(ALP.LT.0.5)THEN
        ALP=1.0-ALP
      ENDIF
C
      ALP=1.0 - ALPHA
      P2=1.0-(ALP/2.0)
      AN=REAL(N)
      Q=1.0-P
      CALL NORPPF(P2,U)
C
      AVAL=(1.0 + R)/(1.0 - R)
      Z=LOG(AVAL)/2.0
C
      AVAL=Z - U/SQRT(REAL(N)-3.0)
      IF(AVAL.GT.40.0)THEN
        ALOWLM=1.0
      ELSEIF(AVAL.LT.-40.0)THEN
        ALOWLM=(-1.0)
      ELSE
        ALOWLM=(EXP(AVAL) - EXP(-AVAL))/(EXP(AVAL) + EXP(-AVAL))
      ENDIF
      IF(ALOWLM.LT.-1.0)ALOWLM=-1.0
C
      AVAL=Z + U/SQRT(REAL(N)-3.0)
      IF(AVAL.GT.40.0)THEN
        AUPPLM=1.0
      ELSEIF(AVAL.LT.-40.0)THEN
        AUPPLM=(-1.0)
      ELSE
        AUPPLM=(EXP(AVAL) - EXP(-AVAL))/(EXP(AVAL) + EXP(-AVAL))
      ENDIF
      IF(AUPPLM.GT.1.0)AUPPLM=1.0
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'CRC3')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPCRC3--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)IERROR,ALOWLM,AUPPLM
 9012   FORMAT('IERROR,ALOWLM,AUPPLM = ',A4,2X,2G15.7)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPCRC5(CUTL90,CUTU90,CUTL95,CUTU95,CUTL99,CUTU99,
     1                  IFLAGU,IFRST,ILAST,
     1                  IBUGA2,IBUGA3,ISUBRO,IERROR)
C
C     PURPOSE--UTILITY ROUTINE USED BY DPCRCI.  THIS ROUTINE UPDATES THE
C              VARIOUS CUTOFF POINTS AFTER A CORRELATION CONFIDENCE
C              INTERVAL.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORAOTRY
C                 NATIONAL INSTITUTE OF STANDARDS OF TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS OF TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2012/6
C     ORIGINAL VERSION--JUNE      2012.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IFLAGU
      CHARACTER*4 IBUGA2
      CHARACTER*4 IBUGA3
      CHARACTER*4 ISUBRO
      CHARACTER*4 IERROR
C
      LOGICAL IFRST
      LOGICAL ILAST
C
      CHARACTER*4 IH
      CHARACTER*4 IH2
      CHARACTER*4 ISUBN0
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCOHK.INC'
      INCLUDE 'DPCOHO.INC'
C
      CHARACTER*4 IOP
      SAVE IOUNI1
C
C-----COMMON----------------------------------------------------------
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IF(IBUGA2.EQ.'ON' .OR. ISUBRO.EQ.'CRC5')THEN
        ISTEPN='1'
        CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPCRC5--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,54)CUTL90,CUTU90,CUTL95,CUTU95,CUTL99,CUTU99
   54   FORMAT('CUTL90,CUTU90,CUTL95,CUTU95,CUTL99,CUTU99 = ',6G15.7)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      IF(IFLAGU.EQ.'FILE')THEN
C
        IF(IFRST)THEN
          IOP='OPEN'
          IFLAG1=1
          IFLAG2=0
          IFLAG3=0
          IFLAG4=0
          IFLAG5=0
          CALL DPAUFI(IOP,IFLAG1,IFLAG2,IFLAG3,IFLAG4,IFLAG5,
     1                IOUNI1,IOUNI2,IOUNI3,IOUNI4,IOUNI5,
     1                IBUGA3,ISUBRO,IERROR)
          IF(IERROR.EQ.'YES')GOTO9000
C
          WRITE(IOUNI1,295)
  295     FORMAT(
     1           7X,'CUTLOW90',7X,'CUTUPP90',7X,'CUTLOW95',
     1           7X,'CUTUPP95',7X,'CUTLOW99',7X,'CUTUPP99')
        ENDIF
        WRITE(IOUNI1,299)CUTL90,CUTU90,CUTL95,CUTU95,CUTL99,CUTU99
  299   FORMAT(6E15.7)
      ELSEIF(IFLAGU.EQ.'ON')THEN
C
        IF(CUTU90.NE.CPUMIN)THEN
          IH='CUTU'
          IH2='PP90'
          VALUE0=CUTU90
          CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1                IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1                IANS,IWIDTH,IBUGA3,IERROR)
        ENDIF
C
        IF(CUTU95.NE.CPUMIN)THEN
          IH='CUTU'
          IH2='PP95'
          VALUE0=CUTU95
          CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1                IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1                IANS,IWIDTH,IBUGA3,IERROR)
        ENDIF
C
        IF(CUTU99.NE.CPUMIN)THEN
          IH='CUTU'
          IH2='PP99'
          VALUE0=CUTU99
          CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1                IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1                IANS,IWIDTH,IBUGA3,IERROR)
        ENDIF
C
        IF(CUTL90.NE.CPUMIN)THEN
          IH='CUTL'
          IH2='OW90'
          VALUE0=CUTL90
          CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1                IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1                IANS,IWIDTH,IBUGA3,IERROR)
        ENDIF
C
        IF(CUTL95.NE.CPUMIN)THEN
          IH='CUTL'
          IH2='OW95'
          VALUE0=CUTL95
          CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1                IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1                IANS,IWIDTH,IBUGA3,IERROR)
        ENDIF
C
        IF(CUTL99.NE.CPUMIN)THEN
          IH='CUTL'
          IH2='OW99'
          VALUE0=CUTL99
          CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1                IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1                IANS,IWIDTH,IBUGA3,IERROR)
        ENDIF
C
      ENDIF
C
      IF(IFLAGU.EQ.'FILE')THEN
        IF(ILAST)THEN
          IOP='CLOS'
          IFLAG1=1
          IFLAG2=0
          IFLAG3=0
          IFLAG4=0
          IFLAG5=0
          CALL DPAUFI(IOP,IFLAG1,IFLAG2,IFLAG3,IFLAG4,IFLAG5,
     1                IOUNI1,IOUNI2,IOUNI3,IOUNI4,IOUNI5,
     1                IBUGA3,ISUBRO,IERROR)
C
          IF(IBUGA2.EQ.'ON' .OR. ISUBRO.EQ.'CRC5')THEN
            ISTEPN='3A'
            CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,301)IERROR
  301       FORMAT('AFTER CALL DPCLFI, IERROR = ',A4)
            CALL DPWRST('XXX','BUG ')
          ENDIF
C
          IF(IERROR.EQ.'YES')GOTO9000
        ENDIF
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
C
      IF(IBUGA2.EQ.'ON' .OR. ISUBRO.EQ.'CRC5')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END OF DPCRC5--')
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPCRLF(IHARG,NUMARG,
     1IDEFCR,IDEFLF,
     1ITEXCR,ITEXLF,
     1IBUGD2,ISUBRO,IFOUND,IERROR)
C
C     PURPOSE--DEFINE THE CARRIAGE RETURN AND LINE FEED SWITCHES
C              (ON OR OFF) FOR
C              TEXT SCRIPT.
C              THE CARRIAGE RETURN AND LINE FEED SWITCHES WILL BE PLACED
C              IN THE CHARACTER VARIABLES ITEXCR AND ITEXLF.
C     INPUT  ARGUMENTS--IHARG  (A  CHARACTER VECTOR)
C                     --NUMARG
C                     --IDEFCR
C                     --IDEFLF
C                     --IBUGD2
C     OUTPUT ARGUMENTS--ITEXCR
C                     --ITEXLF
C                     --IFOUND ('YES' OR 'NO' )
C                     --IERROR ('YES' OR 'NO' )
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--APRIL     1981.
C     UPDATED         --MAY       1982.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IHARG
      CHARACTER*4 IDEFCR
      CHARACTER*4 IDEFLF
      CHARACTER*4 ITEXCR
      CHARACTER*4 ITEXLF
      CHARACTER*4 IBUGD2
      CHARACTER*4 ISUBRO
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
C---------------------------------------------------------------------
C
      DIMENSION IHARG(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IFOUND='NO'
      IERROR='NO'
C
      IF(IBUGD2.EQ.'OFF')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF DPCR--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)IDEFCR,IDEFLF
   53 FORMAT('IDEFCR,IDEFLF = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)NUMARG
   54 FORMAT('NUMARG = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO55I=1,NUMARG
      WRITE(ICOUT,56)I,IHARG(I)
   56 FORMAT('I,IHARG(I) = ',I8,2X,A4)
      CALL DPWRST('XXX','BUG ')
   55 CONTINUE
   90 CONTINUE
C
C               **************************************
C               **  TREAT THE CARRIAGE RETURN CASE  **
C               **************************************
C
      IF(NUMARG.LE.0)GOTO1161
      IF(IHARG(NUMARG).EQ.'ON')GOTO1161
      IF(IHARG(NUMARG).EQ.'OFF')GOTO1162
      IF(IHARG(NUMARG).EQ.'AUTO')GOTO1161
      IF(IHARG(NUMARG).EQ.'DEFA')GOTO1165
      GOTO1170
C
 1161 CONTINUE
      ITEXCR='ON'
      ITEXLF='ON'
      GOTO1180
C
 1162 CONTINUE
      ITEXCR='OFF'
      ITEXLF='OFF'
      GOTO1180
C
 1165 CONTINUE
      ITEXCR=IDEFCR
      ITEXLF=IDEFLF
      GOTO1180
C
 1170 CONTINUE
      IERROR='YES'
      WRITE(ICOUT,1171)
 1171 FORMAT('***** ERROR IN DPCR--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1172)
 1172 FORMAT('      ILLEGAL ENTRY FOR CARRIAGE RETURN ',
     1'COMMAND.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1173)
 1173 FORMAT('      TEST EXAMPLE TO DEMONSTRATE THE ',
     1'PROPER FORM--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1174)
 1174 FORMAT('      SUPPOSE THE THE ANALYST WISHES ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1175)
 1175 FORMAT('      TO HAVE A CARRIAGE RETURN/LINE FEED ',
     1'AFTER THE TEXT COMMAND,')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1177)
 1177 FORMAT('      THEN ALLOWABLE FORMS ARE--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1178)
 1178 FORMAT('           CRLF ON')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1179)
 1179 FORMAT('           CRLF')
      CALL DPWRST('XXX','BUG ')
      GOTO9000
C
 1180 CONTINUE
      IFOUND='YES'
C
      IF(IFEEDB.EQ.'OFF')GOTO1189
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1181)
 1181 FORMAT('THE CARRIAGE RETURN/LINE FEED (AFTER TEXT) ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1182)ITEXCR
 1182 FORMAT('HAS JUST BEEN SET TO ',A4)
      CALL DPWRST('XXX','BUG ')
 1189 CONTINUE
      GOTO9000
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGD2.EQ.'OFF')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF DPCR')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGD2,ISUBRO,IFOUND,IERROR
 9012 FORMAT('IBUGD2,ISUBRO,IFOUND,IERROR = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)IDEFCR,ITEXCR
 9013 FORMAT('IDEFCR,ITEXCR = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)IDEFLF,ITEXLF
 9014 FORMAT('IDEFLF,ITEXLF = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPCROS(ICOM,IHARG,IHARG2,IARGT,ARG,NUMARG,
     1IANS,IWIDTH,
     1IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1IGRASW,IDIASW,
     1PGRAXF,PGRAYF,PDIAXC,PDIAYC,PDIAX2,PDIAY2,
     1PDIAHE,PDIAWI,PDIAVG,PDIAHG,
     1NUMDEV,
     1IDMANU,IDMODE,IDMOD2,IDMOD3,
     1IDPOWE,IDCONT,IDCOLO,IDNVPP,IDNHPP,IDUNIT,
     1IDNVOF,IDNHOF,
CCCCC ADD FOLLOWING LINE MARCH 1997.
     1IDFONT,
     1PXMIN,PXMAX,PYMIN,PYMAX,
     1FX1MIN,FX1MAX,FY1MIN,FY1MAX,
     1IBUGD2,ISUBRO,IFOUND,IERROR)
C
C     PURPOSE--READ THE COORDINATES OF THE CROSS-HAIR.
C              SUCH COORDINATES WILL BE IN
C              STANDARDIZED (0.0 TO 100.0) UNITS.
C
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--83.6
C     ORIGINAL VERSION (AS A SEPARATE SUBROUTINE)--MAY       1983.
C     UPDATED         --JANUARY   1989.  CALL LIST FOR OFFSET VAR (ALAN)
C     UPDATED         --MARCH     1997.  SUPPORT FOR DEVICE FONT (ALAN)
C     UPDATED         --FEBRUARY  1998.  SUPPORT FORM OF COMMAND FOR
C                                        GUI
C
C-----NON-COMMON VARIABLES------------------------------------------------------
C
      CHARACTER*4 ICOM
C
      CHARACTER*4 IHARG
      CHARACTER*4 IHARG2
      CHARACTER*4 IARGT
C
      CHARACTER*4 IANS
C
      CHARACTER*4 IHNAME
      CHARACTER*4 IHNAM2
      CHARACTER*4 IUSE
C
      CHARACTER*4 IGRASW
      CHARACTER*4 IDIASW
C
      CHARACTER*4 IDMANU
      CHARACTER*4 IDMODE
      CHARACTER*4 IDMOD2
      CHARACTER*4 IDMOD3
      CHARACTER*4 IDPOWE
      CHARACTER*4 IDCONT
      CHARACTER*4 IDCOLO
CCCCC ADD FOLLOWING LINE MARCH 1997.
      CHARACTER*4 IDFONT
C
      CHARACTER*4 IFOUND
      CHARACTER*4 IBUGD2
      CHARACTER*4 ISUBRO
      CHARACTER*4 IERROR
C
      CHARACTER*4 ICOPSJ
C
      CHARACTER*4 IHWORD
      CHARACTER*4 IHWOR2
      CHARACTER*4 IOP
      CHARACTER*4 MESSAG
      CHARACTER*4 IFOUNN
C
      DIMENSION IHARG(*)
      DIMENSION IHARG2(*)
      DIMENSION IARGT(*)
      DIMENSION ARG(*)
C
      DIMENSION IANS(*)
C
      DIMENSION IHNAME(*)
      DIMENSION IHNAM2(*)
      DIMENSION IUSE(*)
      DIMENSION IN(*)
      DIMENSION IVALUE(*)
      DIMENSION VALUE(*)
C
      DIMENSION IDMANU(*)
      DIMENSION IDMODE(*)
      DIMENSION IDMOD2(*)
      DIMENSION IDMOD3(*)
      DIMENSION IDPOWE(*)
      DIMENSION IDCONT(*)
      DIMENSION IDCOLO(*)
CCCCC ADD FOLLOWING LINE MARCH 1997.
      DIMENSION IDFONT(*)
      DIMENSION IDNVPP(*)
      DIMENSION IDNHPP(*)
      DIMENSION IDUNIT(*)
C
      DIMENSION IDNVOF(*)
      DIMENSION IDNHOF(*)
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOGR.INC'
      INCLUDE 'DPCOBE.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IFOUND='NO'
      IERROR='NO'
C
      IBUGG4=IBUGD2
      ISUBG4=ISUBRO
C
      PXRATI=(-999.0)
      PYRATI=(-999.0)
      PXRANG=(-999.0)
      PYRANG=(-999.0)
      FXRANG=(-999.0)
      FYRANG=(-999.0)
      ILOCP3=(-999)
C
      ILOC=0
C
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'CROS')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF DPCROS--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)IWIDTH
   53 FORMAT('IWIDTH= ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)(IANS(I),I=1,IWIDTH)
   54 FORMAT('(IANS(I),I=1,IWIDTH) = ',25A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,61)NUMARG
   61 FORMAT('NUMARG = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO62I=1,NUMARG
      WRITE(ICOUT,63)I,IHARG(I),IHARG2(I),IARGT(I),ARG(I)
   63 FORMAT('I,IHARG(I),IHARG2(I),IARGT(I),ARG(I) = ',
     1I8,2X,A4,2X,A4,2X,A4,E15.7)
      CALL DPWRST('XXX','BUG ')
   62 CONTINUE
      WRITE(ICOUT,71)NUMNAM,MAXNAM
   71 FORMAT('NUMNAM,MAXNAM= ',2I8)
      CALL DPWRST('XXX','BUG ')
      DO72I=1,NUMNAM
      WRITE(ICOUT,73)I,IHNAME(I),IHNAM2(I),IUSE(I),IN(I),IVALUE(I),
     1VALUE(I)
   73 FORMAT('I,IHNAME(I),IHNAM2(I),IUSE(I),IN(I),IVALUE(I),',
     1'VALUE(I) = ',
     1I8,2X,A4,2X,A4,2X,A4,I8,I8,E15.7)
      CALL DPWRST('XXX','BUG ')
   72 CONTINUE
      WRITE(ICOUT,76)IGRASW,IDIASW
   76 FORMAT('IGRASW,IDIASW = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,77)PGRAXF,PGRAYF,PDIAXC,PDIAYC
   77 FORMAT('PGRAXF,PGRAYF,PDIAXC,PDIAYC = ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,78)PDIAHE,PDIAWI,PDIAVG,PDIAHG
   78 FORMAT('PDIAHE,PDIAWI,PDIAVG,PDIAHG = ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,80)NUMDEV
   80 FORMAT('NUMDEV= ',I8)
      CALL DPWRST('XXX','BUG ')
      DO81I=1,NUMDEV
      WRITE(ICOUT,82)IDMANU(I),IDMODE(I),IDMOD2(I),IDMOD3(I)
   82 FORMAT('IDMANU(I),IDMODE(I),IDMOD2(I),IDMOD3(I) = ',
     1A4,2X,A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,83)IDPOWE(I),IDCONT(I),IDCOLO(I)
   83 FORMAT('IDPOWE(I),IDCONT(I),IDCOLO(I) = ',
     1A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,84)IDNVPP(I),IDNHPP(I),IDUNIT(I)
   84 FORMAT('IDNVPP(I),IDNHPP(I),IDUNIT(I) = ',
     1I8,I8,I8)
      CALL DPWRST('XXX','BUG ')
   81 CONTINUE
      WRITE(ICOUT,85)PXMIN,PXMAX,PYMIN,PYMAX
   85 FORMAT('PXMIN,PXMAX,PYMIN,PYMAX = ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,86)FX1MIN,FX1MAX,FY1MIN,FY1MAX
   86 FORMAT('FX1MIN,FX1MAX,FY1MIN,FY1MAX = ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,87)IFOUND
   87 FORMAT('IFOUND= ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,88)IBUGG4,ISUBG4,IERRG4
   88 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,89)IBUGD2,IERROR
   89 FORMAT('IBUGD2,IERROR= ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
C               ********************************************************
C               **  STEP 1--                                          **
C               **  EXTRACT NEEDED INFORMATION FROM THE COMMAND LINE  **
C               ********************************************************
C
      IF(ICOM.EQ.'CH'.AND.IHARG(1).EQ.'ON')GOTO1111
      IF(ICOM.EQ.'CH'.AND.IHARG(1).EQ.'AUTO')GOTO1111
      IF(ICOM.EQ.'CH'.AND.IHARG(1).EQ.'DEFA')GOTO1190
      IF(ICOM.EQ.'CH'.AND.IHARG(1).EQ.'OFF')GOTO1190
      IF(ICOM.EQ.'CH'.AND.NUMARG.GE.0)GOTO1110
C
      IF(IHARG(1).EQ.'CH'.AND.IHARG(2).EQ.'ON')GOTO1112
      IF(IHARG(1).EQ.'CH'.AND.IHARG(2).EQ.'AUTO')GOTO1112
      IF(IHARG(1).EQ.'CH'.AND.IHARG(2).EQ.'DEFA')GOTO1190
      IF(IHARG(1).EQ.'CH'.AND.IHARG(2).EQ.'OFF')GOTO1190
      IF(IHARG(1).EQ.'CH'.AND.NUMARG.GE.1)GOTO1111
C
      IF(IHARG(1).EQ.'HAIR'.AND.IHARG(2).EQ.'ON')GOTO1112
      IF(IHARG(1).EQ.'HAIR'.AND.IHARG(2).EQ.'AUTO')GOTO1112
      IF(IHARG(1).EQ.'HAIR'.AND.IHARG(2).EQ.'DEFA')GOTO1190
      IF(IHARG(1).EQ.'HAIR'.AND.IHARG(2).EQ.'OFF')GOTO1190
      IF(IHARG(1).EQ.'HAIR'.AND.NUMARG.GE.1)GOTO1111
C
      IF(IHARG(1).EQ.'CROS'.AND.IHARG(2).EQ.'HAIR'.AND.
     1IHARG(3).EQ.'ON')GOTO1113
      IF(IHARG(1).EQ.'CROS'.AND.IHARG(2).EQ.'HAIR'.AND.
     1IHARG(3).EQ.'AUTO')GOTO1113
      IF(IHARG(1).EQ.'CROS'.AND.IHARG(2).EQ.'HAIR'.AND.
     1IHARG(3).EQ.'OFF')GOTO1190
      IF(IHARG(1).EQ.'CROS'.AND.IHARG(2).EQ.'HAIR'.AND.
     1IHARG(3).EQ.'DEFA')GOTO1190
      IF(IHARG(1).EQ.'CROS'.AND.IHARG(2).EQ.'HAIR'.AND.
     1NUMARG.GE.2)GOTO1112
C
      GOTO9000
C
 1110 CONTINUE
      ILOC=0
      GOTO1190
C
 1111 CONTINUE
      ILOC=1
      GOTO1190
C
 1112 CONTINUE
      ILOC=2
      GOTO1190
C
 1113 CONTINUE
      ILOC=3
      GOTO1190
C
 1190 CONTINUE
CCCCC FEBRUARY 1998.
CCCCC SUPPORT FORM OF COMMAND:
CCCCC     CROSS-HAIR 22.1  34.6
CCCCC FOR GUI.  THIS FORM WILL PRINT THE COORDINATES IN THE MOST
CCCCC RECENT PLOT UNITS.
      IF(NUMARG.EQ.2..AND.IARGT(1).EQ.'NUMB'.AND.
     1   IARGT(2).EQ.'NUMB')THEN
        PXCOOR=ARG(1)
        PYCOOR=ARG(2)
        PXRANG=PXMAX-PXMIN
        PYRANG=PYMAX-PYMIN
        FXRANG=PXRANG
        IF(FX1MIN.NE.CPUMIN.AND.FX1MIN.NE.CPUMAX.AND.
     1     FX1MAX.NE.CPUMIN.AND.FX1MAX.NE.CPUMAX)
     1     FXRANG=FX1MAX-FX1MIN
        FYRANG=PYRANG
        IF(FY1MIN.NE.CPUMIN.AND.FY1MIN.NE.CPUMAX.AND.
     1    FY1MAX.NE.CPUMIN.AND.FY1MAX.NE.CPUMAX)
     1   FYRANG=FY1MAX-FY1MIN
C
        PXRATI=(-999.0)
        IF(PXRANG.GT.0.0)PXRATI=(PXCOOR-PXMIN)/PXRANG
        XCOOR=PXCOOR
        IF(FX1MIN.NE.CPUMIN.AND.FX1MIN.NE.CPUMAX.AND.
     1     FX1MAX.NE.CPUMIN.AND.FX1MAX.NE.CPUMAX)
     1     XCOOR=FX1MIN+PXRATI*FXRANG
        IF(PYRANG.LE.0.0)PYRATI=(-999.0)
        IF(PYRANG.GT.0.0)PYRATI=(PYCOOR-PYMIN)/PYRANG
        YCOOR=PYCOOR
        IF(FY1MIN.NE.CPUMIN.AND.FY1MIN.NE.CPUMAX.AND.
     1     FY1MAX.NE.CPUMIN.AND.FY1MAX.NE.CPUMAX)
     1     YCOOR=FY1MIN+PYRATI*FYRANG
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2186)XCOOR
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2187)YCOOR
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2188)
        CALL DPWRST('XXX','BUG ')
        IFOUND='YES'
        GOTO9000
      ENDIF
C
C               ********************************
C               **  STEP 2--                  **
C               **  STEP THROUGH EACH DEVICE  **
C               ********************************
C
      IF(NUMDEV.LE.0)GOTO9000
      DO8000IDEVIC=1,NUMDEV
C
      IF(IDPOWE(IDEVIC).EQ.'OFF')GOTO8000
C
      IMANUF=IDMANU(IDEVIC)
      IMODEL=IDMODE(IDEVIC)
      IMODE2=IDMOD2(IDEVIC)
      IMODE3=IDMOD3(IDEVIC)
      IGCONT=IDCONT(IDEVIC)
      IGCOLO=IDCOLO(IDEVIC)
CCCCC ADD FOLLOWING LINE MARCH 1997.
      IGFONT=IDFONT(IDEVIC)
      NUMVPP=IDNVPP(IDEVIC)
      NUMHPP=IDNHPP(IDEVIC)
      ANUMVP=NUMVPP
      ANUMHP=NUMHPP
C  AUGUST 1988.  ADD OFFSET VARIABLE
      IOFFSV=IDNVOF(IDEVIC)
      IOFFSH=IDNHOF(IDEVIC)
C
      IGUNIT=IDUNIT(IDEVIC)
C
C               ***********************************
C               **  STEP 3--                     **
C               **  READ THE SCREEN COORDINATES  **
C               ***********************************
C
      CALL GRRESC(PXCOOR,PYCOOR)
C
C               ************************************
C               **  STEP 3.5--                      **
C               **  CARRY OUT CLOSING OPERATIONS  **
C               **  ON THE GRAPHICS DEVICES       **
C               ************************************
C
      ICOPSJ='OFF'
      NUMCOJ=0
      CALL DPCLPL(ICOPSJ,NUMCOJ,
     1PGRAXF,PGRAYF,
     1IGRASW,PDIAXC,PDIAYC,PDIAX2,PDIAY2,
     1PDIAHE,PDIAWI,PDIAVG,PDIAHG)
C
      CALL DPCLDE
C
C               ***************************************
C               **  STEP 4--                         **
C               **  UPDATE INTERNAL DATAPLOT ARRAYS  **
C               ***************************************
C
C
      ILOCP1=ILOC+1
      IF(ILOCP1.GT.NUMARG)GOTO2180
      IHWORD=IHARG(ILOCP1)
      IHWOR2=IHARG2(ILOCP1)
      IOP='CHAD'
      MESSAG='NO'
      CALL UPDATP(IHWORD,IHWOR2,PXCOOR,IOP,MESSAG,
     1IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGD2,ILOCN,IFOUNN,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      ILOCP2=ILOC+2
      IF(ILOCP2.GT.NUMARG)GOTO2180
      IHWORD=IHARG(ILOCP2)
      IHWOR2=IHARG2(ILOCP2)
      IOP='CHAD'
      MESSAG='NO'
      CALL UPDATP(IHWORD,IHWOR2,PYCOOR,IOP,MESSAG,
     1IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGD2,ILOCN,IFOUNN,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      PXRANG=PXMAX-PXMIN
      PYRANG=PYMAX-PYMIN
C
      FXRANG=PXRANG
      IF(FX1MIN.NE.CPUMIN.AND.FX1MIN.NE.CPUMAX.AND.
     1   FX1MAX.NE.CPUMIN.AND.FX1MAX.NE.CPUMAX)
     1   FXRANG=FX1MAX-FX1MIN
C
      FYRANG=PYRANG
      IF(FY1MIN.NE.CPUMIN.AND.FY1MIN.NE.CPUMAX.AND.
     1   FY1MAX.NE.CPUMIN.AND.FY1MAX.NE.CPUMAX)
     1   FYRANG=FY1MAX-FY1MIN
C
      IF(IBUGG4.EQ.'ON')WRITE(ICOUT,2170)PXRANG,PYRANG,FXRANG,FYRANG
 2170 FORMAT('PXRANG,PYRANG,FXRANG,FYRANG = ',4E15.7)
      IF(IBUGG4.EQ.'ON')CALL DPWRST('XXX','BUG ')
C
      ILOCP3=ILOC+3
      IF(ILOCP3.GT.NUMARG)GOTO2180
      PXRATI=(-999.0)
      IF(PXRANG.GT.0.0)PXRATI=(PXCOOR-PXMIN)/PXRANG
      XCOOR=PXCOOR
      IF(FX1MIN.NE.CPUMIN.AND.FX1MIN.NE.CPUMAX.AND.
     1   FX1MAX.NE.CPUMIN.AND.FX1MAX.NE.CPUMAX)
     1   XCOOR=FX1MIN+PXRATI*FXRANG
      IHWORD=IHARG(ILOCP3)
      IHWOR2=IHARG2(ILOCP3)
      IOP='CHAD'
      MESSAG='NO'
      CALL UPDATP(IHWORD,IHWOR2,XCOOR,IOP,MESSAG,
     1IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGD2,ILOCN,IFOUNN,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      ILOCP4=ILOC+4
      IF(ILOCP4.GT.NUMARG)GOTO2180
      IF(PYRANG.LE.0.0)PYRATI=(-999.0)
      IF(PYRANG.GT.0.0)PYRATI=(PYCOOR-PYMIN)/PYRANG
      YCOOR=PYCOOR
      IF(FY1MIN.NE.CPUMIN.AND.FY1MIN.NE.CPUMAX.AND.
     1   FY1MAX.NE.CPUMIN.AND.FY1MAX.NE.CPUMAX)
     1   YCOOR=FY1MIN+PYRATI*FYRANG
      IHWORD=IHARG(ILOCP4)
      IHWOR2=IHARG2(ILOCP4)
      IOP='CHAD'
      MESSAG='NO'
      CALL UPDATP(IHWORD,IHWOR2,YCOOR,IOP,MESSAG,
     1IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGD2,ILOCN,IFOUNN,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
 2180 CONTINUE
      IFOUND='YES'
C
      IF(IFEEDB.EQ.'OFF')GOTO2189
C
 2181 CONTINUE
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2182)PXCOOR
 2182 FORMAT('X COOR. = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2183)PYCOOR
 2183 FORMAT('Y COOR. = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2184)
 2184 FORMAT('(IN 0 TO 100 UNITS)')
      CALL DPWRST('XXX','BUG ')
C
      IF(ILOCP3.GT.NUMARG)GOTO2189
      IF(ICOM.EQ.'CH'.AND.NUMARG.LE.0)GOTO2189
      IF(IHARG(1).EQ.'CH'.AND.NUMARG.LE.1)GOTO2189
      IF(IHARG(1).EQ.'CROS'.AND.IHARG(2).EQ.'HAIR'.AND.
     1NUMARG.LE.2)GOTO2189
C
 2185 CONTINUE
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2186)XCOOR
 2186 FORMAT('X COOR. = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2187)YCOOR
 2187 FORMAT('Y COOR. = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,2188)
 2188 FORMAT('(IN UNITS OF THE DATA)')
      CALL DPWRST('XXX','BUG ')
      GOTO2189
C
 2189 CONTINUE
      GOTO9000
C
 8000 CONTINUE
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IERROR=IERRG4
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'CROS')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF DPCROS--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)PXCOOR,PYCOOR
 9012 FORMAT('PXCOOR,PYCOOR = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)ILOC
 9013 FORMAT('ILOC = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)IWIDTH
 9014 FORMAT('IWIDTH= ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)(IANS(I),I=1,IWIDTH)
 9015 FORMAT('(IANS(I),I=1,IWIDTH) = ',25A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9021)NUMARG
 9021 FORMAT('NUMARG = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO9022I=1,NUMARG
      WRITE(ICOUT,9023)I,IHARG(I),IHARG2(I),IARGT(I),ARG(I)
 9023 FORMAT('I,IHARG(I),IHARG2(I),IARGT(I),ARG(I) = ',
     1I8,2X,A4,2X,A4,2X,A4,E15.7)
      CALL DPWRST('XXX','BUG ')
 9022 CONTINUE
      WRITE(ICOUT,9031)NUMNAM,MAXNAM
 9031 FORMAT('NUMNAM,MAXNAM= ',2I8)
      CALL DPWRST('XXX','BUG ')
      DO9032I=1,NUMNAM
      WRITE(ICOUT,9033)I,IHNAME(I),IHNAM2(I),IUSE(I),IN(I),IVALUE(I),
     1VALUE(I)
 9033 FORMAT('I,IHNAME(I),IHNAM2(I),IUSE(I),IN(I),IVALUE(I),',
     1'VALUE(I) = ',
     1I8,2X,A4,2X,A4,2X,A4,I8,I8,E15.7)
      CALL DPWRST('XXX','BUG ')
 9032 CONTINUE
      WRITE(ICOUT,9035)IMANUF,IMODEL
 9035 FORMAT('IMANUF,IMODEL = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9037)IFOUND
 9037 FORMAT('IFOUND= ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9038)IBUGG4,ISUBG4,IERRG4
 9038 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9039)IBUGD2,IERROR
 9039 FORMAT('IBUGD2,IERROR = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9045)PXMIN,PXMAX,PYMIN,PYMAX
 9045 FORMAT('PXMIN,PXMAX,PYMIN,PYMAX = ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9046)FX1MIN,FX1MAX,FY1MIN,FY1MAX
 9046 FORMAT('FX1MIN,FX1MAX,FY1MIN,FY1MAX = ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9047)PXRANG,PYRANG,FXRANG,FYRANG
 9047 FORMAT('PXRANG,PYRANG,FXRANG,FYRANG = ',4E15.7)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPCRPL(NPLOTV,NPLOTP,NS,ICASPL,IAND1,IAND2,
CCCCC1TEMP,TEMP2,TEMP3,XTEMP1,XTEMP2,MAXNXT,
     1MAXNXT,
     1ISEED,
     1ICONT,ISUBRO,IBUGG2,IBUGG3,IBUGQ,IFOUND,IERROR)
C
C     PURPOSE--GENERATE A CROSS TABULATION PLOT FOR ONE OF
C              DATAPLOT'S SUPPORTED STATISTICS
C
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--99/11
C     ORIGINAL VERSION--NOVEMBER  1999.
C     UPDATED         --APRIL     2001. ARGUMENT LIST FOR CP, CPK, CPM
C                                       ADD CPL AND CPU PLOTS
C     UPDATED         --OCTOBER   2001. HARMONIC MEAN, IQ RANGE
C     UPDATED         --NOVEMBER  2001. BIWEIGHT LOCATION
C     UPDATED         --NOVEMBER  2001. BIWEIGHT SCALE
C     UPDATED         --JULY      2002. WINSORIZED VARIANCE
C     UPDATED         --JULY      2002. WINSORIZED SD
C     UPDATED         --JULY      2002. ADD WINSORIZED COVARIANCE PLOT
C     UPDATED         --JULY      2002. ADD WINSORIZED CORRELATION PLOT
C     UPDATED         --JULY      2002. ADD BIWEIGHT MIDVARIANCE PLOT
C     UPDATED         --JULY      2002. ADD BIWEIGHT MIDCOVARIANCE PLOT
C     UPDATED         --JULY      2002. ADD BIWEIGHT MIDCORRELATION PLOT
C     UPDATED         --JULY      2002. ADD PERCENTAGE BEND MIDVARIANCE
C                                           PLOT
C     UPDATED         --JULY      2002. ADD HODGES LEHMAN PLOT
C     UPDATED         --JULY      2002. ADD QUANTILE PLOT
C     UPDATED         --JULY      2002. ADD QUANTILE STANDARD ERROR PLOT
C     UPDATED         --JULY      2002. ADD TRIMMED MEAN STANDARD ERROR
C                                       PLOT
C     UPDATED         --MARCH     2003. ADD 35 "DIFFERENCE OF" STATISTICS
C     UPDATED         --MARCH     2003. ADD WEIGHTED MEAN, WEIGHTED SD,
C                                       WEIGHTED VARIANCE
C     UPDATED         --APRIL     2003. ADD SN AND QN (AND DIFFERENCE
C                                       OF).  REQUIRED ADDITION OF
C                                       ADDITIONAL SCRATCH VARIABLES.
C     UPDATED         --MAY       2003. WEIGHTED TRIMMED MEAN
C     UPDATED         --OCTOBER   2004. KENDELLS TAU
C     UPDATED         --SEPTEMBER 2005. RATIO
C     UPDATED         --MARCH     2007. RELATIVE RISK
C     UPDATED         --MARCH     2007. CRAMER CONINGENCY COEFFICIENT
C     UPDATED         --MARCH     2007. PEARSON CONINGENCY COEFFICIENT
C     UPDATED         --MARCH     2007. FALSE POSITIVE
C     UPDATED         --MARCH     2007. FALSE NEGATIVE
C     UPDATED         --MARCH     2007. TRUE POSITIVE
C     UPDATED         --MARCH     2007. TRUE NEGATIVE
C     UPDATED         --MARCH     2007. TEST SENSITIVITY
C     UPDATED         --MARCH     2007. TEST SPECIFICITY
C     UPDATED         --APRIL     2007. POSITIVE PREDICTIVE VALUE
C     UPDATED         --APRIL     2007. NEGATIVE PREDICTIVE VALUE
C     UPDATED         --APRIL     2007. LOG ODDS RATIO
C     UPDATED         --APRIL     2007. LOG ODDS RATIO STANDARD ERROR
C     UPDATED         --MAY       2007. TRIMMED STANDARD DEVIATION
C     UPDATED         --AUGUST    2007. MOVE STORAGE OF TEMPORARY
C                                       VARIABLES TO COMMON BLOCKS
C     UPDATED         --NOVEMBER  2007. LP LOCATION
C     UPDATED         --NOVEMBER  2007. DOUBLE PRECISION TEMPORARY
C                                       ARRAYS FOR CMPSTA
C     UPDATED         --NOVEMBER  2007. LP LOCATION
C     UPDATED         --NOVEMBER  2007. VARIANCE OF LP LOCATION
C     UPDATED         --NOVEMBER  2007. SD OF LP LOCATION
C     UPDATED         --NOVEMBER  2007. DIFFERENCE OF LP LOCATION
C     UPDATED         --NOVEMBER  2007. DIFFERENCE OF VARI OF LP LOCATION
C     UPDATED         --NOVEMBER  2007. DIFFERENCE OF SD OF LP LOCATION
C     UPDATED         --SEPTEMBER 2008. BINOMIAL PROBABILITY
C     UPDATED         --SEPTEMBER 2008. DIFFERENCE OF BINOMIAL
C                                       PROBABILITY
C     UPDATED         --FEBRUARY  2009. INDEX MINIMUM
C     UPDATED         --FEBRUARY  2009. INDEX MAXIMUM
C     UPDATED         --FEBRUARY  2009. INDEX EXTREME
C     UPDATED         --FEBRUARY  2009. GRUBB
C                                       GRUBB CDF
C                                       GRUBB DIRECTION
C                                       GRUBB INDEX
C     UPDATED         --FEBRUARY  2009. ONE SAMPLE T TEST
C                                       ONE SAMPLE T TEST CDF
C     UPDATED         --FEBRUARY  2009. CHI-SQUARE SD TEST
C                                       CHI-SQUARE SD TEST CDF
C     UPDATED         --FEBRUARY  2009. FREQUENCY TEST
C                                       FREQUENCY TEST CDF
C     UPDATED         --FEBRUARY  2009. FREQUENCY WITHIN A BLOCK TEST
C                                       FREQUENCY WITHIN A BLOCK TEST CDF
C     UPDATED         --MARCH     2009. EXTRACT STATISTIC WITH "EXTSTA"
C     UPDATED         --JUNE      2010. PARSE WITH "DPPARS"
C     UPDATED         --JUNE      2010. ACCOMODATE 3 RESPONSE VARIABLES
C                                       (CMPSTA UPDATED)
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICASPL
      CHARACTER*4 IAND1
      CHARACTER*4 IAND2
      CHARACTER*4 ICONT
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGG2
      CHARACTER*4 IBUGG3
      CHARACTER*4 IBUGQ
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
      CHARACTER*4 IHWUSE
      CHARACTER*4 MESSAG
      CHARACTER*4 ICASEQ
      CHARACTER*4 IH
      CHARACTER*4 IH2
C
      CHARACTER*4 IXVAR
      CHARACTER*4 IX2VAR
      CHARACTER*4 IYVAR
C
      CHARACTER*4  ISTADF
      CHARACTER*60 ISTANM
C
      CHARACTER*40 INAME
      PARAMETER (MAXSPN=30)
      CHARACTER*4 IVARN1(MAXSPN)
      CHARACTER*4 IVARN2(MAXSPN)
      CHARACTER*4 IVARTY(MAXSPN)
      REAL PVAR(MAXSPN)
      INTEGER ILIS(MAXSPN)
      INTEGER NRIGHT(MAXSPN)
      INTEGER ICOLR(MAXSPN)
C
      CHARACTER*4 ISUBN0
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
C
C     AUGUST 2007: MOVE STORAGE OF FOLLOWING ARRAYS TO
C                  COMMON BLOCKS
C
CCCCC DIMENSION TEMP(*)
CCCCC DIMENSION TEMP2(*)
CCCCC DIMENSION TEMP3(*)
CCCCC DIMENSION XTEMP1(*)
CCCCC DIMENSION XTEMP2(*)
      DIMENSION TEMP(MAXOBV)
      DIMENSION TEMP2(MAXOBV)
      DIMENSION TEMP3(MAXOBV)
      DIMENSION TEMP4(MAXOBV)
      DIMENSION XTEMP1(MAXOBV)
      DIMENSION XTEMP2(MAXOBV)
C
      INTEGER ITEMP1(MAXOBV)
      INTEGER ITEMP2(MAXOBV)
      INTEGER ITEMP3(MAXOBV)
      INTEGER ITEMP4(MAXOBV)
      INTEGER ITEMP5(MAXOBV)
      INTEGER ITEMP6(MAXOBV)
C
      DOUBLE PRECISION DTEMP1(MAXOBV)
      DOUBLE PRECISION DTEMP2(MAXOBV)
      DOUBLE PRECISION DTEMP3(MAXOBV)
C
      DIMENSION X1(MAXOBV)
      DIMENSION X2(MAXOBV)
      DIMENSION Y1(MAXOBV)
      DIMENSION Z1(MAXOBV)
      DIMENSION Z2(MAXOBV)
      DIMENSION XTEMP3(MAXOBV)
      DIMENSION XTEMP4(MAXOBV)
      DIMENSION XTEMP5(MAXOBV)
C
      INCLUDE 'DPCOZZ.INC'
      INCLUDE 'DPCOZI.INC'
      INCLUDE 'DPCOZD.INC'
C
      EQUIVALENCE (GARBAG(IGARB1),X1(1))
      EQUIVALENCE (GARBAG(IGARB2),X2(1))
      EQUIVALENCE (GARBAG(IGARB3),Y1(1))
      EQUIVALENCE (GARBAG(IGARB4),Z1(1))
      EQUIVALENCE (GARBAG(IGARB5),Z2(1))
      EQUIVALENCE (GARBAG(IGARB6),XTEMP3(1))
      EQUIVALENCE (GARBAG(IGARB7),XTEMP4(1))
      EQUIVALENCE (GARBAG(IGARB8),XTEMP5(1))
      EQUIVALENCE (GARBAG(IGARB9),TEMP(1))
      EQUIVALENCE (GARBAG(IGAR10),TEMP2(1))
      EQUIVALENCE (GARBAG(JGAR11),TEMP3(1))
      EQUIVALENCE (GARBAG(JGAR12),TEMP4(1))
      EQUIVALENCE (GARBAG(JGAR13),XTEMP1(1))
      EQUIVALENCE (GARBAG(JGAR14),XTEMP2(1))
C
      EQUIVALENCE (IGARBG(IIGAR1),ITEMP1(1))
      EQUIVALENCE (IGARBG(IIGAR2),ITEMP2(1))
      EQUIVALENCE (IGARBG(IIGAR3),ITEMP3(1))
      EQUIVALENCE (IGARBG(IIGAR4),ITEMP4(1))
      EQUIVALENCE (IGARBG(IIGAR5),ITEMP5(1))
      EQUIVALENCE (IGARBG(IIGAR6),ITEMP6(1))
C
      EQUIVALENCE (DGARBG(IDGAR1),DTEMP1(1))
      EQUIVALENCE (DGARBG(IDGAR2),DTEMP2(1))
      EQUIVALENCE (DGARBG(IDGAR3),DTEMP3(1))
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOHK.INC'
      INCLUDE 'DPCODA.INC'
      INCLUDE 'DPCOHO.INC'
      INCLUDE 'DPCOST.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IERROR='NO'
C
      ISUBN1='CRPL'
      ISUBN2='    '
C
      MAXCP1=MAXCOL+1
      MAXCP2=MAXCOL+2
      MAXCP3=MAXCOL+3
      MAXCP4=MAXCOL+4
      MAXCP5=MAXCOL+5
      MAXCP6=MAXCOL+6
C
      MAXV2=2
      MINN2=2
C
      IXVAR='OFF'
      IX2VAR='OFF'
      IYVAR='ON'
C
C               ******************************************
C               **  TREAT THE CROSS TABULATE PLOT CASE  **
C               ******************************************
C
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'CRPL')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPCRPL--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)ICONT,ISUBRO,IBUGG2,IBUGG3,IBUGQ
   52   FORMAT('ICONT,ISUBRO,IBUGG2,IBUGG3,IBUGQ  = ',
     1         A4,2X,A4,2X,A4,2X,A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,53)ICASPL,IAND1,IAND2
   53   FORMAT('ICASPL,IAND1,IAND2 = ',A4,2X,A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               *************************************
C               **  STEP 1--                       **
C               **  EXTRACT THE COMMAND            **
C               **  COMMAND SYNTAX IS:             **
C               **  CROSS TABULATE <STAT> PLOT     **
C               *************************************
C
      ISTEPN='1'
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'CRPL')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(NUMARG.LE.2)GOTO9000
      IF(ICOM.NE.'CROS')GOTO9000
      IF(IHARG(1).NE.'TABU')GOTO9000
C
CCCCC MARCH 2009: USE "EXTSTA" TO PARSE.  NOTE THAT IF NO
CCCCC             STATISTIC IS GIVEN, WE ASSUME THE "COUNTS"
CCCCC             CASE.
C
      JMIN=2
      JMAX=MIN(NUMARG,JMIN+6)
      DO200I=JMIN,JMAX
        IF(IHARG(I).EQ.'PLOT')THEN
          JMAX=I-1
          ILASTC=I
          GOTO209
        ENDIF
  200 CONTINUE
      IFOUND='NO'
      GOTO9000
  209 CONTINUE
C
      CALL EXTSTA(ICOM,ICOM2,IHARG,IHARG2,IARGT,ARG,NUMARG,JMIN,JMAX,
     1            ICASPL,ISTANM,ISTANR,ISTADF,IFOUND,ILOCV,
     1            ISUBRO,IBUGG3,IERROR)
C
      IF(IFOUND.EQ.'YES')THEN
        IF(ISTANR.GE.2)IXVAR='ON'
        IF(ISTANR.GE.3)IX2VAR='ON'
        IF(ICASPL.EQ.'NUMB')IYVAR='OFF'
      ELSE
        ICASPL='NUMB'
        IYVAR='OFF'
        IXVAR='OFF'
        ILOCV=2
        IFOUND='YES'
      ENDIF
C
      CALL ADJUST(ILASTC,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG)
C
C               *********************************
C               **  STEP 2--                   **
C               **  EXTRACT THE VARIABLE LIST  **
C               *********************************
C
      INAME='CROSS TABULATE PLOT'
      MINNA=1
      MAXNA=100
      MINN2=2
      IFLAGE=1
      IFLAGM=0
      IFLAGP=0
      JMIN=1
      JMAX=NUMARG
      MINNVA=-99
      MAXNVA=-99
C
      CALL DPPARS(IHARG,IHARG2,IARGT,ARG,NUMARG,IANS,IWIDTH,
     1            IHNAME,IHNAM2,IUSE,NUMNAM,IN,IVALUE,VALUE,
     1            JMIN,JMAX,
     1            MINN2,MINNA,MAXNA,MAXSPN,IFLAGE,INAME,
     1            IVARN1,IVARN2,IVARTY,PVAR,
     1            ILIS,NRIGHT,ICOLR,ISUB,NQ,ILOCQ,NUMVAR,
     1            MINNVA,MAXNVA,
     1            IFLAGM,IFLAGP,
     1            IBUGG3,IBUGQ,ISUBRO,IFOUND,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'CRPL')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,281)
  281   FORMAT('***** AFTER CALL DPPARS--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,282)NQ,NUMVAR
  282   FORMAT('NQ,NUMVAR = ',2I8)
        CALL DPWRST('XXX','BUG ')
        IF(NUMVAR.GT.0)THEN
          DO285I=1,NUMVAR
            WRITE(ICOUT,287)I,IVARN1(I),IVARN2(I),ILIS(I),NRIGHT(I),
     1                      ICOLR(I)
  287       FORMAT('I,IVARN1(I),IVARN2(I),ILIS(I),NRIGHT(I),',
     1             'ICOLR(I) = ',I8,2X,A4,A4,2X,3I8)
            CALL DPWRST('XXX','BUG ')
  285     CONTINUE
        ENDIF
      ENDIF
C
C     NEED FOLLOWING VARIABLES:
C     1) TWO GROUP-ID VARIABLE
C     2) ONE RESPONSE VARIABLE FOR STATISTICS THAT REQUIRE ONE VARIABLE
C     3) TWO RESPONSE VARIABLES FOR STATISTICS THAT REQUIRE TWO VARIABLES
C     4) THREE RESPONSE VARIABLES FOR STATISTICS THAT REQUIRE THREE
C        VARIABLES
C
      IF(ICASPL.EQ.'NUMB')ISTANR=0
      MINVAR=2+ISTANR
      IF(NUMVAR.NE.MINVAR)THEN
C
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,211)ISTANA
  211   FORMAT('***** ERROR IN CROSS TABULATE PLOT COMMAND--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,212)MINVAR
  212   FORMAT('      EXACTLY ',I5,' VARIABLES REQUIRED, BUT')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,213)NUMVAR
  213   FORMAT('      ',I8,' VARIABLES WERE GIVEN.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,215)
  215   FORMAT('      THE ENTERED COMMAND LINE WAS AS FOLLOWS--')
        CALL DPWRST('XXX','BUG ')
        IF(IWIDTH.GE.1)THEN
          WRITE(ICOUT,216)(IANS(J),J=1,MIN(80,IWIDTH))
  216     FORMAT('      ',80A1)
          CALL DPWRST('XXX','BUG ')
          IERROR='YES'
          GOTO9000
        ENDIF
      ENDIF
C
C               ********************************
C               **  STEP 3--                  **
C               **  EXTRACT THE DATA          **
C               ********************************
C
      ISTEPN='3'
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'CRPL')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      J=0
      IMAX=NLEFT
      IF(NQ.LT.NLEFT)IMAX=NQ
      DO2660I=1,IMAX
        IF(ISUB(I).EQ.0)GOTO2660
        J=J+1
C
        IF(IYVAR.EQ.'OFF')THEN
          Y1(J)=0.0
        ELSE
          ICOLL=ICOLR(1)
          IJ=MAXN*(ICOLL-1)+I
          IF(ICOLL.LE.MAXCOL)Y1(J)=V(IJ)
          IF(ICOLL.EQ.MAXCP1)Y1(J)=PRED(I)
          IF(ICOLL.EQ.MAXCP2)Y1(J)=RES(I)
          IF(ICOLL.EQ.MAXCP3)Y1(J)=YPLOT(I)
          IF(ICOLL.EQ.MAXCP4)Y1(J)=XPLOT(I)
          IF(ICOLL.EQ.MAXCP5)Y1(J)=X2PLOT(I)
          IF(ICOLL.EQ.MAXCP6)Y1(J)=TAGPLO(I)
        ENDIF
        ICNT=1
C
        IF(IXVAR.EQ.'OFF')THEN
          Z1(J)=0.0
        ELSE
          ICNT=ICNT+1
          ICOLX=ICOLR(ICNT)
          IJ=MAXN*(ICOLX-1)+I
          IF(ICOLX.LE.MAXCOL)Z1(J)=V(IJ)
          IF(ICOLX.EQ.MAXCP1)Z1(J)=PRED(I)
          IF(ICOLX.EQ.MAXCP2)Z1(J)=RES(I)
          IF(ICOLX.EQ.MAXCP3)Z1(J)=YPLOT(I)
          IF(ICOLX.EQ.MAXCP4)Z1(J)=XPLOT(I)
          IF(ICOLX.EQ.MAXCP5)Z1(J)=X2PLOT(I)
          IF(ICOLX.EQ.MAXCP6)Z1(J)=TAGPLO(I)
        ENDIF
C
        IF(IX2VAR.EQ.'OFF')THEN
          Z2(J)=0.0
        ELSE
          ICNT=ICNT+1
          ICOLX=ICOLR(ICNT)
          IJ=MAXN*(ICOLX-1)+I
          IF(ICOLX.LE.MAXCOL)Z2(J)=V(IJ)
          IF(ICOLX.EQ.MAXCP1)Z2(J)=PRED(I)
          IF(ICOLX.EQ.MAXCP2)Z2(J)=RES(I)
          IF(ICOLX.EQ.MAXCP3)Z2(J)=YPLOT(I)
          IF(ICOLX.EQ.MAXCP4)Z2(J)=XPLOT(I)
          IF(ICOLX.EQ.MAXCP5)Z2(J)=X2PLOT(I)
          IF(ICOLX.EQ.MAXCP6)Z2(J)=TAGPLO(I)
        ENDIF
C
        ICNT=ICNT+1
        ICOLH=ICOLR(ICNT)
        IJ=MAXN*(ICOLH-1)+I
        IF(ICOLH.LE.MAXCOL)X1(J)=V(IJ)
        IF(ICOLH.EQ.MAXCP1)X1(J)=PRED(I)
        IF(ICOLH.EQ.MAXCP2)X1(J)=RES(I)
        IF(ICOLH.EQ.MAXCP3)X1(J)=YPLOT(I)
        IF(ICOLH.EQ.MAXCP4)X1(J)=XPLOT(I)
        IF(ICOLH.EQ.MAXCP5)X1(J)=X2PLOT(I)
        IF(ICOLH.EQ.MAXCP6)X1(J)=TAGPLO(I)
C
        ICNT=ICNT+1
        ICOLH2=ICOLR(ICNT)
        IJ=MAXN*(ICOLH2-1)+I
        IF(ICOLH2.LE.MAXCOL)X2(J)=V(IJ)
        IF(ICOLH2.EQ.MAXCP1)X2(J)=PRED(I)
        IF(ICOLH2.EQ.MAXCP2)X2(J)=RES(I)
        IF(ICOLH2.EQ.MAXCP3)X2(J)=YPLOT(I)
        IF(ICOLH2.EQ.MAXCP4)X2(J)=XPLOT(I)
        IF(ICOLH2.EQ.MAXCP5)X2(J)=X2PLOT(I)
        IF(ICOLH2.EQ.MAXCP6)X2(J)=TAGPLO(I)
C
 2660 CONTINUE
      NLOCAL=J
C
C               ******************************************************
C               **  STEP 28--                                       **
C               **  COMPUTE THE APPROPRIATE STATISTIC PLOT STATISTIC--
C               **  (MEAN, STANDARD DEVIATION, RANGE, OR CUSUM).    **
C               **  COMPUTE CONFIDENCE LINES.                       **
C               **  FORM THE VERTICAL AND HORIZONTAL AXIS           **
C               **  VALUES Y(.) AND X(.) FOR THE PLOT.              **
C               **  DEFINE THE VECTOR D(.) TO 1'S, 2'S, AND 3'S     **
C               **  FOR THE PLOTTED VALUE, THE LOWER CONFIDENCE LINE,*
C               **  AND THE UPPER CONFIDENCE LINE.                  **
C               **  DEFINE THE NUMBER OF PLOT POINTS    (NPLOTP).   **
C               **  DEFINE THE NUMBER OF PLOT VARIABLES (NPLOTV).   **
C               ******************************************************
C
      ISTEPN='28'
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'CRPL')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      CALL DPCRP2(Y1,Z1,Z2,X1,X2,NLOCAL,NUMV2,ISTANR,ICASPL,ISIZE,ICONT,
     1            TEMP,TEMP2,TEMP3,TEMP4,
     1            XTEMP1,XTEMP2,XTEMP3,XTEMP4,XTEMP5,MAXNXT,
     1            ISEED,ITEMP1,ITEMP2,ITEMP3,ITEMP4,ITEMP5,ITEMP6,
     1            DTEMP1,DTEMP2,DTEMP3,
     1            ICTBDI,
     1            IQUAME,IQUASE,PSTAMV,
     1            Y,X,D,X3D,NPLOTP,NPLOTV,ISUBRO,IBUGG3,IERROR)
      IF(ICASPL.EQ.'COUN')THEN
        ICASPL='CTCO'
      ELSE
        IF(ICTBDI.EQ.'2')THEN
          ICASPL='CTA2'
        ELSE
          ICASPL='CTAB'
        ENDIF
      ENDIF
C
C
C               *************************************************
C               **  STEP 29--                                  **
C               **  SAVE DIFFERENCE BETWEEN HIGHEST VALUE AND  **
C               **  LOWEST VALUE OF STATISTIC IN INTERNAL      **
C               **  PARAMETER ALOWHIGH                         **
C               *************************************************
      AMINS=CPUMAX
      AMAXS=CPUMIN
      DO2910I=1,NPLOTP
        IF(D(I).NE.1.0)GOTO2910
        IF(Y(I).GT.AMAXS)AMAXS=Y(I)
        IF(Y(I).LT.AMINS)AMINS=Y(I)
 2910 CONTINUE
      ADIFF=0.0
      IF(AMINS.NE.CPUMAX.AND.AMAXS.NE.CPUMIN)ADIFF=AMAXS-AMINS
C
      ISUBN0='DPCRPL'
C
      IH='ALOW'
      IH2='HIGH'
      VALUE0=ADIFF
      CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1IANS,IWIDTH,IBUGG3,IERROR)
C
C
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG2.EQ.'ON'.OR.ISUBRO.EQ.'CRPL')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPCRPL--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)ICONT,ISUBRO,IBUGG2,IBUGG3,IBUGQ
 9012   FORMAT('ICONT,ISUBRO,IBUGG2,IBUGG3,IBUGQ  = ',
     1         A4,2X,A4,2X,A4,2X,A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)IFOUND,IERROR
 9013   FORMAT('IFOUND,IERROR = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9014)NPLOTV,NPLOTP,NS,ICASPL,IAND1,IAND2
 9014   FORMAT('NPLOTV,NPLOTP,NS,ICASPL,IAND1,IAND2 = ',
     1         I8,I8,I8,2X,A4,2X,A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9015)ISIZE,NUMV2
 9015   FORMAT('ISIZE,NUMV2 = ',2I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9017)IHLEFT,IHLEF2,ICOLL,NLEFT
 9017   FORMAT('IHLEFT,IHLEF2,ICOLL,NLEFT = ',A4,2X,A4,I8,I8)
        CALL DPWRST('XXX','BUG ')
        IF(NUMV2.GE.2)THEN
          WRITE(ICOUT,9018)IHHOR,IHHOR2,ICOLH,NHOR
 9018     FORMAT('IHHOR,IHHOR2,ICOLH,NHOR = ',A4,2X,A4,I8,I8)
          CALL DPWRST('XXX','BUG ')
        ENDIF
        IF(NUMV2.GE.3)THEN
          WRITE(ICOUT,9019)IHX,IHX2,ICOLX,NX
 9019     FORMAT('IHX,IHX2,ICOLX,NX = ',A4,2X,A4,I8,I8)
          CALL DPWRST('XXX','BUG ')
        ENDIF
CCCCC   THE FOLLOWING LINE WAS CHANGED SEPTEMBER 1992
CCCCC   IF(NPLOTP.LE.0)GOTO9090
        IF(IFOUND.EQ.'YES'.AND.NPLOTP.GT.0)THEN
          DO9025I=1,NPLOTP
            WRITE(ICOUT,9026)I,Y(I),X(I),D(I)
 9026       FORMAT('I,Y(I),X(I),D(I) = ',I8,3F12.5)
            CALL DPWRST('XXX','BUG ')
 9025     CONTINUE
        ENDIF
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPCRP2(Y,Z,Z2,TAG1,TAG2,N,NUMV2,ISTANR,ICASPL,
     1                  ISIZE,ICONT,
     1                  TEMP,TEMPZ,TEMPZ2,XIDTEM,XIDTE2,
     1                  XTEMP1,XTEMP2,XTEMP4,XTEMP5,MAXNXT,
     1                  ISEED,ITEMP1,ITEMP2,ITEMP3,ITEMP4,ITEMP5,ITEMP6,
     1                  DTEMP1,DTEMP2,DTEMP3,
     1                  ICTBDI,
     1                  IQUAME,IQUASE,PSTAMV,
     1                  Y2,X2,D2,X3D,N2,NPLOTV,ISUBRO,IBUGG3,IERROR)
C
C     PURPOSE--GENERATE A PAIR OF COORDINATE VECTORS THAT WILL DEFINE
C              A PLOT FOR ONE OF DATAPLOT'S SUPPORTED STATISTICS
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     REFERENCE--ASTM MANUAL STP-15D, PAGES 78-84, 100-105
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--99/11
C     ORIGINAL VERSION--NOVEMBER  1999.
C     UPDATED         --JULY      2002. WINSORIZED VARIANCE
C     UPDATED         --JULY      2002. WINSORIZED SD
C     UPDATED         --JULY      2002. ADD WINSORIZED COVARIANCE PLOT
C     UPDATED         --JULY      2002. ADD WINSORIZED CORRELATION PLOT
C     UPDATED         --JULY      2002. ADD BIWEIGHT MIDVARIANCE PLOT
C     UPDATED         --JULY      2002. ADD BIWEIGHT MIDCOVARIANCE PLOT
C     UPDATED         --JULY      2002. ADD PERCENTAGE BEND MIDVARIANCE
C                                           PLOT
C     UPDATED         --JULY      2002. ADD HODGES LEHMAN PLOT
C     UPDATED         --JULY      2002. ADD QUANTILE PLOT
C     UPDATED         --JULY      2002. ADD QUANTILE STANDARD ERROR PLOT
C     UPDATED         --JULY      2002. ADD TRIMMED MEAN STANDARD ERROR
C                                       PLOT
C     UPDATED         --APRIL     2003. ADD SN AND QN
C     UPDATED         --JUNE      2010. ADD Z2/TEMPZ2 TO CALL LIST
C     UPDATED         --JUNE      2010. CALL LIST TO CMPSTA
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICASPL
      CHARACTER*4 ICASP2
      CHARACTER*4 ICONT
      CHARACTER*4 ICTBDI
      CHARACTER*4 IQUAME
      CHARACTER*4 IQUASE
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGG3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION Z(*)
      DIMENSION Z2(*)
      DIMENSION TAG1(*)
      DIMENSION TAG2(*)
      DIMENSION Y2(*)
      DIMENSION X2(*)
      DIMENSION D2(*)
      DIMENSION X3D(*)
C
      DIMENSION TEMP(*)
      DIMENSION TEMPZ(*)
      DIMENSION TEMPZ2(*)
      DIMENSION XIDTEM(*)
      DIMENSION XIDTE2(*)
      DIMENSION XTEMP1(*)
      DIMENSION XTEMP2(*)
      DIMENSION XTEMP4(*)
      DIMENSION XTEMP5(*)
      INTEGER ITEMP1(*)
      INTEGER ITEMP2(*)
      INTEGER ITEMP3(*)
      INTEGER ITEMP4(*)
      INTEGER ITEMP5(*)
      INTEGER ITEMP6(*)
C
      DOUBLE PRECISION DTEMP1(*)
      DOUBLE PRECISION DTEMP2(*)
      DOUBLE PRECISION DTEMP3(*)
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCOHK.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPCR'
      ISUBN2='P2  '
C
      IWRITE='OFF'
C
      I2=0
      ISIZE2=0
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(N.LT.2)THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,31)
   31   FORMAT('***** ERROR IN CROSS TABULATE PLOT--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,32)
   32   FORMAT('      THE NUMBER OF OBSERVATIONS MUST BE AT LEAST 1;')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,34)N
   34   FORMAT('      THE ENTERED NUMBER OF OBSERVATIONS HERE = ',I6)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      IF(IBUGG3.EQ.'ON'.OR.ISUBRO.EQ.'CRP2')THEN
        WRITE(ICOUT,70)
   70   FORMAT('AT THE BEGINNING OF DPCRP2--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,71)IBUGG3,ISUBRO
   71   FORMAT('IBUGG3,ISUBRO = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,72)N,ICASPL,ICONT
   72   FORMAT('N,ICASPL,ICONT = ',I8,2X,A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        DO73I=1,N
          WRITE(ICOUT,74)I,Y(I),Z(I),Z2(I),TAG1(I),TAG2(I)
   74     FORMAT('I, Y(I),Z(I),Z2(I),TAG1(I)TAG2(I) = ',I8,5G15.7)
          CALL DPWRST('XXX','BUG ')
   73   CONTINUE
      ENDIF
C
C               ******************************************************
C               **  STEP 1--                                        **
C               **  DETERMINE THE NUMBER OF DISTINCT VALUES         **
C               **  FOR THE GROUP VARIABLES (TAG1, TAG2)            **
C               **  IF ALL VALUES ARE DISTINCT, THEN THIS           **
C               **  IMPLIES WE HAVE THE NO REPLICATION CASE         **
C               **  WHICH IS AN ERROR CONDITION FOR A PLOT.         **
C               ******************************************************
C
      ISTEPN='1'
      IF(IBUGG3.EQ.'ON'.OR.ISUBRO.EQ.'CRP2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      CALL DISTIN(TAG1,N,IWRITE,XIDTEM,NUMSE1,IBUGG3,IERROR)
      CALL SORT(XIDTEM,NUMSE1,XIDTEM)
      CALL DISTIN(TAG2,N,IWRITE,XIDTE2,NUMSE2,IBUGG3,IERROR)
      CALL SORT(XIDTE2,NUMSE2,XIDTE2)
C
      IF(NUMSE1.LT.1)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,31)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,192)
  192   FORMAT('      NUMBER OF SETS    NUMSE1 = 0 ')
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      IF(NUMSE2.LT.1)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,31)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,194)
  194   FORMAT('      NUMBER OF SETS    NUMSE2 = 0 ')
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      IF(NUMSE1.EQ.N)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,31)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,196)NUMSE1
  196   FORMAT('      NUMBER OF SETS FOR GROUP 1 VARIABLE ',I8,
     1         ' IDENTICAL TO ')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,197)N
  197   FORMAT('      NUMBER OF OBSERVATIONS ',I8,' .')
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      IF(NUMSE2.EQ.N)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,31)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,206)NUMSE2
  206   FORMAT('      NUMBER OF SETS FOR GROUP 2 VARIABLE ',I8,
     1         ' IDENTICAL TO ')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,197)N
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      AN=N
      ANUMS1=NUMSE1
      ANUMS2=NUMSE2
C
C               ****************************************************
C               **  STEP 11--                                     **
C               **  COMPUTE THE SPECIFIED STATISTIC               **
C               **  FOR EACH CROSS-TAB CATEGORY OF THE DATA, AND  **
C               **  THEN FOR THE FULL DATA SET                    **
C               ****************************************************
C
      ISTEPN='11'
      IF(IBUGG3.EQ.'ON'.OR.ISUBRO.EQ.'CRP2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      J=0
      ATAG=1.0
C
      AINC=0.4/REAL(NUMSE2)
      ICASP2=ICASPL
      IF(ICASPL.EQ.'COUN')ICASP2='NUMB'
      DO11000ISET1=1,NUMSE1
CCCCC ATAG=ATAG+1.0
      DO12000ISET2=1,NUMSE2
C
        K=0
        ASTRT=XIDTEM(ISET1)-0.2
        DO11011I=1,N
        IF(TAG1(I).EQ.XIDTEM(ISET1).AND.TAG2(I).EQ.XIDTE2(ISET2))THEN
          K=K+1
          TEMP(K)=Y(I)
          TEMPZ(K)=Z(I)
          TEMPZ2(K)=Z2(I)
        ENDIF
11011   CONTINUE
        NS2=K
        IF(NS2.LT.1)GOTO12000
        CALL DPCRP3(ICASP2,TEMP,TEMPZ,TEMPZ2,NS2,XTEMP1,XTEMP2,XTEMP4,
     1              MAXNXT,RIGHT,
     1              ISEED,ITEMP1,ITEMP2,ITEMP3,ITEMP4,ITEMP5,ITEMP6,
     1              DTEMP1,DTEMP2,DTEMP3,
     1              IQUAME,IQUASE,PSTAMV,ISTANR,
     1              ISUBRO,IBUGG3,IERROR)
        J=J+1
        IF(ICASPL.NE.'COUN'.AND.ICTBDI.EQ.'1')THEN
          Y2(J)=RIGHT
          X2(J)=ASTRT + REAL(ISET2-1)*AINC
          D2(J)=ATAG
        ELSE
          Y2(J)=REAL(XIDTE2(ISET2))
          X2(J)=REAL(XIDTEM(ISET1))
          X3D(J)=RIGHT
CCCCC     D2(J)=RIGHT
          D2(J)=1.0
        ENDIF
12000 CONTINUE
11000 CONTINUE
C
      IF(ICASPL.EQ.'COUN')GOTO13000
      IF(ICTBDI.EQ.'2')GOTO13000
      ATAG=2.0
      DO10500ISET1=1,NUMSE1
        K=0
        DO10550I=1,N
          IF(TAG1(I).EQ.XIDTEM(ISET1))THEN
            K=K+1
            TEMP(K)=Y(I)
            TEMPZ(K)=Z(I)
            TEMPZ2(K)=Z2(I)
          ENDIF
10550   CONTINUE
        NS2=K
        IF(NS2.LT.1)GOTO10500
        CALL DPCRP3(ICASPL,TEMP,TEMPZ,TEMPZ2,NS2,XTEMP1,XTEMP2,XTEMP4,
     1              MAXNXT,RIGHT,
     1              ISEED,ITEMP1,ITEMP2,ITEMP3,ITEMP4,ITEMP5,ITEMP6,
     1              DTEMP1,DTEMP2,DTEMP3,
     1              IQUAME,IQUASE,PSTAMV,ISTANR,
     1              ISUBRO,IBUGG3,IERROR)
        J=J+1
        ATAG=ATAG+1.0
        Y2(J)=RIGHT
        X2(J)=XIDTEM(ISET1)-0.2
        D2(J)=ATAG
        J=J+1
        Y2(J)=RIGHT
        X2(J)=XIDTEM(ISET1)+0.2
        D2(J)=ATAG
10500 CONTINUE
C
      DO10100I=1,N
        TEMP(I)=Y(I)
        TEMPZ(I)=Z(I)
        TEMPZ2(I)=Z2(I)
10100 CONTINUE
      NS2=N
      CALL DPCRP3(ICASPL,TEMP,TEMPZ,TEMPZ2,NS2,XTEMP1,XTEMP2,XTEMP4,
     1            MAXNXT,RIGHT,
     1            ISEED,ITEMP1,ITEMP2,ITEMP3,ITEMP4,ITEMP5,ITEMP6,
     1            DTEMP1,DTEMP2,DTEMP3,
     1            IQUAME,IQUASE,PSTATMV,ISTANR,
     1            ISUBRO,IBUGG3,IERROR)
      ATAG=2.0
      J=J+1
      Y2(J)=RIGHT
      X2(J)=XIDTEM(1)-0.2
      D2(J)=ATAG
      J=J+1
      Y2(J)=RIGHT
      X2(J)=XIDTEM(NUMSE1)+0.2
      D2(J)=ATAG
C
13000 CONTINUE
      N2=J
      NPLOTV=3
      GOTO9000
C
C               ******************
C               **   STEP 90--  **
C               **   EXIT       **
C               ******************
C
 9000 CONTINUE
      IF(IBUGG3.EQ.'ON'.OR.ISUBRO.EQ.'CRP2')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPCRP2--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)IBUGG3,ISUBRO
 9012   FORMAT('IBUGG3,ISUBRO = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)ICASPL,N,NUMSE1,NUMSE2,N2,IERROR
 9013   FORMAT('ICASPL,N,NUMSE1,NUMSE2,N2,IERROR = ',A4,4I8,2X,A4)
        CALL DPWRST('XXX','BUG ')
        DO9020I=1,N2
          WRITE(ICOUT,9021)I,Y2(I),X2(I),D2(I)
 9021     FORMAT('I,Y2(I),X2(I),D2(I) = ',I8,2E15.7,F9.2)
          CALL DPWRST('XXX','BUG ')
 9020   CONTINUE
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPCRP3(ICASPL,TEMP,TEMPZ,TEMPZ3,NS2,
     1                  XTEMP1,XTEMP2,XTEMP3,
     1                  MAXNXT,
     1                  RIGHT,
     1                  ISEED,ITEMP1,ITEMP2,ITEMP3,ITEMP4,ITEMP5,ITEMP6,
     1                  DTEMP1,DTEMP2,DTEMP3,
     1                  IQUAME,IQUASE,PSTAMV,ISTANR,
     1                  ISUBRO,IBUGG3,IERROR)
C
C     PURPOSE--FOR CROSS-TABULATE PLOT, GENERATE VALUE OF
C              STATISTIC.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     REFERENCE--ASTM MANUAL STP-15D, PAGES 78-84, 100-105
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--99/11
C     ORIGINAL VERSION--NOVEMBER  1999.
C     UPDATED         --AUGUST    2002. USE "CMPSTA" TO COMPUTE THE
C                                       DESIRED STATISTIC
C     UPDATED         --JUNE      2010. CALL LIST TO CMPSTA
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICASPL
      CHARACTER*4 IQUAME
      CHARACTER*4 IQUASE
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGG3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
C---------------------------------------------------------------------
C
      DIMENSION TEMP(*)
      DIMENSION TEMPZ(*)
      DIMENSION TEMPZ3(*)
      DIMENSION XTEMP1(*)
      DIMENSION XTEMP2(*)
      DIMENSION XTEMP3(*)
      INTEGER ITEMP1(*)
      INTEGER ITEMP2(*)
      INTEGER ITEMP3(*)
      INTEGER ITEMP4(*)
      INTEGER ITEMP5(*)
      INTEGER ITEMP6(*)
      DOUBLE PRECISION DTEMP1(*)
      DOUBLE PRECISION DTEMP2(*)
      DOUBLE PRECISION DTEMP3(*)
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCOHK.INC'
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPCR'
      ISUBN2='P3  '
C
      IWRITE='OFF'
C
      CALL CMPSTA(TEMP,TEMPZ,TEMPZ3,XTEMP1,XTEMP2,XTEMP3,MAXNXT,
     1            NS2,NS2,NS2,ISTANR,ICASPL,
     1            ISEED,ITEMP1,ITEMP2,ITEMP3,ITEMP4,ITEMP5,ITEMP6,
     1            DTEMP1,DTEMP2,DTEMP3,
CCCCC1            IQUAME,IQUASE,PSTAMV,
     1            RIGHT,
     1            ISUBRO,IBUGG3,IERROR)
C
C               ******************
C               **   STEP 90--  **
C               **   EXIT       **
C               ******************
C
 9000 CONTINUE
      IF(IBUGG3.EQ.'ON'.OR.ISUBRO.EQ.'CRP3')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPCRP3--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)IBUGG3,ISUBRO
 9012   FORMAT('IBUGG3,ISUBRO = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)ICASPL,NS2,IERROR
 9013   FORMAT('ICASPL,NS2,IERROR = ',A4,I8,2X,A4)
        CALL DPWRST('XXX','BUG ')
        DO9020I=1,NS2
          WRITE(ICOUT,9021)I,TEMP(I),TEMPZ(I)
 9021     FORMAT('I,TEMP(I),TEMPZ(I) = ',I8,2E15.7)
          CALL DPWRST('XXX','BUG ')
 9020   CONTINUE
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPCRTA(Y1,X1,X2,MAXNXT,
     1ISEED,
     1ICAPSW,IFORSW,
     1IBUGA2,IBUGA3,IBUGQ,ISUBRO,IFOUND,IERROR)
C
C     PURPOSE--GENERATE A CROSS-TABULATION FOR ONE OF DATAPLOT'S
C              SUPPORTED STATISTICS.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--89/12
C     ORIGINAL VERSION--NOVEMBER  1989.
C     UPDATED         --JUNE      1990.  TEMPORARY ARRAYS TO GARBAGE COMMON
C     UPDATED         --OCTOBER   1992. ADD SUMS AND CHI-SQUARE
C     UPDATED         --AUGUST    2002. EXPAND LIST OF SUPPORTED
C                                       STATISTICS
C     UPDATED         --MARCH     2003. WEIGHTED MEAN, WEIGHTED SD,
C                                       WEIGHTED VARIANCE
C     UPDATED         --MARCH     2003. 35 "DIFFERENCE OF" STATISTICS
C     UPDATED         --APRIL     2003. SN AND QN (AND DIFFERENCE OF)
C                                       REQUIRED ADDITION OF
C                                       ADDITIONAL SCRATCH ARRAYS
C     UPDATED         --MAY       2003. WEIGHTED TRIMMED MEAN
C     UPDATED         --OCTOBER   2004. KENDELLS TAU
C     UPDATED         --SEPTEMBER 2005. RATIO
C     UPDATED         --MARCH     2007. RELATIVE RISK
C     UPDATED         --MARCH     2007. CRAMER CONTINGENCY COEFFICIENT
C     UPDATED         --MARCH     2007. PEARSON CONTINGENCY COEFFICIENT
C     UPDATED         --MARCH     2007. FALSE POSITIVE
C     UPDATED         --MARCH     2007. FALSE NEGATIVE
C     UPDATED         --MARCH     2007. TRUE POSITIVE
C     UPDATED         --MARCH     2007. TRUE NEGATIVE
C     UPDATED         --MARCH     2007. TEST SENSITIVITY
C     UPDATED         --MARCH     2007. TEST SPECIFICITY
C     UPDATED         --APRIL     2007. POSITIVE PREDICTIVE VALUE
C     UPDATED         --APRIL     2007. NEGATIVE PREDICTIVE VALUE
C     UPDATED         --APRIL     2007. ODDS RATIO
C     UPDATED         --APRIL     2007. STANDARD ERROR ODDS RATIO
C     UPDATED         --APRIL     2007. LOG ODDS RATIO
C     UPDATED         --APRIL     2007. LOG STANDARD ERROR ODDS RATIO
C     UPDATED         --NOVEMBER  2007. DOUBLE PRECISION ARRAYS FOR
C                                       CMPSTA
C     UPDATED         --NOVEMBER  2007. LP LOCATION
C     UPDATED         --NOVEMBER  2007. VARIANCE OF LP LOCATION
C     UPDATED         --NOVEMBER  2007. SD OF LP LOCATION
C     UPDATED         --NOVEMBER  2007. DIFFERENCE OF LP LOCATION
C     UPDATED         --NOVEMBER  2007. DIFFERENCE OF VARI OF LP LOCATION
C     UPDATED         --NOVEMBER  2007. DIFFERENCE OF SD OF LP LOCATION
C     UPDATED         --APRIL     2008. SUPPORT FOR 3, 4, 5, OR 6
C                                       CROSS-TABULATION VARIABLES
C     UPDATED         --APRIL     2008. SUPPORT FOR RTF
C     UPDATED         --APRIL     2008. SINCE THERE IS NOW A SEPARATE
C                                       "CHI-SQUARE INDEPENDENCE" TEST
C                                       REMOVE IT FROM HERE
C     UPDATED         --APRIL     2008. "BINOMIAL PROBABILITY" OPTION
C                                       (THIS RECIEVES SPECIAL
C                                       HANDLING)
C     UPDATED         --FEBRUARY  2009. INDEX MINIMUM
C     UPDATED         --FEBRUARY  2009. INDEX MAXIMUM
C     UPDATED         --FEBRUARY  2009. INDEX EXTREME
C     UPDATED         --FEBRUARY  2009. GRUBB
C                                       GRUBB CDF
C                                       GRUBB DIRECTION
C                                       GRUBB INDEX
C     UPDATED         --FEBRUARY  2009. ONE SAMPLE T TEST
C                                       ONE SAMPLE T TEST CDF
C     UPDATED         --FEBRUARY  2009. CHI-SQUARE SD TEST
C                                       CHI-SQUARE SD TEST CDF
C     UPDATED         --FEBRUARY  2009. FREQUENCY TEST
C                                       FREQUENCY TEST CDF
C     UPDATED         --FEBRUARY  2009. FREQUENCY WITHIN A BLOCK TEST
C                                       FREQUENCY WITHIN A BLOCK TEST CDF
C     UPDATED         --MARCH     2009. PARSE WITH "EXTSTA"
C     UPDATED         --FEBRUARY  2010. USE DPPARS
C     UPDATED         --FEBRUARY  2010. HANDLE ONE GROUP-ID VARIABLE
C                                       CASE
C     UPDATED         --JUNE      2010. CALL LIST TO CMPSTA
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICASCT
      CHARACTER*40 ICTNAM
      CHARACTER*4 ICAPSW
      CHARACTER*4 IFORSW
      CHARACTER*4 IBUGA2
      CHARACTER*4 IBUGA3
      CHARACTER*4 IBUGQ
      CHARACTER*4 ISUBRO
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
      CHARACTER*4 IHWUSE
      CHARACTER*4 MESSAG
      CHARACTER*4 IHP
      CHARACTER*4 IHP2
      CHARACTER*4 ICASEQ
C
      CHARACTER*40 INAME
      PARAMETER (MAXSPN=10)
      CHARACTER*4 IVARN1(MAXSPN)
      CHARACTER*4 IVARN2(MAXSPN)
      CHARACTER*4 IVARTY(MAXSPN)
      REAL PVAR(MAXSPN)
      INTEGER ILIS(MAXSPN)
      INTEGER NRIGHT(MAXSPN)
      INTEGER ICOLR(MAXSPN)
C
      CHARACTER*4 IXVAR
      CHARACTER*4 IX2VAR
      CHARACTER*4 IYVAR
C
      CHARACTER*8 IYNAM
      CHARACTER*8 IXNAM
      CHARACTER*8 IXNAM2
      CHARACTER*8 IX1NAM
      CHARACTER*8 IX2NAM
      CHARACTER*8 IX3NAM
      CHARACTER*8 IX4NAM
      CHARACTER*8 IX5NAM
      CHARACTER*8 IX6NAM
C
      CHARACTER*4 ISTADF
      CHARACTER*60 ISTANM
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
C
      DIMENSION Y1(*)
      DIMENSION X1(*)
      DIMENSION X2(*)
C
      PARAMETER (MAXGR9=6)
      DIMENSION XH1DIS(MAXOBV,MAXGR9)
      DIMENSION XDESGN(MAXOBV,MAXGR9)
      DIMENSION TEMP(MAXOBV)
      DIMENSION TEMPZ(MAXOBV)
      DIMENSION TEMPZ2(MAXOBV)
      DIMENSION XTEMP1(MAXOBV)
      DIMENSION Z1(MAXOBV)
      DIMENSION Z2(MAXOBV)
      DIMENSION XTEMP2(MAXOBV)
      DIMENSION XTEMP3(MAXOBV)
      DIMENSION XTEMP4(MAXOBV)
      DIMENSION XTEMP5(MAXOBV)
      DIMENSION XNTRIA(MAXOBV)
      DIMENSION XACLOW(MAXOBV)
      DIMENSION XACUPP(MAXOBV)
      DIMENSION ITEMP1(MAXOBV)
      DIMENSION ITEMP2(MAXOBV)
      DIMENSION ITEMP3(MAXOBV)
      DIMENSION ITEMP4(MAXOBV)
      DIMENSION ITEMP5(MAXOBV)
      DIMENSION ITEMP6(MAXOBV)
      DOUBLE PRECISION DTEMP1(MAXOBV)
      DOUBLE PRECISION DTEMP2(MAXOBV)
      DOUBLE PRECISION DTEMP3(MAXOBV)
CCCCC FOLLOWING LINES ADDED JUNE, 1990
      INCLUDE 'DPCOZZ.INC'
      INCLUDE 'DPCOZ2.INC'
      INCLUDE 'DPCOZI.INC'
      INCLUDE 'DPCOZD.INC'
      EQUIVALENCE (GARBAG(IGARB1),TEMP(1))
      EQUIVALENCE (GARBAG(IGARB2),TEMPZ(1))
      EQUIVALENCE (GARBAG(IGARB3),XTEMP1(1))
      EQUIVALENCE (GARBAG(IGARB4),XTEMP2(1))
      EQUIVALENCE (GARBAG(IGARB5),Z1(1))
      EQUIVALENCE (GARBAG(IGARB6),XTEMP3(1))
      EQUIVALENCE (GARBAG(IGARB7),XNTRIA(1))
      EQUIVALENCE (GARBAG(IGARB8),XACLOW(1))
      EQUIVALENCE (GARBAG(IGARB9),XACUPP(1))
      EQUIVALENCE (GARBAG(IGAR10),Z2(1))
      EQUIVALENCE (GARBAG(JGAR11),TEMPZ2(1))
      EQUIVALENCE (GARBAG(JGAR12),XH1DIS(1,1))
C
      EQUIVALENCE (G2RBAG(IGAR11),XDESGN(1,1))
C
      EQUIVALENCE (IGARBG(IIGAR1),ITEMP1(1))
      EQUIVALENCE (IGARBG(IIGAR2),ITEMP2(1))
      EQUIVALENCE (IGARBG(IIGAR3),ITEMP3(1))
      EQUIVALENCE (IGARBG(IIGAR4),ITEMP4(1))
      EQUIVALENCE (IGARBG(IIGAR5),ITEMP5(1))
      EQUIVALENCE (IGARBG(IIGAR6),ITEMP6(1))
C
      EQUIVALENCE (DGARBG(IDGAR1),DTEMP1(1))
      EQUIVALENCE (DGARBG(IDGAR2),DTEMP2(1))
      EQUIVALENCE (DGARBG(IDGAR3),DTEMP3(1))
C
CCCCC END CHANGE
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOSU.INC'
      INCLUDE 'DPCOHK.INC'
      INCLUDE 'DPCODA.INC'
      INCLUDE 'DPCOST.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IERROR='NO'
C
      ISUBN1='DPCR'
      ISUBN2='TA  '
C
      IYNAM=' '
      IXNAM=' '
      IXNAM2=' '
      IX1NAM=' '
      IX2NAM=' '
      IX3NAM=' '
      IX4NAM=' '
      IX5NAM=' '
      IX6NAM=' '
C
      MAXCP1=MAXCOL+1
      MAXCP2=MAXCOL+2
      MAXCP3=MAXCOL+3
      MAXCP4=MAXCOL+4
      MAXCP5=MAXCOL+5
      MAXCP6=MAXCOL+6
C
      MINN2=1
C
C               ******************************************
C               **  TREAT THE CROSS-TABULATION    CASE  **
C               ******************************************
C
      IF(IBUGA2.EQ.'ON' .OR. ISUBRO.EQ.'CRTA')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPCRTA--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)ICASCT
   52   FORMAT('ICASCT = ',A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,53)IBUGA2,IBUGA3,IBUGQ
   53   FORMAT('IBUGA2,IBUGA3,IBUGQ = ',A4,2X,A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               ***************************
C               **  STEP 1--             **
C               **  EXTRACT THE COMMAND  **
C               ***************************
C
      ISTEPN='1'
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'CRTA')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C               *******************************************************
C               **  STEP 1.5--                                       **
C               **  SEARCH FOR CROSS-TABULATE CHI-SQUARE             **
C               *******************************************************
C
      ICASCT='CSCT'
      IYVAR='ON'
      IXVAR='OFF'
      IX2VAR='OFF'
C
      IF(ICOM.EQ.'CROS' .AND. IHARG(1).EQ.'TABU')THEN
        JMIN=2
      ELSEIF(ICOM.EQ.'TABU')THEN
        JMIN=1
      ELSE
        IFOUND='NO'
        GOTO9000
      ENDIF
      JMAX=MIN(NUMARG,JMIN+6)
C
CCCCC MARCH 2009: USE "EXTSTA" TO PARSE.  NOTE THAT IF NO
CCCCC             STATISTIC IS GIVEN, WE ASSUME THE "COUNTS"
CCCCC             CASE.
C
      CALL EXTSTA(ICOM,ICOM2,IHARG,IHARG2,IARGT,ARG,NUMARG,JMIN,JMAX,
     1            ICASCT,ISTANM,ISTANR,ISTADF,IFOUND,ILOCV,
     1            ISUBRO,IBUGA3,IERROR)
C
      IF(IFOUND.EQ.'YES')THEN
        ICTNAM(1:40)=ISTANM(1:40)
        IYVAR='ON'
        IXVAR='OFF'
        IX2VAR='OFF'
        IF(ISTANR.GE.2)IXVAR='ON'
        IF(ISTANR.GE.3)IX2VAR='ON'
        IF(ICASCT.EQ.'NUMB')THEN
          IYVAR='OFF'
          ISTANR=0
        ENDIF
      ELSE
        ICASCT='NUMB'
        ICTNAM='NUMBER'
        IYVAR='OFF'
        IXVAR='OFF'
        IX2VAR='OFF'
        ISTANR=0
        IFOUND='YES'
        ILOCV=JMIN
      ENDIF
C
      ILASTC=ILOCV-1
      IF(ILASTC.GE.1)THEN
        CALL ADJUST(ILASTC,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG)
      ENDIF
C
C               ****************************************
C               **  STEP 2--                          **
C               **  EXTRACT THE VARIABLE LIST         **
C               ****************************************
C
      ISTEPN='2'
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'CRTA')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      INAME='CROSS TABULATE'
      MINNA=1
      MAXNA=100
      MINN2=1
      IFLAGE=1
      IFLAGM=0
      IFLAGP=0
      JMIN=1
      JMAX=NUMARG
      MINNVA=1
      MAXNVA=6 + ISTANR
C
      CALL DPPARS(IHARG,IHARG2,IARGT,ARG,NUMARG,IANS,IWIDTH,
     1            IHNAME,IHNAM2,IUSE,NUMNAM,IN,IVALUE,VALUE,
     1            JMIN,JMAX,
     1            MINN2,MINNA,MAXNA,MAXSPN,IFLAGE,INAME,
     1            IVARN1,IVARN2,IVARTY,PVAR,
     1            ILIS,NRIGHT,ICOLR,ISUB,NQ,ILOCQ,NUMVAR,
     1            MINNVA,MAXNVA,
     1            IFLAGM,IFLAGP,
     1            IBUGA3,IBUGQ,ISUBRO,IFOUND,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'CRTA')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,281)
  281   FORMAT('***** AFTER CALL DPPARS--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,282)NQ,NUMVAR
  282   FORMAT('NQ,NUMVAR = ',2I8)
        CALL DPWRST('XXX','BUG ')
        IF(NUMVAR.GT.0)THEN
          DO285I=1,NUMVAR
            WRITE(ICOUT,287)I,IVARN1(I),IVARN2(I),ILIS(I),NRIGHT(I),
     1                      ICOLR(I)
  287       FORMAT('I,IVARN1(I),IVARN2(I),ILIS(I),NRIGHT(I),',
     1             'ICOLR(I) = ',I8,2X,A4,A4,2X,3I8)
            CALL DPWRST('XXX','BUG ')
  285     CONTINUE
        ENDIF
      ENDIF
C
C               ****************************************
C               **  STEP 3--                          **
C               **  EXTRACT THE DATA                  **
C               ****************************************
C
      NRESP=ISTANR
      NCRTV=NUMVAR-NRESP
      IF(NCRTV.LT.1 .OR. NCRTV.GT.6)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,301)
  301   FORMAT('****** ERROR IN CROSS TABULATE--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,302)
  302   FORMAT('       THE NUMBER OF GROUP-ID VARIABLES IS LESS THAN')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,303)
  303   FORMAT('       OR GREATER THAN SIX.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,304)NGROUP
  304   FORMAT('       THE NUMBER OF GROUP-ID VARIABLES   = ',I5)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,305)NRESP
  305   FORMAT('       THE NUMBER OF RESPONSE VARIABLES   = ',I5)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
 2650 CONTINUE
      J=0
      DO2660I=1,NRIGHT(1)
        ICOLH=0
        IF(ISUB(I).EQ.0)GOTO2660
        J=J+1
C
        IF(NRESP.GE.1)THEN
          ICOLH=ICOLH+1
          IJ=MAXN*(ICOLR(ICOLH)-1)+I
          IF(ICOLR(ICOLH).LE.MAXCOL)Y1(J)=V(IJ)
          IF(ICOLR(ICOLH).EQ.MAXCP1)Y1(J)=PRED(I)
          IF(ICOLR(ICOLH).EQ.MAXCP2)Y1(J)=RES(I)
          IF(ICOLR(ICOLH).EQ.MAXCP3)Y1(J)=YPLOT(I)
          IF(ICOLR(ICOLH).EQ.MAXCP4)Y1(J)=XPLOT(I)
          IF(ICOLR(ICOLH).EQ.MAXCP5)Y1(J)=X2PLOT(I)
          IF(ICOLR(ICOLH).EQ.MAXCP6)Y1(J)=TAGPLO(I)
        ELSE
          Y1(J)=0.0
        ENDIF
C
        IF(NRESP.GE.2)THEN
          ICOLH=ICOLH+1
          IJ=MAXN*(ICOLR(ICOLH)-1)+I
          IF(ICOLR(ICOLH).LE.MAXCOL)Z1(J)=V(IJ)
          IF(ICOLR(ICOLH).EQ.MAXCP1)Z1(J)=PRED(I)
          IF(ICOLR(ICOLH).EQ.MAXCP2)Z1(J)=RES(I)
          IF(ICOLR(ICOLH).EQ.MAXCP3)Z1(J)=YPLOT(I)
          IF(ICOLR(ICOLH).EQ.MAXCP4)Z1(J)=XPLOT(I)
          IF(ICOLR(ICOLH).EQ.MAXCP5)Z1(J)=X2PLOT(I)
          IF(ICOLR(ICOLH).EQ.MAXCP6)Z1(J)=TAGPLO(I)
        ELSE
          Z1(J)=0.0
        ENDIF
C
        IF(NRESP.GE.3)THEN
          ICOLH=ICOLH+1
          IJ=MAXN*(ICOLR(ICOLH)-1)+I
          IF(ICOLR(ICOLH).LE.MAXCOL)Z2(J)=V(IJ)
          IF(ICOLR(ICOLH).EQ.MAXCP1)Z2(J)=PRED(I)
          IF(ICOLR(ICOLH).EQ.MAXCP2)Z2(J)=RES(I)
          IF(ICOLR(ICOLH).EQ.MAXCP3)Z2(J)=YPLOT(I)
          IF(ICOLR(ICOLH).EQ.MAXCP4)Z2(J)=XPLOT(I)
          IF(ICOLR(ICOLH).EQ.MAXCP5)Z2(J)=X2PLOT(I)
          IF(ICOLR(ICOLH).EQ.MAXCP6)Z2(J)=TAGPLO(I)
        ELSE
          Z2(J)=0.0
        ENDIF
C
        DO2670K=1,NCRTV
          ICOLH=ICOLH+1
          IJ=MAXN*(ICOLR(ICOLH)-1)+I
          IF(ICOLH.LE.MAXCOL)XDESGN(J,K)=V(IJ)
          IF(ICOLH.EQ.MAXCP1)XDESGN(J,K)=PRED(I)
          IF(ICOLH.EQ.MAXCP2)XDESGN(J,K)=RES(I)
          IF(ICOLH.EQ.MAXCP3)XDESGN(J,K)=YPLOT(I)
          IF(ICOLH.EQ.MAXCP4)XDESGN(J,K)=XPLOT(I)
          IF(ICOLH.EQ.MAXCP5)XDESGN(J,K)=X2PLOT(I)
          IF(ICOLH.EQ.MAXCP6)XDESGN(J,K)=TAGPLO(I)
 2670   CONTINUE
C
 2660 CONTINUE
      NLOCAL=J
C
      ICNT=0
      IF(NRESP.GE.1)THEN
        ICNT=ICNT+1
        IYNAM(1:4)=IVARN1(ICNT)(1:4)
        IYNAM(5:8)=IVARN2(ICNT)(1:4)
      ENDIF
      IF(NRESP.GE.2)THEN
        ICNT=ICNT+1
        IXNAM(1:4)=IVARN1(ICNT)(1:4)
        IXNAM(5:8)=IVARN2(ICNT)(1:4)
      ENDIF
      IF(NRESP.GE.3)THEN
        ICNT=ICNT+1
        IXNAM2(1:4)=IVARN1(ICNT)(1:4)
        IXNAM2(5:8)=IVARN2(ICNT)(1:4)
      ENDIF
      IF(NCRTV.GE.1)THEN
        ICNT=ICNT+1
        IX1NAM(1:4)=IVARN1(ICNT)(1:4)
        IX1NAM(5:8)=IVARN2(ICNT)(1:4)
      ENDIF
      IF(NCRTV.GE.2)THEN
        ICNT=ICNT+1
        IX2NAM(1:4)=IVARN1(ICNT)(1:4)
        IX2NAM(5:8)=IVARN2(ICNT)(1:4)
      ENDIF
      IF(NCRTV.GE.3)THEN
        ICNT=ICNT+1
        IX3NAM(1:4)=IVARN1(ICNT)(1:4)
        IX3NAM(5:8)=IVARN2(ICNT)(1:4)
      ENDIF
      IF(NCRTV.GE.4)THEN
        ICNT=ICNT+1
        IX4NAM(1:4)=IVARN1(ICNT)(1:4)
        IX4NAM(5:8)=IVARN2(ICNT)(1:4)
      ENDIF
      IF(NCRTV.GE.5)THEN
        ICNT=ICNT+1
        IX5NAM(1:4)=IVARN1(ICNT)(1:4)
        IX5NAM(5:8)=IVARN2(ICNT)(1:4)
      ENDIF
      IF(NCRTV.GE.6)THEN
        ICNT=ICNT+1
        IX6NAM(1:4)=IVARN1(ICNT)(1:4)
        IX6NAM(5:8)=IVARN2(ICNT)(1:4)
      ENDIF
C
      IF(NLOCAL.LE.0)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,301)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2710)
 2710   FORMAT('      AFTER EXTRACTING THE SUBSET, THERE ARE NO')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2712)
 2712   FORMAT('      OBSERVATIONS REMAINING ON WHICH TO PERFORM')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2714)
 2714   FORMAT('      THE RELEVANT CROSS-TABULATION.')
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
C               *****************************************************
C               **  STEP 8--                                       **
C               **  COMPUTE THE APPROPRIATE CROSS-TABULATION       **
C               **  STATISTIC--                                    **
C               **  (MEAN, STANDARD DEVIATION, RANGE, OR COUNT).   **
C               *****************************************************
C
      ISTEPN='8'
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'CRTA')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(ICASCT.EQ.'BPRO' .OR. ICASCT.EQ.'MECL' .OR.
     1   ICASCT.EQ.'MDCL' .OR. ICASCT.EQ.'BRAT')THEN
        IHP='ALPH'
        IHP2='A   '
        IHWUSE='P'
        MESSAG='NO'
        CALL CHECKN(IHP,IHP2,IHWUSE,
     1              IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,
     1              NUMNAM,MAXNAM,
     1              ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,
     1              ILOCP,IERROR)
        IF(IERROR.EQ.'YES')THEN
          ALPHA=0.95
        ELSE
          ALPHA=VALUE(ILOCP)
          IF(ALPHA.GE.1.0 .AND. ALPHA.LE.100.0)ALPHA=ALPHA/100.
          IF(ALPHA.LE.0.0 .OR. ALPHA.GE.1.0)ALPHA=0.95
          IF(ALPHA.LT.0.5)ALPHA=1.0 - ALPHA
          IF(IBINTA.EQ.'LOWE' .OR. IBINTA.EQ.'UPPE')THEN
            ATEMP=1.0 - ALPHA
            ATEMP=2.0*ATEMP
            ALPHA=1.0 - ATEMP
          ENDIF
        ENDIF
      ELSE
        ALPHA=0.05
      ENDIF
C
      CALL DPCRT2(Y1,Z1,Z2,XDESGN,NLOCAL,MAXGR9,
     1            NUMVAR,ICASCT,ICTNAM,
     1            XH1DIS,
     1            TEMP,TEMPZ,TEMPZ2,XTEMP1,XTEMP2,XTEMP3,
     1            XNTRIA,XACLOW,XACUPP,
     1            ITEMP1,ITEMP2,ITEMP3,ITEMP4,ITEMP5,ITEMP6,
     1            DTEMP1,DTEMP2,DTEMP3,
     1            ISEED,IQUAME,IQUASE,PSTAMV,ALPHA,
     1            IXVAR,IX2VAR,IYVAR,
     1            IYNAM,IXNAM,IXNAM2,
     1            IX1NAM,IX2NAM,IX3NAM,IX4NAM,IX5NAM,IX6NAM,
     1            ICAPSW,ICAPTY,IFORSW,NCRTV,MAXOBV,
     1            Y,X,D,DSIZE,DFILL,DCOLOR,DSYMB,NPLOTP,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA2.EQ.'ON' .OR. ISUBRO.EQ.'CRTA')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPCRTA--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)IFOUND,IERROR
 9012   FORMAT('IFOUND,IERROR = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)NPLOTP,NS,ICASCT
 9013   FORMAT('NPLOTP,NS,ICASCT = ',I8,I8,2X,A4)
        CALL DPWRST('XXX','BUG ')
        IF(NPLOTP.GT.0)THEN
          DO9015I=1,MIN(200,NPLOTP)
          WRITE(ICOUT,9016)I,Y(I),X(I),D(I)
 9016     FORMAT('I,Y(I),X(I),D(I) = ',I8,3F12.5)
          CALL DPWRST('XXX','BUG ')
 9015     CONTINUE
        ENDIF
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPCRT2(Y,Z,Z2,TAG,N,MAXGRP,
     1                  NUMV2,ICASCT,ICTNAM,
     1                  XIDTEM,
     1                  TEMP,TEMPZ,TEMPZ2,XTEMP1,XTEMP2,XTEMP3,
     1                  XNTRIA,XACLOW,XACUPP,
     1                  ITEMP1,ITEMP2,ITEMP3,ITEMP4,ITEMP5,ITEMP6,
     1                  DTEMP1,DTEMP2,DTEMP3,
     1                  ISEED,IQUAME,IQUASE,PSTAMV,ALPHA,
     1                  IXVAR,IX2VAR,IYVAR,
     1                  IYNAM,IXNAM,IXNAM2,
     1                  IX1NAM,IX2NAM,IX3NAM,IX4NAM,IX5NAM,IX6NAM,
     1                  ICAPSW,ICAPTY,IFORSW,NCRTV,MAXNXT,
     1                  Y2,X2,D2,DSIZE,DFILL,DCOLOR,DSYMB,
     1                  N2,ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--GENERATE A PAIR OF COORDINATE VECTORS
C              THAT WILL DEFINE A CROSS-TABULATION
C              OF THE FOLLOWING TYPES--
C                 1) MEAN CROSS-TABULATION;
C                 2) STANDARD DEVIATION CROSS-TABULATION;
C                 3) RANGE CROSS-TABULATION;
C                 4) COUNT CROSS-TABULATION.
C                 5) SUM CROSS-TABULATION`
C                 6) CHI-SQUARE ANALYSIS CROSS_TABULATION
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     REFERENCE--ASTM MANUAL STP-15D, PAGES 78-84, 100-105
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--JUNE      1978.
C     UPDATED         --OCTOBER   1978.
C     UPDATED         --JANUARY   1981.
C     UPDATED         --DECEMBER  1981.
C     UPDATED         --APRIL     1982.
C     UPDATED         --MAY       1982.
C     UPDATED         --NOVEMBER  1989.  COMMENT OUT CHECK OF NUMSET=N
C     UPDATED         --DECEMBEDR 1989.  FIX CROSS-TAB X1 X2
C     UPDATED         --OCTOBER   1992.  SUPPRESS ERROR MESSAGE FOR
C                                        ZERO COUNT CELLS.
C                                        ADD SUM AND CHI-SQUARE OPTIONS
C     UPDATED         --MARCH     1994.  FIX CROSS TABU SUM CASE
C     UPDATED         --MARCH     1994.  MODIFY CROSS TABU CHI-SQUARE
C                                        OUTPUT
C     UPDATED         --DECEMBER  1998.  WRITE OUTPUT TO FILE
C     UPDATED         --AUGUST    2002.  USE CMPSTA TO COMPUTE THE
C                                        STATISTICS
C     UPDATED         --AUGUST    2002.  GREATLY EXPAND LIST OF
C                                        SUPPORTED STATISICS
C     UPDATED         --AUGUST    2002.  SUPPORT FOR HTML OUTPUT
C     UPDATED         --APRIL     2003.  ADD SN AND QN (AND DIFFERENCE
C                                        OF), REQUIRED ADDITIONAL
C                                        SCRATCH ARAYS
C     UPDATED         --OCTOBER   2003.  SUPPORT FOR LATEX OUTPUT
C     UPDATED         --APRIL     2008.  SUPPORT FOR RTF OUTPUT
C     UPDATED         --APRIL     2008.  SUPPORT FOR 3, 4, 5, OR 6
C                                        CROSS-TABULATION VARIABLES
C     UPDATED         --APRIL     2008.  "BINOMIAL PROBABILITY" OPTION
C                                        (THIS RECIEVES SPECIAL
C                                        HANDLING)
C     UPDATED         --AUGUST    2008.  FIXED SOME BUGS
C     UPDATED         --JUNE      2010.  CALL LIST TO CMPSTA
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICASCT
      CHARACTER*40 ICTNAM
      CHARACTER*4 IXVAR
      CHARACTER*4 IX2VAR
      CHARACTER*4 IYVAR
      CHARACTER*4 IQUAME
      CHARACTER*4 IQUASE
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*80 ITABTI
      CHARACTER*4 ITABBR
      CHARACTER*1 IBASLC
C
      CHARACTER*8 IYNAM
      CHARACTER*8 IXNAM
      CHARACTER*8 IXNAM2
      CHARACTER*8 IX1NAM
      CHARACTER*8 IX2NAM
      CHARACTER*8 IX3NAM
      CHARACTER*8 IX4NAM
      CHARACTER*8 IX5NAM
      CHARACTER*8 IX6NAM
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IWRITE
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
CCCCC ADD FOLLOWING 2 LINES.  MARCH 1994.
      CHARACTER*10 ICONC1
      CHARACTER*10 ICONC2
C
      CHARACTER*4 ISUBN0
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION Z(*)
      DIMENSION Z2(*)
      DIMENSION XIDTEM(MAXNXT,MAXGRP)
      DIMENSION Y2(*)
      DIMENSION X2(*)
      DIMENSION D2(*)
      DIMENSION DSIZE(*)
      DIMENSION DFILL(*)
      DIMENSION DCOLOR(*)
      DIMENSION DSYMB(*)
C
      DIMENSION TAG(MAXNXT,MAXGRP)
      DIMENSION TEMP(*)
      DIMENSION TEMPZ(*)
      DIMENSION TEMPZ2(*)
      DIMENSION XTEMP1(*)
      DIMENSION XTEMP2(*)
      DIMENSION XTEMP3(*)
      DIMENSION XNTRIA(*)
      DIMENSION XACLOW(*)
      DIMENSION XACUPP(*)
C
      INTEGER ITEMP1(*)
      INTEGER ITEMP2(*)
      INTEGER ITEMP3(*)
      INTEGER ITEMP4(*)
      INTEGER ITEMP5(*)
      INTEGER ITEMP6(*)
C
      INTEGER NUMSET(6)
C
      DOUBLE PRECISION DTEMP1(*)
      DOUBLE PRECISION DTEMP2(*)
      DOUBLE PRECISION DTEMP3(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPCR'
      ISUBN2='T2  '
C
      I2=0
C
      AN=0.0
      YUPPER=0.0
      YLOWER=0.0
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(N.LT.1)THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,31)
   31   FORMAT('***** ERROR IN CROSS-TABULATE--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,32)
   32   FORMAT('      THE NUMBER OF OBSERVATIONS MUST BE AT LEAST 1.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,34)N
   34   FORMAT('      THE ENTERED NUMBER OF OBSERVATIONS HERE = ',I6)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
CCCCC MAY 2008: DO NOT TREAT FOLLOWING AS AN ERROR.
CCCCC           PRINT A WARNING, BUT CONTINUE TO PROCESS.
CCCCC
CCCCC           WHEN CROSS-TABBING MULTIPLE VARIABLES, CAN
CCCCC           GET A LOT OF ERROR MESSAGES DUE TO CLASSES
CCCCC           WITH SMALL NUMBER OF ELEMENTS.  SO DO NOT
CCCCC           PRINT WARNING MESSAGE.
C
CCCCC IF(IYVAR.EQ.'ON')THEN
CCCCC   HOLD=Y(1)
CCCCC   DO60I=1,N
CCCCC     IF(Y(I).NE.HOLD)GOTO69
CCC60   CONTINUE
CCCCC   WRITE(ICOUT,999)
CCCCC   CALL DPWRST('XXX','BUG ')
CCCCC   WRITE(ICOUT,61)
CCC61   FORMAT('***** WARNING IN CROSS-TABULATE--')
CCCCC   CALL DPWRST('XXX','BUG ')
CCCCC   WRITE(ICOUT,62)
CCC62   FORMAT('      ALL RESPONSE VARIABLE ELEMENTS')
CCCCC   CALL DPWRST('XXX','BUG ')
CCCCC   WRITE(ICOUT,63)HOLD
CCC63   FORMAT('      ARE IDENTICALLY EQUAL TO ',G15.7)
CCCCC   CALL DPWRST('XXX','BUG ')
CCCCC   WRITE(ICOUT,999)
CCCCC   CALL DPWRST('XXX','BUG ')
CCC69   CONTINUE
CCCCC ENDIF
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'CRT2')THEN
        WRITE(ICOUT,70)
   70   FORMAT('AT THE BEGINNING OF DPCRT2--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,71)N,ICASCT,NUMV2,NCRTV
   71   FORMAT('N,ICASCT,NUMV2,NCRTV = ',I8,2X,A4,I8,2X,I5)
        CALL DPWRST('XXX','BUG ')
        DO72I=1,N
          WRITE(ICOUT,73)I,Y(I),Z(I),Z2(I),(TAG(I,J),J=1,MAXGRP)
   73     FORMAT('I,Y(I),Z(I),Z2(I),TAG1-6(I) = ',I8,10F10.3)
          CALL DPWRST('XXX','BUG ')
   72   CONTINUE
      ENDIF
C
C               ******************************************************
C               **  STEP 1--                                        **
C               **  DETERMINE THE NUMBER OF DISTINCT VALUES         **
C               **  FOR THE GROUP VARIABLES (TAG1, TAG2)            **
C               **  IF ALL VALUES ARE DISTINCT, THEN THIS           **
C               **  IMPLIES WE HAVE THE NO REPLICATION CASE         **
C               **  WHICH IS AN ERROR CONDITION FOR A PLOT.         **
C               ******************************************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CRT2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      DO100J=1,MAXGRP
        NUMSET(J)=0
  100 CONTINUE
C
      DO110J=1,NCRTV
        CALL DISTIN(TAG(1,J),N,IWRITE,XIDTEM(1,J),NUMSET(J),
     1              IBUGA3,IERROR)
        CALL SORT(XIDTEM(1,J),NUMSET(J),TEMP)
        DO120I=1,NUMSET(J)
          XIDTEM(I,J)=TEMP(I)
  120   CONTINUE
        IF(NUMSET(J).LT.1 .OR. NUMSET(J).GT.N)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,31)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,111)J,NUMSET(J)
  111     FORMAT('      THE NUMBER OF SETS FOR THE GROUP ',I1,
     1           ' VARIABLE, ',I8,',')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,113)
  113     FORMAT('      IS EITHER LESS THAN ONE OR GREATER THAN THE ',
     1           'NUMBER')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,115)N
  115     FORMAT('      OF OBSERVATIONS, ',I8,'.')
          CALL DPWRST('XXX','BUG ')
          IERROR='YES'
          GOTO9000
        ENDIF
  110 CONTINUE
C
      AN=N
      ANUMS1=NUMSET(1)
      ANUMS2=NUMSET(2)
      ANUMS3=NUMSET(3)
      ANUMS4=NUMSET(4)
      ANUMS5=NUMSET(5)
      ANUMS6=NUMSET(6)
C
C               ***********************************************
C               **  STEP 5--                                 **
C               **  COMPUTE THE VARIOUS CROSS-TAB STATISTICS **
C               ***********************************************
C
      ISTEPN='5.1'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CRT2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IWRITE='OFF'
C
      IF(NCRTV.EQ.1)THEN
        CALL DPCRT0(Y,Z,Z2,TAG,N,
     1              NUMV2,ICASCT,ICTNAM,
     1              XIDTEM(1,1),
     1              NUMSET(1),
     1              TEMP,TEMPZ,TEMPZ2,XTEMP1,XTEMP2,XTEMP3,
     1              XNTRIA,XACLOW,XACUPP,
     1              ITEMP1,ITEMP2,ITEMP3,ITEMP4,ITEMP5,ITEMP6,
     1              DTEMP1,DTEMP2,DTEMP3,
     1              ISEED,ALPHA,
     1              IXVAR,IX2VAR,IYVAR,
     1              IYNAM,IXNAM,IXNAM2,IX1NAM,
     1              ICAPSW,ICAPTY,IFORSW,
     1              MAXNXT,
     1              Y2,X2,N2,ISUBRO,IBUGA3,IERROR)
      ELSEIF(NCRTV.EQ.2)THEN
        CALL DPCRT3(Y,Z,Z2,TAG(1,1),TAG(1,2),N,
     1              NUMV2,ICASCT,ICTNAM,
     1              XIDTEM(1,1),XIDTEM(1,2),
     1              NUMSET(1),NUMSET(2),
     1              TEMP,TEMPZ,TEMPZ2,XTEMP1,XTEMP2,XTEMP3,
     1              XNTRIA,XACLOW,XACUPP,
     1              ITEMP1,ITEMP2,ITEMP3,ITEMP4,ITEMP5,ITEMP6,
     1              DTEMP1,DTEMP2,DTEMP3,
     1              ISEED,ALPHA,
     1              IXVAR,IX2VAR,IYVAR,
     1              IYNAM,IXNAM,IXNAM2,
     1              IX1NAM,IX2NAM,IX3NAM,IX4NAM,IX5NAM,
     1              ICAPSW,ICAPTY,IFORSW,
     1              MAXNXT,
     1              Y2,X2,D2,N2,ISUBRO,IBUGA3,IERROR)
      ELSEIF(NCRTV.EQ.3)THEN
        CALL DPCRT4(Y,Z,Z2,TAG(1,1),TAG(1,2),TAG(1,3),N,
     1              NUMV2,ICASCT,ICTNAM,
     1              XIDTEM(1,1),XIDTEM(1,2),XIDTEM(1,3),
     1              NUMSET(1),NUMSET(2),NUMSET(3),
     1              TEMP,TEMPZ,TEMPZ2,XTEMP1,XTEMP2,XTEMP3,
     1              XNTRIA,XACLOW,XACUPP,
     1              ITEMP1,ITEMP2,ITEMP3,ITEMP4,ITEMP5,ITEMP6,
     1              DTEMP1,DTEMP2,DTEMP3,
     1              ISEED,ALPHA,
     1              IXVAR,IX2VAR,IYVAR,
     1              IYNAM,IXNAM,IXNAM2,
     1              IX1NAM,IX2NAM,IX3NAM,IX4NAM,IX5NAM,
     1              ICAPSW,ICAPTY,IFORSW,
     1              MAXNXT,
     1              Y2,X2,D2,DSIZE,N2,ISUBRO,IBUGA3,IERROR)
      ELSEIF(NCRTV.EQ.4)THEN
        CALL DPCRT5(Y,Z,Z2,TAG(1,1),TAG(1,2),TAG(1,3),TAG(1,4),N,
     1              NUMV2,ICASCT,ICTNAM,
     1              XIDTEM(1,1),XIDTEM(1,2),XIDTEM(1,3),XIDTEM(1,4),
     1              NUMSET(1),NUMSET(2),NUMSET(3),NUMSET(4),
     1              TEMP,TEMPZ,TEMPZ2,XTEMP1,XTEMP2,XTEMP3,
     1              XNTRIA,XACLOW,XACUPP,
     1              ITEMP1,ITEMP2,ITEMP3,ITEMP4,ITEMP5,ITEMP6,
     1              DTEMP1,DTEMP2,DTEMP3,
     1              ISEED,ALPHA,
     1              IXVAR,IX2VAR,IYVAR,
     1              IYNAM,IXNAM,IXNAM2,
     1              IX1NAM,IX2NAM,IX3NAM,IX4NAM,IX5NAM,
     1              ICAPSW,ICAPTY,IFORSW,
     1              MAXNXT,
     1              Y2,X2,D2,DSIZE,DCOLOR,N2,ISUBRO,IBUGA3,IERROR)
      ELSEIF(NCRTV.EQ.5)THEN
        CALL DPCRT6(Y,Z,Z2,TAG(1,1),TAG(1,2),TAG(1,3),
     1              TAG(1,4),TAG(1,5),N,
     1              NUMV2,ICASCT,ICTNAM,
     1              XIDTEM(1,1),XIDTEM(1,2),XIDTEM(1,3),
     1              XIDTEM(1,4),XIDTEM(1,5),
     1              NUMSET(1),NUMSET(2),NUMSET(3),
     1              NUMSET(4),NUMSET(5),
     1              TEMP,TEMPZ,TEMPZ2,XTEMP1,XTEMP2,XTEMP3,
     1              XNTRIA,XACLOW,XACUPP,
     1              ITEMP1,ITEMP2,ITEMP3,ITEMP4,ITEMP5,ITEMP6,
     1              DTEMP1,DTEMP2,DTEMP3,
     1              ISEED,ALPHA,
     1              IXVAR,IX2VAR,IYVAR,
     1              IYNAM,IXNAM,IXNAM2,
     1              IX1NAM,IX2NAM,IX3NAM,IX4NAM,IX5NAM,
     1              ICAPSW,ICAPTY,IFORSW,
     1              MAXNXT,
     1              Y2,X2,D2,DSIZE,DCOLOR,DFILL,N2,
     1              ISUBRO,IBUGA3,IERROR)
      ELSEIF(NCRTV.EQ.6)THEN
        CALL DPCRT7(Y,Z,Z2,TAG(1,1),TAG(1,2),TAG(1,3),TAG(1,4),
     1              TAG(1,5),TAG(1,6),N,
     1              NUMV2,ICASCT,ICTNAM,
     1              XIDTEM(1,1),XIDTEM(1,2),XIDTEM(1,3),
     1              XIDTEM(1,4),XIDTEM(1,5),XIDTEM(1,6),
     1              NUMSET(1),NUMSET(2),NUMSET(3),
     1              NUMSET(4),NUMSET(5),NUMSET(6),
     1              TEMP,TEMPZ,TEMPZ2,XTEMP1,XTEMP2,XTEMP3,
     1              XNTRIA,XACLOW,XACUPP,
     1              ITEMP1,ITEMP2,ITEMP3,ITEMP4,ITEMP5,ITEMP6,
     1              DTEMP1,DTEMP2,DTEMP3,
     1              ISEED,ALPHA,
     1              IXVAR,IX2VAR,IYVAR,
     1              IYNAM,IXNAM,IXNAM2,
     1              IX1NAM,IX2NAM,IX3NAM,IX4NAM,IX5NAM,
     1              IX6NAM,
     1              ICAPSW,ICAPTY,IFORSW,
     1              MAXNXT,
     1              Y2,X2,D2,DSIZE,DCOLOR,DFILL,DSYMB,N2,
     1              ISUBRO,IBUGA3,IERROR)
      ENDIF
C
C               ******************
C               **   STEP 90--  **
C               **   EXIT       **
C               ******************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'CRT2')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPCRT2--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)ICASCT,N,N2,NUMV2,IERROR
 9012   FORMAT('ICASCT,N,N2,NUMV2,IERROR = ',A4,3I8,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9015)NUMSET(1),NUMSET(2),N2
 9015   FORMAT('NUMSET(1),NUMSET(2),N2 = ',3I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9016)ANUMS1,ANUMS2
 9016   FORMAT('ANUMS1,ANUMS2 = ',2E15.7)
        CALL DPWRST('XXX','BUG ')
        DO9020I=1,N2
          WRITE(ICOUT,9021)I,Y2(I),X2(I)
 9021     FORMAT('I,Y2(I),X2(I) = ',I8,2E15.7)
          CALL DPWRST('XXX','BUG ')
 9020   CONTINUE
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPCRT3(Y,Z,Z2,TAG1,TAG2,N,
     1                  NUMV2,ICASCT,ICTNAM,
     1                  XIDTEM,XIDTE2,
     1                  NUMSE1,NUMSE2,
     1                  TEMP,TEMPZ,TEMPZ2,XTEMP1,XTEMP2,XTEMP3,
     1                  XNTRIA,XACLOW,XACUPP,
     1                  ITEMP1,ITEMP2,ITEMP3,ITEMP4,ITEMP5,ITEMP6,
     1                  DTEMP1,DTEMP2,DTEMP3,
     1                  ISEED,ALPHA,
     1                  IXVAR,IX2VAR,IYVAR,
     1                  IYNAM,IXNAM,IXNAM2,
     1                  IX1NAM,IX2NAM,IX3NAM,IX4NAM,IX5NAM,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  MAXNXT,
     1                  Y2,X2,D2,N2,ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--GENERATE A TWO-WAY CROSS-TABULATION AND
C              OPTIONALLY PRINT THE RESULTS TO AN ASCII,
C              HTML, LATEX, OR RTF TABLE.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     REFERENCE--ASTM MANUAL STP-15D, PAGES 78-84, 100-105
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2008/4
C     ORIGINAL VERSION--APRIL     2008. SPLIT OFF FROM DPCRT2 ROUTINE
C     UPDATED         --SEPTEMBER 2008. ACCOMODATE "MISSING" DATA
C     UPDATED         --JANUARY   2010. TREAT BINOMIAL RATIO IN A
C                                       SIMILAR FASHION TO BINOMIAL
C                                       PROBABILITY
C     UPDATED         --JUNE      2010. CALL LIST TO CMPSTA
C     UPDATED         --JUNE      2010. USE DPDTA5 TO PRINT TABLE
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICASCT
      CHARACTER*40 ICTNAM
      CHARACTER*50 ICTEMP
      CHARACTER*60 ICTMP2
      CHARACTER*4 IXVAR
      CHARACTER*4 IX2VAR
      CHARACTER*4 IYVAR
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      PARAMETER(NUMCLI=7)
      PARAMETER(MAXLIN=2)
      PARAMETER (MAXROW=30)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*60 ITITL9
      CHARACTER*60 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(NUMCLI)
      CHARACTER*4  VALIGN(NUMCLI)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      CHARACTER*60 ITITL2(MAXLIN,NUMCLI)
      CHARACTER*15 IVALUE(MAXROW,NUMCLI)
      CHARACTER*4  ITYPCO(NUMCLI)
      INTEGER      NCTIT2(MAXLIN,NUMCLI)
      INTEGER      NCVALU(MAXROW,NUMCLI)
      INTEGER      IWHTML(NUMCLI)
      INTEGER      IWRTF(NUMCLI)
      REAL         AMAT(MAXROW,NUMCLI)
      LOGICAL IFRST
      LOGICAL ILAST
      LOGICAL IFLAG1
      LOGICAL IFLAG2
      LOGICAL IFLAG3
      LOGICAL IFLAGS
      LOGICAL IFLAGE
C
      CHARACTER*8 IYNAM
      CHARACTER*8 IXNAM
      CHARACTER*8 IXNAM2
      CHARACTER*8 IX1NAM
      CHARACTER*8 IX2NAM
      CHARACTER*8 IX3NAM
      CHARACTER*8 IX4NAM
      CHARACTER*8 IX5NAM
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IWRITE
      CHARACTER*4 IBFLAG
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*10 ICONC1
      CHARACTER*10 ICONC2
C
      CHARACTER*4 ISUBN0
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION Z(*)
      DIMENSION Z2(*)
      DIMENSION XIDTEM(*)
      DIMENSION XIDTE2(*)
      DIMENSION Y2(*)
      DIMENSION X2(*)
      DIMENSION D2(*)
C
      DIMENSION TAG1(*)
      DIMENSION TAG2(*)
      DIMENSION TEMP(*)
      DIMENSION TEMPZ(*)
      DIMENSION TEMPZ2(*)
      DIMENSION XTEMP1(*)
      DIMENSION XTEMP2(*)
      DIMENSION XTEMP3(*)
      DIMENSION XNTRIA(*)
      DIMENSION XACLOW(*)
      DIMENSION XACUPP(*)
C
      INTEGER ITEMP1(*)
      INTEGER ITEMP2(*)
      INTEGER ITEMP3(*)
      INTEGER ITEMP4(*)
      INTEGER ITEMP5(*)
      INTEGER ITEMP6(*)
C
      DOUBLE PRECISION DTEMP1(*)
      DOUBLE PRECISION DTEMP2(*)
      DOUBLE PRECISION DTEMP3(*)
C
      CHARACTER*4 IOP
C
      INCLUDE 'DPCOST.INC'
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPCR'
      ISUBN2='T3  '
C
      I2=0
C
      AN=INT(N+0.01)
      ANUMS1=INT(NUMSE1+0.01)
      ANUMS2=INT(NUMSE2+0.01)
C
C               ***********************************************
C               **  STEP 5--                                 **
C               **  COMPUTE THE VARIOUS CROSS-TAB STATISTICS **
C               ***********************************************
C
      ISTEPN='5.1'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CRT3')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     ALLOW THE   SET WRITE DECIMALS COMMAND    TO BE USED TO
C     DETERMINE HOW MANY DIGITS PRINTED IN TABLE.
C
      NUMDIG=-7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=10
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
C     NOTE 9/2008: IN FOLLOWING, WE NEED TO DISTINGUISH BETWEEN
C                  EMPTY SETS DUE TO NO POINTS FALLING IN THE
C                  PARTICULAR CROSS TABULATION (IN WHICH CASE,
C                  WE WANT TO SKIP IN THE OUTPUT FILE) AND EMPTY
C                  SETS DUE TO ALL POINTS IN THE PARTICULAR
C                  CROSS TABULATION BEING MISSING (IN WHICH CASE,
C                  WE MAY WANT TO WRITE A 0 OR A MISSING VALUE).
C
C                  THERE ARE 2 MISSING VALUES:
C
C                  PSTAMV   - SPECIFIES WHETHER THE INPUT DATA
C                             VALUE IS TO BE INCLUDED IN THE
C                             COMPUTATION OF THE STATISTIC
C
C                  PCTAMV    - IF ALL THE DATA IS MISSING, THIS
C                              IS THE VALUE TO USE IN WRITING THE
C                              CROSS TABULATE OUTPUT.
C
      IWRITE='OFF'
      IBFLAG=ICASCT
      IF(IBFLAG.EQ.'BRAT')IBFLAG='BPRO'
C
      EPS=0.1E-7
      J=0
      NRESP=NUMV2-2
      DO1110ISET1=1,NUMSE1
        DO1120ISET2=1,NUMSE2
C
          K=0
          NTEMP2=0
          DO1130I=1,N
            IF(XIDTEM(ISET1).EQ.TAG1(I).AND.XIDTE2(ISET2).EQ.TAG2(I))
     1        GOTO1131
            GOTO1130
 1131       CONTINUE
C
            NTEMP2=NTEMP2+1
            IF(IYVAR.EQ.'OFF')THEN
              K=K+1
              TEMP(K)=0.0
            ELSE
              IF(ABS(Y(I)-PSTAMV).GT.EPS)THEN
                K=K+1
                TEMP(K)=Y(I)
                IF(IXVAR.EQ.'ON')TEMPZ(K)=Z(I)
                IF(IX2VAR.EQ.'ON')TEMPZ2(K)=Z2(I)
              ENDIF
            ENDIF
 1130     CONTINUE
          NTEMP=K
C
C         AUGUST 2002.  CALL CMPSTA (EXCEPT FOR CHI-SQUARE CASE)
C
C         NTEMP2 IS THE NUMBER OF POINTS IN THE SUBSET AND
C         NTEMP IS THE NUMBER OF NON-MISSING POINTS IN THE SUBSET.
C
          IF(NTEMP2.EQ.0)GOTO1129
C
          IF(NTEMP.EQ.0)THEN
            IF(ICTAMV.EQ.'ZERO')THEN
              STAT=0.0
              IF(IBFLAG.EQ.'BPRO' .OR. ICASCT.EQ.'MECL' .OR.
     1           ICASCT.EQ.'MDCL')THEN
                NTRIAL=0
                ALOWLM=0.0
                AUPPLM=0.0
              ENDIF
            ELSEIF(ICTAMV.EQ.'MV  ')THEN
              STAT=PCTAMV
              IF(IBFLAG.EQ.'BPRO' .OR. ICASCT.EQ.'MECL' .OR.
     1           ICASCT.EQ.'MDCL')THEN
                NTRIAL=0
                ALOWLM=PCTAMV
                AUPPLM=PCTAMV
              ENDIF
            ELSE
              GOTO1129
            ENDIF
          ELSE
            CALL CMPSTA(
     1              TEMP,TEMPZ,TEMPZ2,XTEMP1,XTEMP2,XTEMP3,
     1              MAXNXT,NTEMP,NTEMP,NTEMP,
     1              NRESP,ICASCT,
     1              ISEED,ITEMP1,ITEMP2,ITEMP3,ITEMP4,ITEMP5,ITEMP6,
     1              DTEMP1,DTEMP2,DTEMP3,
CCCCC1              IQUAME,IQUASE,PSTAMV,
     1              STAT,
     1              ISUBRO,IBUGA3,IERROR)
            IF(IERROR.EQ.'YES')GOTO9000
            IF(IBFLAG.EQ.'BPRO')THEN
              PTEMP=STAT
              NTRIAL=NTEMP
              IF(ICASCT.EQ.'BRAT')NTRIAL=ITEMP1(1)
              IF(STAT.EQ.PSTAMV)THEN
                ALOWLM=PSTAMV
                AUPPLM=PSTAMV
              ELSE
                ALPHAT=ALPHA
                CALL DPAGCO(PTEMP,NTRIAL,ALPHAT,IWRITE,
     1                      ALOWLM,AUPPLM,IBUGA3,IERROR)
              ENDIF
            ELSEIF(ICASCT.EQ.'MECL')THEN
              XMEAN=STAT
              NTRIAL=NTEMP
              IF(STAT.EQ.PSTAMV)THEN
                ALOWLM=PSTAMV
                AUPPLM=PSTAMV
              ELSE
                CALL SD(TEMP,NTEMP,IWRITE,XSD,IBUGA3,IERROR)
                ALPHAT=ALPHA
                CALL DPMECL(XMEAN,XSD,NTEMP,ALPHAT,IWRITE,
     1                      ALOWLM,AUPPLM,IBUGA3,IERROR)
              ENDIF
            ELSEIF(ICASCT.EQ.'MDCL')THEN
              XMED=STAT
              NTRIAL=NTEMP
              IF(STAT.EQ.PSTAMV)THEN
                ALOWLM=PSTAMV
                AUPPLM=PSTAMV
              ELSE
                XQ=0.5
                CALL QUANSE(XQ,TEMP,NTEMP,IWRITE,XTEMP1,MAXNXT,IQUASE,
     1                      QUASE,IBUGA3,IERROR)
                ALPHAT=ALPHA
                CALL DPMECL(XMED,QUASE,NTEMP,ALPHAT,IWRITE,
     1                      ALOWLM,AUPPLM,IBUGA3,IERROR)
              ENDIF
            ENDIF
          ENDIF
C
          J=J+1
          Y2(J)=STAT
          X2(J)=XIDTEM(ISET1)
          D2(J)=XIDTE2(ISET2)
          IF(IBFLAG.EQ.'BPRO' .OR. ICASCT.EQ.'MECL' .OR.
     1       ICASCT.EQ.'MDCL')THEN
            XNTRIA(J)=REAL(NTRIAL)
            XACLOW(J)=ALOWLM
            XACUPP(J)=AUPPLM
          ENDIF
C
 1129   CONTINUE
          IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'CRT3')THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,1140)ISET1,ISET2,NTEMP,NTEMP2,STAT
 1140       FORMAT('DPCRT3: ISET1,ISET2,NTEMP,NTEMP2,STAT = ',
     1             2I5,2I8,G15.7)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,1141)XIDTEM(ISET1),XIDTE2(ISET2)
 1141       FORMAT('XIDTEM(ISET1),XIDTE2(ISET2) = ',2G15.7)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,1142)J,Y2(J),X2(J),D2(J)
 1142       FORMAT('J,Y2(J),X2(J),D2(J) = ',I8,3G15.7)
            CALL DPWRST('XXX','BUG ')
          ENDIF
C
 1120   CONTINUE
 1110 CONTINUE
      N2=J
C
      IF(ICASCT.EQ.'BRAT')THEN
        IBFLAG='BRAT'
        ICASCT='BPRO'
      ENDIF
C
      IOP='OPEN'
      IFLG11=1
      IFLG21=0
      IFLG31=0
      IFLAG4=0
      IFLAG5=0
      CALL DPAUFI(IOP,IFLG11,IFLG21,IFLG31,IFLAG4,IFLAG5,
     1            IOUNI1,IOUNI2,IOUNI3,IOUNI4,IOUNI5,
     1            IBUGA3,ISUBRO,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      WRITE(IOUNI1,2111)ICTNAM
 2111 FORMAT(' GROUP-ID 1   GROUP-ID 2           ',A40)
      IF(ICASCT.EQ.'BPRO')THEN
        DO2170I=1,N2
          IF(IBINTA.EQ.'LOWE')THEN
            WRITE(IOUNI1,2171)X2(I),D2(I),Y2(I),XNTRIA(I),XACLOW(I)
 2171       FORMAT(5E17.9)
          ELSEIF(IBINTA.EQ.'UPPE')THEN
            WRITE(IOUNI1,2171)X2(I),D2(I),Y2(I),XNTRIA(I),XACUPP(I)
          ELSE
            WRITE(IOUNI1,2173)X2(I),D2(I),Y2(I),XNTRIA(I),
     1                        XACLOW(I),XACUPP(I)
 2173       FORMAT(6E17.9)
          ENDIF
 2170   CONTINUE
      ELSEIF(ICASCT.EQ.'MECL' .OR. ICASCT.EQ.'MDCL')THEN
        DO2175I=1,N2
          WRITE(IOUNI1,2173)X2(I),D2(I),Y2(I),XNTRIA(I),
     1                      XACLOW(I),XACUPP(I)
 2175   CONTINUE
      ELSE
        DO2160I=1,N2
          WRITE(IOUNI1,2161)X2(I),D2(I),Y2(I)
 2161     FORMAT(3E17.9)
 2160   CONTINUE
      ENDIF
C
      IOP='CLOS'
      CALL DPAUFI(IOP,IFLG11,IFLG21,IFLG31,IFLAG4,IFLAG5,
     1            IOUNI1,IOUNI2,IOUNI3,IOUNI4,IOUNI5,
     1            IBUGA3,ISUBRO,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
C               *****************************
C               **   STEP 6--              **
C               **   WRITE OUT THE TABLE   **
C               *****************************
C
      ISTEPN='6'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CRT3')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
C
      IF(IPRINT.EQ.'OFF')GOTO8000
C
      ITITLE(1:15)='Cross Tabulate '
      IF(ICASCT.EQ.'BPRO')THEN
        NCTITL=37
        ITITLE(16:NCTITL)='Binomial Probabilities'
      ELSEIF(ICASCT.EQ.'MECL')THEN
        NCTITL=37
        ITITLE(16:NCTITL)='Mean Confidence Limits'
      ELSEIF(ICASCT.EQ.'MDCL')THEN
        NCTITL=39
        ITITLE(16:NCTITL)='Median Confidence Limits'
      ELSE
        ITITLE(16:55)=ICTNAM(1:40)
        NCTITL=55
        DO4010I=55,1,-1
          IF(ITITLE(I:I).NE.' ')THEN
            NCTITL=I
            GOTO4019
          ENDIF
 4010   CONTINUE
 4019   CONTINUE
      ENDIF
C
      IF(IYVAR.EQ.'ON')THEN
        ITITL9(1:21)='(Response Variables: '
        NTEMP=21
        ITITL9(22:30)=IYNAM(1:8)
        NTEMP=30
        IF(IXVAR.EQ.'ON')THEN
          ITITL9(30:30)=' '
          ITITL9(31:38)=IXNAM(1:8)
          NTEMP=38
        ENDIF
        IF(IX2VAR.EQ.'ON')THEN
          ITITL9(39:39)=' '
          ITITL9(40:47)=IXNAM2(1:8)
          NTEMP=47
        ENDIF
        NTEMP=NTEMP+1
        ITITL9(NTEMP:NTEMP)=')'
        NCTIT9=NTEMP
      ELSE
        ITITL9=' '
        NCTIT9=0
      ENDIF
C
      ITITL2(1,1)(1:8)=IX1NAM
      NCTIT2(1,1)=8
      ITITL2(1,2)(1:8)=IX2NAM
      NCTIT2(1,2)=8
      ITITL2(1,3)='   |   '
      IF(ICAPTY.EQ.'LATE')THEN
        ITITL2(1,3)='  $|$  '
      ENDIF
      NCTIT2(1,3)=7
C
      NUMLIN=1
      IF(ICASCT.EQ.'BPRO')THEN
        NUMCOL=7
        IF(IBINTA.EQ.'LOWE' .OR. IBINTA.EQ.'UPPE')NUMCOL=6
        ITITL2(1,4)='P'
        NCTIT2(1,4)=1
        ITITL2(1,5)='N'
        NCTIT2(1,5)=1
        IF(IBINTA.EQ.'LOWE')THEN
          ITITL2(1,6)(1:40)='Lower AC'
          NCTIT2(1,6)=8
        ELSEIF(IBINTA.EQ.'UPPE')THEN
          ITITL2(1,6)(1:40)='Upper AC'
          NCTIT2(1,6)=8
        ELSE
          ITITL2(1,6)(1:40)='Lower AC'
          NCTIT2(1,6)=8
          ITITL2(1,7)(1:40)='Upper AC'
          NCTIT2(1,7)=8
        ENDIF
      ELSEIF(ICASCT.EQ.'MECL' .OR. ICASCT.EQ.'MDCL')THEN
        NUMCOL=7
        IF(ICASCT.EQ.'MECL')THEN
          ITITL2(1,4)='Mean'
          NCTIT2(1,4)=4
        ELSE
          ITITL2(1,4)='Median'
          NCTIT2(1,4)=6
        ENDIF
        ITITL2(1,5)='N'
        NCTIT2(1,5)=1
        ITITL2(1,6)='Lower Limit'
        ITITL2(1,7)='Upper Limit'
        NCTIT2(1,6)=11
        NCTIT2(1,7)=11
      ELSE
        NUMCOL=4
        ITITL2(1,4)(1:15)=ICTNAM(1:15)
        NTEMP=15
        DO4070I=15,1,-1
          IF(ITITL2(1,4)(I:I).NE.' ')THEN
            NTEMP=I
            GOTO4079
          ENDIF
 4070   CONTINUE
 4079   CONTINUE
        NCTIT2(1,4)=NTEMP
      ENDIF
C
      NMAX=0
      DO4210I=1,NUMCOL
        VALIGN(I)='b'
        ALIGN(I)='r'
        NTOT(I)=15
        IF(NCTIT2(1,I).GT.NTOT(I))NTOT(I)=NCTIT2(1,I)
        NMAX=NMAX+NTOT(I)
        IDIGIT(I)=NUMDIG
        ITYPCO(I)='NUME'
        IF(I.EQ.5)THEN
          NTOT(I)=8
          IDIGIT(I)=0
        ELSEIF(I.EQ.3)THEN
          ITYPCO(I)='ALPHA'
          NTOT(I)=7
          IDIGIT(I)=-1
        ENDIF
 4210 CONTINUE
C
      IWHTML(1)=125
      IWHTML(2)=125
      IWHTML(3)=25
      IWHTML(4)=125
      IWHTML(5)=75
      IWHTML(6)=125
      IWHTML(7)=125
      IJUNK=1400
      IWRTF(1)=IJUNK
      IWRTF(2)=IWRTF(1)+IJUNK
      IWRTF(3)=IWRTF(2)+200
      IWRTF(4)=IWRTF(3)+IJUNK
      IWRTF(5)=IWRTF(4)+800
      IWRTF(6)=IWRTF(5)+IJUNK
      IWRTF(7)=IWRTF(6)+IJUNK
      IFRST=.TRUE.
      IFLAGS=.TRUE.
      ILAST=.TRUE.
      IFLAGE=.FALSE.
C
      ICALL=0
      ICNT=0
      DO4310I=1,N2
        IF(ICNT.GE.30)THEN
          IF(I.EQ.N2)IFLAGE=.TRUE.
          CALL DPDTA5(ITITLE,NCTITL,
     1                ITITL9,NCTIT9,ITITL2,NCTIT2,
     1                MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1                IVALUE,NCVALU,AMAT,ITYPCO,MAXROW,ICNT,
     1                IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1                ICAPSW,ICAPTY,IFRST,ILAST,
     1                IFLAGS,IFLAGE,
     1                ISUBRO,IBUGA3,IERROR)
          IFRST=.FALSE.
          IFLAGS=.FALSE.
          ICALL=1
          ICNT=0
        ENDIF
        ICNT=ICNT+1
        NCTEXT(ICNT)=0
        AMAT(ICNT,1)=X2(I)
        AMAT(ICNT,2)=D2(I)
        AMAT(ICNT,3)=0.0
        AMAT(ICNT,4)=Y2(I)
        IF(ICASCT.EQ.'BPRO' .AND. IBINTA.EQ.'LOWE')THEN
          AMAT(ICNT,5)=XNTRIA(I)
          AMAT(ICNT,6)=XACLOW(I)
        ELSEIF(ICASCT.EQ.'BPRO' .AND. IBINTA.EQ.'UPPE')THEN
          AMAT(ICNT,5)=XNTRIA(I)
          AMAT(ICNT,6)=XACUPP(I)
        ELSEIF(ICASCT.EQ.'BPRO')THEN
          AMAT(ICNT,5)=XNTRIA(I)
          AMAT(ICNT,6)=XACLOW(I)
          AMAT(ICNT,7)=XACUPP(I)
        ELSEIF(ICASCT.EQ.'MECL' .OR. ICASCT.EQ.'MDCL')THEN
          AMAT(ICNT,5)=XNTRIA(I)
          AMAT(ICNT,6)=XACLOW(I)
          AMAT(ICNT,7)=XACUPP(I)
        ENDIF
        DO4320J=1,NUMCOL
          IF(J.EQ.3)THEN
            NCVALU(ICNT,J)=7
            IVALUE(ICNT,J)='   |   '
            IF(ICAPTY.EQ.'LATE')THEN
              IVALUE(ICNT,J)='  $|$  '
            ENDIF
          ELSE
            NCVALU(ICNT,J)=0
            IVALUE(ICNT,J)=' '
          ENDIF
 4320   CONTINUE
 4310 CONTINUE
C
      IF(ICNT.GE.1)THEN
        IFLAGE=.TRUE.
        ILAST=.TRUE.
        CALL DPDTA5(ITITLE,NCTITL,
     1              ITITL9,NCTIT9,ITITL2,NCTIT2,
     1              MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1              IVALUE,NCVALU,AMAT,ITYPCO,MAXROW,ICNT,
     1              IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1              ICAPSW,ICAPTY,IFRST,ILAST,
     1              IFLAGS,IFLAGE,
     1              ISUBRO,IBUGA3,IERROR)
      ENDIF
C
 8000 CONTINUE
      IF(IFEEDB.EQ.'ON')THEN
        WRITE(ICOUT,9212)
 9212   FORMAT(6X,'GROUP-IDs AND STATISTIC WRITTEN TO FILE ',
     1         'DPST1F.DAT')
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               ******************
C               **   STEP 90--  **
C               **   EXIT       **
C               ******************
C
 9000 CONTINUE
C
      IF(IBFLAG.EQ.'BRAT')THEN
        ICASCT='BRAT'
      ENDIF
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'CRT3')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPCRT3--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)ICASCT,N,NUMSE1,N2,IERROR
 9012   FORMAT('ICASCT,N,NUMSE1,N2,IERROR = ',A4,3I8,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9015)NUMV2,NUMSE1,NUMSE2,N2
 9015   FORMAT('NUMV2,NUMSE1,NUMSE2,N2 = ',4I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9016)ANUMS1,ANUMS2
 9016   FORMAT('ANUMS1,ANUMS2 = ',2E15.7)
        CALL DPWRST('XXX','BUG ')
        DO9020I=1,N2
          WRITE(ICOUT,9021)I,Y2(I),X2(I),D2(I)
 9021     FORMAT('I,Y2(I),X2(I),D2(I) = ',I8,3G15.7)
          CALL DPWRST('XXX','BUG ')
 9020   CONTINUE
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPCRT4(Y,Z,Z2,TAG1,TAG2,TAG3,N,
     1                  NUMV2,ICASCT,ICTNAM,
     1                  XIDTEM,XIDTE2,XIDTE3,
     1                  NUMSE1,NUMSE2,NUMSE3,
     1                  TEMP,TEMPZ,TEMPZ2,XTEMP1,XTEMP2,XTEMP3,
     1                  XNTRIA,XACLOW,XACUPP,
     1                  ITEMP1,ITEMP2,ITEMP3,ITEMP4,ITEMP5,ITEMP6,
     1                  DTEMP1,DTEMP2,DTEMP3,
     1                  ISEED,ALPHA,
     1                  IXVAR,IX2VAR,IYVAR,
     1                  IYNAM,IXNAM,IXNAM2,
     1                  IX1NAM,IX2NAM,IX3NAM,IX4NAM,IX5NAM,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  MAXNXT,
     1                  Y2,X2,D2,DSIZE,N2,ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--GENERATE A THREE-WAY CROSS-TABULATION AND
C              OPTIONALLY PRINT THE RESULTS TO AN ASCII,
C              HTML, LATEX, OR RTF TABLE.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     REFERENCE--ASTM MANUAL STP-15D, PAGES 78-84, 100-105
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2008/4
C     ORIGINAL VERSION--APRIL     2008.
C     UPDATED         --SEPTEMBER 2008. ACCOMODATE "MISSING" DATA
C     UPDATED         --JANUARY   2010. TREAT BINOMIAL RATIO IN A
C                                       SIMILAR FASHION TO BINOMIAL
C     UPDATED         --JUNE      2010. CALL LIST TO CMPSTA
C     UPDATED         --JUNE      2010. PRINT TABLES USING DPDTA5
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICASCT
      CHARACTER*40 ICTNAM
      CHARACTER*4 IXVAR
      CHARACTER*4 IX2VAR
      CHARACTER*4 IYVAR
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      PARAMETER(NUMCLI=8)
      PARAMETER(MAXLIN=2)
      PARAMETER (MAXROW=30)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*60 ITITL9
      CHARACTER*60 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(NUMCLI)
      CHARACTER*4  VALIGN(NUMCLI)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      CHARACTER*60 ITITL2(MAXLIN,NUMCLI)
      CHARACTER*15 IVALUE(MAXROW,NUMCLI)
      CHARACTER*4  ITYPCO(NUMCLI)
      INTEGER      NCTIT2(MAXLIN,NUMCLI)
      INTEGER      NCVALU(MAXROW,NUMCLI)
      INTEGER      IWHTML(NUMCLI)
      INTEGER      IWRTF(NUMCLI)
      REAL         AMAT(MAXROW,NUMCLI)
      LOGICAL IFRST
      LOGICAL ILAST
      LOGICAL IFLAG1
      LOGICAL IFLAG2
      LOGICAL IFLAG3
      LOGICAL IFLAGS
      LOGICAL IFLAGE
C
      CHARACTER*8 IYNAM
      CHARACTER*8 IXNAM
      CHARACTER*8 IXNAM2
      CHARACTER*8 IX1NAM
      CHARACTER*8 IX2NAM
      CHARACTER*8 IX3NAM
      CHARACTER*8 IX4NAM
      CHARACTER*8 IX5NAM
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IWRITE
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*10 ICONC1
      CHARACTER*10 ICONC2
C
      CHARACTER*4 ISUBN0
      CHARACTER*4 IBFLAG
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION Z(*)
      DIMENSION Z2(*)
      DIMENSION XIDTEM(*)
      DIMENSION XIDTE2(*)
      DIMENSION XIDTE3(*)
      DIMENSION Y2(*)
      DIMENSION X2(*)
      DIMENSION D2(*)
      DIMENSION DSIZE(*)
      DIMENSION XNTRIA(*)
      DIMENSION XACLOW(*)
      DIMENSION XACUPP(*)
C
      DIMENSION TAG1(*)
      DIMENSION TAG2(*)
      DIMENSION TAG3(*)
      DIMENSION TEMP(*)
      DIMENSION TEMPZ(*)
      DIMENSION TEMPZ2(*)
      DIMENSION XTEMP1(*)
      DIMENSION XTEMP2(*)
      DIMENSION XTEMP3(*)
C
      INTEGER ITEMP1(*)
      INTEGER ITEMP2(*)
      INTEGER ITEMP3(*)
      INTEGER ITEMP4(*)
      INTEGER ITEMP5(*)
      INTEGER ITEMP6(*)
C
      DOUBLE PRECISION DTEMP1(*)
      DOUBLE PRECISION DTEMP2(*)
      DOUBLE PRECISION DTEMP3(*)
C
      CHARACTER*4 IOP
C
      INCLUDE 'DPCOST.INC'
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPCR'
      ISUBN2='T4  '
C
      I2=0
C
      AN=INT(N+0.01)
      ANUMS1=INT(NUMSE1+0.01)
      ANUMS2=INT(NUMSE2+0.01)
      ANUMS3=INT(NUMSE3+0.01)
C
C               ***********************************************
C               **  STEP 5--                                 **
C               **  COMPUTE THE VARIOUS CROSS-TAB STATISTICS **
C               ***********************************************
C
      ISTEPN='5.1'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CRT4')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     ALLOW THE   SET WRITE DECIMALS COMMAND    TO BE USED TO
C     DETERMINE HOW MANY DIGITS PRINTED IN TABLE.
C
      NUMDIG=-7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=10
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
C     NOTE 9/2008: IN FOLLOWING, WE NEED TO DISTINGUISH BETWEEN
C                  EMPTY SETS DUE TO NO POINTS FALLING IN THE
C                  PARTICULAR CROSS TABULATION (IN WHICH CASE,
C                  WE WANT TO SKIP IN THE OUTPUT FILE) AND EMPTY
C                  SETS DUE TO ALL POINTS IN THE PARTICULAR
C                  CROSS TABULATION BEING MISSING (IN WHICH CASE,
C                  WE MAY WANT TO WRITE A 0 OR A MISSING VALUE).
C
C                  THERE ARE 2 MISSING VALUES:
C
C                  PSTAMV   - SPECIFIES WHETHER THE INPUT DATA
C                             VALUE IS TO BE INCLUDED IN THE
C                             COMPUTATION OF THE STATISTIC
C
C                  PCTAMV    - IF ALL THE DATA IS MISSING, THIS
C                              IS THE VALUE TO USE IN WRITING THE
C                              CROSS TABULATE OUTPUT.
C
      IWRITE='OFF'
      IBFLAG=ICASCT
      IF(IBFLAG.EQ.'BRAT')IBFLAG='BPRO'
C
      EPS=0.1E-7
      J=0
      NRESP=NUMV2-3
      DO1110ISET1=1,NUMSE1
        DO1120ISET2=1,NUMSE2
          DO1130ISET3=1,NUMSE3
C
            K=0
            NTEMP2=0
            DO1140I=1,N
              IF(XIDTEM(ISET1).EQ.TAG1(I).AND.XIDTE2(ISET2).EQ.TAG2(I)
     1           .AND.XIDTE3(ISET3).EQ.TAG3(I))
     1           GOTO1141
              GOTO1140
 1141         CONTINUE
C
              NTEMP2=NTEMP2+1
              IF(IYVAR.EQ.'OFF')THEN
                K=K+1
                TEMP(K)=0.0
              ELSE
                IF(ABS(Y(I)-PSTAMV).GT.EPS)THEN
                  K=K+1
                  TEMP(K)=Y(I)
                  IF(IXVAR.EQ.'ON')TEMPZ(K)=Z(I)
                  IF(IX2VAR.EQ.'ON')TEMPZ2(K)=Z2(I)
                ENDIF
              ENDIF
 1140       CONTINUE
            NTEMP=K
C
C           AUGUST 2002.  CALL CMPSTA (EXCEPT FOR CHI-SQUARE CASE)
C
C         NTEMP2 IS THE NUMBER OF POINTS IN THE SUBSET AND
C         NTEMP IS THE NUMBER OF NON-MISSING POINTS IN THE SUBSET.
C
          IF(NTEMP2.EQ.0)GOTO1130
C
            IF(NTEMP.EQ.0)THEN
              IF(ICTAMV.EQ.'ZERO')THEN
                STAT=0.0
                IF(IBFLAG.EQ.'BPRO' .OR. ICASCT.EQ.'MECL' .OR.
     1             ICASCT.EQ.'MDCL')THEN
                  NTRIAL=0
                  ALOWLM=0.0
                  AUPPLM=0.0
                ENDIF
              ELSEIF(ICTAMV.EQ.'MV  ')THEN
                STAT=PCTAMV
                IF(IBFLAG.EQ.'BPRO' .OR. ICASCT.EQ.'MECL' .OR.
     1             ICASCT.EQ.'MDCL')THEN
                  NTRIAL=0
                  ALOWLM=PCTAMV
                  AUPPLM=PCTAMV
                ENDIF
              ELSE
                GOTO1130
              ENDIF
            ELSE
              CALL CMPSTA(
     1              TEMP,TEMPZ,TEMPZ2,XTEMP1,XTEMP2,XTEMP3,
     1              MAXNXT,NTEMP,NTEMP,NTEMP,
     1              NRESP,ICASCT,
     1              ISEED,ITEMP1,ITEMP2,ITEMP3,ITEMP4,ITEMP5,ITEMP6,
     1              DTEMP1,DTEMP2,DTEMP3,
CCCCC1              IQUAME,IQUASE,PSTAMV,
     1              STAT,
     1              ISUBRO,IBUGA3,IERROR)
              IF(IERROR.EQ.'YES')GOTO9000
              IF(IBFLAG.EQ.'BPRO')THEN
                PTEMP=STAT
                NTRIAL=NTEMP
                IF(ICASCT.EQ.'BRAT')NTRIAL=ITEMP1(1)
                IF(STAT.EQ.PSTAMV)THEN
                  ALOWLM=PSTAMV
                  AUPPLM=PSTAMV
                ELSE
                  ALPHAT=ALPHA
                  CALL DPAGCO(PTEMP,NTRIAL,ALPHAT,IWRITE,
     1                        ALOWLM,AUPPLM,IBUGA3,IERROR)
                ENDIF
              ELSEIF(ICASCT.EQ.'MECL')THEN
                XMEAN=STAT
                NTRIAL=NTEMP
                IF(STAT.EQ.PSTAMV)THEN
                  ALOWLM=PSTAMV
                  AUPPLM=PSTAMV
                ELSE
                  CALL SD(TEMP,NTEMP,IWRITE,XSD,IBUGA3,IERROR)
                  ALPHAT=ALPHA
                  CALL DPMECL(XMEAN,XSD,NTEMP,ALPHAT,IWRITE,
     1                        ALOWLM,AUPPLM,IBUGA3,IERROR)
                ENDIF
              ELSEIF(ICASCT.EQ.'MDCL')THEN
                XMED=STAT
                NTRIAL=NTEMP
                IF(STAT.EQ.PSTAMV)THEN
                  ALOWLM=PSTAMV
                  AUPPLM=PSTAMV
                ELSE
                  XQ=0.5
                  CALL QUANSE(XQ,TEMP,NTEMP,IWRITE,XTEMP1,MAXNXT,IQUASE,
     1                        QUASE,IBUGA3,IERROR)
                  ALPHAT=ALPHA
                  CALL DPMECL(XMED,QUASE,NTEMP,ALPHAT,IWRITE,
     1                        ALOWLM,AUPPLM,IBUGA3,IERROR)
                ENDIF
              ENDIF
            ENDIF
C
            J=J+1
            Y2(J)=STAT
            X2(J)=XIDTEM(ISET1)
            D2(J)=XIDTE2(ISET2)
            DSIZE(J)=XIDTE3(ISET3)
            IF(IBFLAG.EQ.'BPRO' .OR. ICASCT.EQ.'MECL' .OR.
     1         ICASCT.EQ.'MDCL')THEN
              XNTRIA(J)=REAL(NTRIAL)
              XACLOW(J)=ALOWLM
              XACUPP(J)=AUPPLM
            ENDIF
C
 1130     CONTINUE
 1120   CONTINUE
 1110 CONTINUE
      N2=J
C
      IF(ICASCT.EQ.'BRAT')THEN
        IBFLAG='BRAT'
        ICASCT='BPRO'
      ENDIF
C
      IOP='OPEN'
      IFLG11=1
      IFLG21=0
      IFLG31=0
      IFLAG4=0
      IFLAG5=0
      CALL DPAUFI(IOP,IFLG11,IFLG21,IFLG31,IFLAG4,IFLAG5,
     1            IOUNI1,IOUNI2,IOUNI3,IOUNI4,IOUNI5,
     1            IBUGA3,ISUBRO,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      WRITE(IOUNI1,2111)ICTNAM
 2111 FORMAT(' GROUP-ID 1   GROUP-ID 2   GROUP-ID 3           ',A40)
      IF(ICASCT.EQ.'BPRO')THEN
        DO2170I=1,N2
          IF(IBINTA.EQ.'LOWE')THEN
            WRITE(IOUNI1,2171)X2(I),D2(I),DSIZE(I),
     1                        Y2(I),XNTRIA(I),XACLOW(I)
 2171       FORMAT(6E17.8)
          ELSEIF(IBINTA.EQ.'UPPE')THEN
            WRITE(IOUNI1,2171)X2(I),D2(I),DSIZE(I),
     1                        Y2(I),XNTRIA(I),XACUPP(I)
          ELSE
            WRITE(IOUNI1,2173)X2(I),D2(I),DSIZE(I),
     1                        Y2(I),XNTRIA(I),
     1                        XACLOW(I),XACUPP(I)
 2173       FORMAT(7E17.9)
          ENDIF
 2170   CONTINUE
      ELSEIF(ICASCT.EQ.'MECL' .OR. ICASCT.EQ.'MDCL')THEN
        DO2175I=1,N2
          WRITE(IOUNI1,2173)X2(I),D2(I),DSIZE(I),Y2(I),XNTRIA(I),
     1                      XACLOW(I),XACUPP(I)
 2175   CONTINUE
      ELSE
        DO2160I=1,N2
          WRITE(IOUNI1,2161)X2(I),D2(I),DSIZE(I),Y2(I)
 2161     FORMAT(4E17.9)
 2160   CONTINUE
      ENDIF
C
      IOP='CLOS'
      CALL DPAUFI(IOP,IFLG11,IFLG21,IFLG31,IFLAG4,IFLAG5,
     1            IOUNI1,IOUNI2,IOUNI3,IOUNI4,IOUNI5,
     1            IBUGA3,ISUBRO,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
C               *****************************
C               **   STEP 6--              **
C               **   WRITE OUT THE TABLE   **
C               *****************************
C
      ISTEPN='6'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CRT4')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
C
      IF(IPRINT.EQ.'OFF')GOTO8000
C
      ITITLE(1:15)='Cross Tabulate '
      IF(ICASCT.EQ.'BPRO')THEN
        NCTITL=37
        ITITLE(16:NCTITL)='Binomial Probabilities'
      ELSEIF(ICASCT.EQ.'MECL')THEN
        NCTITL=37
        ITITLE(16:NCTITL)='Mean Confidence Limits'
      ELSEIF(ICASCT.EQ.'MDCL')THEN
        NCTITL=39
        ITITLE(16:NCTITL)='Median Confidence Limits'
      ELSE
        ITITLE(16:55)=ICTNAM(1:40)
        NCTITL=55
        DO4010I=55,1,-1
          IF(ITITLE(I:I).NE.' ')THEN
            NCTITL=I
            GOTO4019
          ENDIF
 4010   CONTINUE
 4019   CONTINUE
      ENDIF
C
      IF(IYVAR.EQ.'ON')THEN
        ITITL9(1:21)='(Response Variables: '
        NTEMP=21
        ITITL9(22:30)=IYNAM(1:8)
        NTEMP=30
        IF(IXVAR.EQ.'ON')THEN
          ITITL9(30:30)=' '
          ITITL9(31:38)=IXNAM(1:8)
          NTEMP=38
        ENDIF
        IF(IX2VAR.EQ.'ON')THEN
          ITITL9(39:39)=' '
          ITITL9(40:47)=IXNAM2(1:8)
          NTEMP=47
        ENDIF
        NTEMP=NTEMP+1
        ITITL9(NTEMP:NTEMP)=')'
        NCTIT9=NTEMP
      ELSE
        ITITL9=' '
        NCTIT9=0
      ENDIF
C
      ITITL2(1,1)(1:8)=IX1NAM
      NCTIT2(1,1)=8
      ITITL2(1,2)(1:8)=IX2NAM
      NCTIT2(1,2)=8
      ITITL2(1,3)(1:8)=IX3NAM
      NCTIT2(1,3)=8
      ITITL2(1,4)='   |   '
      IF(ICAPTY.EQ.'LATE')THEN
        ITITL2(1,4)='  $|$  '
      ENDIF
      NCTIT2(1,4)=7
C
      NUMLIN=1
      IF(ICASCT.EQ.'BPRO')THEN
        NUMCOL=8
        IF(IBINTA.EQ.'LOWE' .OR. IBINTA.EQ.'UPPE')NUMCOL=7
        ITITL2(1,5)='P'
        NCTIT2(1,5)=1
        ITITL2(1,6)='N'
        NCTIT2(1,6)=1
        IF(IBINTA.EQ.'LOWE')THEN
          ITITL2(1,7)(1:40)='Lower AC'
          NCTIT2(1,7)=8
        ELSEIF(IBINTA.EQ.'UPPE')THEN
          ITITL2(1,7)(1:40)='Upper AC'
          NCTIT2(1,7)=8
        ELSE
          ITITL2(1,7)(1:40)='Lower AC'
          NCTIT2(1,7)=8
          ITITL2(1,8)(1:40)='Upper AC'
          NCTIT2(1,8)=8
        ENDIF
      ELSEIF(ICASCT.EQ.'MECL' .OR. ICASCT.EQ.'MDCL')THEN
        NUMCOL=8
        IF(ICASCT.EQ.'MECL')THEN
          ITITL2(1,5)='Mean'
          NCTIT2(1,5)=4
        ELSE
          ITITL2(1,5)='Median'
          NCTIT2(1,5)=6
        ENDIF
        ITITL2(1,6)='N'
        NCTIT2(1,6)=1
        ITITL2(1,7)='Lower Limit'
        ITITL2(1,7)='Upper Limit'
        NCTIT2(1,8)=11
        NCTIT2(1,8)=11
      ELSE
        NUMCOL=5
        ITITL2(1,5)(1:15)=ICTNAM(1:15)
        NTEMP=15
        DO4070I=15,1,-1
          IF(ITITL2(1,5)(I:I).NE.' ')THEN
            NTEMP=I
            GOTO4079
          ENDIF
 4070   CONTINUE
 4079   CONTINUE
        NCTIT2(1,5)=NTEMP
      ENDIF
C
      NMAX=0
      DO4210I=1,NUMCOL
        VALIGN(I)='b'
        ALIGN(I)='r'
        NTOT(I)=15
        IF(NCTIT2(1,I).GT.NTOT(I))NTOT(I)=NCTIT2(1,I)
        NMAX=NMAX+NTOT(I)
        IDIGIT(I)=NUMDIG
        ITYPCO(I)='NUME'
        IF(I.EQ.6)THEN
          NTOT(I)=8
          IDIGIT(I)=0
        ELSEIF(I.EQ.4)THEN
          ITYPCO(I)='ALPHA'
          NTOT(I)=7
          IDIGIT(I)=-1
CCCCC   ELSEIF(I.EQ.5)THEN
CCCCC     IF(ICASCT.NE.'BPRO' .AND. ICASCT.NE.'MECL' .AND.
CCCCC1       ICASCT.NE.'MDCL')THEN
CCCCC        ALIGN(I)='l'
CCCCC     ENDIF
        ENDIF
 4210 CONTINUE
C
      IWHTML(1)=125
      IWHTML(2)=125
      IWHTML(3)=125
      IWHTML(4)=25
      IWHTML(5)=125
      IWHTML(6)=75
      IWHTML(7)=125
      IWHTML(8)=125
      IJUNK=1400
      IWRTF(1)=IJUNK
      IWRTF(2)=IWRTF(1)+IJUNK
      IWRTF(3)=IWRTF(2)+IJUNK
      IWRTF(4)=IWRTF(3)+200
      IWRTF(5)=IWRTF(4)+IJUNK
      IWRTF(6)=IWRTF(5)+800
      IWRTF(7)=IWRTF(6)+IJUNK
      IWRTF(8)=IWRTF(7)+IJUNK
      IFRST=.TRUE.
      ILAST=.TRUE.
      IFLAGS=.TRUE.
      IFLAGE=.FALSE.
C
      ICNT=0
      ICALL=0
      DO4310I=1,N2
        IF(ICNT.GE.30)THEN
          IF(I.EQ.N2)IFLAGE=.TRUE.
          CALL DPDTA5(ITITLE,NCTITL,
     1                ITITL9,NCTIT9,ITITL2,NCTIT2,
     1                MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1                IVALUE,NCVALU,AMAT,ITYPCO,MAXROW,ICNT,
     1                IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1                ICAPSW,ICAPTY,IFRST,ILAST,
     1                IFLAGS,IFLAGE,
     1                ISUBRO,IBUGA3,IERROR)
          IFRST=.FALSE.
          IFLAGS=.FALSE.
          ICALL=1
          ICNT=0
        ENDIF
        ICNT=ICNT+1
        NCTEXT(ICNT)=0
        AMAT(ICNT,1)=X2(I)
        AMAT(ICNT,2)=D2(I)
        AMAT(ICNT,3)=DSIZE(I)
        AMAT(ICNT,4)=0.0
        AMAT(ICNT,5)=Y2(I)
        IF(ICASCT.EQ.'BPRO' .AND. IBINTA.EQ.'LOWE')THEN
          AMAT(ICNT,6)=XNTRIA(I)
          AMAT(ICNT,7)=XACLOW(I)
        ELSEIF(ICASCT.EQ.'BPRO' .AND. IBINTA.EQ.'UPPE')THEN
          AMAT(ICNT,6)=XNTRIA(I)
          AMAT(ICNT,7)=XACUPP(I)
        ELSEIF(ICASCT.EQ.'BPRO')THEN
          AMAT(ICNT,6)=XNTRIA(I)
          AMAT(ICNT,7)=XACLOW(I)
          AMAT(ICNT,8)=XACUPP(I)
        ELSEIF(ICASCT.EQ.'MECL' .OR. ICASCT.EQ.'MDCL')THEN
          AMAT(ICNT,6)=XNTRIA(I)
          AMAT(ICNT,7)=XACLOW(I)
          AMAT(ICNT,8)=XACUPP(I)
        ENDIF
        DO4320J=1,NUMCOL
          IF(J.EQ.4)THEN
            NCVALU(ICNT,J)=7
            IVALUE(ICNT,J)='   |   '
            IF(ICAPTY.EQ.'LATE')THEN
              IVALUE(ICNT,J)='  $|$  '
            ENDIF
          ELSE
            NCVALU(ICNT,J)=0
            IVALUE(ICNT,J)=' '
          ENDIF
 4320   CONTINUE
 4310 CONTINUE
C
      IF(ICNT.GE.1)THEN
        IFLAGE=.TRUE.
        ILAST=.TRUE.
        CALL DPDTA5(ITITLE,NCTITL,
     1              ITITL9,NCTIT9,ITITL2,NCTIT2,
     1              MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1              IVALUE,NCVALU,AMAT,ITYPCO,MAXROW,ICNT,
     1              IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1              ICAPSW,ICAPTY,IFRST,ILAST,
     1              IFLAGS,IFLAGE,
     1              ISUBRO,IBUGA3,IERROR)
      ENDIF
C
 8000 CONTINUE
      IF(IFEEDB.EQ.'ON')THEN
        WRITE(ICOUT,9212)
 9212   FORMAT(6X,'GROUP-IDs AND STATISTIC WRITTEN TO FILE ',
     1         'DPST1F.DAT')
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               ******************
C               **   STEP 90--  **
C               **   EXIT       **
C               ******************
C
 9000 CONTINUE
C
      IF(IBFLAG.EQ.'BRAT')THEN
        ICASCT='BRAT'
      ENDIF
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'CRT4')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPCRT4--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)ICASCT,N,N2,IERROR
 9012   FORMAT('ICASCT,N,N2,IERROR = ',A4,2I8,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)NUMV2
 9013   FORMAT('NUMV2 = ',I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9015)NUMSE1,NUMSE2,NUMSE3
 9015   FORMAT('NUMSE1,NUMSE2,NUMSE3 = ',3I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9016)ANUMS1,ANUMS2,ANUMS3
 9016   FORMAT('ANUMS1,ANUMS2,ANUMS3 = ',3E15.7)
        CALL DPWRST('XXX','BUG ')
        DO9020I=1,N2
          WRITE(ICOUT,9021)I,Y2(I),X2(I),DSIZE(I),D2(I)
 9021     FORMAT('I,Y2(I),X2(I),DSIZE(I),D2(I) = ',I8,4G15.7)
          CALL DPWRST('XXX','BUG ')
 9020   CONTINUE
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPCRT5(Y,Z,Z2,TAG1,TAG2,TAG3,TAG4,N,
     1                  NUMV2,ICASCT,ICTNAM,
     1                  XIDTEM,XIDTE2,XIDTE3,XIDTE4,
     1                  NUMSE1,NUMSE2,NUMSE3,NUMSE4,
     1                  TEMP,TEMPZ,TEMPZ2,XTEMP1,XTEMP2,XTEMP3,
     1                  XNTRIA,XACLOW,XACUPP,
     1                  ITEMP1,ITEMP2,ITEMP3,ITEMP4,ITEMP5,ITEMP6,
     1                  DTEMP1,DTEMP2,DTEMP3,
     1                  ISEED,ALPHA,
     1                  IXVAR,IX2VAR,IYVAR,
     1                  IYNAM,IXNAM,IXNAM2,
     1                  IX1NAM,IX2NAM,IX3NAM,IX4NAM,IX5NAM,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  MAXNXT,
     1                  Y2,X2,D2,DSIZE,DCOLOR,N2,ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--GENERATE A FOUR-WAY CROSS-TABULATION AND
C              OPTIONALLY PRINT THE RESULTS TO AN ASCII,
C              HTML, LATEX, OR RTF TABLE.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     REFERENCE--ASTM MANUAL STP-15D, PAGES 78-84, 100-105
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2008/4
C     ORIGINAL VERSION--APRIL     2008.
C     UPDATED         --SEPTEMBER 2008. ACCOMODATE "MISSING" DATA
C     UPDATED         --JANUARY   2010. TREAT BINOMIAL RATIO IN A
C                                       SIMILAR FASHION TO BINOMIAL
C     UPDATED         --JUNE      2010. CALL LIST TO CMPSTA
C     UPDATED         --JUNE      2010. USE DPDTA5 TO PRINT TABLE
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICASCT
      CHARACTER*40 ICTNAM
      CHARACTER*4 IXVAR
      CHARACTER*4 IX2VAR
      CHARACTER*4 IYVAR
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      PARAMETER(NUMCLI=9)
      PARAMETER(MAXLIN=2)
      PARAMETER (MAXROW=30)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*60 ITITL9
      CHARACTER*60 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(NUMCLI)
      CHARACTER*4  VALIGN(NUMCLI)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      CHARACTER*60 ITITL2(MAXLIN,NUMCLI)
      CHARACTER*15 IVALUE(MAXROW,NUMCLI)
      CHARACTER*4  ITYPCO(NUMCLI)
      INTEGER      NCTIT2(MAXLIN,NUMCLI)
      INTEGER      NCVALU(MAXROW,NUMCLI)
      INTEGER      IWHTML(NUMCLI)
      INTEGER      IWRTF(NUMCLI)
      REAL         AMAT(MAXROW,NUMCLI)
      LOGICAL IFRST
      LOGICAL ILAST
      LOGICAL IFLAG1
      LOGICAL IFLAG2
      LOGICAL IFLAG3
      LOGICAL IFLAGS
      LOGICAL IFLAGE
C
      CHARACTER*8 IYNAM
      CHARACTER*8 IXNAM
      CHARACTER*8 IXNAM2
      CHARACTER*8 IX1NAM
      CHARACTER*8 IX2NAM
      CHARACTER*8 IX3NAM
      CHARACTER*8 IX4NAM
      CHARACTER*8 IX5NAM
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IWRITE
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*10 ICONC1
      CHARACTER*10 ICONC2
C
      CHARACTER*4 ISUBN0
      CHARACTER*4 IBFLAG
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION Z(*)
      DIMENSION Z2(*)
      DIMENSION XIDTEM(*)
      DIMENSION XIDTE2(*)
      DIMENSION XIDTE3(*)
      DIMENSION XIDTE4(*)
      DIMENSION Y2(*)
      DIMENSION X2(*)
      DIMENSION D2(*)
      DIMENSION DSIZE(*)
      DIMENSION DCOLOR(*)
C
      DIMENSION TAG1(*)
      DIMENSION TAG2(*)
      DIMENSION TAG3(*)
      DIMENSION TAG4(*)
      DIMENSION TEMP(*)
      DIMENSION TEMPZ(*)
      DIMENSION TEMPZ2(*)
      DIMENSION XTEMP1(*)
      DIMENSION XTEMP2(*)
      DIMENSION XTEMP3(*)
      DIMENSION XNTRIA(*)
      DIMENSION XACLOW(*)
      DIMENSION XACUPP(*)
C
      INTEGER ITEMP1(*)
      INTEGER ITEMP2(*)
      INTEGER ITEMP3(*)
      INTEGER ITEMP4(*)
      INTEGER ITEMP5(*)
      INTEGER ITEMP6(*)
C
      DOUBLE PRECISION DTEMP1(*)
      DOUBLE PRECISION DTEMP2(*)
      DOUBLE PRECISION DTEMP3(*)
C
      CHARACTER*4 IOP
C
      INCLUDE 'DPCOST.INC'
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPCR'
      ISUBN2='T5  '
C
      I2=0
C
      AN=INT(N+0.01)
      ANUMS1=INT(NUMSE1+0.01)
      ANUMS2=INT(NUMSE2+0.01)
      ANUMS3=INT(NUMSE3+0.01)
      ANUMS4=INT(NUMSE4+0.01)
C
C               ***********************************************
C               **  STEP 5--                                 **
C               **  COMPUTE THE VARIOUS CROSS-TAB STATISTICS **
C               ***********************************************
C
      ISTEPN='5.1'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CRT5')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     ALLOW THE   SET WRITE DECIMALS COMMAND    TO BE USED TO
C     DETERMINE HOW MANY DIGITS PRINTED IN TABLE.
C
      NUMDIG=-7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=10
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
C     NOTE 9/2008: IN FOLLOWING, WE NEED TO DISTINGUISH BETWEEN
C                  EMPTY SETS DUE TO NO POINTS FALLING IN THE
C                  PARTICULAR CROSS TABULATION (IN WHICH CASE,
C                  WE WANT TO SKIP IN THE OUTPUT FILE) AND EMPTY
C                  SETS DUE TO ALL POINTS IN THE PARTICULAR
C                  CROSS TABULATION BEING MISSING (IN WHICH CASE,
C                  WE MAY WANT TO WRITE A 0 OR A MISSING VALUE).
C
C                  THERE ARE 2 MISSING VALUES:
C
C                  PSTAMV   - SPECIFIES WHETHER THE INPUT DATA
C                             VALUE IS TO BE INCLUDED IN THE
C                             COMPUTATION OF THE STATISTIC
C
C                  PCTAMV    - IF ALL THE DATA IS MISSING, THIS
C                              IS THE VALUE TO USE IN WRITING THE
C                              CROSS TABULATE OUTPUT.
C
      IWRITE='OFF'
      IBFLAG=ICASCT
      IF(IBFLAG.EQ.'BRAT')IBFLAG='BPRO'
C
      EPS=0.1E-7
      J=0
      NRESP=NUMV2-4
      DO1110ISET1=1,NUMSE1
        DO1120ISET2=1,NUMSE2
          DO1130ISET3=1,NUMSE3
          DO1140ISET4=1,NUMSE4
C
            K=0
            NTEMP2=0
            DO1180I=1,N
              IF(XIDTEM(ISET1).EQ.TAG1(I) .AND.
     1           XIDTE2(ISET2).EQ.TAG2(I) .AND.
     1           XIDTE3(ISET3).EQ.TAG3(I) .AND.
     1           XIDTE4(ISET4).EQ.TAG4(I))
     1           GOTO1181
              GOTO1180
 1181         CONTINUE
C
              NTEMP2=NTEMP2+1
              IF(IYVAR.EQ.'OFF')THEN
                K=K+1
                TEMP(K)=0.0
              ELSE
                IF(ABS(Y(I)-PSTAMV).GT.EPS)THEN
                  K=K+1
                  TEMP(K)=Y(I)
                  IF(IXVAR.EQ.'ON')TEMPZ(K)=Z(I)
                  IF(IX2VAR.EQ.'ON')TEMPZ2(K)=Z2(I)
                ENDIF
              ENDIF
 1180       CONTINUE
            NTEMP=K
C
C           AUGUST 2002.  CALL CMPSTA (EXCEPT FOR CHI-SQUARE CASE)
C
C           NTEMP2 IS THE NUMBER OF POINTS IN THE SUBSET AND
C           NTEMP IS THE NUMBER OF NON-MISSING POINTS IN THE SUBSET.
C
            IF(NTEMP2.EQ.0)GOTO1140
C
            IF(NTEMP.EQ.0)THEN
              IF(ICTAMV.EQ.'ZERO')THEN
                STAT=0.0
                IF(IBFLAG.EQ.'BPRO' .OR. ICASCT.EQ.'MECL' .OR.
     1             ICASCT.EQ.'MDCL')THEN
                  NTRIAL=0
                  ALOWLM=0.0
                  AUPPLM=0.0
                ENDIF
              ELSEIF(ICTAMV.EQ.'MV  ')THEN
                STAT=PCTAMV
                IF(IBFLAG.EQ.'BPRO' .OR. ICASCT.EQ.'MECL' .OR.
     1             ICASCT.EQ.'MDCL')THEN
                  NTRIAL=0
                  ALOWLM=PCTAMV
                  AUPPLM=PCTAMV
                ENDIF
              ELSE
                GOTO1140
              ENDIF
            ELSE
              CALL CMPSTA(
     1              TEMP,TEMPZ,TEMPZ2,XTEMP1,XTEMP2,XTEMP3,
     1              MAXNXT,NTEMP,NTEMP,NTEMP,
     1              NRESP,ICASCT,
     1              ISEED,ITEMP1,ITEMP2,ITEMP3,ITEMP4,ITEMP5,ITEMP6,
     1              DTEMP1,DTEMP2,DTEMP3,
CCCCC1              IQUAME,IQUASE,PSTAMV,
     1              STAT,
     1              ISUBRO,IBUGA3,IERROR)
              IF(IERROR.EQ.'YES')GOTO9000
              IF(IBFLAG.EQ.'BPRO')THEN
                PTEMP=STAT
                NTRIAL=NTEMP
                IF(ICASCT.EQ.'BRAT')NTRIAL=ITEMP1(1)
                IF(STAT.EQ.PSTAMV)THEN
                  ALOWLM=PSTAMV
                  AUPPLM=PSTAMV
                ELSE
                  ALPHAT=ALPHA
                  CALL DPAGCO(PTEMP,NTRIAL,ALPHAT,IWRITE,
     1                        ALOWLM,AUPPLM,IBUGA3,IERROR)
                ENDIF
              ELSEIF(ICASCT.EQ.'MECL')THEN
                XMEAN=STAT
                NTRIAL=NTEMP
                IF(STAT.EQ.PSTAMV)THEN
                  ALOWLM=PSTAMV
                  AUPPLM=PSTAMV
                ELSE
                  CALL SD(TEMP,NTEMP,IWRITE,XSD,IBUGA3,IERROR)
                  ALPHAT=ALPHA
                  CALL DPMECL(XMEAN,XSD,NTEMP,ALPHAT,IWRITE,
     1                        ALOWLM,AUPPLM,IBUGA3,IERROR)
                ENDIF
              ELSEIF(ICASCT.EQ.'MDCL')THEN
                XMED=STAT
                NTRIAL=NTEMP
                IF(STAT.EQ.PSTAMV)THEN
                  ALOWLM=PSTAMV
                  AUPPLM=PSTAMV
                ELSE
                  XQ=0.5
                  CALL QUANSE(XQ,TEMP,NTEMP,IWRITE,XTEMP1,MAXNXT,IQUASE,
     1                        QUASE,IBUGA3,IERROR)
                  ALPHAT=ALPHA
                  CALL DPMECL(XMED,QUASE,NTEMP,ALPHAT,IWRITE,
     1                        ALOWLM,AUPPLM,IBUGA3,IERROR)
                ENDIF
              ENDIF
            ENDIF
C
            J=J+1
            Y2(J)=STAT
            X2(J)=XIDTEM(ISET1)
            D2(J)=XIDTE2(ISET2)
            DSIZE(J)=XIDTE3(ISET3)
            DCOLOR(J)=XIDTE4(ISET4)
            IF(IBFLAG.EQ.'BPRO' .OR. ICASCT.EQ.'MECL' .OR.
     1         ICASCT.EQ.'MDCL')THEN
              XNTRIA(J)=REAL(NTRIAL)
              XACLOW(J)=ALOWLM
              XACUPP(J)=AUPPLM
            ENDIF
C
 1140     CONTINUE
 1130     CONTINUE
 1120   CONTINUE
 1110 CONTINUE
      N2=J
C
      IF(ICASCT.EQ.'BRAT')THEN
        IBFLAG='BRAT'
        ICASCT='BPRO'
      ENDIF
C
      IOP='OPEN'
      IFLG11=1
      IFLG21=0
      IFLG31=0
      IFLAG4=0
      IFLAG5=0
      CALL DPAUFI(IOP,IFLG11,IFLG21,IFLG31,IFLAG4,IFLAG5,
     1            IOUNI1,IOUNI2,IOUNI3,IOUNI4,IOUNI5,
     1            IBUGA3,ISUBRO,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      WRITE(IOUNI1,2111)ICTNAM
 2111 FORMAT(' GROUP-ID 1   GROUP-ID 2   GROUP-ID 3   GROUP-ID 4',
     1       '           ',A40)
      IF(ICASCT.EQ.'BPRO')THEN
        DO2170I=1,N2
          IF(IBINTA.EQ.'LOWE')THEN
            WRITE(IOUNI1,2171)X2(I),D2(I),DSIZE(I),DCOLOR(I),
     1                        Y2(I),XNTRIA(I),XACLOW(I)
 2171       FORMAT(7E17.9)
          ELSEIF(IBINTA.EQ.'UPPE')THEN
            WRITE(IOUNI1,2171)X2(I),D2(I),DSIZE(I),DCOLOR(I),
     1                        Y2(I),XNTRIA(I),XACUPP(I)
          ELSE
            WRITE(IOUNI1,2173)X2(I),D2(I),DSIZE(I),DCOLOR(I),
     1                        Y2(I),XNTRIA(I),
     1                        XACLOW(I),XACUPP(I)
 2173       FORMAT(8E17.9)
          ENDIF
 2170   CONTINUE
      ELSEIF(ICASCT.EQ.'MECL' .OR. ICASCT.EQ.'MDCL')THEN
        DO2175I=1,N2
          WRITE(IOUNI1,2173)X2(I),D2(I),DSIZE(I),DCOLOR(I),
     1                      Y2(I),XNTRIA(I),XACLOW(I),XACUPP(I)
 2175   CONTINUE
      ELSE
        DO2160I=1,N2
          WRITE(IOUNI1,2161)X2(I),D2(I),DSIZE(I),DCOLOR(I),Y2(I)
 2161     FORMAT(5E17.9)
 2160   CONTINUE
      ENDIF
C
      IOP='CLOS'
      CALL DPAUFI(IOP,IFLG11,IFLG21,IFLG31,IFLAG4,IFLAG5,
     1            IOUNI1,IOUNI2,IOUNI3,IOUNI4,IOUNI5,
     1            IBUGA3,ISUBRO,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
C               *****************************
C               **   STEP 6--              **
C               **   WRITE OUT THE TABLE   **
C               *****************************
C
      ISTEPN='6'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CRT5')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
C
      IF(IPRINT.EQ.'OFF')GOTO8000
C
      ITITLE(1:15)='Cross Tabulate '
      IF(ICASCT.EQ.'BPRO')THEN
        NCTITL=37
        ITITLE(16:NCTITL)='Binomial Probabilities'
      ELSEIF(ICASCT.EQ.'MECL')THEN
        NCTITL=37
        ITITLE(16:NCTITL)='Mean Confidence Limits'
      ELSEIF(ICASCT.EQ.'MDCL')THEN
        NCTITL=39
        ITITLE(16:NCTITL)='Median Confidence Limits'
      ELSE
        ITITLE(16:55)=ICTNAM(1:40)
        NCTITL=55
        DO4010I=55,1,-1
          IF(ITITLE(I:I).NE.' ')THEN
            NCTITL=I
            GOTO4019
          ENDIF
 4010   CONTINUE
 4019   CONTINUE
      ENDIF
C
      IF(IYVAR.EQ.'ON')THEN
        ITITL9(1:21)='(Response Variables: '
        NTEMP=21
        ITITL9(22:30)=IYNAM(1:8)
        NTEMP=30
        IF(IXVAR.EQ.'ON')THEN
          ITITL9(30:30)=' '
          ITITL9(31:38)=IXNAM(1:8)
          NTEMP=38
        ENDIF
        IF(IX2VAR.EQ.'ON')THEN
          ITITL9(39:39)='-'
          ITITL9(40:47)=IXNAM2(1:8)
          NTEMP=47
        ENDIF
        NTEMP=NTEMP+1
        ITITL9(NTEMP:NTEMP)=')'
        NCTIT9=NTEMP
      ELSE
        ITITL9=' '
        NCTIT9=0
      ENDIF
C
      ITITL2(1,1)(1:8)=IX1NAM
      NCTIT2(1,1)=8
      ITITL2(1,2)(1:8)=IX2NAM
      NCTIT2(1,2)=8
      ITITL2(1,3)(1:8)=IX3NAM
      NCTIT2(1,3)=8
      ITITL2(1,4)(1:8)=IX4NAM
      NCTIT2(1,4)=8
      ITITL2(1,5)='   |   '
      IF(ICAPTY.EQ.'LATE')THEN
        ITITL2(1,5)='  $|$  '
      ENDIF
      NCTIT2(1,5)=7
C
      NUMLIN=1
      IF(ICASCT.EQ.'BPRO')THEN
        NUMCOL=9
        IF(IBINTA.EQ.'LOWE' .OR. IBINTA.EQ.'UPPE')NUMCOL=8
        ITITL2(1,6)='P'
        NCTIT2(1,6)=1
        ITITL2(1,7)='N'
        NCTIT2(1,7)=1
        IF(IBINTA.EQ.'LOWE')THEN
          ITITL2(1,8)(1:40)='Lower AC'
          NCTIT2(1,8)=8
        ELSEIF(IBINTA.EQ.'UPPE')THEN
          ITITL2(1,8)(1:40)='Upper AC'
          NCTIT2(1,8)=8
        ELSE
          ITITL2(1,8)(1:40)='Lower AC'
          NCTIT2(1,8)=8
          ITITL2(1,9)(1:40)='Upper AC'
          NCTIT2(1,9)=8
        ENDIF
      ELSEIF(ICASCT.EQ.'MECL' .OR. ICASCT.EQ.'MDCL')THEN
        NUMCOL=9
        IF(ICASCT.EQ.'MECL')THEN
          ITITL2(1,6)='Mean'
          NCTIT2(1,6)=4
        ELSE
          ITITL2(1,6)='Median'
          NCTIT2(1,6)=6
        ENDIF
        ITITL2(1,7)='N'
        NCTIT2(1,7)=1
        ITITL2(1,8)='Lower Limit'
        ITITL2(1,8)='Upper Limit'
        NCTIT2(1,9)=11
        NCTIT2(1,9)=11
      ELSE
        NUMCOL=6
        ITITL2(1,6)(1:15)=ICTNAM(1:15)
        NTEMP=15
        DO4070I=15,1,-1
          IF(ITITL2(1,6)(I:I).NE.' ')THEN
            NTEMP=I
            GOTO4079
          ENDIF
 4070   CONTINUE
 4079   CONTINUE
        NCTIT2(1,6)=NTEMP
      ENDIF
C
      NMAX=0
      DO4210I=1,NUMCOL
        VALIGN(I)='b'
        ALIGN(I)='r'
        NTOT(I)=15
        IF(NCTIT2(1,I).GT.NTOT(I))NTOT(I)=NCTIT2(1,I)
        NMAX=NMAX+NTOT(I)
        IDIGIT(I)=NUMDIG
        ITYPCO(I)='NUME'
        IF(I.EQ.7)THEN
          NTOT(I)=8
          IDIGIT(I)=0
        ELSEIF(I.EQ.5)THEN
          ITYPCO(I)='ALPHA'
          NTOT(I)=7
          IDIGIT(I)=-1
CCCCC   ELSEIF(I.EQ.6)THEN
CCCCC     IF(ICASCT.NE.'BPRO' .AND. ICASCT.NE.'MECL' .AND.
CCCCC1       ICASCT.NE.'MDCL')THEN
CCCCC        ALIGN(I)='l'
CCCCC     ENDIF
        ENDIF
 4210 CONTINUE
C
      IWHTML(1)=125
      IWHTML(2)=125
      IWHTML(3)=125
      IWHTML(4)=125
      IWHTML(5)=25
      IWHTML(6)=125
      IWHTML(7)=75
      IWHTML(8)=125
      IWHTML(9)=125
      IJUNK=1300
      IF(ICASCT.EQ.'BPRO')IJUNK=1100
      IF(ICASCT.EQ.'MECL')IJUNK=1100
      IF(ICASCT.EQ.'MDCL')IJUNK=1100
      IWRTF(1)=IJUNK
      IWRTF(2)=IWRTF(1)+IJUNK
      IWRTF(3)=IWRTF(2)+IJUNK
      IWRTF(4)=IWRTF(3)+IJUNK
      IWRTF(5)=IWRTF(4)+200
      IWRTF(6)=IWRTF(5)+IJUNK
      IWRTF(7)=IWRTF(6)+800
      IWRTF(8)=IWRTF(7)+IJUNK
      IWRTF(9)=IWRTF(8)+IJUNK
      IFRST=.TRUE.
      ILAST=.TRUE.
      IFLAGS=.TRUE.
      IFLAGE=.FALSE.
      ICALL=0
C
      ICNT=0
      DO4310I=1,N2
        IF(ICNT.GE.30)THEN
          IF(I.EQ.N2)IFLAGE=.TRUE.
          CALL DPDTA5(ITITLE,NCTITL,
     1                ITITL9,NCTIT9,ITITL2,NCTIT2,
     1                MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1                IVALUE,NCVALU,AMAT,ITYPCO,MAXROW,ICNT,
     1                IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1                ICAPSW,ICAPTY,IFRST,ILAST,
     1                IFLAGS,IFLAGE,
     1                ISUBRO,IBUGA3,IERROR)
          IFRST=.FALSE.
          IFLAGS=.FALSE.
          ICALL=1
          ICNT=0
        ENDIF
        ICNT=ICNT+1
        NCTEXT(ICNT)=0
        AMAT(ICNT,1)=X2(I)
        AMAT(ICNT,2)=D2(I)
        AMAT(ICNT,3)=DSIZE(I)
        AMAT(ICNT,4)=DCOLOR(I)
        AMAT(ICNT,5)=0.0
        AMAT(ICNT,6)=Y2(I)
        IF(ICASCT.EQ.'BPRO' .AND. IBINTA.EQ.'LOWE')THEN
          AMAT(ICNT,7)=XNTRIA(I)
          AMAT(ICNT,8)=XACLOW(I)
        ELSEIF(ICASCT.EQ.'BPRO' .AND. IBINTA.EQ.'UPPE')THEN
          AMAT(ICNT,7)=XNTRIA(I)
          AMAT(ICNT,8)=XACUPP(I)
        ELSEIF(ICASCT.EQ.'BPRO')THEN
          AMAT(ICNT,7)=XNTRIA(I)
          AMAT(ICNT,8)=XACLOW(I)
          AMAT(ICNT,9)=XACUPP(I)
        ELSEIF(ICASCT.EQ.'MECL' .OR. ICASCT.EQ.'MDCL')THEN
          AMAT(ICNT,7)=XNTRIA(I)
          AMAT(ICNT,8)=XACLOW(I)
          AMAT(ICNT,9)=XACUPP(I)
        ENDIF
        DO4320J=1,NUMCOL
          IF(J.EQ.5)THEN
            NCVALU(ICNT,J)=7
            IVALUE(ICNT,J)='   |   '
            IF(ICAPTY.EQ.'LATE')THEN
              IVALUE(ICNT,J)='  $|$  '
            ENDIF
          ELSE
            NCVALU(ICNT,J)=0
            IVALUE(ICNT,J)=' '
          ENDIF
 4320   CONTINUE
 4310 CONTINUE
C
      IF(ICNT.GE.1)THEN
        IFLAGE=.TRUE.
        ILAST=.TRUE.
        CALL DPDTA5(ITITLE,NCTITL,
     1              ITITL9,NCTIT9,ITITL2,NCTIT2,
     1              MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1              IVALUE,NCVALU,AMAT,ITYPCO,MAXROW,ICNT,
     1              IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1              ICAPSW,ICAPTY,IFRST,ILAST,
     1              IFLAGS,IFLAGE,
     1              ISUBRO,IBUGA3,IERROR)
      ENDIF
C
 8000 CONTINUE
      IF(IFEEDB.EQ.'ON')THEN
        WRITE(ICOUT,9212)
 9212   FORMAT(6X,'GROUP-IDs AND STATISTIC WRITTEN TO FILE ',
     1         'DPST1F.DAT')
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               ******************
C               **   STEP 90--  **
C               **   EXIT       **
C               ******************
C
 9000 CONTINUE
C
      IF(IBFLAG.EQ.'BRAT')THEN
        ICASCT='BRAT'
      ENDIF
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'CRT5')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPCRT5--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)ICASCT,N,N2,IERROR
 9012   FORMAT('ICASCT,N,N2,IERROR = ',A4,2I8,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)NUMV2
 9013   FORMAT('NUMV2 = ',I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9015)NUMSE1,NUMSE2,NUMSE3,NUMSE4
 9015   FORMAT('NUMSE1,NUMSE2,NUMSE3,NUMSE4 = ',4I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9016)ANUMS1,ANUMS2,ANUMS3,ANUMS4
 9016   FORMAT('ANUMS1,ANUMS2,ANUMS3,ANUMS4 = ',4G15.7)
        CALL DPWRST('XXX','BUG ')
        DO9020I=1,N2
          WRITE(ICOUT,9021)I,Y2(I),X2(I),DSIZE(I),D2(I)
 9021     FORMAT('I,Y2(I),X2(I),DSIZE(I),D2(I) = ',I8,4G15.7)
          CALL DPWRST('XXX','BUG ')
 9020   CONTINUE
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPCRT6(Y,Z,Z2,TAG1,TAG2,TAG3,TAG4,TAG5,N,
     1                  NUMV2,ICASCT,ICTNAM,
     1                  XIDTEM,XIDTE2,XIDTE3,XIDTE4,XIDTE5,
     1                  NUMSE1,NUMSE2,NUMSE3,NUMSE4,NUMSE5,
     1                  TEMP,TEMPZ,TEMPZ2,XTEMP1,XTEMP2,XTEMP3,
     1                  XNTRIA,XACLOW,XACUPP,
     1                  ITEMP1,ITEMP2,ITEMP3,ITEMP4,ITEMP5,ITEMP6,
     1                  DTEMP1,DTEMP2,DTEMP3,
     1                  ISEED,ALPHA,
     1                  IXVAR,IX2VAR,IYVAR,
     1                  IYNAM,IXNAM,IXNAM2,
     1                  IX1NAM,IX2NAM,IX3NAM,IX4NAM,IX5NAM,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  MAXNXT,
     1                  Y2,X2,D2,DSIZE,DCOLOR,DFILL,N2,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--GENERATE A FIVE-WAY CROSS-TABULATION AND
C              OPTIONALLY PRINT THE RESULTS TO AN ASCII,
C              HTML, LATEX, OR RTF TABLE.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     REFERENCE--ASTM MANUAL STP-15D, PAGES 78-84, 100-105
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2008/4
C     ORIGINAL VERSION--APRIL     2008.
C     UPDATED         --SEPTEMBER 2008. ACCOMODATE "MISSING" DATA
C     UPDATED         --JANUARY   2010. TREAT BINOMIAL RATIO IN A
C                                       SIMILAR FASHION TO BINOMIAL
C     UPDATED         --JUNE      2010. CALL LIST TO CMPSTA
C     UPDATED         --JUNE      2010. USE DPDTA5 TO PRINT TABLE
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICASCT
      CHARACTER*40 ICTNAM
      CHARACTER*4 IXVAR
      CHARACTER*4 IX2VAR
      CHARACTER*4 IYVAR
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      PARAMETER(NUMCLI=10)
      PARAMETER(MAXLIN=2)
      PARAMETER (MAXROW=30)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*60 ITITL9
      CHARACTER*60 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(NUMCLI)
      CHARACTER*4  VALIGN(NUMCLI)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      CHARACTER*60 ITITL2(MAXLIN,NUMCLI)
      CHARACTER*15 IVALUE(MAXROW,NUMCLI)
      CHARACTER*4  ITYPCO(NUMCLI)
      INTEGER      NCTIT2(MAXLIN,NUMCLI)
      INTEGER      NCVALU(MAXROW,NUMCLI)
      INTEGER      IWHTML(NUMCLI)
      INTEGER      IWRTF(NUMCLI)
      REAL         AMAT(MAXROW,NUMCLI)
      LOGICAL IFRST
      LOGICAL ILAST
      LOGICAL IFLAG1
      LOGICAL IFLAG2
      LOGICAL IFLAG3
      LOGICAL IFLAGS
      LOGICAL IFLAGE
      CHARACTER*1 IBASLC
C
      CHARACTER*8 IYNAM
      CHARACTER*8 IXNAM
      CHARACTER*8 IXNAM2
      CHARACTER*8 IX1NAM
      CHARACTER*8 IX2NAM
      CHARACTER*8 IX3NAM
      CHARACTER*8 IX4NAM
      CHARACTER*8 IX5NAM
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IWRITE
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*10 ICONC1
      CHARACTER*10 ICONC2
C
      CHARACTER*4 IBFLAG
      CHARACTER*4 ISUBN0
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION Z(*)
      DIMENSION Z2(*)
      DIMENSION XIDTEM(*)
      DIMENSION XIDTE2(*)
      DIMENSION XIDTE3(*)
      DIMENSION XIDTE4(*)
      DIMENSION XIDTE5(*)
      DIMENSION Y2(*)
      DIMENSION X2(*)
      DIMENSION D2(*)
      DIMENSION DSIZE(*)
      DIMENSION DCOLOR(*)
      DIMENSION DFILL(*)
C
      DIMENSION TAG1(*)
      DIMENSION TAG2(*)
      DIMENSION TAG3(*)
      DIMENSION TAG4(*)
      DIMENSION TAG5(*)
      DIMENSION TEMP(*)
      DIMENSION TEMPZ(*)
      DIMENSION TEMPZ2(*)
      DIMENSION XTEMP1(*)
      DIMENSION XTEMP2(*)
      DIMENSION XTEMP3(*)
      DIMENSION XNTRIA(*)
      DIMENSION XACLOW(*)
      DIMENSION XACUPP(*)
C
      INTEGER ITEMP1(*)
      INTEGER ITEMP2(*)
      INTEGER ITEMP3(*)
      INTEGER ITEMP4(*)
      INTEGER ITEMP5(*)
      INTEGER ITEMP6(*)
C
      DOUBLE PRECISION DTEMP1(*)
      DOUBLE PRECISION DTEMP2(*)
      DOUBLE PRECISION DTEMP3(*)
C
      CHARACTER*4 IOP
C
      INCLUDE 'DPCOST.INC'
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPCR'
      ISUBN2='T6  '
C
      I2=0
C
      AN=INT(N+0.01)
      ANUMS1=INT(NUMSE1+0.01)
      ANUMS2=INT(NUMSE2+0.01)
      ANUMS3=INT(NUMSE3+0.01)
      ANUMS4=INT(NUMSE4+0.01)
      ANUMS5=INT(NUMSE5+0.01)
C
C               ***********************************************
C               **  STEP 5--                                 **
C               **  COMPUTE THE VARIOUS CROSS-TAB STATISTICS **
C               ***********************************************
C
      ISTEPN='5.1'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CRT6')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     ALLOW THE   SET WRITE DECIMALS COMMAND    TO BE USED TO
C     DETERMINE HOW MANY DIGITS PRINTED IN TABLE.
C
      NUMDIG=-7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=10
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
C     NOTE 9/2008: IN FOLLOWING, WE NEED TO DISTINGUISH BETWEEN
C                  EMPTY SETS DUE TO NO POINTS FALLING IN THE
C                  PARTICULAR CROSS TABULATION (IN WHICH CASE,
C                  WE WANT TO SKIP IN THE OUTPUT FILE) AND EMPTY
C                  SETS DUE TO ALL POINTS IN THE PARTICULAR
C                  CROSS TABULATION BEING MISSING (IN WHICH CASE,
C                  WE MAY WANT TO WRITE A 0 OR A MISSING VALUE).
C
C                  THERE ARE 2 MISSING VALUES:
C
C                  PSTAMV   - SPECIFIES WHETHER THE INPUT DATA
C                             VALUE IS TO BE INCLUDED IN THE
C                             COMPUTATION OF THE STATISTIC
C
C                  PCTAMV    - IF ALL THE DATA IS MISSING, THIS
C                              IS THE VALUE TO USE IN WRITING THE
C                              CROSS TABULATE OUTPUT.
C
      IWRITE='OFF'
      IBFLAG=ICASCT
      IF(IBFLAG.EQ.'BRAT')IBFLAG='BPRO'
C
      EPS=0.1E-7
      J=0
      NRESP=NUMV2-5
      DO1110ISET1=1,NUMSE1
        DO1120ISET2=1,NUMSE2
          DO1130ISET3=1,NUMSE3
          DO1140ISET4=1,NUMSE4
          DO1150ISET5=1,NUMSE5
C
            K=0
            NTEMP2=0
            DO1180I=1,N
              IF(XIDTEM(ISET1).EQ.TAG1(I) .AND.
     1           XIDTE2(ISET2).EQ.TAG2(I) .AND.
     1           XIDTE3(ISET3).EQ.TAG3(I) .AND.
     1           XIDTE4(ISET4).EQ.TAG4(I) .AND.
     1           XIDTE5(ISET5).EQ.TAG5(I))
     1           GOTO1181
              GOTO1180
 1181         CONTINUE
C
              NTEMP2=NTEMP2+1
              IF(IYVAR.EQ.'OFF')THEN
                K=K+1
                TEMP(K)=0.0
              ELSE
                IF(ABS(Y(I)-PSTAMV).GT.EPS)THEN
                  K=K+1
                  TEMP(K)=Y(I)
                  IF(IXVAR.EQ.'ON')TEMPZ(K)=Z(I)
                  IF(IX2VAR.EQ.'ON')TEMPZ2(K)=Z2(I)
                ENDIF
              ENDIF
 1180       CONTINUE
            NTEMP=K
C
C           AUGUST 2002.  CALL CMPSTA (EXCEPT FOR CHI-SQUARE CASE)
C
C           NTEMP2 IS THE NUMBER OF POINTS IN THE SUBSET AND
C           NTEMP IS THE NUMBER OF NON-MISSING POINTS IN THE SUBSET.
C
            IF(NTEMP2.EQ.0)GOTO1150
C
            IF(NTEMP.EQ.0)THEN
              IF(ICTAMV.EQ.'ZERO')THEN
                STAT=0.0
                IF(IBFLAG.EQ.'BPRO' .OR. ICASCT.EQ.'MECL' .OR.
     1             ICASCT.EQ.'MDCL')THEN
                  NTRIAL=0
                  ALOWLM=0.0
                  AUPPLM=0.0
                ENDIF
              ELSEIF(ICTAMV.EQ.'MV  ')THEN
                STAT=PCTAMV
                IF(IBFLAG.EQ.'BPRO' .OR. ICASCT.EQ.'MECL' .OR.
     1             ICASCT.EQ.'MDCL')THEN
                  NTRIAL=0
                  ALOWLM=PCTAMV
                  AUPPLM=PCTAMV
                ENDIF
              ELSE
                GOTO1150
              ENDIF
            ELSE
              CALL CMPSTA(
     1              TEMP,TEMPZ,TEMPZ2,XTEMP1,XTEMP2,XTEMP3,
     1              MAXNXT,NTEMP,NTEMP,NTEMP,
     1              NRESP,ICASCT,
     1              ISEED,ITEMP1,ITEMP2,ITEMP3,ITEMP4,ITEMP5,ITEMP6,
     1              DTEMP1,DTEMP2,DTEMP3,
CCCCC1              IQUAME,IQUASE,PSTAMV,
     1              STAT,
     1              ISUBRO,IBUGA3,IERROR)
              IF(IERROR.EQ.'YES')GOTO9000
              IF(IBFLAG.EQ.'BPRO')THEN
                PTEMP=STAT
                NTRIAL=NTEMP
                IF(ICASCT.EQ.'BRAT')NTRIAL=ITEMP1(1)
                IF(STAT.EQ.PSTAMV)THEN
                  ALOWLM=PSTAMV
                  AUPPLM=PSTAMV
                ELSE
                  ALPHAT=ALPHA
                  CALL DPAGCO(PTEMP,NTRIAL,ALPHAT,IWRITE,
     1                        ALOWLM,AUPPLM,IBUGA3,IERROR)
                ENDIF
              ELSEIF(ICASCT.EQ.'MECL')THEN
                XMEAN=STAT
                NTRIAL=NTEMP
                IF(STAT.EQ.PSTAMV)THEN
                  ALOWLM=PSTAMV
                  AUPPLM=PSTAMV
                ELSE
                  CALL SD(TEMP,NTEMP,IWRITE,XSD,IBUGA3,IERROR)
                  ALPHAT=ALPHA
                  CALL DPMECL(XMEAN,XSD,NTEMP,ALPHAT,IWRITE,
     1                        ALOWLM,AUPPLM,IBUGA3,IERROR)
                ENDIF
              ELSEIF(ICASCT.EQ.'MDCL')THEN
                XMED=STAT
                NTRIAL=NTEMP
                IF(STAT.EQ.PSTAMV)THEN
                  ALOWLM=PSTAMV
                  AUPPLM=PSTAMV
                ELSE
                  XQ=0.5
                  CALL QUANSE(XQ,TEMP,NTEMP,IWRITE,XTEMP1,MAXNXT,IQUASE,
     1                        QUASE,IBUGA3,IERROR)
                  ALPHAT=ALPHA
                  CALL DPMECL(XMED,QUASE,NTEMP,ALPHAT,IWRITE,
     1                        ALOWLM,AUPPLM,IBUGA3,IERROR)
                ENDIF
              ENDIF
            ENDIF
C
            J=J+1
            Y2(J)=STAT
            X2(J)=XIDTEM(ISET1)
            D2(J)=XIDTE2(ISET2)
            DSIZE(J)=XIDTE3(ISET3)
            DCOLOR(J)=XIDTE4(ISET4)
            DFILL(J)=XIDTE5(ISET5)
            IF(IBFLAG.EQ.'BPRO' .OR. ICASCT.EQ.'MECL' .OR.
     1         ICASCT.EQ.'MDCL')THEN
              XNTRIA(J)=REAL(NTRIAL)
              XACLOW(J)=ALOWLM
              XACUPP(J)=AUPPLM
            ENDIF
C
 1150     CONTINUE
 1140     CONTINUE
 1130     CONTINUE
 1120   CONTINUE
 1110 CONTINUE
      N2=J
C
      IF(ICASCT.EQ.'BRAT')THEN
        IBFLAG='BRAT'
        ICASCT='BPRO'
      ENDIF
C
      IOP='OPEN'
      IFLG11=1
      IFLG21=0
      IFLG31=0
      IFLAG4=0
      IFLAG5=0
      CALL DPAUFI(IOP,IFLG11,IFLG21,IFLG31,IFLAG4,IFLAG5,
     1            IOUNI1,IOUNI2,IOUNI3,IOUNI4,IOUNI5,
     1            IBUGA3,ISUBRO,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      WRITE(IOUNI1,2111)ICTNAM
 2111 FORMAT(' GROUP-ID 1   GROUP-ID 2   GROUP-ID 3   GROUP-ID 4',
     1       '   GROUP-ID 5           ',A40)
C
      IF(ICASCT.EQ.'BPRO')THEN
        DO2170I=1,N2
          IF(IBINTA.EQ.'LOWE')THEN
            WRITE(IOUNI1,2171)X2(I),D2(I),DSIZE(I),DCOLOR(I),DFILL(I),
     1                        Y2(I),XNTRIA(I),XACLOW(I)
 2171       FORMAT(8E17.9)
          ELSEIF(IBINTA.EQ.'UPPE')THEN
            WRITE(IOUNI1,2171)X2(I),D2(I),DSIZE(I),DCOLOR(I),DFILL(I),
     1                        Y2(I),XNTRIA(I),XACUPP(I)
          ELSE
            WRITE(IOUNI1,2173)X2(I),D2(I),DSIZE(I),DCOLOR(I),DFILL(I),
     1                        Y2(I),XNTRIA(I),
     1                        XACLOW(I),XACUPP(I)
 2173       FORMAT(9E17.9)
          ENDIF
 2170   CONTINUE
      ELSEIF(ICASCT.EQ.'MECL' .OR. ICASCT.EQ.'MDCL')THEN
        DO2175I=1,N2
          WRITE(IOUNI1,2173)X2(I),D2(I),DSIZE(I),DCOLOR(I),DFILL(I),
     1                      Y2(I),XNTRIA(I),XACLOW(I),XACUPP(I)
 2175   CONTINUE
      ELSE
        DO2160I=1,N2
          WRITE(IOUNI1,2161)X2(I),D2(I),DSIZE(I),DCOLOR(I),DFILL(I),
     1                      Y2(I)
 2161     FORMAT(6E17.9)
 2160   CONTINUE
      ENDIF
C
      IOP='CLOS'
      CALL DPAUFI(IOP,IFLG11,IFLG21,IFLG31,IFLAG4,IFLAG5,
     1            IOUNI1,IOUNI2,IOUNI3,IOUNI4,IOUNI5,
     1            IBUGA3,ISUBRO,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
C               *****************************
C               **   STEP 6--              **
C               **   WRITE OUT THE TABLE   **
C               *****************************
C
      ISTEPN='6'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CRT6')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
C
      IF(IPRINT.EQ.'OFF')GOTO8000
C
      ITITLE(1:15)='Cross Tabulate '
      IF(ICASCT.EQ.'BPRO')THEN
        NCTITL=37
        ITITLE(16:NCTITL)='Binomial Probabilities'
      ELSEIF(ICASCT.EQ.'MECL')THEN
        NCTITL=37
        ITITLE(16:NCTITL)='Mean Confidence Limits'
      ELSEIF(ICASCT.EQ.'MDCL')THEN
        NCTITL=39
        ITITLE(16:NCTITL)='Median Confidence Limits'
      ELSE
        ITITLE(16:55)=ICTNAM(1:40)
        NCTITL=55
        DO4010I=55,1,-1
          IF(ITITLE(I:I).NE.' ')THEN
            NCTITL=I
            GOTO4019
          ENDIF
 4010   CONTINUE
 4019   CONTINUE
      ENDIF
C
      IF(IYVAR.EQ.'ON')THEN
        ITITL9(1:21)='(Response Variables: '
        NTEMP=21
        ITITL9(22:30)=IYNAM(1:8)
        NTEMP=30
        IF(IXVAR.EQ.'ON')THEN
          ITITL9(30:30)=' '
          ITITL9(31:38)=IXNAM(1:8)
          NTEMP=38
        ENDIF
        IF(IX2VAR.EQ.'ON')THEN
          ITITL9(39:39)=' '
          ITITL9(40:47)=IXNAM2(1:8)
          NTEMP=47
        ENDIF
        NTEMP=NTEMP+1
        ITITL9(NTEMP:NTEMP)=')'
        NCTIT9=NTEMP
      ELSE
        ITITL9=' '
        NCTIT9=0
      ENDIF
C
      ITITL2(1,1)(1:8)=IX1NAM
      NCTIT2(1,1)=8
      ITITL2(1,2)(1:8)=IX2NAM
      NCTIT2(1,2)=8
      ITITL2(1,3)(1:8)=IX3NAM
      NCTIT2(1,3)=8
      ITITL2(1,4)(1:8)=IX4NAM
      NCTIT2(1,4)=8
      ITITL2(1,5)(1:8)=IX5NAM
      NCTIT2(1,5)=8
      ITITL2(1,6)='   |   '
      IF(ICAPTY.EQ.'LATE')THEN
        ITITL2(1,6)='  $|$  '
      ENDIF
      NCTIT2(1,6)=7
C
      NUMLIN=1
      IF(ICASCT.EQ.'BPRO')THEN
        NUMCOL=10
        IF(IBINTA.EQ.'LOWE' .OR. IBINTA.EQ.'UPPE')NUMCOL=9
        ITITL2(1,7)='P'
        NCTIT2(1,7)=1
        ITITL2(1,8)='N'
        NCTIT2(1,8)=1
        IF(IBINTA.EQ.'LOWE')THEN
          ITITL2(1,9)(1:40)='Lower AC'
          NCTIT2(1,9)=8
        ELSEIF(IBINTA.EQ.'UPPE')THEN
          ITITL2(1,9)(1:40)='Upper AC'
          NCTIT2(1,9)=8
        ELSE
          ITITL2(1,9)(1:40)='Lower AC'
          NCTIT2(1,9)=8
          ITITL2(1,10)(1:40)='Upper AC'
          NCTIT2(1,10)=8
        ENDIF
      ELSEIF(ICASCT.EQ.'MECL' .OR. ICASCT.EQ.'MDCL')THEN
        NUMCOL=10
        IF(ICASCT.EQ.'MECL')THEN
          ITITL2(1,7)='Mean'
          NCTIT2(1,7)=4
        ELSE
          ITITL2(1,7)='Median'
          NCTIT2(1,7)=6
        ENDIF
        ITITL2(1,8)='N'
        NCTIT2(1,8)=1
        ITITL2(1,9)='Lower Limit'
        ITITL2(1,9)='Upper Limit'
        NCTIT2(1,10)=11
        NCTIT2(1,10)=11
      ELSE
        NUMCOL=7
        ITITL2(1,7)(1:15)=ICTNAM(1:15)
        NTEMP=15
        DO4070I=15,1,-1
          IF(ITITL2(1,7)(I:I).NE.' ')THEN
            NTEMP=I
            GOTO4079
          ENDIF
 4070   CONTINUE
 4079   CONTINUE
        NCTIT2(1,7)=NTEMP
      ENDIF
C
      NMAX=0
      DO4210I=1,NUMCOL
        VALIGN(I)='b'
        ALIGN(I)='r'
        NTOT(I)=15
        IF(NCTIT2(1,I).GT.NTOT(I))NTOT(I)=NCTIT2(1,I)
        NMAX=NMAX+NTOT(I)
        IDIGIT(I)=NUMDIG
        ITYPCO(I)='NUME'
        IF(I.EQ.8)THEN
          NTOT(I)=8
          IDIGIT(I)=0
        ELSEIF(I.EQ.6)THEN
          ITYPCO(I)='ALPHA'
          NTOT(I)=7
          IDIGIT(I)=-1
CCCCC   ELSEIF(I.EQ.6)THEN
CCCCC     IF(ICASCT.NE.'BPRO' .AND. ICASCT.NE.'MECL' .AND.
CCCCC1       ICASCT.NE.'MDCL')THEN
CCCCC        ALIGN(I)='l'
CCCCC     ENDIF
        ENDIF
 4210 CONTINUE
C
      IWHTML(1)=100
      IWHTML(2)=100
      IWHTML(3)=100
      IWHTML(4)=100
      IWHTML(5)=100
      IWHTML(6)=25
      IWHTML(7)=100
      IWHTML(8)=75
      IWHTML(9)=100
      IWHTML(10)=100
      IJUNK=1300
      IF(ICASCT.EQ.'BPRO' .OR. ICASCT.EQ.'MECL' .OR.
     1   ICASCT.EQ.'MDCL')THEN
        IJUNK=1000
        IPTSAV=IRTFPS
        IRTFPS=16
        CALL DPCONA(92,IBASLC)
        WRITE(ICOUT,7003)IBASLC,IRTFPS
 7003   FORMAT(A1,'fs',I2)
        CALL DPWRST('XXX','WRIT')
      ENDIF
      IWRTF(1)=IJUNK
      IWRTF(2)=IWRTF(1)+IJUNK
      IWRTF(3)=IWRTF(2)+IJUNK
      IWRTF(4)=IWRTF(3)+IJUNK
      IWRTF(5)=IWRTF(4)+IJUNK
      IWRTF(6)=IWRTF(5)+200
      IWRTF(7)=IWRTF(6)+IJUNK
      IWRTF(8)=IWRTF(7)+800
      IWRTF(9)=IWRTF(8)+IJUNK
      IWRTF(10)=IWRTF(9)+IJUNK
      IFRST=.TRUE.
      ILAST=.TRUE.
      IFLAGS=.TRUE.
      IFLAGE=.FALSE.
      ICALL=0
C
      ICNT=0
      DO4310I=1,N2
        IF(ICNT.GE.30)THEN
          IF(I.EQ.N2)IFLAGE=.TRUE.
          CALL DPDTA5(ITITLE,NCTITL,
     1                ITITL9,NCTIT9,ITITL2,NCTIT2,
     1                MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1                IVALUE,NCVALU,AMAT,ITYPCO,MAXROW,ICNT,
     1                IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1                ICAPSW,ICAPTY,IFRST,ILAST,
     1                IFLAGS,IFLAGE,
     1                ISUBRO,IBUGA3,IERROR)
          IFRST=.FALSE.
          IFLAGS=.FALSE.
          ICALL=1
          ICNT=0
        ENDIF
        ICNT=ICNT+1
        NCTEXT(ICNT)=0
        AMAT(ICNT,1)=X2(I)
        AMAT(ICNT,2)=D2(I)
        AMAT(ICNT,3)=DSIZE(I)
        AMAT(ICNT,4)=DCOLOR(I)
        AMAT(ICNT,5)=DFILL(I)
        AMAT(ICNT,6)=0.0
        AMAT(ICNT,7)=Y2(I)
        IF(ICASCT.EQ.'BPRO' .AND. IBINTA.EQ.'LOWE')THEN
          AMAT(ICNT,8)=XNTRIA(I)
          AMAT(ICNT,9)=XACLOW(I)
        ELSEIF(ICASCT.EQ.'BPRO' .AND. IBINTA.EQ.'UPPE')THEN
          AMAT(ICNT,8)=XNTRIA(I)
          AMAT(ICNT,9)=XACUPP(I)
        ELSEIF(ICASCT.EQ.'BPRO')THEN
          AMAT(ICNT,8)=XNTRIA(I)
          AMAT(ICNT,9)=XACLOW(I)
          AMAT(ICNT,10)=XACUPP(I)
        ELSEIF(ICASCT.EQ.'MECL' .OR. ICASCT.EQ.'MDCL')THEN
          AMAT(ICNT,8)=XNTRIA(I)
          AMAT(ICNT,9)=XACLOW(I)
          AMAT(ICNT,10)=XACUPP(I)
        ENDIF
        DO4320J=1,NUMCOL
          IF(J.EQ.6)THEN
            NCVALU(ICNT,J)=7
            IVALUE(ICNT,J)='   |   '
            IF(ICAPTY.EQ.'LATE')THEN
              IVALUE(ICNT,J)='  $|$  '
            ENDIF
          ELSE
            NCVALU(ICNT,J)=0
            IVALUE(ICNT,J)=' '
          ENDIF
 4320   CONTINUE
 4310 CONTINUE
C
      IF(ICNT.GE.1)THEN
        IFLAGE=.TRUE.
        ILAST=.TRUE.
        CALL DPDTA5(ITITLE,NCTITL,
     1              ITITL9,NCTIT9,ITITL2,NCTIT2,
     1              MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1              IVALUE,NCVALU,AMAT,ITYPCO,MAXROW,ICNT,
     1              IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1              ICAPSW,ICAPTY,IFRST,ILAST,
     1              IFLAGS,IFLAGE,
     1              ISUBRO,IBUGA3,IERROR)
      ENDIF
C
      IF(ICASCT.EQ.'BPRO' .OR. ICASCT.EQ.'MECL' .OR.
     1   ICASCT.EQ.'MDCL')THEN
        IJUNK=1000
        IRTFPS=IPTSAV
        WRITE(ICOUT,7003)IBASLC,IRTFPS
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
 8000 CONTINUE
      IF(IFEEDB.EQ.'ON')THEN
        WRITE(ICOUT,9212)
 9212   FORMAT(6X,'GROUP-IDs AND STATISTIC WRITTEN TO FILE ',
     1         'DPST1F.DAT')
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               ******************
C               **   STEP 90--  **
C               **   EXIT       **
C               ******************
C
 9000 CONTINUE
C
      IF(IBFLAG.EQ.'BRAT')THEN
        ICASCT='BRAT'
      ENDIF
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'CRT6')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPCRT6--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)ICASCT,N,N2,IERROR
 9012   FORMAT('ICASCT,N,N2,IERROR = ',A4,2I8,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)NUMV2
 9013   FORMAT('NUMV2 = ',I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9015)NUMSE1,NUMSE2,NUMSE3,NUMSE4,NUMSE5
 9015   FORMAT('NUMSE1,NUMSE2,NUMSE3,NUMSE4,NUMSE5 = ',5I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9016)ANUMS1,ANUMS2,ANUMS3,ANUMS4,ANUMSE5
 9016   FORMAT('ANUMS1,ANUMS2,ANUMS3,ANUMS4,ANUMSE5 = ',5G15.7)
        CALL DPWRST('XXX','BUG ')
        DO9020I=1,N2
          WRITE(ICOUT,9021)I,Y2(I),X2(I),DSIZE(I),D2(I)
 9021     FORMAT('I,Y2(I),X2(I),DSIZE(I),D2(I) = ',I8,4G15.7)
          CALL DPWRST('XXX','BUG ')
 9020   CONTINUE
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPCRT7(Y,Z,Z2,TAG1,TAG2,TAG3,TAG4,TAG5,TAG6,N,
     1                  NUMV2,ICASCT,ICTNAM,
     1                  XIDTEM,XIDTE2,XIDTE3,XIDTE4,XIDTE5,XIDTE6,
     1                  NUMSE1,NUMSE2,NUMSE3,NUMSE4,NUMSE5,NUMSE6,
     1                  TEMP,TEMPZ,TEMPZ2,XTEMP1,XTEMP2,XTEMP3,
     1                  XNTRIA,XACLOW,XACUPP,
     1                  ITEMP1,ITEMP2,ITEMP3,ITEMP4,ITEMP5,ITEMP6,
     1                  DTEMP1,DTEMP2,DTEMP3,
     1                  ISEED,ALPHA,
     1                  IXVAR,IX2VAR,IYVAR,
     1                  IYNAM,IXNAM,IXNAM2,
     1                  IX1NAM,IX2NAM,IX3NAM,IX4NAM,IX5NAM,IX6NAM,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  MAXNXT,
     1                  Y2,X2,D2,DSIZE,DCOLOR,DFILL,DSYMB,N2,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--GENERATE A SIX-WAY CROSS-TABULATION AND
C              OPTIONALLY PRINT THE RESULTS TO AN ASCII,
C              HTML, LATEX, OR RTF TABLE.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     REFERENCE--ASTM MANUAL STP-15D, PAGES 78-84, 100-105
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2008/4
C     ORIGINAL VERSION--APRIL     2008.
C     UPDATED         --SEPTEMBER 2008. ACCOMODATE "MISSING" DATA
C     UPDATED         --JANUARY   2010. TREAT BINOMIAL RATIO IN A
C                                       SIMILAR FASHION TO BINOMIAL
C     UPDATED         --JUNE      2010. CALL LIST TO CMPSTA
C     UPDATED         --JUNE      2010. USE DPDTA5 TO PRINT TABLE
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICASCT
      CHARACTER*40 ICTNAM
      CHARACTER*4 IXVAR
      CHARACTER*4 IX2VAR
      CHARACTER*4 IYVAR
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      PARAMETER(NUMCLI=11)
      PARAMETER(MAXLIN=2)
      PARAMETER (MAXROW=30)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*60 ITITL9
      CHARACTER*60 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(NUMCLI)
      CHARACTER*4  VALIGN(NUMCLI)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      CHARACTER*60 ITITL2(MAXLIN,NUMCLI)
      CHARACTER*15 IVALUE(MAXROW,NUMCLI)
      CHARACTER*4  ITYPCO(NUMCLI)
      INTEGER      NCTIT2(MAXLIN,NUMCLI)
      INTEGER      NCVALU(MAXROW,NUMCLI)
      INTEGER      IWHTML(NUMCLI)
      INTEGER      IWRTF(NUMCLI)
      REAL         AMAT(MAXROW,NUMCLI)
      LOGICAL IFRST
      LOGICAL ILAST
      LOGICAL IFLAG1
      LOGICAL IFLAG2
      LOGICAL IFLAG3
      LOGICAL IFLAGS
      LOGICAL IFLAGE
      CHARACTER*1 IBASLC
C
      CHARACTER*8 IYNAM
      CHARACTER*8 IXNAM
      CHARACTER*8 IXNAM2
      CHARACTER*8 IX1NAM
      CHARACTER*8 IX2NAM
      CHARACTER*8 IX3NAM
      CHARACTER*8 IX4NAM
      CHARACTER*8 IX5NAM
      CHARACTER*8 IX6NAM
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IWRITE
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*10 ICONC1
      CHARACTER*10 ICONC2
C
      CHARACTER*4 IBFLAG
      CHARACTER*4 ISUBN0
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION Z(*)
      DIMENSION Z2(*)
      DIMENSION XIDTEM(*)
      DIMENSION XIDTE2(*)
      DIMENSION XIDTE3(*)
      DIMENSION XIDTE4(*)
      DIMENSION XIDTE5(*)
      DIMENSION XIDTE6(*)
      DIMENSION Y2(*)
      DIMENSION X2(*)
      DIMENSION D2(*)
      DIMENSION DSIZE(*)
      DIMENSION DCOLOR(*)
      DIMENSION DFILL(*)
      DIMENSION DSYMB(*)
C
      DIMENSION TAG1(*)
      DIMENSION TAG2(*)
      DIMENSION TAG3(*)
      DIMENSION TAG4(*)
      DIMENSION TAG5(*)
      DIMENSION TAG6(*)
      DIMENSION TEMP(*)
      DIMENSION TEMPZ(*)
      DIMENSION TEMPZ2(*)
      DIMENSION XTEMP1(*)
      DIMENSION XTEMP2(*)
      DIMENSION XTEMP3(*)
      DIMENSION XNTRIA(*)
      DIMENSION XACLOW(*)
      DIMENSION XACUPP(*)
C
      INTEGER ITEMP1(*)
      INTEGER ITEMP2(*)
      INTEGER ITEMP3(*)
      INTEGER ITEMP4(*)
      INTEGER ITEMP5(*)
      INTEGER ITEMP6(*)
C
      DOUBLE PRECISION DTEMP1(*)
      DOUBLE PRECISION DTEMP2(*)
      DOUBLE PRECISION DTEMP3(*)
C
      CHARACTER*4 IOP
C
      INCLUDE 'DPCOST.INC'
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPCR'
      ISUBN2='T7  '
C
      I2=0
C
      AN=INT(N+0.01)
      ANUMS1=INT(NUMSE1+0.01)
      ANUMS2=INT(NUMSE2+0.01)
      ANUMS3=INT(NUMSE3+0.01)
      ANUMS4=INT(NUMSE4+0.01)
      ANUMS5=INT(NUMSE5+0.01)
      ANUMS6=INT(NUMSE6+0.01)
C
C               ***********************************************
C               **  STEP 5--                                 **
C               **  COMPUTE THE VARIOUS CROSS-TAB STATISTICS **
C               ***********************************************
C
      ISTEPN='5.1'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CRT7')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     ALLOW THE   SET WRITE DECIMALS COMMAND    TO BE USED TO
C     DETERMINE HOW MANY DIGITS PRINTED IN TABLE.
C
      NUMDIG=-7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=10
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
C     NOTE 9/2008: IN FOLLOWING, WE NEED TO DISTINGUISH BETWEEN
C                  EMPTY SETS DUE TO NO POINTS FALLING IN THE
C                  PARTICULAR CROSS TABULATION (IN WHICH CASE,
C                  WE WANT TO SKIP IN THE OUTPUT FILE) AND EMPTY
C                  SETS DUE TO ALL POINTS IN THE PARTICULAR
C                  CROSS TABULATION BEING MISSING (IN WHICH CASE,
C                  WE MAY WANT TO WRITE A 0 OR A MISSING VALUE).
C
C                  THERE ARE 2 MISSING VALUES:
C
C                  PSTAMV   - SPECIFIES WHETHER THE INPUT DATA
C                             VALUE IS TO BE INCLUDED IN THE
C                             COMPUTATION OF THE STATISTIC
C
C                  PCTAMV    - IF ALL THE DATA IS MISSING, THIS
C                              IS THE VALUE TO USE IN WRITING THE
C                              CROSS TABULATE OUTPUT.
C
      IWRITE='OFF'
      IBFLAG=ICASCT
      IF(IBFLAG.EQ.'BRAT')IBFLAG='BPRO'
C
      EPS=0.1E-7
      J=0
      NRESP=NUMV2-6
      DO1110ISET1=1,NUMSE1
        DO1120ISET2=1,NUMSE2
          DO1130ISET3=1,NUMSE3
          DO1140ISET4=1,NUMSE4
          DO1150ISET5=1,NUMSE5
          DO1160ISET6=1,NUMSE6
C
            K=0
            NTEMP2=0
            DO1180I=1,N
              IF(XIDTEM(ISET1).EQ.TAG1(I) .AND.
     1           XIDTE2(ISET2).EQ.TAG2(I) .AND.
     1           XIDTE3(ISET3).EQ.TAG3(I) .AND.
     1           XIDTE4(ISET4).EQ.TAG4(I) .AND.
     1           XIDTE5(ISET5).EQ.TAG5(I) .AND.
     1           XIDTE6(ISET6).EQ.TAG6(I))
     1           GOTO1181
              GOTO1180
 1181         CONTINUE
C
              NTEMP2=NTEMP2+1
              IF(IYVAR.EQ.'OFF')THEN
                K=K+1
                TEMP(K)=0.0
              ELSE
                IF(ABS(Y(I)-PSTAMV).GT.EPS)THEN
                  K=K+1
                  TEMP(K)=Y(I)
                  IF(IXVAR.EQ.'ON')TEMPZ(K)=Z(I)
                  IF(IX2VAR.EQ.'ON')TEMPZ2(K)=Z2(I)
                ENDIF
              ENDIF
 1180       CONTINUE
            NTEMP=K
C
C           AUGUST 2002.  CALL CMPSTA (EXCEPT FOR CHI-SQUARE CASE)
C
C           NTEMP2 IS THE NUMBER OF POINTS IN THE SUBSET AND
C           NTEMP IS THE NUMBER OF NON-MISSING POINTS IN THE SUBSET.
C
            IF(NTEMP2.EQ.0)GOTO1160
C
            IF(NTEMP.EQ.0)THEN
              IF(ICTAMV.EQ.'ZERO')THEN
                STAT=0.0
                IF(IBFLAG.EQ.'BPRO' .OR. ICASCT.EQ.'MECL' .OR.
     1             ICASCT.EQ.'MDCL')THEN
                  NTRIAL=0
                  ALOWLM=0.0
                  AUPPLM=0.0
                ENDIF
              ELSEIF(ICTAMV.EQ.'MV  ')THEN
                STAT=PCTAMV
                IF(IBFLAG.EQ.'BPRO' .OR. ICASCT.EQ.'MECL' .OR.
     1             ICASCT.EQ.'MDCL')THEN
                  NTRIAL=0
                  ALOWLM=PCTAMV
                  AUPPLM=PCTAMV
                ENDIF
              ELSE
                GOTO1160
              ENDIF
            ELSE
              CALL CMPSTA(
     1              TEMP,TEMPZ,TEMPZ2,XTEMP1,XTEMP2,XTEMP3,
     1              MAXNXT,NTEMP,NTEMP,NTEMP,
     1              NRESP,ICASCT,
     1              ISEED,ITEMP1,ITEMP2,ITEMP3,ITEMP4,ITEMP5,ITEMP6,
     1              DTEMP1,DTEMP2,DTEMP3,
CCCCC1              IQUAME,IQUASE,PSTAMV,
     1              STAT,
     1              ISUBRO,IBUGA3,IERROR)
              IF(IERROR.EQ.'YES')GOTO9000
              IF(IBFLAG.EQ.'BPRO')THEN
                PTEMP=STAT
                NTRIAL=NTEMP
                IF(ICASCT.EQ.'BRAT')NTRIAL=ITEMP1(1)
                IF(STAT.EQ.PSTAMV)THEN
                  ALOWLM=PSTAMV
                  AUPPLM=PSTAMV
                ELSE
                  ALPHAT=ALPHA
                  CALL DPAGCO(PTEMP,NTRIAL,ALPHAT,IWRITE,
     1                        ALOWLM,AUPPLM,IBUGA3,IERROR)
                ENDIF
              ELSEIF(ICASCT.EQ.'MECL')THEN
                XMEAN=STAT
                NTRIAL=NTEMP
                IF(STAT.EQ.PSTAMV)THEN
                  ALOWLM=PSTAMV
                  AUPPLM=PSTAMV
                ELSE
                  CALL SD(TEMP,NTEMP,IWRITE,XSD,IBUGA3,IERROR)
                  ALPHAT=ALPHA
                  CALL DPMECL(XMEAN,XSD,NTEMP,ALPHAT,IWRITE,
     1                        ALOWLM,AUPPLM,IBUGA3,IERROR)
                ENDIF
              ELSEIF(ICASCT.EQ.'MDCL')THEN
                XMED=STAT
                NTRIAL=NTEMP
                IF(STAT.EQ.PSTAMV)THEN
                  ALOWLM=PSTAMV
                  AUPPLM=PSTAMV
                ELSE
                  XQ=0.5
                  CALL QUANSE(XQ,TEMP,NTEMP,IWRITE,XTEMP1,MAXNXT,IQUASE,
     1                        QUASE,IBUGA3,IERROR)
                  ALPHAT=ALPHA
                  CALL DPMECL(XMED,QUASE,NTEMP,ALPHAT,IWRITE,
     1                        ALOWLM,AUPPLM,IBUGA3,IERROR)
                ENDIF
              ENDIF
            ENDIF
C
            J=J+1
            Y2(J)=STAT
            X2(J)=XIDTEM(ISET1)
            D2(J)=XIDTE2(ISET2)
            DSIZE(J)=XIDTE3(ISET3)
            DCOLOR(J)=XIDTE4(ISET4)
            DFILL(J)=XIDTE5(ISET5)
            DSYMB(J)=XIDTE6(ISET6)
            IF(IBFLAG.EQ.'BPRO' .OR. ICASCT.EQ.'MECL' .OR.
     1         ICASCT.EQ.'MDCL')THEN
              XNTRIA(J)=REAL(NTRIAL)
              XACLOW(J)=ALOWLM
              XACUPP(J)=AUPPLM
            ENDIF
C
 1160     CONTINUE
 1150     CONTINUE
 1140     CONTINUE
 1130     CONTINUE
 1120   CONTINUE
 1110 CONTINUE
      N2=J
C
      IF(ICASCT.EQ.'BRAT')THEN
        IBFLAG='BRAT'
        ICASCT='BPRO'
      ENDIF
C
      IOP='OPEN'
      IFLG11=1
      IFLG21=0
      IFLG31=0
      IFLAG4=0
      IFLAG5=0
      CALL DPAUFI(IOP,IFLG11,IFLG21,IFLG31,IFLAG4,IFLAG5,
     1            IOUNI1,IOUNI2,IOUNI3,IOUNI4,IOUNI5,
     1            IBUGA3,ISUBRO,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      WRITE(IOUNI1,2111)ICTNAM
 2111 FORMAT(' GROUP-ID 1   GROUP-ID 2   GROUP-ID 3   GROUP-ID 4',
     1       '   GROUP-ID 5   GROUP-ID 6           ',A40)
C
      IF(ICASCT.EQ.'BPRO')THEN
        DO2170I=1,N2
          IF(IBINTA.EQ.'LOWE')THEN
            WRITE(IOUNI1,2171)X2(I),D2(I),DSIZE(I),DCOLOR(I),DFILL(I),
     1                        DSYMB(I),Y2(I),XNTRIA(I),XACLOW(I)

 2171       FORMAT(9E17.9)
          ELSEIF(IBINTA.EQ.'UPPE')THEN
            WRITE(IOUNI1,2171)X2(I),D2(I),DSIZE(I),DCOLOR(I),DFILL(I),
     1                        DSYMB(I),Y2(I),XNTRIA(I),XACUPP(I)
          ELSE
            WRITE(IOUNI1,2173)X2(I),D2(I),DSIZE(I),DCOLOR(I),DFILL(I),
     1                        DSYMB(I),Y2(I),XNTRIA(I),
     1                        XACLOW(I),XACUPP(I)
 2173       FORMAT(10E17.9)
          ENDIF
 2170   CONTINUE
      ELSEIF(ICASCT.EQ.'MECL' .OR. ICASCT.EQ.'MDCL')THEN
        DO2175I=1,N2
          WRITE(IOUNI1,2173)X2(I),D2(I),DSIZE(I),DCOLOR(I),DFILL(I),
     1                      DSYMB(I),Y2(I),XNTRIA(I),XACLOW(I),XACUPP(I)
 2175   CONTINUE
      ELSE
        DO2160I=1,N2
          WRITE(IOUNI1,2161)X2(I),D2(I),DSIZE(I),DCOLOR(I),DFILL(I),
     1                      DSYMB(I),Y2(I)
 2161     FORMAT(7E17.9)
 2160   CONTINUE
      ENDIF
C
      IOP='CLOS'
      CALL DPAUFI(IOP,IFLG11,IFLG21,IFLG31,IFLAG4,IFLAG5,
     1            IOUNI1,IOUNI2,IOUNI3,IOUNI4,IOUNI5,
     1            IBUGA3,ISUBRO,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
C               *****************************
C               **   STEP 6--              **
C               **   WRITE OUT THE TABLE   **
C               *****************************
C
      ISTEPN='6'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CRT7')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
C
      IF(IPRINT.EQ.'OFF')GOTO8000
C
      ITITLE(1:15)='Cross Tabulate '
      IF(ICASCT.EQ.'BPRO')THEN
        NCTITL=37
        ITITLE(16:NCTITL)='Binomial Probabilities'
      ELSEIF(ICASCT.EQ.'MECL')THEN
        NCTITL=37
        ITITLE(16:NCTITL)='Mean Confidence Limits'
      ELSEIF(ICASCT.EQ.'MDCL')THEN
        NCTITL=39
        ITITLE(16:NCTITL)='Median Confidence Limits'
      ELSE
        ITITLE(16:55)=ICTNAM(1:40)
        NCTITL=55
        DO4010I=55,1,-1
          IF(ITITLE(I:I).NE.' ')THEN
            NCTITL=I
            GOTO4019
          ENDIF
 4010   CONTINUE
 4019   CONTINUE
      ENDIF
C
      IF(IYVAR.EQ.'ON')THEN
        ITITL9(1:21)='(Response Variables: '
        NTEMP=21
        ITITL9(22:30)=IYNAM(1:8)
        NTEMP=30
        IF(IXVAR.EQ.'ON')THEN
          ITITL9(30:30)=' '
          ITITL9(31:38)=IXNAM(1:8)
          NTEMP=38
        ENDIF
        IF(IX2VAR.EQ.'ON')THEN
          ITITL9(39:39)=' '
          ITITL9(40:47)=IXNAM2(1:8)
          NTEMP=47
        ENDIF
        NTEMP=NTEMP+1
        ITITL9(NTEMP:NTEMP)=')'
        NCTIT9=NTEMP
      ELSE
        ITITL9=' '
        NCTIT9=0
      ENDIF
C
      ITITL2(1,1)(1:8)=IX1NAM
      NCTIT2(1,1)=8
      ITITL2(1,2)(1:8)=IX2NAM
      NCTIT2(1,2)=8
      ITITL2(1,3)(1:8)=IX3NAM
      NCTIT2(1,3)=8
      ITITL2(1,4)(1:8)=IX4NAM
      NCTIT2(1,4)=8
      ITITL2(1,5)(1:8)=IX5NAM
      NCTIT2(1,5)=8
      ITITL2(1,6)(1:8)=IX6NAM
      NCTIT2(1,6)=8
      ITITL2(1,7)='   |   '
      IF(ICAPTY.EQ.'LATE')THEN
        ITITL2(1,7)='  $|$  '
      ENDIF
      NCTIT2(1,7)=7
C
      NUMLIN=1
      IF(ICASCT.EQ.'BPRO')THEN
        NUMCOL=11
        IF(IBINTA.EQ.'LOWE' .OR. IBINTA.EQ.'UPPE')NUMCOL=10
        ITITL2(1,8)='P'
        NCTIT2(1,8)=1
        ITITL2(1,9)='N'
        NCTIT2(1,9)=1
        IF(IBINTA.EQ.'LOWE')THEN
          ITITL2(1,10)(1:40)='Lower AC'
          NCTIT2(1,10)=8
        ELSEIF(IBINTA.EQ.'UPPE')THEN
          ITITL2(1,10)(1:40)='Upper AC'
          NCTIT2(1,10)=8
        ELSE
          ITITL2(1,10)(1:40)='Lower AC'
          NCTIT2(1,10)=8
          ITITL2(1,11)(1:40)='Upper AC'
          NCTIT2(1,11)=8
        ENDIF
      ELSEIF(ICASCT.EQ.'MECL' .OR. ICASCT.EQ.'MDCL')THEN
        NUMCOL=11
        IF(ICASCT.EQ.'MECL')THEN
          ITITL2(1,8)='Mean'
          NCTIT2(1,8)=4
        ELSE
          ITITL2(1,8)='Median'
          NCTIT2(1,8)=6
        ENDIF
        ITITL2(1,9)='N'
        NCTIT2(1,9)=1
        ITITL2(1,10)='Lower Limit'
        ITITL2(1,10)='Upper Limit'
        NCTIT2(1,11)=11
        NCTIT2(1,11)=11
      ELSE
        NUMCOL=8
        ITITL2(1,8)(1:15)=ICTNAM(1:15)
        NTEMP=15
        DO4070I=15,1,-1
          IF(ITITL2(1,8)(I:I).NE.' ')THEN
            NTEMP=I
            GOTO4079
          ENDIF
 4070   CONTINUE
 4079   CONTINUE
        NCTIT2(1,8)=NTEMP
      ENDIF
C
      NMAX=0
      DO4210I=1,NUMCOL
        VALIGN(I)='b'
        ALIGN(I)='r'
        NTOT(I)=15
        IF(NCTIT2(1,I).GT.NTOT(I))NTOT(I)=NCTIT2(1,I)
        NMAX=NMAX+NTOT(I)
        IDIGIT(I)=NUMDIG
        ITYPCO(I)='NUME'
        IF(I.EQ.9)THEN
          NTOT(I)=8
          IDIGIT(I)=0
        ELSEIF(I.EQ.7)THEN
          ITYPCO(I)='ALPHA'
          NTOT(I)=7
          IDIGIT(I)=-1
CCCCC   ELSEIF(I.EQ.6)THEN
CCCCC     IF(ICASCT.NE.'BPRO' .AND. ICASCT.NE.'MECL' .AND.
CCCCC1       ICASCT.NE.'MDCL')THEN
CCCCC        ALIGN(I)='l'
CCCCC     ENDIF
        ENDIF
 4210 CONTINUE
C
      IWHTML(1)=100
      IWHTML(2)=100
      IWHTML(3)=100
      IWHTML(4)=100
      IWHTML(5)=100
      IWHTML(6)=100
      IWHTML(7)=25
      IWHTML(8)=100
      IWHTML(9)=75
      IWHTML(10)=100
      IWHTML(11)=100
      IJUNK=1300
      IF(ICASCT.EQ.'BPRO' .OR. ICASCT.EQ.'MECL' .OR.
     1   ICASCT.EQ.'MDCL')THEN
        IJUNK=900
        IPTSAV=IRTFPS
        IRTFPS=14
        CALL DPCONA(92,IBASLC)
        WRITE(ICOUT,7003)IBASLC,IRTFPS
 7003   FORMAT(A1,'fs',I2)
        CALL DPWRST('XXX','WRIT')
      ENDIF
      IWRTF(1)=IJUNK
      IWRTF(2)=IWRTF(1)+IJUNK
      IWRTF(3)=IWRTF(2)+IJUNK
      IWRTF(4)=IWRTF(3)+IJUNK
      IWRTF(5)=IWRTF(4)+IJUNK
      IWRTF(6)=IWRTF(5)+IJUNK
      IWRTF(7)=IWRTF(6)+200
      IWRTF(8)=IWRTF(7)+IJUNK
      IWRTF(9)=IWRTF(8)+800
      IWRTF(10)=IWRTF(9)+IJUNK
      IWRTF(11)=IWRTF(10)+IJUNK
      IFRST=.TRUE.
      ILAST=.TRUE.
      IFLAGS=.TRUE.
      IFLAGE=.FALSE.
      ICALL=0
C
      ICNT=0
      DO4310I=1,N2
        IF(ICNT.GE.30)THEN
          IF(I.EQ.N2)IFLAGE=.TRUE.
          CALL DPDTA5(ITITLE,NCTITL,
     1                ITITL9,NCTIT9,ITITL2,NCTIT2,
     1                MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1                IVALUE,NCVALU,AMAT,ITYPCO,MAXROW,ICNT,
     1                IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1                ICAPSW,ICAPTY,IFRST,ILAST,
     1                IFLAGS,IFLAGE,
     1                ISUBRO,IBUGA3,IERROR)
          IFRST=.FALSE.
          IFLAGS=.FALSE.
          ICALL=1
          ICNT=0
        ENDIF
        ICNT=ICNT+1
        NCTEXT(ICNT)=0
        AMAT(ICNT,1)=X2(I)
        AMAT(ICNT,2)=D2(I)
        AMAT(ICNT,3)=DSIZE(I)
        AMAT(ICNT,4)=DCOLOR(I)
        AMAT(ICNT,5)=DFILL(I)
        AMAT(ICNT,6)=DSYMB(I)
        AMAT(ICNT,7)=0.0
        AMAT(ICNT,8)=Y2(I)
        IF(ICASCT.EQ.'BPRO' .AND. IBINTA.EQ.'LOWE')THEN
          AMAT(ICNT,9)=XNTRIA(I)
          AMAT(ICNT,10)=XACLOW(I)
        ELSEIF(ICASCT.EQ.'BPRO' .AND. IBINTA.EQ.'UPPE')THEN
          AMAT(ICNT,9)=XNTRIA(I)
          AMAT(ICNT,10)=XACUPP(I)
        ELSEIF(ICASCT.EQ.'BPRO')THEN
          AMAT(ICNT,9)=XNTRIA(I)
          AMAT(ICNT,10)=XACLOW(I)
          AMAT(ICNT,11)=XACUPP(I)
        ELSEIF(ICASCT.EQ.'MECL' .OR. ICASCT.EQ.'MDCL')THEN
          AMAT(ICNT,9)=XNTRIA(I)
          AMAT(ICNT,10)=XACLOW(I)
          AMAT(ICNT,11)=XACUPP(I)
        ENDIF
        DO4320J=1,NUMCOL
          IF(J.EQ.7)THEN
            NCVALU(ICNT,J)=7
            IVALUE(ICNT,J)='   |   '
            IF(ICAPTY.EQ.'LATE')THEN
              IVALUE(ICNT,J)='  $|$  '
            ENDIF
          ELSE
            NCVALU(ICNT,J)=0
            IVALUE(ICNT,J)=' '
          ENDIF
 4320   CONTINUE
 4310 CONTINUE
C
      IF(ICNT.GE.1)THEN
        IFLAGE=.TRUE.
        ILAST=.TRUE.
        CALL DPDTA5(ITITLE,NCTITL,
     1              ITITL9,NCTIT9,ITITL2,NCTIT2,
     1              MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1              IVALUE,NCVALU,AMAT,ITYPCO,MAXROW,ICNT,
     1              IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1              ICAPSW,ICAPTY,IFRST,ILAST,
     1              IFLAGS,IFLAGE,
     1              ISUBRO,IBUGA3,IERROR)
      ENDIF
C
      IF(ICASCT.EQ.'BPRO' .OR. ICASCT.EQ.'MECL' .OR.
     1   ICASCT.EQ.'MDCL')THEN
        IRTFPS=IPTSAV
        WRITE(ICOUT,7003)IBASLC,IRTFPS
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
 8000 CONTINUE
      IF(IFEEDB.EQ.'ON')THEN
        WRITE(ICOUT,9212)
 9212   FORMAT(6X,'GROUP-IDs AND STATISTIC WRITTEN TO FILE ',
     1         'DPST1F.DAT')
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               ******************
C               **   STEP 90--  **
C               **   EXIT       **
C               ******************
C
 9000 CONTINUE
C
      IF(IBFLAG.EQ.'BRAT')THEN
        ICASCT='BRAT'
      ENDIF
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'CRT7')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPCRT7--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)ICASCT,N,N2,IERROR
 9012   FORMAT('ICASCT,N,N2,IERROR = ',A4,2I8,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)NUMV2
 9013   FORMAT('NUMV2 = ',I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9015)NUMSE1,NUMSE2,NUMSE3,NUMSE4,NUMSE5,NUMSE6
 9015   FORMAT('NUMSE1,NUMSE2,NUMSE3,NUMSE4,NUMSE5,NUMSE6 = ',6I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9016)ANUMS1,ANUMS2,ANUMS3,ANUMS4,ANUMSE5,ANUMSE6
 9016   FORMAT('ANUMS1,ANUMS2,ANUMS3,ANUMS4,ANUMSE5,ANUMSE6 = ',6G15.7)
        CALL DPWRST('XXX','BUG ')
        DO9020I=1,N2
          WRITE(ICOUT,9021)I,Y2(I),X2(I),DSIZE(I),D2(I)
 9021     FORMAT('I,Y2(I),X2(I),DSIZE(I),D2(I) = ',I8,4G15.7)
          CALL DPWRST('XXX','BUG ')
 9020   CONTINUE
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPCRT0(Y,Z,Z2,TAG1,N,
     1                  NUMV2,ICASCT,ICTNAM,
     1                  XIDTEM,
     1                  NUMSE1,
     1                  TEMP,TEMPZ,TEMPZ2,XTEMP1,XTEMP2,XTEMP3,
     1                  XNTRIA,XACLOW,XACUPP,
     1                  ITEMP1,ITEMP2,ITEMP3,ITEMP4,ITEMP5,ITEMP6,
     1                  DTEMP1,DTEMP2,DTEMP3,
     1                  ISEED,ALPHA,
     1                  IXVAR,IX2VAR,IYVAR,
     1                  IYNAM,IXNAM,IXNAM2,IX1NAM,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  MAXNXT,
     1                  Y2,X2,N2,ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--GENERATE A ONE-WAY TABULATION AND
C              OPTIONALLY PRINT THE RESULTS TO AN ASCII,
C              HTML, LATEX, OR RTF TABLE.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     REFERENCE--ASTM MANUAL STP-15D, PAGES 78-84, 100-105
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2008/6
C     ORIGINAL VERSION--JUNE      2008. SPLIT OFF FROM DPTAB2 ROUTINE
C     UPDATED         --SEPTEMBER 2008. ACCOMODATE "MISSING" DATA
C     UPDATED         --JANUARY   2010. "BINOMIAL RATIO" HANDLED
C                                       SAME AS "BINOMIAL PROB"
C     UPDATED         --JUNE      2010. CALL LIST TO CMPSTA
C     UPDATED         --JUNE      2010. USE DPDTA5 TO PRINT TABLE
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICASCT
      CHARACTER*40 ICTNAM
      CHARACTER*50 ICTEMP
      CHARACTER*60 ICTMP2
      CHARACTER*4 IXVAR
      CHARACTER*4 IX2VAR
      CHARACTER*4 IYVAR
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      PARAMETER(NUMCLI=6)
      PARAMETER(MAXLIN=2)
      PARAMETER (MAXROW=30)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*60 ITITL9
      CHARACTER*60 ITEXT(MAXROW)
      CHARACTER*4  ALIGN(NUMCLI)
      CHARACTER*4  VALIGN(NUMCLI)
      REAL         AVALUE(MAXROW)
      INTEGER      NCTEXT(MAXROW)
      INTEGER      IDIGIT(MAXROW)
      INTEGER      NTOT(MAXROW)
      CHARACTER*60 ITITL2(MAXLIN,NUMCLI)
      CHARACTER*15 IVALUE(MAXROW,NUMCLI)
      CHARACTER*4  ITYPCO(NUMCLI)
      INTEGER      NCTIT2(MAXLIN,NUMCLI)
      INTEGER      NCVALU(MAXROW,NUMCLI)
      INTEGER      IWHTML(NUMCLI)
      INTEGER      IWRTF(NUMCLI)
      REAL         AMAT(MAXROW,NUMCLI)
      LOGICAL IFRST
      LOGICAL ILAST
      LOGICAL IFLAG1
      LOGICAL IFLAG2
      LOGICAL IFLAG3
      LOGICAL IFLAGS
      LOGICAL IFLAGE
C
      CHARACTER*8 IYNAM
      CHARACTER*8 IXNAM
      CHARACTER*8 IXNAM2
      CHARACTER*8 IX1NAM
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IWRITE
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      CHARACTER*4 ISUBN0
      CHARACTER*4 IBFLAG
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION Z(*)
      DIMENSION Z2(*)
      DIMENSION XIDTEM(*)
      DIMENSION Y2(*)
      DIMENSION X2(*)
C
      DIMENSION TAG1(*)
      DIMENSION TEMP(*)
      DIMENSION TEMPZ(*)
      DIMENSION TEMPZ2(*)
      DIMENSION XTEMP1(*)
      DIMENSION XTEMP2(*)
      DIMENSION XTEMP3(*)
      DIMENSION XNTRIA(*)
      DIMENSION XACLOW(*)
      DIMENSION XACUPP(*)
C
      INTEGER ITEMP1(*)
      INTEGER ITEMP2(*)
      INTEGER ITEMP3(*)
      INTEGER ITEMP4(*)
      INTEGER ITEMP5(*)
      INTEGER ITEMP6(*)
C
      DOUBLE PRECISION DTEMP1(*)
      DOUBLE PRECISION DTEMP2(*)
      DOUBLE PRECISION DTEMP3(*)
C
      CHARACTER*4 IOP
C
      INCLUDE 'DPCOST.INC'
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPCR'
      ISUBN2='T0  '
C
      IBFLAG=ICASCT
      IF(IBFLAG.EQ.'BRAT')IBFLAG='BPRO'
      I2=0
      AN=INT(N+0.01)
      ANUMS1=INT(NUMSE1+0.01)
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'CRT0')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,11)
   11   FORMAT('***** AT THE BEGINNING OF DPCRT0--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,12)ICASCT,N,NUMSE1
   12   FORMAT('ICASCT,N,NUMSE1 = ',A4,2I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,13)IYVAR,IXVAR,IX2VAR
   13   FORMAT('IYVAR,IXVAR,IX2VAR = ',A4,2X,A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,14)IYNAM,IXNAM,IXNAM2
   14   FORMAT('IYNAM,IXNAM,IXNAM2 = ',A8,2X,A8,2X,A8)
        CALL DPWRST('XXX','BUG ')
        DO20I=1,N
          WRITE(ICOUT,16)I,Y(I),Z(I),Z2(I),TAG1(I)
   16     FORMAT('I,Y(I),Z(I),Z2(I),TAG1(I) = ',I8,4G15.7)
          CALL DPWRST('XXX','BUG ')
   20   CONTINUE
      ENDIF
C
C               ***********************************************
C               **  STEP 5--                                 **
C               **  COMPUTE THE VARIOUS CROSS-TAB STATISTICS **
C               ***********************************************
C
      ISTEPN='5.1'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CRT0')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     ALLOW THE   SET WRITE DECIMALS COMMAND    TO BE USED TO
C     DETERMINE HOW MANY DIGITS PRINTED IN TABLE.
C
      NUMDIG=-7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=10
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
C     NOTE 9/2008: IN FOLLOWING, WE NEED TO DISTINGUISH BETWEEN
C                  EMPTY SETS DUE TO NO POINTS FALLING IN THE
C                  PARTICULAR CROSS TABULATION (IN WHICH CASE,
C                  WE WANT TO SKIP IN THE OUTPUT FILE) AND EMPTY
C                  SETS DUE TO ALL POINTS IN THE PARTICULAR
C                  CROSS TABULATION BEING MISSING (IN WHICH CASE,
C                  WE MAY WANT TO WRITE A 0 OR A MISSING VALUE).
C
C                  THERE ARE 2 MISSING VALUES:
C
C                  PSTAMV   - SPECIFIES WHETHER THE INPUT DATA
C                             VALUE IS TO BE INCLUDED IN THE
C                             COMPUTATION OF THE STATISTIC
C
C                  PCTAMV    - IF ALL THE DATA IS MISSING, THIS
C                              IS THE VALUE TO USE IN WRITING THE
C                              CROSS TABULATE OUTPUT.
C
      IWRITE='OFF'
C
      EPS=0.1E-7
      J=0
      K=0
      NRESP=NUMV2-1
C
      ISTEPN='5.2'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CRT0')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      DO1110ISET1=1,NUMSE1
C
        K=0
        NTEMP2=0
        NTEMP=0
C
        ISTEPN='5.2'
        IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CRT0')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
        DO1130I=1,N
          IF(XIDTEM(ISET1).EQ.TAG1(I))GOTO1131
          GOTO1130
 1131     CONTINUE
C
          NTEMP2=NTEMP2+1
          IF(IYVAR.EQ.'OFF')THEN
            NTEMP=NTEMP+1
            TEMP(NTEMP)=0.0
          ELSE
            IF(ABS(Y(I)-PSTAMV).GT.EPS)THEN
              NTEMP=NTEMP+1
              TEMP(NTEMP)=Y(I)
              IF(IXVAR.EQ.'ON')TEMPZ(NTEMP)=Z(I)
              IF(IX2VAR.EQ.'ON')TEMPZ2(NTEMP)=Z2(I)
            ENDIF
          ENDIF
 1130   CONTINUE
C
        IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CRT0')THEN
          ISTEPN='5.3'
          CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,1133)NTEMP,NTEMP2
 1133     FORMAT('DPCRT0: NTEMP,NTEMP2=',2I8)
          CALL DPWRST('XXX','BUG ')
        ENDIF
C
C       AUGUST 2002.  CALL CMPSTA (EXCEPT FOR CHI-SQUARE CASE)
C
C       NTEMP2 IS THE NUMBER OF POINTS IN THE SUBSET AND
C       NTEMP IS THE NUMBER OF NON-MISSING POINTS IN THE SUBSET.
C
        IF(NTEMP2.EQ.0)GOTO1110
C
        IF(NTEMP.EQ.0)THEN
          IF(ICTAMV.EQ.'ZERO')THEN
            STAT=0.0
            IF(IBFLAG.EQ.'BPRO' .OR. ICASCT.EQ.'MECL' .OR.
     1         ICASCT.EQ.'MDCL')THEN
              NTRIAL=0
              ALOWLM=0.0
              AUPPLM=0.0
            ENDIF
          ELSEIF(ICTAMV.EQ.'MV  ')THEN
            STAT=PCTAMV
            IF(IBFLAG.EQ.'BPRO' .OR. ICASCT.EQ.'MECL' .OR.
     1         ICASCT.EQ.'MDCL')THEN
              NTRIAL=0
              ALOWLM=PCTAMV
              AUPPLM=PCTAMV
            ENDIF
          ELSE
            GOTO1110
          ENDIF
        ELSE
          CALL CMPSTA(
     1              TEMP,TEMPZ,TEMPZ2,XTEMP1,XTEMP2,XTEMP3,
     1              MAXNXT,NTEMP,NTEMP,NTEMP,
     1              NRESP,ICASCT,
     1              ISEED,ITEMP1,ITEMP2,ITEMP3,ITEMP4,ITEMP5,ITEMP6,
     1              DTEMP1,DTEMP2,DTEMP3,
CCCCC1              IQUAME,IQUASE,PSTAMV,
     1              STAT,
     1              ISUBRO,IBUGA3,IERROR)
          IF(IERROR.EQ.'YES')GOTO9000
          IF(IBFLAG.EQ.'BPRO')THEN
            PTEMP=STAT
            NTRIAL=NTEMP
            IF(ICASCT.EQ.'BRAT')NTRIAL=ITEMP1(1)
            IF(STAT.EQ.PSTAMV)THEN
              ALOWLM=PSTAMV
              AUPPLM=PSTAMV
            ELSE
              ALPHAT=ALPHA
              CALL DPAGCO(PTEMP,NTRIAL,ALPHAT,IWRITE,
     1                    ALOWLM,AUPPLM,IBUGA3,IERROR)
            ENDIF
          ELSEIF(ICASCT.EQ.'MECL')THEN
            XMEAN=STAT
            NTRIAL=NTEMP
            IF(STAT.EQ.PSTAMV)THEN
              ALOWLM=PSTAMV
              AUPPLM=PSTAMV
            ELSE
              CALL SD(TEMP,NTEMP,IWRITE,XSD,IBUGA3,IERROR)
              ALPHAT=ALPHA
              CALL DPMECL(XMEAN,XSD,NTEMP,ALPHAT,IWRITE,
     1                    ALOWLM,AUPPLM,IBUGA3,IERROR)
            ENDIF
          ELSEIF(ICASCT.EQ.'MDCL')THEN
            XMED=STAT
            NTRIAL=NTEMP
            IF(STAT.EQ.PSTAMV)THEN
              ALOWLM=PSTAMV
              AUPPLM=PSTAMV
            ELSE
              XQ=0.5
              CALL QUANSE(XQ,TEMP,NTEMP,IWRITE,XTEMP1,MAXNXT,IQUASE,
     1                    QUASE,IBUGA3,IERROR)
              ALPHAT=ALPHA
              CALL DPMECL(XMED,QUASE,NTEMP,ALPHAT,IWRITE,
     1                    ALOWLM,AUPPLM,IBUGA3,IERROR)
            ENDIF
          ENDIF
        ENDIF
C
        J=J+1
        Y2(J)=STAT
        X2(J)=XIDTEM(ISET1)
C
        IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CRT0')THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,1136)J
 1136     FORMAT('DPCRT0: J=',I8)
          CALL DPWRST('XXX','BUG ')
        ENDIF
C
        IF(IBFLAG.EQ.'BPRO' .OR. ICASCT.EQ.'MECL' .OR.
     1     ICASCT.EQ.'MDCL')THEN
          XNTRIA(J)=REAL(NTRIAL)
          XACLOW(J)=ALOWLM
          XACUPP(J)=AUPPLM
        ENDIF
C
 1110 CONTINUE
C
      N2=J
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CRT0')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1191)J,N2
 1191   FORMAT('DPCRT0: J,N2=',2I8)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      IOP='OPEN'
      IFLG11=1
      IFLG21=0
      IFLG31=0
      IFLAG4=0
      IFLAG5=0
      CALL DPAUFI(IOP,IFLG11,IFLG21,IFLG31,IFLAG4,IFLAG5,
     1            IOUNI1,IOUNI2,IOUNI3,IOUNI4,IOUNI5,
     1            IBUGA3,ISUBRO,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
CCCCC WRITE OUT TO DPST1F.DAT
C
      WRITE(IOUNI1,2111)ICTNAM
 2111 FORMAT(' GROUP-ID 1          ',A40)
      IF(IBFLAG.EQ.'BPRO')THEN
        DO2170I=1,N2
          IF(IBINTA.EQ.'LOWE')THEN
            WRITE(IOUNI1,2171)X2(I),Y2(I),XNTRIA(I),XACLOW(I)
 2171       FORMAT(4E17.9)
          ELSEIF(IBINTA.EQ.'UPPE')THEN
            WRITE(IOUNI1,2171)X2(I),Y2(I),XNTRIA(I),XACUPP(I)
          ELSE
            WRITE(IOUNI1,2173)X2(I),Y2(I),XNTRIA(I),
     1                        XACLOW(I),XACUPP(I)
 2173       FORMAT(5E17.9)
          ENDIF
 2170   CONTINUE
      ELSEIF(ICASCT.EQ.'MECL' .OR. ICASCT.EQ.'MDCL')THEN
        DO2175I=1,N2
          WRITE(IOUNI1,2173)X2(I),Y2(I),XNTRIA(I),
     1                      XACLOW(I),XACUPP(I)
 2175   CONTINUE
      ELSE
        DO2160I=1,N2
          WRITE(IOUNI1,2161)X2(I),Y2(I)
 2161     FORMAT(2E17.9)
 2160   CONTINUE
      ENDIF
C
      IOP='CLOSE'
      CALL DPAUFI(IOP,IFLG11,IFLG21,IFLG31,IFLAG4,IFLAG5,
     1            IOUNI1,IOUNI2,IOUNI3,IOUNI4,IOUNI5,
     1            IBUGA3,ISUBRO,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
C               *****************************
C               **   STEP 6--              **
C               **   WRITE OUT THE TABLE   **
C               *****************************
C
      ISTEPN='6'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CRT0')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
C
      IF(IPRINT.EQ.'OFF')GOTO8000
C
      ITITLE(1:15)='Cross Tabulate '
      IF(ICASCT.EQ.'BPRO')THEN
        NCTITL=37
        ITITLE(16:NCTITL)='Binomial Probabilities'
      ELSEIF(ICASCT.EQ.'MECL')THEN
        NCTITL=37
        ITITLE(16:NCTITL)='Mean Confidence Limits'
      ELSEIF(ICASCT.EQ.'MDCL')THEN
        NCTITL=39
        ITITLE(16:NCTITL)='Median Confidence Limits'
      ELSE
        ITITLE(16:55)=ICTNAM(1:40)
        NCTITL=55
        DO4010I=55,1,-1
          IF(ITITLE(I:I).NE.' ')THEN
            NCTITL=I
            GOTO4019
          ENDIF
 4010   CONTINUE
 4019   CONTINUE
      ENDIF
C
      IF(IYVAR.EQ.'ON')THEN
        ITITL9(1:21)='(Response Variables: '
        NTEMP=21
        ITITL9(22:30)=IYNAM(1:8)
        NTEMP=30
        IF(IXVAR.EQ.'ON')THEN
          ITITL9(30:30)=' '
          ITITL9(31:38)=IXNAM(1:8)
          NTEMP=38
        ENDIF
        IF(IX2VAR.EQ.'ON')THEN
          ITITL9(39:39)=' '
          ITITL9(40:47)=IXNAM2(1:8)
          NTEMP=47
        ENDIF
        NTEMP=NTEMP+1
        ITITL9(NTEMP:NTEMP)=')'
        NCTIT9=NTEMP
      ELSE
        ITITL9=' '
        NCTIT9=0
      ENDIF
C
      ITITL2(1,1)(1:8)=IX1NAM
      NCTIT2(1,1)=8
      ITITL2(1,2)='   |   '
      IF(ICAPTY.EQ.'LATE')THEN
        ITITL2(1,2)='  $|$  '
      ENDIF
      NCTIT2(1,2)=7
C
      NUMLIN=1
      IF(ICASCT.EQ.'BPRO')THEN
        NUMCOL=6
        IF(IBINTA.EQ.'LOWE' .OR. IBINTA.EQ.'UPPE')NUMCOL=5
        ITITL2(1,3)='P'
        NCTIT2(1,3)=1
        ITITL2(1,4)='N'
        NCTIT2(1,4)=1
        IF(IBINTA.EQ.'LOWE')THEN
          ITITL2(1,5)(1:40)='Lower AC'
          NCTIT2(1,5)=8
        ELSEIF(IBINTA.EQ.'UPPE')THEN
          ITITL2(1,5)(1:40)='Upper AC'
          NCTIT2(1,5)=8
        ELSE
          ITITL2(1,5)(1:40)='Lower AC'
          NCTIT2(1,5)=8
          ITITL2(1,6)(1:40)='Upper AC'
          NCTIT2(1,6)=8
        ENDIF
      ELSEIF(ICASCT.EQ.'MECL' .OR. ICASCT.EQ.'MDCL')THEN
        NUMCOL=6
        IF(ICASCT.EQ.'MECL')THEN
          ITITL2(1,3)='Mean'
          NCTIT2(1,3)=4
        ELSE
          ITITL2(1,3)='Median'
          NCTIT2(1,3)=6
        ENDIF
        ITITL2(1,4)='N'
        NCTIT2(1,4)=1
        ITITL2(1,5)='Lower Limit'
        ITITL2(1,6)='Upper Limit'
        NCTIT2(1,5)=11
        NCTIT2(1,6)=11
      ELSE
        NUMCOL=3
        ITITL2(1,3)(1:15)=ICTNAM(1:15)
        NTEMP=15
        DO4070I=15,1,-1
          IF(ITITL2(1,3)(I:I).NE.' ')THEN
            NTEMP=I
            GOTO4079
          ENDIF
 4070   CONTINUE
 4079   CONTINUE
        NCTIT2(1,3)=NTEMP
      ENDIF
C
      NMAX=0
      DO4210I=1,NUMCOL
        VALIGN(I)='b'
        ALIGN(I)='r'
        NTOT(I)=15
        IF(NCTIT2(1,I).GT.NTOT(I))NTOT(I)=NCTIT2(1,I)
        NMAX=NMAX+NTOT(I)
        IDIGIT(I)=NUMDIG
        ITYPCO(I)='NUME'
        IF(I.EQ.4)THEN
          NTOT(I)=8
          IDIGIT(I)=0
        ELSEIF(I.EQ.2)THEN
          ITYPCO(I)='ALPHA'
          NTOT(I)=7
          IDIGIT(I)=-1
        ENDIF
 4210 CONTINUE
C
      IWHTML(1)=125
      IWHTML(2)=25
      IWHTML(3)=125
      IWHTML(4)=75
      IWHTML(5)=125
      IWHTML(6)=125
      IJUNK=1400
      IWRTF(1)=IJUNK
      IWRTF(2)=IWRTF(1)+200
      IWRTF(3)=IWRTF(2)+IJUNK
      IWRTF(4)=IWRTF(3)+800
      IWRTF(5)=IWRTF(4)+IJUNK
      IWRTF(6)=IWRTF(5)+IJUNK
      IFRST=.TRUE.
      IFLAGS=.TRUE.
      ILAST=.TRUE.
      IFLAGE=.FALSE.
C
      ICALL=0
      ICNT=0
      DO4310I=1,N2
        IF(ICNT.GE.30)THEN
          IF(I.EQ.N2)IFLAGE=.TRUE.
          CALL DPDTA5(ITITLE,NCTITL,
     1                ITITL9,NCTIT9,ITITL2,NCTIT2,
     1                MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1                IVALUE,NCVALU,AMAT,ITYPCO,MAXROW,ICNT,
     1                IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1                ICAPSW,ICAPTY,IFRST,ILAST,
     1                IFLAGS,IFLAGE,
     1                ISUBRO,IBUGA3,IERROR)
          IFRST=.FALSE.
          IFLAGS=.FALSE.
          ICALL=1
          ICNT=0
        ENDIF
        ICNT=ICNT+1
        NCTEXT(ICNT)=0
        AMAT(ICNT,1)=X2(I)
        AMAT(ICNT,2)=0.0
        AMAT(ICNT,3)=Y2(I)
        IF(ICASCT.EQ.'BPRO' .AND. IBINTA.EQ.'LOWE')THEN
          AMAT(ICNT,4)=XNTRIA(I)
          AMAT(ICNT,5)=XACLOW(I)
        ELSEIF(ICASCT.EQ.'BPRO' .AND. IBINTA.EQ.'UPPE')THEN
          AMAT(ICNT,4)=XNTRIA(I)
          AMAT(ICNT,5)=XACUPP(I)
        ELSEIF(ICASCT.EQ.'BPRO')THEN
          AMAT(ICNT,4)=XNTRIA(I)
          AMAT(ICNT,5)=XACLOW(I)
          AMAT(ICNT,6)=XACUPP(I)
        ELSEIF(ICASCT.EQ.'MECL' .OR. ICASCT.EQ.'MDCL')THEN
          AMAT(ICNT,4)=XNTRIA(I)
          AMAT(ICNT,5)=XACLOW(I)
          AMAT(ICNT,6)=XACUPP(I)
        ENDIF
        DO4320J=1,NUMCOL
          IF(J.EQ.2)THEN
            NCVALU(ICNT,J)=7
            IVALUE(ICNT,J)='   |   '
            IF(ICAPTY.EQ.'LATE')THEN
              IVALUE(ICNT,J)='  $|$  '
            ENDIF
          ELSE
            NCVALU(ICNT,J)=0
            IVALUE(ICNT,J)=' '
          ENDIF
 4320   CONTINUE
 4310 CONTINUE
C
      IF(ICNT.GE.1)THEN
        IFLAGE=.TRUE.
        ILAST=.TRUE.
        CALL DPDTA5(ITITLE,NCTITL,
     1              ITITL9,NCTIT9,ITITL2,NCTIT2,
     1              MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1              IVALUE,NCVALU,AMAT,ITYPCO,MAXROW,ICNT,
     1              IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1              ICAPSW,ICAPTY,IFRST,ILAST,
     1              IFLAGS,IFLAGE,
     1              ISUBRO,IBUGA3,IERROR)
      ENDIF
C
 8000 CONTINUE
      IF(IFEEDB.EQ.'ON')THEN
        WRITE(ICOUT,9212)
 9212   FORMAT(6X,'GROUP-IDs AND STATISTIC WRITTEN TO FILE ',
     1         'DPST1F.DAT')
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               ******************
C               **   STEP 90--  **
C               **   EXIT       **
C               ******************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'CRT0')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPCRT0--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)ICASCT,N,NUMV2,NUMSE1,N2,IERROR
 9012   FORMAT('ICASCT,N,NUMV2,NUMSE1,N2,IERROR = ',A4,4I8,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9016)ANUMS1
 9016   FORMAT('ANUMS1 = ',E15.7)
        CALL DPWRST('XXX','BUG ')
        DO9020I=1,N2
          WRITE(ICOUT,9021)I,Y2(I),X2(I)
 9021     FORMAT('I,Y2(I),X2(I) = ',I8,2G15.7)
          CALL DPWRST('XXX','BUG ')
 9020   CONTINUE
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPCSTE(XTEMP1,XTEMP2,MAXNXT,
     1                  ICAPSW,IFORSW,ICASAN,
     1                  IBUGA2,IBUGA3,IBUGQ,ISUBRO,IFOUND,IERROR)
C
C     PURPOSE--CARRY OUT A ONE-SAMPLE CHI-SQUARED TEST
C     EXAMPLE--CHI-SQUARED TEST Y SIGMA
C              CHI-SQUARED TEST SIGMA Y
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--94/2
C     ORIGINAL VERSION--FEBRUARY  1994.
C     UPDATED         --DECEMBER  1994.  COPY CHI-SQUARED TEST PARAM.
C     UPDATED         --MAY       1995.  BUG FIX
C     UPDATED         --JANUARY   2004.  SUPPORT FOR HTML, LATEX
C     UPDATED         --APRIL     2011.  USE DPPARS AND DPPAR3
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IBUGA2
      CHARACTER*4 IBUGA3
      CHARACTER*4 IBUGQ
      CHARACTER*4 ISUBRO
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
      CHARACTER*4 ICAPSW
      CHARACTER*4 IFORSW
      CHARACTER*4 ICASAN
C
      CHARACTER*4 IHWUSE
      CHARACTER*4 MESSAG
C
      CHARACTER*4 IMULT
      CHARACTER*4 IREPL
C
      CHARACTER*4 IH
      CHARACTER*4 IH2
      CHARACTER*4 IHOST1
      CHARACTER*4 ISUBN0
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      CHARACTER*4 ICASA2
      CHARACTER*4 ICASA3
      CHARACTER*4 ICASE
      CHARACTER*4 IVARID
      CHARACTER*4 IVARI2
      CHARACTER*4 IVARI3
      CHARACTER*4 IVARI4
      CHARACTER*40 INAME
      PARAMETER (MAXSPN=30)
      CHARACTER*4 IVARN1(MAXSPN)
      CHARACTER*4 IVARN2(MAXSPN)
      CHARACTER*4 IVARTY(MAXSPN)
      REAL PVAR(MAXSPN)
      INTEGER ILIS(MAXSPN)
      INTEGER NRIGHT(MAXSPN)
      INTEGER ICOLR(MAXSPN)
C
      CHARACTER*4 IFLAGU
      LOGICAL IFRST
      LOGICAL ILAST
C
C---------------------------------------------------------------------
C
      DIMENSION XTEMP1(*)
      DIMENSION XTEMP2(*)
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCOHK.INC'
      INCLUDE 'DPCOSU.INC'
      INCLUDE 'DPCODA.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPCS'
      ISUBN2='TE  '
C
      MAXCP1=MAXCOL+1
      MAXCP2=MAXCOL+2
      MAXCP3=MAXCOL+3
      MAXCP4=MAXCOL+4
      MAXCP5=MAXCOL+5
      MAXCP6=MAXCOL+6
C
      IFOUND='YES'
      IERROR='NO'
C
      ICASA2='BOTH'
      IF(ICASAN.EQ.'CSLT')THEN
        ICASAN='CSTE'
        ICASA2='LOWE'
      ELSEIF(ICASAN.EQ.'CSUT')THEN
        ICASAN='CSTE'
        ICASA2='UPPE'
      ELSEIF(ICASAN.EQ.'CS2T')THEN
        ICASAN='CSTE'
        ICASA2='TWOT'
      ENDIF
C
C               ***************************************
C               **  TREAT THE CHI-SQUARED TEST CASE  **
C               ***************************************
C
      IF(IBUGA2.EQ.'ON' .OR. ISUBRO.EQ.'CSTE')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPCSTE--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGA2,IBUGA3,IBUGQ,ISUBRO,MAXNXT
   52   FORMAT('IBUGA2,IBUGA3,IBUGQ,ISUBRO = ',4(A4,2X),I8)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               ****************************************
C               **  STEP 2--                          **
C               **  EXTRACT THE VARIABLE LIST         **
C               ****************************************
C
      ISTEPN='2'
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'CSTE')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      INAME='CHI-SQUARE TEST'
      MINNA=1
      MAXNA=100
      MINN2=2
      IFLAGE=0
      IFLAGM=1
      MINNVA=2
      MAXNVA=MAXSPN
      IFLAGP=29
      IF(IREPL.EQ.'ON')THEN
        IFLAGE=1
        IFLAGM=0
      ENDIF
      JMIN=1
      JMAX=NUMARG
C
      CALL DPPARS(IHARG,IHARG2,IARGT,ARG,NUMARG,IANS,IWIDTH,
     1            IHNAME,IHNAM2,IUSE,NUMNAM,IN,IVALUE,VALUE,
     1            JMIN,JMAX,
     1            MINN2,MINNA,MAXNA,MAXSPN,IFLAGE,INAME,
     1            IVARN1,IVARN2,IVARTY,PVAR,
     1            ILIS,NRIGHT,ICOLR,ISUB,NQ,ILOCQ,NUMVAR,
     1            MINNVA,MAXNVA,
     1            IFLAGM,IFLAGP,
     1            IBUGA3,IBUGQ,ISUBRO,IFOUND,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'CSTE')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,281)
  281   FORMAT('***** AFTER CALL DPPARS--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,282)NQ,NUMVAR
  282   FORMAT('NQ,NUMVAR = ',2I8)
        CALL DPWRST('XXX','BUG ')
        IF(NUMVAR.GT.0)THEN
          DO285I=1,NUMVAR
            WRITE(ICOUT,287)I,IVARN1(I),IVARN2(I),ILIS(I),NRIGHT(I),
     1                      ICOLR(I)
  287       FORMAT('I,IVARN1(I),IVARN2(I),ILIS(I),NRIGHT(I),',
     1             'ICOLR(I) = ',I8,2X,A4,A4,2X,3I8)
            CALL DPWRST('XXX','BUG ')
  285     CONTINUE
        ENDIF
      ENDIF
C
C     EITHER THE FIRST OR LAST ARGUMENT SHOULD BE A PARAMETER.
C
      IF(IVARTY(1).NE.'PARA' .AND. IVARTY(NUMVAR).NE.'PARA')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,101)
  101   FORMAT('***** ERROR IN CHI-SQUARE TEST--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,292)
  292   FORMAT('      EITHER THE FIRST OR THE LAST ARGUMENT MUST BE ',
     1         'A PARAMETER.')
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ELSEIF(IVARTY(1).EQ.'PARA')THEN
        ISTART=2
        ISTOP=NUMVAR
        SIGMA0=PVAR(1)
      ELSEIF(IVARTY(NUMVAR).EQ.'PARA')THEN
        ISTART=1
        ISTOP=NUMVAR-1
        SIGMA0=PVAR(NUMVAR)
      ENDIF
C
C               *****************************************
C               **  STEP 3A--                          **
C               **  CASE 1: NO REPLICATION CASE        **
C               *****************************************
C
      ISTEPN='3A'
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'CSTE')
     1  CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NUMVA2=1
      DO5210I=ISTART,ISTOP
        ICOL=I
        CALL DPPAR3(ICOL,IVALUE,IVALU2,IN,MAXN,MAXOBV,
     1              INAME,IVARN1,IVARN2,IVARTY,
     1              ILIS,NRIGHT,ICOLR,ISUB,NQ,NUMVA2,
     1              MAXCOL,MAXCP1,MAXCP2,MAXCP3,
     1              MAXCP4,MAXCP5,MAXCP6,
     1              V,PRED,RES,YPLOT,XPLOT,X2PLOT,TAGPLO,
     1              Y,Y,Y,NS1,NLOCA2,NLOCA3,ICASE,
     1              IBUGA3,ISUBRO,IFOUND,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
C
C               *****************************************
C               **  STEP 52--                          **
C               **  PERFORM CHI-SQUARE TEST            **
C               *****************************************
C
        ISTEPN='52'
        IF(IBUGA2.EQ.'ON' .OR. ISUBRO.EQ.'CSTE')THEN
          CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,5211)
 5211     FORMAT('***** FROM DPCSTE, BEFORE CALL DPCST2--')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,5212)I,J,NS1,MAXN
 5212     FORMAT('I,J,NS1,MAXN = ',4I8)
          CALL DPWRST('XXX','BUG ')
          DO5215II=1,NS1
            WRITE(ICOUT,5216)II,Y(II)
 5216       FORMAT('I,Y(I),X(I) = ',I8,2G15.7)
            CALL DPWRST('XXX','BUG ')
 5215     CONTINUE
        ENDIF
C
        IVARID=IVARN1(I)
        IVARI2=IVARN2(I)
        CALL DPCST2(Y,NS1,SIGMA0,
     1              XTEMP1,XTEMP2,MAXNXT,
     1              ICAPSW,ICAPTY,IFORSW,
     1              IVARID,IVARI2,ICASA2,
     1              STATVA,STATCD,STATNU,PVAL2T,PVALLT,PVALUT,
     1              CTL999,CUTL99,CUTL95,CUTL90,CUTL80,CUTL50,
     1              CTU999,CUTU99,CUTU95,CUTU90,CUTU80,CUTU50,
     1              IBUGA3,ISUBRO,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
C
C               ***************************************
C               **  STEP 8C--                        **
C               **  UPDATE INTERNAL DATAPLOT TABLES  **
C               ***************************************
C
        ISTEPN='8C'
        IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'CSTE')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
        IF(ISTOP-ISTART.GT.0)THEN
          IFLAGU='FILE'
        ELSE
          IFLAGU='ON'
        ENDIF
        IFRST=.FALSE.
        ILAST=.FALSE.
        IF(I.EQ.ISTART)IFRST=.TRUE.
        IF(I.EQ.ISTOP)ILAST=.TRUE.
        STATV2=CPUMIN
        STATC2=CPUMIN
        STATN2=CPUMIN
        ICASA3='ONES'
        CALL DPTTE5(ICASA3,STATVA,STATCD,STATNU,
     1              STATV2,STATC2,STATN2,
     1              PVAL2T,PVALLT,PVALUT,
     1              CTL999,CUTL99,CUTL95,CUTL90,CUTL80,CUTL50,
     1              CTU999,CUTU99,CUTU95,CUTU90,CUTU80,CUTU50,
     1              IFLAGU,IFRST,ILAST,
     1              IBUGA2,IBUGA3,ISUBRO,IERROR)
C
 5210 CONTINUE
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA2.EQ.'ON' .OR. ISUBRO.EQ.'CSTE')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPCSTE--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9016)IFOUND,IERROR
 9016   FORMAT('IFOUND,IERROR = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9018)STATVA,STATCD,PVAL
 9018   FORMAT('STATVA,STATCD,PVAL = ',3G15.7)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPCST2(Y1,N1,SIGMA0,
     1                  XTEMP1,XTEMP2,MAXNXT,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  IVARID,IVARI2,ICASA2,
     1                  STATVA,STATCD,STATNU,PVAL2T,PVALLT,PVALUT,
     1                  CTL999,CUTL99,CUTL95,CUTL90,CUTL80,CUTL50,
     1                  CTU999,CUTU99,CUTU95,CUTU90,CUTU80,CUTU50,
     1                  IBUGA3,ISUBRO,IERROR)
C
C     PURPOSE--THIS ROUTINE CARRIES OUT A ONE-SAMPLE CHI-SQUARED TEST
C     EXAMPLE--CHI-SQUARED TEST Y SIGMA0
C              CHI-SQUARED TEST SIGMA0 Y
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--MAY       1984.
C     UPDATED         --APRIL     1987.  (LARRY KNAB CORRECTION--
C                                        BROWNLEE, P. 225)
C     UPDATED         --FEBRUARY  1994.  REFORMAT OUTPUT
C     UPDATED         --FEBRUARY  1994.  DPWRST: 'BUG ' => 'WRIT'
C     UPDATED         --DECEMBER  1994.  COPY CHI-SQUARED TEST PARAM.
C     UPDATED         --OCTOBER   2001.  MODIFY SOME OF THE
C                                        PRINT OUT FOR BETTER
C                                        CLARITY
C     UPDATED         --JANUARY   2004.  SUPPORT FOR HTML, LATEX
C     UPDATED         --APRIL     2011.  USE DPDTA1 AND DPDTA5 TO
C                                        PRINT OUTPUT.  REFORMAT OUTPUT
C                                        SOMEWHAT AS WELL.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IVARID
      CHARACTER*4 IVARI2
      CHARACTER*4 ICASA2
      CHARACTER*4 IBUGA3
      CHARACTER*4 ISUBRO
      CHARACTER*4 IERROR
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
C
      CHARACTER*4 IWRITE
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      DIMENSION Y1(*)
      DIMENSION XTEMP1(*)
      DIMENSION XTEMP2(*)
C
      PARAMETER (NUMALP=6)
      REAL ALPHA(NUMALP)
C
      PARAMETER(NUMCLI=5)
      PARAMETER(MAXLIN=3)
      PARAMETER (MAXROW=NUMALP)
      PARAMETER (MAXRO2=30)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*60 ITITL9
      CHARACTER*60 ITEXT(MAXRO2)
      CHARACTER*4  ALIGN(NUMCLI)
      CHARACTER*4  VALIGN(NUMCLI)
      REAL         AVALUE(MAXRO2)
      INTEGER      NCTEXT(MAXRO2)
      INTEGER      IDIGIT(MAXRO2)
      INTEGER      NTOT(MAXRO2)
      CHARACTER*60 ITITL2(MAXLIN,NUMCLI)
      CHARACTER*15 IVALUE(MAXROW,NUMCLI)
      CHARACTER*4  ITYPCO(NUMCLI)
      INTEGER      NCTIT2(MAXLIN,NUMCLI)
      INTEGER      NCVALU(MAXROW,NUMCLI)
      INTEGER      IWHTML(NUMCLI)
      INTEGER      IWRTF(NUMCLI)
      REAL         AMAT(MAXROW,NUMCLI)
      LOGICAL IFRST
      LOGICAL ILAST
      LOGICAL IFLAGS
      LOGICAL IFLAGE
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA ALPHA/0.50, 0.80, 0.90, 0.95, 0.99, 0.999/
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPCS'
      ISUBN2='T2  '
C
      IERROR='NO'
      IWRITE='OFF'
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'CST2')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPCST2--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,SIGMA0,N1
   52   FORMAT('IBUGA3,ISUBRO,SIGMA0,N1 = ',2(A4,2X),G15.7,I8)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,N1
          WRITE(ICOUT,57)I,Y1(I)
   57     FORMAT('I,Y1(I) = ',I8,G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ******************************
C               **  STEP 31--               **
C               **  CARRY OUT CALCULATIONS  **
C               **  FOR A CHI-SQUARED TEST  **
C               ******************************
C
      ISTEPN='31'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CST2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      CALL DPCST3(Y1,N1,SIGMA0,IWRITE,
     1            STATVA,STATCD,STATNU,
     1            YMEAN,YSD,RATIO,
     1            ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      IDF=INT(STATNU+0.1)
      CALL CHSPPF(.0005,IDF,CTL999)
      CALL CHSPPF(.005,IDF,CUTL99)
      CALL CHSPPF(.025,IDF,CUTL95)
      CALL CHSPPF(.05,IDF,CUTL90)
      CALL CHSPPF(.1,IDF,CUTL80)
      CALL CHSPPF(.25,IDF,CUTL50)
      CALL CHSPPF(.75,IDF,CUTU50)
      CALL CHSPPF(.90,IDF,CUTU80)
      CALL CHSPPF(.95,IDF,CUTU90)
      CALL CHSPPF(.975,IDF,CUTU95)
      CALL CHSPPF(.995,IDF,CUTU99)
      CALL CHSPPF(.9995,IDF,CTU999)
C
      PVALLT=STATCD
      PVALUT=1.0 - STATCD
      IF(YSD.LE.SIGMA0)THEN
        PVAL2T=2.0*STATCD
      ELSE
        PVAL2T=2.0*(1.0 - STATCD)
      ENDIF
C
C               *******************************
C               **   STEP 32--               **
C               **   WRITE OUT EVERYTHING    **
C               **   FOR A CHI-SQUARED TEST  **
C               *******************************
C
      ISTEPN='22'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CST2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IPRINT.EQ.'OFF')GOTO9000
C
      ITITLE='One Sample Chi-Square Standard Deviation Test'
      NCTITL=45
      ITITLZ=' '
      NCTITZ=0
C
      ICNT=1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Response Variable: '
      WRITE(ITEXT(ICNT)(20:23),'(A4)')IVARID(1:4)
      WRITE(ITEXT(ICNT)(24:27),'(A4)')IVARI2(1:4)
      NCTEXT(ICNT)=27
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=1
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='H0: Standard Deviation Equal'
      NCTEXT(ICNT)=28
      AVALUE(ICNT)=SIGMA0
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='H0: Standard Deviation Not Equal'
      NCTEXT(ICNT)=32
      AVALUE(ICNT)=SIGMA0
      IDIGIT(ICNT)=NUMDIG
C
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=1
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(N1)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=YMEAN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=YSD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=1
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Test:'
      NCTEXT(ICNT)=5
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='s/sigma0'
      NCTEXT(ICNT)=8
      AVALUE(ICNT)=RATIO
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Chi-Square Test Statistic Value:'
      NCTEXT(ICNT)=32
      AVALUE(ICNT)=STATVA
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Degrees of Freedom:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=INT(STATNU+0.1)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='CDF Value:'
      NCTEXT(ICNT)=10
      AVALUE(ICNT)=STATCD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='P-Value (2-tailed test):'
      NCTEXT(ICNT)=24
      AVALUE(ICNT)=PVAL2T
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='P-Value (lower-tailed test):'
      NCTEXT(ICNT)=28
      AVALUE(ICNT)=PVALLT
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='P-Value (upper-tailed test):'
      NCTEXT(ICNT)=28
      AVALUE(ICNT)=PVALUT
      IDIGIT(ICNT)=NUMDIG
C
      NUMROW=ICNT
      DO2110I=1,NUMROW
        NTOT(I)=15
 2110 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.TRUE.
C
      ISTEPN='21A'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CST2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
      ISTEPN='21B'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CST2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      ITITLE='Two-Tailed Test'
      NCTITL=15
      ITITL9='H0: sigma = sigma0; Ha: sigma <> sigma0'
      NCTIT9=39
C
      DO2130J=1,5
        DO2140I=1,3
          ITITL2(I,J)=' '
          NCTIT2(I,J)=0
 2140   CONTINUE
 2130 CONTINUE
C
      ITITL2(2,1)='Significance'
      NCTIT2(2,1)=12
      ITITL2(3,1)='Level'
      NCTIT2(3,1)=5
C
      ITITL2(2,2)='Test '
      NCTIT2(2,2)=4
      ITITL2(3,2)='Statistic'
      NCTIT2(3,2)=9
C
      ITITL2(1,3)='Lower'
      NCTIT2(1,3)=5
      ITITL2(2,3)='Critical'
      NCTIT2(2,3)=8
      ITITL2(3,3)='Value (<)'
      NCTIT2(3,3)=9
C
      ITITL2(1,4)='Upper'
      NCTIT2(1,4)=5
      ITITL2(2,4)='Critical'
      NCTIT2(2,4)=8
      ITITL2(3,4)='Value (>)'
      NCTIT2(3,4)=9
C
      ITITL2(1,5)='Null'
      NCTIT2(1,5)=4
      ITITL2(2,5)='Hypothesis'
      NCTIT2(2,5)=10
      ITITL2(3,5)='Conclusion'
      NCTIT2(3,5)=10
C
      NMAX=0
      NUMCOL=5
      DO2150I=1,NUMCOL
        VALIGN(I)='b'
        ALIGN(I)='r'
        NTOT(I)=15
        NMAX=NMAX+NTOT(I)
        ITYPCO(I)='NUME'
        IDIGIT(I)=NUMDIG
        IF(I.EQ.1 .OR. I.EQ.5)THEN
          ITYPCO(I)='ALPH'
        ENDIF
 2150 CONTINUE
C
      IWHTML(1)=125
      IWHTML(2)=150
      IWHTML(3)=150
      IWHTML(4)=150
      IWHTML(5)=150
      IINC=1600
      IINC2=1400
      IWRTF(1)=IINC
      IWRTF(2)=IWRTF(1)+IINC
      IWRTF(3)=IWRTF(2)+IINC
      IWRTF(4)=IWRTF(3)+IINC
      IWRTF(5)=IWRTF(4)+IINC
C
      DO2160J=1,NUMALP
C
        AMAT(J,2)=STATVA
        ALPHAT=(1.0 - ALPHA(J))/2.0
        CALL CHSPPF(ALPHAT,IDF,ATEMP)
        AMAT(J,3)=ATEMP
        ALPHAT=1.0 - ALPHAT
        CALL CHSPPF(ALPHAT,IDF,ATEMP)
        AMAT(J,4)=ATEMP
        IVALUE(J,5)(1:6)='ACCEPT'
        IF(STATVA.LT.AMAT(J,3))IVALUE(J,5)(1:6)='REJECT'
        IF(STATVA.GT.AMAT(J,4))IVALUE(J,5)(1:6)='REJECT'
        NCVALU(J,5)=6
C
        ALPHAT=100.0*ALPHA(J)
        WRITE(IVALUE(J,1)(1:4),'(F4.1)')ALPHAT
        IVALUE(J,1)(5:5)='%'
        NCVALU(J,1)=5
 2160 CONTINUE
C
      ICNT=NUMALP
      NUMLIN=3
      IFRST=.TRUE.
      ILAST=.TRUE.
      IFLAGS=.TRUE.
      IFLAGE=.TRUE.
      IF(ICASA2.NE.'LOWE' .AND. ICASA2.NE.'UPPE')THEN
        CALL DPDTA5(ITITLE,NCTITL,
     1              ITITL9,NCTIT9,ITITL2,NCTIT2,
     1              MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1              IVALUE,NCVALU,AMAT,ITYPCO,MAXROW,ICNT,
     1              IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1              ICAPSW,ICAPTY,IFRST,ILAST,
     1              IFLAGS,IFLAGE,
     1              ISUBRO,IBUGA3,IERROR)
      ENDIF
      IF(ICASA2.EQ.'TWOT')GOTO9000
C
      ITITLE='Lower-Tailed Test'
      NCTITL=17
      ITITL9='H0: sigma = sigma0; Ha: sigma < sigma0'
      NCTIT9=38
C
      ITITL2(1,3)='Lower'
      NCTIT2(1,3)=5
      ITITL2(2,3)='Critical'
      NCTIT2(2,3)=8
      ITITL2(3,3)='Value (<)'
      NCTIT2(3,3)=9
C
      ITITL2(1,4)='Null'
      NCTIT2(1,4)=4
      ITITL2(2,4)='Hypothesis'
      NCTIT2(2,4)=10
      ITITL2(3,4)='Conclusion'
      NCTIT2(3,4)=10
C
      NMAX=0
      NUMCOL=4
      DO2250I=1,NUMCOL
        VALIGN(I)='b'
        ALIGN(I)='r'
        NTOT(I)=15
        NMAX=NMAX+NTOT(I)
        ITYPCO(I)='NUME'
        IDIGIT(I)=NUMDIG
        IF(I.EQ.1 .OR. I.EQ.4)THEN
          ITYPCO(I)='ALPH'
        ENDIF
 2250 CONTINUE
C
      DO2260J=1,NUMALP
C
        AMAT(J,2)=STATVA
        ALPHAT=(1.0 - ALPHA(J))
        CALL CHSPPF(ALPHAT,IDF,ATEMP)
        AMAT(J,3)=ATEMP
        IVALUE(J,4)(1:6)='ACCEPT'
        IF(STATVA.LT.AMAT(J,3))IVALUE(J,4)(1:6)='REJECT'
        NCVALU(J,4)=6
C
        ALPHAT=100.0*ALPHA(J)
        WRITE(IVALUE(J,1)(1:4),'(F4.1)')ALPHAT
        IVALUE(J,1)(5:5)='%'
        NCVALU(J,1)=5
 2260 CONTINUE
C
      ICNT=NUMALP
      NUMLIN=3
      IFRST=.TRUE.
      ILAST=.TRUE.
      IFLAGS=.TRUE.
      IFLAGE=.TRUE.
      IF(ICASA2.NE.'UPPE')THEN
        CALL DPDTA5(ITITLE,NCTITL,
     1              ITITL9,NCTIT9,ITITL2,NCTIT2,
     1              MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1              IVALUE,NCVALU,AMAT,ITYPCO,MAXROW,ICNT,
     1              IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1              ICAPSW,ICAPTY,IFRST,ILAST,
     1              IFLAGS,IFLAGE,
     1              ISUBRO,IBUGA3,IERROR)
      ENDIF
      IF(ICASA2.EQ.'LOWE')GOTO9000
C
      ITITLE='Upper-Tailed Test'
      NCTITL=17
      ITITL9='H0: sigma = sigma0; Ha: sigma > sigma0'
      NCTIT9=38
C
      ITITL2(1,3)='Upper'
      NCTIT2(1,3)=5
      ITITL2(2,3)='Critical'
      NCTIT2(2,3)=8
      ITITL2(3,3)='Value (>)'
      NCTIT2(3,3)=9
C
      NMAX=0
      NUMCOL=4
      DO2350I=1,NUMCOL
        NTOT(I)=15
        NMAX=NMAX+NTOT(I)
 2350 CONTINUE
C
      DO2360J=1,NUMALP
C
        ALPHAT=ALPHA(J)
        CALL CHSPPF(ALPHAT,IDF,ATEMP)
        AMAT(J,3)=ATEMP
        IVALUE(J,4)(1:6)='ACCEPT'
        IF(STATVA.GT.AMAT(J,3))IVALUE(J,4)(1:6)='REJECT'
        NCVALU(J,4)=6
 2360 CONTINUE
C
      ICNT=NUMALP
      NUMLIN=3
      IFRST=.TRUE.
      ILAST=.TRUE.
      IFLAGS=.TRUE.
      IFLAGE=.TRUE.
      IF(ICASA2.NE.'LOWE')THEN
        CALL DPDTA5(ITITLE,NCTITL,
     1              ITITL9,NCTIT9,ITITL2,NCTIT2,
     1              MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1              IVALUE,NCVALU,AMAT,ITYPCO,MAXROW,ICNT,
     1              IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1              ICAPSW,ICAPTY,IFRST,ILAST,
     1              IFLAGS,IFLAGE,
     1              ISUBRO,IBUGA3,IERROR)
      ENDIF
C
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'CST2')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPCST2--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9013)IERROR,STATVA,STATCD,STATNU
 9013   FORMAT('IERROR,STATVA,STATCD,STATNU = ',A4,3G15.7)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPCST3(X,N,SIGMA0,IWRITE,
     1                  STATVA,STATCD,STATNU,
     1                  XMEAN,XSD,RATIO,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE ONE SAMPLE CHI-SQUARE TEST
C              (AND ALTERNATIVELY THE CDF VALUE).
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VECTOR OF
C                                (UNSORTED OR SORTED) OBSERVATIONS.
C                     --N      = THE INTEGER NUMBER OF OBSERVATIONS
C                                IN THE VECTOR X.
C                     --SIGMA0 = THE SINGLE PRECISION VALUE FOR WHICH
C                                THE TEST IS PERFORMED (I.E.,
C                                H0: SIGMA = SIGMA0).
C     OUTPUT ARGUMENTS--STATVA = THE SINGLE PRECISION VALUE OF THE
C                                COMPUTED STATISTIC.
C                     --STATCD = THE SINGLE PRECISION VALUE OF THE
C                                COMPUTED CDF OF THE TEST STATISTIC.
C     OUTPUT--THE COMPUTED SINGLE PRECISION VALUE OF THE
C             TEST STATISTIC.
C     RESTRICTIONS--THERE IS NO RESTRICTION ON THE MAXIMUM VALUE
C                   OF N FOR THIS SUBROUTINE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--CHSCDF.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2009.2
C     ORIGINAL VERSION--FEBRUARY  2009.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IWRITE
      CHARACTER*4 IWRTSV
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
C---------------------------------------------------------------------
C
      DIMENSION X(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPCS'
      ISUBN2='T3  '
      IWRTSV=IWRITE
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'CST3')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPCST3--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGA3
   52   FORMAT('IBUGA3 = ',A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,53)N,SIGMA0
   53   FORMAT('N,SIGMA0 = ',I8,G15.7)
        CALL DPWRST('XXX','BUG ')
        DO55I=1,N
          WRITE(ICOUT,56)I,X(I)
   56     FORMAT('I,X(I) = ',I8,G15.7)
          CALL DPWRST('XXX','BUG ')
   55   CONTINUE
      ENDIF
C
C               ******************************************
C               **  COMPUTE ONE SAMPLE CHI-SQUARE TEST  **
C               ******************************************
C
C               ********************************************
C               **  STEP 1--                              **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      STATVA=-99.0
      STATCD=-99.0
      IWRITE='OFF'
C
      AN=N
C
      IF(N.LE.1)THEN
        IERROR='YES'
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,111)
  111   FORMAT('***** ERROR IN CHI-SQUARE SD TEST--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,112)
  112   FORMAT('      THE INPUT NUMBER OF OBSERVATIONS FOR THE ',
     1         'RESPONSE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,113)
  113   FORMAT('      VARIABLE MUST BE 2 OR LARGER.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,116)
  116   FORMAT('      SUCH WAS NOT THE CASE HERE.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,117)N
  117   FORMAT('      THE INPUT NUMBER OF OBSERVATIONS HERE = ',I8,
     1         '.')
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
C
      IF(SIGMA0.LE.0.0)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,111)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1101)
 1101   FORMAT('      THE SPECIFIED SIGMA0 IS NON-POSITIVE.')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1102)SIGMA0
 1102   FORMAT('SIGMA0 = ',G15.7)
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      HOLD=X(1)
      DO1135I=2,N
        IF(X(I).NE.HOLD)GOTO1139
 1135 CONTINUE
 1130 CONTINUE
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,111)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1131)HOLD
 1131 FORMAT('      THE RESPONSE VARIABLE HAS ALL ELEMENTS = ',G15.7)
      CALL DPWRST('XXX','WRIT')
      IERROR='YES'
      GOTO9000
 1139 CONTINUE
C
C               ***********************************************
C               **  STEP 2--                                 **
C               **  COMPUTE THE ONE SAMPLE CHI-SQUARE TEST.  **
C               ***********************************************
C
      CALL MEAN(X,N,IWRITE,XMEAN,IBUGA3,IERROR)
      CALL SD(X,N,IWRITE,XSD,IBUGA3,IERROR)
      AN=N
      RATIO=XSD/SIGMA0
      STATVA=(AN-1.0)*RATIO**2
      IDF=N-1
      STATNU=REAL(IDF)
      CALL CHSCDF(STATVA,IDF,STATCD)
C
C               *******************************
C               **  STEP 3--                 **
C               **  WRITE OUT A LINE         **
C               **  OF SUMMARY INFORMATION.  **
C               *******************************
C
  800 CONTINUE
      IF(IFEEDB.EQ.'ON' .AND. IWRITE.EQ.'ON')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,811)N,STATVA
  811   FORMAT('THE VALUE OF THE CHI-SQUARE SD TEST OF THE ',I8,
     1         ' OBSERVATIONS = ',G15.7)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
C
      IWRITE=IWRTSV
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'CST3')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPCST3--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)IBUGA3,IERROR
 9012   FORMAT('IBUGA3,IERROR = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9015)STATVA,STATCD
 9015   FORMAT('STATVA,STATCD = ',2G15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9016)XMEAN,XSD
 9016   FORMAT('XMEAN,XSD = ',2G15.7)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPCUBE(IHARG,IARGT,ARG,NUMARG,
     1PXSTAR,PYSTAR,
     1PXEND,PYEND,
     1ILINPA,ILINCO,PLINTH,
     1AREGBA,
     1IREBLI,IREBCO,PREBTH,
     1IREFSW,IREFCO,
     1IREPTY,IREPLI,IREPCO,PREPTH,PREPSP,
     1PTEXHE,PTEXWI,PTEXVG,PTEXHG,
     1IGRASW,IDIASW,
     1PGRAXF,PGRAYF,PDIAXC,PDIAYC,PDIAX2,PDIAY2,
     1PDIAHE,PDIAWI,PDIAVG,PDIAHG,
     1NUMDEV,
     1IDMANU,IDMODE,IDMOD2,IDMOD3,
     1IDPOWE,IDCONT,IDCOLO,IDNVPP,IDNHPP,IDUNIT,
     1IDNVOF,IDNHOF,
CCCCC ADD FOLLOWING LINE MARCH 1997.
     1IDFONT,
CCCCC ADD FOLLOWING LINE JULY 1997.
     1UNITSW,
     1IBUGD2,IFOUND,IERROR)
C
C     PURPOSE--DRAW ONE OR MORE CUBES
C              (DEPENDING ON HOW MANY NUMBERS ARE PROVIDED).
C              THE COORDINATES ARE IN STANDARDIZED UNITS
C              OF 0 TO 100.
C     NOTE--THE INPUT COORDINATES DEFINE THE OPPOSING CORNERS
C           OF (THE FRONT FACE OF) THE CUBE.
C     NOTE-THE USUAL INPUT NUMBER OF COORDINATES IS 2
C          AND THEREFORE THE USUAL INPUT NUMBER OF NUMBERS IS 2*2 = 4.
C     NOTE--IF 2 NUMBERS ARE PROVIDED,
C           THEN THE DRAWN CUBE WILL GO
C           FROM THE LAST CURSOR POSITION
C           TO THE (X,Y) POINT
C           (EITHER ABSOLUTE OR RELATIVE)
C           AS DEFINED BY THE 2 NUMBERS.
C     NOTE--IF 4 NUMBERS ARE PROVIDED,
C           THEN THE DRAWN CUBE WILL GO
C           FROM THE ABSOLUTE (X,Y) POSITION
C           AS DEFINED BY THE FIRST 2 NUMBERS
C           TO THE (X,Y) POINT
C           (EITHER ABSOLUTE OR RELATIVE)
C           AS DEFINED BY THE THIRD AND FOURTH NUMBERS.
C     NOTE--IF 6 NUMBERS ARE PROVIDED,
C           THEN THE DRAWN CUBE WILL GO
C           FROM THE (X,Y) POSITION
C           AS RESULTING FROM THE THIRD AND FOURTH NUMBERS
C           TO THE (X,Y) POINT
C           (EITHER ABSOLUTE OR RELATIVE)
C           AS DEFINED BY THE FIFTH AND SIXTH NUMBERS.
C     NOTE--AND SO FORTH FOR 8, 10, 12, ... NUMBERS.
C     INPUT  ARGUMENTS--IHARG
C                     --IARGT
C                     --ARG
C                     --NUMARG
C                     --PXSTAR
C                     --PYSTAR
C     OUTPUT ARGUMENTS--PXEND
C                     --PYEND
C                     --IFOUND ('YES' OR 'NO' )
C                     --IERROR ('YES' OR 'NO' )
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--APRIL     1987.
C     UPDATED         --JANUARY   1989.  CALL LIST FOR OFFSET VAR (ALAN)
C     UPDATED         --MARCH     1997.  SUPPORT FOR DEVICE FONT (ALAN)
C     UPDATED         --JULY      1997.  SUPPORT FOR "DATA" UNITS (ALAN)
C
C-----NON-COMMON VARIABLES-----------------------------------------
C
      CHARACTER*4 IHARG
      CHARACTER*4 IARGT
C
      CHARACTER*4 ILINPA
      CHARACTER*4 ILINCO
C
      CHARACTER*4 IREBLI
      CHARACTER*4 IREBCO
      CHARACTER*4 IREFSW
      CHARACTER*4 IREFCO
      CHARACTER*4 IREPTY
      CHARACTER*4 IREPLI
      CHARACTER*4 IREPCO
C
      CHARACTER*4 IGRASW
      CHARACTER*4 IDIASW
C
      CHARACTER*4 IDMANU
      CHARACTER*4 IDMODE
      CHARACTER*4 IDMOD2
      CHARACTER*4 IDMOD3
      CHARACTER*4 IDPOWE
      CHARACTER*4 IDCONT
      CHARACTER*4 IDCOLO
CCCCC ADD FOLLOWING LINE MARCH 1997.
      CHARACTER*4 IDFONT
CCCCC ADD FOLLOWING LINE JULY 1997.
      CHARACTER*4 UNITSW
C
      CHARACTER*4 IFOUND
      CHARACTER*4 IBUGD2
      CHARACTER*4 IERROR
      CHARACTER*4 ISUBRO
C
      CHARACTER*4 IFIG
      CHARACTER*4 IBELSW
      CHARACTER*4 IERASW
      CHARACTER*4 IBACCO
      CHARACTER*4 ICOPSW
      CHARACTER*4 ITYPEO
C
      DIMENSION IHARG(*)
      DIMENSION IARGT(*)
      DIMENSION ARG(*)
C
      DIMENSION ILINPA(*)
      DIMENSION ILINCO(*)
      DIMENSION PLINTH(*)
C
      DIMENSION AREGBA(*)
      DIMENSION IREBLI(*)
      DIMENSION IREBCO(*)
      DIMENSION PREBTH(*)
      DIMENSION IREFSW(*)
      DIMENSION IREFCO(*)
      DIMENSION IREPTY(*)
      DIMENSION IREPLI(*)
      DIMENSION IREPCO(*)
      DIMENSION PREPTH(*)
      DIMENSION PREPSP(*)
C
      DIMENSION IDMANU(*)
      DIMENSION IDMODE(*)
      DIMENSION IDMOD2(*)
      DIMENSION IDMOD3(*)
      DIMENSION IDPOWE(*)
      DIMENSION IDCONT(*)
      DIMENSION IDCOLO(*)
CCCCC ADD FOLLOWING LINE MARCH 1997.
      DIMENSION IDFONT(*)
      DIMENSION IDNVPP(*)
      DIMENSION IDNHPP(*)
      DIMENSION IDUNIT(*)
C
      DIMENSION IDNVOF(*)
      DIMENSION IDNHOF(*)
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOGR.INC'
      INCLUDE 'DPCOBE.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IFOUND='NO'
      IERROR='NO'
      IERRG4=IERROR
CCCCC IBUGG4=IBUGD2
CCCCC ISUBG4=ISUBRO
C
      ILOCFN=0
      NUMNUM=0
C
      X1=0.0
      Y1=0.0
      X2=0.0
      Y2=0.0
C
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'CUBE')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF DPCUBE--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)NUMARG
   53 FORMAT('NUMARG = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO55I=1,NUMARG
      WRITE(ICOUT,56)I,IHARG(I),IARGT(I),ARG(I)
   56 FORMAT('I,IHARG(I),IARGT(I),ARG(I) = ',I8,2X,A4,2X,A4,E15.7)
      CALL DPWRST('XXX','BUG ')
   55 CONTINUE
      WRITE(ICOUT,57)PXSTAR,PYSTAR
   57 FORMAT('PXSTAR,PYSTAR = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,58)PXEND,PYEND
   58 FORMAT('PXEND,PYEND = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,61)ILINPA(1),ILINCO(1),PLINTH(1)
   61 FORMAT('ILINPA(1),ILINCO(1),PLINTH(1) = ',A4,2X,A4,E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,62)AREGBA(1)
   62 FORMAT('AREGBA(1) = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,63)IREBLI(1),IREBCO(1),PREBTH(1)
   63 FORMAT('IREBLI(1),IREBCO(1),PREBTH(1) = ',A4,2X,A4,E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,64)IREFSW(1),IREFCO(1)
   64 FORMAT('IREFSW(1),IREFCO(1) = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,65)IREPTY(1),IREPLI(1),IREPCO(1),PREPTH(1),PREPSP(1)
   65 FORMAT('IREPTY(1),IREPLI(1),IREPCO(1),PREPTH(1),PREPSP(1) = ',
     1A4,2X,A4,2X,A4,2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,69)PTEXHE,PTEXWI
   69 FORMAT('PTEXHE,PTEXWI= ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,70)PTEXVG,PTEXHG
   70 FORMAT('PTEXVG,PTEXHG= ',2E15.6)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,76)IGRASW,IDIASW
   76 FORMAT('IGRASW,IDIASW = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,77)PGRAXF,PGRAYF,PDIAXC,PDIAYC
   77 FORMAT('PGRAXF,PGRAYF,PDIAXC,PDIAYC = ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,78)PDIAHE,PDIAWI,PDIAVG,PDIAHG
   78 FORMAT('PDIAHE,PDIAWI,PDIAVG,PDIAHG = ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,80)NUMDEV
   80 FORMAT('NUMDEV= ',I8)
      CALL DPWRST('XXX','BUG ')
      DO81I=1,NUMDEV
      WRITE(ICOUT,82)IDMANU(I),IDMODE(I),IDMOD2(I),IDMOD3(I)
   82 FORMAT('IDMANU(I),IDMODE(I),IDMOD2(I),IDMOD3(I) = ',
     1A4,2X,A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,83)IDPOWE(I),IDCONT(I),IDCOLO(I)
   83 FORMAT('IDPOWE(I),IDCONT(I),IDCOLO(I) = ',
     1A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,84)IDNVPP(I),IDNHPP(I),IDUNIT(I)
   84 FORMAT('IDNVPP(I),IDNHPP(I),IDUNIT(I) = ',
     1I8,I8,I8)
      CALL DPWRST('XXX','BUG ')
   81 CONTINUE
      WRITE(ICOUT,87)IFOUND
   87 FORMAT('IFOUND= ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,88)IBUGG4,ISUBG4,IERRG4
   88 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,89)IBUGD2,IERROR
   89 FORMAT('IBUGD2,IERROR= ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
      IFIG='CUBE'
      NUMPT=2
      NUMPT2=2*NUMPT
C
C               ********************************
C               **  STEP 0--                  **
C               **  STEP THROUGH EACH DEVICE  **
C               ********************************
C
      IF(NUMDEV.LE.0)GOTO9000
      DO8000IDEVIC=1,NUMDEV
C
      IF(IDPOWE(IDEVIC).EQ.'OFF')GOTO8000
C
      IMANUF=IDMANU(IDEVIC)
      IMODEL=IDMODE(IDEVIC)
      IMODE2=IDMOD2(IDEVIC)
      IMODE3=IDMOD3(IDEVIC)
      IGCONT=IDCONT(IDEVIC)
      IGCOLO=IDCOLO(IDEVIC)
CCCCC ADD FOLLOWING LINE MARCH 1997.
      IGFONT=IDFONT(IDEVIC)
      NUMVPP=IDNVPP(IDEVIC)
      NUMHPP=IDNHPP(IDEVIC)
      ANUMVP=NUMVPP
      ANUMHP=NUMHPP
C  AUGUST 1988.  ADD OFFSET VARIABLE
      IOFFSV=IDNVOF(IDEVIC)
      IOFFSH=IDNHOF(IDEVIC)
C
      IGUNIT=IDUNIT(IDEVIC)
C
C               ************************************
C               **  STEP 1--                      **
C               **  CARRY OUT OPENING OPERATIONS  **
C               **  ON THE GRAPHICS DEVICES       **
C               ************************************
C
      CALL DPOPDE
C
      IBELSW='OFF'
      NUMRIN=0
      IERASW='OFF'
      IBACCO='JUNK'
C
      CALL DPOPPL(IGRASW,
     1IBELSW,NUMRIN,IERASW,
     1IBACCO)
C
C               *****************************************
C               **  STEP 2--                           **
C               **  SEARCH FOR COMMAND SPECIFICATIONS  **
C               *****************************************
C
      IF(NUMARG.GE.2.AND.
     1IARGT(1).EQ.'NUMB'.AND.IARGT(2).EQ.'NUMB')
     1GOTO1111
      IF(NUMARG.GE.3.AND.IHARG(1).EQ.'ABSO'.AND.
     1IARGT(2).EQ.'NUMB'.AND.IARGT(3).EQ.'NUMB')
     1GOTO1112
      IF(NUMARG.GE.3.AND.IHARG(1).EQ.'RELA'.AND.
     1IARGT(2).EQ.'NUMB'.AND.IARGT(3).EQ.'NUMB')
     1GOTO1113
      GOTO1130
C
 1111 CONTINUE
      ITYPEO='ABSO'
      ILOCFN=1
      GOTO1119
C
 1112 CONTINUE
      ITYPEO='ABSO'
      ILOCFN=2
      GOTO1119
C
 1113 CONTINUE
      ITYPEO='RELA'
      ILOCFN=2
      GOTO1119
 1119 CONTINUE
C
      IF(ILOCFN.GT.NUMARG)GOTO1129
      DO1120I=ILOCFN,NUMARG
      IF(IARGT(I).EQ.'NUMB')GOTO1120
      GOTO1129
 1120 CONTINUE
      IFOUND='YES'
      GOTO1149
 1129 CONTINUE
      GOTO1130
C
 1130 CONTINUE
      IERRG4='YES'
      WRITE(ICOUT,1131)
 1131 FORMAT('***** ERROR IN DPCUBE--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1132)
 1132 FORMAT('      ILLEGAL FORM FOR DRAW ',
     1'COMMAND.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1134)
 1134 FORMAT('      TEST EXAMPLE TO DEMONSTRATE THE ',
     1'PROPER FORM--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1135)
 1135 FORMAT('      SUPPOSE IT IS DESIRED TO DRAW A CUBE ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1136)
 1136 FORMAT('      WITH ONE FRONT FACE CORNER AT THE POINT 20 20 ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1137)
 1137 FORMAT('      AND THE FRONT FACE OPPOSITE CORNER AT 40 60')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1141)
 1141 FORMAT('      THEN THE ALLOWABLE FORMS ARE--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1142)
 1142 FORMAT('      CUBE 20 20 40 60 ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1143)
 1143 FORMAT('      CUBE ABSOLUTE 20 20 40 60 ')
      CALL DPWRST('XXX','BUG ')
      GOTO9000
 1149 CONTINUE
C
C               ****************************
C               **  STEP 3--              **
C               **  DRAW OUT THE LINE(S)  **
C               ****************************
C
      NUMNUM=NUMARG-ILOCFN+1
      IF(NUMNUM.LT.NUMPT2)GOTO1151
      GOTO1152
C
 1151 CONTINUE
      J=ILOCFN-1
      X1=PXSTAR
      Y1=PYSTAR
      GOTO1159
C
 1152 CONTINUE
      J=ILOCFN
      IF(J.GT.NUMARG)GOTO1190
      X1=ARG(J)
CCCCC THE FOLLOWING LINE WAS ADDED JULY 1997
      IF(UNITSW.EQ.'DATA')CALL DPCODS('X',X1,X1,IBUGD2,ISUBRO,IERROR)
      J=J+1
      IF(J.GT.NUMARG)GOTO1190
      Y1=ARG(J)
CCCCC THE FOLLOWING LINE WAS ADDED JULY 1997
      IF(UNITSW.EQ.'DATA')CALL DPCODS('Y',Y1,Y1,IBUGD2,ISUBRO,IERROR)
      GOTO1159
 1159 CONTINUE
C
 1160 CONTINUE
      J=J+1
      IF(J.GT.NUMARG)GOTO1190
      X2=ARG(J)
CCCCC THE FOLLOWING LINE WAS ADDED JULY 1997
      IF(UNITSW.EQ.'DATA')CALL DPCODS('X',X2,X2,IBUGD2,ISUBRO,IERROR)
      IF(ITYPEO.EQ.'RELA')X2=X1+X2
      J=J+1
      IF(J.GT.NUMARG)GOTO1190
      Y2=ARG(J)
CCCCC THE FOLLOWING LINE WAS ADDED JULY 1997
      IF(UNITSW.EQ.'DATA')CALL DPCODS('Y',Y2,Y2,IBUGD2,ISUBRO,IERROR)
      IF(ITYPEO.EQ.'RELA')Y2=Y1+Y2
C
 1170 CONTINUE
      CALL DPCUB2(X1,Y1,X2,Y2,
     1IFIG,
     1ILINPA,ILINCO,PLINTH,
     1AREGBA,
     1IREBLI,IREBCO,PREBTH,
     1IREFSW,IREFCO,
     1IREPTY,IREPLI,IREPCO,PREPTH,PREPSP,
     1PTEXHE,PTEXWI,PTEXVG,PTEXHG)
C
      X1=X2
      Y1=Y2
C
      GOTO1160
 1190 CONTINUE
C
      PXEND=X2
      PYEND=Y2
C
C               ************************************
C               **  STEP 4--                      **
C               **  CARRY OUT CLOSING OPERATIONS  **
C               **  ON THE GRAPHICS DEVICES       **
C               ************************************
C
      ICOPSW='OFF'
      NUMCOP=0
      CALL DPCLPL(ICOPSW,NUMCOP,
     1PGRAXF,PGRAYF,
     1IGRASW,PDIAXC,PDIAYC,PDIAX2,PDIAY2,
     1PDIAHE,PDIAWI,PDIAVG,PDIAHG)
C
      CALL DPCLDE
C
 8000 CONTINUE
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'CUBE')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF DPCUBE--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)ILOCFN,NUMNUM
 9012 FORMAT('ILOCFN,NUMNUM = ',2I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)X1,Y1,X2,Y2
 9013 FORMAT('X1,Y1,X2,Y2 = ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)PXSTAR,PYSTAR
 9015 FORMAT('PXSTAR,PYSTAR = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9016)PXEND,PYEND
 9016 FORMAT('PXEND,PYEND = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9017)IFIG
 9017 FORMAT('IFIG = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9027)IFOUND
 9027 FORMAT('IFOUND = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9028)IBUGG4,ISUBG4,IERRG4
 9028 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9029)IBUGD2,IERROR
 9029 FORMAT('IBUGD2,IERROR = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPCUB2(X1,Y1,X2,Y2,
     1IFIG,
     1ILINPA,ILINCO,PLINTH,
     1AREGBA,
     1IREBLI,IREBCO,PREBTH,
     1IREFSW,IREFCO,
     1IREPTY,IREPLI,IREPCO,PREPTH,PREPSP,
     1PTEXHE,PTEXWI,PTEXVG,PTEXHG)
C
C     PURPOSE--DRAW A CUBE
C              WITH ONE FRONT FACE CORNER AT (X1,Y1)
C              AND THE FRONT FACE OPPOSITE CORNER AT (X2,Y2).
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--87/5
C     ORIGINAL VERSION--APRIL     1987.
C     UPDATED         --JANUARY   1989.  MODIFY CALLS TO DPDRPL (ALAN)
C     UPDATED         --JANUARY   1989.  MODIFY CALL  TO DPFIRE (ALAN)
C
C-----NON-COMMON VARIABLES-------------------------------------
C
      CHARACTER*4 IFIG
      CHARACTER*4 IPATT2
C
      CHARACTER*4 ILINPA
      CHARACTER*4 ILINCO
C
      CHARACTER*4 IREBLI
      CHARACTER*4 IREBCO
      CHARACTER*4 IREFSW
      CHARACTER*4 IREFCO
      CHARACTER*4 IREPTY
      CHARACTER*4 IREPLI
      CHARACTER*4 IREPCO
C
      CHARACTER*4 IPATT
      CHARACTER*4 ICOLF
      CHARACTER*4 ICOLP
      CHARACTER*4 ICOL
      CHARACTER*4 IFLAG
C
      DIMENSION PX(20)
      DIMENSION PY(20)
CCCCC DIMENSION PX3(20)
CCCCC DIMENSION PY3(20)
C
      DIMENSION ILINPA(*)
      DIMENSION ILINCO(*)
      DIMENSION PLINTH(*)
C
      DIMENSION AREGBA(*)
      DIMENSION IREBLI(*)
      DIMENSION IREBCO(*)
      DIMENSION PREBTH(*)
      DIMENSION IREFSW(*)
      DIMENSION IREFCO(*)
      DIMENSION IREPTY(*)
      DIMENSION IREPLI(*)
      DIMENSION IREPCO(*)
      DIMENSION PREPTH(*)
      DIMENSION PREPSP(*)
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOGR.INC'
      INCLUDE 'DPCOBE.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'CUB2')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF DPCUB2--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)X1,Y1
   53 FORMAT('X1,Y1 = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)X2,Y2
   54 FORMAT('X2,Y2 = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,59)IFIG
   59 FORMAT('IFIG = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,61)ILINPA(1),ILINCO(1),PLINTH(1)
   61 FORMAT('ILINPA(1),ILINCO(1),PLINTH(1) = ',A4,2X,A4,E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,62)AREGBA(1)
   62 FORMAT('AREGBA(1) = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,63)IREBLI(1),IREBCO(1),PREBTH(1)
   63 FORMAT('IREBLI(1),IREBCO(1),PREBTH(1) = ',A4,2X,A4,E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,64)IREFSW(1),IREFCO(1)
   64 FORMAT('IREFSW(1),IREFCO(1) = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,65)IREPTY(1),IREPLI(1),IREPCO(1),PREPTH(1),PREPSP(1)
   65 FORMAT('IREPTY(1),IREPLI(1),IREPCO(1),PREPTH(1),PREPSP(1) = ',
     1A4,2X,A4,2X,A4,2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,69)PTEXHE,PTEXWI
   69 FORMAT('PTEXHE,PTEXWI= ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,70)PTEXVG,PTEXHG
   70 FORMAT('PTEXVG,PTEXHG= ',2E15.6)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,79)IBUGG4,ISUBG4,IERRG4
   79 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
C               *********************************
C               **  STEP 1--                   **
C               **  SET THE SPECS              **
C               **  WHICH CONTROL THE          **
C               **  APPEARANCE OF THE          **
C               **  RESULTING CUBE.            **
C               *********************************
C
      DELX=ABS(X2-X1)
      DELY=ABS(Y2-Y1)
      DELMIN=DELX
CCCCC IF(DELY.LT.DELX)DELMIN=DELY
      P3D=0.3
      DEL3D=P3D*DELMIN
C
C               *************************
C               **  STEP 2--           **
C               **  FILL THE FIGURE    **
C               **  (IF CALLED FOR)    **
C               *************************
C
      IF(IREFSW(1).EQ.'OFF')GOTO2190
C
      IPATT=IREPTY(1)
      PTHICK=PREPTH(1)
      PXGAP=PREPSP(1)
      PYGAP=PREPSP(1)
      ICOLF=IREFCO(1)
      ICOLP=IREPCO(1)
C
      IF(IREFSW(1).EQ.'ON')GOTO2110
      IF(IREFSW(1).EQ.'ONF')GOTO2110
      IF(IREFSW(1).EQ.'ONS')GOTO2120
      IF(IREFSW(1).EQ.'ONT')GOTO2130
      IF(IREFSW(1).EQ.'ONFS')GOTO2110
      IF(IREFSW(1).EQ.'ONSF')GOTO2110
      IF(IREFSW(1).EQ.'ONFT')GOTO2110
      IF(IREFSW(1).EQ.'ONTF')GOTO2110
      IF(IREFSW(1).EQ.'ONST')GOTO2120
      IF(IREFSW(1).EQ.'ONTS')GOTO2120
C
C               ********************************
C               **  STEP 2.1--                **
C               **  FRONT FACE ONLY           **
C               ********************************
C
 2110 CONTINUE
      PX(1)=X1
      PY(1)=Y1
C
      PX(2)=X2
      PY(2)=Y1
C
      PX(3)=X2
      PY(3)=Y2
C
      PX(4)=X1
      PY(4)=Y2
C
      PX(5)=X1
      PY(5)=Y1
C
      NP=5
C
      IPATT2='SOLI'
      CALL DPFIRE(PX,PY,NP,
     1IFIG,IPATT,PTHICK,PXGAP,PYGAP,ICOLF,ICOLP,IPATT2)
C
      IF(IREFSW(1).EQ.'ON')GOTO2120
      IF(IREFSW(1).EQ.'ONF')GOTO2190
      IF(IREFSW(1).EQ.'ONS')GOTO2120
      IF(IREFSW(1).EQ.'ONT')GOTO2130
      IF(IREFSW(1).EQ.'ONFS')GOTO2120
      IF(IREFSW(1).EQ.'ONSF')GOTO2120
      IF(IREFSW(1).EQ.'ONFT')GOTO2130
      IF(IREFSW(1).EQ.'ONTF')GOTO2130
      IF(IREFSW(1).EQ.'ONST')GOTO2120
      IF(IREFSW(1).EQ.'ONTS')GOTO2120
C
C               ********************************
C               **  STEP 2.2--                **
C               **  SIDE (= RIGHT) FACE ONLY  **
C               ********************************
C
C
 2120 CONTINUE
      PX(1)=X2
      PY(1)=Y2
C
      PX(2)=X2+DEL3D
      PY(2)=Y2+DEL3D
C
      PX(3)=X2+DEL3D
      PY(3)=Y1+DEL3D
C
      PX(4)=X2
      PY(4)=Y1
C
      PX(5)=X2
      PY(5)=Y2
C
      NP=5
C
      IPATT2='SOLI'
      CALL DPFIRE(PX,PY,NP,
     1IFIG,IPATT,PTHICK,PXGAP,PYGAP,ICOLF,ICOLP,IPATT2)
C
      IF(IREFSW(1).EQ.'ON')GOTO2130
      IF(IREFSW(1).EQ.'ONF')GOTO2190
      IF(IREFSW(1).EQ.'ONS')GOTO2190
      IF(IREFSW(1).EQ.'ONT')GOTO2130
      IF(IREFSW(1).EQ.'ONFS')GOTO2190
      IF(IREFSW(1).EQ.'ONSF')GOTO2190
      IF(IREFSW(1).EQ.'ONFT')GOTO2130
      IF(IREFSW(1).EQ.'ONTF')GOTO2130
      IF(IREFSW(1).EQ.'ONST')GOTO2130
      IF(IREFSW(1).EQ.'ONTS')GOTO2130
C
C               ********************************
C               **  STEP 2.3--                **
C               **  TOP FACE ONLY             **
C               ********************************
C
 2130 CONTINUE
      PX(1)=X1
      PY(1)=Y2
C
      PX(2)=X1+DEL3D
      PY(2)=Y2+DEL3D
C
      PX(3)=X2+DEL3D
      PY(3)=Y2+DEL3D
C
      PX(4)=X2
      PY(4)=Y2
C
      PX(5)=X1
      PY(5)=Y2
C
      NP=5
C
      IPATT2='SOLI'
      CALL DPFIRE(PX,PY,NP,
     1IFIG,IPATT,PTHICK,PXGAP,PYGAP,ICOLF,ICOLP,IPATT2)
C
 2190 CONTINUE
C
C               ***************************
C               **  STEP 3--             **
C               **  DRAW OUT THE FIGURE  **
C               ***************************
C
      IPATT=ILINPA(1)
      PTHICK=PLINTH(1)
      ICOL=ILINCO(1)
C
      PX(1)=X1
      PY(1)=Y1
C
      PX(2)=X2
      PY(2)=Y1
C
      PX(3)=X2
      PY(3)=Y2
C
      PX(4)=X1
      PY(4)=Y2
C
      PX(5)=X1
      PY(5)=Y1
C
      NP=5
C
      IFLAG='ON'
CCCCC CALL DPDRPL(PX,PY,NP,PX3,PY3,NP3,
CCCCC1IFIG,IPATT,PTHICK,ICOL)
      CALL DPDRPL(PX,PY,NP,
     1IFIG,IPATT,PTHICK,ICOL,
     1JPATT,JTHICK,PTHIC2,JCOL,IFLAG)
C
      PX(1)=X1
      PY(1)=Y2
C
      PX(2)=X1+DEL3D
      PY(2)=Y2+DEL3D
C
      PX(3)=X2+DEL3D
      PY(3)=Y2+DEL3D
C
      PX(4)=X2
      PY(4)=Y2
C
      NP=4
C
      IFLAG='ON'
CCCCC CALL DPDRPL(PX,PY,NP,PX3,PY3,NP3,
CCCCC1IFIG,IPATT,PTHICK,ICOL)
      CALL DPDRPL(PX,PY,NP,
     1IFIG,IPATT,PTHICK,ICOL,
     1JPATT,JTHICK,PTHIC2,JCOL,IFLAG)
C
      PX(1)=X2+DEL3D
      PY(1)=Y2+DEL3D
C
      PX(2)=X2+DEL3D
      PY(2)=Y1+DEL3D
C
      PX(3)=X2
      PY(3)=Y1
C
      NP=3
C
      IFLAG='ON'
CCCCC CALL DPDRPL(PX,PY,NP,PX3,PY3,NP3,
CCCCC1IFIG,IPATT,PTHICK,ICOL)
      CALL DPDRPL(PX,PY,NP,
     1IFIG,IPATT,PTHICK,ICOL,
     1JPATT,JTHICK,PTHIC2,JCOL,IFLAG)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGG4.EQ.'OFF'.AND.ISUBG4.NE.'CUB2')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF DPCUB2--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)NP
 9013 FORMAT('NP = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO9015I=1,NP
      WRITE(ICOUT,9016)I,PX(I),PY(I)
 9016 FORMAT('I,PX(I),PY(I) = ',I8,2E15.7)
      CALL DPWRST('XXX','BUG ')
 9015 CONTINUE
      WRITE(ICOUT,9021)IREFSW(1),IREFCO(1)
 9021 FORMAT('IREFSW(1),IREFCO(1) = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9022)DELX,DELY,DELMIN,P3D,DEL3D
 9022 FORMAT('DELX,DELY,DELMIN,P3D,DEL3D = ',5E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9039)IBUGG4,ISUBG4,IERRG4
 9039 FORMAT('IBUGG4,ISUBG4,IERRG4 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE DPCUCO(IHARG,IARGT,ARG,NUMARG,PDIAYC,
     1PDIAY2,IFOUND,IERROR)
C
C     PURPOSE--DEFINE THE (VERTICAL) COORDINATE FOR THE CURSOR
C              THE COORDINATE FOR THE CURSOR WILL BE PLACED
C              IN THE FLOATING POINT VARIABLE PDIAY2.
C     INPUT  ARGUMENTS--IHARG  (A  HOLLERITH VECTOR)
C                     --NUMARG
C                     --PDIAYC
C     OUTPUT ARGUMENTS--PDIAY2
C                     --IFOUND ('YES' OR 'NO' )
C                     --IERROR ('YES' OR 'NO' )
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--86/7
C     ORIGINAL VERSION--APRIL     1986.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IHARG
      CHARACTER*4 IARGT
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
C---------------------------------------------------------------------
C
      DIMENSION IHARG(*)
      DIMENSION IARGT(*)
      DIMENSION ARG(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IFOUND='NO'
      IERROR='NO'
C
      IF(NUMARG.EQ.1)GOTO1150
      IF(IARGT(NUMARG).EQ.'NUMB')GOTO1160
      GOTO1110
C
 1110 CONTINUE
      IF(IHARG(NUMARG).EQ.'ON')GOTO1150
      IF(IHARG(NUMARG).EQ.'OFF')GOTO1150
      IF(IHARG(NUMARG).EQ.'AUTO')GOTO1150
      IF(IHARG(NUMARG).EQ.'DEFA')GOTO1150
C
 1120 CONTINUE
      IERROR='YES'
      WRITE(ICOUT,1121)
 1121 FORMAT('***** ERROR IN DPCUCO--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1122)
 1122 FORMAT('      ILLEGAL FORM FOR CURSOR COORDINATES ',
     1'COMMAND.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1124)
 1124 FORMAT('      TEST EXAMPLE TO DEMONSTRATE THE ',
     1'PROPER FORM--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1125)
 1125 FORMAT('      SUPPOSE IT IS DESIRED TO HAVE ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1126)
 1126 FORMAT('      THE CURSOR COORDINATE TO BE 20 PERCENT ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1127)
 1127 FORMAT('      OF THE WAY UP THE SCREEN (FROM THE BOTTOM), ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1128)
 1128 FORMAT('      THEN THE ALLOWABLE FORM IS--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1131)
 1131 FORMAT('      CURSOR COORDINATE 20')
      CALL DPWRST('XXX','BUG ')
      GOTO1199
C
 1150 CONTINUE
      PDIAY2=PDIAYC
      GOTO1180
C
 1160 CONTINUE
      PDIAY2=ARG(NUMARG)
      GOTO1180
C
 1180 CONTINUE
      IFOUND='YES'
C
      IF(IFEEDB.EQ.'OFF')GOTO1189
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1181)PDIAY2
 1181 FORMAT('THE CURSOR COORDINATE HAS JUST BEEN SET TO ',
     1E15.7)
      CALL DPWRST('XXX','BUG ')
 1189 CONTINUE
      GOTO1199
C
 1199 CONTINUE
      RETURN
      END
      SUBROUTINE DPCUSP(IHARG,IARGT,ARG,NUMARG,DEFCSP,
     1PDIAVG,IFOUND,IERROR)
C
C     PURPOSE--DEFINE THE SPACING (= VERTICAL GAP) FOR THE CURSOR
C              THE SPACING FOR THE CURSOR WILL BE PLACED
C              IN THE FLOATING POINT VARIABLE PDIAVG.
C     INPUT  ARGUMENTS--IHARG  (A  HOLLERITH VECTOR)
C                     --NUMARG
C                     --DEFCSP
C     OUTPUT ARGUMENTS--PDIAVG
C                     --IFOUND ('YES' OR 'NO' )
C                     --IERROR ('YES' OR 'NO' )
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--86/7
C     ORIGINAL VERSION--APRIL     1986.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IHARG
      CHARACTER*4 IARGT
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
C---------------------------------------------------------------------
C
      DIMENSION IHARG(*)
      DIMENSION IARGT(*)
      DIMENSION ARG(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IFOUND='NO'
      IERROR='NO'
C
      IF(NUMARG.EQ.1)GOTO1150
      IF(IARGT(NUMARG).EQ.'NUMB')GOTO1160
      GOTO1110
C
 1110 CONTINUE
      IF(IHARG(NUMARG).EQ.'ON')GOTO1150
      IF(IHARG(NUMARG).EQ.'OFF')GOTO1150
      IF(IHARG(NUMARG).EQ.'AUTO')GOTO1150
      IF(IHARG(NUMARG).EQ.'DEFA')GOTO1150
C
 1120 CONTINUE
      IERROR='YES'
      WRITE(ICOUT,1121)
 1121 FORMAT('***** ERROR IN DPCUSP--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1122)
 1122 FORMAT('      ILLEGAL FORM FOR CURSOR SPACING ',
     1'COMMAND.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1124)
 1124 FORMAT('      TEST EXAMPLE TO DEMONSTRATE THE ',
     1'PROPER FORM--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1125)
 1125 FORMAT('      SUPPOSE IT IS DESIRED TO HAVE ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1126)
 1126 FORMAT('      THE CURSOR SPACING TO BE 2 PERCENT ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1127)
 1127 FORMAT('      OF TOTAL SCREEN HEIGHT, ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1128)
 1128 FORMAT('      THEN THE ALLOWABLE FORM IS--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1131)
 1131 FORMAT('      CURSOR SPACING 2')
      CALL DPWRST('XXX','BUG ')
      GOTO1199
C
 1150 CONTINUE
      PDIAVG=DEFCSP
      GOTO1180
C
 1160 CONTINUE
      PDIAVG=ARG(NUMARG)
      GOTO1180
C
 1180 CONTINUE
      IFOUND='YES'
C
      IF(IFEEDB.EQ.'OFF')GOTO1189
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1181)PDIAVG
 1181 FORMAT('THE CURSOR SPACING HAS JUST BEEN SET TO ',
     1E15.7)
      CALL DPWRST('XXX','BUG ')
 1189 CONTINUE
      GOTO1199
C
 1199 CONTINUE
      RETURN
      END
      SUBROUTINE DPCUSU(XTEMP1,MAXNXT,
     1                  ICASAN,ICAPSW,IFORSW,
     1                  IBUGA2,IBUGA3,IBUGQ,ISUBRO,IFOUND,IERROR)
C
C     PURPOSE--PERFORM A CUMULATIVE SUM TEST FOR RANDOMNESS
C     EXAMPLE--CUMULATIVE SUM TEST Y
C     REFERENCE--A STATISTICAL TEST SUITE FOR RANDOM AND PSUEDORANDOM
C                NUMBER GENERATORS FOR CRYPTOGRAPHIC APPLICATIONS,
C                ANDREW RUKHIN, JUAN SOTO, JAMES NECHVATAL, MILES SMID,
C                ELAINE BARKER, STEFAN LEIGH, MARK LEVENSON,
C                MARK VANGEL, DAVID BANKS, ALAN HECKERT, JAMES DRAY,
C                SAN VO.  NIST SPECIAL PUBLICATION 800-22,
C                OCTOBER 2000, PP. 14-16.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2003/12
C     ORIGINAL VERSION--DECEMBER  2003.
C     UPDATED         --MARCH     2011. USE DPPARS ROUTINE
C     UPATED          --MARCH     2011. REWRITTEN TO HANDLE MULTIPLE
C                                       RESPONSE VARIABLES, GROUP-ID
C                                       VARIABLES, OR A LAB-ID VARIABLE
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICASAN
      CHARACTER*4 ICAPSW
      CHARACTER*4 IFORSW
C
      CHARACTER*4 IBUGA2
      CHARACTER*4 IBUGA3
      CHARACTER*4 IBUGQ
      CHARACTER*4 ISUBRO
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
      CHARACTER*4 MESSAG
      CHARACTER*4 IHWUSE
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      CHARACTER*4 IH
      CHARACTER*4 IH2
      CHARACTER*4 IHOST1
      CHARACTER*4 ISUBN0
C
      CHARACTER*4 IFLAGU
      LOGICAL IFRST
      LOGICAL ILAST
C
      CHARACTER*4 LOWLTY
      CHARACTER*4 UPPLTY
      CHARACTER*4 IMETHD
      CHARACTER*4 IREPL
      CHARACTER*4 IMULT
      CHARACTER*4 ICTMP1
      CHARACTER*4 ICTMP2
      CHARACTER*4 ICTMP3
      CHARACTER*4 ICTMP4
      CHARACTER*4 ICTMP5
      CHARACTER*4 ICASE
C
      CHARACTER*40 INAME
      PARAMETER (MAXSPN=30)
      CHARACTER*4 IVARN1(MAXSPN)
      CHARACTER*4 IVARN2(MAXSPN)
      CHARACTER*4 IVARTY(MAXSPN)
      CHARACTER*4 IVARID(1)
      CHARACTER*4 IVARI2(1)
      REAL PVAR(MAXSPN)
      REAL PID(MAXSPN)
      INTEGER ILIS(MAXSPN)
      INTEGER NRIGHT(MAXSPN)
      INTEGER ICOLR(MAXSPN)
C
C---------------------------------------------------------------------
C
      DIMENSION XTEMP1(*)
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCOZZ.INC'
      INCLUDE 'DPCOZ2.INC'
C
      DIMENSION YTEMP1(MAXOBV)
      DIMENSION YTEMP2(MAXOBV)
      DIMENSION YTEMP3(MAXOBV)
      DIMENSION XDESGN(MAXOBV,7)
      DIMENSION XIDTEM(MAXOBV)
      DIMENSION XIDTE2(MAXOBV)
      DIMENSION XIDTE3(MAXOBV)
      DIMENSION XIDTE4(MAXOBV)
      DIMENSION XIDTE5(MAXOBV)
      DIMENSION XIDTE6(MAXOBV)
C
      DIMENSION TEMP1(MAXOBV)
      DIMENSION TEMP2(MAXOBV)
C
      EQUIVALENCE (GARBAG(IGARB1),YTEMP1(1))
      EQUIVALENCE (GARBAG(IGARB2),YTEMP2(1))
      EQUIVALENCE (GARBAG(IGARB3),YTEMP3(1))
      EQUIVALENCE (GARBAG(IGARB4),TEMP1(1))
      EQUIVALENCE (GARBAG(IGARB5),XIDTEM(1))
      EQUIVALENCE (GARBAG(IGARB6),XIDTE2(1))
      EQUIVALENCE (GARBAG(IGARB7),XIDTE3(1))
      EQUIVALENCE (GARBAG(IGARB8),XIDTE4(1))
      EQUIVALENCE (GARBAG(IGARB9),XIDTE5(1))
      EQUIVALENCE (GARBAG(IGAR10),XIDTE6(1))
      EQUIVALENCE (GARBAG(JGAR11),TEMP2(1))
      EQUIVALENCE (G2RBAG(IGAR11),XDESGN(1,1))
C
      INCLUDE 'DPCOHK.INC'
      INCLUDE 'DPCOSU.INC'
      INCLUDE 'DPCODA.INC'
      INCLUDE 'DPCOST.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IREPL='OFF'
      IMULT='OFF'
      ISUBN1='DPCU'
      ISUBN2='SU  '
C
      MAXCP1=MAXCOL+1
      MAXCP2=MAXCOL+2
      MAXCP3=MAXCOL+3
      MAXCP4=MAXCOL+4
      MAXCP5=MAXCOL+5
      MAXCP6=MAXCOL+6
C
      IFOUND='NO'
      IERROR='NO'
C
C               ********************************************
C               **  TREAT THE CUMULATIVE SUM   TEST CASE  **
C               ********************************************
C
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'CUSU')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPCUSU--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGA2,IBUGA3,IBUGQ,ISUBRO
   52   FORMAT('IBUGA2,IBUGA3,IBUGQ,ISUBRO = ',3(A4,2X),A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,55)IFORSW,ICAPSW,ICAPTY,MAXNXT
   55   FORMAT('IFORSW,ICAPSW,ICAPTY,MAXNXT = ',3(A4,2X),I8)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               *****************************************************
C               **  STEP 1--                                       **
C               **  EXTRACT THE COMMAND                            **
C               **  LOOK FOR ONE OF THE FOLLOWING COMMANDS:        **
C               **    1) CUMULATIVE SUM TEST Y                     **
C               **    2) MULTIPLE CUMULATIVE SUM TEST   Y1 ... YK  **
C               **    3) REPLICATED CUMULATIVE SUM TEST            **
C               **       Y X1 ... XK                               **
C               *****************************************************
C
      ISTEPN='1'
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'CUSU')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      ILASTC=9999
      ILASTZ=9999
      ICASAN='CUSU'
C
C     LOOK FOR:
C
C          CUMULATIVE SUM TEST
C
      DO100I=0,NUMARG-1
C
        IF(I.EQ.0)THEN
          ICTMP1=ICOM
        ELSE
          ICTMP1=IHARG(I)
        ENDIF
        ICTMP2=IHARG(I+1)
        ICTMP3=IHARG(I+2)
        ICTMP4=IHARG(I+3)
C
        IF(ICTMP1.EQ.'=')THEN
          IFOUND='NO'
          GOTO9000
        ELSEIF(ICTMP1.EQ.'CUMU' .AND. ICTMP2.EQ.'SUM ' .AND.
     1         ICTMP3.EQ.'TEST')THEN
          IFOUND='YES'
          ICASAN='CUSU'
          ILASTC=I
          ILASTZ=I+2
        ELSEIF(ICTMP1.EQ.'REPL')THEN
          IREPL='ON'
          ILASTC=MIN(ILASTC,I)
          ILASTZ=MAX(ILASTZ,I)
        ELSEIF(ICTMP1.EQ.'MULT')THEN
          IMULT='ON'
          ILASTC=MIN(ILASTC,I)
          ILASTZ=MAX(ILASTZ,I)
        ENDIF
  100 CONTINUE
C
      IF(IFOUND.EQ.'NO')GOTO9000
C
      ISHIFT=ILASTZ
      CALL SHIFTL(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1            IBUGA2,IERROR)
C
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'CUSU')THEN
        WRITE(ICOUT,91)ICASAN,IMULT,IREPL,ISHIFT
   91   FORMAT('DPCUSU: ICASAN,IMULT,IREPL,ISHIFT = ',3(A4,2X),I5)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      IF(IMULT.EQ.'ON')THEN
        IF(IREPL.EQ.'ON')THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,101)
  101     FORMAT('***** ERROR IN CUMULATIVE SUM TEST--')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,103)
  103     FORMAT('      YOU CANNOT SPECIFY BOTH "MULTIPLE" AND ',
     1           '"REPLICATION"')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,104)
  104     FORMAT('      FOR THE CUMULATIVE SUM TEST COMMAND.')
          CALL DPWRST('XXX','BUG ')
          IERROR='YES'
          GOTO9000
        ENDIF
      ENDIF
C
C               *********************************
C               **  STEP 4--                   **
C               **  EXTRACT THE VARIABLE LIST  **
C               *********************************
C
      ISTEPN='4'
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'CUSU')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      INAME='CUMULATIVE SUM TEST'
      MINNA=1
      MAXNA=100
      MINN2=2
      IFLAGE=0
      IFLAGM=1
      IF(IREPL.EQ.'ON')THEN
        IFLAGM=0
        IFLAGE=1
      ENDIF
      IFLAGP=0
      JMIN=1
      JMAX=NUMARG
      MINNVA=1
      MAXNVA=MAXSPN
C
      CALL DPPARS(IHARG,IHARG2,IARGT,ARG,NUMARG,IANS,IWIDTH,
     1            IHNAME,IHNAM2,IUSE,NUMNAM,IN,IVALUE,VALUE,
     1            JMIN,JMAX,
     1            MINN2,MINNA,MAXNA,MAXSPN,IFLAGE,INAME,
     1            IVARN1,IVARN2,IVARTY,PVAR,
     1            ILIS,NRIGHT,ICOLR,ISUB,NQ,ILOCQ,NUMVAR,
     1            MINNVA,MAXNVA,
     1            IFLAGM,IFLAGP,
     1            IBUGA3,IBUGQ,ISUBRO,IFOUND,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'CUSU')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,281)
  281   FORMAT('***** AFTER CALL DPPARS--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,282)NQ,NUMVAR
  282   FORMAT('NQ,NUMVAR = ',2I8)
        CALL DPWRST('XXX','BUG ')
        IF(NUMVAR.GT.0)THEN
          DO285I=1,NUMVAR
            WRITE(ICOUT,287)I,IVARN1(I),IVARN2(I),ILIS(I),NRIGHT(I),
     1                      ICOLR(I)
  287       FORMAT('I,IVARN1(I),IVARN2(I),ILIS(I),NRIGHT(I),',
     1             'ICOLR(I) = ',I8,2X,A4,A4,2X,3I8)
            CALL DPWRST('XXX','BUG ')
  285     CONTINUE
        ENDIF
      ENDIF
C
C               ***********************************************
C               **  STEP 5--                                 **
C               **  DETERMINE:                               **
C               **  1) NUMBER OF REPLICATION VARIABLES (0-6) **
C               **  2) NUMBER OF RESPONSE    VARIABLES (>= 1)**
C               ***********************************************
C
      ISTEPN='5'
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'CUSU')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NRESP=0
      NREPL=0
      IF(IMULT.EQ.'ON')THEN
        NRESP=NUMVAR
      ELSEIF(IREPL.EQ.'ON')THEN
        NRESP=1
        NREPL=NUMVAR-NRESP
        IF(NREPL.LT.1 .OR. NREPL.GT.6)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,101)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,511)
  511     FORMAT('      FOR THE REPLICATION CASE, THE NUMBER OF ',
     1           'REPLICATION VARIABLES')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,512)
  512     FORMAT('      MUST BE BETWEEN ONE AND SIX.')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,513)NREPL
  513     FORMAT('      THE NUMBER OF REPLICATION VARIABLES = ',I5)
          CALL DPWRST('XXX','BUG ')
          IERROR='YES'
          GOTO9000
        ENDIF
      ELSE
        NRESP=NUMVAR
        IMULT='ON'
      ENDIF
C
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'CUSU')THEN
        WRITE(ICOUT,521)NRESP,NREPL
  521   FORMAT('NRESP,NREPL = ',2I5)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               ******************************************************
C               **  STEP 6--                                        **
C               **  GENERATE THE CUMULATIVE SUM   TEST FOR THE      **
C               **  VARIOUS CASES                                   **
C               ******************************************************
C
      ISTEPN='6'
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'CUSU')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C               ******************************************
C               **  STEP 8A--                           **
C               **  CASE 1: NO REPLICATION VARIABLES    **
C               ******************************************
C
      IF(NREPL.LT.1)THEN
        ISTEPN='8A'
        IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'CUSU')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C       LOOP THROUGH EACH OF THE RESPONSE VARIABLES
C
        NCURVE=0
        DO810IRESP=1,NRESP
          NCURVE=NCURVE+1
C
          IINDX=ICOLR(IRESP)
          PID(1)=CPUMIN
          IVARID(1)=IVARN1(IRESP)
          IVARI2(1)=IVARN2(IRESP)
C
          IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'CUSU')THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,811)IRESP,NCURVE
  811       FORMAT('IRESP,NCURVE = ',2I5)
            CALL DPWRST('XXX','BUG ')
          ENDIF
C
          ICOL=IRESP
          NUMVA2=1
          CALL DPPAR3(ICOL,IVALUE,IVALU2,IN,MAXN,MAXOBV,
     1                INAME,IVARN1,IVARN2,IVARTY,
     1                ILIS,NRIGHT,ICOLR,ISUB,NQ,NUMVA2,
     1                MAXCOL,MAXCP1,MAXCP2,MAXCP3,
     1                MAXCP4,MAXCP5,MAXCP6,
     1                V,PRED,RES,YPLOT,XPLOT,X2PLOT,TAGPLO,
     1                Y,XTEMP1,XTEMP1,NS1,NLOCA2,NLOCA3,ICASE,
     1                IBUGA3,ISUBRO,IFOUND,IERROR)
          IF(IERROR.EQ.'YES')GOTO9000
C
C         *****************************************************
C         **  STEP 8B--                                      **
C         *****************************************************
C
          IF(IBUGA2.EQ.'ON' .OR. ISUBRO.EQ.'CUSU')THEN
            ISTEPN='8B'
            CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,822)
  822       FORMAT('***** FROM THE MIDDLE  OF DPFRTE--')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,823)ICASAN,NUMVAR,NLOCAL
  823       FORMAT('ICASAN,NUMVAR,NQ = ',A4,2I8)
            CALL DPWRST('XXX','BUG ')
            IF(NLOCAL.GE.1)THEN
              DO825I=1,NLOCAL
                WRITE(ICOUT,826)I,Y(I)
  826           FORMAT('I,Y(I) = ',I8,G15.7)
                CALL DPWRST('XXX','BUG ')
  825         CONTINUE
            ENDIF
          ENDIF
C
          CALL DPCUS2(Y,NS1,
     1                XTEMP1,MAXNXT,
     1                ICAPSW,ICAPTY,IFORSW,ICASAN,M,
     1                PID,IVARID,IVARI2,NREPL,
     1                STATVA,STATV2,PVAL1,PVAL2,
     1                YTEMP1,
     1                ISUBRO,IBUGA3,IERROR)
C
C               ***************************************
C               **  STEP 61--                        **
C               **  UPDATE INTERNAL DATAPLOT TABLES  **
C               ***************************************
C
          ISTEPN='8C'
          IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'CUSU')
     1      CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
          IF(NRESP.GT.1)THEN
            IFLAGU='FILE'
          ELSE
            IFLAGU='ON'
          ENDIF
          IFRST=.FALSE.
          ILAST=.FALSE.
          IF(IRESP.EQ.1)IFRST=.TRUE.
          IF(IRESP.EQ.NRESP)ILAST=.TRUE.
          CALL DPCUS5(STATVA,STATV2,PVAL1,PVAL2,
     1                IFLAGU,IFRST,ILAST,
     1                IBUGA2,IBUGA3,ISUBRO,IERROR)
  810   CONTINUE
C
C               ****************************************************
C               **  STEP 9A--                                     **
C               **  CASE 3: ONE OR MORE REPLICATION VARIABLES.    **
C               **          FOR THIS CASE, THE NUMBER OF RESPONSE **
C               **          VARIABLES MUST BE EXACTLY 1.          **
C               **          FOR THIS CASE, ALL VARIABLES MUST     **
C               **          HAVE THE SAME LENGTH.                 **
C               ****************************************************
C
      ELSEIF(NREPL.GE.1)THEN
        ISTEPN='9A'
        IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'CUSU')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
        J=0
        IMAX=NRIGHT(1)
        IF(NQ.LT.NRIGHT(1))IMAX=NQ
        DO910I=1,IMAX
          IF(ISUB(I).EQ.0)GOTO910
          J=J+1
C
C         RESPONSE VARIABLE IN Y
C
          ICOLC=1
          IJ=MAXN*(ICOLR(ICOLC)-1)+I
          IF(ICOLR(ICOLC).LE.MAXCOL)Y(J)=V(IJ)
          IF(ICOLR(ICOLC).EQ.MAXCP1)Y(J)=PRED(I)
          IF(ICOLR(ICOLC).EQ.MAXCP2)Y(J)=RES(I)
          IF(ICOLR(ICOLC).EQ.MAXCP3)Y(J)=YPLOT(I)
          IF(ICOLR(ICOLC).EQ.MAXCP4)Y(J)=XPLOT(I)
          IF(ICOLR(ICOLC).EQ.MAXCP5)Y(J)=X2PLOT(I)
          IF(ICOLR(ICOLC).EQ.MAXCP6)Y(J)=TAGPLO(I)
C
          IF(NREPL.GE.1)THEN
            DO920IR=1,MIN(NREPL,6)
              ICOLC=ICOLC+1
              ICOLT=ICOLR(ICOLC)
              IJ=MAXN*(ICOLT-1)+I
              IF(ICOLT.LE.MAXCOL)XDESGN(J,IR)=V(IJ)
              IF(ICOLT.EQ.MAXCP1)XDESGN(J,IR)=PRED(I)
              IF(ICOLT.EQ.MAXCP2)XDESGN(J,IR)=RES(I)
              IF(ICOLT.EQ.MAXCP3)XDESGN(J,IR)=YPLOT(I)
              IF(ICOLT.EQ.MAXCP4)XDESGN(J,IR)=XPLOT(I)
              IF(ICOLT.EQ.MAXCP5)XDESGN(J,IR)=X2PLOT(I)
              IF(ICOLT.EQ.MAXCP6)XDESGN(J,IR)=TAGPLO(I)
  920       CONTINUE
          ENDIF
C
  910   CONTINUE
        NLOCAL=J
C
C       *****************************************************
C       **  STEP 9B--                                      **
C       **  CALL DPCUS2 TO PERFORM CUMULATIVE SUM TEST.    **
C       *****************************************************
C
C
        IF(IBUGA2.EQ.'ON' .OR. ISUBRO.EQ.'CUSU')THEN
          ISTEPN='9C'
          CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,941)
  941     FORMAT('***** FROM THE MIDDLE  OF DPCUSU--')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,942)ICASAN,NUMVAR,NLOCAL,NREPL
  942     FORMAT('ICASAN,NUMVAR,NLOCAL,NREPL = ',
     1           A4,3I8)
          CALL DPWRST('XXX','BUG ')
          IF(NLOCAL.GE.1)THEN
            DO945I=1,NLOCAL
              WRITE(ICOUT,946)I,Y(I),XDESGN(I,1),XDESGN(I,2)
  946         FORMAT('I,Y(I),XDESGN(I,1),XDESGN(I,2) = ',
     1               I8,4F12.5)
              CALL DPWRST('XXX','BUG ')
  945       CONTINUE
          ENDIF
        ENDIF
C
C       *****************************************************
C       **  STEP 9C--                                      **
C       **  FIND THE DISTINCT VALUES IN EACH OF THE        **
C       **  REPLICATION VARIABLES.                         **
C       *****************************************************
C
        CALL DPPP5(XDESGN(1,1),XDESGN(1,2),XDESGN(1,3),
     1             XDESGN(1,4),XDESGN(1,5),XDESGN(1,6),
     1             NREPL,NLOCAL,MAXOBV,
     1             XIDTEM,XIDTE2,XIDTE3,XIDTE4,XIDTE5,XIDTE6,
     1             XTEMP1,TEMP2,
     1             NUMSE1,NUMSE2,NUMSE3,NUMSE4,NUMSE5,NUMSE6,
     1             IBUGA3,ISUBRO,IERROR)
C
C       *****************************************************
C       **  STEP 9D--                                      **
C       **  NOW LOOP THROUGH THE VARIOUS REPLICATIONS      **
C       *****************************************************
C
        NCURVE=0
        IADD=1
C
        IF(NREPL.EQ.1)THEN
          J=0
          DO1110ISET1=1,NUMSE1
            K=0
            PID(IADD+1)=XIDTEM(ISET1)
            DO1130I=1,NLOCAL
              IF(XIDTEM(ISET1).EQ.XDESGN(I,1))THEN
                K=K+1
                TEMP1(K)=Y(I)
              ENDIF
 1130       CONTINUE
            NTEMP=K
            NCURVE=NCURVE+1
            IF(NTEMP.GT.0)THEN
              CALL DPCUS2(TEMP1,NTEMP,
     1                    XTEMP1,MAXNXT,
     1                    ICAPSW,ICAPTY,IFORSW,ICASAN,M,
     1                    PID,IVARID,IVARI2,NREPL,
     1                    STATVA,STATV2,PVAL1,PVAL2,
     1                    YTEMP1,
     1                    ISUBRO,IBUGA3,IERROR)
            ENDIF
            IFLAGU='FILE'
            IFRST=.FALSE.
            ILAST=.FALSE.
            IF(NCURVE.EQ.1)IFRST=.TRUE.
            IF(NCURVE.EQ.NTOT)ILAST=.TRUE.
            CALL DPCUS5(STATVA,STATV2,PVAL1,PVAL2,
     1                  IFLAGU,IFRST,ILAST,
     1                  IBUGA2,IBUGA3,ISUBRO,IERROR)
 1110     CONTINUE
        ELSEIF(NREPL.EQ.2)THEN
          J=0
          NTOT=NUMSE1*NUMSE2
          DO1210ISET1=1,NUMSE1
          DO1220ISET2=1,NUMSE2
            K=0
            PID(1+IADD)=XIDTEM(ISET1)
            PID(2+IADD)=XIDTE2(ISET2)
            DO1290I=1,NLOCAL
              IF(
     1           XIDTEM(ISET1).EQ.XDESGN(I,1) .AND.
     1           XIDTE2(ISET2).EQ.XDESGN(I,2)
     1          )THEN
                K=K+1
                TEMP1(K)=Y(I)
              ENDIF
 1290       CONTINUE
            NTEMP=K
            NCURVE=NCURVE+1
            IF(NTEMP.GT.0)THEN
              CALL DPCUS2(TEMP1,NTEMP,
     1                    XTEMP1,MAXNXT,
     1                    ICAPSW,ICAPTY,IFORSW,ICASAN,M,
     1                    PID,IVARID,IVARI2,NREPL,
     1                    STATVA,STATV2,PVAL1,PVAL2,
     1                    YTEMP1,
     1                    ISUBRO,IBUGA3,IERROR)
              IFLAGU='FILE'
              IFRST=.FALSE.
              ILAST=.FALSE.
              IF(NCURVE.EQ.1)IFRST=.TRUE.
              IF(NCURVE.EQ.NTOT)ILAST=.TRUE.
              CALL DPCUS5(STATVA,STATV2,PVAL1,PVAL2,
     1                    IFLAGU,IFRST,ILAST,
     1                    IBUGA2,IBUGA3,ISUBRO,IERROR)
            ENDIF
 1220     CONTINUE
 1210     CONTINUE
        ELSEIF(NREPL.EQ.3)THEN
          J=0
          NTOT=NUMSE1*NUMSE2*NUMSE3
          DO1310ISET1=1,NUMSE1
          DO1320ISET2=1,NUMSE2
          DO1330ISET3=1,NUMSE3
            K=0
            PID(1+IADD)=XIDTEM(ISET1)
            PID(2+IADD)=XIDTE2(ISET2)
            PID(3+IADD)=XIDTE3(ISET3)
            DO1390I=1,NLOCAL
              IF(
     1           XIDTEM(ISET1).EQ.XDESGN(I,1) .AND.
     1           XIDTE2(ISET2).EQ.XDESGN(I,2) .AND.
     1           XIDTE3(ISET3).EQ.XDESGN(I,3)
     1          )THEN
                K=K+1
                TEMP1(K)=Y(I)
              ENDIF
 1390       CONTINUE
            NTEMP=K
            NCURVE=NCURVE+1
            NPLOT1=NPLOTP
            IF(NTEMP.GT.0)THEN
              CALL DPCUS2(TEMP1,NTEMP,
     1                    XTEMP1,MAXNXT,
     1                    ICAPSW,ICAPTY,IFORSW,ICASAN,M,
     1                    PID,IVARID,IVARI2,NREPL,
     1                    STATVA,STATV2,PVAL1,PVAL2,
     1                    YTEMP1,
     1                    ISUBRO,IBUGA3,IERROR)
              IFLAGU='FILE'
              IFRST=.FALSE.
              ILAST=.FALSE.
              IF(NCURVE.EQ.1)IFRST=.TRUE.
              IF(NCURVE.EQ.NTOT)ILAST=.TRUE.
              CALL DPCUS5(STATVA,STATV2,PVAL1,PVAL2,
     1                    IFLAGU,IFRST,ILAST,
     1                    IBUGA2,IBUGA3,ISUBRO,IERROR)
            ENDIF
 1330     CONTINUE
 1320     CONTINUE
 1310     CONTINUE
        ELSEIF(NREPL.EQ.4)THEN
          J=0
          NTOT=NUMSE1*NUMSE2*NUMSE3*NUMSE4
          DO1410ISET1=1,NUMSE1
          DO1420ISET2=1,NUMSE2
          DO1430ISET3=1,NUMSE3
          DO1440ISET4=1,NUMSE4
            K=0
            PID(1+IADD)=XIDTEM(ISET1)
            PID(2+IADD)=XIDTE2(ISET2)
            PID(3+IADD)=XIDTE3(ISET3)
            PID(4+IADD)=XIDTE4(ISET4)
            DO1490I=1,NLOCAL
              IF(
     1           XIDTEM(ISET1).EQ.XDESGN(I,1) .AND.
     1           XIDTE2(ISET2).EQ.XDESGN(I,2) .AND.
     1           XIDTE3(ISET3).EQ.XDESGN(I,3) .AND.
     1           XIDTE4(ISET4).EQ.XDESGN(I,4)
     1          )THEN
                K=K+1
                TEMP1(K)=Y(I)
              ENDIF
 1490       CONTINUE
            NTEMP=K
            NCURVE=NCURVE+1
            NPLOT1=NPLOTP
            IF(NTEMP.GT.0)THEN
              CALL DPCUS2(TEMP1,NTEMP,
     1                    XTEMP1,MAXNXT,
     1                    ICAPSW,ICAPTY,IFORSW,ICASAN,M,
     1                    PID,IVARID,IVARI2,NREPL,
     1                    STATVA,STATV2,PVAL1,PVAL2,
     1                    YTEMP1,
     1                    ISUBRO,IBUGA3,IERROR)
              IFLAGU='FILE'
              IFRST=.FALSE.
              ILAST=.FALSE.
              IF(NCURVE.EQ.1)IFRST=.TRUE.
              IF(NCURVE.EQ.NTOT)ILAST=.TRUE.
              CALL DPCUS5(STATVA,STATV2,PVAL1,PVAL2,
     1                    IFLAGU,IFRST,ILAST,
     1                    IBUGA2,IBUGA3,ISUBRO,IERROR)
            ENDIF
 1440     CONTINUE
 1430     CONTINUE
 1420     CONTINUE
 1410     CONTINUE
        ELSEIF(NREPL.EQ.5)THEN
          J=0
          NTOT=NUMSE1*NUMSE2*NUMSE3*NUMSE4*NUMSE5
          DO1510ISET1=1,NUMSE1
          DO1520ISET2=1,NUMSE2
          DO1530ISET3=1,NUMSE3
          DO1540ISET4=1,NUMSE4
          DO1550ISET5=1,NUMSE5
            K=0
            PID(1+IADD)=XIDTEM(ISET1)
            PID(2+IADD)=XIDTE2(ISET2)
            PID(3+IADD)=XIDTE3(ISET3)
            PID(4+IADD)=XIDTE4(ISET4)
            PID(5+IADD)=XIDTE5(ISET4)
            DO1590I=1,NLOCAL
              IF(
     1           XIDTEM(ISET1).EQ.XDESGN(I,1) .AND.
     1           XIDTE2(ISET2).EQ.XDESGN(I,2) .AND.
     1           XIDTE3(ISET3).EQ.XDESGN(I,3) .AND.
     1           XIDTE4(ISET4).EQ.XDESGN(I,4) .AND.
     1           XIDTE5(ISET5).EQ.XDESGN(I,5)
     1          )THEN
                K=K+1
                TEMP1(K)=Y(I)
              ENDIF
 1590       CONTINUE
            NTEMP=K
            NCURVE=NCURVE+1
            NPLOT1=NPLOTP
            IF(NTEMP.GT.0)THEN
              CALL DPCUS2(TEMP1,NTEMP,
     1                    XTEMP1,MAXNXT,
     1                    ICAPSW,ICAPTY,IFORSW,ICASAN,M,
     1                    PID,IVARID,IVARI2,NREPL,
     1                    STATVA,STATV2,PVAL1,PVAL2,
     1                    YTEMP1,
     1                    ISUBRO,IBUGA3,IERROR)
              IFLAGU='FILE'
              IFRST=.FALSE.
              ILAST=.FALSE.
              IF(NCURVE.EQ.1)IFRST=.TRUE.
              IF(NCURVE.EQ.NTOT)ILAST=.TRUE.
              CALL DPCUS5(STATVA,STATV2,PVAL1,PVAL2,
     1                    IFLAGU,IFRST,ILAST,
     1                    IBUGA2,IBUGA3,ISUBRO,IERROR)
            ENDIF
 1550     CONTINUE
 1540     CONTINUE
 1530     CONTINUE
 1520     CONTINUE
 1510     CONTINUE
        ELSEIF(NREPL.EQ.6)THEN
          J=0
          NTOT=NUMSE1*NUMSE2*NUMSE3*NUMSE4*NUMSE5*NUMSE6
          DO1610ISET1=1,NUMSE1
          DO1620ISET2=1,NUMSE2
          DO1630ISET3=1,NUMSE3
          DO1640ISET4=1,NUMSE4
          DO1650ISET5=1,NUMSE5
          DO1660ISET6=1,NUMSE6
            K=0
            PID(1+IADD)=XIDTEM(ISET1)
            PID(2+IADD)=XIDTE2(ISET2)
            PID(3+IADD)=XIDTE3(ISET3)
            PID(4+IADD)=XIDTE4(ISET4)
            PID(5+IADD)=XIDTE5(ISET4)
            PID(6+IADD)=XIDTE6(ISET4)
            DO1690I=1,NLOCAL
              IF(
     1           XIDTEM(ISET1).EQ.XDESGN(I,1) .AND.
     1           XIDTE2(ISET2).EQ.XDESGN(I,2) .AND.
     1           XIDTE3(ISET3).EQ.XDESGN(I,3) .AND.
     1           XIDTE4(ISET4).EQ.XDESGN(I,4) .AND.
     1           XIDTE5(ISET5).EQ.XDESGN(I,5) .AND.
     1           XIDTE6(ISET6).EQ.XDESGN(I,6)
     1          )THEN
                K=K+1
                TEMP1(K)=Y(I)
              ENDIF
 1690       CONTINUE
            NTEMP=K
            NCURVE=NCURVE+1
            NPLOT1=NPLOTP
            IF(NTEMP.GT.0)THEN
              CALL DPCUS2(TEMP1,NTEMP,
     1                    XTEMP1,MAXNXT,
     1                    ICAPSW,ICAPTY,IFORSW,ICASAN,M,
     1                    PID,IVARID,IVARI2,NREPL,
     1                    STATVA,STATV2,PVAL1,PVAL2,
     1                    YTEMP1,
     1                    ISUBRO,IBUGA3,IERROR)
              IFLAGU='FILE'
              IFRST=.FALSE.
              ILAST=.FALSE.
              IF(NCURVE.EQ.1)IFRST=.TRUE.
              IF(NCURVE.EQ.NTOT)ILAST=.TRUE.
              CALL DPCUS5(STATVA,STATV2,PVAL1,PVAL2,
     1                    IFLAGU,IFRST,ILAST,
     1                    IBUGA2,IBUGA3,ISUBRO,IERROR)
            ENDIF
 1660     CONTINUE
 1650     CONTINUE
 1640     CONTINUE
 1630     CONTINUE
 1620     CONTINUE
 1610     CONTINUE
        ENDIF
C
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'CUSU')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPCUSU--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9016)IFOUND,IERROR
 9016   FORMAT('IFOUND,IERROR = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPCUS2(Y,N,
     1                  XTEMP,MAXNXT,
     1                  ICAPSW,ICAPTY,IFORSW,ICASAN,M,
     1                  PID,IVARID,IVARI2,NREPL,
     1                  STATVA,STATV2,PVAL1,PVAL2,
     1                  YTEMP1,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE CARRIES OUT THE CUMULATIVE SUM TEST
C              FOR RANDOMNESS.
C     EXAMPLE--CUMULATIVE SUM TEST Y
C     REFERENCE--A STATISTICAL TEST SUITE FOR RANDOM AND PSUEDORANDOM
C                NUMBER GENERATORS FOR CRYPTOGRAPHIC APPLICATIONS,
C                ANDREW RUKHIN, JUAN SOTO, JAMES NECHVATAL, MILES SMID,
C                ELAINE BARKER, STEFAN LEIGH, MARK LEVENSON,
C                MARK VANGEL, DAVID BANKS, ALAN HECKERT, JAMES DRAY,
C                SAN VO.  NIST SPECIAL PUBLICATION 800-22,
C                OCTOBER 2000, PP. 14-18.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2003/12
C     ORIGINAL VERSION--DECEMBER  2003.
C     UPDATED         --MARCH     2011. USE DPDTA1 AND DPDTA5 TO PRINT
C                                       TABLES
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IVARID(*)
      CHARACTER*4 IVARI2(*)
C
      CHARACTER*4 ICAPSW
      CHARACTER*4 ICAPTY
      CHARACTER*4 IFORSW
      CHARACTER*4 ICASAN
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION XTEMP(*)
      DIMENSION YTEMP1(*)
      DIMENSION PID(*)
C
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DSUM2
      DOUBLE PRECISION DSUM3
      DOUBLE PRECISION DSUM4
      DOUBLE PRECISION DZ1
      DOUBLE PRECISION DZ2
      DOUBLE PRECISION DCDF1
      DOUBLE PRECISION DCDF2
C
      PARAMETER (NUMALP=7)
C
      PARAMETER(NUMCLI=4)
      PARAMETER(MAXLIN=3)
      PARAMETER (MAXROW=NUMALP)
      PARAMETER (MAXRO2=20)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*1  ITITL9
      CHARACTER*60 ITEXT(MAXRO2)
      CHARACTER*4  ALIGN(NUMCLI)
      CHARACTER*4  VALIGN(NUMCLI)
      REAL         AVALUE(MAXRO2)
      INTEGER      NCTEXT(MAXRO2)
      INTEGER      IDIGIT(MAXRO2)
      INTEGER      NTOT(MAXRO2)
      CHARACTER*60 ITITL2(MAXLIN,NUMCLI)
      CHARACTER*15 IVALUE(MAXROW,NUMCLI)
      CHARACTER*4  ITYPCO(NUMCLI)
      INTEGER      NCTIT2(MAXLIN,NUMCLI)
      INTEGER      NCVALU(MAXROW,NUMCLI)
      INTEGER      IWHTML(NUMCLI)
      INTEGER      IWRTF(NUMCLI)
      REAL         AMAT(MAXROW,NUMCLI)
      LOGICAL IFRST
      LOGICAL ILAST
      LOGICAL IFLAGS
      LOGICAL IFLAGE
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPCU'
      ISUBN2='S2  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CUS2')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPCUS2--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)ICASAN,IBUGA3,ISUBRO,N
   52   FORMAT('ICASAN,IBUGA3,ISUBRO,N = ',3(A4,2X),I8)
        CALL DPWRST('XXX','BUG ')
        DO56I=1,N
          WRITE(ICOUT,57)I,Y(I)
   57     FORMAT('I,Y(I) = ',I8,G15.7)
          CALL DPWRST('XXX','BUG ')
   56   CONTINUE
      ENDIF
C
      CALL DPCUS3(Y,N,
     1            XTEMP,MAXNXT,
     1            STATVA,STATV2,STATCD,STATC2,PVAL1,PVAL2,
     1            YTEMP1,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *********************************
C               **   STEP 52--                 **
C               **   WRITE OUT EVERYTHING      **
C               **   FOR CUMULATIVE SUM TEST   **
C               *********************************
C
      ISTEPN='52'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CUS2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IPRINT.EQ.'OFF')GOTO9000
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      ITITLE='Cumulative Sum Test for Randomness'
      NCTITL=34
      ITITLZ=' '
      NCTITZ=0
C
      ICNT=1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Response Variable: '
      WRITE(ITEXT(ICNT)(20:23),'(A4)')IVARID(1)(1:4)
      WRITE(ITEXT(ICNT)(24:27),'(A4)')IVARI2(1)(1:4)
      NCTEXT(ICNT)=27
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      IF(NREPL.GT.0)THEN
        IADD=1
        DO6101I=1,NREPL
          ICNT=ICNT+1
          ITEMP=I+IADD
          ITEXT(ICNT)='Factor Variable  : '
          WRITE(ITEXT(ICNT)(17:17),'(I1)')I
          WRITE(ITEXT(ICNT)(20:23),'(A4)')IVARID(ITEMP)(1:4)
          WRITE(ITEXT(ICNT)(24:27),'(A4)')IVARI2(ITEMP)(1:4)
          NCTEXT(ICNT)=27
          AVALUE(ICNT)=PID(ITEMP)
          IDIGIT(ICNT)=NUMDIG
 6101   CONTINUE
      ENDIF
C
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=1
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='H0: The Data Are Random'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Ha: The Data Are Not Random'
      NCTEXT(ICNT)=27
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=1
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(N)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=1
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Forward Direction Cumulative Sum Test Statistic:'
      NCTEXT(ICNT)=48
      AVALUE(ICNT)=STATVA
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Forward Direction P-Value:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=PVAL1
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=1
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Backward Direction Cumulative Sum Test Statistic:'
      NCTEXT(ICNT)=49
      AVALUE(ICNT)=STATV2
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Backward Direction P-Value:'
      NCTEXT(ICNT)=28
      AVALUE(ICNT)=PVAL2
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=1
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      NUMROW=ICNT
      DO6110I=1,NUMROW
        NTOT(I)=15
 6110 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.TRUE.
C
      ISTEPN='42A'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CUS2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
      ISTEPN='42D'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CUS2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      ITITL9=' '
      NCTIT9=0
      ITITLE='Conclusions for Forward Direction Test'
      NCTITL=38
C
      DO6130J=1,4
        DO6140I=1,3
          ITITL2(I,J)=' '
          NCTIT2(I,J)=0
 6140   CONTINUE
 6130 CONTINUE
C
      ITITL2(2,1)='Null'
      NCTIT2(2,1)=4
      ITITL2(3,1)='Hypothesis'
      NCTIT2(3,1)=10
C
      ITITL2(2,2)='Confidence'
      NCTIT2(2,2)=10
      ITITL2(3,2)='Level'
      NCTIT2(3,2)=5
C
      ITITL2(3,3)='P-Value'
      NCTIT2(3,3)=7
C
      ITITL2(1,4)='Null'
      NCTIT2(1,4)=4
      ITITL2(2,4)='Hypothesis'
      NCTIT2(2,4)=10
      ITITL2(3,4)='Conclusion'
      NCTIT2(3,4)=10
C
      NMAX=0
      NUMCOL=4
      DO6150I=1,NUMCOL
        VALIGN(I)='b'
        ALIGN(I)='r'
        NTOT(I)=15
        IF(I.EQ.1)NTOT(I)=12
        NMAX=NMAX+NTOT(I)
        ITYPCO(I)='ALPH'
        IF(I.EQ.3)ITYPCO(I)='NUME'
        IDIGIT(I)=NUMDIG
        IWHTML(1)=150
        IWHTML(2)=125
        IWHTML(3)=150
        IWHTML(4)=150
        IINC=1600
        IINC2=1400
        IINC3=2200
        IWRTF(1)=IINC
        IWRTF(2)=IWRTF(1)+IINC
        IWRTF(3)=IWRTF(2)+IINC2
        IWRTF(4)=IWRTF(3)+IINC
C
        DO6160J=1,NUMALP
C
          AMAT(J,I)=0.0
          AMAT(J,3)=PVAL1
          IVALUE(J,1)='Random'
          NCVALU(J,1)=6
          IVALUE(J,4)(1:6)='REJECT'
          IF(J.EQ.1)THEN
            IVALUE(J,2)(1:5)='50.0%'
            IF(PVAL1.GE.0.50)IVALUE(J,4)(1:6)='ACCEPT'
          ELSEIF(J.EQ.2)THEN
            IVALUE(J,2)(1:5)='75.0%'
            IF(PVAL1.GE.0.25)IVALUE(J,4)(1:6)='ACCEPT'
          ELSEIF(J.EQ.3)THEN
            IVALUE(J,2)(1:5)='90.0%'
            IF(PVAL1.GE.0.10)IVALUE(J,4)(1:6)='ACCEPT'
          ELSEIF(J.EQ.4)THEN
            IVALUE(J,2)(1:5)='95.0%'
            IF(PVAL1.GE.0.05)IVALUE(J,4)(1:6)='ACCEPT'
          ELSEIF(J.EQ.5)THEN
            IVALUE(J,2)(1:5)='97.5%'
            IF(PVAL1.GE.0.025)IVALUE(J,4)(1:6)='ACCEPT'
          ELSEIF(J.EQ.6)THEN
            IVALUE(J,2)(1:5)='99.0%'
            IF(PVAL1.GE.0.01)IVALUE(J,4)(1:6)='ACCEPT'
          ELSEIF(J.EQ.7)THEN
            IVALUE(J,2)(1:5)='99.9%'
            IF(PVAL1.GE.0.001)IVALUE(J,4)(1:6)='ACCEPT'
          ENDIF
          NCVALU(J,2)=5
          NCVALU(J,4)=6
C
 6160   CONTINUE
 6150 CONTINUE
C
      ICNT=NUMALP
      NUMLIN=3
      NUMCOL=4
      IFRST=.TRUE.
      ILAST=.TRUE.
      IFLAGS=.TRUE.
      IFLAGE=.TRUE.
      CALL DPDTA5(ITITLE,NCTITL,
     1            ITITL9,NCTIT9,ITITL2,NCTIT2,
     1            MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1            IVALUE,NCVALU,AMAT,ITYPCO,MAXROW,ICNT,
     1            IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1            ICAPSW,ICAPTY,IFRST,ILAST,
     1            IFLAGS,IFLAGE,
     1            ISUBRO,IBUGA3,IERROR)
C
      ITITL9=' '
      NCTIT9=0
      ITITLE='Conclusions for Backward Direction Test'
      NCTITL=40
C
      NMAX=0
      NUMCOL=4
      DO7150I=1,NUMCOL
        NTOT(I)=15
        IF(I.EQ.1)NTOT(I)=12
        NMAX=NMAX+NTOT(I)
C
        DO7160J=1,NUMALP
C
          AMAT(J,I)=0.0
          AMAT(J,3)=PVAL2
          IVALUE(J,4)(1:6)='REJECT'
          IF(J.EQ.1)THEN
            IVALUE(J,2)(1:5)='50.0%'
            IF(PVAL2.GE.0.50)IVALUE(J,4)(1:6)='ACCEPT'
          ELSEIF(J.EQ.2)THEN
            IVALUE(J,2)(1:5)='75.0%'
            IF(PVAL2.GE.0.25)IVALUE(J,4)(1:6)='ACCEPT'
          ELSEIF(J.EQ.3)THEN
            IVALUE(J,2)(1:5)='90.0%'
            IF(PVAL2.GE.0.10)IVALUE(J,4)(1:6)='ACCEPT'
          ELSEIF(J.EQ.4)THEN
            IVALUE(J,2)(1:5)='95.0%'
            IF(PVAL2.GE.0.05)IVALUE(J,4)(1:6)='ACCEPT'
          ELSEIF(J.EQ.5)THEN
            IVALUE(J,2)(1:5)='97.5%'
            IF(PVAL2.GE.0.025)IVALUE(J,4)(1:6)='ACCEPT'
          ELSEIF(J.EQ.6)THEN
            IVALUE(J,2)(1:5)='99.0%'
            IF(PVAL2.GE.0.01)IVALUE(J,4)(1:6)='ACCEPT'
          ELSEIF(J.EQ.7)THEN
            IVALUE(J,2)(1:5)='99.9%'
            IF(PVAL2.GE.0.001)IVALUE(J,4)(1:6)='ACCEPT'
          ENDIF
          NCVALU(J,2)=5
          NCVALU(J,4)=6
C
 7160   CONTINUE
 7150 CONTINUE
C
      ICNT=NUMALP
      NUMLIN=3
      NUMCOL=4
      IFRST=.TRUE.
      ILAST=.TRUE.
      IFLAGS=.TRUE.
      IFLAGE=.TRUE.
      CALL DPDTA5(ITITLE,NCTITL,
     1            ITITL9,NCTIT9,ITITL2,NCTIT2,
     1            MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1            IVALUE,NCVALU,AMAT,ITYPCO,MAXROW,ICNT,
     1            IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1            ICAPSW,ICAPTY,IFRST,ILAST,
     1            IFLAGS,IFLAGE,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CUS2')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPCUS2--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)N,IBUGA3,IERROR
 9012   FORMAT('N,IBUGA3,IERROR = ',I8,2X,A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        DO9016I=1,N
          WRITE(ICOUT,9017)I,Y(I),XTEMP(I)
 9017     FORMAT('I,Y(I),XTEMP(I) = ',I8,2G15.7)
          CALL DPWRST('XXX','WRIT')
 9016   CONTINUE
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPCUS3(Y,N,
     1                  XTEMP,MAXNXT,
     1                  STATVA,STATV2,STATCD,STATC2,PVAL1,PVAL2,
     1                  YTEMP1,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE CARRIES OUT THE CUMULATIVE SUM TEST
C              FOR RANDOMNESS (EITHER FORWARD DIRECTION OR
C              BACKWARD DIRECTION).  THIS IS EXTRACTED FROM DPCUS2
C              IN ORDER TO MAKE IT CALLABLE FROM CMPSTA (I.E.,
C              MAKE A SUPPORTED STATISTIC).
C     EXAMPLE--LET A = CUMULATIVE SUM FORWARD TEST Y
C     REFERENCE--A STATISTICAL TEST SUITE FOR RANDOM AND PSUEDORANDOM
C                NUMBER GENERATORS FOR CRYPTOGRAPHIC APPLICATIONS,
C                ANDREW RUKHIN, JUAN SOTO, JAMES NECHVATAL, MILES SMID,
C                ELAINE BARKER, STEFAN LEIGH, MARK LEVENSON,
C                MARK VANGEL, DAVID BANKS, ALAN HECKERT, JAMES DRAY,
C                SAN VO.  NIST SPECIAL PUBLICATION 800-22,
C                OCTOBER 2000, PP. 14-18.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2011/3
C     ORIGINAL VERSION--MARCH     2011. EXTRACTED FROM DPCUS2
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION XTEMP(*)
      DIMENSION YTEMP1(*)
C
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DSUM2
      DOUBLE PRECISION DSUM3
      DOUBLE PRECISION DSUM4
      DOUBLE PRECISION DZ1
      DOUBLE PRECISION DZ2
      DOUBLE PRECISION DCDF1
      DOUBLE PRECISION DCDF2
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPCU'
      ISUBN2='S3  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CUS3')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPCUS3--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)ICASAN,IBUGA3,ISUBRO,N
   52   FORMAT('ICASAN,IBUGA3,ISUBRO,N = ',3(A4,2X),I8)
        CALL DPWRST('XXX','BUG ')
        DO56I=1,N
          WRITE(ICOUT,57)I,Y(I)
   57     FORMAT('I,Y(I) = ',I8,G15.7)
          CALL DPWRST('XXX','BUG ')
   56   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'CUS3')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(N.LE.5)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1111)
 1111   FORMAT('***** ERROR IN CUMULATIVE SUM RANDOMNESS TEST.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1113)
 1113   FORMAT('      AT LEAST SIX OBSERVATIONS REQUIRED.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1115)N
 1115   FORMAT('SAMPLE SIZE = ',I8)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      HOLD=Y(1)
      DO1135I=2,N
      IF(Y(I).NE.HOLD)GOTO1139
 1135 CONTINUE
 1130 CONTINUE
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1111)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1131)HOLD
 1131 FORMAT('      THE RESPONSE VARIABLE HAS ALL ELEMENTS = ',G15.7)
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
 1139 CONTINUE
C
C               *******************************
C               **  STEP 2--                 **
C               **  COMPUTE THE NUMBER OF    **
C               **  DISTINCT VALUES.         **
C               *******************************
C
      ISTEPN='2'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CUS3')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IWRITE='NO'
      CALL DISTIN(Y,N,IWRITE,YTEMP1,NDIST,IBUGA3,IERROR)
C
      IF(IERROR.EQ.'YES')GOTO9000
      IF(NDIST.NE.2)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1111)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2003)
 2003   FORMAT('      FOR CUMULATIVE SUM TEST, EXACTLY TWO DISTINCT ',
     1         'VALUES ARE ALLOWED.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2005)NDIST
 2005   FORMAT('      NUMBER OF DISTINCT VALUES = ',I8)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
C               ******************************
C               **  STEP 21--               **
C               **  CARRY OUT CALCULATIONS  **
C               **  FOR CUSUM         TEST  **
C               ******************************
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CUS3')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IWRITE='OFF'
C
      ALOW=MIN(YTEMP1(1),YTEMP1(2))
      AHIGH=MAX(YTEMP1(1),YTEMP1(2))
      DZ1=0.0D0
      DZ2=0.0D0
      DSUM1=0.0D0
      DSUM2=0.0D0
      DSUM3=0.0D0
      DSUM4=0.0D0
C
      DO2120I=1,N
        IF(Y(I).EQ.ALOW)THEN
          DSUM1=DSUM1 - 1.0
        ELSE
          DSUM1=DSUM1 + 1.0
        ENDIF
        DZ1=MAX(DZ1,ABS(DSUM1))
 2120 CONTINUE
C
      DO2130I=N,1,-1
        IF(Y(I).EQ.ALOW)THEN
          DSUM2=DSUM2 - 1.0
        ELSE
          DSUM2=DSUM2 + 1.0
        ENDIF
        DZ2=MAX(DZ2,ABS(DSUM2))
 2130 CONTINUE
C
      AN=REAL(N)
      Z1=REAL(DZ1)/SQRT(AN)
      Z2=REAL(DZ2)/SQRT(AN)
      STATVA=Z1
      STATV2=Z2
C
      DSUM1=0.0D0
      DSUM2=0.0D0
C
      ATEMP=((AN/Z1)-1.0)/4.0
      IUPP=INT(ATEMP)
      ATEMP=((-AN/Z1)+1.0)/4.0
      ILOW=INT(ATEMP)
      DSUM1=0.0D0
      DO2140K=ILOW,IUPP
        AK=REAL(K)
        ATEMP=(4.0*AK+1.0)*Z1
        CALL NODCDF(DBLE(ATEMP),DCDF1)
        ATEMP=((4.0*AK - 1.0)*Z1)
        CALL NODCDF(DBLE(ATEMP),DCDF2)
        DSUM1=DSUM1 + (DCDF1 - DCDF2)
 2140 CONTINUE
C
      ATEMP=((AN/Z1)-3.0)/4.0
      IUPP=INT(ATEMP)
      ATEMP=((-AN/Z1)-1.0)/4.0
      ILOW=INT(ATEMP)
      DO2150K=ILOW,IUPP
        AK=REAL(K)
        ATEMP=(4.0*AK+3.0)*Z1
        CALL NODCDF(DBLE(ATEMP),DCDF1)
        ATEMP=((4.0*AK + 1.0)*Z1)
        CALL NODCDF(DBLE(ATEMP),DCDF2)
        DSUM2=DSUM2 + (DCDF1 - DCDF2)
 2150 CONTINUE
C
      ATEMP=((AN/Z2)-1.0)/4.0
      IUPP=INT(ATEMP)
      ATEMP=((-AN/Z2)+1.0)/4.0
      ILOW=INT(ATEMP)
      DSUM3=0.0D0
      DO2180K=ILOW,IUPP
        ATEMP=(4.0*REAL(K)+1.0)*Z2
        CALL NODCDF(DBLE(ATEMP),DCDF1)
        ATEMP=((4.0*REAL(K) - 1.0)*Z2)
        CALL NODCDF(DBLE(ATEMP),DCDF2)
        DSUM3=DSUM3 + (DCDF1 - DCDF2)
 2180 CONTINUE
C
      ATEMP=((AN/Z2)-3.0)/4.0
      IUPP=INT(ATEMP)
      ATEMP=((-AN/Z2)-1.0)/4.0
      ILOW=INT(ATEMP)
      DSUM4=0.0D0
      DO2190K=ILOW,IUPP
        ATEMP=(4.0*REAL(K)+3.0)*Z2
        CALL NODCDF(DBLE(ATEMP),DCDF1)
        ATEMP=((4.0*REAL(K) + 1.0)*Z2)
        CALL NODCDF(DBLE(ATEMP),DCDF2)
        DSUM4=DSUM4 + (DCDF1 - DCDF2)
 2190 CONTINUE
C
      STATCD=REAL(1.0D0 - DSUM1 + DSUM2)
      STATC2=REAL(1.0D0 - DSUM3 + DSUM4)
      PVAL1=STATCD
      PVAL2=STATC2
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CUS3')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPCUS3--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)N,IBUGA3,IERROR
 9012   FORMAT('N,IBUGA3,IERROR = ',I8,2X,A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPCUS5(STATVA,STATV2,PVAL1,PVAL2,
     1                  IFLAGU,IFRST,ILAST,
     1                  IBUGA2,IBUGA3,ISUBRO,IERROR)
C
C     PURPOSE--UTILITY ROUTINE USED BY DPCUSU.  THIS ROUTINE
C              UPDATES THE PARAMETERS "STATVAL" AND
C              "PVALUE".  NOTE THAT THERE ARE "FORWARD" AND "BACKWARD"
C              VERSIONS OF THE STATISTIC.
C
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORAOTRY
C                 NATIONAL INSTITUTE OF STANDARDS OF TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS OF TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2011/3
C     ORIGINAL VERSION--MARCH     2011.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IFLAGU
      CHARACTER*4 IBUGA2
      CHARACTER*4 IBUGA3
      CHARACTER*4 ISUBRO
      CHARACTER*4 IERROR
C
      LOGICAL IFRST
      LOGICAL ILAST
C
      CHARACTER*4 IH
      CHARACTER*4 IH2
      CHARACTER*4 ISUBN0
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCOHK.INC'
      INCLUDE 'DPCOHO.INC'
C
      CHARACTER*4 IOP
      SAVE IOUNI1
C
C-----COMMON----------------------------------------------------------
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IF(IBUGA2.EQ.'ON' .OR. ISUBRO.EQ.'CUS5')THEN
        ISTEPN='1'
        CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPCUS5--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,53)STATVA,STATV2,PVAL1,PVAL2
   53   FORMAT('STATVA,STATV2,PVAL1,PVAL2 = ',4G15.7)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      IF(IFLAGU.EQ.'FILE')THEN
C
        IF(IFRST)THEN
          IOP='OPEN'
          IFLAG1=1
          IFLAG2=0
          IFLAG3=0
          IFLAG4=0
          IFLAG5=0
          CALL DPAUFI(IOP,IFLAG1,IFLAG2,IFLAG3,IFLAG4,IFLAG5,
     1                IOUNI1,IOUNI2,IOUNI3,IOUNI4,IOUNI5,
     1                IBUGA3,ISUBRO,IERROR)
          IF(IERROR.EQ.'YES')GOTO9000
C
          WRITE(IOUNI1,295)
  295     FORMAT(11X,'STATVAL',8X,'PVALUE',
     1           6X,'STATVAL2',7X,'PVALUE2')
        ENDIF
        WRITE(IOUNI1,299)STATVA,STATV2,PVAL1,PVAL2
  299   FORMAT(4E15.7)
      ELSEIF(IFLAGU.EQ.'ON')THEN
        IF(STATVA.NE.CPUMIN)THEN
          IH='STAT'
          IH2='VAL '
          VALUE0=STATVA
          CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1                IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1                IANS,IWIDTH,IBUGA3,IERROR)
        ENDIF
C
        IF(STATV2.NE.CPUMIN)THEN
          IH='STAT'
          IH2='VAL2'
          VALUE0=STATV2
          CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1                IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1                IANS,IWIDTH,IBUGA3,IERROR)
        ENDIF
C
        IF(PVAL1.NE.CPUMIN)THEN
          IH='PVAL'
          IH2='UE  '
          VALUE0=PVAL1
          CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1                IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1                IANS,IWIDTH,IBUGA3,IERROR)
        ENDIF
C
        IF(PVAL2.NE.CPUMIN)THEN
          IH='PVAL'
          IH2='UE2 '
          VALUE0=PVAL2
          CALL DPADDP(IH,IH2,VALUE0,IHOST1,ISUBN0,
     1                IHNAME,IHNAM2,IUSE,VALUE,IVALUE,NUMNAM,MAXNAM,
     1                IANS,IWIDTH,IBUGA3,IERROR)
        ENDIF
C
      ENDIF
C
      IF(IFLAGU.EQ.'FILE')THEN
        IF(ILAST)THEN
          IOP='CLOS'
          IFLAG1=1
          IFLAG2=0
          IFLAG3=0
          IFLAG4=0
          IFLAG5=0
          CALL DPAUFI(IOP,IFLAG1,IFLAG2,IFLAG3,IFLAG4,IFLAG5,
     1                IOUNI1,IOUNI2,IOUNI3,IOUNI4,IOUNI5,
     1                IBUGA3,ISUBRO,IERROR)
C
          IF(IBUGA2.EQ.'ON' .OR. ISUBRO.EQ.'CUS5')THEN
            ISTEPN='3A'
            CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,301)IERROR
  301       FORMAT('AFTER CALL DPCLFI, IERROR = ',A4)
            CALL DPWRST('XXX','BUG ')
          ENDIF
C
          IF(IERROR.EQ.'YES')GOTO9000
        ENDIF
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
C
      IF(IBUGA2.EQ.'ON' .OR. ISUBRO.EQ.'CUS5')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END OF DPCUS5--')
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPCUSZ(IHARG,IARGT,ARG,NUMARG,DEFCSZ,
     1ACURSZ,IFOUND,IERROR)
C
C     PURPOSE--DEFINE THE SIZE FOR THE CURSOR
C              (THE HORIZONTAL STRING ABOVE THE UPPER HORIZONTAL FRAME).
C              THE SIZE FOR THE CURSOR WILL BE PLACED
C              IN THE FLOATING POINT VARIABLE ACURSZ.
C              (NOTE THAT THE IMPORTANT VARIABLE PDIAHE
C              IS USUALLY SET
C              EQUAL TO ACURSZ IN THE CALLING ROUTINE
C              AFTER THE CALL TO THIS SUBROUTINE).
C     INPUT  ARGUMENTS--IHARG  (A  HOLLERITH VECTOR)
C                     --NUMARG
C                     --DEFCSZ
C     OUTPUT ARGUMENTS--ACURSZ
C                     --IFOUND ('YES' OR 'NO' )
C                     --IERROR ('YES' OR 'NO' )
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--JANUARY   1980.
C     UPDATED         --MAY       1982.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IHARG
      CHARACTER*4 IARGT
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
C---------------------------------------------------------------------
C
      DIMENSION IHARG(*)
      DIMENSION IARGT(*)
      DIMENSION ARG(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IFOUND='NO'
      IERROR='NO'
C
      IF(NUMARG.LE.0)GOTO1199
      IF(IHARG(1).NE.'SIZE')GOTO1199
      IF(NUMARG.EQ.1)GOTO1150
      IF(IARGT(NUMARG).EQ.'NUMB')GOTO1160
      GOTO1110
C
 1110 CONTINUE
      IF(IHARG(NUMARG).EQ.'ON')GOTO1150
      IF(IHARG(NUMARG).EQ.'OFF')GOTO1150
      IF(IHARG(NUMARG).EQ.'AUTO')GOTO1150
      IF(IHARG(NUMARG).EQ.'DEFA')GOTO1150
C
 1120 CONTINUE
      IERROR='YES'
      WRITE(ICOUT,1121)
 1121 FORMAT('***** ERROR IN DPCUSZ--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1122)
 1122 FORMAT('      ILLEGAL FORM FOR CURSOR SIZE ',
     1'COMMAND.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1124)
 1124 FORMAT('      TEST EXAMPLE TO DEMONSTRATE THE ',
     1'PROPER FORM--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1125)
 1125 FORMAT('      SUPPOSE IT IS DESIRED TO HAVE ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1126)
 1126 FORMAT('      THE CURSOR ONE AND ONE HALF TIMES AS BIG ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1127)
 1127 FORMAT('      AS THE DEFAULT SIZE (WHICH IS SIZE 1), ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1128)
 1128 FORMAT('      THEN THE ALLOWABLE FORM IS--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1131)
 1131 FORMAT('      CURSOR SIZE 1.5 ')
      CALL DPWRST('XXX','BUG ')
      GOTO1199
C
 1150 CONTINUE
      ACURSZ=DEFCSZ
      GOTO1180
C
 1160 CONTINUE
      ACURSZ=ARG(NUMARG)
      GOTO1180
C
 1180 CONTINUE
      IFOUND='YES'
C
      IF(IFEEDB.EQ.'OFF')GOTO1189
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1181)ACURSZ
 1181 FORMAT('THE CURSOR SIZE HAS JUST BEEN SET TO ',
     1E15.7)
      CALL DPWRST('XXX','BUG ')
 1189 CONTINUE
      GOTO1199
C
 1199 CONTINUE
      RETURN
      END
      SUBROUTINE DPCXTE(XTEMP1,XTEMP2,MAXNXT,
     1                  ICAPSW,IFORSW,
     1                  IBUGA2,IBUGA3,IBUGQ,ISUBRO,IFOUND,IERROR)
C
C     PURPOSE--CARRY OUT A COX STUART TEST FOR TREND
C     EXAMPLE--COX STUART TEST Y
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBUG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2011/6
C     ORIGINAL VERSION--JUNE      2011.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IBUGA2
      CHARACTER*4 IBUGA3
      CHARACTER*4 IBUGQ
      CHARACTER*4 ISUBRO
      CHARACTER*4 ICAPSW
      CHARACTER*4 IFORSW
      CHARACTER*4 IFOUND
      CHARACTER*4 IERROR
C
      CHARACTER*4 IHWUSE
      CHARACTER*4 MESSAG
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*4 IH
      CHARACTER*4 IH2
      CHARACTER*4 ISUBN0
C
      CHARACTER*4 ICASAN
      CHARACTER*4 ICASA2
      CHARACTER*4 ICASA3
      CHARACTER*4 IMULT
      CHARACTER*4 IREPL
      CHARACTER*4 ICTMP1
      CHARACTER*4 ICTMP2
      CHARACTER*4 ICTMP3
C
      CHARACTER*4 ICASE
      CHARACTER*4 IVARID
      CHARACTER*4 IVARI2
      CHARACTER*4 IVARI3
      CHARACTER*4 IVARI4
      CHARACTER*40 INAME
      PARAMETER (MAXSPN=30)
      CHARACTER*4 IVARN1(MAXSPN)
      CHARACTER*4 IVARN2(MAXSPN)
      CHARACTER*4 IVARTY(MAXSPN)
      REAL PVAR(MAXSPN)
      INTEGER ILIS(MAXSPN)
      INTEGER NRIGHT(MAXSPN)
      INTEGER ICOLR(MAXSPN)
C
      CHARACTER*4 IFLAGU
      LOGICAL IFRST
      LOGICAL ILAST
C
C---------------------------------------------------------------------
C
      DIMENSION XTEMP1(*)
      DIMENSION XTEMP2(*)
C
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCOZZ.INC'
      DIMENSION Y2(MAXOBV)
      EQUIVALENCE (GARBAG(IGARB1),Y2(1))
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOHK.INC'
      INCLUDE 'DPCOSU.INC'
      INCLUDE 'DPCODA.INC'
      INCLUDE 'DPCOHO.INC'
      INCLUDE 'DPCOST.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPCX'
      ISUBN2='TE  '
C
      MAXCP1=MAXCOL+1
      MAXCP2=MAXCOL+2
      MAXCP3=MAXCOL+3
      MAXCP4=MAXCOL+4
      MAXCP5=MAXCOL+5
      MAXCP6=MAXCOL+6
C
      IFOUND='YES'
      IERROR='NO'
      IREPL='OFF'
      IMULT='OFF'
      ICASA2='TWOT'
C
C               **************************************
C               **  TREAT THE COX STUART TEST CASE  **
C               **************************************
C
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'CXTE')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF DPCXTE--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGA2,IBUGA3,IBUGQ,ISUBRO,MAXNXT
   52   FORMAT('IBUGA2,IBUGA3,IBUGQ,ISUBRO = ',4(A4,2X),I8)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               *********************************************************
C               **  STEP 1--                                           **
C               **  EXTRACT THE COMMAND                                **
C               *********************************************************
C
      ISTEPN='1'
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'CXTE')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      ILASTZ=9999
      ICASAN='COXS'
C
C     LOOK FOR:
C
C          COX STUART TEST
C          LOWER TAILED
C          UPPER TAILED
C
      DO100I=0,NUMARG-1
C
        IF(I.EQ.0)THEN
          ICTMP1=ICOM
        ELSE
          ICTMP1=IHARG(I)
        ENDIF
        ICTMP2=IHARG(I+1)
        ICTMP3=IHARG(I+2)
C
        IF(ICTMP1.EQ.'=')THEN
          IFOUND='NO'
          GOTO9000
        ELSEIF(ICTMP1.EQ.'COX ' .AND. ICTMP2.EQ.'STUA' .AND.
     1         ICTMP3.EQ.'TEST')THEN
          IFOUND='YES'
          ICASAN='COXS'
          ILASTZ=I+2
        ELSEIF(ICTMP1.EQ.'COX ' .AND. ICTMP2.EQ.'STUA')THEN
          IFOUND='YES'
          ICASAN='COXS'
          ILASTZ=I+1
        ELSEIF(ICTMP1.EQ.'LOWE' .AND. ICTMP2.EQ.'TAIL')THEN
          ICASA2='LOWE'
          ILASTZ=MAX(ILASTZ,I+1)
        ELSEIF(ICTMP1.EQ.'UPPE' .AND. ICTMP2.EQ.'TAIL')THEN
          ICASA2='UPPE'
          ILASTZ=MAX(ILASTZ,I+1)
        ENDIF
  100 CONTINUE
C
      IF(IFOUND.EQ.'NO')GOTO9000
C
      ISHIFT=ILASTZ
      CALL SHIFTL(ISHIFT,IHARG,IHARG2,IARG,ARG,IARGT,NUMARG,
     1            IBUGA2,IERROR)
C
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'CXTE')THEN
        WRITE(ICOUT,91)ICASAN,ICASA2,ISHIFT
   91   FORMAT('DPCXTE: ICASAN,ICASA2,ISHIFT = ',
     1         2(A4,2X),I5)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               ****************************************
C               **  STEP 2--                          **
C               **  EXTRACT THE VARIABLE LIST         **
C               ****************************************
C
      ISTEPN='2'
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'CXTE')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      INAME='COX-STUART TEST'
      MINNA=1
      MAXNA=100
      MINN2=2
      IFLAGE=0
      IFLAGM=1
      MINNVA=1
      MAXNVA=MAXSPN
      IF(IREPL.EQ.'ON')THEN
        IFLAGE=1
        IFLAGM=0
      ENDIF
      JMIN=1
      JMAX=NUMARG
C
      CALL DPPARS(IHARG,IHARG2,IARGT,ARG,NUMARG,IANS,IWIDTH,
     1            IHNAME,IHNAM2,IUSE,NUMNAM,IN,IVALUE,VALUE,
     1            JMIN,JMAX,
     1            MINN2,MINNA,MAXNA,MAXSPN,IFLAGE,INAME,
     1            IVARN1,IVARN2,IVARTY,PVAR,
     1            ILIS,NRIGHT,ICOLR,ISUB,NQ,ILOCQ,NUMVAR,
     1            MINNVA,MAXNVA,
     1            IFLAGM,IFLAGP,
     1            IBUGA3,IBUGQ,ISUBRO,IFOUND,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'CXTE')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,281)
  281   FORMAT('***** AFTER CALL DPPARS--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,282)NQ,NUMVAR
  282   FORMAT('NQ,NUMVAR = ',2I8)
        CALL DPWRST('XXX','BUG ')
        IF(NUMVAR.GT.0)THEN
          DO285I=1,NUMVAR
            WRITE(ICOUT,287)I,IVARN1(I),IVARN2(I),ILIS(I),NRIGHT(I),
     1                      ICOLR(I)
  287       FORMAT('I,IVARN1(I),IVARN2(I),ILIS(I),NRIGHT(I),',
     1             'ICOLR(I) = ',I8,2X,A4,A4,2X,3I8)
            CALL DPWRST('XXX','BUG ')
  285     CONTINUE
        ENDIF
      ENDIF
C
C               ******************************************************
C               **  STEP 3A--                                       **
C               **  CASE 1: NO REPLICATION.                         **
C               ******************************************************
C
      ISTEPN='3A'
      IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'CXTE')
     1  CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      NUMVA2=1
      DO5210I=1,NUMVAR
        ICOL=I
        CALL DPPAR3(ICOL,IVALUE,IVALU2,IN,MAXN,MAXOBV,
     1              INAME,IVARN1,IVARN2,IVARTY,
     1              ILIS,NRIGHT,ICOLR,ISUB,NQ,NUMVA2,
     1              MAXCOL,MAXCP1,MAXCP2,MAXCP3,
     1              MAXCP4,MAXCP5,MAXCP6,
     1              V,PRED,RES,YPLOT,XPLOT,X2PLOT,TAGPLO,
     1              Y,Y,Y,NS1,NLOCA2,NLOCA3,ICASE,
     1              IBUGA3,ISUBRO,IFOUND,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
C
C               *****************************************
C               **  STEP 52--                          **
C               **  PERFORM COX STUART    TEST         **
C               *****************************************
C
        ISTEPN='52'
        IF(IBUGA2.EQ.'ON' .OR. ISUBRO.EQ.'CXTE')THEN
          CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,5211)
 5211     FORMAT('***** FROM DPCXTE, BEFORE CALL DPCXT2--')
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,5212)I,NS1,MAXN
 5212     FORMAT('I,NS1,MAXN = ',3I8)
          CALL DPWRST('XXX','BUG ')
          DO5215II=1,NS1
            WRITE(ICOUT,5216)II,Y(II)
 5216       FORMAT('I,Y(I) = ',I8,G15.7)
            CALL DPWRST('XXX','BUG ')
 5215     CONTINUE
        ENDIF
C
        IVARID=IVARN1(I)
        IVARI2=IVARN2(I)
        CALL DPCXT2(Y,NS1,ICASA2,
     1              Y2,XTEMP1,XTEMP2,MAXNXT,
     1              ICAPSW,ICAPTY,IFORSW,
     1              IVARID,IVARI2,
     1              STATV1,STATV2,STATC1,STATC2,
     1              PVAL2T,PVALLT,PVALUT,
     1              CTL999,CUTL99,CUTL95,CUTL90,CUTL80,CUTL50,
     1              CTU999,CUTU99,CUTU95,CUTU90,CUTU80,CUTU50,
     1              IBUGA3,ISUBRO,IERROR)
        IF(IERROR.EQ.'YES')GOTO9000
C
C               ***************************************
C               **  STEP 8C--                        **
C               **  UPDATE INTERNAL DATAPLOT TABLES  **
C               ***************************************
C
        ISTEPN='8C'
        IF(IBUGA2.EQ.'ON'.OR.ISUBRO.EQ.'CXTE')
     1    CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
        IFLAGU='ON'
        IFRST=.FALSE.
        ILAST=.FALSE.
        IF(I.EQ.1)IFRST=.TRUE.
        IF(I.EQ.NUMVAR)ILAST=.TRUE.
        ICASA3='TWOS'
        CALL DPSIG5(ICASA3,STATV1,STATC1,
     1              PVAL2T,PVALLT,PVALUT,
     1              CTL999,CUTL99,CUTL95,CUTL90,CUTL80,CUTL50,
     1              CTU999,CUTU99,CUTU95,CUTU90,CUTU80,CUTU50,
     1              IFLAGU,IFRST,ILAST,
     1              IBUGA2,IBUGA3,ISUBRO,IERROR)
C
 5210 CONTINUE
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA2.EQ.'ON' .OR. ISUBRO.EQ.'CXTE')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPCXTE--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9016)IFOUND,IERROR
 9016   FORMAT('IFOUND,IERROR = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPCXT2(Y1,N,ICASAN,
     1                  Y2,XTEMP1,XTEMP2,MAXNXT,
     1                  ICAPSW,ICAPTY,IFORSW,
     1                  IVARID,IVARI2,
     1                  STATV1,STATV2,STATC1,STATC2,
     1                  PVAL2T,PVALLT,PVALUT,
     1                  CTL999,CUTL99,CUTL95,CUTL90,CUTL80,CUTL50,
     1                  CTU999,CUTU99,CUTU95,CUTU90,CUTU80,CUTU50,
     1                  IBUGA3,ISUBRO,IERROR)
C
C     PURPOSE--THIS ROUTINE CARRIES OUT THE COX-STUART TREND TEST.
C              THIS IS ESSENTIALLY A TWO-SAMPLE SIGN TEST BETWEEN POINTS
C              BELOW THE MEDIAN WITH POINTS ABOVE THE MEDIAN.
C     EXAMPLE--COX STUART TEST Y
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBUG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2011/6
C     ORIGINAL VERSION--JUNE      2011.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IVARID
      CHARACTER*4 IVARI2
      CHARACTER*4 ICAPTY
      CHARACTER*4 ICAPSW
      CHARACTER*4 IFORSW
      CHARACTER*4 IBUGA3
      CHARACTER*4 ICASAN
      CHARACTER*4 ISUBRO
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      DIMENSION Y1(*)
      DIMENSION Y2(*)
      DIMENSION XTEMP1(*)
      DIMENSION XTEMP2(*)
C
      DOUBLE PRECISION DCDF
      DOUBLE PRECISION DPPF
      DOUBLE PRECISION DPAR
C
      PARAMETER (NUMALP=6)
      REAL ALPHA(NUMALP)
C
      PARAMETER(NUMCLI=5)
      PARAMETER(MAXLIN=3)
      PARAMETER (MAXROW=NUMALP)
      PARAMETER (MAXRO2=35)
      CHARACTER*60 ITITLE
      CHARACTER*60 ITITLZ
      CHARACTER*60 ITITL9
      CHARACTER*60 ITEXT(MAXRO2)
      CHARACTER*4  ALIGN(NUMCLI)
      CHARACTER*4  VALIGN(NUMCLI)
      REAL         AVALUE(MAXRO2)
      INTEGER      NCTEXT(MAXRO2)
      INTEGER      IDIGIT(MAXRO2)
      INTEGER      NTOT(MAXRO2)
      CHARACTER*60 ITITL2(MAXLIN,NUMCLI)
      CHARACTER*15 IVALUE(MAXROW,NUMCLI)
      CHARACTER*4  ITYPCO(NUMCLI)
      INTEGER      NCTIT2(MAXLIN,NUMCLI)
      INTEGER      NCVALU(MAXROW,NUMCLI)
      INTEGER      IWHTML(NUMCLI)
      INTEGER      IWRTF(NUMCLI)
      REAL         AMAT(MAXROW,NUMCLI)
      LOGICAL IFRST
      LOGICAL ILAST
      LOGICAL IFLAGS
      LOGICAL IFLAGE
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      DATA ALPHA/0.50, 0.80, 0.90, 0.95, 0.99, 0.999/
C
      ISUBN1='DPCX'
      ISUBN2='T2  '
C
      IERROR='NO'
      IWRITE='OFF'
C
      NUMDIG=7
      IF(IFORSW.EQ.'1')NUMDIG=1
      IF(IFORSW.EQ.'2')NUMDIG=2
      IF(IFORSW.EQ.'3')NUMDIG=3
      IF(IFORSW.EQ.'4')NUMDIG=4
      IF(IFORSW.EQ.'5')NUMDIG=5
      IF(IFORSW.EQ.'6')NUMDIG=6
      IF(IFORSW.EQ.'7')NUMDIG=7
      IF(IFORSW.EQ.'8')NUMDIG=8
      IF(IFORSW.EQ.'9')NUMDIG=9
      IF(IFORSW.EQ.'0')NUMDIG=0
      IF(IFORSW.EQ.'E')NUMDIG=-2
      IF(IFORSW.EQ.'-2')NUMDIG=-2
      IF(IFORSW.EQ.'-3')NUMDIG=-3
      IF(IFORSW.EQ.'-4')NUMDIG=-4
      IF(IFORSW.EQ.'-5')NUMDIG=-5
      IF(IFORSW.EQ.'-6')NUMDIG=-6
      IF(IFORSW.EQ.'-7')NUMDIG=-7
      IF(IFORSW.EQ.'-8')NUMDIG=-8
      IF(IFORSW.EQ.'-9')NUMDIG=-9
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CXT2')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF DPCXT2--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,ICASAN,IVARID,IVARI2
   52   FORMAT('IBUGA3,ISUBRO,ICASAN,IVARID,IVARI2 = ',4(A4,2X),A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,55)N
   55   FORMAT('N1 = ',2I8)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,N
          WRITE(ICOUT,57)I,Y1(I)
   57     FORMAT('I,Y1(I) = ',I8,G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               *********************************
C               **  STEP 11--                  **
C               **  SPLIT THE DATA INTO 2      **
C               **  PARTS                      **
C               *********************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CXT2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IODD=MOD(N,2)
      IF(IODD.EQ.0)THEN
        IC=N/2
        DO1110I=1,IC
          Y2(I)=Y1(IC+I)
 1110   CONTINUE
        N1=IC
      ELSE
        IC=(N+1)/2
        N1=IC-1
        DO1120I=1,N1
          Y2(I)=Y1(IC+I)
 1120   CONTINUE
      ENDIF
C
C               *********************************
C               **  STEP 11--                  **
C               **  CARRY OUT CALCULATIONS FOR **
C               **  THE COX-STUART      TEST   **
C               *********************************
C
 1100 CONTINUE
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CXT2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      D0=0.0
      CALL DPSIG4(Y1,N1,Y2,N1,D0,IWRITE,
     1            XTEMP1,XTEMP2,MAXNXT,
     1            Y1MEAN,Y1MED,Y1SD,Y1MAD,
     1            Y2MEAN,Y2MED,Y2SD,Y2MAD,
     1            STATV1,STATC1,STATV2,STATC2,RTIES,NTEMP,
     1            PVAL2T,PVALLT,PVALUT,
     1            ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      DPAR=0.5D0
      CALL BINPPF(.0005D0,DPAR,NTEMP,DPPF)
      CTL999=DPPF
      CALL BINPPF(.005D0,DPAR,NTEMP,DPPF)
      CUTL99=DPPF
      CALL BINPPF(.025D0,DPAR,NTEMP,DPPF)
      CUTL95=DPPF
      CALL BINPPF(.05D0,DPAR,NTEMP,DPPF)
      CUTL90=DPPF
      CALL BINPPF(.1D0,DPAR,NTEMP,DPPF)
      CUTL80=DPPF
      CALL BINPPF(.25D0,DPAR,NTEMP,DPPF)
      CUTL50=DPPF
      CALL BINPPF(.75D0,DPAR,NTEMP,DPPF)
      CUTU50=DPPF
      CALL BINPPF(.90D0,DPAR,NTEMP,DPPF)
      CUTU80=DPPF
      CALL BINPPF(.95D0,DPAR,NTEMP,DPPF)
      CUTU90=DPPF
      CALL BINPPF(.975D0,DPAR,NTEMP,DPPF)
      CUTU95=DPPF
      CALL BINPPF(.995D0,DPAR,NTEMP,DPPF)
      CUTU99=DPPF
      CALL BINPPF(.9995D0,DPAR,NTEMP,DPPF)
      CTU999=DPPF
C
C               *********************************
C               **   STEP 32--                 **
C               **   WRITE OUT EVERYTHING      **
C               **   FOR COX STUART      TEST  **
C               *********************************
C
      ISTEPN='42'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CXT2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(IPRINT.EQ.'OFF')GOTO9000
C
      ITITLE='Cox Stuart Test for Trend'
      NCTITL=25
      ITITLZ='(Compare Observations < Midpoint to Those > Midpoint)'
      NCTITZ=53
C
      ICNT=1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=0
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Response Variable:  '
      WRITE(ITEXT(ICNT)(21:24),'(A4)')IVARID(1:4)
      WRITE(ITEXT(ICNT)(25:28),'(A4)')IVARI2(1:4)
      NCTEXT(ICNT)=28
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=1
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='H0: There is No Trend'
      NCTEXT(ICNT)=21
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Ha: There is a Trend'
      NCTEXT(ICNT)=20
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=1
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Summary Statistics:'
      NCTEXT(ICNT)=19
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations for Original Sample:'
      NCTEXT(ICNT)=23
      AVALUE(ICNT)=REAL(N)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Observations After Matching:'
      NCTEXT(ICNT)=38
      AVALUE(ICNT)=REAL(NTEMP)
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=1
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Summary Statistics for Points Below Midpoint:'
      NCTEXT(ICNT)=45
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=Y1MEAN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Median:'
      NCTEXT(ICNT)=14
      AVALUE(ICNT)=Y1MED
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=Y1SD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Median Absolute Deviation:'
      NCTEXT(ICNT)=32
      AVALUE(ICNT)=Y1MAD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=1
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=1
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Summary Statistics for Points Above Midpoint:'
      NCTEXT(ICNT)=45
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Mean:'
      NCTEXT(ICNT)=12
      AVALUE(ICNT)=Y2MEAN
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Median:'
      NCTEXT(ICNT)=14
      AVALUE(ICNT)=Y2MED
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Standard Deviation:'
      NCTEXT(ICNT)=26
      AVALUE(ICNT)=Y2SD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='Sample Median Absolute Deviation:'
      NCTEXT(ICNT)=32
      AVALUE(ICNT)=Y2MAD
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)=' '
      NCTEXT(ICNT)=1
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
C
      ICNT=ICNT+1
      ITEXT(ICNT)='Test:'
      NCTEXT(ICNT)=5
      AVALUE(ICNT)=0.0
      IDIGIT(ICNT)=-1
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Positive Differences:'
      NCTEXT(ICNT)=31
      AVALUE(ICNT)=STATV1
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Negative Differences:'
      NCTEXT(ICNT)=31
      AVALUE(ICNT)=STATV2
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='Number of Ties:'
      NCTEXT(ICNT)=15
      AVALUE(ICNT)=RTIES
      IDIGIT(ICNT)=0
      ICNT=ICNT+1
      ITEXT(ICNT)='CDF Value for Positive Values:'
      NCTEXT(ICNT)=30
      AVALUE(ICNT)=STATC1
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='CDF Value for Negative Values:'
      NCTEXT(ICNT)=30
      AVALUE(ICNT)=STATC2
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='P-Value (2-tailed test):'
      NCTEXT(ICNT)=24
      AVALUE(ICNT)=PVAL2T
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='P-Value (lower-tailed test):'
      NCTEXT(ICNT)=28
      AVALUE(ICNT)=PVALLT
      IDIGIT(ICNT)=NUMDIG
      ICNT=ICNT+1
      ITEXT(ICNT)='P-Value (upper-tailed test):'
      NCTEXT(ICNT)=28
      AVALUE(ICNT)=PVALUT
      IDIGIT(ICNT)=NUMDIG
C
      NUMROW=ICNT
      DO4110I=1,NUMROW
        NTOT(I)=15
 4110 CONTINUE
C
      IFRST=.TRUE.
      ILAST=.TRUE.
C
      CALL DPDTA1(ITITLE,NCTITL,ITITLZ,NCTITZ,ITEXT,NCTEXT,
     1            AVALUE,IDIGIT,
     1            NTOT,NUMROW,
     1            ICAPSW,ICAPTY,ILAST,IFRST,
     1            ISUBRO,IBUGA3,IERROR)
C
      ISTEPN='21B'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CXT2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      ITITLE='Two-Tailed Test'
      NCTITL=15
      ITITL9='H0: P(+) = P(-); Ha: P(+) <> P(-)'
      NCTIT9=33
C
      DO4130J=1,NUMCLI
        DO4140I=1,3
          ITITL2(I,J)=' '
          NCTIT2(I,J)=0
 4140   CONTINUE
 4130 CONTINUE
C
      ITITL2(2,1)='Significance'
      NCTIT2(2,1)=12
      ITITL2(3,1)='Level'
      NCTIT2(3,1)=5
C
      ITITL2(2,2)='Test '
      NCTIT2(2,2)=4
      ITITL2(3,2)='Statistic'
      NCTIT2(3,2)=9
C
      ITITL2(1,3)='Lower'
      NCTIT2(1,3)=5
      ITITL2(2,3)='Critical'
      NCTIT2(2,3)=8
      ITITL2(3,3)='Value (<)'
      NCTIT2(3,3)=9
C
      ITITL2(1,4)='Upper'
      NCTIT2(1,4)=5
      ITITL2(2,4)='Critical'
      NCTIT2(2,4)=8
      ITITL2(3,4)='Value (>)'
      NCTIT2(3,4)=9
C
      ITITL2(1,5)='Null'
      NCTIT2(1,5)=4
      ITITL2(2,5)='Hypothesis'
      NCTIT2(2,5)=10
      ITITL2(3,5)='Conclusion'
      NCTIT2(3,5)=10
C
      NMAX=0
      NUMCOL=5
      DO4150I=1,NUMCOL
        VALIGN(I)='b'
        ALIGN(I)='r'
        NTOT(I)=15
        NMAX=NMAX+NTOT(I)
        ITYPCO(I)='NUME'
        IDIGIT(I)=0
        IF(I.EQ.1 .OR. I.EQ.5)THEN
          ITYPCO(I)='ALPH'
        ENDIF
 4150 CONTINUE
C
      IWHTML(1)=125
      IWHTML(2)=150
      IWHTML(3)=150
      IWHTML(4)=150
      IWHTML(5)=150
      IINC=1600
      IINC2=1400
      IWRTF(1)=IINC
      IWRTF(2)=IWRTF(1)+IINC
      IWRTF(3)=IWRTF(2)+IINC
      IWRTF(4)=IWRTF(3)+IINC
      IWRTF(5)=IWRTF(4)+IINC
C
      DO4160J=1,NUMALP
C
        AMAT(J,2)=STATV1
        ALPHAT=(1.0 - ALPHA(J))/2.0
        CALL BINPPF(DBLE(ALPHAT),DPAR,NTEMP,DPPF)
        AMAT(J,3)=REAL(DPPF)
        ALPHAT=1.0 - ALPHAT
        CALL BINPPF(DBLE(ALPHAT),DPAR,NTEMP,DPPF)
        AMAT(J,4)=REAL(DPPF)
        IVALUE(J,5)(1:6)='ACCEPT'
        IF(STATV1.LT.AMAT(J,3))IVALUE(J,5)(1:6)='REJECT'
        IF(STATV1.GT.AMAT(J,4))IVALUE(J,5)(1:6)='REJECT'
        NCVALU(J,5)=6
C
        ALPHAT=100.0*ALPHA(J)
        WRITE(IVALUE(J,1)(1:4),'(F4.1)')ALPHAT
        IVALUE(J,1)(5:5)='%'
        NCVALU(J,1)=5
 4160 CONTINUE
C
      ICNT=NUMALP
      NUMLIN=3
      IFRST=.TRUE.
      ILAST=.TRUE.
      IFLAGS=.TRUE.
      IFLAGE=.TRUE.
      IF(ICASAN.NE.'LOWE' .AND. ICASAN.NE.'UPPE')THEN
        CALL DPDTA5(ITITLE,NCTITL,
     1              ITITL9,NCTIT9,ITITL2,NCTIT2,
     1              MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1              IVALUE,NCVALU,AMAT,ITYPCO,MAXROW,ICNT,
     1              IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1              ICAPSW,ICAPTY,IFRST,ILAST,
     1              IFLAGS,IFLAGE,
     1              ISUBRO,IBUGA3,IERROR)
      ENDIF
      IF(ICASAN.EQ.'TWOT')GOTO9000
C
      ITITLE='Lower One-Tailed Test (decreasing trend)'
      NCTITL=40
      ITITL9='H0: P(+) = P(-); Ha: P(+) < P(-)'
      NCTIT9=32
C
      ITITL2(2,3)='Critical'
      NCTIT2(2,3)=8
      ITITL2(3,3)='Value (<)'
      NCTIT2(3,3)=9
C
      ITITL2(1,4)='Null'
      NCTIT2(1,4)=4
      ITITL2(2,4)='Hypothesis'
      NCTIT2(2,4)=10
      ITITL2(3,4)='Conclusion'
      NCTIT2(3,4)=10
      ITYPCO(4)='ALPH'
C
      NMAX=0
      NUMCOL=4
      DO4250I=1,NUMCOL
        NTOT(I)=15
        NMAX=NMAX+NTOT(I)
 4250 CONTINUE
C
      DO4260J=1,NUMALP
        ALPHAT=1.0 - ALPHA(J)
        CALL BINPPF(DBLE(ALPHAT),DPAR,NTEMP,DPPF)
        AMAT(J,3)=REAL(DPPF)
        IVALUE(J,4)(1:6)='REJECT'
        IF(STATVA.GE.AMAT(J,3))THEN
          IVALUE(J,4)(1:6)='ACCEPT'
        ENDIF
        NCVALU(J,4)=6
 4260 CONTINUE
C
      ICNT=NUMALP
      NUMLIN=3
      IFRST=.TRUE.
      ILAST=.TRUE.
      IFLAGS=.TRUE.
      IFLAGE=.TRUE.
      IF(ICASAN.NE.'UPPE')THEN
        CALL DPDTA5(ITITLE,NCTITL,
     1              ITITL9,NCTIT9,ITITL2,NCTIT2,
     1              MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1              IVALUE,NCVALU,AMAT,ITYPCO,MAXROW,ICNT,
     1              IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1              ICAPSW,ICAPTY,IFRST,ILAST,
     1              IFLAGS,IFLAGE,
     1              ISUBRO,IBUGA3,IERROR)
      ENDIF
C
      IF(ICASAN.EQ.'LOWE')GOTO9000
C
      ITITLE='Upper One-Tailed Test (increasing trend)'
      NCTITL=40
      ITITL9='H0: P(+) = P(-); Ha: P(+) > P(-)'
      NCTIT9=32
C
      ITITL2(1,3)='Upper'
      NCTIT2(1,3)=5
      ITITL2(2,3)='Critical'
      NCTIT2(2,3)=8
      ITITL2(3,3)='Value (>)'
      NCTIT2(3,3)=9
C
      NMAX=0
      NUMCOL=4
      DO4350I=1,NUMCOL
        NTOT(I)=15
        NMAX=NMAX+NTOT(I)
 4350 CONTINUE
C
      DO4360J=1,NUMALP
        ALPHAT=ALPHA(J)
        CALL BINPPF(DBLE(ALPHAT),DPAR,NTEMP,DPPF)
        AMAT(J,3)=REAL(DPPF)
        IVALUE(J,4)(1:6)='REJECT'
        IF(STATVA.LE.AMAT(J,3))THEN
          IVALUE(J,4)(1:6)='ACCEPT'
        ENDIF
        NCVALU(J,4)=6
 4360 CONTINUE
C
      ICNT=NUMALP
      NUMLIN=3
      IFRST=.TRUE.
      ILAST=.TRUE.
      IFLAGS=.TRUE.
      IFLAGE=.TRUE.
      CALL DPDTA5(ITITLE,NCTITL,
     1            ITITL9,NCTIT9,ITITL2,NCTIT2,
     1            MAXLIN,NUMLIN,NUMCLI,NUMCOL,
     1            IVALUE,NCVALU,AMAT,ITYPCO,MAXROW,ICNT,
     1            IDIGIT,NTOT,IWHTML,IWRTF,VALIGN,ALIGN,NMAX,
     1            ICAPSW,ICAPTY,IFRST,ILAST,
     1            IFLAGS,IFLAGE,
     1            ISUBRO,IBUGA3,IERROR)
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'CXT2')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF DPCXT2--')
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE DPCYGR(IANSLC,IWIDTH,IHARG,IARGT,IARG,NUMARG,
     1IBUGS2,ISUBRO,IFOUND,IERROR)
C
C     PURPOSE--CYCLE THROUGH THE CURRENTLY SAVED PIXMAPS
C
C                  CYCLE GRAPHS  (OR CYCLE PLOT, CG, CP)
C
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--97/4
C     ORIGINAL VERSION--APRIL     1997.
C     UPDATED         --AUGUST    1997. MOVE SOME CODE TO A LOWER LEVEL
C                                       TO SUPPORT NON-X11 DEVICES
C                                       (SPECIFICALLY PC FOR NOW)
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      INCLUDE 'DPCOPA.INC'
      CHARACTER*4 IANSLC
      CHARACTER*4 IHARG
      CHARACTER*4 IARGT
      CHARACTER*4 ICODE
      CHARACTER*256 ISTRI2
      CHARACTER*128 CTEMP
C
      CHARACTER*4 IBUGS2
      CHARACTER*4 ISUBRO
      CHARACTER*4 IERROR
      CHARACTER*4 IFOUND
C
      CHARACTER*4 ISTEPN
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
CCCCC DIMENSION IADE(128)
CCCCC DIMENSION IADE2(128)
C
      DIMENSION IANSLC(*)
      DIMENSION IHARG(*)
      DIMENSION IARGT(*)
      DIMENSION IARG(*)
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOPM.INC'
      INCLUDE 'DPCOF2.INC'
      INCLUDE 'DPCOHO.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='DPLI'
      ISUBN2='GR  '
C
      IFOUND='NO'
      IERROR='NO'
C
      IF(IBUGS2.EQ.'OFF'.AND.ISUBRO.NE.'CYGR')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('AT THE BEGINNING OF DPCYGR--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGS2,ISUBRO,IFOUND,IERROR
   52 FORMAT('IBUGS2,ISUBRO,IFOUND,IERROR = ',A4,2X,A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
      IFOUND='YES'
C
C               *******************************
C               **  STEP 12--                **
C               **  CALL XCYCLE              **
C               *******************************
C
      ISTEPN='12'
      IF(IBUGS2.EQ.'ON'.OR.ISUBRO.EQ.'CYGR')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(NUMPXM.LT.2)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1203)
        CALL DPWRST('XXX','BUG')
        IERROR='YES'
        GOTO9000
      ELSE
        IF(IFEEDB.EQ.'ON')THEN
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,1213)
          CALL DPWRST('XXX','BUG')
          WRITE(ICOUT,1215)
          CALL DPWRST('XXX','BUG')
          WRITE(ICOUT,1217)
          CALL DPWRST('XXX','BUG')
          IF(ICOMPI.EQ.'MS-F')THEN
            WRITE(ICOUT,1221)
          ELSE
            WRITE(ICOUT,1219)
          ENDIF
          CALL DPWRST('XXX','BUG')
        ENDIF
      ENDIF
 1203 FORMAT('***** THERE ARE FEWER THAN TWO CURRENTLY SAVED PIMAPS.')
 1213 FORMAT('***** TO CYCLE THROUGH THE PREVIOUSLY SAVED GRAPHS:')
 1215 FORMAT('      1. CLICK THE LEFT MOUSE BUTTON TO CYCLE BACK.')
 1217 FORMAT('      2. CLICK THE RIGHT MOUSE BUTTON TO CYCLE FORWARD.')
 1219 FORMAT('      3. CLICK THE MIDDLE MOUSE BUTTON TO STOP CYCLING.')
 1221 FORMAT('      3. HOLD SHIFT OR CONTROL KEY DOWN WHILE CLICKING ',
     1'THE LEFT OR RIGHT BUTTON TO STOP CYCLING.')
C
C  AUGUST 1997.  IN ORDER TO GENERALIZE THE CODE TO NON-X11 DEVICES,
C  MOVE FOLLOWING CODE TO LOWER LEVEL ROUTINE.
C
      ICODE='CYCL'
      ISTRI2=' '
      CTEMP=' '
      NCSTR2=0
      NCTEMP=0
      CALL GRSAGR(ICODE,ISTRI2,NCSTR2,CTEMP,NCTEMP)
C
C1000 CONTINUE
CCCCC IERR=0
CCCCC CALL XCYCLE(IERR,IBUTTN)
CCCCC IF(IERR.EQ.4)THEN
CCCCC   WRITE(ICOUT,999)
CCCCC   CALL DPWRST('XXX','BUG ')
CCCCC   WRITE(ICOUT,1310)
CCCCC   CALL DPWRST('XXX','BUG ')
CCCCC   IERROR='YES'
CCCCC   GOTO9000
CCCCC ELSEIF(IERR.NE.0)THEN
CCCCC   WRITE(ICOUT,999)
CCCCC   CALL DPWRST('XXX','BUG ')
CCCCC   WRITE(ICOUT,1310)
CCCCC   CALL DPWRST('XXX','BUG ')
CCCCC   IERROR='YES'
CCCCC   GOTO9000
CCCCC ENDIF
C1310 FORMAT('***** ERROR FROM DPCYGR: X11 NOT ACTIVE ON THIS ',
CCCCC1'IMPLEMENTATION.')
C1311 FORMAT('***** ERROR FROM DPCYGR: ERROR TRYING TO REDRAW PIXMAP.')
CCCCC IF(IBUTTN.EQ.1)THEN
CCCCC   ICURPM=ICURPM-1
CCCCC   IF(ICURPM.LT.1)ICURPM=1
CCCCC ELSEIF(IBUTTN.EQ.3)THEN
CCCCC   ICURPM=ICURPM+1
CCCCC   IF(ICURPM.GT.NUMPXM)ICURPM=NUMPXM
CCCCC ELSE
CCCCC   GOTO9000
CCCCC ENDIF
C
CCCCC NCSTR2=1
CCCCC DO1405I=128,1,-1
CCCCC   NCSTR2=I
CCCCC   IF(IPXMFN(ICURPM)(I:I).NE.' ')GOTO1409
C1405 CONTINUE
C1409 CONTINUE
CCCCC CTEMP=' '
CCCCC IF(ICURPM.LE.9)THEN
CCCCC   CTEMP(1:4)='  - '
CCCCC   WRITE(CTEMP(1:1),'(I1)')ICURPM
CCCCC   NCTEMP=4
CCCCC ELSEIF(ICURPM.LE.99)THEN
CCCCC   CTEMP(1:5)='   - '
CCCCC   WRITE(CTEMP(1:2),'(I2)')ICURPM
CCCCC   NCTEMP=5
CCCCC ELSEIF(ICURPM.LE.999)THEN
CCCCC   CTEMP(1:6)='    - '
CCCCC   WRITE(CTEMP(1:3),'(I3)')ICURPM
CCCCC   NCTEMP=6
CCCCC ENDIF
CCCCC DO1415I=1,NCTEMP
CCCCC   CALL DPCOAN(CTEMP(I:I),IADE2(I))
C1415 CONTINUE
CCCCC DO1420I=1,NCSTR2
CCCCC   CALL DPCOAN(IPXMFN(ICURPM)(I:I),IADE(I))
CCCCC   CALL DPCOAN(IPXMFN(ICURPM)(I:I),IADE2(I+NCTEMP))
C1420 CONTINUE
CCCCC IADE(NCSTR2+1)=0
CCCCC IADE2(NCSTR2+NCTEMP+1)=0
CCCCC IERR=0
CCCCC CALL XRESTG(IADE,IADE2,IERR)
CCCCC IF(IERR.NE.0)THEN
CCCCC   WRITE(ICOUT,999)
CCCCC   CALL DPWRST('XXX','BUG ')
CCCCC   WRITE(ICOUT,1310)
CCCCC   CALL DPWRST('XXX','BUG ')
CCCCC   IERROR='YES'
CCCCC   GOTO9000
CCCCC ENDIF
C
CCCCC GOTO1000
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGS2.EQ.'OFF'.AND.ISUBRO.NE.'CYGR')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
