C-----THIS IS COMMON/INCLUDE FILE DPCOZZ.INC-----
C     THIS IS THE PRIMARY COMMON FOR DIMENSION REDUCTION VIA SCRATCH AREA
C
C     UPDATED--AUGUST      1990.  MOVE IGARB0 SETTING TO DPCOPA.INC
C     UPDATED--MAY         1995.  10 ADDITIONAL ARRAYS FOR DPFIT.
C
C  THIS INCLUDE FILE CREATES A COMMON BLOCK FOR "SCRATCH" STORAGE.
C  MANY DATAPLOT ROUTINES DIMENSION TEMPORARY ARRAYS OF SIZE MAXOBV
C  (MAXIMUM NUMBER OF OBSERVATIONS FOR A VARIABLE) AND MAXPOP (MAXIMUM
C  NUMBER OF POINTS PER PLOT).  AS MAXOBV AND MAXPOP ARE ADJUSTED
C  UPWARD, THE SIZE OF THE DATAPLOT EXECUTABLE FILE EXPANDS RAPIDLY.
C  THE PURPOSE OF THIS COMMON BLOCK IS TO ALLOW "MAXOBV" TO BE INCREASED
C  WITHOUT DRASTICALLY INCREASING THE SIZE OF DATAPLOT'S EXECUTABLE FILE.
C  THIS IS POSSIBLE BECAUSE THE DATAPLOT ROUTINES CAN EQUIVALENCE THEIR
C  TEMPORARY ARRAYS TO POSITIONS IN THIS COMMON BLOCK.  FOR THE DEFAULT
C  SETTINGS OF MAXOBV AND MAXPOP (2,048 AND 5,000), THE DATAPLOT EXECUTABLE
C  SHOULD BE REDUCED BY ABOUT 2 TO 2 1/2 MEGABYTES (ON A 4-BYTE PER WORD
C  MACHINE).  IF MAXOBV IS INCREASED TO 5,000, THE SAVINGS SHOULD BE
C  ABOUT 6 MEGABYTES.
C
C  NOTE THAT THESE ARE THE ONLY INCLUDE FILES THAT ARE NOT PLACED IN
C  THE MAIN ROUTINE.  NORMALLY, COMMON BLOCKS SHOULD BE PLACED IN THE MAIN
C  ROUTINE TO ENSURE THAT THEY GET LOADED IN THE "ROOT" SEGMENT ON SYSTEMS
C  THAT USE SEGMENTATION OR OVERLAYING.  THIS PREVENTS COMMON BLOCKS FROM
C  LOSING THEIR VALUES WHEN SEGMENTS ARE SWAPPED.   HOWEVER, SINCE THESE
C  COMMON BLOCKS ARE SIMPLY PROVIDING SCRATCH SPACE, THIS DOES NOT MATTER.
C  IN FACT, IT IS DESIRABLE TO HAVE THEM PLACED AS FAR DOWN THE SEGMENTATION
C  SCHEME AS POSSIBLE.
C
C  THE INCLUDE FILES "DPCOZI" AND "DPCOZD" PROVIDE SIMILAR SCRATCH SPACE
C  FOR INTEGER AND DOUBLE PRECISION ARRAYS.
C
C  THE FOLLOWING ROUTINES USE THE SCATCH SPACE:
C
C  A) MOST OF THE ROUTINES CALLED BY MAINAN AND MAINGR USE SCRATCH ARRAYS.
C     TYPICALLY, MOST USE BETWEEN ONE AND EIGHT ARRAYS DIMENSIONED TO MAXOBV.
C     SINCE THESE ROUTINES DO NOT DEPEND ON THE OLD VALUES IN THE TEMPORARY
C     ARRAYS, THERE SHOLD BE NO PROBLEM WITH CONFLICTING USE OF THE
C     SCRATCH SPACE.  ALSO, ONCE THE COORDINATES ARE CALCULATED BY A
C     MAINGR ROUTINE, THE SCRATCH SPACE CAN BE REUSED BY THE ACTUAL
C     GRAPHING ROUTINES.
C
C     THE FOLLOWING ROUTINES ARE THE ONLY ONES USING MORE THAN 8 ARRAYS.
C
C     1) DPYATE - THIS ROUTINE USES 17 REAL ARRAYS (AND 3 INTEGER ARRAYS)
C     2) DPFIT  - THIS ROUTINE USES 10 REAL ARRAYS.  IN ADDITION, IT USES
C        USES ONE ARRAY DIMENSIONED TO (MAXOBV,MAXCMF) WHERE MAXCMF IS THE
C        MAXIMUM NUMBER OF VARIABLES FOR A FIT (THE DEFAULT VALUE IS 35).
C        THIS MEANS FIT REQUIRES (10+MAXCMF)*MAXOBV WORDS OF SCRATCH SPACE
C        (OR 45*MAXOBV FOR THE DEFAULT VALUE OF MAXCMF).
C     3) DPDEXP - THIS ROUTINE USES 4 ARRAYS DIMENSIONED TO 10*MAXOBV FOR
C        A TOTAL OF 40*MAXOBV WORDS.  ALSO, FOR FUTURE DEVELOPMENT, ALLOW
C        FOR 5 ADDITIONAL ARRAYS (IT USES ONE NOW).  THIS REQUIRES 45*MAXOBV
C        WORDS OF SCRATCH SPACE.
C
C B) SOME OF THE MATHEMATICS ROUTINES UNDER  THE LET COMMAND ALSO USE SCRATCH
C    SPACE.  MORE CARE NEEDS TO BE TAKEN WITH THESE ROUTINES SINCE THEY CAN
C    POTENTIALLY BE CALLED BY ANALYSIS AND GRAPHICS COMMANDS.  TO AVOID
C    POSSIBLE STORAGE CONFLICTS, DPMATC AND DPSTAC SHOULD USE ARRAYS 1
C    THROUGH 10 (THESE ROUTINES EXECUTE THE MATH AND STAT COMMANDS UNDER
C    LET AND WILL NOT BE CALLED BY MAINGR AND MAINAN ROUTINES).  THE
C    UNDERLYING ROUTINES CAN USE 11 THROUGH 45.  FOR SAFETY, THEY USE 41
C    THROUGH 45.  THE ONLY EXCEPTION IS THE INTERP ROUTINE, WHICH NEEDS 17
C    ARRAYS.  IT USES 11 THROUGH 27.  HOWEVER, THIS ROUTINE WILL NOT BE
C    CALLED BY THE MAINGR OR MAINAN ROUTINES, SO THERE SHOULD NOT BE A
C    CONFLICT.  ALSO, DPYATE, DPFIT, AND DPDEXP WERE MANUALLY SEARCHED TO
C    ENSURE THAT THEY DO NOT CALL UNDERLYING LET ROUTINES THAT MIGHT CAUSE
C    A STORAGE CONFLICT.
C
C C) THE ROUTINES THAT DO THE ACTUAL PLOTTING ALSO USE SCRATCH ARRAYS.  THE
C    DISCRETE GRAPHICS ARE DONE BEFORE ANY OF THE CONTINUOUS GRAPHICS, SO
C    THAT SPACE CAN BE SAFELY REUSED.  THE PLOTGE ROUTINE (WHICH IS THE
C    ROUTINE THAT INITIATES THE ACTUAL PLOTTING ON CONTINUOUS DEVICES)
C    USES 12 ARRAYS DIMENSIONED TO MAXPOP.  THESE SHOULD NOT BE REUSED
C    UNTIL THE SPECIFIC GRAPH IS COMPLETED).  THE UNDERLYING GRAPHICS USE
C    AN ADDITIONAL 6 ARRAYS (ALTHOUGH IT MIGHT BE POSSIBLE TO OVERLAY SOME
C    OF THESE, IT SEEMS SAFER TO USE SEPARATE STORAGE).  IN SUMMARY, THE
C    ACTUAL GRAPHING ROUTINES REQUIRE 18*MAXPOP WORDS OF SCRATCH SPACE.
C
C IN SUMMARY, THE AMOUNT OF SCRATCH SPACE REQUIRED (IN WORDS) IS THE
C MAXIMUM OF THE FOLLOWING 3 NUMBERS.  THE VALUE OF IGARB0 SHOULD BE SET
C TO THIS.
C
C    45*MAXOBV
C    (10+MAXCMF)*MAXOBV
C    18*MAXPOP
C
C ALTHOUGH LOGICALLY A SINGLE COMMON BLOCK COULD BE USED, IT IS PROBABLY
C DESIRABLE TO REDUCE THE SIZE OF INDIVIDUAL COMMON BLOCKS BY SPLITTING
C THE COMMON BLOCK INTO SEVERAL SMALLER ONES.  HOWEVER, THE ABILITY TO
C DO THIS IS LIMITED BY THE FACT THAT THE FIT ROUTINE DIMENSIONS A SINGLE
C ARRAY TO MAXCMF*MAXOBV (I.E., 35 X 2048 BY DEFAULT) AND IT IS NOT LEGAL
C TO EQUIVALENCE A SINGLE ARRAY OVER MORE THAN ONE COMMON BLOCK.  THE
C COMMON BLOCK WILL BE SPLIT INTO 2 PARTS.  MOST OF THE ROUTINES WILL
C ONLY USE THE FIRST PART.  CURRENTLY, ONLY ABOUT A DOZEN ROUTINES NEED
C THE SECOND ONE.
C
C     INCLUDE FILE          SIZE
C     ============          ====
COLD  DPCOZZ                MAX OF 10*MAXOBV, 5*MAXPOP
CNEW  DPCOZZ                MAX OF 20*MAXOBV, 5*MAXPOP
C     DPCOZ2                MAX OF 35*MAXOBV, MAXCMF*MAXOBV, 13*MAXPOP
C
CCCCC THE FOLLOWING 2 LINES WERE COMMENTED OUT AUGUST 1990
CCCCC AND MOVED TO DPCOPA.INC     AUGUST 1990
CCCCC PARAMETER (IGARB0=5*MAXPOP)
CCCCC PARAMETER (IGARB0=10*MAXOBV)
C
      PARAMETER (IGARB1=1)
      PARAMETER (IGARB2=MAXOBV+1)
      PARAMETER (IGARB3=2*MAXOBV+1)
      PARAMETER (IGARB4=3*MAXOBV+1)
      PARAMETER (IGARB5=4*MAXOBV+1)
      PARAMETER (IGARB6=5*MAXOBV+1)
      PARAMETER (IGARB7=6*MAXOBV+1)
      PARAMETER (IGARB8=7*MAXOBV+1)
      PARAMETER (IGARB9=8*MAXOBV+1)
      PARAMETER (IGAR10=9*MAXOBV+1)
CCCCC MAY 1995.  FOLLOWING 10 LINES ADDED
      PARAMETER (JGAR11=10*MAXOBV+1)
      PARAMETER (JGAR12=11*MAXOBV+1)
      PARAMETER (JGAR13=12*MAXOBV+1)
      PARAMETER (JGAR14=13*MAXOBV+1)
      PARAMETER (JGAR15=14*MAXOBV+1)
      PARAMETER (JGAR16=15*MAXOBV+1)
      PARAMETER (JGAR17=16*MAXOBV+1)
      PARAMETER (JGAR18=17*MAXOBV+1)
      PARAMETER (JGAR19=18*MAXOBV+1)
      PARAMETER (JGAR20=19*MAXOBV+1)
C
      PARAMETER (IGARG1=1)
      PARAMETER (IGARG2=MAXPOP+1)
      PARAMETER (IGARG3=2*MAXPOP+1)
      PARAMETER (IGARG4=3*MAXPOP+1)
      PARAMETER (IGARG5=4*MAXPOP+1)
C
      REAL GARBAG
      COMMON/RGARB1/GARBAG(IGARB0)
C
