// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by aliasgen. DO NOT EDIT.

// Package privateca aliases all exported identifiers in package
// "cloud.google.com/go/security/privateca/apiv1beta1/privatecapb".
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb.
// Please read https://github.com/googleapis/google-cloud-go/blob/main/migration.md
// for more details.
package privateca

import (
	src "cloud.google.com/go/security/privateca/apiv1beta1/privatecapb"
	grpc "google.golang.org/grpc"
)

// Deprecated: Please use consts in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
const (
	CertificateAuthority_DEVOPS                          = src.CertificateAuthority_DEVOPS
	CertificateAuthority_DISABLED                        = src.CertificateAuthority_DISABLED
	CertificateAuthority_EC_P256_SHA256                  = src.CertificateAuthority_EC_P256_SHA256
	CertificateAuthority_EC_P384_SHA384                  = src.CertificateAuthority_EC_P384_SHA384
	CertificateAuthority_ENABLED                         = src.CertificateAuthority_ENABLED
	CertificateAuthority_ENTERPRISE                      = src.CertificateAuthority_ENTERPRISE
	CertificateAuthority_PENDING_ACTIVATION              = src.CertificateAuthority_PENDING_ACTIVATION
	CertificateAuthority_PENDING_DELETION                = src.CertificateAuthority_PENDING_DELETION
	CertificateAuthority_RSA_PKCS1_2048_SHA256           = src.CertificateAuthority_RSA_PKCS1_2048_SHA256
	CertificateAuthority_RSA_PKCS1_3072_SHA256           = src.CertificateAuthority_RSA_PKCS1_3072_SHA256
	CertificateAuthority_RSA_PKCS1_4096_SHA256           = src.CertificateAuthority_RSA_PKCS1_4096_SHA256
	CertificateAuthority_RSA_PSS_2048_SHA256             = src.CertificateAuthority_RSA_PSS_2048_SHA256
	CertificateAuthority_RSA_PSS_3072_SHA256             = src.CertificateAuthority_RSA_PSS_3072_SHA256
	CertificateAuthority_RSA_PSS_4096_SHA256             = src.CertificateAuthority_RSA_PSS_4096_SHA256
	CertificateAuthority_SELF_SIGNED                     = src.CertificateAuthority_SELF_SIGNED
	CertificateAuthority_SIGN_HASH_ALGORITHM_UNSPECIFIED = src.CertificateAuthority_SIGN_HASH_ALGORITHM_UNSPECIFIED
	CertificateAuthority_STATE_UNSPECIFIED               = src.CertificateAuthority_STATE_UNSPECIFIED
	CertificateAuthority_SUBORDINATE                     = src.CertificateAuthority_SUBORDINATE
	CertificateAuthority_TIER_UNSPECIFIED                = src.CertificateAuthority_TIER_UNSPECIFIED
	CertificateAuthority_TYPE_UNSPECIFIED                = src.CertificateAuthority_TYPE_UNSPECIFIED
	CertificateRevocationList_ACTIVE                     = src.CertificateRevocationList_ACTIVE
	CertificateRevocationList_STATE_UNSPECIFIED          = src.CertificateRevocationList_STATE_UNSPECIFIED
	CertificateRevocationList_SUPERSEDED                 = src.CertificateRevocationList_SUPERSEDED
	PublicKey_KEY_TYPE_UNSPECIFIED                       = src.PublicKey_KEY_TYPE_UNSPECIFIED
	PublicKey_PEM_EC_KEY                                 = src.PublicKey_PEM_EC_KEY
	PublicKey_PEM_RSA_KEY                                = src.PublicKey_PEM_RSA_KEY
	RevocationReason_AFFILIATION_CHANGED                 = src.RevocationReason_AFFILIATION_CHANGED
	RevocationReason_ATTRIBUTE_AUTHORITY_COMPROMISE      = src.RevocationReason_ATTRIBUTE_AUTHORITY_COMPROMISE
	RevocationReason_CERTIFICATE_AUTHORITY_COMPROMISE    = src.RevocationReason_CERTIFICATE_AUTHORITY_COMPROMISE
	RevocationReason_CERTIFICATE_HOLD                    = src.RevocationReason_CERTIFICATE_HOLD
	RevocationReason_CESSATION_OF_OPERATION              = src.RevocationReason_CESSATION_OF_OPERATION
	RevocationReason_KEY_COMPROMISE                      = src.RevocationReason_KEY_COMPROMISE
	RevocationReason_PRIVILEGE_WITHDRAWN                 = src.RevocationReason_PRIVILEGE_WITHDRAWN
	RevocationReason_REVOCATION_REASON_UNSPECIFIED       = src.RevocationReason_REVOCATION_REASON_UNSPECIFIED
	RevocationReason_SUPERSEDED                          = src.RevocationReason_SUPERSEDED
)

// Deprecated: Please use vars in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
var (
	CertificateAuthority_SignHashAlgorithm_name                  = src.CertificateAuthority_SignHashAlgorithm_name
	CertificateAuthority_SignHashAlgorithm_value                 = src.CertificateAuthority_SignHashAlgorithm_value
	CertificateAuthority_State_name                              = src.CertificateAuthority_State_name
	CertificateAuthority_State_value                             = src.CertificateAuthority_State_value
	CertificateAuthority_Tier_name                               = src.CertificateAuthority_Tier_name
	CertificateAuthority_Tier_value                              = src.CertificateAuthority_Tier_value
	CertificateAuthority_Type_name                               = src.CertificateAuthority_Type_name
	CertificateAuthority_Type_value                              = src.CertificateAuthority_Type_value
	CertificateRevocationList_State_name                         = src.CertificateRevocationList_State_name
	CertificateRevocationList_State_value                        = src.CertificateRevocationList_State_value
	File_google_cloud_security_privateca_v1beta1_resources_proto = src.File_google_cloud_security_privateca_v1beta1_resources_proto
	File_google_cloud_security_privateca_v1beta1_service_proto   = src.File_google_cloud_security_privateca_v1beta1_service_proto
	PublicKey_KeyType_name                                       = src.PublicKey_KeyType_name
	PublicKey_KeyType_value                                      = src.PublicKey_KeyType_value
	RevocationReason_name                                        = src.RevocationReason_name
	RevocationReason_value                                       = src.RevocationReason_value
)

// Request message for
// [CertificateAuthorityService.ActivateCertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthorityService.ActivateCertificateAuthority].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type ActivateCertificateAuthorityRequest = src.ActivateCertificateAuthorityRequest

// A [Certificate][google.cloud.security.privateca.v1beta1.Certificate]
// corresponds to a signed X.509 certificate issued by a
// [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type Certificate = src.Certificate

// A
// [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority]
// represents an individual Certificate Authority. A
// [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority]
// can be used to create
// [Certificates][google.cloud.security.privateca.v1beta1.Certificate].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type CertificateAuthority = src.CertificateAuthority

// CertificateAuthorityServiceClient is the client API for
// CertificateAuthorityService service. For semantics around ctx use and
// closing/ending streaming RPCs, please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type CertificateAuthorityServiceClient = src.CertificateAuthorityServiceClient

// CertificateAuthorityServiceServer is the server API for
// CertificateAuthorityService service.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type CertificateAuthorityServiceServer = src.CertificateAuthorityServiceServer

// URLs where a
// [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority]
// will publish content.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type CertificateAuthority_AccessUrls = src.CertificateAuthority_AccessUrls

// The issuing policy for a
// [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority].
// [Certificates][google.cloud.security.privateca.v1beta1.Certificate] will not
// be successfully issued from this
// [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority]
// if they violate the policy.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type CertificateAuthority_CertificateAuthorityPolicy = src.CertificateAuthority_CertificateAuthorityPolicy
type CertificateAuthority_CertificateAuthorityPolicy_AllowedConfigList = src.CertificateAuthority_CertificateAuthorityPolicy_AllowedConfigList
type CertificateAuthority_CertificateAuthorityPolicy_AllowedConfigList_ = src.CertificateAuthority_CertificateAuthorityPolicy_AllowedConfigList_

// [AllowedSubjectAltNames][google.cloud.security.privateca.v1beta1.CertificateAuthority.CertificateAuthorityPolicy.AllowedSubjectAltNames]
// specifies the allowed values for
// [SubjectAltNames][google.cloud.security.privateca.v1beta1.SubjectAltNames]
// by the
// [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority]
// when issuing
// [Certificates][google.cloud.security.privateca.v1beta1.Certificate].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type CertificateAuthority_CertificateAuthorityPolicy_AllowedSubjectAltNames = src.CertificateAuthority_CertificateAuthorityPolicy_AllowedSubjectAltNames

// [IssuanceModes][google.cloud.security.privateca.v1beta1.CertificateAuthority.CertificateAuthorityPolicy.IssuanceModes]
// specifies the allowed ways in which
// [Certificates][google.cloud.security.privateca.v1beta1.Certificate] may be
// requested from this
// [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type CertificateAuthority_CertificateAuthorityPolicy_IssuanceModes = src.CertificateAuthority_CertificateAuthorityPolicy_IssuanceModes
type CertificateAuthority_CertificateAuthorityPolicy_OverwriteConfigValues = src.CertificateAuthority_CertificateAuthorityPolicy_OverwriteConfigValues

// Options that affect all certificates issued by a
// [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type CertificateAuthority_IssuingOptions = src.CertificateAuthority_IssuingOptions

// A Cloud KMS key configuration that a
// [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority]
// will use.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type CertificateAuthority_KeyVersionSpec = src.CertificateAuthority_KeyVersionSpec
type CertificateAuthority_KeyVersionSpec_Algorithm = src.CertificateAuthority_KeyVersionSpec_Algorithm
type CertificateAuthority_KeyVersionSpec_CloudKmsKeyVersion = src.CertificateAuthority_KeyVersionSpec_CloudKmsKeyVersion

// The algorithm of a Cloud KMS CryptoKeyVersion of a
// [CryptoKey][google.cloud.kms.v1.CryptoKey] with the
// [CryptoKeyPurpose][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose] value
// `ASYMMETRIC_SIGN`. These values correspond to the
// [CryptoKeyVersionAlgorithm][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm]
// values. For RSA signing algorithms, the PSS algorithms should be preferred,
// use PKCS1 algorithms if required for compatibility. For further
// recommandations, see
// https://cloud.google.com/kms/docs/algorithms#algorithm_recommendations.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type CertificateAuthority_SignHashAlgorithm = src.CertificateAuthority_SignHashAlgorithm

// The state of a
// [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority],
// indicating if it can be used.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type CertificateAuthority_State = src.CertificateAuthority_State

// The tier of a
// [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority],
// indicating its supported functionality and/or billing SKU.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type CertificateAuthority_Tier = src.CertificateAuthority_Tier

// The type of a
// [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority],
// indicating its issuing chain.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type CertificateAuthority_Type = src.CertificateAuthority_Type

// A
// [CertificateConfig][google.cloud.security.privateca.v1beta1.CertificateConfig]
// describes an X.509 certificate or CSR that is to be created, as an
// alternative to using ASN.1.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type CertificateConfig = src.CertificateConfig

// These values are used to create the distinguished name and subject
// alternative name fields in an X.509 certificate.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type CertificateConfig_SubjectConfig = src.CertificateConfig_SubjectConfig

// A
// [CertificateDescription][google.cloud.security.privateca.v1beta1.CertificateDescription]
// describes an X.509 certificate or CSR that has been issued, as an
// alternative to using ASN.1 / X.509.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type CertificateDescription = src.CertificateDescription

// A group of fingerprints for the x509 certificate.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type CertificateDescription_CertificateFingerprint = src.CertificateDescription_CertificateFingerprint

// A KeyId identifies a specific public key, usually by hashing the public
// key.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type CertificateDescription_KeyId = src.CertificateDescription_KeyId

// These values describe fields in an issued X.509 certificate such as the
// distinguished name, subject alternative names, serial number, and lifetime.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type CertificateDescription_SubjectDescription = src.CertificateDescription_SubjectDescription

// A
// [CertificateRevocationList][google.cloud.security.privateca.v1beta1.CertificateRevocationList]
// corresponds to a signed X.509 certificate Revocation List (CRL). A CRL
// contains the serial numbers of certificates that should no longer be
// trusted.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type CertificateRevocationList = src.CertificateRevocationList

// Describes a revoked
// [Certificate][google.cloud.security.privateca.v1beta1.Certificate].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type CertificateRevocationList_RevokedCertificate = src.CertificateRevocationList_RevokedCertificate

// The state of a
// [CertificateRevocationList][google.cloud.security.privateca.v1beta1.CertificateRevocationList],
// indicating if it is current.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type CertificateRevocationList_State = src.CertificateRevocationList_State
type Certificate_Config = src.Certificate_Config
type Certificate_PemCsr = src.Certificate_PemCsr

// Describes fields that are relavent to the revocation of a
// [Certificate][google.cloud.security.privateca.v1beta1.Certificate].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type Certificate_RevocationDetails = src.Certificate_RevocationDetails

// Request message for
// [CertificateAuthorityService.CreateCertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthorityService.CreateCertificateAuthority].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type CreateCertificateAuthorityRequest = src.CreateCertificateAuthorityRequest

// Request message for
// [CertificateAuthorityService.CreateCertificate][google.cloud.security.privateca.v1beta1.CertificateAuthorityService.CreateCertificate].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type CreateCertificateRequest = src.CreateCertificateRequest

// Request message for
// [CertificateAuthorityService.DisableCertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthorityService.DisableCertificateAuthority].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type DisableCertificateAuthorityRequest = src.DisableCertificateAuthorityRequest

// Request message for
// [CertificateAuthorityService.EnableCertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthorityService.EnableCertificateAuthority].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type EnableCertificateAuthorityRequest = src.EnableCertificateAuthorityRequest

// Request message for
// [CertificateAuthorityService.FetchCertificateAuthorityCsr][google.cloud.security.privateca.v1beta1.CertificateAuthorityService.FetchCertificateAuthorityCsr].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type FetchCertificateAuthorityCsrRequest = src.FetchCertificateAuthorityCsrRequest

// Response message for
// [CertificateAuthorityService.FetchCertificateAuthorityCsr][google.cloud.security.privateca.v1beta1.CertificateAuthorityService.FetchCertificateAuthorityCsr].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type FetchCertificateAuthorityCsrResponse = src.FetchCertificateAuthorityCsrResponse

// Request message for
// [CertificateAuthorityService.GetCertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthorityService.GetCertificateAuthority].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type GetCertificateAuthorityRequest = src.GetCertificateAuthorityRequest

// Request message for
// [CertificateAuthorityService.GetCertificate][google.cloud.security.privateca.v1beta1.CertificateAuthorityService.GetCertificate].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type GetCertificateRequest = src.GetCertificateRequest

// Request message for
// [CertificateAuthorityService.GetCertificateRevocationList][google.cloud.security.privateca.v1beta1.CertificateAuthorityService.GetCertificateRevocationList].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type GetCertificateRevocationListRequest = src.GetCertificateRevocationListRequest

// Request message for
// [CertificateAuthorityService.GetReusableConfig][google.cloud.security.privateca.v1beta1.CertificateAuthorityService.GetReusableConfig].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type GetReusableConfigRequest = src.GetReusableConfigRequest

// A [KeyUsage][google.cloud.security.privateca.v1beta1.KeyUsage] describes
// key usage values that may appear in an X.509 certificate.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type KeyUsage = src.KeyUsage

// [KeyUsage.ExtendedKeyUsageOptions][google.cloud.security.privateca.v1beta1.KeyUsage.ExtendedKeyUsageOptions]
// has fields that correspond to certain common OIDs that could be specified
// as an extended key usage value.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type KeyUsage_ExtendedKeyUsageOptions = src.KeyUsage_ExtendedKeyUsageOptions

// [KeyUsage.KeyUsageOptions][google.cloud.security.privateca.v1beta1.KeyUsage.KeyUsageOptions]
// corresponds to the key usage values described in
// https://tools.ietf.org/html/rfc5280#section-4.2.1.3.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type KeyUsage_KeyUsageOptions = src.KeyUsage_KeyUsageOptions

// Request message for
// [CertificateAuthorityService.ListCertificateAuthorities][google.cloud.security.privateca.v1beta1.CertificateAuthorityService.ListCertificateAuthorities].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type ListCertificateAuthoritiesRequest = src.ListCertificateAuthoritiesRequest

// Response message for
// [CertificateAuthorityService.ListCertificateAuthorities][google.cloud.security.privateca.v1beta1.CertificateAuthorityService.ListCertificateAuthorities].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type ListCertificateAuthoritiesResponse = src.ListCertificateAuthoritiesResponse

// Request message for
// [CertificateAuthorityService.ListCertificateRevocationLists][google.cloud.security.privateca.v1beta1.CertificateAuthorityService.ListCertificateRevocationLists].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type ListCertificateRevocationListsRequest = src.ListCertificateRevocationListsRequest

// Response message for
// [CertificateAuthorityService.ListCertificateRevocationLists][google.cloud.security.privateca.v1beta1.CertificateAuthorityService.ListCertificateRevocationLists].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type ListCertificateRevocationListsResponse = src.ListCertificateRevocationListsResponse

// Request message for
// [CertificateAuthorityService.ListCertificates][google.cloud.security.privateca.v1beta1.CertificateAuthorityService.ListCertificates].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type ListCertificatesRequest = src.ListCertificatesRequest

// Response message for
// [CertificateAuthorityService.ListCertificates][google.cloud.security.privateca.v1beta1.CertificateAuthorityService.ListCertificates].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type ListCertificatesResponse = src.ListCertificatesResponse

// Request message for
// [CertificateAuthorityService.ListReusableConfigs][google.cloud.security.privateca.v1beta1.CertificateAuthorityService.ListReusableConfigs].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type ListReusableConfigsRequest = src.ListReusableConfigsRequest

// Response message for
// [CertificateAuthorityService.ListReusableConfigs][google.cloud.security.privateca.v1beta1.CertificateAuthorityService.ListReusableConfigs].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type ListReusableConfigsResponse = src.ListReusableConfigsResponse

// An [ObjectId][google.cloud.security.privateca.v1beta1.ObjectId] specifies
// an object identifier (OID). These provide context and describe types in
// ASN.1 messages.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type ObjectId = src.ObjectId

// Represents the metadata of the long-running operation.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type OperationMetadata = src.OperationMetadata

// A [PublicKey][google.cloud.security.privateca.v1beta1.PublicKey] describes
// a public key.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type PublicKey = src.PublicKey

// Types of public keys that are supported. At a minimum, we support RSA and
// ECDSA, for the key sizes or curves listed:
// https://cloud.google.com/kms/docs/algorithms#asymmetric_signing_algorithms
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type PublicKey_KeyType = src.PublicKey_KeyType

// Request message for
// [CertificateAuthorityService.RestoreCertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthorityService.RestoreCertificateAuthority].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type RestoreCertificateAuthorityRequest = src.RestoreCertificateAuthorityRequest

// A [ReusableConfig][google.cloud.security.privateca.v1beta1.ReusableConfig]
// refers to a managed
// [ReusableConfigValues][google.cloud.security.privateca.v1beta1.ReusableConfigValues].
// Those, in turn, are used to describe certain fields of an X.509 certificate,
// such as the key usage fields, fields specific to CA certificates,
// certificate policy extensions and custom extensions.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type ReusableConfig = src.ReusableConfig

// A
// [ReusableConfigValues][google.cloud.security.privateca.v1beta1.ReusableConfigValues]
// is used to describe certain fields of an X.509 certificate, such as the key
// usage fields, fields specific to CA certificates, certificate policy
// extensions and custom extensions.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type ReusableConfigValues = src.ReusableConfigValues

// Describes values that are relevant in a CA certificate.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type ReusableConfigValues_CaOptions = src.ReusableConfigValues_CaOptions

// A
// [ReusableConfigWrapper][google.cloud.security.privateca.v1beta1.ReusableConfigWrapper]
// describes values that may assist in creating an X.509 certificate, or a
// reference to a pre-defined set of values.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type ReusableConfigWrapper = src.ReusableConfigWrapper
type ReusableConfigWrapper_ReusableConfig = src.ReusableConfigWrapper_ReusableConfig
type ReusableConfigWrapper_ReusableConfigValues = src.ReusableConfigWrapper_ReusableConfigValues

// A
// [RevocationReason][google.cloud.security.privateca.v1beta1.RevocationReason]
// indicates whether a
// [Certificate][google.cloud.security.privateca.v1beta1.Certificate] has been
// revoked, and the reason for revocation. These correspond to standard
// revocation reasons from RFC 5280. Note that the enum labels and values in
// this definition are not the same ASN.1 values defined in RFC 5280. These
// values will be translated to the correct ASN.1 values when a CRL is created.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type RevocationReason = src.RevocationReason

// Request message for
// [CertificateAuthorityService.RevokeCertificate][google.cloud.security.privateca.v1beta1.CertificateAuthorityService.RevokeCertificate].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type RevokeCertificateRequest = src.RevokeCertificateRequest

// Request message for
// [CertificateAuthorityService.ScheduleDeleteCertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthorityService.ScheduleDeleteCertificateAuthority].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type ScheduleDeleteCertificateAuthorityRequest = src.ScheduleDeleteCertificateAuthorityRequest

// [Subject][google.cloud.security.privateca.v1beta1.Subject] describes parts
// of a distinguished name that, in turn, describes the subject of the
// certificate.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type Subject = src.Subject

// [SubjectAltNames][google.cloud.security.privateca.v1beta1.SubjectAltNames]
// corresponds to a more modern way of listing what the asserted identity is in
// a certificate (i.e., compared to the "common name" in the distinguished
// name).
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type SubjectAltNames = src.SubjectAltNames

// Describes a subordinate CA's issuers. This is either a resource path to a
// known issuing
// [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority],
// or a PEM issuer certificate chain.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type SubordinateConfig = src.SubordinateConfig
type SubordinateConfig_CertificateAuthority = src.SubordinateConfig_CertificateAuthority
type SubordinateConfig_PemIssuerChain = src.SubordinateConfig_PemIssuerChain

// This message describes a subordinate CA's issuer certificate chain. This
// wrapper exists for compatibility reasons.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type SubordinateConfig_SubordinateConfigChain = src.SubordinateConfig_SubordinateConfigChain

// UnimplementedCertificateAuthorityServiceServer can be embedded to have
// forward compatible implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type UnimplementedCertificateAuthorityServiceServer = src.UnimplementedCertificateAuthorityServiceServer

// Request message for
// [CertificateAuthorityService.UpdateCertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthorityService.UpdateCertificateAuthority].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type UpdateCertificateAuthorityRequest = src.UpdateCertificateAuthorityRequest

// Request message for
// [CertificateAuthorityService.UpdateCertificate][google.cloud.security.privateca.v1beta1.CertificateAuthorityService.UpdateCertificate].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type UpdateCertificateRequest = src.UpdateCertificateRequest

// Request message for
// [CertificateAuthorityService.UpdateCertificateRevocationList][google.cloud.security.privateca.v1beta1.CertificateAuthorityService.UpdateCertificateRevocationList].
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type UpdateCertificateRevocationListRequest = src.UpdateCertificateRevocationListRequest

// An [X509Extension][google.cloud.security.privateca.v1beta1.X509Extension]
// specifies an X.509 extension, which may be used in different parts of X.509
// objects like certificates, CSRs, and CRLs.
//
// Deprecated: Please use types in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
type X509Extension = src.X509Extension

// Deprecated: Please use funcs in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
func NewCertificateAuthorityServiceClient(cc grpc.ClientConnInterface) CertificateAuthorityServiceClient {
	return src.NewCertificateAuthorityServiceClient(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/security/privateca/apiv1beta1/privatecapb
func RegisterCertificateAuthorityServiceServer(s *grpc.Server, srv CertificateAuthorityServiceServer) {
	src.RegisterCertificateAuthorityServiceServer(s, srv)
}
