/*
 * Copyright (c) 1999-2001,2003-2004,2008,2010,2012 Apple Inc. All Rights Reserved.
 * 
 * @APPLE_LICENSE_HEADER_START@
 * 
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this
 * file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 *
 * oidsattr.h -- Cert/CRL related OIDs.
 */

#include <Security/SecAsn1Types.h>
#include <Security/oidsbase.h>

#ifndef	_CDSA_OIDSATTR_H_
#define _CDSA_OIDSATTR_H_

/* 
 * Directory name component identifiers.
 */
extern const SecAsn1Oid
    CSSMOID_ObjectClass DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_AliasedEntryName DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_KnowledgeInformation DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_CommonName DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_Surname DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_SerialNumber DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_CountryName DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_LocalityName DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_StateProvinceName DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_CollectiveStateProvinceName DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_StreetAddress DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_CollectiveStreetAddress DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_OrganizationName DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_CollectiveOrganizationName DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_OrganizationalUnitName DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_CollectiveOrganizationalUnitName DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_Title DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_Description DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_SearchGuide DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_BusinessCategory DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_PostalAddress DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_CollectivePostalAddress DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_PostalCode DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_CollectivePostalCode DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_PostOfficeBox DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_CollectivePostOfficeBox DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_PhysicalDeliveryOfficeName DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,  
    CSSMOID_CollectivePhysicalDeliveryOfficeName DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_TelephoneNumber DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_CollectiveTelephoneNumber DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,   
    CSSMOID_TelexNumber DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_CollectiveTelexNumber DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_TelexTerminalIdentifier DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_CollectiveTelexTerminalIdentifier DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_FacsimileTelephoneNumber DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_CollectiveFacsimileTelephoneNumber DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_X_121Address DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_InternationalISDNNumber DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_CollectiveInternationalISDNNumber DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_RegisteredAddress DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_DestinationIndicator DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_PreferredDeliveryMethod DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_PresentationAddress DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_SupportedApplicationContext DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_Member DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_Owner DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_RoleOccupant DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_SeeAlso DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_UserPassword DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_UserCertificate DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_CACertificate DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_AuthorityRevocationList DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_CertificateRevocationList DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_CrossCertificatePair DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_Name DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_GivenName DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_Initials DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_GenerationQualifier DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_UniqueIdentifier DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_DNQualifier DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_EnhancedSearchGuide DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_ProtocolInformation DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_DistinguishedName DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_UniqueMember DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_HouseIdentifier DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER;
	
/* PKCS 9 */
extern const SecAsn1Oid
    CSSMOID_EmailAddress DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_UnstructuredName DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_ContentType DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_MessageDigest DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_SigningTime DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_CounterSignature DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_ChallengePassword DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_UnstructuredAddress DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_ExtendedCertificateAttributes DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER;

extern const SecAsn1Oid
    CSSMOID_PKCS9_Id_Ct_TSTInfo DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
    CSSMOID_PKCS9_TimeStampToken DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER;

/* PKIX */
extern const SecAsn1Oid
    CSSMOID_QT_CPS DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_QT_UNOTICE DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_AD_OCSP DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_AD_CA_ISSUERS DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_AD_TIME_STAMPING DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_AD_CA_REPOSITORY DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_PDA_DATE_OF_BIRTH DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_PDA_PLACE_OF_BIRTH DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_PDA_GENDER DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_PDA_COUNTRY_CITIZEN DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_PDA_COUNTRY_RESIDENCE DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_OID_QCS_SYNTAX_V1 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_OID_QCS_SYNTAX_V2 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER;

/* ETSI */
extern const SecAsn1Oid
    CSSMOID_ETSI_QCS_QC_COMPLIANCE DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_ETSI_QCS_QC_LIMIT_VALUE DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_ETSI_QCS_QC_RETENTION DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_ETSI_QCS_QC_SSCD DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER;

/* PKCS7 */
extern const SecAsn1Oid
    CSSMOID_PKCS7_Data DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_PKCS7_SignedData DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_PKCS7_EnvelopedData DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_PKCS7_SignedAndEnvelopedData DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_PKCS7_DigestedData DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_PKCS7_EncryptedData DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_PKCS7_DataWithAttributes DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_PKCS7_EncryptedPrivateKeyInfo DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 

/* PKCS8 */
    CSSMOID_PKCS9_FriendlyName DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_PKCS9_LocalKeyId DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_PKCS9_CertTypes DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_PKCS9_CrlTypes DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_PKCS9_X509Certificate DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_PKCS9_SdsiCertificate DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_PKCS9_X509Crl DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 

/* PKCS12 */
    CSSMOID_PKCS12_keyBag DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_PKCS12_shroudedKeyBag DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_PKCS12_certBag DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_PKCS12_crlBag DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_PKCS12_secretBag DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_PKCS12_safeContentsBag DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	
/* RFC 2798 (LDAP) */
	CSSMOID_UserID DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 

/* RFC 1275 (X.500) */
	CSSMOID_DomainComponent DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	
/* Kerberos PKINIT CMS ContentInfo types */
    CSSMOID_KERBv5_PKINIT_AUTH_DATA DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_KERBv5_PKINIT_DH_KEY_DATA DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
    CSSMOID_KERBv5_PKINIT_RKEY_DATA DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER;

/* Elliptic Curve OIDs from X9.62 and Certicom SEC 2 */
extern const SecAsn1Oid
	CSSMOID_X9_62 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_X9_62_FieldType DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_X9_62_PubKeyType DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_X9_62_EllCurve DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_X9_62_C_TwoCurve DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_X9_62_PrimeCurve DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_X9_62_SigType DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_secp192r1 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_secp256r1 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_Certicom DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_CerticomEllCurve DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_secp112r1 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_secp112r2 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_secp128r1 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_secp128r2 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_secp160k1 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_secp160r1 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_secp160r2 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_secp192k1 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_secp224k1 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_secp224r1 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_secp256k1 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_secp384r1 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_secp521r1 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_sect113r1 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_sect113r2 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_sect131r1 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_sect131r2 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_sect163k1 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_sect163r1 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_sect163r2 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_sect193r1 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_sect193r2 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_sect233k1 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_sect233r1 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_sect239k1 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_sect283k1 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_sect283r1 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_sect409k1 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_sect409r1 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_sect571k1 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_sect571r1 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER;

#endif	/* _CDSA_OIDSATTR_H_*/
