#ifndef _TMP36_h
#define _TMP36_h

#include "Arduino.h"

class TMP36 {
public:  
  enum Tmp36Modes {
    Exact = 0,
    HalfDegrees = 1,
    Integer = 2
  };

  enum ReferenceVoltages {
    ReferenceVoltage11 = 1,
    ReferenceVoltage33 = 3,
    ReferenceVoltage50 = 5
  };

  TMP36(byte sensorPin, ReferenceVoltages referenceVolatage, Tmp36Modes mode = TMP36::Exact, int readings = 1);
  float ReadTemperature();

private:
  byte m_SensorPin;
  int m_Readings;
  float m_ReferenceVoltage;
  Tmp36Modes m_Mode;
  float InternalRead();
  
};


#endif

