#include "PowerSave.h"
#include <avr/wdt.h>
#include <avr/sleep.h>
#include <avr/power.h>

ISR(WDT_vect) {
  wdt_disable();
  wdt_reset();
  WDTCSR &= ~_BV(WDIE);
}

void PowerSaveClass::Sleep(unsigned long milliseconds) {
  while (milliseconds >= 8000) { InternalSleep(WDTO_8S); milliseconds -= 8000; }
  if (milliseconds >= 4000)    { InternalSleep(WDTO_4S); milliseconds -= 4000; }
  if (milliseconds >= 2000)    { InternalSleep(WDTO_2S); milliseconds -= 2000; }
  if (milliseconds >= 1000)    { InternalSleep(WDTO_1S); milliseconds -= 1000; }
  if (milliseconds >= 500)     { InternalSleep(WDTO_500MS); milliseconds -= 500; }
  if (milliseconds >= 250)     { InternalSleep(WDTO_250MS); milliseconds -= 250; }
  if (milliseconds >= 125)     { InternalSleep(WDTO_120MS); milliseconds -= 120; }
  if (milliseconds >= 64)      { InternalSleep(WDTO_60MS); milliseconds -= 60; }
  if (milliseconds >= 32)      { InternalSleep(WDTO_30MS); milliseconds -= 30; }
  if (milliseconds >= 16)      { InternalSleep(WDTO_15MS); milliseconds -= 15; }
}

#ifndef sleep_bod_disable() 
#define sleep_bod_disable() \
  do { \
  uint8_t tempreg; \
  __asm__ __volatile__("in %[tempreg], %[mcucr]" "\n\t" \
  "ori %[tempreg], %[bods_bodse]" "\n\t" \
  "out %[mcucr], %[tempreg]" "\n\t" \
  "andi %[tempreg], %[not_bodse]" "\n\t" \
  "out %[mcucr], %[tempreg]" \
  : [tempreg] "=&d" (tempreg) \
  : [mcucr] "I" _SFR_IO_ADDR(MCUCR), \
  [bods_bodse] "i" (_BV(BODS) | _BV(BODSE)), \
  [not_bodse] "i" (~_BV(BODSE))); \
  } while (0)
#endif

#define adc_disable()  (ADCSRA &= ~(1<<ADEN)) // disable ADC
#define adc_enable()   (ADCSRA |=  (1<<ADEN)) // enable ADC
#define ac_disable()   (ACSR   |=  (1<<ACD )) // disable analog comparator
#define ac_enable()    (ACSR   &= ~(1<<ACD )) // enable analog comparator

void PowerSaveClass::InternalSleep(byte duration) {
  wdt_enable(duration);
  wdt_reset();
  WDTCSR |= _BV(WDIE);

  ac_disable();
  adc_disable();
  power_all_disable();
  
  set_sleep_mode(SLEEP_MODE_PWR_DOWN);
  sleep_enable();
  sleep_bod_disable();
  sleep_cpu();

  // After the sleep time is passed, we continue here
  sleep_disable(); 
  power_all_enable();
  adc_enable();
  ac_enable();
}


PowerSaveClass PowerSave;
