#include "HC_SR04.h"

HC_SR04::HC_SR04(byte triggerPin, byte echoPin) {
  m_TriggerPin = triggerPin;
  m_EchoPin = echoPin;

  pinMode(m_TriggerPin, OUTPUT);
  pinMode(m_EchoPin, INPUT);

  digitalWrite(m_TriggerPin, LOW);
}

float HC_SR04::ReadDistance(float temperature) {
  // Speed of sound in cm/us
  float speedOfSound = (331.5 + 0.6 * temperature) / 10000.0;
  
  // Trigger the measurement
  digitalWrite(m_TriggerPin, HIGH);
  delayMicroseconds(20);
  digitalWrite(m_TriggerPin, LOW);

  // Calculate
  unsigned long duration = pulseIn(m_EchoPin, HIGH);
  float distance = (duration / 2.0) * speedOfSound;
  distance = round(distance * 2.0) / 2.0;

  if (distance >= 400.0 || distance <= 0.0){
    distance = -1.0;
  }


  return distance;
}
