#ifndef VANTAGE_h
#define VANTAGE_h

#include <Arduino.h>            //assumes Arduino IDE v1.0 or greater

//#define _DEBUG 				1	// enable debug per compile

// Davis specific
#define DAVIS_PACKET_LEN     10 // ISS has fixed packet lengths of eight bytes, including CRC and trailing repeater info
#define SPI_CS               SS // SS is the SPI slave select pin, for instance D10 on atmega328
#define RF69_IRQ_PIN          2 // INT0 on AVRs should be connected to DIO0 (ex on Atmega328 it's D2)
#define CSMA_LIMIT          -90 // upper RX signal sensitivity threshold in dBm for carrier sense access

#define RF69_MODE_SLEEP       0 // XTAL OFF
#define RF69_MODE_STANDBY     1 // XTAL ON
#define RF69_MODE_SYNTH       2 // PLL ON
#define RF69_MODE_RX          3 // RX MODE
#define RF69_MODE_TX          4 // TX MODE

// added these here because upstream removed them
#define REG_TESTAFC        0x71

#define RF_FDEVMSB_9900    0x00
#define RF_FDEVLSB_9900    0xa1

#define RF_AFCLOWBETA_ON   0x20
#define RF_AFCLOWBETA_OFF  0x00 // Default
// <- Davis specific

#define FREQ_TABLE_LENGTH_US 51
#define FREQ_TABLE_LENGTH_AU 51
#define FREQ_TABLE_LENGTH_EU 5

#define FREQ_BAND_US 0
#define FREQ_BAND_AU 1
#define FREQ_BAND_EU 2

typedef uint8_t FRF_ITEM[3];

static const __attribute__((progmem)) FRF_ITEM FRF_US[FREQ_TABLE_LENGTH_US] =
{
  {0xE3, 0xDA, 0x7C},
  {0xE1, 0x98, 0x71},
  {0xE3, 0xFA, 0x92},
  {0xE6, 0xBD, 0x01},
  {0xE4, 0xBB, 0x4D},
  {0xE2, 0x99, 0x56},
  {0xE7, 0x7D, 0xBC},
  {0xE5, 0x9C, 0x0E},
  {0xE3, 0x39, 0xE6},
  {0xE6, 0x1C, 0x81},
  {0xE4, 0x5A, 0xE8},
  {0xE1, 0xF8, 0xD6},
  {0xE5, 0x3B, 0xBF},
  {0xE7, 0x1D, 0x5F},
  {0xE3, 0x9A, 0x3C},
  {0xE2, 0x39, 0x00},
  {0xE4, 0xFB, 0x77},
  {0xE6, 0x5C, 0xB2},
  {0xE2, 0xD9, 0x90},
  {0xE7, 0xBD, 0xEE},
  {0xE4, 0x3A, 0xD2},
  {0xE1, 0xD8, 0xAA},
  {0xE5, 0x5B, 0xCD},
  {0xE6, 0xDD, 0x34},
  {0xE3, 0x5A, 0x0A},
  {0xE7, 0x9D, 0xD9},
  {0xE2, 0x79, 0x41},
  {0xE4, 0x9B, 0x28},
  {0xE5, 0xDC, 0x40},
  {0xE7, 0x3D, 0x74},
  {0xE1, 0xB8, 0x9C},
  {0xE3, 0xBA, 0x60},
  {0xE6, 0x7C, 0xC8},
  {0xE4, 0xDB, 0x62},
  {0xE2, 0xB9, 0x7A},
  {0xE5, 0x7B, 0xE2},
  {0xE7, 0xDE, 0x12},
  {0xE6, 0x3C, 0x9D},
  {0xE3, 0x19, 0xC9},
  {0xE4, 0x1A, 0xB6},
  {0xE5, 0xBC, 0x2B},
  {0xE2, 0x18, 0xEB},
  {0xE6, 0xFD, 0x42},
  {0xE5, 0x1B, 0xA3},
  {0xE3, 0x7A, 0x2E},
  {0xE5, 0xFC, 0x64},
  {0xE2, 0x59, 0x16},
  {0xE6, 0x9C, 0xEC},
  {0xE2, 0xF9, 0xAC},
  {0xE4, 0x7B, 0x0C},
  {0xE7, 0x5D, 0x98}
};

static const __attribute__((progmem)) FRF_ITEM FRF_AU[FREQ_TABLE_LENGTH_AU] =
{
   {0xE5, 0x84, 0xDD},
   {0xE6, 0x43, 0x43},
   {0xE7, 0x1F, 0xCE},
   {0xE6, 0x7F, 0x7C},
   {0xE5, 0xD5, 0x0E},
   {0xE7, 0x5B, 0xF7},
   {0xE6, 0xC5, 0x81},
   {0xE6, 0x07, 0x2B},
   {0xE6, 0xED, 0xA1},
   {0xE6, 0x61, 0x58},
   {0xE5, 0xA3, 0x02},
   {0xE6, 0xA7, 0x8D},
   {0xE7, 0x3D, 0xB2},
   {0xE6, 0x25, 0x3F},
   {0xE5, 0xB7, 0x0A},
   {0xE6, 0x93, 0x85},
   {0xE7, 0x01, 0xDB},
   {0xE5, 0xE9, 0x26},
   {0xE7, 0x70, 0x00},
   {0xE6, 0x57, 0x6C},
   {0xE5, 0x98, 0xF5},
   {0xE6, 0xB1, 0x99},
   {0xE7, 0x29, 0xDB},
   {0xE6, 0x11, 0x37},
   {0xE7, 0x65, 0xE3},
   {0xE5, 0xCB, 0x33},
   {0xE6, 0x75, 0x60},
   {0xE6, 0xD9, 0xA9},
   {0xE7, 0x47, 0xDF},
   {0xE5, 0x8E, 0xF9},
   {0xE6, 0x2F, 0x4B},
   {0xE7, 0x0B, 0xB6},
   {0xE6, 0x89, 0x68},
   {0xE5, 0xDF, 0x2B},
   {0xE6, 0xBB, 0xA5},
   {0xE7, 0x79, 0xFB},
   {0xE6, 0xF7, 0xAE},
   {0xE5, 0xFD, 0x2F},
   {0xE6, 0x4D, 0x4F},
   {0xE6, 0xCF, 0x8D},
   {0xE5, 0xAD, 0x0E},
   {0xE7, 0x33, 0xD7},
   {0xE6, 0x9D, 0x91},
   {0xE6, 0x1B, 0x33},
   {0xE6, 0xE3, 0xA5},
   {0xE5, 0xC1, 0x16},
   {0xE7, 0x15, 0xC2},
   {0xE5, 0xF3, 0x33},
   {0xE6, 0x6B, 0x64},
   {0xE7, 0x51, 0xDB},
   {0xE6, 0x39, 0x58}
};

static const __attribute__((progmem)) FRF_ITEM FRF_EU[FREQ_TABLE_LENGTH_EU] =
{
  {0xD9, 0x04, 0x45},
  {0xD9, 0x13, 0x04},
  {0xD9, 0x21, 0xC2},
  {0xD9, 0x0B, 0xA4},
  {0xD9, 0x1A, 0x63}
};

static const FRF_ITEM *bandTab[3] = {
  FRF_US,
  FRF_AU,
  FRF_EU
};

static const uint8_t bandTabLengths[3] = {
  FREQ_TABLE_LENGTH_US,
  FREQ_TABLE_LENGTH_AU,
  FREQ_TABLE_LENGTH_EU
};

// Station data structure for managing radio reception
typedef struct __attribute__((packed)) Station {
  byte id;                // station ID (set with the DIP switch on original equipment)
                          // set it ONE LESS than advertised station id, eg. 0 for station 1 (default) etc.
  byte type;              // STYPE_XXX station type, eg. ISS, standalone anemometer transmitter, etc.
  bool active;            // true when the station is actively listened to but ignored
                          // MUST be used when multiple stations are transmitting but only one is needed
  byte repeaterId;        // repeater id when packet is coming via a repeater, otherwise 0
                          // repeater IDs A..H are stored as 0x8..0xf here
  byte channel;           // rx channel the next packet of the station is expected on
  unsigned long lastRx;   // last time a packet is seen or should have been seen when missed
  unsigned long interval; // packet transmit interval for the station: (41 + id) / 16 * 1M ) microsecs
  byte lostPackets;       // missed packets since a packet was last seen from this station
};

// Davis VP2 standalone station types
#define STYPE_ISS         0x0 // ISS
#define STYPE_TEMP_ONLY   0x1 // Temperature Only Station
#define STYPE_HUM_ONLY    0x2 // Humidity Only Station
#define STYPE_TEMP_HUM    0x3 // Temperature/Humidity Station
#define STYPE_WLESS_ANEMO 0x4 // Wireless Anemometer Station
#define STYPE_RAIN        0x5 // Rain Station
#define STYPE_LEAF        0x6 // Leaf Station
#define STYPE_SOIL        0x7 // Soil Station
#define STYPE_SOIL_LEAF   0x8 // Soil/Leaf Station
#define STYPE_SENSORLINK  0x9 // SensorLink Station (not supported for the VP2)
#define STYPE_OFF         0xA // No station  OFF
#define STYPE_VUE         0x10 // pseudo station type for the Vue ISS
                               // since the Vue also has a type of 0x0

// Below are known, publicly documented packet types for the VP2 and the Vue.

// VP2 packet types
#define VP2P_UV           0x4 // UV index
#define VP2P_RAINSECS     0x5 // seconds between rain bucket tips
#define VP2P_SOLAR        0x6 // solar irradiation
#define VP2P_TEMP         0x8 // outside temperature
#define VP2P_WINDGUST     0x9 // 10-minute wind gust
#define VP2P_HUMIDITY     0xA // outside humidity
#define VP2P_RAIN         0xE // rain bucket tips counter
#define VP2P_SOIL_LEAF    0xF // soil/leaf station

// Vue packet types
#define VUEP_VCAP         0x2 // supercap voltage
#define VUEP_VSOLAR       0x7 // solar panel voltage

#endif  // VANTAGE_h
