#include "Help.h"

#ifndef NOHELP

//- helpText ---------------------------------------------------------------------------------------
const char helpText[] PROGMEM =
"\n"
"Available commands:" "\n"
"  <n>b             - radio band (0=US, 1=AU, [2=EU])" "\n"
"  <n>d             - DEBUG mode ([0=off], 1=on)" "\n"
"  <n>h             - height above sea level ([0]m)" "\n"
"  <n>l             - activity LED ([0=off], 1=on)" "\n"
"  <n>p             - show raw payload data ([0=off], 1=only decoded, 2=only undecoded, 3=all)" "\n"
"  <id>,<type>s     - station config (id=device channel, type=device type)" "\n"
"                     add  <id>,<type>s" "\n"
"                     list s" "\n"
"                     remove  <id>,10s" "\n"
"  <n>S             - BMP180 (n=sensor interval [60s])" "\n"
"  <n>r             - receive mode (0=disable, [1=enable])" "\n"
"  v                - version and configuration report" "\n"
;


void Help::Show() {
  PGM_P s = helpText;
  for (;;) {
    char c = pgm_read_byte(s++);
    if (c == 0)
      break;
    if (c == '\n')
      Serial.print('\r');
    Serial.print(c);
  }
  Serial.println();

}

#endif
