/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.spreadsheet;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPAdaptable;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPMessageType;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingType;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraintBase;
import org.jkiss.dbeaver.model.data.DBDAttributeDecorator;
import org.jkiss.dbeaver.model.data.DBDCollection;
import org.jkiss.dbeaver.model.data.DBDComplexValue;
import org.jkiss.dbeaver.model.data.DBDComposite;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDContentCached;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDResultSetModel;
import org.jkiss.dbeaver.model.data.DBDRowIdentifier;
import org.jkiss.dbeaver.model.data.DBDValueRow;
import org.jkiss.dbeaver.model.data.DBDValueSurrogate;
import org.jkiss.dbeaver.model.data.DBDVoid;
import org.jkiss.dbeaver.model.data.hints.DBDAttributeHintProvider;
import org.jkiss.dbeaver.model.data.hints.DBDCellHintProvider;
import org.jkiss.dbeaver.model.data.hints.DBDValueHint;
import org.jkiss.dbeaver.model.data.hints.DBDValueHintContext;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.impl.data.DBDValueError;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.preferences.DBPPropertyManager;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.virtual.DBVEntityConstraint;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.properties.PropertyCollector;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.SimpleByteArrayTransfer;
import org.jkiss.dbeaver.ui.UIElementAlignment;
import org.jkiss.dbeaver.ui.UIElementFontStyle;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.PropertyPageStandard;
import org.jkiss.dbeaver.ui.controls.bool.BooleanMode;
import org.jkiss.dbeaver.ui.controls.bool.BooleanStyleSet;
import org.jkiss.dbeaver.ui.controls.lightgrid.GridCell;
import org.jkiss.dbeaver.ui.controls.lightgrid.GridColumn;
import org.jkiss.dbeaver.ui.controls.lightgrid.GridPos;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridColumn;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridContentProvider;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridController;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridHint;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridItem;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridLabelProvider;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridRow;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridStatusColumn;
import org.jkiss.dbeaver.ui.controls.resultset.AbstractPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetDisplayFormatProvider;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetEditor;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetSelection;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetSelectionExt;
import org.jkiss.dbeaver.ui.controls.resultset.IStatefulControl;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetCellLocation;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetCopySettings;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetHintContext;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetIcons;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetModel;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetPasteSettings;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetThemeSettings;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetValueController;
import org.jkiss.dbeaver.ui.controls.resultset.handler.ResultSetPropertyTester;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;
import org.jkiss.dbeaver.ui.controls.resultset.spreadsheet.Spreadsheet;
import org.jkiss.dbeaver.ui.controls.resultset.spreadsheet.SpreadsheetFindReplaceTarget;
import org.jkiss.dbeaver.ui.controls.resultset.spreadsheet.SpreadsheetHint;
import org.jkiss.dbeaver.ui.controls.resultset.spreadsheet.SpreadsheetMessages;
import org.jkiss.dbeaver.ui.data.IMultiController;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.IValueEditor;
import org.jkiss.dbeaver.ui.data.IValueEditorStandalone;
import org.jkiss.dbeaver.ui.data.editors.BaseValueEditor;
import org.jkiss.dbeaver.ui.data.managers.BaseValueManager;
import org.jkiss.dbeaver.ui.dialogs.EditTextDialog;
import org.jkiss.dbeaver.ui.editors.TextEditorUtils;
import org.jkiss.dbeaver.ui.navigator.database.NavigatorThemeSettings;
import org.jkiss.dbeaver.ui.properties.PropertySourceDelegate;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;
import org.jkiss.utils.xml.XMLUtils;

public class SpreadsheetPresentation
extends AbstractPresentation
implements IResultSetEditor,
IResultSetDisplayFormatProvider,
ISelectionProvider,
IStatefulControl,
DBPAdaptable,
IGridController {
    public static final String PRESENTATION_ID = "spreadsheet";
    public static final EnumSet<DBDValueHint.HintType> INLINE_HINT_TYPES = EnumSet.of(DBDValueHint.HintType.STRING, DBDValueHint.HintType.ACTION, DBDValueHint.HintType.IMAGE);
    private static final Log log = Log.getLog(SpreadsheetPresentation.class);
    private Spreadsheet spreadsheet;
    @Nullable
    private DBDAttributeBinding curAttribute;
    private int columnOrder = -1;
    private final Map<SpreadsheetValueController, IValueEditorStandalone> openEditors = new HashMap<SpreadsheetValueController, IValueEditorStandalone>();
    private Color backgroundDefault;
    private Color foregroundDefault;
    private Color cellHeaderSelectionBackground;
    private boolean isHighContrastTheme = false;
    private boolean showOddRows = true;
    private boolean highlightRowsWithSelectedCells;
    private boolean showAttrOrdering;
    private boolean supportsAttributeFilter;
    private boolean autoFetchSegments;
    private boolean showAttributeIcons;
    private boolean showAttributeDescription;
    private boolean calcColumnWidthByValue;
    private boolean rightJustifyNumbers = true;
    private boolean rightJustifyDateTime = true;
    private boolean showBooleanAsCheckbox;
    private boolean showWhitespaceCharacters;
    private BooleanStyleSet booleanStyles;
    private int rowBatchSize;
    private IValueEditor activeInlineEditor;
    private int highlightScopeFirstLine;
    private int highlightScopeLastLine;
    private Color highlightScopeColor;
    private boolean useNativeNumbersFormat;
    private boolean colorizeDataTypes = true;
    private final Map<DBPDataKind, Color> dataTypesForegrounds = new IdentityHashMap<DBPDataKind, Color>();
    private DBDDisplayFormat gridValueFormat;

    public Spreadsheet getSpreadsheet() {
        return this.spreadsheet;
    }

    @Override
    public boolean isDirty() {
        return this.activeInlineEditor != null && this.activeInlineEditor.getControl() != null && !this.activeInlineEditor.getControl().isDisposed() && !DBExecUtils.isAttributeReadOnly((DBDAttributeBinding)this.getCurrentAttribute()) && !(this.activeInlineEditor instanceof IValueEditorStandalone);
    }

    @Override
    public void applyChanges() {
        if (this.activeInlineEditor != null && this.activeInlineEditor.getControl() != null && !this.activeInlineEditor.getControl().isDisposed()) {
            IValueController valueController = (IValueController)this.activeInlineEditor.getControl().getData("org.jkiss.dbeaver.resultset.value-controller");
            if (valueController != null) {
                try {
                    Object value = this.activeInlineEditor.extractEditorValue();
                    valueController.updateValue(value, true);
                }
                catch (DBException e) {
                    DBWorkbench.getPlatformUI().showError("Error extracting editor value", null, (Throwable)e);
                }
            }
            this.spreadsheet.cancelInlineEditor();
        }
        super.applyChanges();
    }

    @Override
    public void createPresentation(@NotNull IResultSetController controller, @NotNull Composite parent) {
        super.createPresentation(controller, parent);
        this.spreadsheet = new Spreadsheet(parent, 268436226, controller.getSite(), this, new ContentProvider(), new GridLabelProvider(), this);
        this.spreadsheet.setLayoutData(new GridData(1808));
        this.spreadsheet.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail != 1 && e.detail != 4) {
                    SpreadsheetPresentation.this.updateGridCursor((GridCell)e.data);
                }
                SpreadsheetPresentation.this.fireSelectionChanged((ISelection)new SpreadsheetSelectionImpl());
            }
        });
        this.spreadsheet.addMouseWheelListener(e -> {});
        this.spreadsheet.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                SpreadsheetPresentation.this.spreadsheet.cancelInlineEditor();
            }
        });
        this.spreadsheet.addTraverseListener(e -> {
            if (e.detail == 16 && controller.isPanelsVisible()) {
                controller.getVisiblePanel().setFocus();
                e.doit = false;
            }
        });
        this.activateTextKeyBindings(controller, (Control)this.spreadsheet);
        this.applyCurrentThemeSettings();
        this.trackPresentationControl();
        TextEditorUtils.enableHostEditorKeyBindingsSupport((IWorkbenchPartSite)controller.getSite(), (Control)this.spreadsheet);
    }

    @Override
    public void dispose() {
        this.closeEditors();
        this.clearMetaData();
        UIUtils.dispose((Resource)this.cellHeaderSelectionBackground);
        super.dispose();
    }

    @Override
    public void scrollToRow(@NotNull IResultSetPresentation.RowPosition position) {
        boolean recordMode = this.controller.isRecordMode();
        ResultSetRow curRow = this.controller.getCurrentRow();
        ResultSetModel model = this.controller.getModel();
        this.spreadsheet.setRedraw(false);
        try {
            int hScrollPos = this.spreadsheet.getHorizontalScrollBarProxy().getSelection();
            switch (position) {
                case FIRST: {
                    if (recordMode) {
                        if (model.getRowCount() > 0) {
                            this.controller.setCurrentRow(model.getRow(0));
                            break;
                        }
                        this.controller.setCurrentRow(null);
                        break;
                    }
                    this.spreadsheet.shiftCursor(0, -this.spreadsheet.getItemCount(), false);
                    break;
                }
                case PREVIOUS: {
                    if (recordMode && curRow != null && curRow.getVisualNumber() > 0) {
                        this.controller.setCurrentRow(model.getRow(curRow.getVisualNumber() - 1));
                        break;
                    }
                    this.spreadsheet.shiftCursor(0, -1, false);
                    break;
                }
                case NEXT: {
                    if (recordMode && curRow != null && curRow.getVisualNumber() < model.getRowCount() - 1) {
                        this.controller.setCurrentRow(model.getRow(curRow.getVisualNumber() + 1));
                        break;
                    }
                    this.spreadsheet.shiftCursor(0, 1, false);
                    break;
                }
                case LAST: {
                    if (recordMode && model.getRowCount() > 0) {
                        this.controller.setCurrentRow(model.getRow(model.getRowCount() - 1));
                        break;
                    }
                    this.spreadsheet.shiftCursor(0, this.spreadsheet.getItemCount(), false);
                    break;
                }
                case CURRENT: {
                    GridCell newCell;
                    if (curRow == null || recordMode) break;
                    GridPos curPos = this.spreadsheet.getCursorPosition();
                    IGridRow gridRow = this.spreadsheet.getRowByElement(curRow.getVisualNumber(), curRow);
                    if (gridRow == null || (newCell = this.spreadsheet.posToCell(new GridPos(curPos.col, gridRow.getVisualPosition()))) == null) break;
                    this.spreadsheet.setCursor(newCell, false, true, true);
                }
            }
            if (recordMode && this.controller.getSelectedRecords().length > 1 && curRow != null) {
                int newColumnIndex;
                curRow = this.controller.getCurrentRow();
                int n = newColumnIndex = curRow == null ? -1 : ArrayUtils.indexOf((int[])this.controller.getSelectedRecords(), (int)0, (int)curRow.getVisualNumber());
                if (newColumnIndex >= 0) {
                    GridPos focusPos = this.spreadsheet.getCursorPosition();
                    GridCell newPos = this.spreadsheet.posToCell(new GridPos(newColumnIndex, focusPos.row));
                    if (newPos != null) {
                        this.spreadsheet.setCursor(newPos, true, true, false);
                    }
                }
            }
            this.spreadsheet.getHorizontalScrollBarProxy().setSelection(hScrollPos);
            this.controller.updateStatusMessage();
            this.controller.updatePanelsContent(false);
            if (recordMode) {
                this.refreshData(true, false, true);
            }
        }
        finally {
            this.spreadsheet.setRedraw(true);
        }
    }

    @Override
    @Nullable
    public DBDAttributeBinding getCurrentAttribute() {
        return this.curAttribute;
    }

    @Override
    public void setCurrentAttribute(@NotNull DBDAttributeBinding attribute) {
        this.curAttribute = attribute;
        ResultSetRow curRow = this.controller.getCurrentRow();
        boolean recordMode = this.controller.isRecordMode();
        IGridColumn gridColumn = this.spreadsheet.getColumnByElement(recordMode ? curRow : this.curAttribute);
        IGridRow gridRow = this.spreadsheet.getRowByElement(recordMode ? 0 : (curRow == null ? 0 : curRow.getVisualNumber()), recordMode ? this.curAttribute : curRow);
        GridCell cell = new GridCell(gridColumn, gridRow);
        this.spreadsheet.setCursor(cell, false, true, true);
    }

    @Override
    public void showAttribute(@NotNull DBDAttributeBinding attribute) {
        this.spreadsheet.showColumn(attribute);
    }

    @Override
    @Nullable
    public int[] getCurrentRowIndexes() {
        GridPos focusPos = this.spreadsheet.getFocusPos();
        if (focusPos.row >= 0) {
            return this.getRowNestedIndexes(this.spreadsheet.getRow(focusPos.row));
        }
        return null;
    }

    @Override
    public Point getCursorLocation() {
        Rectangle columnBounds;
        GridPos focusPos = this.spreadsheet.getFocusPos();
        if (focusPos.col >= 0 && (columnBounds = this.spreadsheet.getColumnBounds(focusPos.col)) != null) {
            columnBounds.y += this.spreadsheet.getHeaderHeight() + (focusPos.row - this.spreadsheet.getTopIndex()) * (this.spreadsheet.getItemHeight() + 1) + this.spreadsheet.getItemHeight() / 2;
            return new Point(columnBounds.x + 20, columnBounds.y);
        }
        return super.getCursorLocation();
    }

    @Override
    protected void performHorizontalScroll(int scrollCount) {
        this.spreadsheet.scrollHorizontally(scrollCount);
    }

    private void revealCursor() {
        GridPos position = this.spreadsheet.getCursorPosition();
        this.spreadsheet.showItem(position.row);
    }

    void highlightRows(int firstLine, int lastLine, Color color) {
        this.highlightScopeFirstLine = firstLine;
        this.highlightScopeLastLine = lastLine;
        this.highlightScopeColor = color;
    }

    @Override
    public Object saveState() {
        return new ViewState(this.curAttribute, this.spreadsheet.getHorizontalScrollBarProxy().getSelection());
    }

    @Override
    public void restoreState(Object state) {
        if (state == null) {
            return;
        }
        ViewState viewState = (ViewState)state;
        this.curAttribute = this.controller.getModel().getAttributeBinding((DBSAttributeBase)viewState.focusedAttribute);
        this.spreadsheet.getHorizontalScrollBarProxy().setSelection(viewState.hScrollSelection);
        this.spreadsheet.setDefaultFocusRow();
    }

    private void updateGridCursor(GridCell cell) {
        boolean changed;
        IGridRow newRow;
        IGridColumn newCol;
        if (cell == null) {
            newCol = null;
            newRow = null;
        } else if (this.isArrayColAndFirstRow(cell.getColumn(), cell.getRow())) {
            newCol = cell.getColumn().getParent();
            newRow = cell.getRow();
        } else {
            newCol = cell.getColumn();
            newRow = cell.getRow();
        }
        ResultSetRow curRow = this.controller.getCurrentRow();
        if (!this.controller.isRecordMode()) {
            Object object;
            Object object2;
            boolean bl = changed = newRow != null && curRow != newRow.getElement() || newCol != null && this.curAttribute != newCol.getElement();
            if (newRow != null && (object2 = newRow.getElement()) instanceof ResultSetRow) {
                ResultSetRow resultSetRow;
                curRow = resultSetRow = (ResultSetRow)object2;
                this.controller.setCurrentRow(curRow);
            }
            if (newCol != null && (object = newCol.getElement()) instanceof DBDAttributeBinding) {
                DBDAttributeBinding attributeBinding;
                this.curAttribute = attributeBinding = (DBDAttributeBinding)object;
            }
        } else {
            Object object;
            Object object3;
            boolean bl = changed = newRow != null && this.curAttribute != newRow.getElement();
            if (newRow != null && (object3 = newRow.getElement()) instanceof DBDAttributeBinding) {
                DBDAttributeBinding attributeBinding;
                this.curAttribute = attributeBinding = (DBDAttributeBinding)object3;
            }
            if (newCol != null && (object = newCol.getElement()) instanceof ResultSetRow) {
                ResultSetRow resultSetRow = (ResultSetRow)object;
                if (curRow != newCol.getElement()) {
                    curRow = resultSetRow;
                    this.controller.setCurrentRow(curRow);
                }
            }
        }
        if (changed) {
            this.spreadsheet.cancelInlineEditor();
            ResultSetPropertyTester.firePropertyChange("canMove");
            ResultSetPropertyTester.firePropertyChange("editable");
            this.spreadsheet.redrawGrid();
        }
    }

    @Override
    @NotNull
    public Map<Transfer, Object> copySelection(ResultSetCopySettings settings) {
        String quoteString;
        String rowDelimiter;
        boolean copyHTML = settings.isCopyHTML();
        StringBuilder tdt = new StringBuilder();
        StringBuilder html = new StringBuilder();
        byte[] binaryData = null;
        LinkedHashMap<Transfer, Object> formats = new LinkedHashMap<Transfer, Object>();
        String columnDelimiter = settings.getColumnDelimiter();
        if (columnDelimiter == null) {
            columnDelimiter = "\t";
        }
        if ((rowDelimiter = settings.getRowDelimiter()) == null) {
            rowDelimiter = GeneralUtils.getDefaultLineSeparator();
        }
        if (CommonUtils.isEmpty((String)(quoteString = settings.getQuoteString()))) {
            quoteString = "\"";
        }
        List<IGridColumn> selectedColumns = this.spreadsheet.getColumnSelection();
        IGridLabelProvider labelProvider = this.spreadsheet.getLabelProvider();
        if (copyHTML) {
            html.append("<table border=\"1\">");
        }
        if (settings.isCopyHeader()) {
            if (copyHTML) {
                html.append("<thead>");
            }
            if (settings.isCopyRowNumbers()) {
                tdt.append("#");
                if (copyHTML) {
                    html.append("<th>#</th>");
                }
            }
            for (IGridColumn column : selectedColumns) {
                if (!tdt.isEmpty()) {
                    tdt.append(columnDelimiter);
                }
                String columnText = labelProvider.getText(column);
                tdt.append(columnText);
                if (!copyHTML) continue;
                html.append("<th>").append(XMLUtils.escapeXml((CharSequence)columnText)).append("</th>");
            }
            tdt.append(rowDelimiter);
            if (copyHTML) {
                html.append("</thead>").append(rowDelimiter);
            }
        }
        if (copyHTML) {
            html.append("<tbody>");
        }
        List<GridCell> selectedCells = this.spreadsheet.getCellSelection();
        boolean quoteCells = settings.isQuoteCells() && selectedCells.size() > 1;
        boolean forceQuotes = settings.isForceQuotes();
        GridCell prevCell = null;
        for (GridCell cell : selectedCells) {
            ResultSetRow row;
            SpreadsheetValueController valueController;
            int prevColIndex;
            if (prevCell == null || cell.row != prevCell.row) {
                if (prevCell != null && prevCell.col != cell.col) {
                    int i = prevColIndex = selectedColumns.indexOf(prevCell.col);
                    while (i < selectedColumns.size() - 1) {
                        tdt.append(columnDelimiter);
                        if (copyHTML) {
                            html.append("<td></td>");
                        }
                        ++i;
                    }
                }
                if (prevCell != null) {
                    tdt.append(rowDelimiter);
                    if (copyHTML) {
                        html.append("</tr>").append(rowDelimiter);
                    }
                }
                if (settings.isCopyRowNumbers()) {
                    String rowNumber = labelProvider.getText(cell.row);
                    tdt.append(rowNumber).append(columnDelimiter);
                    if (copyHTML) {
                        html.append("<td>").append(rowNumber).append("</td>");
                    }
                }
                if (copyHTML) {
                    html.append("<tr>");
                }
            }
            if (prevCell != null && prevCell.col != cell.col) {
                prevColIndex = selectedColumns.indexOf(prevCell.col);
                int curColIndex = selectedColumns.indexOf(cell.col);
                int i = prevColIndex;
                while (i < curColIndex) {
                    tdt.append(columnDelimiter);
                    if (i != prevColIndex && copyHTML) {
                        html.append("<td></td>");
                    }
                    ++i;
                }
            }
            DBDAttributeBinding column = this.getAttributeFromGrid(cell.col, cell.row);
            Object value = this.spreadsheet.getContentProvider().getCellValue(cell.col, cell.row, false);
            if (binaryData == null && (column.getDataKind() == DBPDataKind.BINARY || column.getDataKind() == DBPDataKind.CONTENT)) {
                DBDContent content;
                if (value instanceof byte[]) {
                    byte[] bValue;
                    binaryData = bValue = (byte[])value;
                } else if (value instanceof DBDContent && !ContentUtils.isTextContent((DBDContent)(content = (DBDContent)value)) && value instanceof DBDContentCached) {
                    try {
                        binaryData = ContentUtils.getContentBinaryValue((DBRProgressMonitor)new VoidProgressMonitor(), (DBDContent)content);
                    }
                    catch (DBCException dBCException) {
                        log.debug((Object)"Error reading content binary value");
                    }
                }
            }
            Object cellText = column.getValueRenderer().getValueDisplayString((DBSTypedObject)column.getAttribute(), value, settings.getFormat());
            if ((forceQuotes || quoteCells && !CommonUtils.isEmpty((String)cellText)) && (forceQuotes || ((String)cellText).contains(columnDelimiter) || ((String)cellText).contains(rowDelimiter))) {
                cellText = quoteString + (String)cellText + quoteString;
            }
            tdt.append((String)cellText);
            if (copyHTML) {
                html.append("<td>").append(XMLUtils.escapeXml((CharSequence)cellText)).append("</td> ");
            }
            if (settings.isCut() && !(valueController = new SpreadsheetValueController(this.controller, new ResultSetCellLocation(column, row = this.getResultRowFromGrid(cell.col, cell.row), this.getRowNestedIndexes(cell.row)), IValueController.EditType.NONE, null)).isReadOnly()) {
                valueController.updateValue(BaseValueManager.makeNullValue(valueController), false);
            }
            prevCell = cell;
        }
        if (copyHTML) {
            html.append("</tbody>").append(rowDelimiter);
            html.append("</table>").append(rowDelimiter);
        }
        if (settings.isCut()) {
            this.controller.redrawData(false, false);
            this.controller.updatePanelsContent(false);
        }
        formats.put((Transfer)TextTransfer.getInstance(), tdt.toString());
        if (copyHTML) {
            formats.put((Transfer)HTMLTransfer.getInstance(), html.toString());
        }
        if (binaryData != null) {
            formats.put((Transfer)SimpleByteArrayTransfer.getInstance(), binaryData);
        }
        return formats;
    }

    @Override
    public void pasteFromClipboard(@Nullable ResultSetPasteSettings settings) {
        try {
            ArrayList<DBDValueRow> updatedRows = new ArrayList<DBDValueRow>();
            HashSet<DBDAttributeBinding> updatedAttrs = new HashSet<DBDAttributeBinding>();
            if (settings != null) {
                String strValue;
                Clipboard clipboard = new Clipboard(Display.getCurrent());
                try {
                    strValue = (String)clipboard.getContents((Transfer)TextTransfer.getInstance());
                }
                finally {
                    clipboard.dispose();
                }
                if (CommonUtils.isEmpty((String)strValue)) {
                    return;
                }
                Pair targetRange = this.spreadsheet.getItemCount() == 0 ? new Pair((Object)new GridPos(0, 0), null) : this.getContinuousRange(List.copyOf(this.spreadsheet.getSelection()));
                if (targetRange == null) {
                    DBWorkbench.getPlatformUI().showWarningMessageBox("Advanced paste", "You can't perform this operation on a multiple range selection.\n\nPlease select a single range and try again.");
                    return;
                }
                GridPos rangeStart = (GridPos)targetRange.getFirst();
                GridPos rangeEnd = (GridPos)targetRange.getSecond();
                int rowNum = rangeStart.row;
                Throwable throwable = null;
                Object var11_21 = null;
                try (DBCSession session = DBUtils.openUtilSession((DBRProgressMonitor)new VoidProgressMonitor(), (DBSObject)this.controller.getDataContainer(), (String)"Advanced paste");){
                    String[][] newLines = this.parseGridLines(strValue, settings.isInsertMultipleRows(), settings.isIgnoreQuotes());
                    while (rangeEnd == null && rowNum + newLines.length > this.spreadsheet.getItemCount()) {
                        this.controller.addNewRow(IResultSetController.RowPlacement.AT_END, false, false);
                        this.spreadsheet.refreshRowsData();
                    }
                    if (rowNum < 0 || rowNum >= this.spreadsheet.getItemCount()) {
                        return;
                    }
                    String[][] stringArray = newLines;
                    int n = newLines.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String[] line = stringArray[n2];
                        int colNum = rangeStart.col;
                        IGridRow gridRow = this.spreadsheet.getRow(rowNum);
                        String[] stringArray2 = line;
                        int n3 = line.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String value = stringArray2[n4];
                            GridColumn colElement = this.spreadsheet.getColumn(colNum);
                            DBDAttributeBinding attr = this.getAttributeFromGrid(colElement, gridRow);
                            ResultSetRow row = this.getResultRowFromGrid(colElement, gridRow);
                            if (attr != null && row != null && this.controller.getAttributeReadOnlyStatus(attr, true, false) == null) {
                                updatedAttrs.add(attr);
                                updatedRows.add(row);
                                Object newValue = settings.isInsertNulls() && settings.getNullValueMark().equalsIgnoreCase(value) ? null : attr.getValueHandler().getValueFromObject(session, (DBSTypedObject)attr.getAttribute(), (Object)value, true, false);
                                new SpreadsheetValueController(this.controller, new ResultSetCellLocation(attr, row, this.getRowNestedIndexes(gridRow)), IValueController.EditType.NONE, null).updateValue(newValue, false);
                                if (++colNum >= this.spreadsheet.getColumnCount() || rangeEnd != null && rangeStart.col != rangeEnd.col && colNum > rangeEnd.col) break;
                            }
                            ++n4;
                        }
                        if (++rowNum >= this.spreadsheet.getItemCount()) {
                            break;
                        }
                        if (rangeEnd != null && rowNum > rangeEnd.row) {
                            break;
                        }
                        ++n2;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                this.scrollToRow(IResultSetPresentation.RowPosition.CURRENT);
            } else {
                Collection<GridPos> ssSelection = this.spreadsheet.getSelection();
                for (GridPos pos : ssSelection) {
                    ResultSetRow row;
                    DBDAttributeBinding attr;
                    IGridRow gridRow = this.spreadsheet.getRow(pos.row);
                    if (this.controller.isRecordMode()) {
                        attr = (DBDAttributeBinding)this.spreadsheet.getRowElement(pos.row);
                        row = this.controller.getCurrentRow();
                    } else {
                        attr = (DBDAttributeBinding)this.spreadsheet.getColumnElement(pos.col);
                        row = (ResultSetRow)gridRow.getElement();
                    }
                    if (attr == null || row == null || this.controller.getAttributeReadOnlyStatus(attr, true, false) != null) continue;
                    SpreadsheetValueController valueController = new SpreadsheetValueController(this.controller, new ResultSetCellLocation(attr, row, this.getRowNestedIndexes(gridRow)), IValueController.EditType.NONE, null);
                    Object newValue = null;
                    if (attr.getDataKind() == DBPDataKind.BINARY || attr.getDataKind() == DBPDataKind.CONTENT) {
                        Clipboard clipboard = new Clipboard(Display.getCurrent());
                        try {
                            Throwable throwable = null;
                            Object var14_36 = null;
                            try (DBCSession session = DBUtils.openUtilSession((DBRProgressMonitor)new VoidProgressMonitor(), (DBSObject)attr, (String)"Copy from clipboard");){
                                byte[] binaryContents = (byte[])clipboard.getContents((Transfer)SimpleByteArrayTransfer.getInstance());
                                if (binaryContents != null) {
                                    newValue = valueController.getValueHandler().getValueFromObject(session, (DBSTypedObject)attr, (Object)binaryContents, false, false);
                                }
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                throw throwable;
                            }
                        }
                        finally {
                            clipboard.dispose();
                        }
                    }
                    if (newValue == null && (newValue = ResultSetUtils.getAttributeValueFromClipboard(attr)) == null) continue;
                    valueController.updateValue(newValue, false);
                }
            }
            this.controller.redrawData(false, true);
            this.controller.updateEditControls();
            this.controller.updatePanelsContent(false);
            this.controller.refreshHintCache(updatedAttrs, updatedRows, null);
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError("Cannot replace cell value", null, (Throwable)e);
        }
    }

    @Nullable
    private Pair<GridPos, GridPos> getContinuousRange(@NotNull List<GridPos> selection) {
        return switch (selection.size()) {
            case 0 -> null;
            case 1 -> new Pair((Object)selection.get(0), null);
            default -> {
                GridPos min = selection.get(0);
                GridPos max = new GridPos(min);
                int i = 0;
                while (i < selection.size()) {
                    GridPos cur = selection.get(i);
                    if (i > 0 && (cur.row - max.row > 1 || cur.col - max.col > 1)) {
                        yield null;
                    }
                    max = cur;
                    ++i;
                }
                yield new Pair((Object)min, (Object)max);
            }
        };
    }

    /*
     * Unable to fully structure code
     */
    private String[][] parseGridLines(String strValue, boolean splitRows, boolean ignoreQuotes) {
        lines = new ArrayList<String[]>();
        cellValue = new StringBuilder();
        curLine = new ArrayList<String>();
        inQuote = false;
        length = strValue.length();
        i = 0;
        while (i < length) {
            block14: {
                block13: {
                    c = strValue.charAt(i);
                    if (!inQuote || c == '\"') break block13;
                    cellValue.append(c);
                    break block14;
                }
                switch (c) {
                    case '\t': 
                    case '\n': {
                        curLine.add(cellValue.toString());
                        cellValue.setLength(0);
                        if (c != '\n' || !splitRows) break;
                        lines.add(curLine.toArray(new String[0]));
                        curLine.clear();
                        break;
                    }
                    case '\r': {
                        break;
                    }
                    case '\"': {
                        if (ignoreQuotes) {
                            cellValue.append(c);
                            break;
                        }
                        if (!inQuote) ** GOTO lbl36
                        if (i == length - 1 || strValue.charAt(i + 1) == '\t' || strValue.charAt(i + 1) == '\r' || strValue.charAt(i + 1) == '\n') {
                            inQuote = false;
                            break;
                        }
                        ** GOTO lbl45
lbl36:
                        // 1 sources

                        if (cellValue.isEmpty()) {
                            k = i + 1;
                            while (k < length) {
                                if (strValue.charAt(k) == '\"' && (k == length - 1 || strValue.charAt(k + 1) == '\t' || strValue.charAt(k + 1) == '\r' || strValue.charAt(k + 1) == '\n')) {
                                    inQuote = true;
                                    break;
                                }
                                ++k;
                            }
                            if (inQuote) break;
                        }
                    }
lbl45:
                    // 5 sources

                    default: {
                        cellValue.append(c);
                    }
                }
            }
            ++i;
        }
        if (!cellValue.isEmpty()) {
            curLine.add(cellValue.toString());
        }
        if (!curLine.isEmpty()) {
            lines.add(curLine.toArray(new String[0]));
        }
        return (String[][])lines.toArray((T[])new String[lines.size()][]);
    }

    @Override
    public Control getControl() {
        return this.spreadsheet;
    }

    @Override
    public void refreshData(boolean refreshMetadata, boolean append, boolean keepState) {
        if (this.spreadsheet.isDisposed()) {
            return;
        }
        this.isHighContrastTheme = UIStyles.isHighContrastTheme();
        DBPPreferenceStore preferenceStore = this.getPreferenceStore();
        this.showOddRows = preferenceStore.getBoolean("resultset.show.oddRows");
        this.highlightRowsWithSelectedCells = preferenceStore.getBoolean("resultset.highlight.selectedRows");
        this.rightJustifyNumbers = preferenceStore.getBoolean("resultset.show.rightJustifyNumbers");
        this.rightJustifyDateTime = preferenceStore.getBoolean("resultset.show.rightJustifyDateTime");
        this.rowBatchSize = preferenceStore.getInt("resultset.show.row.batch.size");
        this.showAttrOrdering = preferenceStore.getBoolean("resultset.show.attrOrder");
        this.showAttributeIcons = this.controller.getPreferenceStore().getBoolean("resultset.show.attIcons");
        this.showAttributeDescription = this.getPreferenceStore().getBoolean("resultset.show.columnDescription");
        this.supportsAttributeFilter = this.controller.getDataContainer() != null && (this.controller.getDecorator().getDecoratorFeatures() & 1L) != 0L && this.controller.getDataContainer().isFeatureSupported("data.filter") && this.controller.getPreferenceStore().getBoolean("resultset.show.attFilters");
        this.autoFetchSegments = this.controller.getPreferenceStore().getBoolean("resultset.autofetch.next.segment");
        this.calcColumnWidthByValue = this.getPreferenceStore().getBoolean("resultset.calc.columnWidthByValues");
        this.showBooleanAsCheckbox = preferenceStore.getBoolean("resultset.show.boolean.checkbox");
        this.showWhitespaceCharacters = preferenceStore.getBoolean("resultset.show.whitespace.characters");
        this.booleanStyles = BooleanStyleSet.getDefaultStyles((DBPPreferenceStore)preferenceStore);
        this.useNativeNumbersFormat = this.controller.getPreferenceStore().getBoolean("resultset.format.numeric.native");
        this.spreadsheet.setColumnScrolling(!this.getPreferenceStore().getBoolean("resultset.hScroll.smooth"));
        this.gridValueFormat = (DBDDisplayFormat)CommonUtils.valueOf(DBDDisplayFormat.class, (String)this.getPreferenceStore().getString("resultset.grid.value.format"), (Enum)DBDDisplayFormat.UI);
        this.spreadsheet.setRedraw(false);
        try {
            this.spreadsheet.refreshData(refreshMetadata, keepState, false);
        }
        finally {
            this.spreadsheet.setRedraw(true);
        }
    }

    @Override
    public void formatData(boolean refreshData) {
        this.spreadsheet.refreshData(false, true, false);
    }

    @Override
    public void clearMetaData() {
        this.curAttribute = null;
        if (this.columnOrder != 0) {
            this.columnOrder = -1;
        }
    }

    @Override
    public void updateValueView() {
        this.spreadsheet.redrawGrid();
        this.spreadsheet.updateScrollbars();
        if (this.curAttribute == null) {
            this.curAttribute = this.getFocusAttribute();
        }
    }

    @Override
    public void fillMenu(@NotNull IMenuManager menu) {
        menu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.controller.getSite(), (String)"org.jkiss.dbeaver.core.resultset.grid.togglePreview", (int)32));
    }

    @Override
    public void changeMode(boolean recordMode) {
        ResultSetRow oldRow = this.controller.getCurrentRow();
        DBDAttributeBinding oldAttribute = this.curAttribute;
        int rowCount = this.controller.getModel().getRowCount();
        if (rowCount > 0) {
            if (oldRow == null) {
                oldRow = this.controller.getModel().getRow(0);
            } else if (oldRow.getVisualNumber() >= rowCount) {
                oldRow = this.controller.getModel().getRow(rowCount - 1);
            }
        }
        if (oldAttribute == null && this.controller.getModel().getVisibleAttributeCount() > 0) {
            oldAttribute = this.controller.getModel().getVisibleAttribute(0);
        }
        int n = this.columnOrder = recordMode ? -1 : 0;
        if (oldRow != null && oldAttribute != null) {
            IGridColumn gridColumn = this.spreadsheet.getColumnByElement(recordMode ? oldRow : oldAttribute);
            IGridRow gridRow = this.spreadsheet.getRowByElement(recordMode ? 0 : oldRow.getVisualNumber(), recordMode ? oldAttribute : oldRow);
            this.spreadsheet.setCursor(new GridCell(gridColumn, gridRow), false, true, true);
        }
        this.spreadsheet.layout(true, true);
    }

    void fillContextMenu(@NotNull IMenuManager manager, @Nullable IGridColumn colObject, @Nullable IGridRow rowObject, boolean columnHeaderMenu, boolean rowHeaderMenu) {
        ResultSetRow row;
        boolean recordMode = this.controller.isRecordMode();
        DBDAttributeBinding attr = colObject == null ? this.getFocusAttribute() : (this.isArrayColAndFirstRow(colObject, rowObject) ? this.getAttributeFromGrid(colObject.getParent(), rowObject) : this.getAttributeFromGrid(colObject, rowObject));
        ResultSetRow resultSetRow = row = rowObject == null ? this.getFocusRow() : this.getResultRowFromGrid(colObject, rowObject);
        IResultSetController.ContextMenuLocation menuLocation = columnHeaderMenu ? IResultSetController.ContextMenuLocation.COLUMN_HEADER : (rowHeaderMenu ? IResultSetController.ContextMenuLocation.ROW_HEADER : IResultSetController.ContextMenuLocation.DATA);
        this.controller.fillContextMenu(manager, attr, row, this.getRowNestedIndexes(rowObject), menuLocation);
        if (colObject != null && rowObject == null) {
            IGridColumn attrCol;
            final List<IGridColumn> selectedColumns = this.spreadsheet.getColumnSelection();
            if (selectedColumns.size() == 1 && (attrCol = this.spreadsheet.getColumnByElement(attr)) != null) {
                selectedColumns.clear();
                selectedColumns.add(attrCol);
            }
            if (!recordMode && !selectedColumns.isEmpty()) {
                String hideTitle;
                manager.insertBefore("results_additions", (IContributionItem)new Separator());
                final DBDDataFilter dataFilter = this.controller.getModel().getDataFilter();
                boolean allPinned = selectedColumns.stream().map(x -> dataFilter.getConstraint(((DBDAttributeBinding)x.getElement()).getTopParent())).allMatch(x -> x != null && x.hasOption("pinned"));
                final boolean allUnpinned = selectedColumns.stream().map(x -> dataFilter.getConstraint(((DBDAttributeBinding)x.getElement()).getTopParent())).allMatch(x -> x != null && !x.hasOption("pinned"));
                if (allUnpinned != allPinned) {
                    String pinnedTitle = allUnpinned ? (selectedColumns.size() == 1 ? NLS.bind((String)ResultSetMessages.controls_resultset_viewer_pin_column, (Object)((DBDAttributeBinding)selectedColumns.get(0).getElement()).getName()) : NLS.bind((String)ResultSetMessages.controls_resultset_viewer_pin_columns, (Object)selectedColumns.size())) : (selectedColumns.size() == 1 ? NLS.bind((String)ResultSetMessages.controls_resultset_viewer_unpin_column, (Object)((DBDAttributeBinding)selectedColumns.get(0).getElement()).getName()) : NLS.bind((String)ResultSetMessages.controls_resultset_viewer_unpin_columns, (Object)selectedColumns.size()));
                    manager.insertBefore("results_additions", (IAction)new Action(pinnedTitle){

                        public void run() {
                            for (IGridColumn column : selectedColumns) {
                                DBDAttributeBinding attribute = (DBDAttributeBinding)column.getElement();
                                DBDAttributeConstraint constraint = dataFilter.getConstraint(attribute.getTopParent());
                                if (constraint == null) continue;
                                if (allUnpinned) {
                                    constraint.setOption("pinned", (Object)SpreadsheetPresentation.getNextPinIndex(dataFilter));
                                    continue;
                                }
                                constraint.removeOption("pinned");
                            }
                            SpreadsheetPresentation.this.spreadsheet.refreshData(true, true, false);
                        }
                    });
                }
                if (this.getController().getModel().getDataFilter().hasHiddenAttributes()) {
                    manager.insertAfter("results_additions", (IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.controller.getSite(), (String)"org.jkiss.dbeaver.core.resultset.grid.showColumns", (String)ResultSetMessages.controls_resultset_viewer_show_hidden_columns, null));
                }
                if (selectedColumns.size() == 1) {
                    DBDAttributeBinding columnToHide = (DBDAttributeBinding)selectedColumns.get(0).getElement();
                    hideTitle = NLS.bind((String)ResultSetMessages.controls_resultset_viewer_hide_column_x, (Object)columnToHide.getName());
                } else {
                    hideTitle = NLS.bind((String)ResultSetMessages.controls_resultset_viewer_hide_columns_x, (Object)selectedColumns.size());
                }
                manager.insertAfter("results_additions", (IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.controller.getSite(), (String)"org.jkiss.dbeaver.core.resultset.grid.hideColumns", (String)hideTitle, null));
            }
        }
        if (recordMode && row != null) {
            ArrayList<Integer> selectedRowIndexes = new ArrayList<Integer>();
            for (IGridColumn sRow : this.spreadsheet.getColumnSelection()) {
                Object object = sRow.getElement();
                if (!(object instanceof ResultSetRow)) continue;
                ResultSetRow resultSetRow2 = (ResultSetRow)object;
                selectedRowIndexes.add(resultSetRow2.getVisualNumber());
            }
            if (!selectedRowIndexes.isEmpty() && selectedRowIndexes.size() < this.controller.getSelectedRecords().length) {
                final List curRowIndexes = Arrays.stream(this.controller.getSelectedRecords()).boxed().collect(Collectors.toList());
                curRowIndexes.removeAll(selectedRowIndexes);
                if (!curRowIndexes.isEmpty()) {
                    manager.insertAfter("results_additions", (IAction)new Action("Hide row(s)"){

                        public void run() {
                            SpreadsheetPresentation.this.controller.setSelectedRecords(curRowIndexes.stream().mapToInt(i -> i).toArray());
                            SpreadsheetPresentation.this.refreshData(true, false, true);
                        }
                    });
                }
            }
        }
        if (rowObject == null && !this.controller.getModel().getVisibleAttributes().isEmpty()) {
            manager.insertAfter("results_additions", (IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.controller.getSite(), (String)"org.jkiss.dbeaver.core.resultset.grid.columnsHideEmpty"));
            manager.insertAfter("results_additions", (IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.controller.getSite(), (String)"org.jkiss.dbeaver.core.resultset.grid.columnsFitValue"));
            manager.insertAfter("results_additions", (IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.controller.getSite(), (String)"org.jkiss.dbeaver.core.resultset.grid.columnsFitScreen"));
        }
    }

    public static int getNextPinIndex(@NotNull DBDDataFilter dataFilter) {
        int maxIndex = 0;
        for (DBDAttributeConstraint ac : dataFilter.getConstraints()) {
            Integer pinIndex = (Integer)ac.getOption("pinned");
            if (pinIndex == null) continue;
            maxIndex = Math.max(maxIndex, pinIndex + 1);
        }
        return maxIndex;
    }

    private boolean isArrayColAndFirstRow(@Nullable IGridColumn colObject, @Nullable IGridRow rowObject) {
        DBDAttributeBinding binding;
        Object object;
        return colObject != null && colObject.getParent() != null && (object = colObject.getParent().getElement()) instanceof DBDAttributeBinding && (binding = (DBDAttributeBinding)object).getDataKind() == DBPDataKind.ARRAY && rowObject != null && rowObject.getParent() == null;
    }

    private void closeEditors() {
        ArrayList<IValueEditorStandalone> editors = new ArrayList<IValueEditorStandalone>(this.openEditors.values());
        for (IValueEditorStandalone editor : editors) {
            if (editor.getControl() == null || editor.getControl().isDisposed()) continue;
            editor.closeValueEditor();
        }
        this.openEditors.clear();
    }

    @Override
    @Nullable
    public Control openValueEditor(boolean inline) {
        IValueEditor iValueEditor;
        IValueController.EditType[] supportedEditTypes;
        SpreadsheetValueController valueController;
        IGridColumn focusColumn = this.spreadsheet.getFocusColumn();
        IGridRow focusRow = this.spreadsheet.getFocusRow();
        DBDAttributeBinding attr = this.getAttributeFromGrid(focusColumn, focusRow);
        ResultSetRow row = this.getResultRowFromGrid(focusColumn, focusRow);
        if (attr == null || row == null) {
            return null;
        }
        ResultSetCellLocation cellLocation = new ResultSetCellLocation(attr, row, this.getRowNestedIndexes(focusRow));
        Object cellValue = this.getController().getModel().getCellValue(cellLocation);
        if (cellValue instanceof DBDValueSurrogate) {
            return null;
        }
        if (!inline) {
            Iterator<SpreadsheetValueController> iterator = this.openEditors.keySet().iterator();
            while (iterator.hasNext()) {
                valueController = iterator.next();
                if (attr != valueController.getBinding() || row != valueController.getCurRow()) continue;
                IValueEditorStandalone editor = this.openEditors.get(valueController);
                if (editor.getControl() != null && !editor.getControl().isDisposed()) {
                    editor.showValueEditor();
                    return null;
                }
                iterator.remove();
            }
        } else if (this.isShowAsCheckbox(attr) && this.getPreferenceStore().getBoolean("resultset.show.boolean.toggleOnClick")) {
            return null;
        }
        Composite placeholder = null;
        if (inline) {
            String readOnlyStatus = this.controller.getAttributeReadOnlyStatus(attr, true, true);
            if (readOnlyStatus != null) {
                this.controller.setStatus(NLS.bind((String)ResultSetMessages.controls_resultset_viewer_action_open_value_editor_column_readonly, (Object)DBUtils.getObjectFullName((DBPNamedObject)attr, (DBPEvaluationContext)DBPEvaluationContext.UI), (Object)readOnlyStatus), DBPMessageType.ERROR);
            }
            this.spreadsheet.cancelInlineEditor();
            this.activeInlineEditor = null;
            placeholder = new Composite((Composite)this.spreadsheet, 0);
            placeholder.setFont(this.spreadsheet.getFont());
            placeholder.setLayout((Layout)new FillLayout());
            GridData gd = new GridData(1808);
            gd.horizontalIndent = 0;
            gd.verticalIndent = 0;
            gd.grabExcessHorizontalSpace = true;
            gd.grabExcessVerticalSpace = true;
            placeholder.setLayoutData((Object)gd);
            placeholder.addDisposeListener(e -> this.controller.updateStatusMessage());
            this.controller.lockActionsByControl((Control)placeholder);
        }
        if ((supportedEditTypes = (valueController = new SpreadsheetValueController(this.controller, cellLocation, inline ? IValueController.EditType.INLINE : IValueController.EditType.EDITOR, placeholder)).getValueManager().getSupportedEditTypes()).length == 0) {
            if (placeholder != null) {
                placeholder.dispose();
            }
            return null;
        }
        try {
            this.activeInlineEditor = valueController.getValueManager().createEditor(valueController);
        }
        catch (Exception e2) {
            DBWorkbench.getPlatformUI().showError("Cannot edit value", null, (Throwable)e2);
            return null;
        }
        if (this.activeInlineEditor != null) {
            this.activeInlineEditor.createControl();
            Control control = this.activeInlineEditor.getControl();
            if (control != null) {
                control.setFocus();
                control.setData("org.jkiss.dbeaver.resultset.value-controller", (Object)valueController);
                control.addKeyListener(KeyListener.keyPressedAdapter(e -> this.revealCursor()));
                control.addTraverseListener(e -> {
                    if (e.keyCode == 27 || e.keyCode == 13) {
                        this.revealCursor();
                    }
                });
                this.revealCursor();
            }
        }
        if ((iValueEditor = this.activeInlineEditor) instanceof IValueEditorStandalone) {
            IValueEditorStandalone editorStandalone = (IValueEditorStandalone)iValueEditor;
            valueController.registerEditor(editorStandalone);
            Control editorControl = this.activeInlineEditor.getControl();
            if (editorControl != null) {
                editorControl.addDisposeListener(e -> valueController.unregisterEditor((IValueEditorStandalone)this.activeInlineEditor));
            }
            UIUtils.asyncExec(() -> ((IValueEditorStandalone)this.activeInlineEditor).showValueEditor());
        } else if (this.activeInlineEditor != null) {
            try {
                this.activeInlineEditor.primeEditorValue(valueController.getValue());
            }
            catch (DBException e3) {
                log.error((Object)e3);
            }
            this.activeInlineEditor.setDirty(false);
        }
        if (inline) {
            if (this.activeInlineEditor != null) {
                this.spreadsheet.showCellEditor(placeholder);
                IValueEditor iValueEditor2 = this.activeInlineEditor;
                if (iValueEditor2 instanceof BaseValueEditor) {
                    BaseValueEditor bve = (BaseValueEditor)iValueEditor2;
                    if (CommonUtils.getBoolean((String)this.getPreferenceStore().getString("resultset.behavior.inlineEnter"))) {
                        bve.addAdditionalTraverseActions(it -> {
                            if (it.detail == 4) {
                                Event applyEvent = new Event();
                                applyEvent.keyCode = (it.stateMask & 0x20000) == 0 ? 0x1000002 : 0x1000004;
                                this.getSpreadsheet().notifyListeners(1, applyEvent);
                                this.openValueEditor(true);
                            }
                        });
                    }
                }
                return this.activeInlineEditor.getControl();
            }
            placeholder.dispose();
            if (ArrayUtils.contains((Object[])supportedEditTypes, (Object)((Object)IValueController.EditType.PANEL))) {
                this.controller.activatePanel("value-view", true, true);
                return null;
            }
        }
        return null;
    }

    public void navigateLink(@NotNull GridCell cell, int x, int y, int state) {
        DBDAttributeBinding attr = this.getAttributeFromGrid(cell.col, cell.row);
        ResultSetRow row = this.getResultRowFromGrid(cell.col, cell.row);
        Object value = this.controller.getModel().getCellValue(new ResultSetCellLocation(attr, row, this.getRowNestedIndexes(cell.row)));
        if ((value instanceof Boolean || value instanceof Number || value == null) && this.isShowAsCheckbox(attr)) {
            if (!this.getPreferenceStore().getBoolean("resultset.show.boolean.toggleOnClick")) {
                return;
            }
            if (!DBExecUtils.isAttributeReadOnly((DBDAttributeBinding)attr)) {
                this.toggleBooleanValue(new ResultSetCellLocation(attr, row, this.getRowNestedIndexes(cell.row)), value);
            }
        } else if (this.isAttributeExpandable(cell.row, (DBSAttributeBase)attr)) {
            this.spreadsheet.toggleCellValue(cell.col, cell.row);
        } else if (DBUtils.isNullValue((Object)value)) {
            UIUtils.showMessageBox((Shell)this.getSpreadsheet().getShell(), (String)"Wrong link", (String)"Can't navigate to NULL value", (int)1);
        } else {
            IGridContentProvider.CellInformation cellInfo = this.spreadsheet.getContentProvider().getCellInfo(cell.col, cell.row, false);
            if ((cellInfo.state & 2) != 0) {
                String strValue = attr.getValueHandler().getValueDisplayString((DBSTypedObject)attr, value, DBDDisplayFormat.UI);
                if (SpreadsheetPresentation.isHyperlinkText(strValue)) {
                    ShellUtils.launchProgram((String)strValue);
                } else {
                    EditTextDialog dialog = new EditTextDialog(this.getSpreadsheet().getShell(), attr.getName(), strValue, true);
                    dialog.open();
                }
            } else {
                this.spreadsheet.getCellRenderer().executeHintAction(cell.row, cell.col, cellInfo, x, y, state);
            }
        }
    }

    public void toggleCellValue(IGridColumn columnElement, IGridRow rowElement) {
        Object cellValue;
        DBDAttributeBinding attr = this.getAttributeFromGrid(columnElement, rowElement);
        ResultSetRow row = this.getResultRowFromGrid(columnElement, rowElement);
        ResultSetCellLocation cellLocation = new ResultSetCellLocation(attr, row, this.getRowNestedIndexes(rowElement));
        if (this.isShowAsCheckbox(attr) && ((cellValue = this.controller.getModel().getCellValue(cellLocation)) instanceof Boolean || cellValue instanceof Number || cellValue == null)) {
            this.toggleBooleanValue(cellLocation, cellValue);
        }
        if (this.isAttributeExpandable(rowElement, (DBSAttributeBase)attr)) {
            this.spreadsheet.toggleRowExpand(rowElement, columnElement);
        }
    }

    private void toggleBooleanValue(ResultSetCellLocation cellLocation, Object value) {
        boolean nullable;
        boolean bl = nullable = !cellLocation.getAttribute().isRequired();
        if (value instanceof Number) {
            Number number = (Number)value;
            value = number.byteValue() != 0;
        }
        value = Boolean.TRUE.equals(value) ? Boolean.valueOf(false) : (Boolean.FALSE.equals(value) ? (nullable ? null : Boolean.valueOf(true)) : Boolean.valueOf(true));
        SpreadsheetValueController valueController = new SpreadsheetValueController(this.controller, cellLocation, IValueController.EditType.NONE, null);
        for (ResultSetRow selRow : this.getSelection().getSelectedRows()) {
            valueController.setCurRow(selRow, cellLocation.getRowIndexes());
            valueController.updateValue(value, true);
        }
    }

    @Override
    protected void applyThemeSettings(ITheme currentTheme) {
        this.spreadsheet.setFont(ResultSetThemeSettings.instance.resultSetFont);
        if (this.cellHeaderSelectionBackground != null) {
            UIUtils.dispose((Resource)this.cellHeaderSelectionBackground);
            this.cellHeaderSelectionBackground = null;
        }
        Color headerSelectionBackground = ResultSetThemeSettings.instance.cellHeaderSelectedBackground;
        RGB cellSel = UIUtils.blend((RGB)headerSelectionBackground.getRGB(), (RGB)(UIStyles.isDarkTheme() ? new RGB(100, 100, 100) : new RGB(255, 255, 255)), (int)50);
        this.cellHeaderSelectionBackground = new Color((Device)this.getSpreadsheet().getDisplay(), cellSel);
        this.spreadsheet.setLineColor(ResultSetThemeSettings.instance.lineNormalColor);
        this.spreadsheet.setLineSelectedColor(ResultSetThemeSettings.instance.lineSelectedColor);
        this.spreadsheet.recalculateSizes(true);
        this.booleanStyles = BooleanStyleSet.getDefaultStyles((DBPPreferenceStore)this.getPreferenceStore());
        this.colorizeDataTypes = this.getPreferenceStore().getBoolean("resultset.show.colorizeDataTypes");
        this.dataTypesForegrounds.put(DBPDataKind.BINARY, ResultSetThemeSettings.instance.dtBinaryColor);
        this.dataTypesForegrounds.put(DBPDataKind.BOOLEAN, ResultSetThemeSettings.instance.dtBooleanColor);
        this.dataTypesForegrounds.put(DBPDataKind.DATETIME, ResultSetThemeSettings.instance.dtDateTimeColor);
        this.dataTypesForegrounds.put(DBPDataKind.NUMERIC, ResultSetThemeSettings.instance.dtNumericColor);
        this.dataTypesForegrounds.put(DBPDataKind.STRING, ResultSetThemeSettings.instance.dtStringColor);
    }

    private boolean supportsDataFilter() {
        DBSDataContainer dataContainer = this.controller.getDataContainer();
        return dataContainer != null && dataContainer.isFeatureSupported("data.filter");
    }

    public void changeSorting(Object columnElement, int state) {
        if (columnElement == null) {
            this.columnOrder = this.columnOrder == -1 ? 128 : (this.columnOrder == 128 ? 1024 : -1);
            this.spreadsheet.refreshData(false, true, false);
            this.spreadsheet.redrawGrid();
            return;
        }
        boolean ctrlPressed = (state & 0x40000) == 262144;
        boolean altPressed = (state & 0x10000) == 65536;
        this.controller.toggleSortOrder((DBDAttributeBinding)columnElement, ctrlPressed ? IResultSetController.ColumnOrder.ASC : (altPressed ? IResultSetController.ColumnOrder.DESC : null));
    }

    /*
     * WARNING - void declaration
     */
    void handleColumnIconClick(Object columnElement) {
        void attributeBinding;
        if (!(columnElement instanceof DBDAttributeBinding)) {
            log.debug((Object)("Unable to show distinct filter for columnElement" + String.valueOf(columnElement)));
            return;
        }
        DBDAttributeBinding dBDAttributeBinding = (DBDAttributeBinding)columnElement;
        this.controller.showColumnMenu((DBDAttributeBinding)attributeBinding);
    }

    public DBPPreferenceStore getPreferenceStore() {
        return this.controller.getPreferenceStore();
    }

    public <T> T getAdapter(@NotNull Class<T> adapter) {
        if (adapter == IPropertySheetPage.class) {
            PropertyPageStandard page = new PropertyPageStandard();
            page.setPropertySourceProvider(object -> {
                if (object instanceof GridCell) {
                    GridCell cell = (GridCell)object;
                    DBDAttributeBinding attr = this.getAttributeFromGrid(cell.col, cell.row);
                    ResultSetRow row = this.getResultRowFromGrid(cell.col, cell.row);
                    SpreadsheetValueController valueController = new SpreadsheetValueController(this.controller, new ResultSetCellLocation(attr, row, this.getRowNestedIndexes(cell.row)), IValueController.EditType.NONE, null);
                    PropertyCollector props = new PropertyCollector((Object)valueController.getBinding().getAttribute(), false);
                    props.collectProperties();
                    valueController.getValueManager().contributeProperties((DBPPropertyManager)props, valueController);
                    return new PropertySourceDelegate((DBPPropertySource)props);
                }
                return null;
            });
            return adapter.cast(page);
        }
        if (adapter == IFindReplaceTarget.class) {
            return adapter.cast(SpreadsheetFindReplaceTarget.getInstance().owned(this));
        }
        return null;
    }

    @Override
    @Nullable
    public DBDAttributeBinding getFocusAttribute() {
        IGridItem gridItem = this.controller.isRecordMode() ? this.spreadsheet.getFocusRow() : this.spreadsheet.getFocusColumn();
        while (gridItem != null) {
            Object object = gridItem.getElement();
            if (object instanceof DBDAttributeBinding) {
                DBDAttributeBinding ab = (DBDAttributeBinding)object;
                return ab;
            }
            gridItem = gridItem.getParent();
        }
        return null;
    }

    @Nullable
    public ResultSetRow getFocusRow() {
        return this.controller.isRecordMode() ? (ResultSetRow)this.spreadsheet.getFocusColumnElement() : (ResultSetRow)this.spreadsheet.getFocusRowElement();
    }

    public int getHighlightScopeFirstLine() {
        return this.highlightScopeFirstLine;
    }

    public int getHighlightScopeLastLine() {
        return this.highlightScopeLastLine;
    }

    public SpreadsheetSelectionImpl getSelection() {
        return new SpreadsheetSelectionImpl();
    }

    @Override
    public void setSelection(ISelection selection) {
        this.setSelection(selection, true);
    }

    @Override
    public void setSelection(@NotNull ISelection selection, boolean reflect) {
        IResultSetSelection rss;
        if (selection instanceof IResultSetSelection && (rss = (IResultSetSelection)selection).getController() == this.getController()) {
            return;
        }
        this.spreadsheet.deselectAll();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            ArrayList<GridPos> cellSelection = new ArrayList<GridPos>();
            for (Object cell : ss) {
                if (cell instanceof GridPos) {
                    GridPos gp = (GridPos)cell;
                    cellSelection.add(gp);
                    continue;
                }
                log.warn((Object)("Bad selection object: " + String.valueOf(cell)));
            }
            this.spreadsheet.selectCells(cellSelection);
            this.spreadsheet.showSelection();
        }
        if (reflect) {
            this.fireSelectionChanged(selection);
        }
    }

    public boolean shiftColumns(@NotNull List<Object> columns, int delta) {
        if (delta == 0) {
            return false;
        }
        DBDDataFilter dataFilter = new DBDDataFilter(this.controller.getModel().getDataFilter());
        ArrayList<DBDAttributeConstraint> constraintsToMove = new ArrayList<DBDAttributeConstraint>(columns.size());
        int pinnedAttrsCount = 0;
        int normalAttrsCount = 0;
        for (Object column : columns) {
            if (column instanceof DBDAttributeBinding) {
                DBDAttributeConstraint attrConstraint = dataFilter.getConstraint((DBDAttributeBinding)column);
                if (attrConstraint != null) {
                    constraintsToMove.add(attrConstraint);
                    if (attrConstraint.hasOption("pinned")) {
                        ++pinnedAttrsCount;
                        continue;
                    }
                    ++normalAttrsCount;
                    continue;
                }
                return false;
            }
            return false;
        }
        if (pinnedAttrsCount != 0 && normalAttrsCount != 0) {
            return false;
        }
        boolean pin = pinnedAttrsCount > 0;
        int order = delta > 0 ? -1 : 1;
        constraintsToMove.sort((a, b) -> Integer.compare(SpreadsheetPresentation.getConstraintPosition(a, pin), SpreadsheetPresentation.getConstraintPosition(b, pin)) * order);
        List<DBDAttributeConstraint> allConstraints = SpreadsheetPresentation.getOrderedConstraints(dataFilter, pin);
        int leftmostIndex = constraintsToMove.stream().mapToInt(c -> SpreadsheetPresentation.getConstraintPosition(c, pin)).min().getAsInt();
        int rightmostIndex = constraintsToMove.stream().mapToInt(c -> SpreadsheetPresentation.getConstraintPosition(c, pin)).max().getAsInt();
        if (delta < 0 && leftmostIndex + delta < 0 || delta > 0 && rightmostIndex + delta >= allConstraints.size()) {
            return false;
        }
        for (DBDAttributeConstraint constraint : constraintsToMove) {
            int oldIndex = SpreadsheetPresentation.getConstraintPosition(constraint, pin);
            int newIndex = oldIndex + delta;
            allConstraints.remove(constraint);
            allConstraints.add(newIndex, constraint);
        }
        int i = 0;
        while (i < allConstraints.size()) {
            SpreadsheetPresentation.setConstraintPosition(allConstraints.get(i), pin, i);
            ++i;
        }
        this.controller.setDataFilter(dataFilter, false);
        this.spreadsheet.refreshData(false, true, false);
        return true;
    }

    @Override
    public void moveColumn(Object dragColumn, Object dropColumn, IGridController.DropLocation location) {
        if (dragColumn instanceof DBDAttributeBinding) {
            DBDAttributeBinding dragBinding = (DBDAttributeBinding)dragColumn;
            if (dropColumn instanceof DBDAttributeBinding) {
                DBDAttributeBinding dropBinding = (DBDAttributeBinding)dropColumn;
                DBDDataFilter dataFilter = new DBDDataFilter(this.controller.getModel().getDataFilter());
                DBDAttributeConstraint dragC = dataFilter.getConstraint(dragBinding);
                DBDAttributeConstraint dropC = dataFilter.getConstraint(dropBinding);
                if (dragC == null || dropC == null) {
                    return;
                }
                boolean pin = dragC.hasOption("pinned") && dropC.hasOption("pinned");
                int sourcePosition = SpreadsheetPresentation.getConstraintPosition(dragC, pin);
                int targetPosition = SpreadsheetPresentation.getConstraintPosition(dropC, pin);
                switch (location) {
                    case DROP_AFTER: {
                        if (sourcePosition <= targetPosition || targetPosition >= dataFilter.getConstraints().size() - 1) break;
                        ++targetPosition;
                        break;
                    }
                    case DROP_BEFORE: {
                        if (sourcePosition >= targetPosition || targetPosition <= 0) break;
                        --targetPosition;
                        break;
                    }
                    case SWAP: {
                        SpreadsheetPresentation.setConstraintPosition(dropC, pin, sourcePosition);
                        SpreadsheetPresentation.setConstraintPosition(dragC, pin, targetPosition);
                    }
                }
                if (sourcePosition == targetPosition) {
                    return;
                }
                if (location != IGridController.DropLocation.SWAP) {
                    List<DBDAttributeConstraint> constraints = SpreadsheetPresentation.getOrderedConstraints(dataFilter, pin);
                    if (sourcePosition < targetPosition) {
                        int i = sourcePosition + 1;
                        while (i <= targetPosition) {
                            SpreadsheetPresentation.setConstraintPosition(constraints.get(i), pin, i - 1);
                            ++i;
                        }
                    } else {
                        int i = sourcePosition - 1;
                        while (i >= targetPosition) {
                            SpreadsheetPresentation.setConstraintPosition(constraints.get(i), pin, i + 1);
                            --i;
                        }
                    }
                    SpreadsheetPresentation.setConstraintPosition(dragC, pin, targetPosition);
                }
                this.controller.setDataFilter(dataFilter, false);
                this.spreadsheet.setFocusColumn(targetPosition);
                this.spreadsheet.refreshData(false, true, false);
            }
        }
    }

    private static int getConstraintPosition(@NotNull DBDAttributeConstraint constraint, boolean pin) {
        if (pin) {
            return (Integer)constraint.getOption("pinned");
        }
        return constraint.getVisualPosition();
    }

    private static void setConstraintPosition(@NotNull DBDAttributeConstraint constraint, boolean pin, int position) {
        if (pin) {
            constraint.setOption("pinned", (Object)position);
        } else {
            constraint.setVisualPosition(position);
        }
    }

    @NotNull
    private static List<DBDAttributeConstraint> getOrderedConstraints(@NotNull DBDDataFilter filter, boolean pin) {
        List constraints = filter.getConstraints();
        if (pin) {
            return constraints.stream().filter(x -> x.hasOption("pinned")).sorted(Comparator.comparing(x -> (Comparable)x.getOption("pinned"))).collect(Collectors.toList());
        }
        return constraints.stream().sorted(Comparator.comparing(DBDAttributeConstraintBase::getVisualPosition)).collect(Collectors.toList());
    }

    @Override
    public boolean isMaximizeSingleColumn() {
        return this.controller.isRecordMode();
    }

    public Color getBackgroundDeleted() {
        return ResultSetThemeSettings.instance.backgroundDeleted;
    }

    public Color getBackgroundModified() {
        return ResultSetThemeSettings.instance.backgroundModified;
    }

    private DBDAttributeBinding getAttributeFromGrid(IGridColumn colObject, IGridRow rowObject) {
        if (this.controller.isRecordMode()) {
            if (rowObject == null) {
                return null;
            }
            Object object = rowObject.getElement();
            if (object instanceof DBDAttributeBinding) {
                DBDAttributeBinding attr = (DBDAttributeBinding)object;
                return attr;
            }
            Object object2 = rowObject.getElement();
            if (object2 instanceof DBSAttributeBase) {
                DBSAttributeBase attr = (DBSAttributeBase)object2;
                IGridRow pr = rowObject.getParent();
                while (pr != null) {
                    DBDAttributeBindingType bt;
                    DBDAttributeBinding ab;
                    Object object3 = pr.getElement();
                    if (object3 instanceof DBDAttributeBindingType && (ab = (DBDAttributeBinding)DBUtils.findObject((Collection)(bt = (DBDAttributeBindingType)object3).getNestedBindings(), (String)attr.getName())) != null) {
                        return ab;
                    }
                    pr = pr.getParent();
                }
                return this.controller.getModel().getAttributeBinding(attr);
            }
            if (rowObject.getParent() != null) {
                return this.getAttributeFromGrid(colObject, rowObject.getParent());
            }
            return null;
        }
        return colObject == null ? null : (DBDAttributeBinding)colObject.getElement();
    }

    private ResultSetRow getResultRowFromGrid(IGridColumn colObject, IGridRow rowObject) {
        if (this.controller.isRecordMode()) {
            return colObject == null ? null : (ResultSetRow)colObject.getElement();
        }
        return rowObject == null ? null : (ResultSetRow)rowObject.getElement();
    }

    private boolean isAttributeExpandable(@Nullable IGridRow row, @NotNull DBSAttributeBase attr) {
        if (attr.getDataKind() == DBPDataKind.STRUCT && this.controller.isRecordMode()) {
            return true;
        }
        if (attr instanceof DBDAttributeBinding) {
            DBDAttributeBinding binding;
            DBDAttributeBinding cur = binding = (DBDAttributeBinding)attr;
            while (cur != null) {
                DBPDataKind kind = cur.getDataKind();
                if (kind == DBPDataKind.ARRAY) {
                    return true;
                }
                cur = cur.getParentObject();
            }
        }
        return false;
    }

    private boolean isSimpleAttribute(DBDAttributeBinding attr) {
        DBDRowIdentifier rowIdentifier = attr.getRowIdentifier();
        return CommonUtils.isEmpty((Collection)attr.getReferrers()) && (rowIdentifier == null || !rowIdentifier.hasAttribute(attr) || rowIdentifier.getUniqueKey().getConstraintType() != DBSEntityConstraintType.PRIMARY_KEY);
    }

    private static boolean isHyperlinkText(String strValue) {
        return strValue.startsWith("http://") || strValue.startsWith("https://");
    }

    public ResultSetCellLocation getCurrentCellLocation() {
        DBDAttributeBinding currentAttribute = this.getCurrentAttribute();
        ResultSetRow currentRow = this.getController().getCurrentRow();
        IGridRow focusRow = this.spreadsheet.getFocusRow();
        return new ResultSetCellLocation(currentAttribute, currentRow, this.getRowNestedIndexes(focusRow));
    }

    public ResultSetCellLocation getCellLocation(GridCell cell) {
        boolean recordMode = this.getController().isRecordMode();
        DBDAttributeBinding attr = (DBDAttributeBinding)(recordMode ? cell.row.getElement() : cell.col.getElement());
        ResultSetRow row = (ResultSetRow)(recordMode ? cell.col.getElement() : cell.row.getElement());
        return new ResultSetCellLocation(attr, row, this.getRowNestedIndexes(cell.row));
    }

    @Nullable
    private int[] getRowNestedIndexes(IGridItem gridRow) {
        int[] nestedIndexes = null;
        if (gridRow != null && gridRow.getParent() != null) {
            nestedIndexes = new int[gridRow.getLevel()];
            if (this.controller.isRecordMode()) {
                int lastIndex = nestedIndexes.length;
                IGridItem gr = gridRow;
                while (gr.getParent() != null) {
                    if (this.hasParentArrayRow(gr)) {
                        nestedIndexes[lastIndex - 1] = gr.getRelativeIndex();
                        --lastIndex;
                    }
                    gr = gr.getParent();
                }
                if (lastIndex == nestedIndexes.length) {
                    return null;
                }
                int indexesCount = gridRow.getLevel() - lastIndex;
                if (indexesCount != nestedIndexes.length) {
                    int[] indexesCopy = new int[indexesCount];
                    System.arraycopy(nestedIndexes, lastIndex, indexesCopy, 0, indexesCount);
                    nestedIndexes = indexesCopy;
                }
            } else {
                IGridItem gr = gridRow;
                while (gr.getParent() != null) {
                    nestedIndexes[gr.getLevel() - 1] = gr.getRelativeIndex();
                    gr = gr.getParent();
                }
            }
        }
        return nestedIndexes;
    }

    private boolean hasParentArrayRow(IGridItem item) {
        IGridItem gr = item.getParent();
        while (gr != null) {
            Object object = gr.getElement();
            if (object instanceof DBSTypedObject) {
                DBSTypedObject b = (DBSTypedObject)object;
                return b.getDataKind() == DBPDataKind.ARRAY;
            }
            if (gr.getElement() instanceof DBDComposite) {
                return false;
            }
            gr = gr.getParent();
        }
        return false;
    }

    private DBDDisplayFormat getValueRenderFormat(DBDAttributeBinding attr, Object value) {
        if (value instanceof Number && this.useNativeNumbersFormat) {
            return DBDDisplayFormat.NATIVE;
        }
        return this.gridValueFormat;
    }

    @Override
    public DBDDisplayFormat getDefaultDisplayFormat() {
        return this.gridValueFormat;
    }

    @Override
    public void setDefaultDisplayFormat(DBDDisplayFormat displayFormat) {
        this.gridValueFormat = displayFormat;
        this.getPreferenceStore().setValue("resultset.grid.value.format", this.gridValueFormat.name());
    }

    private boolean isShowAsCheckbox(DBDAttributeBinding attr) {
        return this.showBooleanAsCheckbox && attr.getPresentationAttribute().getDataKind() == DBPDataKind.BOOLEAN;
    }

    private boolean isShowAsCollection(@NotNull IGridRow row, @NotNull IGridColumn column, @Nullable Object value) {
        DBDCollection collection;
        return value instanceof DBDCollection && !(collection = (DBDCollection)value).isNull() && (collection.isEmpty() || this.spreadsheet.isCellExpanded(row, column));
    }

    private class ContentProvider
    implements IGridContentProvider {
        private ContentProvider() {
        }

        @Override
        @NotNull
        public Object[] getElements(boolean horizontal) {
            boolean recordMode = SpreadsheetPresentation.this.controller.isRecordMode();
            ResultSetModel model = SpreadsheetPresentation.this.controller.getModel();
            if (horizontal) {
                if (!recordMode) {
                    return model.getVisibleAttributes().toArray();
                }
                int[] selectedRecords = SpreadsheetPresentation.this.controller.getSelectedRecords();
                ArrayList<ResultSetRow> rows = new ArrayList<ResultSetRow>(selectedRecords.length);
                int i = 0;
                while (i < selectedRecords.length) {
                    if (selectedRecords[i] < SpreadsheetPresentation.this.controller.getModel().getRowCount()) {
                        rows.add(SpreadsheetPresentation.this.controller.getModel().getRow(selectedRecords[i]));
                    }
                    ++i;
                }
                return rows.toArray();
            }
            if (!recordMode) {
                return model.getAllRows().toArray();
            }
            Object[] columns = model.getVisibleAttributes().toArray(new DBDAttributeBinding[model.getVisibleAttributeCount()]);
            if (SpreadsheetPresentation.this.columnOrder != 0 && SpreadsheetPresentation.this.columnOrder != -1) {
                Arrays.sort(columns, (o1, o2) -> o1.getName().compareTo(o2.getName()) * (SpreadsheetPresentation.this.columnOrder == 128 ? 1 : -1));
            }
            return columns;
        }

        @Override
        public boolean hasChildren(@NotNull IGridItem item) {
            Object object = item.getElement();
            if (object instanceof DBSAttributeBase) {
                DBSAttributeBase attr = (DBSAttributeBase)object;
                return switch (attr.getDataKind()) {
                    case DBPDataKind.DOCUMENT, DBPDataKind.ANY -> {
                        if (SpreadsheetPresentation.this.controller.isRecordMode()) {
                            yield false;
                        }
                        yield true;
                    }
                    default -> SpreadsheetPresentation.this.isAttributeExpandable(null, attr);
                };
            }
            return SpreadsheetPresentation.this.controller.isRecordMode() && item.getElement() instanceof DBDComplexValue;
        }

        @Override
        @Nullable
        public Object[] getChildren(@NotNull IGridItem item) {
            block10: {
                block9: {
                    Object object = item.getElement();
                    if (!(object instanceof DBDAttributeBinding)) break block9;
                    DBDAttributeBinding binding = (DBDAttributeBinding)object;
                    if (SpreadsheetPresentation.this.controller.isRecordMode() && binding.getDataKind() == DBPDataKind.ARRAY && SpreadsheetPresentation.this.controller.getCurrentRow() != null) {
                        Object cellValue = SpreadsheetPresentation.this.controller.getModel().getCellValue(binding, SpreadsheetPresentation.this.controller.getCurrentRow(), SpreadsheetPresentation.this.getRowNestedIndexes(item), false);
                        if (cellValue instanceof Collection) {
                            Collection col = (Collection)cellValue;
                            return col.toArray();
                        }
                        if (cellValue instanceof DBDComposite) {
                            return null;
                        }
                        return null;
                    }
                    switch (binding.getDataKind()) {
                        case STRUCT: 
                        case DOCUMENT: 
                        case ARRAY: 
                        case ANY: {
                            List<DBDAttributeBinding> children = SpreadsheetPresentation.this.controller.getModel().getVisibleAttributes(binding);
                            if (!CommonUtils.isEmpty(children)) {
                                return children.toArray();
                            } else {
                                break;
                            }
                        }
                    }
                    break block10;
                }
                Object object = item.getElement();
                if (object instanceof Collection) {
                    Collection col = (Collection)object;
                    return col.toArray();
                }
                Object object2 = item.getElement();
                if (object2 instanceof DBDComposite) {
                    DBDComposite composite = (DBDComposite)object2;
                    return composite.getAttributes();
                }
            }
            return null;
        }

        @Override
        public int getCollectionSize(@NotNull IGridColumn colElement, @NotNull IGridRow rowElement) {
            ResultSetRow row = SpreadsheetPresentation.this.getResultRowFromGrid(colElement, rowElement);
            DBDAttributeBinding attr = SpreadsheetPresentation.this.getAttributeFromGrid(colElement, rowElement);
            int[] nestedIndexes = SpreadsheetPresentation.this.getRowNestedIndexes(rowElement);
            ResultSetCellLocation cellLocation = new ResultSetCellLocation(attr, row, nestedIndexes);
            Object cellValue = SpreadsheetPresentation.this.controller.getModel().getCellValue(cellLocation);
            if (cellValue instanceof List) {
                return ((List)cellValue).size();
            }
            if (cellValue instanceof DBDComposite) {
                DBDComposite composite = (DBDComposite)cellValue;
                if (SpreadsheetPresentation.this.controller.isRecordMode()) {
                    return composite.getAttributeCount();
                }
            }
            return 0;
        }

        @Override
        public int getSortOrder(@Nullable IGridColumn column) {
            Object object;
            if (column != null && (object = column.getElement()) instanceof DBDAttributeBinding) {
                DBDAttributeBinding binding = (DBDAttributeBinding)object;
                if (!binding.hasNestedBindings()) {
                    DBDAttributeConstraint co = SpreadsheetPresentation.this.controller.getModel().getDataFilter().getConstraint(binding);
                    if (co != null && co.getOrderPosition() > 0) {
                        return co.isOrderDescending() ? 1024 : 128;
                    }
                    return -1;
                }
            } else if (column == null && SpreadsheetPresentation.this.controller.isRecordMode()) {
                return SpreadsheetPresentation.this.columnOrder;
            }
            return 0;
        }

        @Override
        public IGridContentProvider.ElementState getDefaultState(@NotNull IGridColumn element) {
            Object object = element.getElement();
            if (object instanceof DBDAttributeBinding) {
                DBDAttributeBinding binding = (DBDAttributeBinding)object;
                switch (binding.getAttribute().getDataKind()) {
                    case STRUCT: 
                    case DOCUMENT: 
                    case ANY: {
                        return IGridContentProvider.ElementState.EXPANDED;
                    }
                    case ARRAY: {
                        Object cellValue;
                        ResultSetRow curRow = SpreadsheetPresentation.this.controller.getCurrentRow();
                        if (curRow == null || !((cellValue = SpreadsheetPresentation.this.controller.getModel().getCellValue(new ResultSetCellLocation(binding, curRow))) instanceof List)) break;
                        if (((List)cellValue).size() < 3) {
                            return IGridContentProvider.ElementState.EXPANDED;
                        }
                        if (DBUtils.isNullValue((Object)cellValue)) break;
                        return IGridContentProvider.ElementState.COLLAPSED;
                    }
                }
            }
            return IGridContentProvider.ElementState.NONE;
        }

        @Override
        public IGridStatusColumn[] getStatusColumns() {
            return new IGridStatusColumn[]{new IGridStatusColumn(){

                @Override
                public String getDisplayName() {
                    return ResultSetMessages.controls_resultset_results_read_only_status;
                }

                @Override
                public String getStatusText() {
                    return SpreadsheetPresentation.this.getController().getReadOnlyStatus();
                }

                @Override
                public DBPImage getStatusIcon() {
                    if (SpreadsheetPresentation.this.getController().getReadOnlyStatus() != null) {
                        return UIIcon.BUTTON_READ_ONLY;
                    }
                    return null;
                }
            }, new IGridStatusColumn(){

                @Override
                public String getDisplayName() {
                    return ResultSetMessages.controls_resultset_results_edit_key;
                }

                @Override
                public String getStatusText() {
                    DBDRowIdentifier rowIdentifier = SpreadsheetPresentation.this.getController().getModel().getDefaultRowIdentifier();
                    if (rowIdentifier != null && !rowIdentifier.isIncomplete()) {
                        return rowIdentifier.getUniqueKey().getConstraintType().getName() + " " + rowIdentifier.getAttributes().stream().map(DBDAttributeBinding::getName).collect(Collectors.joining(","));
                    }
                    DBSDataContainer dataContainer = SpreadsheetPresentation.this.getController().getDataContainer();
                    if (dataContainer instanceof DBSEntity && !dataContainer.isFeatureSupported("data.update")) {
                        return "Data modification is not supported by database.";
                    }
                    if (rowIdentifier == null) {
                        return "Table metadata not found. Data edit is not possible.";
                    }
                    if (rowIdentifier.isIncomplete()) {
                        return "No unique key was found. Data modification is not possible.";
                    }
                    return "Virtual key is used";
                }

                @Override
                public DBPImage getStatusIcon() {
                    DBDRowIdentifier rowIdentifier = SpreadsheetPresentation.this.getController().getModel().getDefaultRowIdentifier();
                    if (rowIdentifier == null) {
                        return ResultSetIcons.META_TABLE_NA;
                    }
                    if (rowIdentifier.isIncomplete()) {
                        return ResultSetIcons.META_KEY_NA;
                    }
                    if (rowIdentifier.getUniqueKey() instanceof DBVEntityConstraint) {
                        return ResultSetIcons.META_KEY_VIRTUAL;
                    }
                    return ResultSetIcons.META_KEY_OK;
                }
            }};
        }

        @Override
        public boolean isVoidCell(IGridColumn gridColumn, IGridRow gridRow) {
            return this.getCellValue(gridColumn, gridRow, false) == DBDVoid.INSTANCE;
        }

        @Override
        public int getColumnPinIndex(@NotNull IGridColumn element) {
            if (!SpreadsheetPresentation.this.controller.isRecordMode()) {
                DBDAttributeBinding attr = (DBDAttributeBinding)element.getElement();
                DBDAttributeConstraint ac = SpreadsheetPresentation.this.controller.getModel().getDataFilter().getConstraint(attr);
                if (ac != null) {
                    Integer pinIndex = (Integer)ac.getOption("pinned");
                    return pinIndex == null ? -1 : pinIndex;
                }
            }
            return -1;
        }

        @Override
        public boolean isElementSupportsFilter(IGridColumn element) {
            if (element != null && element.getElement() instanceof DBDAttributeBinding) {
                return SpreadsheetPresentation.this.supportsAttributeFilter;
            }
            return false;
        }

        @Override
        public boolean isElementSupportsSort(@Nullable IGridColumn element) {
            if (element != null && element.getElement() instanceof DBDAttributeBinding) {
                return SpreadsheetPresentation.this.showAttrOrdering;
            }
            return false;
        }

        @Override
        public boolean isElementReadOnly(@NotNull IGridColumn element) {
            Object object = element.getElement();
            if (object instanceof DBDAttributeBinding) {
                DBDAttributeBinding binding = (DBDAttributeBinding)object;
                return SpreadsheetPresentation.this.controller.getAttributeReadOnlyStatus(binding, true, false) != null;
            }
            return false;
        }

        @Override
        public boolean isElementExpandable(@NotNull IGridItem item) {
            if (item instanceof IGridRow) {
                IGridRow row = (IGridRow)item;
                return this.hasExpandableElements(row);
            }
            return false;
        }

        private boolean hasExpandableElements(@NotNull IGridRow row) {
            int i = 0;
            while (i < SpreadsheetPresentation.this.spreadsheet.getColumnCount()) {
                Object cellValue = this.getCellValue(SpreadsheetPresentation.this.spreadsheet.getColumn(i), row, false);
                if (cellValue instanceof DBDComplexValue) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        @Override
        public boolean isGridReadOnly() {
            return SpreadsheetPresentation.this.controller.isAllAttributesReadOnly();
        }

        @Override
        public void validateDataPresence(IGridColumn gridColumn, IGridRow gridRow) {
            ResultSetRow row = SpreadsheetPresentation.this.getResultRowFromGrid(gridColumn, gridRow);
            int rowNum = row.getVisualNumber();
            if (!(rowNum <= 0 || rowNum != SpreadsheetPresentation.this.controller.getModel().getRowCount() - 1 || !SpreadsheetPresentation.this.autoFetchSegments || SpreadsheetPresentation.this.controller.isRefreshInProgress() || SpreadsheetPresentation.this.controller.getContainer().getDataContainer() != null && SpreadsheetPresentation.this.controller.getContainer().getDataContainer().isFeatureSupported("data.modifying") || SpreadsheetPresentation.this.getPreferenceStore().getInt("resultset.maxrows") < SpreadsheetPresentation.this.getSpreadsheet().getMaxVisibleRows() || !SpreadsheetPresentation.this.controller.isRecordMode() && !SpreadsheetPresentation.this.spreadsheet.isRowVisible(rowNum))) {
                SpreadsheetPresentation.this.controller.readNextSegment();
            }
        }

        @Override
        @NotNull
        public IGridContentProvider.CellInformation getCellInfo(@NotNull IGridColumn colElement, @NotNull IGridRow rowElement, boolean selected) {
            Object cellValue;
            DBDAttributeBinding attr = SpreadsheetPresentation.this.getAttributeFromGrid(colElement, rowElement);
            ResultSetRow row = SpreadsheetPresentation.this.getResultRowFromGrid(colElement, rowElement);
            IGridContentProvider.CellInformation info = new IGridContentProvider.CellInformation();
            info.value = cellValue = row == null || attr == null ? null : this.getCellValue(colElement, rowElement, false);
            info.text = this.formatValue(colElement, rowElement, info.value);
            info.state = 0;
            if (attr != null && cellValue != DBDVoid.INSTANCE) {
                if ((SpreadsheetPresentation.this.controller.getDecorator().getDecoratorFeatures() & 0x20L) != 0L) {
                    DBDCollection col;
                    if (SpreadsheetPresentation.this.isShowAsCheckbox(attr)) {
                        info.state |= 0x80;
                        info.state = info.state | (SpreadsheetPresentation.this.booleanStyles.getMode() == BooleanMode.TEXT ? 8 : 1);
                    } else if (cellValue instanceof DBDCollection && !(col = (DBDCollection)cellValue).isEmpty() || cellValue instanceof DBDComposite && SpreadsheetPresentation.this.controller.isRecordMode()) {
                        if (!DBUtils.isNullValue((Object)cellValue)) {
                            info.state |= 1;
                        }
                    } else {
                        String strValue;
                        String string = strValue = info.text != null ? info.text.toString() : attr.getValueHandler().getValueDisplayString((DBSTypedObject)attr, cellValue, DBDDisplayFormat.UI);
                        if (strValue != null && SpreadsheetPresentation.isHyperlinkText(strValue)) {
                            try {
                                new URL(strValue);
                                info.state |= 2;
                            }
                            catch (MalformedURLException malformedURLException) {}
                        }
                    }
                }
                if (SpreadsheetPresentation.this.showWhitespaceCharacters) {
                    info.state |= 0x10;
                }
                if (attr.isTransformed()) {
                    info.state |= 4;
                }
            }
            info.align = CommonUtils.isBitSet((int)info.state, (int)1) && !CommonUtils.isBitSet((int)info.state, (int)128) ? 0 : this.getCellAlign(attr, row, cellValue);
            if (attr != null && cellValue != DBDVoid.INSTANCE) {
                Collection col;
                DBDComplexValue cv;
                if (SpreadsheetPresentation.this.booleanStyles.getMode() != BooleanMode.TEXT && SpreadsheetPresentation.this.isShowAsCheckbox(attr)) {
                    if (cellValue instanceof Number) {
                        cellValue = ((Number)cellValue).byteValue() != 0;
                    }
                    if (cellValue instanceof Boolean || cellValue == null) {
                        info.image = SpreadsheetPresentation.this.booleanStyles.getStyle((Boolean)cellValue).getIcon();
                    }
                }
                if (!(info.image != null || !(cellValue instanceof DBDComplexValue) || (cv = (DBDComplexValue)cellValue).isNull() || cellValue instanceof Collection && (col = (Collection)cellValue).isEmpty())) {
                    GridCell cell = new GridCell(colElement, rowElement);
                    boolean cellExpanded = SpreadsheetPresentation.this.spreadsheet.isCellExpanded(cell);
                    info.state = info.state | (cellExpanded ? 32 : 64);
                    info.image = cellExpanded ? UIIcon.TREE_COLLAPSE : UIIcon.TREE_EXPAND;
                }
            }
            info.background = this.getCellBackground(attr, row, cellValue, rowElement.getVisualPosition(), selected, false);
            info.foreground = this.getCellForeground(attr, row, cellValue, info.background, selected);
            if (row != null && attr != null && SpreadsheetPresentation.this.isShowAsCheckbox(attr)) {
                if (cellValue instanceof Number) {
                    cellValue = ((Number)cellValue).byteValue() != 0;
                }
                if ((DBUtils.isNullValue((Object)cellValue) || cellValue instanceof Boolean) && SpreadsheetPresentation.this.booleanStyles.getMode() != BooleanMode.ICON) {
                    info.font = SpreadsheetPresentation.this.spreadsheet.getFont(SpreadsheetPresentation.this.booleanStyles.getStyle((Boolean)cellValue).getFontStyle());
                }
            }
            return info;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        @Override
        @Nullable
        public Object getCellValue(IGridColumn gridColumn, IGridRow gridRow, boolean formatString) {
            Object value = this.getCellValue(gridColumn, gridRow, SpreadsheetPresentation.this.getRowNestedIndexes(gridRow), false);
            if (formatString) {
                return this.formatValue(gridColumn, gridRow, value);
            }
            return value;
        }

        @Nullable
        public Object getCellValue(@NotNull IGridColumn gridColumn, @NotNull IGridRow gridRow, @Nullable int[] rowIndexes, boolean retrieveDeepestCollectionElement) {
            if (gridRow.getParent() != null && !SpreadsheetPresentation.this.spreadsheet.isCellExpanded(gridRow.getParent(), gridColumn)) {
                return DBDVoid.INSTANCE;
            }
            DBDAttributeBinding attr = SpreadsheetPresentation.this.getAttributeFromGrid(gridColumn, gridRow);
            ResultSetRow row = SpreadsheetPresentation.this.getResultRowFromGrid(gridColumn, gridRow);
            if (attr == null || row == null) {
                return null;
            }
            return SpreadsheetPresentation.this.controller.getModel().getCellValue(attr, row, rowIndexes, retrieveDeepestCollectionElement);
        }

        @Nullable
        private Object formatValue(@NotNull IGridColumn gridColumn, @NotNull IGridRow gridRow, @Nullable Object value) {
            DBDCollection collection;
            String defaultValue;
            DBSEntityAttribute entityAttribute;
            DBDAttributeBinding attr = SpreadsheetPresentation.this.getAttributeFromGrid(gridColumn, gridRow);
            ResultSetRow row = SpreadsheetPresentation.this.getResultRowFromGrid(gridColumn, gridRow);
            if (attr == null || row == null) {
                return null;
            }
            if (DBUtils.isNullValue((Object)value) && row.getState() == 2 && (entityAttribute = attr.getEntityAttribute()) != null && (defaultValue = entityAttribute.getDefaultValue()) != null && !"NULL".equalsIgnoreCase(defaultValue)) {
                value = defaultValue;
            }
            if (value instanceof DBDValueError) {
                DBDValueError valueError = (DBDValueError)value;
                return valueError.getErrorTitle();
            }
            if ((value instanceof Boolean || value instanceof Number || value == null) && SpreadsheetPresentation.this.isShowAsCheckbox(attr)) {
                if (SpreadsheetPresentation.this.booleanStyles.getMode() != BooleanMode.TEXT) {
                    return "";
                }
                if (value instanceof Number) {
                    value = ((Number)value).byteValue() != 0;
                }
                if (SpreadsheetPresentation.this.booleanStyles.getMode() == BooleanMode.TEXT) {
                    return SpreadsheetPresentation.this.booleanStyles.getStyle((Boolean)value).getText();
                }
                return value;
            }
            if (value instanceof DBDCollection && !(collection = (DBDCollection)value).isNull()) {
                if (SpreadsheetPresentation.this.isShowAsCollection(gridRow, gridColumn, value)) {
                    if (collection.isEmpty()) {
                        return "";
                    }
                    return "[" + collection.size() + "]";
                }
                Object child = this.getCellValue(gridColumn, gridRow, SpreadsheetPresentation.this.getRowNestedIndexes(gridRow), true);
                if (child == value) {
                    return value;
                }
                return this.formatValue(gridColumn, gridRow, child);
            }
            if (value instanceof DBDComposite) {
                DBDComposite composite = (DBDComposite)value;
                if (!DBUtils.isNullValue((Object)value)) {
                    return composite.toString();
                }
            }
            try {
                return attr.getValueRenderer().getValueDisplayString((DBSTypedObject)attr.getAttribute(), value, SpreadsheetPresentation.this.getValueRenderFormat(attr, value));
            }
            catch (Exception e) {
                return new DBDValueError((Throwable)e);
            }
        }

        public int getCellAlign(@Nullable DBDAttributeBinding attr, ResultSetRow row, Object cellValue) {
            if (!SpreadsheetPresentation.this.controller.isRecordMode() && attr != null) {
                if (cellValue instanceof DBDCollection) {
                    return 0;
                }
                if (SpreadsheetPresentation.this.isShowAsCheckbox(attr)) {
                    if (row.getState() == 2) {
                        return 1;
                    }
                    if (cellValue instanceof Number) {
                        Number number = (Number)cellValue;
                        cellValue = number.byteValue() != 0;
                    }
                    if (DBUtils.isNullValue((Object)cellValue) || cellValue instanceof Boolean) {
                        return switch (SpreadsheetPresentation.this.booleanStyles.getStyle((Boolean)cellValue).getAlignment()) {
                            case UIElementAlignment.LEFT -> 0;
                            case UIElementAlignment.CENTER -> 1;
                            case UIElementAlignment.RIGHT -> 2;
                            default -> throw new MatchException(null, null);
                        };
                    }
                }
                DBPDataKind dataKind = attr.getDataKind();
                if ((SpreadsheetPresentation.this.rightJustifyNumbers && dataKind == DBPDataKind.NUMERIC || SpreadsheetPresentation.this.rightJustifyDateTime && dataKind == DBPDataKind.DATETIME) && SpreadsheetPresentation.this.isSimpleAttribute(attr)) {
                    return 2;
                }
            }
            return 0;
        }

        @Nullable
        private Color getCellForeground(DBDAttributeBinding attribute, ResultSetRow row, Object cellValue, Color background, boolean selected) {
            Color color;
            String fg;
            if (selected) {
                Color color2;
                Color fg2 = ResultSetThemeSettings.instance.foregroundSelected;
                if (SpreadsheetPresentation.this.colorizeDataTypes && !DBUtils.isNullValue((Object)cellValue) && (color2 = SpreadsheetPresentation.this.dataTypesForegrounds.get(attribute.getDataKind())) != null) {
                    RGB mixRGB = UIUtils.blend((RGB)fg2.getRGB(), (RGB)color2.getRGB(), (int)15);
                    return UIUtils.getSharedTextColors().getColor(mixRGB);
                }
                return fg2;
            }
            if (SpreadsheetPresentation.this.isShowAsCheckbox(attribute) && SpreadsheetPresentation.this.booleanStyles.getMode() == BooleanMode.TEXT) {
                if (cellValue instanceof Number) {
                    Number number = (Number)cellValue;
                    cellValue = number.byteValue() != 0;
                }
                if (DBUtils.isNullValue((Object)cellValue) || cellValue instanceof Boolean) {
                    return UIUtils.getSharedColor((RGB)SpreadsheetPresentation.this.booleanStyles.getStyle((Boolean)cellValue).getColor());
                }
                return null;
            }
            DBDAttributeDecorator dataLabelProvider = SpreadsheetPresentation.this.getController().getDecorator().getDataLabelProvider();
            if (dataLabelProvider != null && (fg = dataLabelProvider.getCellForeground(attribute, row.getVisualNumber())) != null) {
                return UIUtils.getSharedColor((String)fg);
            }
            if (row.colorInfo != null) {
                Color cellFG;
                if (row.colorInfo.cellFgColors != null && (cellFG = row.colorInfo.cellFgColors[attribute.getOrdinalPosition()]) != null) {
                    return cellFG;
                }
                if (row.colorInfo.rowForeground != null) {
                    return row.colorInfo.rowForeground;
                }
            }
            if (DBUtils.isNullValue((Object)cellValue)) {
                return ResultSetThemeSettings.instance.foregroundNull;
            }
            if (SpreadsheetPresentation.this.colorizeDataTypes && (color = SpreadsheetPresentation.this.dataTypesForegrounds.get(attribute.getDataKind())) != null) {
                return color;
            }
            return UIStyles.getContrastColor((Color)background);
        }

        private Color getCellBackground(DBDAttributeBinding attribute, ResultSetRow row, Object cellValue, int rowPosition, boolean cellSelected, boolean ignoreRowSelection) {
            String bg;
            GridCell sourceCell;
            if (cellValue == DBDVoid.INSTANCE) {
                return ResultSetThemeSettings.instance.cellHeaderBackground;
            }
            if (SpreadsheetPresentation.this.spreadsheet.getCellSelectionSize() == 1 && SpreadsheetPresentation.this.getPreferenceStore().getBoolean("resultset.mark.cell.value.occurrences") && (sourceCell = SpreadsheetPresentation.this.spreadsheet.getCursorCell()) != null) {
                Object sourceValue;
                ResultSetRow sourceRow = SpreadsheetPresentation.this.getResultRowFromGrid(sourceCell.col, sourceCell.row);
                DBDAttributeBinding sourceAttribute = SpreadsheetPresentation.this.getAttributeFromGrid(sourceCell.col, sourceCell.row);
                if ((sourceRow != row || sourceAttribute != attribute) && CommonUtils.equalObjects((Object)(sourceValue = SpreadsheetPresentation.this.spreadsheet.getContentProvider().getCellValue(sourceCell.col, sourceCell.row, false)), (Object)cellValue)) {
                    return ResultSetThemeSettings.instance.backgroundMatched;
                }
            }
            if (cellSelected) {
                Color normalColor = this.getCellBackground(attribute, row, cellValue, rowPosition, false, true);
                if (normalColor == null || normalColor == SpreadsheetPresentation.this.backgroundDefault || SpreadsheetPresentation.this.isHighContrastTheme) {
                    return ResultSetThemeSettings.instance.backgroundSelected;
                }
                RGB mixRGB = UIUtils.blend((RGB)normalColor.getRGB(), (RGB)ResultSetThemeSettings.instance.backgroundSelected.getRGB(), (int)15);
                return UIUtils.getSharedTextColors().getColor(mixRGB);
            }
            SpreadsheetFindReplaceTarget findReplaceTarget = SpreadsheetFindReplaceTarget.getInstance().owned(SpreadsheetPresentation.this);
            if (findReplaceTarget.isSessionActive()) {
                String cellText;
                Pattern searchPattern;
                boolean inScope;
                boolean hasScope = SpreadsheetPresentation.this.highlightScopeFirstLine >= 0 && SpreadsheetPresentation.this.highlightScopeLastLine >= 0;
                boolean bl = inScope = hasScope && rowPosition >= SpreadsheetPresentation.this.highlightScopeFirstLine && rowPosition <= SpreadsheetPresentation.this.highlightScopeLastLine;
                if ((!hasScope || inScope) && (searchPattern = findReplaceTarget.getSearchPattern()) != null && searchPattern.matcher(cellText = CommonUtils.toString((Object)cellValue)).find()) {
                    return ResultSetThemeSettings.instance.backgroundMatched;
                }
                if (!SpreadsheetPresentation.this.controller.isRecordMode() && inScope) {
                    return SpreadsheetPresentation.this.highlightScopeColor != null ? SpreadsheetPresentation.this.highlightScopeColor : ResultSetThemeSettings.instance.backgroundSelected;
                }
            }
            if (!ignoreRowSelection && SpreadsheetPresentation.this.highlightRowsWithSelectedCells && SpreadsheetPresentation.this.spreadsheet.isRowSelected(rowPosition)) {
                RGB mixRGB;
                Color selectedCellColor;
                Color normalColor = this.getCellBackground(attribute, row, cellValue, rowPosition, false, true);
                if (normalColor == null || normalColor == SpreadsheetPresentation.this.backgroundDefault || SpreadsheetPresentation.this.isHighContrastTheme) {
                    selectedCellColor = ResultSetThemeSettings.instance.backgroundSelected;
                } else {
                    mixRGB = UIUtils.blend((RGB)normalColor.getRGB(), (RGB)ResultSetThemeSettings.instance.backgroundSelected.getRGB(), (int)50);
                    selectedCellColor = UIUtils.getSharedTextColors().getColor(mixRGB);
                }
                mixRGB = UIUtils.blend((RGB)selectedCellColor.getRGB(), (RGB)normalColor.getRGB(), (int)25);
                return UIUtils.getSharedTextColors().getColor(mixRGB);
            }
            DBDAttributeDecorator dataLabelProvider = SpreadsheetPresentation.this.getController().getDecorator().getDataLabelProvider();
            if (dataLabelProvider != null && (bg = dataLabelProvider.getCellBackground(attribute, row.getVisualNumber())) != null) {
                return UIUtils.getSharedColor((String)bg);
            }
            switch (row.getState()) {
                case 2: {
                    return ResultSetThemeSettings.instance.backgroundAdded;
                }
                case 3: {
                    return ResultSetThemeSettings.instance.backgroundDeleted;
                }
            }
            if (row.isChanged(attribute)) {
                return ResultSetThemeSettings.instance.backgroundModified;
            }
            if (row.colorInfo != null) {
                Color cellBG;
                if (row.colorInfo.cellBgColors != null && (cellBG = row.colorInfo.cellBgColors[attribute.getOrdinalPosition()]) != null) {
                    return cellBG;
                }
                if (row.colorInfo.rowBackground != null) {
                    return row.colorInfo.rowBackground;
                }
            }
            if (cellValue != null && cellValue.getClass() == DBDValueError.class) {
                return ResultSetThemeSettings.instance.backgroundError;
            }
            if (!SpreadsheetPresentation.this.controller.isRecordMode() && SpreadsheetPresentation.this.showOddRows && !SpreadsheetPresentation.this.isHighContrastTheme) {
                int rowNumber;
                int rowRelativeNumber;
                boolean odd;
                if (SpreadsheetPresentation.this.rowBatchSize < 1) {
                    SpreadsheetPresentation.this.rowBatchSize = 1;
                }
                boolean bl = odd = (rowRelativeNumber = (rowNumber = row.getVisualNumber()) % (SpreadsheetPresentation.this.rowBatchSize * 2)) < SpreadsheetPresentation.this.rowBatchSize;
                if (odd) {
                    return ResultSetThemeSettings.instance.backgroundOdd;
                }
            }
            if (SpreadsheetPresentation.this.backgroundDefault == null) {
                SpreadsheetPresentation.this.backgroundDefault = SpreadsheetPresentation.this.controller.getDefaultBackground();
            }
            return SpreadsheetPresentation.this.backgroundDefault;
        }

        @Override
        @NotNull
        public String getCellLinkText(IGridColumn colElement, IGridRow rowElement) {
            DBDAttributeBinding attr = SpreadsheetPresentation.this.getAttributeFromGrid(colElement, rowElement);
            ResultSetRow row = SpreadsheetPresentation.this.getResultRowFromGrid(colElement, rowElement);
            Object value = SpreadsheetPresentation.this.controller.getModel().getCellValue(new ResultSetCellLocation(attr, row, SpreadsheetPresentation.this.getRowNestedIndexes(rowElement)));
            List<IGridHint> cellHints = this.getCellHints(colElement, rowElement, value, 8);
            if (cellHints != null) {
                for (IGridHint hint : cellHints) {
                    String hintText;
                    if (!hint.hasAction() || (hintText = hint.getActionToolTip()) == null) continue;
                    return hintText;
                }
            }
            return "";
        }

        @Override
        public String getCellToolTip(IGridColumn colElement, IGridRow rowElement) {
            Object cellValue = this.getCellValue(colElement, rowElement, false);
            StringBuilder toolTip = new StringBuilder();
            toolTip.append(this.formatValue(colElement, rowElement, cellValue));
            boolean hasHints = false;
            List<IGridHint> cellHints = this.getCellHints(colElement, rowElement, cellValue, 4);
            if (cellHints != null) {
                for (IGridHint hint : cellHints) {
                    String hintText = hint.getText();
                    if (hintText == null) continue;
                    String hintLabel = hint.getHintLabel();
                    toolTip.append("\n");
                    if (hintLabel != null) {
                        toolTip.append(hintLabel).append(": ");
                    }
                    toolTip.append(hintText);
                    hasHints = true;
                }
            }
            if (hasHints) {
                toolTip.insert(0, "Value: ");
            }
            return toolTip.toString();
        }

        @Override
        public List<IGridHint> getCellHints(IGridColumn colElement, IGridRow rowElement, Object cellValue, int options) {
            DBDAttributeBinding attr = SpreadsheetPresentation.this.getAttributeFromGrid(colElement, rowElement);
            if (attr == null) {
                return null;
            }
            ResultSetRow row = SpreadsheetPresentation.this.getResultRowFromGrid(colElement, rowElement);
            if (row == null) {
                return null;
            }
            IGridContentProvider.CellInformation cellInfo = this.getCellInfo(colElement, rowElement, false);
            int hintOptions = options;
            if ((0x20 & cellInfo.state) != 0) {
                hintOptions |= 0x10;
            }
            ArrayList<SpreadsheetHint> gridHints = null;
            for (DBDCellHintProvider hintProvider : SpreadsheetPresentation.this.controller.getModel().getHintContext().getCellHintProviders(attr)) {
                DBDValueHint[] valueHints = hintProvider.getCellHints((DBDResultSetModel)SpreadsheetPresentation.this.controller.getModel(), attr, (DBDValueRow)row, cellValue, INLINE_HINT_TYPES, hintOptions);
                if (valueHints == null) continue;
                DBDValueHint[] dBDValueHintArray = valueHints;
                int n = valueHints.length;
                int n2 = 0;
                while (n2 < n) {
                    DBDValueHint hint = dBDValueHintArray[n2];
                    if (gridHints == null) {
                        gridHints = new ArrayList<SpreadsheetHint>();
                    }
                    gridHints.add(new SpreadsheetHint(SpreadsheetPresentation.this.getController(), hint));
                    ++n2;
                }
            }
            return gridHints;
        }

        @Override
        public List<IGridHint> getColumnHints(IGridItem element, int options) {
            DBDAttributeBinding attr;
            if (element instanceof IGridColumn) {
                IGridColumn gc = (IGridColumn)element;
                v0 = SpreadsheetPresentation.this.getAttributeFromGrid(gc, null);
            } else {
                v0 = attr = null;
            }
            if (attr == null) {
                return null;
            }
            int hintOptions = 1;
            ArrayList<SpreadsheetHint> gridHints = null;
            for (DBDAttributeHintProvider hintProvider : SpreadsheetPresentation.this.controller.getModel().getHintContext().getColumnHintProviders(attr)) {
                DBDValueHint[] valueHints = hintProvider.getAttributeHints((DBDResultSetModel)SpreadsheetPresentation.this.controller.getModel(), attr, INLINE_HINT_TYPES, hintOptions);
                if (valueHints == null) continue;
                DBDValueHint[] dBDValueHintArray = valueHints;
                int n = valueHints.length;
                int n2 = 0;
                while (n2 < n) {
                    DBDValueHint hint = dBDValueHintArray[n2];
                    if (gridHints == null) {
                        gridHints = new ArrayList<SpreadsheetHint>();
                    }
                    gridHints.add(new SpreadsheetHint(SpreadsheetPresentation.this.getController(), hint));
                    ++n2;
                }
            }
            return gridHints;
        }

        @Override
        public int getColumnHintsWidth(IGridColumn colElement) {
            DBDAttributeBinding ab;
            DBDAttributeBinding attr;
            Object object = colElement.getElement();
            DBDAttributeBinding dBDAttributeBinding = attr = object instanceof DBDAttributeBinding ? (ab = (DBDAttributeBinding)object) : null;
            if (attr == null) {
                return 0;
            }
            int hintSize = 0;
            for (DBDCellHintProvider hintProvider : SpreadsheetPresentation.this.controller.getModel().getHintContext().getCellHintProviders(attr)) {
                hintSize += hintProvider.getAttributeHintSize((DBDValueHintContext)SpreadsheetPresentation.this.controller.getModel().getHintContext(), attr);
            }
            return hintSize;
        }

        @Override
        public void resetColors() {
            SpreadsheetPresentation.this.backgroundDefault = null;
            SpreadsheetPresentation.this.foregroundDefault = null;
        }
    }

    private class GridLabelProvider
    implements IGridLabelProvider {
        private GridLabelProvider() {
        }

        @Override
        @Nullable
        public Image getImage(IGridItem item) {
            if (!SpreadsheetPresentation.this.showAttributeIcons) {
                return null;
            }
            Object object = item.getElement();
            if (object instanceof DBDAttributeBinding) {
                DBDAttributeBinding attr = (DBDAttributeBinding)object;
                DBPImage image = DBValueFormatting.getObjectImage((DBPObject)attr.getAttribute());
                return DBeaverIcons.getImage((DBPImage)image);
            }
            Object object2 = item.getElement();
            if (object2 instanceof DBSAttributeBase) {
                DBSAttributeBase attrBase = (DBSAttributeBase)object2;
                return DBeaverIcons.getImage((DBPImage)DBValueFormatting.getObjectImage((DBPObject)attrBase));
            }
            return null;
        }

        private boolean isAttributeReadOnly(@NotNull DBDAttributeBinding attr) {
            return CommonUtils.isBitSet((long)SpreadsheetPresentation.this.controller.getDecorator().getDecoratorFeatures(), (long)8L) && SpreadsheetPresentation.this.controller.getAttributeReadOnlyStatus(attr, true, true) != null && !SpreadsheetPresentation.this.controller.isAllAttributesReadOnly();
        }

        @Override
        public Object getGridOption(String option) {
            if ("OPTION_EXCLUDE_COLUMN_NAME_FOR_WIDTH_CALC".equals(option)) {
                return SpreadsheetPresentation.this.calcColumnWidthByValue;
            }
            return null;
        }

        @Override
        public Font getMainFontItalic() {
            return ResultSetThemeSettings.instance.resultSetFontItalic;
        }

        @Override
        @Nullable
        public Color getForeground(IGridItem element) {
            if (element == null) {
                if (SpreadsheetPresentation.this.foregroundDefault == null) {
                    SpreadsheetPresentation.this.foregroundDefault = SpreadsheetPresentation.this.controller.getDefaultForeground();
                }
                return SpreadsheetPresentation.this.foregroundDefault;
            }
            return null;
        }

        @Override
        @Nullable
        public Color getBackground(IGridItem element) {
            if (SpreadsheetPresentation.this.backgroundDefault == null) {
                SpreadsheetPresentation.this.backgroundDefault = SpreadsheetPresentation.this.controller.getDefaultBackground();
            }
            if (element == null) {
                return SpreadsheetPresentation.this.backgroundDefault;
            }
            return null;
        }

        @Override
        @NotNull
        public Color getHeaderForeground(@Nullable IGridItem item, boolean selected) {
            return ResultSetThemeSettings.instance.cellHeaderForeground;
        }

        @Override
        @NotNull
        public Color getHeaderBackground(@Nullable IGridItem item, boolean selected) {
            return selected ? SpreadsheetPresentation.this.cellHeaderSelectionBackground : ResultSetThemeSettings.instance.cellHeaderBackground;
        }

        @Override
        @NotNull
        public Color getHeaderBorder(@Nullable IGridItem item) {
            return ResultSetThemeSettings.instance.cellHeaderBorder;
        }

        @Override
        public Color getHeaderReadOnlyColor() {
            return ResultSetThemeSettings.instance.backgroundReadOnly;
        }

        @Override
        @NotNull
        public String getText(@NotNull IGridItem item) {
            Object object;
            if (item instanceof IGridColumn && SpreadsheetPresentation.this.controller.isRecordMode()) {
                ResultSetRow rsr = (ResultSetRow)item.getElement();
                return ResultSetMessages.controls_resultset_viewer_status_row + " #" + (rsr.getVisualNumber() + 1);
            }
            if (item instanceof IGridRow) {
                IGridRow row = (IGridRow)item;
                if (!SpreadsheetPresentation.this.controller.isRecordMode()) {
                    return row.toString();
                }
            }
            if ((object = item.getElement()) instanceof DBDAttributeBinding) {
                DBDAttributeBinding binding = (DBDAttributeBinding)object;
                return this.getAttributeText(binding);
            }
            Object object2 = item.getElement();
            if (object2 instanceof DBSAttributeBase) {
                DBSAttributeBase attr = (DBSAttributeBase)object2;
                return attr.getName();
            }
            if (item instanceof IGridRow) {
                IGridRow row = (IGridRow)item;
                return String.valueOf(row.getRelativeIndex() + 1);
            }
            return String.valueOf(item.getElement());
        }

        @NotNull
        private String getAttributeText(DBDAttributeBinding binding) {
            Object label = CommonUtils.isEmpty((String)binding.getLabel()) ? binding.getName() : binding.getLabel();
            DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
            if (store.getBoolean("resultset.show.column.position")) {
                label = (String)label + " (" + (binding.getOrdinalPosition() + 1) + ")";
            }
            return label;
        }

        @Override
        @Nullable
        public String getDescription(IGridItem element) {
            if (!SpreadsheetPresentation.this.showAttributeDescription || element.getParent() != null) {
                return null;
            }
            Object object = element.getElement();
            if (object instanceof DBDAttributeBinding) {
                DBDAttributeBinding attributeBinding = (DBDAttributeBinding)object;
                return attributeBinding.getDescription();
            }
            return null;
        }

        @Override
        @Nullable
        public Font getFont(IGridItem element) {
            Object object = element.getElement();
            if (object instanceof DBDAttributeBinding) {
                DBDAttributeBinding attributeBinding = (DBDAttributeBinding)object;
                DBDAttributeConstraint constraint = SpreadsheetPresentation.this.controller.getModel().getDataFilter().getConstraint(attributeBinding);
                if (constraint != null && constraint.hasCondition()) {
                    return SpreadsheetPresentation.this.spreadsheet.getFont(UIElementFontStyle.BOLD);
                }
                if (attributeBinding.isTransformed()) {
                    return SpreadsheetPresentation.this.spreadsheet.getFont(UIElementFontStyle.ITALIC);
                }
            }
            return null;
        }

        @Override
        @Nullable
        public String getToolTipText(IGridItem element) {
            Object object = element.getElement();
            if (object instanceof DBDAttributeBinding) {
                DBDAttributeBinding attributeBinding = (DBDAttributeBinding)object;
                String name = attributeBinding.getName();
                String typeName = attributeBinding.getFullTypeName();
                String description = attributeBinding.getDescription();
                StringBuilder tip = new StringBuilder();
                tip.append(SpreadsheetMessages.tooltip_column).append(": ");
                tip.append(name).append(" ").append(typeName);
                if (attributeBinding.isRequired()) {
                    tip.append(" NOT NULL");
                }
                if (!CommonUtils.isEmpty((String)description)) {
                    tip.append("\n").append(SpreadsheetMessages.tooltip_description).append(": ").append(description);
                }
                ResultSetHintContext hintContext = SpreadsheetPresentation.this.controller.getModel().getHintContext();
                for (DBDAttributeHintProvider ahp : hintContext.getColumnHintProviders(attributeBinding)) {
                    DBDValueHint[] hints = ahp.getAttributeHints((DBDResultSetModel)SpreadsheetPresentation.this.controller.getModel(), attributeBinding, INLINE_HINT_TYPES, 4);
                    if (hints == null) continue;
                    DBDValueHint[] dBDValueHintArray = hints;
                    int n = hints.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DBDValueHint hint = dBDValueHintArray[n2];
                        tip.append("\n").append(hint.getHintText());
                        ++n2;
                    }
                }
                return tip.toString();
            }
            return null;
        }

        @Override
        public Color getErrorForeground() {
            return ResultSetThemeSettings.instance.foregroundError;
        }

        @Override
        public Color getHintForeground() {
            return NavigatorThemeSettings.instance.hintColor;
        }
    }

    class SpreadsheetSelectionImpl
    implements IResultSetSelection,
    IResultSetSelectionExt {
        SpreadsheetSelectionImpl() {
        }

        @Nullable
        public GridPos getFirstElement() {
            Collection<GridPos> ssSelection = SpreadsheetPresentation.this.spreadsheet.getSelection();
            if (ssSelection.isEmpty()) {
                return null;
            }
            return ssSelection.iterator().next();
        }

        @NotNull
        public Iterator<GridPos> iterator() {
            return SpreadsheetPresentation.this.spreadsheet.getSelection().iterator();
        }

        public int size() {
            return SpreadsheetPresentation.this.spreadsheet.getSelection().size();
        }

        public Object[] toArray() {
            return SpreadsheetPresentation.this.spreadsheet.getSelection().toArray();
        }

        public List<GridPos> toList() {
            return new ArrayList<GridPos>(SpreadsheetPresentation.this.spreadsheet.getSelection());
        }

        public boolean isEmpty() {
            return SpreadsheetPresentation.this.spreadsheet.getSelection().isEmpty();
        }

        @Override
        @NotNull
        public IResultSetController getController() {
            return SpreadsheetPresentation.this.getController();
        }

        @Override
        @NotNull
        public List<DBDAttributeBinding> getSelectedAttributes() {
            if (SpreadsheetPresentation.this.controller.isRecordMode()) {
                Object[] elements = SpreadsheetPresentation.this.spreadsheet.getContentProvider().getElements(false);
                ArrayList<DBDAttributeBinding> attrs = new ArrayList<DBDAttributeBinding>();
                ArrayList<Integer> rowSelection = new ArrayList<Integer>(SpreadsheetPresentation.this.spreadsheet.getRowSelection());
                Collections.sort(rowSelection);
                for (Integer row : rowSelection) {
                    if (row >= elements.length) continue;
                    attrs.add((DBDAttributeBinding)elements[row]);
                }
                return attrs;
            }
            ArrayList<DBDAttributeBinding> attrs = new ArrayList<DBDAttributeBinding>();
            for (IGridColumn row : SpreadsheetPresentation.this.spreadsheet.getColumnSelection()) {
                attrs.add((DBDAttributeBinding)row.getElement());
            }
            return attrs;
        }

        @Override
        @NotNull
        public List<ResultSetRow> getSelectedRows() {
            ArrayList<ResultSetRow> rows = new ArrayList<ResultSetRow>();
            if (SpreadsheetPresentation.this.controller.isRecordMode()) {
                for (IGridColumn col : SpreadsheetPresentation.this.spreadsheet.getColumnSelection()) {
                    if (!(col.getElement() instanceof ResultSetRow)) continue;
                    rows.add((ResultSetRow)col.getElement());
                }
            } else {
                for (Integer row : SpreadsheetPresentation.this.spreadsheet.getRowSelection()) {
                    IGridRow gridRow = SpreadsheetPresentation.this.spreadsheet.getRow(row);
                    ResultSetRow rsr = (ResultSetRow)gridRow.getElement();
                    if (rows.contains(rsr)) continue;
                    rows.add(rsr);
                }
            }
            rows.sort(Comparator.comparingInt(ResultSetRow::getVisualNumber));
            return rows;
        }

        @Override
        public DBDAttributeBinding getElementAttribute(Object element) {
            GridPos pos = (GridPos)element;
            return SpreadsheetPresentation.this.getAttributeFromGrid(SpreadsheetPresentation.this.spreadsheet.getColumn(pos.col), SpreadsheetPresentation.this.spreadsheet.getRow(pos.row));
        }

        @Override
        public ResultSetRow getElementRow(Object element) {
            GridPos pos = (GridPos)element;
            return SpreadsheetPresentation.this.getResultRowFromGrid(SpreadsheetPresentation.this.spreadsheet.getColumn(pos.col), SpreadsheetPresentation.this.spreadsheet.getRow(pos.row));
        }

        @Override
        public int[] getElementRowIndexes(Object element) {
            IGridRow row = SpreadsheetPresentation.this.spreadsheet.getRow(((GridPos)element).row);
            return SpreadsheetPresentation.this.getRowNestedIndexes(row);
        }

        @Override
        public int getSelectedColumnCount() {
            return SpreadsheetPresentation.this.spreadsheet.getColumnSelectionSize();
        }

        @Override
        public int getSelectedRowCount() {
            return SpreadsheetPresentation.this.spreadsheet.getRowSelectionSize();
        }

        @Override
        public int getSelectedCellCount() {
            return SpreadsheetPresentation.this.spreadsheet.getCellSelectionSize();
        }
    }

    public class SpreadsheetValueController
    extends ResultSetValueController
    implements IMultiController {
        SpreadsheetValueController(@NotNull IResultSetController controller, @NotNull ResultSetCellLocation cellLocation, @Nullable IValueController.EditType editType, Composite inlinePlaceholder) {
            super(controller, cellLocation, editType, inlinePlaceholder);
        }

        @Override
        public Object getValue() {
            return this.controller.getModel().getCellValue(this.cellLocation);
        }

        @Override
        public void closeInlineEditor() {
            SpreadsheetPresentation.this.spreadsheet.cancelInlineEditor();
        }

        @Override
        public void nextInlineEditor(boolean next) {
            SpreadsheetPresentation.this.spreadsheet.cancelInlineEditor();
            int colOffset = next ? 1 : -1;
            int rowOffset = 0;
            int colCount = SpreadsheetPresentation.this.spreadsheet.getColumnCount();
            GridPos curPosition = SpreadsheetPresentation.this.spreadsheet.getCursorPosition();
            if (colOffset > 0 && curPosition.col + colOffset >= colCount) {
                colOffset = -colCount;
                rowOffset = 1;
            } else if (colOffset < 0 && curPosition.col + colOffset < 0) {
                colOffset = colCount;
                rowOffset = -1;
            }
            SpreadsheetPresentation.this.spreadsheet.shiftCursor(colOffset, rowOffset, false);
            SpreadsheetPresentation.this.openValueEditor(true);
        }

        @Override
        public void updateValue(@Nullable Object value, boolean updatePresentation) {
            super.updateValue(value, updatePresentation);
            if (updatePresentation) {
                SpreadsheetPresentation.this.spreadsheet.redrawGrid();
            }
        }

        @Override
        public void updateSelectionValue(Object value) {
            DBDAttributeBinding origAttr = this.getBinding();
            ResultSetRow origRow = this.getCurRow();
            int[] origRowIndexes = this.cellLocation.getRowIndexes();
            try {
                Collection<GridPos> ssSelection = SpreadsheetPresentation.this.spreadsheet.getSelection();
                for (GridPos pos : ssSelection) {
                    GridColumn gridColumn = SpreadsheetPresentation.this.spreadsheet.getColumn(pos.col);
                    IGridRow gridRow = SpreadsheetPresentation.this.spreadsheet.getRow(pos.row);
                    DBDAttributeBinding attr = SpreadsheetPresentation.this.getAttributeFromGrid(gridColumn, gridRow);
                    ResultSetRow row = SpreadsheetPresentation.this.getResultRowFromGrid(gridColumn, gridRow);
                    if (attr == null || row == null) continue;
                    if (!ArrayUtils.isEmpty((int[])origRowIndexes)) {
                        attr = ResultSetCellLocation.getLeafAttribute(attr, origRowIndexes);
                    }
                    if (attr.getValueHandler() != origAttr.getValueHandler() || this.controller.getAttributeReadOnlyStatus(attr, true, false) != null) continue;
                    this.setBinding(attr);
                    this.setCurRow(row, SpreadsheetPresentation.this.spreadsheet.getPresentation().getCurrentRowIndexes());
                    this.updateValue(value, false);
                }
                SpreadsheetPresentation.this.spreadsheet.redrawGrid();
                this.controller.updatePanelsContent(false);
            }
            finally {
                this.setBinding(origAttr);
                this.setCurRow(origRow, origRowIndexes);
            }
        }

        void registerEditor(IValueEditorStandalone editor) {
            SpreadsheetPresentation.this.openEditors.put(this, editor);
        }

        void unregisterEditor(IValueEditorStandalone editor) {
            SpreadsheetPresentation.this.openEditors.remove(this);
        }
    }

    private static class ViewState {
        DBDAttributeBinding focusedAttribute;
        int hScrollSelection;

        ViewState(DBDAttributeBinding focusedAttribute, int hScrollSelection) {
            this.focusedAttribute = focusedAttribute;
            this.hScrollSelection = hScrollSelection;
        }
    }
}

