/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pixie.wmf.records;

import org.pentaho.reporting.libraries.pixie.wmf.MfDcState;
import org.pentaho.reporting.libraries.pixie.wmf.MfRecord;
import org.pentaho.reporting.libraries.pixie.wmf.WmfFile;
import org.pentaho.reporting.libraries.pixie.wmf.records.MfCmd;
import org.pentaho.reporting.libraries.pixie.wmf.records.RecordCreationException;

public class MfCmdSetTextAlign
extends MfCmd {
    private static final int RECORD_SIZE = 1;
    private static final int POS_TEXT_ALIGNMENT = 0;
    private int textAlignMode;

    public void replay(WmfFile file) {
        MfDcState state = file.getCurrentState();
        state.setTextAlign(this.textAlignMode);
    }

    public MfCmd getInstance() {
        return new MfCmdSetTextAlign();
    }

    public void setRecord(MfRecord record) {
        int id = record.getParam(0);
        this.setTextAlignMode(id);
    }

    public MfRecord getRecord() throws RecordCreationException {
        MfRecord record = new MfRecord(1);
        record.setParam(0, this.getTextAlignMode());
        return record;
    }

    public int getFunction() {
        return 302;
    }

    public int getTextAlignMode() {
        return this.textAlignMode;
    }

    public void setTextAlignMode(int id) {
        this.textAlignMode = id;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[SET_TEXT_ALIGN] textAlign=");
        b.append(this.getTextAlignMode());
        return b.toString();
    }

    protected void scaleXChanged() {
    }

    protected void scaleYChanged() {
    }
}

