/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMHTMLTableElement.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMHTMLCollectionPrivate.h"
#include "WebKitDOMHTMLElementPrivate.h"
#include "WebKitDOMHTMLTableCaptionElementPrivate.h"
#include "WebKitDOMHTMLTableElementPrivate.h"
#include "WebKitDOMHTMLTableSectionElementPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMHTMLTableElement* kit(WebCore::HTMLTableElement* obj)
{
    return WEBKIT_DOM_HTML_TABLE_ELEMENT(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::HTMLTableElement* core(WebKitDOMHTMLTableElement* request)
{
    return request ? static_cast<WebCore::HTMLTableElement*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMHTMLTableElement* wrapHTMLTableElement(WebCore::HTMLTableElement* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_HTML_TABLE_ELEMENT(g_object_new(WEBKIT_TYPE_DOM_HTML_TABLE_ELEMENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMHTMLTableElement, webkit_dom_html_table_element, WEBKIT_TYPE_DOM_HTML_ELEMENT)

enum {
    PROP_0,
    PROP_CAPTION,
    PROP_T_HEAD,
    PROP_T_FOOT,
    PROP_ROWS,
    PROP_T_BODIES,
    PROP_ALIGN,
    PROP_BG_COLOR,
    PROP_BORDER,
    PROP_CELL_PADDING,
    PROP_CELL_SPACING,
    PROP_FRAME,
    PROP_RULES,
    PROP_SUMMARY,
    PROP_WIDTH,
};

static void webkit_dom_html_table_element_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLTableElement* self = WEBKIT_DOM_HTML_TABLE_ELEMENT(object);
    WebCore::HTMLTableElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_ALIGN: {
        coreSelf->setAttribute(WebCore::HTMLNames::alignAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_BG_COLOR: {
        coreSelf->setAttribute(WebCore::HTMLNames::bgcolorAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_BORDER: {
        coreSelf->setAttribute(WebCore::HTMLNames::borderAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_CELL_PADDING: {
        coreSelf->setAttribute(WebCore::HTMLNames::cellpaddingAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_CELL_SPACING: {
        coreSelf->setAttribute(WebCore::HTMLNames::cellspacingAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_FRAME: {
        coreSelf->setAttribute(WebCore::HTMLNames::frameAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_RULES: {
        coreSelf->setAttribute(WebCore::HTMLNames::rulesAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_SUMMARY: {
        coreSelf->setAttribute(WebCore::HTMLNames::summaryAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_WIDTH: {
        coreSelf->setAttribute(WebCore::HTMLNames::widthAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_table_element_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLTableElement* self = WEBKIT_DOM_HTML_TABLE_ELEMENT(object);
    WebCore::HTMLTableElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_CAPTION: {
        RefPtr<WebCore::HTMLTableCaptionElement> ptr = coreSelf->caption();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_T_HEAD: {
        RefPtr<WebCore::HTMLTableSectionElement> ptr = coreSelf->tHead();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_T_FOOT: {
        RefPtr<WebCore::HTMLTableSectionElement> ptr = coreSelf->tFoot();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_ROWS: {
        RefPtr<WebCore::HTMLCollection> ptr = coreSelf->rows();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_T_BODIES: {
        RefPtr<WebCore::HTMLCollection> ptr = coreSelf->tBodies();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_ALIGN: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::alignAttr)));
        break;
    }
    case PROP_BG_COLOR: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::bgcolorAttr)));
        break;
    }
    case PROP_BORDER: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::borderAttr)));
        break;
    }
    case PROP_CELL_PADDING: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::cellpaddingAttr)));
        break;
    }
    case PROP_CELL_SPACING: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::cellspacingAttr)));
        break;
    }
    case PROP_FRAME: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::frameAttr)));
        break;
    }
    case PROP_RULES: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::rulesAttr)));
        break;
    }
    case PROP_SUMMARY: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::summaryAttr)));
        break;
    }
    case PROP_WIDTH: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::widthAttr)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_table_element_class_init(WebKitDOMHTMLTableElementClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_html_table_element_set_property;
    gobjectClass->get_property = webkit_dom_html_table_element_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_CAPTION,
                                    g_param_spec_object("caption", /* name */
                                                           "html_table_element_caption", /* short description */
                                                           "read-write  WebKitDOMHTMLTableCaptionElement* HTMLTableElement.caption", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_HTML_TABLE_CAPTION_ELEMENT, /* gobject type */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_T_HEAD,
                                    g_param_spec_object("t-head", /* name */
                                                           "html_table_element_t-head", /* short description */
                                                           "read-write  WebKitDOMHTMLTableSectionElement* HTMLTableElement.t-head", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_HTML_TABLE_SECTION_ELEMENT, /* gobject type */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_T_FOOT,
                                    g_param_spec_object("t-foot", /* name */
                                                           "html_table_element_t-foot", /* short description */
                                                           "read-write  WebKitDOMHTMLTableSectionElement* HTMLTableElement.t-foot", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_HTML_TABLE_SECTION_ELEMENT, /* gobject type */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_ROWS,
                                    g_param_spec_object("rows", /* name */
                                                           "html_table_element_rows", /* short description */
                                                           "read-only  WebKitDOMHTMLCollection* HTMLTableElement.rows", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_HTML_COLLECTION, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_T_BODIES,
                                    g_param_spec_object("t-bodies", /* name */
                                                           "html_table_element_t-bodies", /* short description */
                                                           "read-only  WebKitDOMHTMLCollection* HTMLTableElement.t-bodies", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_HTML_COLLECTION, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_ALIGN,
                                    g_param_spec_string("align", /* name */
                                                           "html_table_element_align", /* short description */
                                                           "read-write  gchar* HTMLTableElement.align", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_BG_COLOR,
                                    g_param_spec_string("bg-color", /* name */
                                                           "html_table_element_bg-color", /* short description */
                                                           "read-write  gchar* HTMLTableElement.bg-color", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_BORDER,
                                    g_param_spec_string("border", /* name */
                                                           "html_table_element_border", /* short description */
                                                           "read-write  gchar* HTMLTableElement.border", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CELL_PADDING,
                                    g_param_spec_string("cell-padding", /* name */
                                                           "html_table_element_cell-padding", /* short description */
                                                           "read-write  gchar* HTMLTableElement.cell-padding", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CELL_SPACING,
                                    g_param_spec_string("cell-spacing", /* name */
                                                           "html_table_element_cell-spacing", /* short description */
                                                           "read-write  gchar* HTMLTableElement.cell-spacing", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_FRAME,
                                    g_param_spec_string("frame", /* name */
                                                           "html_table_element_frame", /* short description */
                                                           "read-write  gchar* HTMLTableElement.frame", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_RULES,
                                    g_param_spec_string("rules", /* name */
                                                           "html_table_element_rules", /* short description */
                                                           "read-write  gchar* HTMLTableElement.rules", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SUMMARY,
                                    g_param_spec_string("summary", /* name */
                                                           "html_table_element_summary", /* short description */
                                                           "read-write  gchar* HTMLTableElement.summary", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WIDTH,
                                    g_param_spec_string("width", /* name */
                                                           "html_table_element_width", /* short description */
                                                           "read-write  gchar* HTMLTableElement.width", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
}

static void webkit_dom_html_table_element_init(WebKitDOMHTMLTableElement* request)
{
}

WebKitDOMHTMLElement*
webkit_dom_html_table_element_create_t_head(WebKitDOMHTMLTableElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TABLE_ELEMENT(self), 0);
    WebCore::HTMLTableElement* item = WebKit::core(self);
    RefPtr<WebCore::HTMLElement> gobjectResult = WTF::getPtr(item->createTHead());
    return WebKit::kit(gobjectResult.get());
}

void
webkit_dom_html_table_element_delete_t_head(WebKitDOMHTMLTableElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TABLE_ELEMENT(self));
    WebCore::HTMLTableElement* item = WebKit::core(self);
    item->deleteTHead();
}

WebKitDOMHTMLElement*
webkit_dom_html_table_element_create_t_foot(WebKitDOMHTMLTableElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TABLE_ELEMENT(self), 0);
    WebCore::HTMLTableElement* item = WebKit::core(self);
    RefPtr<WebCore::HTMLElement> gobjectResult = WTF::getPtr(item->createTFoot());
    return WebKit::kit(gobjectResult.get());
}

void
webkit_dom_html_table_element_delete_t_foot(WebKitDOMHTMLTableElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TABLE_ELEMENT(self));
    WebCore::HTMLTableElement* item = WebKit::core(self);
    item->deleteTFoot();
}

WebKitDOMHTMLElement*
webkit_dom_html_table_element_create_t_body(WebKitDOMHTMLTableElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TABLE_ELEMENT(self), 0);
    WebCore::HTMLTableElement* item = WebKit::core(self);
    RefPtr<WebCore::HTMLElement> gobjectResult = WTF::getPtr(item->createTBody());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMHTMLElement*
webkit_dom_html_table_element_create_caption(WebKitDOMHTMLTableElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TABLE_ELEMENT(self), 0);
    WebCore::HTMLTableElement* item = WebKit::core(self);
    RefPtr<WebCore::HTMLElement> gobjectResult = WTF::getPtr(item->createCaption());
    return WebKit::kit(gobjectResult.get());
}

void
webkit_dom_html_table_element_delete_caption(WebKitDOMHTMLTableElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TABLE_ELEMENT(self));
    WebCore::HTMLTableElement* item = WebKit::core(self);
    item->deleteCaption();
}

WebKitDOMHTMLElement*
webkit_dom_html_table_element_insert_row(WebKitDOMHTMLTableElement* self, glong index, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TABLE_ELEMENT(self), 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::HTMLTableElement* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    RefPtr<WebCore::HTMLElement> gobjectResult = WTF::getPtr(item->insertRow(index, ec));
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return WebKit::kit(gobjectResult.get());
}

void
webkit_dom_html_table_element_delete_row(WebKitDOMHTMLTableElement* self, glong index, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TABLE_ELEMENT(self));
    g_return_if_fail(!error || !*error);
    WebCore::HTMLTableElement* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    item->deleteRow(index, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

WebKitDOMHTMLTableCaptionElement*
webkit_dom_html_table_element_get_caption(WebKitDOMHTMLTableElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TABLE_ELEMENT(self), 0);
    WebCore::HTMLTableElement* item = WebKit::core(self);
    RefPtr<WebCore::HTMLTableCaptionElement> gobjectResult = WTF::getPtr(item->caption());
    return WebKit::kit(gobjectResult.get());
}

void
webkit_dom_html_table_element_set_caption(WebKitDOMHTMLTableElement* self, WebKitDOMHTMLTableCaptionElement* value, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TABLE_ELEMENT(self));
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TABLE_CAPTION_ELEMENT(value));
    g_return_if_fail(!error || !*error);
    WebCore::HTMLTableElement* item = WebKit::core(self);
    WebCore::HTMLTableCaptionElement* convertedValue = WebKit::core(value);
    WebCore::ExceptionCode ec = 0;
    item->setCaption(convertedValue, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

WebKitDOMHTMLTableSectionElement*
webkit_dom_html_table_element_get_t_head(WebKitDOMHTMLTableElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TABLE_ELEMENT(self), 0);
    WebCore::HTMLTableElement* item = WebKit::core(self);
    RefPtr<WebCore::HTMLTableSectionElement> gobjectResult = WTF::getPtr(item->tHead());
    return WebKit::kit(gobjectResult.get());
}

void
webkit_dom_html_table_element_set_t_head(WebKitDOMHTMLTableElement* self, WebKitDOMHTMLTableSectionElement* value, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TABLE_ELEMENT(self));
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TABLE_SECTION_ELEMENT(value));
    g_return_if_fail(!error || !*error);
    WebCore::HTMLTableElement* item = WebKit::core(self);
    WebCore::HTMLTableSectionElement* convertedValue = WebKit::core(value);
    WebCore::ExceptionCode ec = 0;
    item->setTHead(convertedValue, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

WebKitDOMHTMLTableSectionElement*
webkit_dom_html_table_element_get_t_foot(WebKitDOMHTMLTableElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TABLE_ELEMENT(self), 0);
    WebCore::HTMLTableElement* item = WebKit::core(self);
    RefPtr<WebCore::HTMLTableSectionElement> gobjectResult = WTF::getPtr(item->tFoot());
    return WebKit::kit(gobjectResult.get());
}

void
webkit_dom_html_table_element_set_t_foot(WebKitDOMHTMLTableElement* self, WebKitDOMHTMLTableSectionElement* value, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TABLE_ELEMENT(self));
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TABLE_SECTION_ELEMENT(value));
    g_return_if_fail(!error || !*error);
    WebCore::HTMLTableElement* item = WebKit::core(self);
    WebCore::HTMLTableSectionElement* convertedValue = WebKit::core(value);
    WebCore::ExceptionCode ec = 0;
    item->setTFoot(convertedValue, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

WebKitDOMHTMLCollection*
webkit_dom_html_table_element_get_rows(WebKitDOMHTMLTableElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TABLE_ELEMENT(self), 0);
    WebCore::HTMLTableElement* item = WebKit::core(self);
    RefPtr<WebCore::HTMLCollection> gobjectResult = WTF::getPtr(item->rows());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMHTMLCollection*
webkit_dom_html_table_element_get_t_bodies(WebKitDOMHTMLTableElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TABLE_ELEMENT(self), 0);
    WebCore::HTMLTableElement* item = WebKit::core(self);
    RefPtr<WebCore::HTMLCollection> gobjectResult = WTF::getPtr(item->tBodies());
    return WebKit::kit(gobjectResult.get());
}

gchar*
webkit_dom_html_table_element_get_align(WebKitDOMHTMLTableElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TABLE_ELEMENT(self), 0);
    WebCore::HTMLTableElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::alignAttr));
    return result;
}

void
webkit_dom_html_table_element_set_align(WebKitDOMHTMLTableElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TABLE_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLTableElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::alignAttr, convertedValue);
}

gchar*
webkit_dom_html_table_element_get_bg_color(WebKitDOMHTMLTableElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TABLE_ELEMENT(self), 0);
    WebCore::HTMLTableElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::bgcolorAttr));
    return result;
}

void
webkit_dom_html_table_element_set_bg_color(WebKitDOMHTMLTableElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TABLE_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLTableElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::bgcolorAttr, convertedValue);
}

gchar*
webkit_dom_html_table_element_get_border(WebKitDOMHTMLTableElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TABLE_ELEMENT(self), 0);
    WebCore::HTMLTableElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::borderAttr));
    return result;
}

void
webkit_dom_html_table_element_set_border(WebKitDOMHTMLTableElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TABLE_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLTableElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::borderAttr, convertedValue);
}

gchar*
webkit_dom_html_table_element_get_cell_padding(WebKitDOMHTMLTableElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TABLE_ELEMENT(self), 0);
    WebCore::HTMLTableElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::cellpaddingAttr));
    return result;
}

void
webkit_dom_html_table_element_set_cell_padding(WebKitDOMHTMLTableElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TABLE_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLTableElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::cellpaddingAttr, convertedValue);
}

gchar*
webkit_dom_html_table_element_get_cell_spacing(WebKitDOMHTMLTableElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TABLE_ELEMENT(self), 0);
    WebCore::HTMLTableElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::cellspacingAttr));
    return result;
}

void
webkit_dom_html_table_element_set_cell_spacing(WebKitDOMHTMLTableElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TABLE_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLTableElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::cellspacingAttr, convertedValue);
}

gchar*
webkit_dom_html_table_element_get_frame(WebKitDOMHTMLTableElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TABLE_ELEMENT(self), 0);
    WebCore::HTMLTableElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::frameAttr));
    return result;
}

void
webkit_dom_html_table_element_set_frame(WebKitDOMHTMLTableElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TABLE_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLTableElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::frameAttr, convertedValue);
}

gchar*
webkit_dom_html_table_element_get_rules(WebKitDOMHTMLTableElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TABLE_ELEMENT(self), 0);
    WebCore::HTMLTableElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::rulesAttr));
    return result;
}

void
webkit_dom_html_table_element_set_rules(WebKitDOMHTMLTableElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TABLE_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLTableElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::rulesAttr, convertedValue);
}

gchar*
webkit_dom_html_table_element_get_summary(WebKitDOMHTMLTableElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TABLE_ELEMENT(self), 0);
    WebCore::HTMLTableElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::summaryAttr));
    return result;
}

void
webkit_dom_html_table_element_set_summary(WebKitDOMHTMLTableElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TABLE_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLTableElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::summaryAttr, convertedValue);
}

gchar*
webkit_dom_html_table_element_get_width(WebKitDOMHTMLTableElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TABLE_ELEMENT(self), 0);
    WebCore::HTMLTableElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::widthAttr));
    return result;
}

void
webkit_dom_html_table_element_set_width(WebKitDOMHTMLTableElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TABLE_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLTableElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::widthAttr, convertedValue);
}

